// Copyright 2021 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the disco-to-proto3-converter. DO NOT EDIT!
// Source Discovery file: compute.v1.json
// Source file revision: 20210415
// API name: compute
// API version: v1

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v3.12.2
// source: google/cloud/compute/v1/compute.proto

package compute

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The deprecation state of this resource. This can be ACTIVE, DEPRECATED, OBSOLETE, or DELETED. Operations which communicate the end of life date for an image, can use ACTIVE. Operations which create a new resource using a DEPRECATED resource will return successfully, but with a warning indicating the deprecated resource and recommending its replacement. Operations which use OBSOLETE or DELETED resources will be rejected and result in an error.
type DeprecationStatus_State int32

const (
	// A value indicating that the enum field is not set.
	DeprecationStatus_UNDEFINED_STATE DeprecationStatus_State = 0
	DeprecationStatus_ACTIVE          DeprecationStatus_State = 314733318
	DeprecationStatus_DELETED         DeprecationStatus_State = 120962041
	DeprecationStatus_DEPRECATED      DeprecationStatus_State = 463360435
	DeprecationStatus_OBSOLETE        DeprecationStatus_State = 66532761
)

// Enum value maps for DeprecationStatus_State.
var (
	DeprecationStatus_State_name = map[int32]string{
		0:         "UNDEFINED_STATE",
		314733318: "ACTIVE",
		120962041: "DELETED",
		463360435: "DEPRECATED",
		66532761:  "OBSOLETE",
	}
	DeprecationStatus_State_value = map[string]int32{
		"UNDEFINED_STATE": 0,
		"ACTIVE":          314733318,
		"DELETED":         120962041,
		"DEPRECATED":      463360435,
		"OBSOLETE":        66532761,
	}
)

func (x DeprecationStatus_State) Enum() *DeprecationStatus_State {
	p := new(DeprecationStatus_State)
	*p = x
	return p
}

func (x DeprecationStatus_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DeprecationStatus_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[0].Descriptor()
}

func (DeprecationStatus_State) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[0]
}

func (x DeprecationStatus_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use DeprecationStatus_State.Descriptor instead.
func (DeprecationStatus_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{1, 0}
}

// [Output Only] A warning code, if applicable. For example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in the response.
type Warning_Code int32

const (
	// A value indicating that the enum field is not set.
	Warning_UNDEFINED_CODE                            Warning_Code = 0
	Warning_CLEANUP_FAILED                            Warning_Code = 150308440
	Warning_DEPRECATED_RESOURCE_USED                  Warning_Code = 391835586
	Warning_DEPRECATED_TYPE_USED                      Warning_Code = 346526230
	Warning_DISK_SIZE_LARGER_THAN_IMAGE_SIZE          Warning_Code = 369442967
	Warning_EXPERIMENTAL_TYPE_USED                    Warning_Code = 451954443
	Warning_EXTERNAL_API_WARNING                      Warning_Code = 175546307
	Warning_FIELD_VALUE_OVERRIDEN                     Warning_Code = 329669423
	Warning_INJECTED_KERNELS_DEPRECATED               Warning_Code = 417377419
	Warning_LARGE_DEPLOYMENT_WARNING                  Warning_Code = 481440678
	Warning_MISSING_TYPE_DEPENDENCY                   Warning_Code = 344505463
	Warning_NEXT_HOP_ADDRESS_NOT_ASSIGNED             Warning_Code = 324964999
	Warning_NEXT_HOP_CANNOT_IP_FORWARD                Warning_Code = 383382887
	Warning_NEXT_HOP_INSTANCE_NOT_FOUND               Warning_Code = 464250446
	Warning_NEXT_HOP_INSTANCE_NOT_ON_NETWORK          Warning_Code = 243758146
	Warning_NEXT_HOP_NOT_RUNNING                      Warning_Code = 417081265
	Warning_NOT_CRITICAL_ERROR                        Warning_Code = 105763924
	Warning_NO_RESULTS_ON_PAGE                        Warning_Code = 30036744
	Warning_PARTIAL_SUCCESS                           Warning_Code = 39966469
	Warning_REQUIRED_TOS_AGREEMENT                    Warning_Code = 3745539
	Warning_RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING Warning_Code = 496728641
	Warning_RESOURCE_NOT_DELETED                      Warning_Code = 168598460
	Warning_SCHEMA_VALIDATION_IGNORED                 Warning_Code = 275245642
	Warning_SINGLE_INSTANCE_PROPERTY_TEMPLATE         Warning_Code = 268305617
	Warning_UNDECLARED_PROPERTIES                     Warning_Code = 390513439
	Warning_UNREACHABLE                               Warning_Code = 13328052
)

// Enum value maps for Warning_Code.
var (
	Warning_Code_name = map[int32]string{
		0:         "UNDEFINED_CODE",
		150308440: "CLEANUP_FAILED",
		391835586: "DEPRECATED_RESOURCE_USED",
		346526230: "DEPRECATED_TYPE_USED",
		369442967: "DISK_SIZE_LARGER_THAN_IMAGE_SIZE",
		451954443: "EXPERIMENTAL_TYPE_USED",
		175546307: "EXTERNAL_API_WARNING",
		329669423: "FIELD_VALUE_OVERRIDEN",
		417377419: "INJECTED_KERNELS_DEPRECATED",
		481440678: "LARGE_DEPLOYMENT_WARNING",
		344505463: "MISSING_TYPE_DEPENDENCY",
		324964999: "NEXT_HOP_ADDRESS_NOT_ASSIGNED",
		383382887: "NEXT_HOP_CANNOT_IP_FORWARD",
		464250446: "NEXT_HOP_INSTANCE_NOT_FOUND",
		243758146: "NEXT_HOP_INSTANCE_NOT_ON_NETWORK",
		417081265: "NEXT_HOP_NOT_RUNNING",
		105763924: "NOT_CRITICAL_ERROR",
		30036744:  "NO_RESULTS_ON_PAGE",
		39966469:  "PARTIAL_SUCCESS",
		3745539:   "REQUIRED_TOS_AGREEMENT",
		496728641: "RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING",
		168598460: "RESOURCE_NOT_DELETED",
		275245642: "SCHEMA_VALIDATION_IGNORED",
		268305617: "SINGLE_INSTANCE_PROPERTY_TEMPLATE",
		390513439: "UNDECLARED_PROPERTIES",
		13328052:  "UNREACHABLE",
	}
	Warning_Code_value = map[string]int32{
		"UNDEFINED_CODE":                            0,
		"CLEANUP_FAILED":                            150308440,
		"DEPRECATED_RESOURCE_USED":                  391835586,
		"DEPRECATED_TYPE_USED":                      346526230,
		"DISK_SIZE_LARGER_THAN_IMAGE_SIZE":          369442967,
		"EXPERIMENTAL_TYPE_USED":                    451954443,
		"EXTERNAL_API_WARNING":                      175546307,
		"FIELD_VALUE_OVERRIDEN":                     329669423,
		"INJECTED_KERNELS_DEPRECATED":               417377419,
		"LARGE_DEPLOYMENT_WARNING":                  481440678,
		"MISSING_TYPE_DEPENDENCY":                   344505463,
		"NEXT_HOP_ADDRESS_NOT_ASSIGNED":             324964999,
		"NEXT_HOP_CANNOT_IP_FORWARD":                383382887,
		"NEXT_HOP_INSTANCE_NOT_FOUND":               464250446,
		"NEXT_HOP_INSTANCE_NOT_ON_NETWORK":          243758146,
		"NEXT_HOP_NOT_RUNNING":                      417081265,
		"NOT_CRITICAL_ERROR":                        105763924,
		"NO_RESULTS_ON_PAGE":                        30036744,
		"PARTIAL_SUCCESS":                           39966469,
		"REQUIRED_TOS_AGREEMENT":                    3745539,
		"RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING": 496728641,
		"RESOURCE_NOT_DELETED":                      168598460,
		"SCHEMA_VALIDATION_IGNORED":                 275245642,
		"SINGLE_INSTANCE_PROPERTY_TEMPLATE":         268305617,
		"UNDECLARED_PROPERTIES":                     390513439,
		"UNREACHABLE":                               13328052,
	}
)

func (x Warning_Code) Enum() *Warning_Code {
	p := new(Warning_Code)
	*p = x
	return p
}

func (x Warning_Code) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Warning_Code) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[1].Descriptor()
}

func (Warning_Code) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[1]
}

func (x Warning_Code) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Warning_Code.Descriptor instead.
func (Warning_Code) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{5, 0}
}

// This signifies the networking tier used for configuring this access configuration and can only take the following values: PREMIUM, STANDARD.
//
// If an AccessConfig is specified without a valid external IP address, an ephemeral IP will be created with this networkTier.
//
// If an AccessConfig with a valid external IP address is specified, it must match that of the networkTier associated with the Address resource owning that IP.
type AccessConfig_NetworkTier int32

const (
	// A value indicating that the enum field is not set.
	AccessConfig_UNDEFINED_NETWORK_TIER AccessConfig_NetworkTier = 0
	AccessConfig_PREMIUM                AccessConfig_NetworkTier = 399530551
	AccessConfig_STANDARD               AccessConfig_NetworkTier = 484642493
)

// Enum value maps for AccessConfig_NetworkTier.
var (
	AccessConfig_NetworkTier_name = map[int32]string{
		0:         "UNDEFINED_NETWORK_TIER",
		399530551: "PREMIUM",
		484642493: "STANDARD",
	}
	AccessConfig_NetworkTier_value = map[string]int32{
		"UNDEFINED_NETWORK_TIER": 0,
		"PREMIUM":                399530551,
		"STANDARD":               484642493,
	}
)

func (x AccessConfig_NetworkTier) Enum() *AccessConfig_NetworkTier {
	p := new(AccessConfig_NetworkTier)
	*p = x
	return p
}

func (x AccessConfig_NetworkTier) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AccessConfig_NetworkTier) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[2].Descriptor()
}

func (AccessConfig_NetworkTier) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[2]
}

func (x AccessConfig_NetworkTier) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AccessConfig_NetworkTier.Descriptor instead.
func (AccessConfig_NetworkTier) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{8, 0}
}

// The type of configuration. The default and only option is ONE_TO_ONE_NAT.
type AccessConfig_Type int32

const (
	// A value indicating that the enum field is not set.
	AccessConfig_UNDEFINED_TYPE AccessConfig_Type = 0
	AccessConfig_ONE_TO_ONE_NAT AccessConfig_Type = 84090205
)

// Enum value maps for AccessConfig_Type.
var (
	AccessConfig_Type_name = map[int32]string{
		0:        "UNDEFINED_TYPE",
		84090205: "ONE_TO_ONE_NAT",
	}
	AccessConfig_Type_value = map[string]int32{
		"UNDEFINED_TYPE": 0,
		"ONE_TO_ONE_NAT": 84090205,
	}
)

func (x AccessConfig_Type) Enum() *AccessConfig_Type {
	p := new(AccessConfig_Type)
	*p = x
	return p
}

func (x AccessConfig_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AccessConfig_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[3].Descriptor()
}

func (AccessConfig_Type) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[3]
}

func (x AccessConfig_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AccessConfig_Type.Descriptor instead.
func (AccessConfig_Type) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{8, 1}
}

// The type of address to reserve, either INTERNAL or EXTERNAL. If unspecified, defaults to EXTERNAL.
type Address_AddressType int32

const (
	// A value indicating that the enum field is not set.
	Address_UNDEFINED_ADDRESS_TYPE Address_AddressType = 0
	Address_EXTERNAL               Address_AddressType = 35607499
	Address_INTERNAL               Address_AddressType = 279295677
	Address_UNSPECIFIED_TYPE       Address_AddressType = 53933922
)

// Enum value maps for Address_AddressType.
var (
	Address_AddressType_name = map[int32]string{
		0:         "UNDEFINED_ADDRESS_TYPE",
		35607499:  "EXTERNAL",
		279295677: "INTERNAL",
		53933922:  "UNSPECIFIED_TYPE",
	}
	Address_AddressType_value = map[string]int32{
		"UNDEFINED_ADDRESS_TYPE": 0,
		"EXTERNAL":               35607499,
		"INTERNAL":               279295677,
		"UNSPECIFIED_TYPE":       53933922,
	}
)

func (x Address_AddressType) Enum() *Address_AddressType {
	p := new(Address_AddressType)
	*p = x
	return p
}

func (x Address_AddressType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Address_AddressType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[4].Descriptor()
}

func (Address_AddressType) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[4]
}

func (x Address_AddressType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Address_AddressType.Descriptor instead.
func (Address_AddressType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{9, 0}
}

// The IP version that will be used by this address. Valid options are IPV4 or IPV6. This can only be specified for a global address.
type Address_IpVersion int32

const (
	// A value indicating that the enum field is not set.
	Address_UNDEFINED_IP_VERSION Address_IpVersion = 0
	Address_IPV4                 Address_IpVersion = 2254341
	Address_IPV6                 Address_IpVersion = 2254343
	Address_UNSPECIFIED_VERSION  Address_IpVersion = 21850000
)

// Enum value maps for Address_IpVersion.
var (
	Address_IpVersion_name = map[int32]string{
		0:        "UNDEFINED_IP_VERSION",
		2254341:  "IPV4",
		2254343:  "IPV6",
		21850000: "UNSPECIFIED_VERSION",
	}
	Address_IpVersion_value = map[string]int32{
		"UNDEFINED_IP_VERSION": 0,
		"IPV4":                 2254341,
		"IPV6":                 2254343,
		"UNSPECIFIED_VERSION":  21850000,
	}
)

func (x Address_IpVersion) Enum() *Address_IpVersion {
	p := new(Address_IpVersion)
	*p = x
	return p
}

func (x Address_IpVersion) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Address_IpVersion) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[5].Descriptor()
}

func (Address_IpVersion) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[5]
}

func (x Address_IpVersion) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Address_IpVersion.Descriptor instead.
func (Address_IpVersion) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{9, 1}
}

// This signifies the networking tier used for configuring this address and can only take the following values: PREMIUM or STANDARD. Global forwarding rules can only be Premium Tier. Regional forwarding rules can be either Premium or Standard Tier. Standard Tier addresses applied to regional forwarding rules can be used with any external load balancer. Regional forwarding rules in Premium Tier can only be used with a network load balancer.
//
// If this field is not specified, it is assumed to be PREMIUM.
type Address_NetworkTier int32

const (
	// A value indicating that the enum field is not set.
	Address_UNDEFINED_NETWORK_TIER Address_NetworkTier = 0
	Address_PREMIUM                Address_NetworkTier = 399530551
	Address_STANDARD               Address_NetworkTier = 484642493
)

// Enum value maps for Address_NetworkTier.
var (
	Address_NetworkTier_name = map[int32]string{
		0:         "UNDEFINED_NETWORK_TIER",
		399530551: "PREMIUM",
		484642493: "STANDARD",
	}
	Address_NetworkTier_value = map[string]int32{
		"UNDEFINED_NETWORK_TIER": 0,
		"PREMIUM":                399530551,
		"STANDARD":               484642493,
	}
)

func (x Address_NetworkTier) Enum() *Address_NetworkTier {
	p := new(Address_NetworkTier)
	*p = x
	return p
}

func (x Address_NetworkTier) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Address_NetworkTier) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[6].Descriptor()
}

func (Address_NetworkTier) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[6]
}

func (x Address_NetworkTier) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Address_NetworkTier.Descriptor instead.
func (Address_NetworkTier) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{9, 2}
}

// The purpose of this resource, which can be one of the following values:
// - `GCE_ENDPOINT` for addresses that are used by VM instances, alias IP ranges, internal load balancers, and similar resources.
// - `DNS_RESOLVER` for a DNS resolver address in a subnetwork
// - `VPC_PEERING` for addresses that are reserved for VPC peer networks.
// - `NAT_AUTO` for addresses that are external IP addresses automatically reserved for Cloud NAT.
// - `IPSEC_INTERCONNECT` for addresses created from a private IP range that are reserved for a VLAN attachment in an IPsec-encrypted Cloud Interconnect configuration. These addresses are regional resources.
type Address_Purpose int32

const (
	// A value indicating that the enum field is not set.
	Address_UNDEFINED_PURPOSE       Address_Purpose = 0
	Address_DNS_RESOLVER            Address_Purpose = 476114556
	Address_GCE_ENDPOINT            Address_Purpose = 230515243
	Address_IPSEC_INTERCONNECT      Address_Purpose = 340437251
	Address_NAT_AUTO                Address_Purpose = 163666477
	Address_PRIVATE_SERVICE_CONNECT Address_Purpose = 48134724
	Address_SHARED_LOADBALANCER_VIP Address_Purpose = 294447572
	Address_VPC_PEERING             Address_Purpose = 400800170
)

// Enum value maps for Address_Purpose.
var (
	Address_Purpose_name = map[int32]string{
		0:         "UNDEFINED_PURPOSE",
		476114556: "DNS_RESOLVER",
		230515243: "GCE_ENDPOINT",
		340437251: "IPSEC_INTERCONNECT",
		163666477: "NAT_AUTO",
		48134724:  "PRIVATE_SERVICE_CONNECT",
		294447572: "SHARED_LOADBALANCER_VIP",
		400800170: "VPC_PEERING",
	}
	Address_Purpose_value = map[string]int32{
		"UNDEFINED_PURPOSE":       0,
		"DNS_RESOLVER":            476114556,
		"GCE_ENDPOINT":            230515243,
		"IPSEC_INTERCONNECT":      340437251,
		"NAT_AUTO":                163666477,
		"PRIVATE_SERVICE_CONNECT": 48134724,
		"SHARED_LOADBALANCER_VIP": 294447572,
		"VPC_PEERING":             400800170,
	}
)

func (x Address_Purpose) Enum() *Address_Purpose {
	p := new(Address_Purpose)
	*p = x
	return p
}

func (x Address_Purpose) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Address_Purpose) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[7].Descriptor()
}

func (Address_Purpose) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[7]
}

func (x Address_Purpose) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Address_Purpose.Descriptor instead.
func (Address_Purpose) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{9, 3}
}

// [Output Only] The status of the address, which can be one of RESERVING, RESERVED, or IN_USE. An address that is RESERVING is currently in the process of being reserved. A RESERVED address is currently reserved and available to use. An IN_USE address is currently being used by another resource and is not available.
type Address_Status int32

const (
	// A value indicating that the enum field is not set.
	Address_UNDEFINED_STATUS Address_Status = 0
	Address_IN_USE           Address_Status = 17393485
	Address_RESERVED         Address_Status = 432241448
	Address_RESERVING        Address_Status = 514587225
)

// Enum value maps for Address_Status.
var (
	Address_Status_name = map[int32]string{
		0:         "UNDEFINED_STATUS",
		17393485:  "IN_USE",
		432241448: "RESERVED",
		514587225: "RESERVING",
	}
	Address_Status_value = map[string]int32{
		"UNDEFINED_STATUS": 0,
		"IN_USE":           17393485,
		"RESERVED":         432241448,
		"RESERVING":        514587225,
	}
)

func (x Address_Status) Enum() *Address_Status {
	p := new(Address_Status)
	*p = x
	return p
}

func (x Address_Status) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Address_Status) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[8].Descriptor()
}

func (Address_Status) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[8]
}

func (x Address_Status) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Address_Status.Descriptor instead.
func (Address_Status) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{9, 4}
}

// Specifies the disk interface to use for attaching this disk, which is either SCSI or NVME. The default is SCSI. For performance characteristics of SCSI over NVMe, see Local SSD performance.
type AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk_Interface int32

const (
	// A value indicating that the enum field is not set.
	AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk_UNDEFINED_INTERFACE AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk_Interface = 0
	AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk_NVME                AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk_Interface = 2408800
	AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk_SCSI                AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk_Interface = 2539686
)

// Enum value maps for AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk_Interface.
var (
	AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk_Interface_name = map[int32]string{
		0:       "UNDEFINED_INTERFACE",
		2408800: "NVME",
		2539686: "SCSI",
	}
	AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk_Interface_value = map[string]int32{
		"UNDEFINED_INTERFACE": 0,
		"NVME":                2408800,
		"SCSI":                2539686,
	}
)

func (x AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk_Interface) Enum() *AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk_Interface {
	p := new(AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk_Interface)
	*p = x
	return p
}

func (x AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk_Interface) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk_Interface) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[9].Descriptor()
}

func (AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk_Interface) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[9]
}

func (x AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk_Interface) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk_Interface.Descriptor instead.
func (AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk_Interface) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{15, 0}
}

// The ID of a supported feature. Read  Enabling guest operating system features to see a list of available options.
type GuestOsFeature_Type int32

const (
	// A value indicating that the enum field is not set.
	GuestOsFeature_UNDEFINED_TYPE           GuestOsFeature_Type = 0
	GuestOsFeature_FEATURE_TYPE_UNSPECIFIED GuestOsFeature_Type = 531767259
	GuestOsFeature_GVNIC                    GuestOsFeature_Type = 68209305
	GuestOsFeature_MULTI_IP_SUBNET          GuestOsFeature_Type = 151776719
	GuestOsFeature_SECURE_BOOT              GuestOsFeature_Type = 376811194
	GuestOsFeature_SEV_CAPABLE              GuestOsFeature_Type = 87083793
	GuestOsFeature_UEFI_COMPATIBLE          GuestOsFeature_Type = 195865408
	GuestOsFeature_VIRTIO_SCSI_MULTIQUEUE   GuestOsFeature_Type = 201597069
	GuestOsFeature_WINDOWS                  GuestOsFeature_Type = 456863331
)

// Enum value maps for GuestOsFeature_Type.
var (
	GuestOsFeature_Type_name = map[int32]string{
		0:         "UNDEFINED_TYPE",
		531767259: "FEATURE_TYPE_UNSPECIFIED",
		68209305:  "GVNIC",
		151776719: "MULTI_IP_SUBNET",
		376811194: "SECURE_BOOT",
		87083793:  "SEV_CAPABLE",
		195865408: "UEFI_COMPATIBLE",
		201597069: "VIRTIO_SCSI_MULTIQUEUE",
		456863331: "WINDOWS",
	}
	GuestOsFeature_Type_value = map[string]int32{
		"UNDEFINED_TYPE":           0,
		"FEATURE_TYPE_UNSPECIFIED": 531767259,
		"GVNIC":                    68209305,
		"MULTI_IP_SUBNET":          151776719,
		"SECURE_BOOT":              376811194,
		"SEV_CAPABLE":              87083793,
		"UEFI_COMPATIBLE":          195865408,
		"VIRTIO_SCSI_MULTIQUEUE":   201597069,
		"WINDOWS":                  456863331,
	}
)

func (x GuestOsFeature_Type) Enum() *GuestOsFeature_Type {
	p := new(GuestOsFeature_Type)
	*p = x
	return p
}

func (x GuestOsFeature_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (GuestOsFeature_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[10].Descriptor()
}

func (GuestOsFeature_Type) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[10]
}

func (x GuestOsFeature_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use GuestOsFeature_Type.Descriptor instead.
func (GuestOsFeature_Type) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{19, 0}
}

// Specifies which action to take on instance update with this disk. Default is to use the existing disk.
type AttachedDiskInitializeParams_OnUpdateAction int32

const (
	// A value indicating that the enum field is not set.
	AttachedDiskInitializeParams_UNDEFINED_ON_UPDATE_ACTION      AttachedDiskInitializeParams_OnUpdateAction = 0
	AttachedDiskInitializeParams_RECREATE_DISK                   AttachedDiskInitializeParams_OnUpdateAction = 494767853
	AttachedDiskInitializeParams_RECREATE_DISK_IF_SOURCE_CHANGED AttachedDiskInitializeParams_OnUpdateAction = 398099712
	AttachedDiskInitializeParams_USE_EXISTING_DISK               AttachedDiskInitializeParams_OnUpdateAction = 232682233
)

// Enum value maps for AttachedDiskInitializeParams_OnUpdateAction.
var (
	AttachedDiskInitializeParams_OnUpdateAction_name = map[int32]string{
		0:         "UNDEFINED_ON_UPDATE_ACTION",
		494767853: "RECREATE_DISK",
		398099712: "RECREATE_DISK_IF_SOURCE_CHANGED",
		232682233: "USE_EXISTING_DISK",
	}
	AttachedDiskInitializeParams_OnUpdateAction_value = map[string]int32{
		"UNDEFINED_ON_UPDATE_ACTION":      0,
		"RECREATE_DISK":                   494767853,
		"RECREATE_DISK_IF_SOURCE_CHANGED": 398099712,
		"USE_EXISTING_DISK":               232682233,
	}
)

func (x AttachedDiskInitializeParams_OnUpdateAction) Enum() *AttachedDiskInitializeParams_OnUpdateAction {
	p := new(AttachedDiskInitializeParams_OnUpdateAction)
	*p = x
	return p
}

func (x AttachedDiskInitializeParams_OnUpdateAction) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AttachedDiskInitializeParams_OnUpdateAction) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[11].Descriptor()
}

func (AttachedDiskInitializeParams_OnUpdateAction) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[11]
}

func (x AttachedDiskInitializeParams_OnUpdateAction) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AttachedDiskInitializeParams_OnUpdateAction.Descriptor instead.
func (AttachedDiskInitializeParams_OnUpdateAction) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{20, 0}
}

// Specifies the disk interface to use for attaching this disk, which is either SCSI or NVME. The default is SCSI. Persistent disks must always use SCSI and the request will fail if you attempt to attach a persistent disk in any other format than SCSI. Local SSDs can use either NVME or SCSI. For performance characteristics of SCSI over NVMe, see Local SSD performance.
type AttachedDisk_Interface int32

const (
	// A value indicating that the enum field is not set.
	AttachedDisk_UNDEFINED_INTERFACE AttachedDisk_Interface = 0
	AttachedDisk_NVME                AttachedDisk_Interface = 2408800
	AttachedDisk_SCSI                AttachedDisk_Interface = 2539686
)

// Enum value maps for AttachedDisk_Interface.
var (
	AttachedDisk_Interface_name = map[int32]string{
		0:       "UNDEFINED_INTERFACE",
		2408800: "NVME",
		2539686: "SCSI",
	}
	AttachedDisk_Interface_value = map[string]int32{
		"UNDEFINED_INTERFACE": 0,
		"NVME":                2408800,
		"SCSI":                2539686,
	}
)

func (x AttachedDisk_Interface) Enum() *AttachedDisk_Interface {
	p := new(AttachedDisk_Interface)
	*p = x
	return p
}

func (x AttachedDisk_Interface) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AttachedDisk_Interface) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[12].Descriptor()
}

func (AttachedDisk_Interface) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[12]
}

func (x AttachedDisk_Interface) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AttachedDisk_Interface.Descriptor instead.
func (AttachedDisk_Interface) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{22, 0}
}

// The mode in which to attach this disk, either READ_WRITE or READ_ONLY. If not specified, the default is to attach the disk in READ_WRITE mode.
type AttachedDisk_Mode int32

const (
	// A value indicating that the enum field is not set.
	AttachedDisk_UNDEFINED_MODE AttachedDisk_Mode = 0
	AttachedDisk_READ_ONLY      AttachedDisk_Mode = 91950261
	AttachedDisk_READ_WRITE     AttachedDisk_Mode = 173607894
)

// Enum value maps for AttachedDisk_Mode.
var (
	AttachedDisk_Mode_name = map[int32]string{
		0:         "UNDEFINED_MODE",
		91950261:  "READ_ONLY",
		173607894: "READ_WRITE",
	}
	AttachedDisk_Mode_value = map[string]int32{
		"UNDEFINED_MODE": 0,
		"READ_ONLY":      91950261,
		"READ_WRITE":     173607894,
	}
)

func (x AttachedDisk_Mode) Enum() *AttachedDisk_Mode {
	p := new(AttachedDisk_Mode)
	*p = x
	return p
}

func (x AttachedDisk_Mode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AttachedDisk_Mode) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[13].Descriptor()
}

func (AttachedDisk_Mode) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[13]
}

func (x AttachedDisk_Mode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AttachedDisk_Mode.Descriptor instead.
func (AttachedDisk_Mode) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{22, 1}
}

// Specifies the type of the disk, either SCRATCH or PERSISTENT. If not specified, the default is PERSISTENT.
type AttachedDisk_Type int32

const (
	// A value indicating that the enum field is not set.
	AttachedDisk_UNDEFINED_TYPE AttachedDisk_Type = 0
	AttachedDisk_PERSISTENT     AttachedDisk_Type = 460683927
	AttachedDisk_SCRATCH        AttachedDisk_Type = 496778970
)

// Enum value maps for AttachedDisk_Type.
var (
	AttachedDisk_Type_name = map[int32]string{
		0:         "UNDEFINED_TYPE",
		460683927: "PERSISTENT",
		496778970: "SCRATCH",
	}
	AttachedDisk_Type_value = map[string]int32{
		"UNDEFINED_TYPE": 0,
		"PERSISTENT":     460683927,
		"SCRATCH":        496778970,
	}
)

func (x AttachedDisk_Type) Enum() *AttachedDisk_Type {
	p := new(AttachedDisk_Type)
	*p = x
	return p
}

func (x AttachedDisk_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AttachedDisk_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[14].Descriptor()
}

func (AttachedDisk_Type) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[14]
}

func (x AttachedDisk_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AttachedDisk_Type.Descriptor instead.
func (AttachedDisk_Type) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{22, 2}
}

// The log type that this config enables.
type AuditLogConfig_LogType int32

const (
	// A value indicating that the enum field is not set.
	AuditLogConfig_UNDEFINED_LOG_TYPE   AuditLogConfig_LogType = 0
	AuditLogConfig_ADMIN_READ           AuditLogConfig_LogType = 128951462
	AuditLogConfig_DATA_READ            AuditLogConfig_LogType = 305224971
	AuditLogConfig_DATA_WRITE           AuditLogConfig_LogType = 340181738
	AuditLogConfig_LOG_TYPE_UNSPECIFIED AuditLogConfig_LogType = 154527053
)

// Enum value maps for AuditLogConfig_LogType.
var (
	AuditLogConfig_LogType_name = map[int32]string{
		0:         "UNDEFINED_LOG_TYPE",
		128951462: "ADMIN_READ",
		305224971: "DATA_READ",
		340181738: "DATA_WRITE",
		154527053: "LOG_TYPE_UNSPECIFIED",
	}
	AuditLogConfig_LogType_value = map[string]int32{
		"UNDEFINED_LOG_TYPE":   0,
		"ADMIN_READ":           128951462,
		"DATA_READ":            305224971,
		"DATA_WRITE":           340181738,
		"LOG_TYPE_UNSPECIFIED": 154527053,
	}
)

func (x AuditLogConfig_LogType) Enum() *AuditLogConfig_LogType {
	p := new(AuditLogConfig_LogType)
	*p = x
	return p
}

func (x AuditLogConfig_LogType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AuditLogConfig_LogType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[15].Descriptor()
}

func (AuditLogConfig_LogType) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[15]
}

func (x AuditLogConfig_LogType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AuditLogConfig_LogType.Descriptor instead.
func (AuditLogConfig_LogType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{23, 0}
}

// The type of the permission that was checked.
type AuthorizationLoggingOptions_PermissionType int32

const (
	// A value indicating that the enum field is not set.
	AuthorizationLoggingOptions_UNDEFINED_PERMISSION_TYPE   AuthorizationLoggingOptions_PermissionType = 0
	AuthorizationLoggingOptions_ADMIN_READ                  AuthorizationLoggingOptions_PermissionType = 128951462
	AuthorizationLoggingOptions_ADMIN_WRITE                 AuthorizationLoggingOptions_PermissionType = 244412079
	AuthorizationLoggingOptions_DATA_READ                   AuthorizationLoggingOptions_PermissionType = 305224971
	AuthorizationLoggingOptions_DATA_WRITE                  AuthorizationLoggingOptions_PermissionType = 340181738
	AuthorizationLoggingOptions_PERMISSION_TYPE_UNSPECIFIED AuthorizationLoggingOptions_PermissionType = 440313346
)

// Enum value maps for AuthorizationLoggingOptions_PermissionType.
var (
	AuthorizationLoggingOptions_PermissionType_name = map[int32]string{
		0:         "UNDEFINED_PERMISSION_TYPE",
		128951462: "ADMIN_READ",
		244412079: "ADMIN_WRITE",
		305224971: "DATA_READ",
		340181738: "DATA_WRITE",
		440313346: "PERMISSION_TYPE_UNSPECIFIED",
	}
	AuthorizationLoggingOptions_PermissionType_value = map[string]int32{
		"UNDEFINED_PERMISSION_TYPE":   0,
		"ADMIN_READ":                  128951462,
		"ADMIN_WRITE":                 244412079,
		"DATA_READ":                   305224971,
		"DATA_WRITE":                  340181738,
		"PERMISSION_TYPE_UNSPECIFIED": 440313346,
	}
)

func (x AuthorizationLoggingOptions_PermissionType) Enum() *AuthorizationLoggingOptions_PermissionType {
	p := new(AuthorizationLoggingOptions_PermissionType)
	*p = x
	return p
}

func (x AuthorizationLoggingOptions_PermissionType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AuthorizationLoggingOptions_PermissionType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[16].Descriptor()
}

func (AuthorizationLoggingOptions_PermissionType) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[16]
}

func (x AuthorizationLoggingOptions_PermissionType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AuthorizationLoggingOptions_PermissionType.Descriptor instead.
func (AuthorizationLoggingOptions_PermissionType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{25, 0}
}

// Defines operating mode for this policy.
type AutoscalingPolicy_Mode int32

const (
	// A value indicating that the enum field is not set.
	AutoscalingPolicy_UNDEFINED_MODE AutoscalingPolicy_Mode = 0
	AutoscalingPolicy_OFF            AutoscalingPolicy_Mode = 78159
	AutoscalingPolicy_ON             AutoscalingPolicy_Mode = 2527
	AutoscalingPolicy_ONLY_SCALE_OUT AutoscalingPolicy_Mode = 152713670
	AutoscalingPolicy_ONLY_UP        AutoscalingPolicy_Mode = 478095374
)

// Enum value maps for AutoscalingPolicy_Mode.
var (
	AutoscalingPolicy_Mode_name = map[int32]string{
		0:         "UNDEFINED_MODE",
		78159:     "OFF",
		2527:      "ON",
		152713670: "ONLY_SCALE_OUT",
		478095374: "ONLY_UP",
	}
	AutoscalingPolicy_Mode_value = map[string]int32{
		"UNDEFINED_MODE": 0,
		"OFF":            78159,
		"ON":             2527,
		"ONLY_SCALE_OUT": 152713670,
		"ONLY_UP":        478095374,
	}
)

func (x AutoscalingPolicy_Mode) Enum() *AutoscalingPolicy_Mode {
	p := new(AutoscalingPolicy_Mode)
	*p = x
	return p
}

func (x AutoscalingPolicy_Mode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AutoscalingPolicy_Mode) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[17].Descriptor()
}

func (AutoscalingPolicy_Mode) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[17]
}

func (x AutoscalingPolicy_Mode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AutoscalingPolicy_Mode.Descriptor instead.
func (AutoscalingPolicy_Mode) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{26, 0}
}

// [Output Only] The current state of a scaling schedule.
type ScalingScheduleStatus_State int32

const (
	// A value indicating that the enum field is not set.
	ScalingScheduleStatus_UNDEFINED_STATE ScalingScheduleStatus_State = 0
	ScalingScheduleStatus_ACTIVE          ScalingScheduleStatus_State = 314733318
	ScalingScheduleStatus_DISABLED        ScalingScheduleStatus_State = 516696700
	ScalingScheduleStatus_OBSOLETE        ScalingScheduleStatus_State = 66532761
	ScalingScheduleStatus_READY           ScalingScheduleStatus_State = 77848963
)

// Enum value maps for ScalingScheduleStatus_State.
var (
	ScalingScheduleStatus_State_name = map[int32]string{
		0:         "UNDEFINED_STATE",
		314733318: "ACTIVE",
		516696700: "DISABLED",
		66532761:  "OBSOLETE",
		77848963:  "READY",
	}
	ScalingScheduleStatus_State_value = map[string]int32{
		"UNDEFINED_STATE": 0,
		"ACTIVE":          314733318,
		"DISABLED":        516696700,
		"OBSOLETE":        66532761,
		"READY":           77848963,
	}
)

func (x ScalingScheduleStatus_State) Enum() *ScalingScheduleStatus_State {
	p := new(ScalingScheduleStatus_State)
	*p = x
	return p
}

func (x ScalingScheduleStatus_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ScalingScheduleStatus_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[18].Descriptor()
}

func (ScalingScheduleStatus_State) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[18]
}

func (x ScalingScheduleStatus_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ScalingScheduleStatus_State.Descriptor instead.
func (ScalingScheduleStatus_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{27, 0}
}

// The type of error, warning, or notice returned. Current set of possible values:
// - ALL_INSTANCES_UNHEALTHY (WARNING): All instances in the instance group are unhealthy (not in RUNNING state).
// - BACKEND_SERVICE_DOES_NOT_EXIST (ERROR): There is no backend service attached to the instance group.
// - CAPPED_AT_MAX_NUM_REPLICAS (WARNING): Autoscaler recommends a size greater than maxNumReplicas.
// - CUSTOM_METRIC_DATA_POINTS_TOO_SPARSE (WARNING): The custom metric samples are not exported often enough to be a credible base for autoscaling.
// - CUSTOM_METRIC_INVALID (ERROR): The custom metric that was specified does not exist or does not have the necessary labels.
// - MIN_EQUALS_MAX (WARNING): The minNumReplicas is equal to maxNumReplicas. This means the autoscaler cannot add or remove instances from the instance group.
// - MISSING_CUSTOM_METRIC_DATA_POINTS (WARNING): The autoscaler did not receive any data from the custom metric configured for autoscaling.
// - MISSING_LOAD_BALANCING_DATA_POINTS (WARNING): The autoscaler is configured to scale based on a load balancing signal but the instance group has not received any requests from the load balancer.
// - MODE_OFF (WARNING): Autoscaling is turned off. The number of instances in the group won't change automatically. The autoscaling configuration is preserved.
// - MODE_ONLY_UP (WARNING): Autoscaling is in the "Autoscale only out" mode. The autoscaler can add instances but not remove any.
// - MORE_THAN_ONE_BACKEND_SERVICE (ERROR): The instance group cannot be autoscaled because it has more than one backend service attached to it.
// - NOT_ENOUGH_QUOTA_AVAILABLE (ERROR): There is insufficient quota for the necessary resources, such as CPU or number of instances.
// - REGION_RESOURCE_STOCKOUT (ERROR): Shown only for regional autoscalers: there is a resource stockout in the chosen region.
// - SCALING_TARGET_DOES_NOT_EXIST (ERROR): The target to be scaled does not exist.
// - UNSUPPORTED_MAX_RATE_LOAD_BALANCING_CONFIGURATION (ERROR): Autoscaling does not work with an HTTP/S load balancer that has been configured for maxRate.
// - ZONE_RESOURCE_STOCKOUT (ERROR): For zonal autoscalers: there is a resource stockout in the chosen zone. For regional autoscalers: in at least one of the zones you're using there is a resource stockout.  New values might be added in the future. Some of the values might not be available in all API versions.
type AutoscalerStatusDetails_Type int32

const (
	// A value indicating that the enum field is not set.
	AutoscalerStatusDetails_UNDEFINED_TYPE                                    AutoscalerStatusDetails_Type = 0
	AutoscalerStatusDetails_ALL_INSTANCES_UNHEALTHY                           AutoscalerStatusDetails_Type = 404965477
	AutoscalerStatusDetails_BACKEND_SERVICE_DOES_NOT_EXIST                    AutoscalerStatusDetails_Type = 191417626
	AutoscalerStatusDetails_CAPPED_AT_MAX_NUM_REPLICAS                        AutoscalerStatusDetails_Type = 518617
	AutoscalerStatusDetails_CUSTOM_METRIC_DATA_POINTS_TOO_SPARSE              AutoscalerStatusDetails_Type = 328964659
	AutoscalerStatusDetails_CUSTOM_METRIC_INVALID                             AutoscalerStatusDetails_Type = 204430550
	AutoscalerStatusDetails_MIN_EQUALS_MAX                                    AutoscalerStatusDetails_Type = 2821361
	AutoscalerStatusDetails_MISSING_CUSTOM_METRIC_DATA_POINTS                 AutoscalerStatusDetails_Type = 94885086
	AutoscalerStatusDetails_MISSING_LOAD_BALANCING_DATA_POINTS                AutoscalerStatusDetails_Type = 509858898
	AutoscalerStatusDetails_MODE_OFF                                          AutoscalerStatusDetails_Type = 164169907
	AutoscalerStatusDetails_MODE_ONLY_SCALE_OUT                               AutoscalerStatusDetails_Type = 3840994
	AutoscalerStatusDetails_MODE_ONLY_UP                                      AutoscalerStatusDetails_Type = 100969842
	AutoscalerStatusDetails_MORE_THAN_ONE_BACKEND_SERVICE                     AutoscalerStatusDetails_Type = 151922141
	AutoscalerStatusDetails_NOT_ENOUGH_QUOTA_AVAILABLE                        AutoscalerStatusDetails_Type = 403101631
	AutoscalerStatusDetails_REGION_RESOURCE_STOCKOUT                          AutoscalerStatusDetails_Type = 528622846
	AutoscalerStatusDetails_SCALING_TARGET_DOES_NOT_EXIST                     AutoscalerStatusDetails_Type = 122636699
	AutoscalerStatusDetails_SCHEDULED_INSTANCES_GREATER_THAN_AUTOSCALER_MAX   AutoscalerStatusDetails_Type = 29275586
	AutoscalerStatusDetails_SCHEDULED_INSTANCES_LESS_THAN_AUTOSCALER_MIN      AutoscalerStatusDetails_Type = 398287669
	AutoscalerStatusDetails_UNKNOWN                                           AutoscalerStatusDetails_Type = 433141802
	AutoscalerStatusDetails_UNSUPPORTED_MAX_RATE_LOAD_BALANCING_CONFIGURATION AutoscalerStatusDetails_Type = 330845009
	AutoscalerStatusDetails_ZONE_RESOURCE_STOCKOUT                            AutoscalerStatusDetails_Type = 210200502
)

// Enum value maps for AutoscalerStatusDetails_Type.
var (
	AutoscalerStatusDetails_Type_name = map[int32]string{
		0:         "UNDEFINED_TYPE",
		404965477: "ALL_INSTANCES_UNHEALTHY",
		191417626: "BACKEND_SERVICE_DOES_NOT_EXIST",
		518617:    "CAPPED_AT_MAX_NUM_REPLICAS",
		328964659: "CUSTOM_METRIC_DATA_POINTS_TOO_SPARSE",
		204430550: "CUSTOM_METRIC_INVALID",
		2821361:   "MIN_EQUALS_MAX",
		94885086:  "MISSING_CUSTOM_METRIC_DATA_POINTS",
		509858898: "MISSING_LOAD_BALANCING_DATA_POINTS",
		164169907: "MODE_OFF",
		3840994:   "MODE_ONLY_SCALE_OUT",
		100969842: "MODE_ONLY_UP",
		151922141: "MORE_THAN_ONE_BACKEND_SERVICE",
		403101631: "NOT_ENOUGH_QUOTA_AVAILABLE",
		528622846: "REGION_RESOURCE_STOCKOUT",
		122636699: "SCALING_TARGET_DOES_NOT_EXIST",
		29275586:  "SCHEDULED_INSTANCES_GREATER_THAN_AUTOSCALER_MAX",
		398287669: "SCHEDULED_INSTANCES_LESS_THAN_AUTOSCALER_MIN",
		433141802: "UNKNOWN",
		330845009: "UNSUPPORTED_MAX_RATE_LOAD_BALANCING_CONFIGURATION",
		210200502: "ZONE_RESOURCE_STOCKOUT",
	}
	AutoscalerStatusDetails_Type_value = map[string]int32{
		"UNDEFINED_TYPE":                                  0,
		"ALL_INSTANCES_UNHEALTHY":                         404965477,
		"BACKEND_SERVICE_DOES_NOT_EXIST":                  191417626,
		"CAPPED_AT_MAX_NUM_REPLICAS":                      518617,
		"CUSTOM_METRIC_DATA_POINTS_TOO_SPARSE":            328964659,
		"CUSTOM_METRIC_INVALID":                           204430550,
		"MIN_EQUALS_MAX":                                  2821361,
		"MISSING_CUSTOM_METRIC_DATA_POINTS":               94885086,
		"MISSING_LOAD_BALANCING_DATA_POINTS":              509858898,
		"MODE_OFF":                                        164169907,
		"MODE_ONLY_SCALE_OUT":                             3840994,
		"MODE_ONLY_UP":                                    100969842,
		"MORE_THAN_ONE_BACKEND_SERVICE":                   151922141,
		"NOT_ENOUGH_QUOTA_AVAILABLE":                      403101631,
		"REGION_RESOURCE_STOCKOUT":                        528622846,
		"SCALING_TARGET_DOES_NOT_EXIST":                   122636699,
		"SCHEDULED_INSTANCES_GREATER_THAN_AUTOSCALER_MAX": 29275586,
		"SCHEDULED_INSTANCES_LESS_THAN_AUTOSCALER_MIN":    398287669,
		"UNKNOWN": 433141802,
		"UNSUPPORTED_MAX_RATE_LOAD_BALANCING_CONFIGURATION": 330845009,
		"ZONE_RESOURCE_STOCKOUT":                            210200502,
	}
)

func (x AutoscalerStatusDetails_Type) Enum() *AutoscalerStatusDetails_Type {
	p := new(AutoscalerStatusDetails_Type)
	*p = x
	return p
}

func (x AutoscalerStatusDetails_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AutoscalerStatusDetails_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[19].Descriptor()
}

func (AutoscalerStatusDetails_Type) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[19]
}

func (x AutoscalerStatusDetails_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AutoscalerStatusDetails_Type.Descriptor instead.
func (AutoscalerStatusDetails_Type) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{28, 0}
}

// [Output Only] The status of the autoscaler configuration. Current set of possible values:
// - PENDING: Autoscaler backend hasn't read new/updated configuration.
// - DELETING: Configuration is being deleted.
// - ACTIVE: Configuration is acknowledged to be effective. Some warnings might be present in the statusDetails field.
// - ERROR: Configuration has errors. Actionable for users. Details are present in the statusDetails field.  New values might be added in the future.
type Autoscaler_Status int32

const (
	// A value indicating that the enum field is not set.
	Autoscaler_UNDEFINED_STATUS Autoscaler_Status = 0
	Autoscaler_ACTIVE           Autoscaler_Status = 314733318
	Autoscaler_DELETING         Autoscaler_Status = 528602024
	Autoscaler_ERROR            Autoscaler_Status = 66247144
	Autoscaler_PENDING          Autoscaler_Status = 35394935
)

// Enum value maps for Autoscaler_Status.
var (
	Autoscaler_Status_name = map[int32]string{
		0:         "UNDEFINED_STATUS",
		314733318: "ACTIVE",
		528602024: "DELETING",
		66247144:  "ERROR",
		35394935:  "PENDING",
	}
	Autoscaler_Status_value = map[string]int32{
		"UNDEFINED_STATUS": 0,
		"ACTIVE":           314733318,
		"DELETING":         528602024,
		"ERROR":            66247144,
		"PENDING":          35394935,
	}
)

func (x Autoscaler_Status) Enum() *Autoscaler_Status {
	p := new(Autoscaler_Status)
	*p = x
	return p
}

func (x Autoscaler_Status) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Autoscaler_Status) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[20].Descriptor()
}

func (Autoscaler_Status) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[20]
}

func (x Autoscaler_Status) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Autoscaler_Status.Descriptor instead.
func (Autoscaler_Status) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{29, 0}
}

// Indicates whether predictive autoscaling based on CPU metric is enabled. Valid values are:
//
// * NONE (default). No predictive method is used. The autoscaler scales the group to meet current demand based on real-time metrics. * OPTIMIZE_AVAILABILITY. Predictive autoscaling improves availability by monitoring daily and weekly load patterns and scaling out ahead of anticipated demand.
type AutoscalingPolicyCpuUtilization_PredictiveMethod int32

const (
	// A value indicating that the enum field is not set.
	AutoscalingPolicyCpuUtilization_UNDEFINED_PREDICTIVE_METHOD AutoscalingPolicyCpuUtilization_PredictiveMethod = 0
	AutoscalingPolicyCpuUtilization_NONE                        AutoscalingPolicyCpuUtilization_PredictiveMethod = 2402104
	AutoscalingPolicyCpuUtilization_OPTIMIZE_AVAILABILITY       AutoscalingPolicyCpuUtilization_PredictiveMethod = 11629437
)

// Enum value maps for AutoscalingPolicyCpuUtilization_PredictiveMethod.
var (
	AutoscalingPolicyCpuUtilization_PredictiveMethod_name = map[int32]string{
		0:        "UNDEFINED_PREDICTIVE_METHOD",
		2402104:  "NONE",
		11629437: "OPTIMIZE_AVAILABILITY",
	}
	AutoscalingPolicyCpuUtilization_PredictiveMethod_value = map[string]int32{
		"UNDEFINED_PREDICTIVE_METHOD": 0,
		"NONE":                        2402104,
		"OPTIMIZE_AVAILABILITY":       11629437,
	}
)

func (x AutoscalingPolicyCpuUtilization_PredictiveMethod) Enum() *AutoscalingPolicyCpuUtilization_PredictiveMethod {
	p := new(AutoscalingPolicyCpuUtilization_PredictiveMethod)
	*p = x
	return p
}

func (x AutoscalingPolicyCpuUtilization_PredictiveMethod) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AutoscalingPolicyCpuUtilization_PredictiveMethod) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[21].Descriptor()
}

func (AutoscalingPolicyCpuUtilization_PredictiveMethod) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[21]
}

func (x AutoscalingPolicyCpuUtilization_PredictiveMethod) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AutoscalingPolicyCpuUtilization_PredictiveMethod.Descriptor instead.
func (AutoscalingPolicyCpuUtilization_PredictiveMethod) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{33, 0}
}

// Defines how target utilization value is expressed for a Stackdriver Monitoring metric. Either GAUGE, DELTA_PER_SECOND, or DELTA_PER_MINUTE.
type AutoscalingPolicyCustomMetricUtilization_UtilizationTargetType int32

const (
	// A value indicating that the enum field is not set.
	AutoscalingPolicyCustomMetricUtilization_UNDEFINED_UTILIZATION_TARGET_TYPE AutoscalingPolicyCustomMetricUtilization_UtilizationTargetType = 0
	AutoscalingPolicyCustomMetricUtilization_DELTA_PER_MINUTE                  AutoscalingPolicyCustomMetricUtilization_UtilizationTargetType = 87432861
	AutoscalingPolicyCustomMetricUtilization_DELTA_PER_SECOND                  AutoscalingPolicyCustomMetricUtilization_UtilizationTargetType = 255180029
	AutoscalingPolicyCustomMetricUtilization_GAUGE                             AutoscalingPolicyCustomMetricUtilization_UtilizationTargetType = 67590361
)

// Enum value maps for AutoscalingPolicyCustomMetricUtilization_UtilizationTargetType.
var (
	AutoscalingPolicyCustomMetricUtilization_UtilizationTargetType_name = map[int32]string{
		0:         "UNDEFINED_UTILIZATION_TARGET_TYPE",
		87432861:  "DELTA_PER_MINUTE",
		255180029: "DELTA_PER_SECOND",
		67590361:  "GAUGE",
	}
	AutoscalingPolicyCustomMetricUtilization_UtilizationTargetType_value = map[string]int32{
		"UNDEFINED_UTILIZATION_TARGET_TYPE": 0,
		"DELTA_PER_MINUTE":                  87432861,
		"DELTA_PER_SECOND":                  255180029,
		"GAUGE":                             67590361,
	}
)

func (x AutoscalingPolicyCustomMetricUtilization_UtilizationTargetType) Enum() *AutoscalingPolicyCustomMetricUtilization_UtilizationTargetType {
	p := new(AutoscalingPolicyCustomMetricUtilization_UtilizationTargetType)
	*p = x
	return p
}

func (x AutoscalingPolicyCustomMetricUtilization_UtilizationTargetType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AutoscalingPolicyCustomMetricUtilization_UtilizationTargetType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[22].Descriptor()
}

func (AutoscalingPolicyCustomMetricUtilization_UtilizationTargetType) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[22]
}

func (x AutoscalingPolicyCustomMetricUtilization_UtilizationTargetType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AutoscalingPolicyCustomMetricUtilization_UtilizationTargetType.Descriptor instead.
func (AutoscalingPolicyCustomMetricUtilization_UtilizationTargetType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{34, 0}
}

// Specifies how to determine whether the backend of a load balancer can handle additional traffic or is fully loaded. For usage guidelines, see  Connection balancing mode.
type Backend_BalancingMode int32

const (
	// A value indicating that the enum field is not set.
	Backend_UNDEFINED_BALANCING_MODE Backend_BalancingMode = 0
	Backend_CONNECTION               Backend_BalancingMode = 246311646
	Backend_RATE                     Backend_BalancingMode = 2508000
	Backend_UTILIZATION              Backend_BalancingMode = 157008386
)

// Enum value maps for Backend_BalancingMode.
var (
	Backend_BalancingMode_name = map[int32]string{
		0:         "UNDEFINED_BALANCING_MODE",
		246311646: "CONNECTION",
		2508000:   "RATE",
		157008386: "UTILIZATION",
	}
	Backend_BalancingMode_value = map[string]int32{
		"UNDEFINED_BALANCING_MODE": 0,
		"CONNECTION":               246311646,
		"RATE":                     2508000,
		"UTILIZATION":              157008386,
	}
)

func (x Backend_BalancingMode) Enum() *Backend_BalancingMode {
	p := new(Backend_BalancingMode)
	*p = x
	return p
}

func (x Backend_BalancingMode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Backend_BalancingMode) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[23].Descriptor()
}

func (Backend_BalancingMode) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[23]
}

func (x Backend_BalancingMode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Backend_BalancingMode.Descriptor instead.
func (Backend_BalancingMode) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{39, 0}
}

// Specifies the cache setting for all responses from this backend. The possible values are:
//
// USE_ORIGIN_HEADERS Requires the origin to set valid caching headers to cache content. Responses without these headers will not be cached at Google's edge, and will require a full trip to the origin on every request, potentially impacting performance and increasing load on the origin server.
//
// FORCE_CACHE_ALL Cache all content, ignoring any "private", "no-store" or "no-cache" directives in Cache-Control response headers. Warning: this may result in Cloud CDN caching private, per-user (user identifiable) content.
//
// CACHE_ALL_STATIC Automatically cache static content, including common image formats, media (video and audio), and web assets (JavaScript and CSS). Requests and responses that are marked as uncacheable, as well as dynamic content (including HTML), will not be cached.
type BackendBucketCdnPolicy_CacheMode int32

const (
	// A value indicating that the enum field is not set.
	BackendBucketCdnPolicy_UNDEFINED_CACHE_MODE BackendBucketCdnPolicy_CacheMode = 0
	BackendBucketCdnPolicy_CACHE_ALL_STATIC     BackendBucketCdnPolicy_CacheMode = 355027945
	BackendBucketCdnPolicy_FORCE_CACHE_ALL      BackendBucketCdnPolicy_CacheMode = 486026928
	BackendBucketCdnPolicy_INVALID_CACHE_MODE   BackendBucketCdnPolicy_CacheMode = 381295560
	BackendBucketCdnPolicy_USE_ORIGIN_HEADERS   BackendBucketCdnPolicy_CacheMode = 55380261
)

// Enum value maps for BackendBucketCdnPolicy_CacheMode.
var (
	BackendBucketCdnPolicy_CacheMode_name = map[int32]string{
		0:         "UNDEFINED_CACHE_MODE",
		355027945: "CACHE_ALL_STATIC",
		486026928: "FORCE_CACHE_ALL",
		381295560: "INVALID_CACHE_MODE",
		55380261:  "USE_ORIGIN_HEADERS",
	}
	BackendBucketCdnPolicy_CacheMode_value = map[string]int32{
		"UNDEFINED_CACHE_MODE": 0,
		"CACHE_ALL_STATIC":     355027945,
		"FORCE_CACHE_ALL":      486026928,
		"INVALID_CACHE_MODE":   381295560,
		"USE_ORIGIN_HEADERS":   55380261,
	}
)

func (x BackendBucketCdnPolicy_CacheMode) Enum() *BackendBucketCdnPolicy_CacheMode {
	p := new(BackendBucketCdnPolicy_CacheMode)
	*p = x
	return p
}

func (x BackendBucketCdnPolicy_CacheMode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (BackendBucketCdnPolicy_CacheMode) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[24].Descriptor()
}

func (BackendBucketCdnPolicy_CacheMode) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[24]
}

func (x BackendBucketCdnPolicy_CacheMode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use BackendBucketCdnPolicy_CacheMode.Descriptor instead.
func (BackendBucketCdnPolicy_CacheMode) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{40, 0}
}

// Specifies the cache setting for all responses from this backend. The possible values are:
//
// USE_ORIGIN_HEADERS Requires the origin to set valid caching headers to cache content. Responses without these headers will not be cached at Google's edge, and will require a full trip to the origin on every request, potentially impacting performance and increasing load on the origin server.
//
// FORCE_CACHE_ALL Cache all content, ignoring any "private", "no-store" or "no-cache" directives in Cache-Control response headers. Warning: this may result in Cloud CDN caching private, per-user (user identifiable) content.
//
// CACHE_ALL_STATIC Automatically cache static content, including common image formats, media (video and audio), and web assets (JavaScript and CSS). Requests and responses that are marked as uncacheable, as well as dynamic content (including HTML), will not be cached.
type BackendServiceCdnPolicy_CacheMode int32

const (
	// A value indicating that the enum field is not set.
	BackendServiceCdnPolicy_UNDEFINED_CACHE_MODE BackendServiceCdnPolicy_CacheMode = 0
	BackendServiceCdnPolicy_CACHE_ALL_STATIC     BackendServiceCdnPolicy_CacheMode = 355027945
	BackendServiceCdnPolicy_FORCE_CACHE_ALL      BackendServiceCdnPolicy_CacheMode = 486026928
	BackendServiceCdnPolicy_INVALID_CACHE_MODE   BackendServiceCdnPolicy_CacheMode = 381295560
	BackendServiceCdnPolicy_USE_ORIGIN_HEADERS   BackendServiceCdnPolicy_CacheMode = 55380261
)

// Enum value maps for BackendServiceCdnPolicy_CacheMode.
var (
	BackendServiceCdnPolicy_CacheMode_name = map[int32]string{
		0:         "UNDEFINED_CACHE_MODE",
		355027945: "CACHE_ALL_STATIC",
		486026928: "FORCE_CACHE_ALL",
		381295560: "INVALID_CACHE_MODE",
		55380261:  "USE_ORIGIN_HEADERS",
	}
	BackendServiceCdnPolicy_CacheMode_value = map[string]int32{
		"UNDEFINED_CACHE_MODE": 0,
		"CACHE_ALL_STATIC":     355027945,
		"FORCE_CACHE_ALL":      486026928,
		"INVALID_CACHE_MODE":   381295560,
		"USE_ORIGIN_HEADERS":   55380261,
	}
)

func (x BackendServiceCdnPolicy_CacheMode) Enum() *BackendServiceCdnPolicy_CacheMode {
	p := new(BackendServiceCdnPolicy_CacheMode)
	*p = x
	return p
}

func (x BackendServiceCdnPolicy_CacheMode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (BackendServiceCdnPolicy_CacheMode) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[25].Descriptor()
}

func (BackendServiceCdnPolicy_CacheMode) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[25]
}

func (x BackendServiceCdnPolicy_CacheMode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use BackendServiceCdnPolicy_CacheMode.Descriptor instead.
func (BackendServiceCdnPolicy_CacheMode) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{45, 0}
}

// Specifies the load balancer type. Choose EXTERNAL for external HTTP(S), SSL Proxy, TCP Proxy and Network Load Balancing. Choose  INTERNAL for Internal TCP/UDP Load Balancing. Choose  INTERNAL_MANAGED for Internal HTTP(S) Load Balancing.  INTERNAL_SELF_MANAGED for Traffic Director. A backend service created for one type of load balancer cannot be used with another. For more information, refer to Choosing a load balancer.
type BackendService_LoadBalancingScheme int32

const (
	// A value indicating that the enum field is not set.
	BackendService_UNDEFINED_LOAD_BALANCING_SCHEME BackendService_LoadBalancingScheme = 0
	BackendService_EXTERNAL                        BackendService_LoadBalancingScheme = 35607499
	BackendService_INTERNAL                        BackendService_LoadBalancingScheme = 279295677
	BackendService_INTERNAL_MANAGED                BackendService_LoadBalancingScheme = 37350397
	BackendService_INTERNAL_SELF_MANAGED           BackendService_LoadBalancingScheme = 236211150
	BackendService_INVALID_LOAD_BALANCING_SCHEME   BackendService_LoadBalancingScheme = 275352060
)

// Enum value maps for BackendService_LoadBalancingScheme.
var (
	BackendService_LoadBalancingScheme_name = map[int32]string{
		0:         "UNDEFINED_LOAD_BALANCING_SCHEME",
		35607499:  "EXTERNAL",
		279295677: "INTERNAL",
		37350397:  "INTERNAL_MANAGED",
		236211150: "INTERNAL_SELF_MANAGED",
		275352060: "INVALID_LOAD_BALANCING_SCHEME",
	}
	BackendService_LoadBalancingScheme_value = map[string]int32{
		"UNDEFINED_LOAD_BALANCING_SCHEME": 0,
		"EXTERNAL":                        35607499,
		"INTERNAL":                        279295677,
		"INTERNAL_MANAGED":                37350397,
		"INTERNAL_SELF_MANAGED":           236211150,
		"INVALID_LOAD_BALANCING_SCHEME":   275352060,
	}
)

func (x BackendService_LoadBalancingScheme) Enum() *BackendService_LoadBalancingScheme {
	p := new(BackendService_LoadBalancingScheme)
	*p = x
	return p
}

func (x BackendService_LoadBalancingScheme) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (BackendService_LoadBalancingScheme) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[26].Descriptor()
}

func (BackendService_LoadBalancingScheme) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[26]
}

func (x BackendService_LoadBalancingScheme) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use BackendService_LoadBalancingScheme.Descriptor instead.
func (BackendService_LoadBalancingScheme) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{55, 0}
}

// The load balancing algorithm used within the scope of the locality. The possible values are:
// - ROUND_ROBIN: This is a simple policy in which each healthy backend is selected in round robin order. This is the default.
// - LEAST_REQUEST: An O(1) algorithm which selects two random healthy hosts and picks the host which has fewer active requests.
// - RING_HASH: The ring/modulo hash load balancer implements consistent hashing to backends. The algorithm has the property that the addition/removal of a host from a set of N hosts only affects 1/N of the requests.
// - RANDOM: The load balancer selects a random healthy host.
// - ORIGINAL_DESTINATION: Backend host is selected based on the client connection metadata, i.e., connections are opened to the same address as the destination address of the incoming connection before the connection was redirected to the load balancer.
// - MAGLEV: used as a drop in replacement for the ring hash load balancer. Maglev is not as stable as ring hash but has faster table lookup build times and host selection times. For more information about Maglev, see https://ai.google/research/pubs/pub44824
//
// This field is applicable to either:
// - A regional backend service with the service_protocol set to HTTP, HTTPS, or HTTP2, and load_balancing_scheme set to INTERNAL_MANAGED.
// - A global backend service with the load_balancing_scheme set to INTERNAL_SELF_MANAGED.
//
// If sessionAffinity is not NONE, and this field is not set to MAGLEV or RING_HASH, session affinity settings will not take effect.
//
// Only the default ROUND_ROBIN policy is supported when the backend service is referenced by a URL map that is bound to target gRPC proxy that has validateForProxyless field set to true.
type BackendService_LocalityLbPolicy int32

const (
	// A value indicating that the enum field is not set.
	BackendService_UNDEFINED_LOCALITY_LB_POLICY BackendService_LocalityLbPolicy = 0
	BackendService_INVALID_LB_POLICY            BackendService_LocalityLbPolicy = 323318707
	BackendService_LEAST_REQUEST                BackendService_LocalityLbPolicy = 46604921
	BackendService_MAGLEV                       BackendService_LocalityLbPolicy = 119180266
	BackendService_ORIGINAL_DESTINATION         BackendService_LocalityLbPolicy = 166297216
	BackendService_RANDOM                       BackendService_LocalityLbPolicy = 262527171
	BackendService_RING_HASH                    BackendService_LocalityLbPolicy = 432795069
	BackendService_ROUND_ROBIN                  BackendService_LocalityLbPolicy = 153895801
)

// Enum value maps for BackendService_LocalityLbPolicy.
var (
	BackendService_LocalityLbPolicy_name = map[int32]string{
		0:         "UNDEFINED_LOCALITY_LB_POLICY",
		323318707: "INVALID_LB_POLICY",
		46604921:  "LEAST_REQUEST",
		119180266: "MAGLEV",
		166297216: "ORIGINAL_DESTINATION",
		262527171: "RANDOM",
		432795069: "RING_HASH",
		153895801: "ROUND_ROBIN",
	}
	BackendService_LocalityLbPolicy_value = map[string]int32{
		"UNDEFINED_LOCALITY_LB_POLICY": 0,
		"INVALID_LB_POLICY":            323318707,
		"LEAST_REQUEST":                46604921,
		"MAGLEV":                       119180266,
		"ORIGINAL_DESTINATION":         166297216,
		"RANDOM":                       262527171,
		"RING_HASH":                    432795069,
		"ROUND_ROBIN":                  153895801,
	}
)

func (x BackendService_LocalityLbPolicy) Enum() *BackendService_LocalityLbPolicy {
	p := new(BackendService_LocalityLbPolicy)
	*p = x
	return p
}

func (x BackendService_LocalityLbPolicy) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (BackendService_LocalityLbPolicy) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[27].Descriptor()
}

func (BackendService_LocalityLbPolicy) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[27]
}

func (x BackendService_LocalityLbPolicy) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use BackendService_LocalityLbPolicy.Descriptor instead.
func (BackendService_LocalityLbPolicy) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{55, 1}
}

// The protocol this BackendService uses to communicate with backends.
//
// Possible values are HTTP, HTTPS, HTTP2, TCP, SSL, UDP or GRPC. depending on the chosen load balancer or Traffic Director configuration. Refer to the documentation for the load balancer or for Traffic Director for more information.
//
// Must be set to GRPC when the backend service is referenced by a URL map that is bound to target gRPC proxy.
type BackendService_Protocol int32

const (
	// A value indicating that the enum field is not set.
	BackendService_UNDEFINED_PROTOCOL BackendService_Protocol = 0
	BackendService_GRPC               BackendService_Protocol = 2196510
	BackendService_HTTP               BackendService_Protocol = 2228360
	BackendService_HTTP2              BackendService_Protocol = 69079210
	BackendService_HTTPS              BackendService_Protocol = 69079243
	BackendService_SSL                BackendService_Protocol = 82412
	BackendService_TCP                BackendService_Protocol = 82881
	BackendService_UDP                BackendService_Protocol = 83873
)

// Enum value maps for BackendService_Protocol.
var (
	BackendService_Protocol_name = map[int32]string{
		0:        "UNDEFINED_PROTOCOL",
		2196510:  "GRPC",
		2228360:  "HTTP",
		69079210: "HTTP2",
		69079243: "HTTPS",
		82412:    "SSL",
		82881:    "TCP",
		83873:    "UDP",
	}
	BackendService_Protocol_value = map[string]int32{
		"UNDEFINED_PROTOCOL": 0,
		"GRPC":               2196510,
		"HTTP":               2228360,
		"HTTP2":              69079210,
		"HTTPS":              69079243,
		"SSL":                82412,
		"TCP":                82881,
		"UDP":                83873,
	}
)

func (x BackendService_Protocol) Enum() *BackendService_Protocol {
	p := new(BackendService_Protocol)
	*p = x
	return p
}

func (x BackendService_Protocol) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (BackendService_Protocol) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[28].Descriptor()
}

func (BackendService_Protocol) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[28]
}

func (x BackendService_Protocol) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use BackendService_Protocol.Descriptor instead.
func (BackendService_Protocol) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{55, 2}
}

// Type of session affinity to use. The default is NONE.
//
// When the loadBalancingScheme is EXTERNAL: * For Network Load Balancing, the possible values are NONE, CLIENT_IP, CLIENT_IP_PROTO, or  CLIENT_IP_PORT_PROTO. * For all other load balancers that use loadBalancingScheme=EXTERNAL, the possible values are NONE, CLIENT_IP, or GENERATED_COOKIE. * You can use GENERATED_COOKIE if the protocol is HTTP, HTTP2, or HTTPS.
//
// When the loadBalancingScheme is INTERNAL, possible values are NONE, CLIENT_IP, CLIENT_IP_PROTO, or CLIENT_IP_PORT_PROTO.
//
// When the loadBalancingScheme is INTERNAL_SELF_MANAGED, or INTERNAL_MANAGED, possible values are NONE, CLIENT_IP, GENERATED_COOKIE, HEADER_FIELD, or HTTP_COOKIE.
//
// Not supported when the backend service is referenced by a URL map that is bound to target gRPC proxy that has validateForProxyless field set to true.
type BackendService_SessionAffinity int32

const (
	// A value indicating that the enum field is not set.
	BackendService_UNDEFINED_SESSION_AFFINITY BackendService_SessionAffinity = 0
	BackendService_CLIENT_IP                  BackendService_SessionAffinity = 345665051
	BackendService_CLIENT_IP_NO_DESTINATION   BackendService_SessionAffinity = 106122516
	BackendService_CLIENT_IP_PORT_PROTO       BackendService_SessionAffinity = 221722926
	BackendService_CLIENT_IP_PROTO            BackendService_SessionAffinity = 25322148
	BackendService_GENERATED_COOKIE           BackendService_SessionAffinity = 370321204
	BackendService_HEADER_FIELD               BackendService_SessionAffinity = 200737960
	BackendService_HTTP_COOKIE                BackendService_SessionAffinity = 494981627
	BackendService_NONE                       BackendService_SessionAffinity = 2402104
)

// Enum value maps for BackendService_SessionAffinity.
var (
	BackendService_SessionAffinity_name = map[int32]string{
		0:         "UNDEFINED_SESSION_AFFINITY",
		345665051: "CLIENT_IP",
		106122516: "CLIENT_IP_NO_DESTINATION",
		221722926: "CLIENT_IP_PORT_PROTO",
		25322148:  "CLIENT_IP_PROTO",
		370321204: "GENERATED_COOKIE",
		200737960: "HEADER_FIELD",
		494981627: "HTTP_COOKIE",
		2402104:   "NONE",
	}
	BackendService_SessionAffinity_value = map[string]int32{
		"UNDEFINED_SESSION_AFFINITY": 0,
		"CLIENT_IP":                  345665051,
		"CLIENT_IP_NO_DESTINATION":   106122516,
		"CLIENT_IP_PORT_PROTO":       221722926,
		"CLIENT_IP_PROTO":            25322148,
		"GENERATED_COOKIE":           370321204,
		"HEADER_FIELD":               200737960,
		"HTTP_COOKIE":                494981627,
		"NONE":                       2402104,
	}
)

func (x BackendService_SessionAffinity) Enum() *BackendService_SessionAffinity {
	p := new(BackendService_SessionAffinity)
	*p = x
	return p
}

func (x BackendService_SessionAffinity) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (BackendService_SessionAffinity) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[29].Descriptor()
}

func (BackendService_SessionAffinity) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[29]
}

func (x BackendService_SessionAffinity) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use BackendService_SessionAffinity.Descriptor instead.
func (BackendService_SessionAffinity) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{55, 3}
}

// Health state of the instance.
type HealthStatus_HealthState int32

const (
	// A value indicating that the enum field is not set.
	HealthStatus_UNDEFINED_HEALTH_STATE HealthStatus_HealthState = 0
	HealthStatus_HEALTHY                HealthStatus_HealthState = 439801213
	HealthStatus_UNHEALTHY              HealthStatus_HealthState = 462118084
)

// Enum value maps for HealthStatus_HealthState.
var (
	HealthStatus_HealthState_name = map[int32]string{
		0:         "UNDEFINED_HEALTH_STATE",
		439801213: "HEALTHY",
		462118084: "UNHEALTHY",
	}
	HealthStatus_HealthState_value = map[string]int32{
		"UNDEFINED_HEALTH_STATE": 0,
		"HEALTHY":                439801213,
		"UNHEALTHY":              462118084,
	}
)

func (x HealthStatus_HealthState) Enum() *HealthStatus_HealthState {
	p := new(HealthStatus_HealthState)
	*p = x
	return p
}

func (x HealthStatus_HealthState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (HealthStatus_HealthState) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[30].Descriptor()
}

func (HealthStatus_HealthState) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[30]
}

func (x HealthStatus_HealthState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use HealthStatus_HealthState.Descriptor instead.
func (HealthStatus_HealthState) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{61, 0}
}

//
type HealthStatus_WeightError int32

const (
	// A value indicating that the enum field is not set.
	HealthStatus_UNDEFINED_WEIGHT_ERROR HealthStatus_WeightError = 0
	HealthStatus_INVALID_WEIGHT         HealthStatus_WeightError = 383698400
	HealthStatus_MISSING_WEIGHT         HealthStatus_WeightError = 384027537
	HealthStatus_UNAVAILABLE_WEIGHT     HealthStatus_WeightError = 439464295
	HealthStatus_WEIGHT_NONE            HealthStatus_WeightError = 502428831
)

// Enum value maps for HealthStatus_WeightError.
var (
	HealthStatus_WeightError_name = map[int32]string{
		0:         "UNDEFINED_WEIGHT_ERROR",
		383698400: "INVALID_WEIGHT",
		384027537: "MISSING_WEIGHT",
		439464295: "UNAVAILABLE_WEIGHT",
		502428831: "WEIGHT_NONE",
	}
	HealthStatus_WeightError_value = map[string]int32{
		"UNDEFINED_WEIGHT_ERROR": 0,
		"INVALID_WEIGHT":         383698400,
		"MISSING_WEIGHT":         384027537,
		"UNAVAILABLE_WEIGHT":     439464295,
		"WEIGHT_NONE":            502428831,
	}
)

func (x HealthStatus_WeightError) Enum() *HealthStatus_WeightError {
	p := new(HealthStatus_WeightError)
	*p = x
	return p
}

func (x HealthStatus_WeightError) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (HealthStatus_WeightError) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[31].Descriptor()
}

func (HealthStatus_WeightError) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[31]
}

func (x HealthStatus_WeightError) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use HealthStatus_WeightError.Descriptor instead.
func (HealthStatus_WeightError) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{61, 1}
}

// The private IPv6 google access type for VMs. If not specified, use  INHERIT_FROM_SUBNETWORK as default.
type InstanceProperties_PrivateIpv6GoogleAccess int32

const (
	// A value indicating that the enum field is not set.
	InstanceProperties_UNDEFINED_PRIVATE_IPV6_GOOGLE_ACCESS  InstanceProperties_PrivateIpv6GoogleAccess = 0
	InstanceProperties_ENABLE_BIDIRECTIONAL_ACCESS_TO_GOOGLE InstanceProperties_PrivateIpv6GoogleAccess = 427975994
	InstanceProperties_ENABLE_OUTBOUND_VM_ACCESS_TO_GOOGLE   InstanceProperties_PrivateIpv6GoogleAccess = 288210263
	InstanceProperties_INHERIT_FROM_SUBNETWORK               InstanceProperties_PrivateIpv6GoogleAccess = 530256959
)

// Enum value maps for InstanceProperties_PrivateIpv6GoogleAccess.
var (
	InstanceProperties_PrivateIpv6GoogleAccess_name = map[int32]string{
		0:         "UNDEFINED_PRIVATE_IPV6_GOOGLE_ACCESS",
		427975994: "ENABLE_BIDIRECTIONAL_ACCESS_TO_GOOGLE",
		288210263: "ENABLE_OUTBOUND_VM_ACCESS_TO_GOOGLE",
		530256959: "INHERIT_FROM_SUBNETWORK",
	}
	InstanceProperties_PrivateIpv6GoogleAccess_value = map[string]int32{
		"UNDEFINED_PRIVATE_IPV6_GOOGLE_ACCESS":  0,
		"ENABLE_BIDIRECTIONAL_ACCESS_TO_GOOGLE": 427975994,
		"ENABLE_OUTBOUND_VM_ACCESS_TO_GOOGLE":   288210263,
		"INHERIT_FROM_SUBNETWORK":               530256959,
	}
)

func (x InstanceProperties_PrivateIpv6GoogleAccess) Enum() *InstanceProperties_PrivateIpv6GoogleAccess {
	p := new(InstanceProperties_PrivateIpv6GoogleAccess)
	*p = x
	return p
}

func (x InstanceProperties_PrivateIpv6GoogleAccess) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (InstanceProperties_PrivateIpv6GoogleAccess) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[32].Descriptor()
}

func (InstanceProperties_PrivateIpv6GoogleAccess) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[32]
}

func (x InstanceProperties_PrivateIpv6GoogleAccess) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use InstanceProperties_PrivateIpv6GoogleAccess.Descriptor instead.
func (InstanceProperties_PrivateIpv6GoogleAccess) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{67, 0}
}

// [Output Only] The status of the reservation.
type Reservation_Status int32

const (
	// A value indicating that the enum field is not set.
	Reservation_UNDEFINED_STATUS Reservation_Status = 0
	Reservation_CREATING         Reservation_Status = 455564985
	Reservation_DELETING         Reservation_Status = 528602024
	Reservation_INVALID          Reservation_Status = 530283991
	Reservation_READY            Reservation_Status = 77848963
	Reservation_UPDATING         Reservation_Status = 494614342
)

// Enum value maps for Reservation_Status.
var (
	Reservation_Status_name = map[int32]string{
		0:         "UNDEFINED_STATUS",
		455564985: "CREATING",
		528602024: "DELETING",
		530283991: "INVALID",
		77848963:  "READY",
		494614342: "UPDATING",
	}
	Reservation_Status_value = map[string]int32{
		"UNDEFINED_STATUS": 0,
		"CREATING":         455564985,
		"DELETING":         528602024,
		"INVALID":          530283991,
		"READY":            77848963,
		"UPDATING":         494614342,
	}
)

func (x Reservation_Status) Enum() *Reservation_Status {
	p := new(Reservation_Status)
	*p = x
	return p
}

func (x Reservation_Status) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Reservation_Status) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[33].Descriptor()
}

func (Reservation_Status) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[33]
}

func (x Reservation_Status) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Reservation_Status.Descriptor instead.
func (Reservation_Status) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{73, 0}
}

// Type of resource for which this commitment applies. Possible values are VCPU and MEMORY
type ResourceCommitment_Type int32

const (
	// A value indicating that the enum field is not set.
	ResourceCommitment_UNDEFINED_TYPE ResourceCommitment_Type = 0
	ResourceCommitment_ACCELERATOR    ResourceCommitment_Type = 429815371
	ResourceCommitment_LOCAL_SSD      ResourceCommitment_Type = 508934896
	ResourceCommitment_MEMORY         ResourceCommitment_Type = 123056385
	ResourceCommitment_UNSPECIFIED    ResourceCommitment_Type = 526786327
	ResourceCommitment_VCPU           ResourceCommitment_Type = 2628978
)

// Enum value maps for ResourceCommitment_Type.
var (
	ResourceCommitment_Type_name = map[int32]string{
		0:         "UNDEFINED_TYPE",
		429815371: "ACCELERATOR",
		508934896: "LOCAL_SSD",
		123056385: "MEMORY",
		526786327: "UNSPECIFIED",
		2628978:   "VCPU",
	}
	ResourceCommitment_Type_value = map[string]int32{
		"UNDEFINED_TYPE": 0,
		"ACCELERATOR":    429815371,
		"LOCAL_SSD":      508934896,
		"MEMORY":         123056385,
		"UNSPECIFIED":    526786327,
		"VCPU":           2628978,
	}
)

func (x ResourceCommitment_Type) Enum() *ResourceCommitment_Type {
	p := new(ResourceCommitment_Type)
	*p = x
	return p
}

func (x ResourceCommitment_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ResourceCommitment_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[34].Descriptor()
}

func (ResourceCommitment_Type) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[34]
}

func (x ResourceCommitment_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ResourceCommitment_Type.Descriptor instead.
func (ResourceCommitment_Type) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{74, 0}
}

// The category of the commitment. Category MACHINE specifies commitments composed of machine resources such as VCPU or MEMORY, listed in resources. Category LICENSE specifies commitments composed of software licenses, listed in licenseResources. Note that only MACHINE commitments should have a Type specified.
type Commitment_Category int32

const (
	// A value indicating that the enum field is not set.
	Commitment_UNDEFINED_CATEGORY   Commitment_Category = 0
	Commitment_CATEGORY_UNSPECIFIED Commitment_Category = 509189462
	Commitment_LICENSE              Commitment_Category = 347869217
	Commitment_MACHINE              Commitment_Category = 469553191
)

// Enum value maps for Commitment_Category.
var (
	Commitment_Category_name = map[int32]string{
		0:         "UNDEFINED_CATEGORY",
		509189462: "CATEGORY_UNSPECIFIED",
		347869217: "LICENSE",
		469553191: "MACHINE",
	}
	Commitment_Category_value = map[string]int32{
		"UNDEFINED_CATEGORY":   0,
		"CATEGORY_UNSPECIFIED": 509189462,
		"LICENSE":              347869217,
		"MACHINE":              469553191,
	}
)

func (x Commitment_Category) Enum() *Commitment_Category {
	p := new(Commitment_Category)
	*p = x
	return p
}

func (x Commitment_Category) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Commitment_Category) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[35].Descriptor()
}

func (Commitment_Category) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[35]
}

func (x Commitment_Category) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Commitment_Category.Descriptor instead.
func (Commitment_Category) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{75, 0}
}

// The plan for this commitment, which determines duration and discount rate. The currently supported plans are TWELVE_MONTH (1 year), and THIRTY_SIX_MONTH (3 years).
type Commitment_Plan int32

const (
	// A value indicating that the enum field is not set.
	Commitment_UNDEFINED_PLAN   Commitment_Plan = 0
	Commitment_INVALID          Commitment_Plan = 530283991
	Commitment_THIRTY_SIX_MONTH Commitment_Plan = 266295942
	Commitment_TWELVE_MONTH     Commitment_Plan = 173083962
)

// Enum value maps for Commitment_Plan.
var (
	Commitment_Plan_name = map[int32]string{
		0:         "UNDEFINED_PLAN",
		530283991: "INVALID",
		266295942: "THIRTY_SIX_MONTH",
		173083962: "TWELVE_MONTH",
	}
	Commitment_Plan_value = map[string]int32{
		"UNDEFINED_PLAN":   0,
		"INVALID":          530283991,
		"THIRTY_SIX_MONTH": 266295942,
		"TWELVE_MONTH":     173083962,
	}
)

func (x Commitment_Plan) Enum() *Commitment_Plan {
	p := new(Commitment_Plan)
	*p = x
	return p
}

func (x Commitment_Plan) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Commitment_Plan) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[36].Descriptor()
}

func (Commitment_Plan) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[36]
}

func (x Commitment_Plan) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Commitment_Plan.Descriptor instead.
func (Commitment_Plan) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{75, 1}
}

// [Output Only] Status of the commitment with regards to eventual expiration (each commitment has an end date defined). One of the following values: NOT_YET_ACTIVE, ACTIVE, EXPIRED.
type Commitment_Status int32

const (
	// A value indicating that the enum field is not set.
	Commitment_UNDEFINED_STATUS Commitment_Status = 0
	Commitment_ACTIVE           Commitment_Status = 314733318
	Commitment_CREATING         Commitment_Status = 455564985
	Commitment_EXPIRED          Commitment_Status = 482489093
	Commitment_NOT_YET_ACTIVE   Commitment_Status = 20607337
)

// Enum value maps for Commitment_Status.
var (
	Commitment_Status_name = map[int32]string{
		0:         "UNDEFINED_STATUS",
		314733318: "ACTIVE",
		455564985: "CREATING",
		482489093: "EXPIRED",
		20607337:  "NOT_YET_ACTIVE",
	}
	Commitment_Status_value = map[string]int32{
		"UNDEFINED_STATUS": 0,
		"ACTIVE":           314733318,
		"CREATING":         455564985,
		"EXPIRED":          482489093,
		"NOT_YET_ACTIVE":   20607337,
	}
)

func (x Commitment_Status) Enum() *Commitment_Status {
	p := new(Commitment_Status)
	*p = x
	return p
}

func (x Commitment_Status) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Commitment_Status) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[37].Descriptor()
}

func (Commitment_Status) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[37]
}

func (x Commitment_Status) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Commitment_Status.Descriptor instead.
func (Commitment_Status) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{75, 2}
}

// [Output Only] The status of disk creation.
// - CREATING: Disk is provisioning.
// - RESTORING: Source data is being copied into the disk.
// - FAILED: Disk creation failed.
// - READY: Disk is ready for use.
// - DELETING: Disk is deleting.
type Disk_Status int32

const (
	// A value indicating that the enum field is not set.
	Disk_UNDEFINED_STATUS Disk_Status = 0
	Disk_CREATING         Disk_Status = 455564985
	Disk_DELETING         Disk_Status = 528602024
	Disk_FAILED           Disk_Status = 455706685
	Disk_READY            Disk_Status = 77848963
	Disk_RESTORING        Disk_Status = 404263851
)

// Enum value maps for Disk_Status.
var (
	Disk_Status_name = map[int32]string{
		0:         "UNDEFINED_STATUS",
		455564985: "CREATING",
		528602024: "DELETING",
		455706685: "FAILED",
		77848963:  "READY",
		404263851: "RESTORING",
	}
	Disk_Status_value = map[string]int32{
		"UNDEFINED_STATUS": 0,
		"CREATING":         455564985,
		"DELETING":         528602024,
		"FAILED":           455706685,
		"READY":            77848963,
		"RESTORING":        404263851,
	}
)

func (x Disk_Status) Enum() *Disk_Status {
	p := new(Disk_Status)
	*p = x
	return p
}

func (x Disk_Status) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Disk_Status) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[38].Descriptor()
}

func (Disk_Status) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[38]
}

func (x Disk_Status) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Disk_Status.Descriptor instead.
func (Disk_Status) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{84, 0}
}

// Specifies whether to include the disk and what image to use. Possible values are:
// - source-image: to use the same image that was used to create the source instance's corresponding disk. Applicable to the boot disk and additional read-write disks.
// - source-image-family: to use the same image family that was used to create the source instance's corresponding disk. Applicable to the boot disk and additional read-write disks.
// - custom-image: to use a user-provided image url for disk creation. Applicable to the boot disk and additional read-write disks.
// - attach-read-only: to attach a read-only disk. Applicable to read-only disks.
// - do-not-include: to exclude a disk from the template. Applicable to additional read-write disks, local SSDs, and read-only disks.
type DiskInstantiationConfig_InstantiateFrom int32

const (
	// A value indicating that the enum field is not set.
	DiskInstantiationConfig_UNDEFINED_INSTANTIATE_FROM DiskInstantiationConfig_InstantiateFrom = 0
	DiskInstantiationConfig_ATTACH_READ_ONLY           DiskInstantiationConfig_InstantiateFrom = 513775419
	DiskInstantiationConfig_BLANK                      DiskInstantiationConfig_InstantiateFrom = 63281460
	DiskInstantiationConfig_CUSTOM_IMAGE               DiskInstantiationConfig_InstantiateFrom = 196311789
	DiskInstantiationConfig_DEFAULT                    DiskInstantiationConfig_InstantiateFrom = 115302945
	DiskInstantiationConfig_DO_NOT_INCLUDE             DiskInstantiationConfig_InstantiateFrom = 104218952
	DiskInstantiationConfig_SOURCE_IMAGE               DiskInstantiationConfig_InstantiateFrom = 62631959
	DiskInstantiationConfig_SOURCE_IMAGE_FAMILY        DiskInstantiationConfig_InstantiateFrom = 76850316
)

// Enum value maps for DiskInstantiationConfig_InstantiateFrom.
var (
	DiskInstantiationConfig_InstantiateFrom_name = map[int32]string{
		0:         "UNDEFINED_INSTANTIATE_FROM",
		513775419: "ATTACH_READ_ONLY",
		63281460:  "BLANK",
		196311789: "CUSTOM_IMAGE",
		115302945: "DEFAULT",
		104218952: "DO_NOT_INCLUDE",
		62631959:  "SOURCE_IMAGE",
		76850316:  "SOURCE_IMAGE_FAMILY",
	}
	DiskInstantiationConfig_InstantiateFrom_value = map[string]int32{
		"UNDEFINED_INSTANTIATE_FROM": 0,
		"ATTACH_READ_ONLY":           513775419,
		"BLANK":                      63281460,
		"CUSTOM_IMAGE":               196311789,
		"DEFAULT":                    115302945,
		"DO_NOT_INCLUDE":             104218952,
		"SOURCE_IMAGE":               62631959,
		"SOURCE_IMAGE_FAMILY":        76850316,
	}
)

func (x DiskInstantiationConfig_InstantiateFrom) Enum() *DiskInstantiationConfig_InstantiateFrom {
	p := new(DiskInstantiationConfig_InstantiateFrom)
	*p = x
	return p
}

func (x DiskInstantiationConfig_InstantiateFrom) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DiskInstantiationConfig_InstantiateFrom) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[39].Descriptor()
}

func (DiskInstantiationConfig_InstantiateFrom) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[39]
}

func (x DiskInstantiationConfig_InstantiateFrom) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use DiskInstantiationConfig_InstantiateFrom.Descriptor instead.
func (DiskInstantiationConfig_InstantiateFrom) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{87, 0}
}

// The distribution shape to which the group converges either proactively or on resize events (depending on the value set in updatePolicy.instanceRedistributionType).
type DistributionPolicy_TargetShape int32

const (
	// A value indicating that the enum field is not set.
	DistributionPolicy_UNDEFINED_TARGET_SHAPE DistributionPolicy_TargetShape = 0
	DistributionPolicy_ANY                    DistributionPolicy_TargetShape = 64972
	DistributionPolicy_BALANCED               DistributionPolicy_TargetShape = 468409608
	DistributionPolicy_EVEN                   DistributionPolicy_TargetShape = 2140442
)

// Enum value maps for DistributionPolicy_TargetShape.
var (
	DistributionPolicy_TargetShape_name = map[int32]string{
		0:         "UNDEFINED_TARGET_SHAPE",
		64972:     "ANY",
		468409608: "BALANCED",
		2140442:   "EVEN",
	}
	DistributionPolicy_TargetShape_value = map[string]int32{
		"UNDEFINED_TARGET_SHAPE": 0,
		"ANY":                    64972,
		"BALANCED":               468409608,
		"EVEN":                   2140442,
	}
)

func (x DistributionPolicy_TargetShape) Enum() *DistributionPolicy_TargetShape {
	p := new(DistributionPolicy_TargetShape)
	*p = x
	return p
}

func (x DistributionPolicy_TargetShape) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DistributionPolicy_TargetShape) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[40].Descriptor()
}

func (DistributionPolicy_TargetShape) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[40]
}

func (x DistributionPolicy_TargetShape) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use DistributionPolicy_TargetShape.Descriptor instead.
func (DistributionPolicy_TargetShape) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{99, 0}
}

// The type of the peering route.
type ExchangedPeeringRoute_Type int32

const (
	// A value indicating that the enum field is not set.
	ExchangedPeeringRoute_UNDEFINED_TYPE        ExchangedPeeringRoute_Type = 0
	ExchangedPeeringRoute_DYNAMIC_PEERING_ROUTE ExchangedPeeringRoute_Type = 469794858
	ExchangedPeeringRoute_STATIC_PEERING_ROUTE  ExchangedPeeringRoute_Type = 473407545
	ExchangedPeeringRoute_SUBNET_PEERING_ROUTE  ExchangedPeeringRoute_Type = 465782504
)

// Enum value maps for ExchangedPeeringRoute_Type.
var (
	ExchangedPeeringRoute_Type_name = map[int32]string{
		0:         "UNDEFINED_TYPE",
		469794858: "DYNAMIC_PEERING_ROUTE",
		473407545: "STATIC_PEERING_ROUTE",
		465782504: "SUBNET_PEERING_ROUTE",
	}
	ExchangedPeeringRoute_Type_value = map[string]int32{
		"UNDEFINED_TYPE":        0,
		"DYNAMIC_PEERING_ROUTE": 469794858,
		"STATIC_PEERING_ROUTE":  473407545,
		"SUBNET_PEERING_ROUTE":  465782504,
	}
)

func (x ExchangedPeeringRoute_Type) Enum() *ExchangedPeeringRoute_Type {
	p := new(ExchangedPeeringRoute_Type)
	*p = x
	return p
}

func (x ExchangedPeeringRoute_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ExchangedPeeringRoute_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[41].Descriptor()
}

func (ExchangedPeeringRoute_Type) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[41]
}

func (x ExchangedPeeringRoute_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ExchangedPeeringRoute_Type.Descriptor instead.
func (ExchangedPeeringRoute_Type) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{100, 0}
}

// Indicates the user-supplied redundancy type of this external VPN gateway.
type ExternalVpnGateway_RedundancyType int32

const (
	// A value indicating that the enum field is not set.
	ExternalVpnGateway_UNDEFINED_REDUNDANCY_TYPE      ExternalVpnGateway_RedundancyType = 0
	ExternalVpnGateway_FOUR_IPS_REDUNDANCY            ExternalVpnGateway_RedundancyType = 520087913
	ExternalVpnGateway_SINGLE_IP_INTERNALLY_REDUNDANT ExternalVpnGateway_RedundancyType = 133914873
	ExternalVpnGateway_TWO_IPS_REDUNDANCY             ExternalVpnGateway_RedundancyType = 367049635
)

// Enum value maps for ExternalVpnGateway_RedundancyType.
var (
	ExternalVpnGateway_RedundancyType_name = map[int32]string{
		0:         "UNDEFINED_REDUNDANCY_TYPE",
		520087913: "FOUR_IPS_REDUNDANCY",
		133914873: "SINGLE_IP_INTERNALLY_REDUNDANT",
		367049635: "TWO_IPS_REDUNDANCY",
	}
	ExternalVpnGateway_RedundancyType_value = map[string]int32{
		"UNDEFINED_REDUNDANCY_TYPE":      0,
		"FOUR_IPS_REDUNDANCY":            520087913,
		"SINGLE_IP_INTERNALLY_REDUNDANT": 133914873,
		"TWO_IPS_REDUNDANCY":             367049635,
	}
)

func (x ExternalVpnGateway_RedundancyType) Enum() *ExternalVpnGateway_RedundancyType {
	p := new(ExternalVpnGateway_RedundancyType)
	*p = x
	return p
}

func (x ExternalVpnGateway_RedundancyType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ExternalVpnGateway_RedundancyType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[42].Descriptor()
}

func (ExternalVpnGateway_RedundancyType) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[42]
}

func (x ExternalVpnGateway_RedundancyType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ExternalVpnGateway_RedundancyType.Descriptor instead.
func (ExternalVpnGateway_RedundancyType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{103, 0}
}

// The file type of source file.
type FileContentBuffer_FileType int32

const (
	// A value indicating that the enum field is not set.
	FileContentBuffer_UNDEFINED_FILE_TYPE FileContentBuffer_FileType = 0
	FileContentBuffer_BIN                 FileContentBuffer_FileType = 65767
	FileContentBuffer_UNDEFINED           FileContentBuffer_FileType = 137851184
	FileContentBuffer_X509                FileContentBuffer_FileType = 2674086
)

// Enum value maps for FileContentBuffer_FileType.
var (
	FileContentBuffer_FileType_name = map[int32]string{
		0:         "UNDEFINED_FILE_TYPE",
		65767:     "BIN",
		137851184: "UNDEFINED",
		2674086:   "X509",
	}
	FileContentBuffer_FileType_value = map[string]int32{
		"UNDEFINED_FILE_TYPE": 0,
		"BIN":                 65767,
		"UNDEFINED":           137851184,
		"X509":                2674086,
	}
)

func (x FileContentBuffer_FileType) Enum() *FileContentBuffer_FileType {
	p := new(FileContentBuffer_FileType)
	*p = x
	return p
}

func (x FileContentBuffer_FileType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (FileContentBuffer_FileType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[43].Descriptor()
}

func (FileContentBuffer_FileType) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[43]
}

func (x FileContentBuffer_FileType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use FileContentBuffer_FileType.Descriptor instead.
func (FileContentBuffer_FileType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{105, 0}
}

// This field can only be specified for a particular firewall rule if logging is enabled for that rule. This field denotes whether to include or exclude metadata for firewall logs.
type FirewallLogConfig_Metadata int32

const (
	// A value indicating that the enum field is not set.
	FirewallLogConfig_UNDEFINED_METADATA   FirewallLogConfig_Metadata = 0
	FirewallLogConfig_EXCLUDE_ALL_METADATA FirewallLogConfig_Metadata = 334519954
	FirewallLogConfig_INCLUDE_ALL_METADATA FirewallLogConfig_Metadata = 164619908
)

// Enum value maps for FirewallLogConfig_Metadata.
var (
	FirewallLogConfig_Metadata_name = map[int32]string{
		0:         "UNDEFINED_METADATA",
		334519954: "EXCLUDE_ALL_METADATA",
		164619908: "INCLUDE_ALL_METADATA",
	}
	FirewallLogConfig_Metadata_value = map[string]int32{
		"UNDEFINED_METADATA":   0,
		"EXCLUDE_ALL_METADATA": 334519954,
		"INCLUDE_ALL_METADATA": 164619908,
	}
)

func (x FirewallLogConfig_Metadata) Enum() *FirewallLogConfig_Metadata {
	p := new(FirewallLogConfig_Metadata)
	*p = x
	return p
}

func (x FirewallLogConfig_Metadata) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (FirewallLogConfig_Metadata) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[44].Descriptor()
}

func (FirewallLogConfig_Metadata) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[44]
}

func (x FirewallLogConfig_Metadata) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use FirewallLogConfig_Metadata.Descriptor instead.
func (FirewallLogConfig_Metadata) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{108, 0}
}

// Direction of traffic to which this firewall applies, either `INGRESS` or `EGRESS`. The default is `INGRESS`. For `INGRESS` traffic, you cannot specify the destinationRanges field, and for `EGRESS` traffic, you cannot specify the sourceRanges or sourceTags fields.
type Firewall_Direction int32

const (
	// A value indicating that the enum field is not set.
	Firewall_UNDEFINED_DIRECTION Firewall_Direction = 0
	Firewall_EGRESS              Firewall_Direction = 432880501
	Firewall_INGRESS             Firewall_Direction = 516931221
)

// Enum value maps for Firewall_Direction.
var (
	Firewall_Direction_name = map[int32]string{
		0:         "UNDEFINED_DIRECTION",
		432880501: "EGRESS",
		516931221: "INGRESS",
	}
	Firewall_Direction_value = map[string]int32{
		"UNDEFINED_DIRECTION": 0,
		"EGRESS":              432880501,
		"INGRESS":             516931221,
	}
)

func (x Firewall_Direction) Enum() *Firewall_Direction {
	p := new(Firewall_Direction)
	*p = x
	return p
}

func (x Firewall_Direction) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Firewall_Direction) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[45].Descriptor()
}

func (Firewall_Direction) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[45]
}

func (x Firewall_Direction) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Firewall_Direction.Descriptor instead.
func (Firewall_Direction) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{109, 0}
}

// The direction in which this rule applies.
type FirewallPolicyRule_Direction int32

const (
	// A value indicating that the enum field is not set.
	FirewallPolicyRule_UNDEFINED_DIRECTION FirewallPolicyRule_Direction = 0
	FirewallPolicyRule_EGRESS              FirewallPolicyRule_Direction = 432880501
	FirewallPolicyRule_INGRESS             FirewallPolicyRule_Direction = 516931221
)

// Enum value maps for FirewallPolicyRule_Direction.
var (
	FirewallPolicyRule_Direction_name = map[int32]string{
		0:         "UNDEFINED_DIRECTION",
		432880501: "EGRESS",
		516931221: "INGRESS",
	}
	FirewallPolicyRule_Direction_value = map[string]int32{
		"UNDEFINED_DIRECTION": 0,
		"EGRESS":              432880501,
		"INGRESS":             516931221,
	}
)

func (x FirewallPolicyRule_Direction) Enum() *FirewallPolicyRule_Direction {
	p := new(FirewallPolicyRule_Direction)
	*p = x
	return p
}

func (x FirewallPolicyRule_Direction) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (FirewallPolicyRule_Direction) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[46].Descriptor()
}

func (FirewallPolicyRule_Direction) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[46]
}

func (x FirewallPolicyRule_Direction) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use FirewallPolicyRule_Direction.Descriptor instead.
func (FirewallPolicyRule_Direction) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{113, 0}
}

// Specifies how individual filterLabel matches within the list of filterLabels contribute towards the overall metadataFilter match.
// Supported values are:
// - MATCH_ANY: At least one of the filterLabels must have a matching label in the provided metadata.
// - MATCH_ALL: All filterLabels must have matching labels in the provided metadata.
type MetadataFilter_FilterMatchCriteria int32

const (
	// A value indicating that the enum field is not set.
	MetadataFilter_UNDEFINED_FILTER_MATCH_CRITERIA MetadataFilter_FilterMatchCriteria = 0
	MetadataFilter_MATCH_ALL                       MetadataFilter_FilterMatchCriteria = 180663271
	MetadataFilter_MATCH_ANY                       MetadataFilter_FilterMatchCriteria = 180663346
	MetadataFilter_NOT_SET                         MetadataFilter_FilterMatchCriteria = 163646646
)

// Enum value maps for MetadataFilter_FilterMatchCriteria.
var (
	MetadataFilter_FilterMatchCriteria_name = map[int32]string{
		0:         "UNDEFINED_FILTER_MATCH_CRITERIA",
		180663271: "MATCH_ALL",
		180663346: "MATCH_ANY",
		163646646: "NOT_SET",
	}
	MetadataFilter_FilterMatchCriteria_value = map[string]int32{
		"UNDEFINED_FILTER_MATCH_CRITERIA": 0,
		"MATCH_ALL":                       180663271,
		"MATCH_ANY":                       180663346,
		"NOT_SET":                         163646646,
	}
)

func (x MetadataFilter_FilterMatchCriteria) Enum() *MetadataFilter_FilterMatchCriteria {
	p := new(MetadataFilter_FilterMatchCriteria)
	*p = x
	return p
}

func (x MetadataFilter_FilterMatchCriteria) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (MetadataFilter_FilterMatchCriteria) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[47].Descriptor()
}

func (MetadataFilter_FilterMatchCriteria) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[47]
}

func (x MetadataFilter_FilterMatchCriteria) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use MetadataFilter_FilterMatchCriteria.Descriptor instead.
func (MetadataFilter_FilterMatchCriteria) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{118, 0}
}

// The IP protocol to which this rule applies.
//
// For protocol forwarding, valid options are TCP, UDP, ESP, AH, SCTP and ICMP.
//
// The valid IP protocols are different for different load balancing products:
// - Internal TCP/UDP Load Balancing: The load balancing scheme is INTERNAL, and one of TCP, UDP or ALL is valid.
// - Traffic Director: The load balancing scheme is INTERNAL_SELF_MANAGED, and only TCP is valid.
// - Internal HTTP(S) Load Balancing: The load balancing scheme is INTERNAL_MANAGED, and only TCP is valid.
// - HTTP(S), SSL Proxy, and TCP Proxy Load Balancing: The load balancing scheme is EXTERNAL and only TCP is valid.
// - Network Load Balancing: The load balancing scheme is EXTERNAL, and one of TCP or UDP is valid.
type ForwardingRule_IPProtocol int32

const (
	// A value indicating that the enum field is not set.
	ForwardingRule_UNDEFINED_I_P_PROTOCOL ForwardingRule_IPProtocol = 0
	ForwardingRule_AH                     ForwardingRule_IPProtocol = 2087
	ForwardingRule_ESP                    ForwardingRule_IPProtocol = 68962
	ForwardingRule_ICMP                   ForwardingRule_IPProtocol = 2241597
	ForwardingRule_SCTP                   ForwardingRule_IPProtocol = 2539724
	ForwardingRule_TCP                    ForwardingRule_IPProtocol = 82881
	ForwardingRule_UDP                    ForwardingRule_IPProtocol = 83873
)

// Enum value maps for ForwardingRule_IPProtocol.
var (
	ForwardingRule_IPProtocol_name = map[int32]string{
		0:       "UNDEFINED_I_P_PROTOCOL",
		2087:    "AH",
		68962:   "ESP",
		2241597: "ICMP",
		2539724: "SCTP",
		82881:   "TCP",
		83873:   "UDP",
	}
	ForwardingRule_IPProtocol_value = map[string]int32{
		"UNDEFINED_I_P_PROTOCOL": 0,
		"AH":                     2087,
		"ESP":                    68962,
		"ICMP":                   2241597,
		"SCTP":                   2539724,
		"TCP":                    82881,
		"UDP":                    83873,
	}
)

func (x ForwardingRule_IPProtocol) Enum() *ForwardingRule_IPProtocol {
	p := new(ForwardingRule_IPProtocol)
	*p = x
	return p
}

func (x ForwardingRule_IPProtocol) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ForwardingRule_IPProtocol) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[48].Descriptor()
}

func (ForwardingRule_IPProtocol) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[48]
}

func (x ForwardingRule_IPProtocol) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ForwardingRule_IPProtocol.Descriptor instead.
func (ForwardingRule_IPProtocol) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{120, 0}
}

// The IP Version that will be used by this forwarding rule. Valid options are IPV4 or IPV6. This can only be specified for an external global forwarding rule.
type ForwardingRule_IpVersion int32

const (
	// A value indicating that the enum field is not set.
	ForwardingRule_UNDEFINED_IP_VERSION ForwardingRule_IpVersion = 0
	ForwardingRule_IPV4                 ForwardingRule_IpVersion = 2254341
	ForwardingRule_IPV6                 ForwardingRule_IpVersion = 2254343
	ForwardingRule_UNSPECIFIED_VERSION  ForwardingRule_IpVersion = 21850000
)

// Enum value maps for ForwardingRule_IpVersion.
var (
	ForwardingRule_IpVersion_name = map[int32]string{
		0:        "UNDEFINED_IP_VERSION",
		2254341:  "IPV4",
		2254343:  "IPV6",
		21850000: "UNSPECIFIED_VERSION",
	}
	ForwardingRule_IpVersion_value = map[string]int32{
		"UNDEFINED_IP_VERSION": 0,
		"IPV4":                 2254341,
		"IPV6":                 2254343,
		"UNSPECIFIED_VERSION":  21850000,
	}
)

func (x ForwardingRule_IpVersion) Enum() *ForwardingRule_IpVersion {
	p := new(ForwardingRule_IpVersion)
	*p = x
	return p
}

func (x ForwardingRule_IpVersion) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ForwardingRule_IpVersion) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[49].Descriptor()
}

func (ForwardingRule_IpVersion) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[49]
}

func (x ForwardingRule_IpVersion) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ForwardingRule_IpVersion.Descriptor instead.
func (ForwardingRule_IpVersion) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{120, 1}
}

// Specifies the forwarding rule type.
//
//
// - EXTERNAL is used for:
// - Classic Cloud VPN gateways
// - Protocol forwarding to VMs from an external IP address
// - HTTP(S), SSL Proxy, TCP Proxy, and Network Load Balancing
// - INTERNAL is used for:
// - Protocol forwarding to VMs from an internal IP address
// - Internal TCP/UDP Load Balancing
// - INTERNAL_MANAGED is used for:
// - Internal HTTP(S) Load Balancing
// - INTERNAL_SELF_MANAGED is used for:
// - Traffic Director
//
// For more information about forwarding rules, refer to Forwarding rule concepts.
type ForwardingRule_LoadBalancingScheme int32

const (
	// A value indicating that the enum field is not set.
	ForwardingRule_UNDEFINED_LOAD_BALANCING_SCHEME ForwardingRule_LoadBalancingScheme = 0
	ForwardingRule_EXTERNAL                        ForwardingRule_LoadBalancingScheme = 35607499
	ForwardingRule_INTERNAL                        ForwardingRule_LoadBalancingScheme = 279295677
	ForwardingRule_INTERNAL_MANAGED                ForwardingRule_LoadBalancingScheme = 37350397
	ForwardingRule_INTERNAL_SELF_MANAGED           ForwardingRule_LoadBalancingScheme = 236211150
	ForwardingRule_INVALID                         ForwardingRule_LoadBalancingScheme = 530283991
)

// Enum value maps for ForwardingRule_LoadBalancingScheme.
var (
	ForwardingRule_LoadBalancingScheme_name = map[int32]string{
		0:         "UNDEFINED_LOAD_BALANCING_SCHEME",
		35607499:  "EXTERNAL",
		279295677: "INTERNAL",
		37350397:  "INTERNAL_MANAGED",
		236211150: "INTERNAL_SELF_MANAGED",
		530283991: "INVALID",
	}
	ForwardingRule_LoadBalancingScheme_value = map[string]int32{
		"UNDEFINED_LOAD_BALANCING_SCHEME": 0,
		"EXTERNAL":                        35607499,
		"INTERNAL":                        279295677,
		"INTERNAL_MANAGED":                37350397,
		"INTERNAL_SELF_MANAGED":           236211150,
		"INVALID":                         530283991,
	}
)

func (x ForwardingRule_LoadBalancingScheme) Enum() *ForwardingRule_LoadBalancingScheme {
	p := new(ForwardingRule_LoadBalancingScheme)
	*p = x
	return p
}

func (x ForwardingRule_LoadBalancingScheme) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ForwardingRule_LoadBalancingScheme) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[50].Descriptor()
}

func (ForwardingRule_LoadBalancingScheme) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[50]
}

func (x ForwardingRule_LoadBalancingScheme) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ForwardingRule_LoadBalancingScheme.Descriptor instead.
func (ForwardingRule_LoadBalancingScheme) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{120, 2}
}

// This signifies the networking tier used for configuring this load balancer and can only take the following values: PREMIUM, STANDARD.
//
// For regional ForwardingRule, the valid values are PREMIUM and STANDARD. For GlobalForwardingRule, the valid value is PREMIUM.
//
// If this field is not specified, it is assumed to be PREMIUM. If IPAddress is specified, this value must be equal to the networkTier of the Address.
type ForwardingRule_NetworkTier int32

const (
	// A value indicating that the enum field is not set.
	ForwardingRule_UNDEFINED_NETWORK_TIER ForwardingRule_NetworkTier = 0
	ForwardingRule_PREMIUM                ForwardingRule_NetworkTier = 399530551
	ForwardingRule_STANDARD               ForwardingRule_NetworkTier = 484642493
)

// Enum value maps for ForwardingRule_NetworkTier.
var (
	ForwardingRule_NetworkTier_name = map[int32]string{
		0:         "UNDEFINED_NETWORK_TIER",
		399530551: "PREMIUM",
		484642493: "STANDARD",
	}
	ForwardingRule_NetworkTier_value = map[string]int32{
		"UNDEFINED_NETWORK_TIER": 0,
		"PREMIUM":                399530551,
		"STANDARD":               484642493,
	}
)

func (x ForwardingRule_NetworkTier) Enum() *ForwardingRule_NetworkTier {
	p := new(ForwardingRule_NetworkTier)
	*p = x
	return p
}

func (x ForwardingRule_NetworkTier) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ForwardingRule_NetworkTier) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[51].Descriptor()
}

func (ForwardingRule_NetworkTier) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[51]
}

func (x ForwardingRule_NetworkTier) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ForwardingRule_NetworkTier.Descriptor instead.
func (ForwardingRule_NetworkTier) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{120, 3}
}

// Specifies how port is selected for health checking, can be one of following values:
// USE_FIXED_PORT: The port number in port is used for health checking.
// USE_NAMED_PORT: The portName is used for health checking.
// USE_SERVING_PORT: For NetworkEndpointGroup, the port specified for each network endpoint is used for health checking. For other backends, the port or named port specified in the Backend Service is used for health checking.
//
//
// If not specified, gRPC health check follows behavior specified in port and portName fields.
type GRPCHealthCheck_PortSpecification int32

const (
	// A value indicating that the enum field is not set.
	GRPCHealthCheck_UNDEFINED_PORT_SPECIFICATION GRPCHealthCheck_PortSpecification = 0
	GRPCHealthCheck_USE_FIXED_PORT               GRPCHealthCheck_PortSpecification = 190235748
	GRPCHealthCheck_USE_NAMED_PORT               GRPCHealthCheck_PortSpecification = 349300671
	GRPCHealthCheck_USE_SERVING_PORT             GRPCHealthCheck_PortSpecification = 362637516
)

// Enum value maps for GRPCHealthCheck_PortSpecification.
var (
	GRPCHealthCheck_PortSpecification_name = map[int32]string{
		0:         "UNDEFINED_PORT_SPECIFICATION",
		190235748: "USE_FIXED_PORT",
		349300671: "USE_NAMED_PORT",
		362637516: "USE_SERVING_PORT",
	}
	GRPCHealthCheck_PortSpecification_value = map[string]int32{
		"UNDEFINED_PORT_SPECIFICATION": 0,
		"USE_FIXED_PORT":               190235748,
		"USE_NAMED_PORT":               349300671,
		"USE_SERVING_PORT":             362637516,
	}
)

func (x GRPCHealthCheck_PortSpecification) Enum() *GRPCHealthCheck_PortSpecification {
	p := new(GRPCHealthCheck_PortSpecification)
	*p = x
	return p
}

func (x GRPCHealthCheck_PortSpecification) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (GRPCHealthCheck_PortSpecification) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[52].Descriptor()
}

func (GRPCHealthCheck_PortSpecification) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[52]
}

func (x GRPCHealthCheck_PortSpecification) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use GRPCHealthCheck_PortSpecification.Descriptor instead.
func (GRPCHealthCheck_PortSpecification) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{125, 0}
}

// Specifies how port is selected for health checking, can be one of following values:
// USE_FIXED_PORT: The port number in port is used for health checking.
// USE_NAMED_PORT: The portName is used for health checking.
// USE_SERVING_PORT: For NetworkEndpointGroup, the port specified for each network endpoint is used for health checking. For other backends, the port or named port specified in the Backend Service is used for health checking.
//
//
// If not specified, HTTP2 health check follows behavior specified in port and portName fields.
type HTTP2HealthCheck_PortSpecification int32

const (
	// A value indicating that the enum field is not set.
	HTTP2HealthCheck_UNDEFINED_PORT_SPECIFICATION HTTP2HealthCheck_PortSpecification = 0
	HTTP2HealthCheck_USE_FIXED_PORT               HTTP2HealthCheck_PortSpecification = 190235748
	HTTP2HealthCheck_USE_NAMED_PORT               HTTP2HealthCheck_PortSpecification = 349300671
	HTTP2HealthCheck_USE_SERVING_PORT             HTTP2HealthCheck_PortSpecification = 362637516
)

// Enum value maps for HTTP2HealthCheck_PortSpecification.
var (
	HTTP2HealthCheck_PortSpecification_name = map[int32]string{
		0:         "UNDEFINED_PORT_SPECIFICATION",
		190235748: "USE_FIXED_PORT",
		349300671: "USE_NAMED_PORT",
		362637516: "USE_SERVING_PORT",
	}
	HTTP2HealthCheck_PortSpecification_value = map[string]int32{
		"UNDEFINED_PORT_SPECIFICATION": 0,
		"USE_FIXED_PORT":               190235748,
		"USE_NAMED_PORT":               349300671,
		"USE_SERVING_PORT":             362637516,
	}
)

func (x HTTP2HealthCheck_PortSpecification) Enum() *HTTP2HealthCheck_PortSpecification {
	p := new(HTTP2HealthCheck_PortSpecification)
	*p = x
	return p
}

func (x HTTP2HealthCheck_PortSpecification) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (HTTP2HealthCheck_PortSpecification) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[53].Descriptor()
}

func (HTTP2HealthCheck_PortSpecification) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[53]
}

func (x HTTP2HealthCheck_PortSpecification) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use HTTP2HealthCheck_PortSpecification.Descriptor instead.
func (HTTP2HealthCheck_PortSpecification) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{136, 0}
}

// Specifies the type of proxy header to append before sending data to the backend, either NONE or PROXY_V1. The default is NONE.
type HTTP2HealthCheck_ProxyHeader int32

const (
	// A value indicating that the enum field is not set.
	HTTP2HealthCheck_UNDEFINED_PROXY_HEADER HTTP2HealthCheck_ProxyHeader = 0
	HTTP2HealthCheck_NONE                   HTTP2HealthCheck_ProxyHeader = 2402104
	HTTP2HealthCheck_PROXY_V1               HTTP2HealthCheck_ProxyHeader = 334352940
)

// Enum value maps for HTTP2HealthCheck_ProxyHeader.
var (
	HTTP2HealthCheck_ProxyHeader_name = map[int32]string{
		0:         "UNDEFINED_PROXY_HEADER",
		2402104:   "NONE",
		334352940: "PROXY_V1",
	}
	HTTP2HealthCheck_ProxyHeader_value = map[string]int32{
		"UNDEFINED_PROXY_HEADER": 0,
		"NONE":                   2402104,
		"PROXY_V1":               334352940,
	}
)

func (x HTTP2HealthCheck_ProxyHeader) Enum() *HTTP2HealthCheck_ProxyHeader {
	p := new(HTTP2HealthCheck_ProxyHeader)
	*p = x
	return p
}

func (x HTTP2HealthCheck_ProxyHeader) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (HTTP2HealthCheck_ProxyHeader) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[54].Descriptor()
}

func (HTTP2HealthCheck_ProxyHeader) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[54]
}

func (x HTTP2HealthCheck_ProxyHeader) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use HTTP2HealthCheck_ProxyHeader.Descriptor instead.
func (HTTP2HealthCheck_ProxyHeader) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{136, 1}
}

// Specifies how port is selected for health checking, can be one of following values:
// USE_FIXED_PORT: The port number in port is used for health checking.
// USE_NAMED_PORT: The portName is used for health checking.
// USE_SERVING_PORT: For NetworkEndpointGroup, the port specified for each network endpoint is used for health checking. For other backends, the port or named port specified in the Backend Service is used for health checking.
//
//
// If not specified, HTTP health check follows behavior specified in port and portName fields.
type HTTPHealthCheck_PortSpecification int32

const (
	// A value indicating that the enum field is not set.
	HTTPHealthCheck_UNDEFINED_PORT_SPECIFICATION HTTPHealthCheck_PortSpecification = 0
	HTTPHealthCheck_USE_FIXED_PORT               HTTPHealthCheck_PortSpecification = 190235748
	HTTPHealthCheck_USE_NAMED_PORT               HTTPHealthCheck_PortSpecification = 349300671
	HTTPHealthCheck_USE_SERVING_PORT             HTTPHealthCheck_PortSpecification = 362637516
)

// Enum value maps for HTTPHealthCheck_PortSpecification.
var (
	HTTPHealthCheck_PortSpecification_name = map[int32]string{
		0:         "UNDEFINED_PORT_SPECIFICATION",
		190235748: "USE_FIXED_PORT",
		349300671: "USE_NAMED_PORT",
		362637516: "USE_SERVING_PORT",
	}
	HTTPHealthCheck_PortSpecification_value = map[string]int32{
		"UNDEFINED_PORT_SPECIFICATION": 0,
		"USE_FIXED_PORT":               190235748,
		"USE_NAMED_PORT":               349300671,
		"USE_SERVING_PORT":             362637516,
	}
)

func (x HTTPHealthCheck_PortSpecification) Enum() *HTTPHealthCheck_PortSpecification {
	p := new(HTTPHealthCheck_PortSpecification)
	*p = x
	return p
}

func (x HTTPHealthCheck_PortSpecification) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (HTTPHealthCheck_PortSpecification) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[55].Descriptor()
}

func (HTTPHealthCheck_PortSpecification) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[55]
}

func (x HTTPHealthCheck_PortSpecification) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use HTTPHealthCheck_PortSpecification.Descriptor instead.
func (HTTPHealthCheck_PortSpecification) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{137, 0}
}

// Specifies the type of proxy header to append before sending data to the backend, either NONE or PROXY_V1. The default is NONE.
type HTTPHealthCheck_ProxyHeader int32

const (
	// A value indicating that the enum field is not set.
	HTTPHealthCheck_UNDEFINED_PROXY_HEADER HTTPHealthCheck_ProxyHeader = 0
	HTTPHealthCheck_NONE                   HTTPHealthCheck_ProxyHeader = 2402104
	HTTPHealthCheck_PROXY_V1               HTTPHealthCheck_ProxyHeader = 334352940
)

// Enum value maps for HTTPHealthCheck_ProxyHeader.
var (
	HTTPHealthCheck_ProxyHeader_name = map[int32]string{
		0:         "UNDEFINED_PROXY_HEADER",
		2402104:   "NONE",
		334352940: "PROXY_V1",
	}
	HTTPHealthCheck_ProxyHeader_value = map[string]int32{
		"UNDEFINED_PROXY_HEADER": 0,
		"NONE":                   2402104,
		"PROXY_V1":               334352940,
	}
)

func (x HTTPHealthCheck_ProxyHeader) Enum() *HTTPHealthCheck_ProxyHeader {
	p := new(HTTPHealthCheck_ProxyHeader)
	*p = x
	return p
}

func (x HTTPHealthCheck_ProxyHeader) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (HTTPHealthCheck_ProxyHeader) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[56].Descriptor()
}

func (HTTPHealthCheck_ProxyHeader) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[56]
}

func (x HTTPHealthCheck_ProxyHeader) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use HTTPHealthCheck_ProxyHeader.Descriptor instead.
func (HTTPHealthCheck_ProxyHeader) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{137, 1}
}

// Specifies how port is selected for health checking, can be one of following values:
// USE_FIXED_PORT: The port number in port is used for health checking.
// USE_NAMED_PORT: The portName is used for health checking.
// USE_SERVING_PORT: For NetworkEndpointGroup, the port specified for each network endpoint is used for health checking. For other backends, the port or named port specified in the Backend Service is used for health checking.
//
//
// If not specified, HTTPS health check follows behavior specified in port and portName fields.
type HTTPSHealthCheck_PortSpecification int32

const (
	// A value indicating that the enum field is not set.
	HTTPSHealthCheck_UNDEFINED_PORT_SPECIFICATION HTTPSHealthCheck_PortSpecification = 0
	HTTPSHealthCheck_USE_FIXED_PORT               HTTPSHealthCheck_PortSpecification = 190235748
	HTTPSHealthCheck_USE_NAMED_PORT               HTTPSHealthCheck_PortSpecification = 349300671
	HTTPSHealthCheck_USE_SERVING_PORT             HTTPSHealthCheck_PortSpecification = 362637516
)

// Enum value maps for HTTPSHealthCheck_PortSpecification.
var (
	HTTPSHealthCheck_PortSpecification_name = map[int32]string{
		0:         "UNDEFINED_PORT_SPECIFICATION",
		190235748: "USE_FIXED_PORT",
		349300671: "USE_NAMED_PORT",
		362637516: "USE_SERVING_PORT",
	}
	HTTPSHealthCheck_PortSpecification_value = map[string]int32{
		"UNDEFINED_PORT_SPECIFICATION": 0,
		"USE_FIXED_PORT":               190235748,
		"USE_NAMED_PORT":               349300671,
		"USE_SERVING_PORT":             362637516,
	}
)

func (x HTTPSHealthCheck_PortSpecification) Enum() *HTTPSHealthCheck_PortSpecification {
	p := new(HTTPSHealthCheck_PortSpecification)
	*p = x
	return p
}

func (x HTTPSHealthCheck_PortSpecification) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (HTTPSHealthCheck_PortSpecification) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[57].Descriptor()
}

func (HTTPSHealthCheck_PortSpecification) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[57]
}

func (x HTTPSHealthCheck_PortSpecification) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use HTTPSHealthCheck_PortSpecification.Descriptor instead.
func (HTTPSHealthCheck_PortSpecification) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{138, 0}
}

// Specifies the type of proxy header to append before sending data to the backend, either NONE or PROXY_V1. The default is NONE.
type HTTPSHealthCheck_ProxyHeader int32

const (
	// A value indicating that the enum field is not set.
	HTTPSHealthCheck_UNDEFINED_PROXY_HEADER HTTPSHealthCheck_ProxyHeader = 0
	HTTPSHealthCheck_NONE                   HTTPSHealthCheck_ProxyHeader = 2402104
	HTTPSHealthCheck_PROXY_V1               HTTPSHealthCheck_ProxyHeader = 334352940
)

// Enum value maps for HTTPSHealthCheck_ProxyHeader.
var (
	HTTPSHealthCheck_ProxyHeader_name = map[int32]string{
		0:         "UNDEFINED_PROXY_HEADER",
		2402104:   "NONE",
		334352940: "PROXY_V1",
	}
	HTTPSHealthCheck_ProxyHeader_value = map[string]int32{
		"UNDEFINED_PROXY_HEADER": 0,
		"NONE":                   2402104,
		"PROXY_V1":               334352940,
	}
)

func (x HTTPSHealthCheck_ProxyHeader) Enum() *HTTPSHealthCheck_ProxyHeader {
	p := new(HTTPSHealthCheck_ProxyHeader)
	*p = x
	return p
}

func (x HTTPSHealthCheck_ProxyHeader) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (HTTPSHealthCheck_ProxyHeader) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[58].Descriptor()
}

func (HTTPSHealthCheck_ProxyHeader) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[58]
}

func (x HTTPSHealthCheck_ProxyHeader) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use HTTPSHealthCheck_ProxyHeader.Descriptor instead.
func (HTTPSHealthCheck_ProxyHeader) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{138, 1}
}

// Specifies how port is selected for health checking, can be one of following values:
// USE_FIXED_PORT: The port number in port is used for health checking.
// USE_NAMED_PORT: The portName is used for health checking.
// USE_SERVING_PORT: For NetworkEndpointGroup, the port specified for each network endpoint is used for health checking. For other backends, the port or named port specified in the Backend Service is used for health checking.
//
//
// If not specified, SSL health check follows behavior specified in port and portName fields.
type SSLHealthCheck_PortSpecification int32

const (
	// A value indicating that the enum field is not set.
	SSLHealthCheck_UNDEFINED_PORT_SPECIFICATION SSLHealthCheck_PortSpecification = 0
	SSLHealthCheck_USE_FIXED_PORT               SSLHealthCheck_PortSpecification = 190235748
	SSLHealthCheck_USE_NAMED_PORT               SSLHealthCheck_PortSpecification = 349300671
	SSLHealthCheck_USE_SERVING_PORT             SSLHealthCheck_PortSpecification = 362637516
)

// Enum value maps for SSLHealthCheck_PortSpecification.
var (
	SSLHealthCheck_PortSpecification_name = map[int32]string{
		0:         "UNDEFINED_PORT_SPECIFICATION",
		190235748: "USE_FIXED_PORT",
		349300671: "USE_NAMED_PORT",
		362637516: "USE_SERVING_PORT",
	}
	SSLHealthCheck_PortSpecification_value = map[string]int32{
		"UNDEFINED_PORT_SPECIFICATION": 0,
		"USE_FIXED_PORT":               190235748,
		"USE_NAMED_PORT":               349300671,
		"USE_SERVING_PORT":             362637516,
	}
)

func (x SSLHealthCheck_PortSpecification) Enum() *SSLHealthCheck_PortSpecification {
	p := new(SSLHealthCheck_PortSpecification)
	*p = x
	return p
}

func (x SSLHealthCheck_PortSpecification) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SSLHealthCheck_PortSpecification) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[59].Descriptor()
}

func (SSLHealthCheck_PortSpecification) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[59]
}

func (x SSLHealthCheck_PortSpecification) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SSLHealthCheck_PortSpecification.Descriptor instead.
func (SSLHealthCheck_PortSpecification) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{140, 0}
}

// Specifies the type of proxy header to append before sending data to the backend, either NONE or PROXY_V1. The default is NONE.
type SSLHealthCheck_ProxyHeader int32

const (
	// A value indicating that the enum field is not set.
	SSLHealthCheck_UNDEFINED_PROXY_HEADER SSLHealthCheck_ProxyHeader = 0
	SSLHealthCheck_NONE                   SSLHealthCheck_ProxyHeader = 2402104
	SSLHealthCheck_PROXY_V1               SSLHealthCheck_ProxyHeader = 334352940
)

// Enum value maps for SSLHealthCheck_ProxyHeader.
var (
	SSLHealthCheck_ProxyHeader_name = map[int32]string{
		0:         "UNDEFINED_PROXY_HEADER",
		2402104:   "NONE",
		334352940: "PROXY_V1",
	}
	SSLHealthCheck_ProxyHeader_value = map[string]int32{
		"UNDEFINED_PROXY_HEADER": 0,
		"NONE":                   2402104,
		"PROXY_V1":               334352940,
	}
)

func (x SSLHealthCheck_ProxyHeader) Enum() *SSLHealthCheck_ProxyHeader {
	p := new(SSLHealthCheck_ProxyHeader)
	*p = x
	return p
}

func (x SSLHealthCheck_ProxyHeader) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SSLHealthCheck_ProxyHeader) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[60].Descriptor()
}

func (SSLHealthCheck_ProxyHeader) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[60]
}

func (x SSLHealthCheck_ProxyHeader) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SSLHealthCheck_ProxyHeader.Descriptor instead.
func (SSLHealthCheck_ProxyHeader) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{140, 1}
}

// Specifies how port is selected for health checking, can be one of following values:
// USE_FIXED_PORT: The port number in port is used for health checking.
// USE_NAMED_PORT: The portName is used for health checking.
// USE_SERVING_PORT: For NetworkEndpointGroup, the port specified for each network endpoint is used for health checking. For other backends, the port or named port specified in the Backend Service is used for health checking.
//
//
// If not specified, TCP health check follows behavior specified in port and portName fields.
type TCPHealthCheck_PortSpecification int32

const (
	// A value indicating that the enum field is not set.
	TCPHealthCheck_UNDEFINED_PORT_SPECIFICATION TCPHealthCheck_PortSpecification = 0
	TCPHealthCheck_USE_FIXED_PORT               TCPHealthCheck_PortSpecification = 190235748
	TCPHealthCheck_USE_NAMED_PORT               TCPHealthCheck_PortSpecification = 349300671
	TCPHealthCheck_USE_SERVING_PORT             TCPHealthCheck_PortSpecification = 362637516
)

// Enum value maps for TCPHealthCheck_PortSpecification.
var (
	TCPHealthCheck_PortSpecification_name = map[int32]string{
		0:         "UNDEFINED_PORT_SPECIFICATION",
		190235748: "USE_FIXED_PORT",
		349300671: "USE_NAMED_PORT",
		362637516: "USE_SERVING_PORT",
	}
	TCPHealthCheck_PortSpecification_value = map[string]int32{
		"UNDEFINED_PORT_SPECIFICATION": 0,
		"USE_FIXED_PORT":               190235748,
		"USE_NAMED_PORT":               349300671,
		"USE_SERVING_PORT":             362637516,
	}
)

func (x TCPHealthCheck_PortSpecification) Enum() *TCPHealthCheck_PortSpecification {
	p := new(TCPHealthCheck_PortSpecification)
	*p = x
	return p
}

func (x TCPHealthCheck_PortSpecification) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (TCPHealthCheck_PortSpecification) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[61].Descriptor()
}

func (TCPHealthCheck_PortSpecification) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[61]
}

func (x TCPHealthCheck_PortSpecification) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use TCPHealthCheck_PortSpecification.Descriptor instead.
func (TCPHealthCheck_PortSpecification) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{141, 0}
}

// Specifies the type of proxy header to append before sending data to the backend, either NONE or PROXY_V1. The default is NONE.
type TCPHealthCheck_ProxyHeader int32

const (
	// A value indicating that the enum field is not set.
	TCPHealthCheck_UNDEFINED_PROXY_HEADER TCPHealthCheck_ProxyHeader = 0
	TCPHealthCheck_NONE                   TCPHealthCheck_ProxyHeader = 2402104
	TCPHealthCheck_PROXY_V1               TCPHealthCheck_ProxyHeader = 334352940
)

// Enum value maps for TCPHealthCheck_ProxyHeader.
var (
	TCPHealthCheck_ProxyHeader_name = map[int32]string{
		0:         "UNDEFINED_PROXY_HEADER",
		2402104:   "NONE",
		334352940: "PROXY_V1",
	}
	TCPHealthCheck_ProxyHeader_value = map[string]int32{
		"UNDEFINED_PROXY_HEADER": 0,
		"NONE":                   2402104,
		"PROXY_V1":               334352940,
	}
)

func (x TCPHealthCheck_ProxyHeader) Enum() *TCPHealthCheck_ProxyHeader {
	p := new(TCPHealthCheck_ProxyHeader)
	*p = x
	return p
}

func (x TCPHealthCheck_ProxyHeader) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (TCPHealthCheck_ProxyHeader) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[62].Descriptor()
}

func (TCPHealthCheck_ProxyHeader) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[62]
}

func (x TCPHealthCheck_ProxyHeader) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use TCPHealthCheck_ProxyHeader.Descriptor instead.
func (TCPHealthCheck_ProxyHeader) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{141, 1}
}

// Specifies the type of the healthCheck, either TCP, SSL, HTTP, HTTPS or HTTP2. If not specified, the default is TCP. Exactly one of the protocol-specific health check field must be specified, which must match type field.
type HealthCheck_Type int32

const (
	// A value indicating that the enum field is not set.
	HealthCheck_UNDEFINED_TYPE HealthCheck_Type = 0
	HealthCheck_GRPC           HealthCheck_Type = 2196510
	HealthCheck_HTTP           HealthCheck_Type = 2228360
	HealthCheck_HTTP2          HealthCheck_Type = 69079210
	HealthCheck_HTTPS          HealthCheck_Type = 69079243
	HealthCheck_INVALID        HealthCheck_Type = 530283991
	HealthCheck_SSL            HealthCheck_Type = 82412
	HealthCheck_TCP            HealthCheck_Type = 82881
)

// Enum value maps for HealthCheck_Type.
var (
	HealthCheck_Type_name = map[int32]string{
		0:         "UNDEFINED_TYPE",
		2196510:   "GRPC",
		2228360:   "HTTP",
		69079210:  "HTTP2",
		69079243:  "HTTPS",
		530283991: "INVALID",
		82412:     "SSL",
		82881:     "TCP",
	}
	HealthCheck_Type_value = map[string]int32{
		"UNDEFINED_TYPE": 0,
		"GRPC":           2196510,
		"HTTP":           2228360,
		"HTTP2":          69079210,
		"HTTPS":          69079243,
		"INVALID":        530283991,
		"SSL":            82412,
		"TCP":            82881,
	}
)

func (x HealthCheck_Type) Enum() *HealthCheck_Type {
	p := new(HealthCheck_Type)
	*p = x
	return p
}

func (x HealthCheck_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (HealthCheck_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[63].Descriptor()
}

func (HealthCheck_Type) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[63]
}

func (x HealthCheck_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use HealthCheck_Type.Descriptor instead.
func (HealthCheck_Type) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{142, 0}
}

// Optional. Policy for how the results from multiple health checks for the same endpoint are aggregated. Defaults to NO_AGGREGATION if unspecified.
// - NO_AGGREGATION. An EndpointHealth message is returned for each backend in the health check service.
// - AND. If any backend's health check reports UNHEALTHY, then UNHEALTHY is the HealthState of the entire health check service. If all backend's are healthy, the HealthState of the health check service is HEALTHY. .
type HealthCheckService_HealthStatusAggregationPolicy int32

const (
	// A value indicating that the enum field is not set.
	HealthCheckService_UNDEFINED_HEALTH_STATUS_AGGREGATION_POLICY HealthCheckService_HealthStatusAggregationPolicy = 0
	HealthCheckService_AND                                        HealthCheckService_HealthStatusAggregationPolicy = 64951
	HealthCheckService_NO_AGGREGATION                             HealthCheckService_HealthStatusAggregationPolicy = 426445124
)

// Enum value maps for HealthCheckService_HealthStatusAggregationPolicy.
var (
	HealthCheckService_HealthStatusAggregationPolicy_name = map[int32]string{
		0:         "UNDEFINED_HEALTH_STATUS_AGGREGATION_POLICY",
		64951:     "AND",
		426445124: "NO_AGGREGATION",
	}
	HealthCheckService_HealthStatusAggregationPolicy_value = map[string]int32{
		"UNDEFINED_HEALTH_STATUS_AGGREGATION_POLICY": 0,
		"AND":            64951,
		"NO_AGGREGATION": 426445124,
	}
)

func (x HealthCheckService_HealthStatusAggregationPolicy) Enum() *HealthCheckService_HealthStatusAggregationPolicy {
	p := new(HealthCheckService_HealthStatusAggregationPolicy)
	*p = x
	return p
}

func (x HealthCheckService_HealthStatusAggregationPolicy) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (HealthCheckService_HealthStatusAggregationPolicy) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[64].Descriptor()
}

func (HealthCheckService_HealthStatusAggregationPolicy) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[64]
}

func (x HealthCheckService_HealthStatusAggregationPolicy) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use HealthCheckService_HealthStatusAggregationPolicy.Descriptor instead.
func (HealthCheckService_HealthStatusAggregationPolicy) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{145, 0}
}

// Health state of the network endpoint determined based on the health checks configured.
type HealthStatusForNetworkEndpoint_HealthState int32

const (
	// A value indicating that the enum field is not set.
	HealthStatusForNetworkEndpoint_UNDEFINED_HEALTH_STATE HealthStatusForNetworkEndpoint_HealthState = 0
	HealthStatusForNetworkEndpoint_DRAINING               HealthStatusForNetworkEndpoint_HealthState = 480455402
	HealthStatusForNetworkEndpoint_HEALTHY                HealthStatusForNetworkEndpoint_HealthState = 439801213
	HealthStatusForNetworkEndpoint_UNHEALTHY              HealthStatusForNetworkEndpoint_HealthState = 462118084
	HealthStatusForNetworkEndpoint_UNKNOWN                HealthStatusForNetworkEndpoint_HealthState = 433141802
)

// Enum value maps for HealthStatusForNetworkEndpoint_HealthState.
var (
	HealthStatusForNetworkEndpoint_HealthState_name = map[int32]string{
		0:         "UNDEFINED_HEALTH_STATE",
		480455402: "DRAINING",
		439801213: "HEALTHY",
		462118084: "UNHEALTHY",
		433141802: "UNKNOWN",
	}
	HealthStatusForNetworkEndpoint_HealthState_value = map[string]int32{
		"UNDEFINED_HEALTH_STATE": 0,
		"DRAINING":               480455402,
		"HEALTHY":                439801213,
		"UNHEALTHY":              462118084,
		"UNKNOWN":                433141802,
	}
)

func (x HealthStatusForNetworkEndpoint_HealthState) Enum() *HealthStatusForNetworkEndpoint_HealthState {
	p := new(HealthStatusForNetworkEndpoint_HealthState)
	*p = x
	return p
}

func (x HealthStatusForNetworkEndpoint_HealthState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (HealthStatusForNetworkEndpoint_HealthState) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[65].Descriptor()
}

func (HealthStatusForNetworkEndpoint_HealthState) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[65]
}

func (x HealthStatusForNetworkEndpoint_HealthState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use HealthStatusForNetworkEndpoint_HealthState.Descriptor instead.
func (HealthStatusForNetworkEndpoint_HealthState) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{150, 0}
}

// The HTTP Status code to use for this RedirectAction.
// Supported values are:
// - MOVED_PERMANENTLY_DEFAULT, which is the default value and corresponds to 301.
// - FOUND, which corresponds to 302.
// - SEE_OTHER which corresponds to 303.
// - TEMPORARY_REDIRECT, which corresponds to 307. In this case, the request method will be retained.
// - PERMANENT_REDIRECT, which corresponds to 308. In this case, the request method will be retained.
type HttpRedirectAction_RedirectResponseCode int32

const (
	// A value indicating that the enum field is not set.
	HttpRedirectAction_UNDEFINED_REDIRECT_RESPONSE_CODE HttpRedirectAction_RedirectResponseCode = 0
	HttpRedirectAction_FOUND                            HttpRedirectAction_RedirectResponseCode = 67084130
	HttpRedirectAction_MOVED_PERMANENTLY_DEFAULT        HttpRedirectAction_RedirectResponseCode = 386698449
	HttpRedirectAction_PERMANENT_REDIRECT               HttpRedirectAction_RedirectResponseCode = 382006381
	HttpRedirectAction_SEE_OTHER                        HttpRedirectAction_RedirectResponseCode = 445380580
	HttpRedirectAction_TEMPORARY_REDIRECT               HttpRedirectAction_RedirectResponseCode = 489550378
)

// Enum value maps for HttpRedirectAction_RedirectResponseCode.
var (
	HttpRedirectAction_RedirectResponseCode_name = map[int32]string{
		0:         "UNDEFINED_REDIRECT_RESPONSE_CODE",
		67084130:  "FOUND",
		386698449: "MOVED_PERMANENTLY_DEFAULT",
		382006381: "PERMANENT_REDIRECT",
		445380580: "SEE_OTHER",
		489550378: "TEMPORARY_REDIRECT",
	}
	HttpRedirectAction_RedirectResponseCode_value = map[string]int32{
		"UNDEFINED_REDIRECT_RESPONSE_CODE": 0,
		"FOUND":                            67084130,
		"MOVED_PERMANENTLY_DEFAULT":        386698449,
		"PERMANENT_REDIRECT":               382006381,
		"SEE_OTHER":                        445380580,
		"TEMPORARY_REDIRECT":               489550378,
	}
)

func (x HttpRedirectAction_RedirectResponseCode) Enum() *HttpRedirectAction_RedirectResponseCode {
	p := new(HttpRedirectAction_RedirectResponseCode)
	*p = x
	return p
}

func (x HttpRedirectAction_RedirectResponseCode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (HttpRedirectAction_RedirectResponseCode) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[66].Descriptor()
}

func (HttpRedirectAction_RedirectResponseCode) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[66]
}

func (x HttpRedirectAction_RedirectResponseCode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use HttpRedirectAction_RedirectResponseCode.Descriptor instead.
func (HttpRedirectAction_RedirectResponseCode) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{160, 0}
}

// The format used to encode and transmit the block device, which should be TAR. This is just a container and transmission format and not a runtime format. Provided by the client when the disk image is created.
type RawDisk_ContainerType int32

const (
	// A value indicating that the enum field is not set.
	RawDisk_UNDEFINED_CONTAINER_TYPE RawDisk_ContainerType = 0
	RawDisk_TAR                      RawDisk_ContainerType = 82821
)

// Enum value maps for RawDisk_ContainerType.
var (
	RawDisk_ContainerType_name = map[int32]string{
		0:     "UNDEFINED_CONTAINER_TYPE",
		82821: "TAR",
	}
	RawDisk_ContainerType_value = map[string]int32{
		"UNDEFINED_CONTAINER_TYPE": 0,
		"TAR":                      82821,
	}
)

func (x RawDisk_ContainerType) Enum() *RawDisk_ContainerType {
	p := new(RawDisk_ContainerType)
	*p = x
	return p
}

func (x RawDisk_ContainerType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (RawDisk_ContainerType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[67].Descriptor()
}

func (RawDisk_ContainerType) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[67]
}

func (x RawDisk_ContainerType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use RawDisk_ContainerType.Descriptor instead.
func (RawDisk_ContainerType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{168, 0}
}

// The type of the image used to create this disk. The default and only value is RAW
type Image_SourceType int32

const (
	// A value indicating that the enum field is not set.
	Image_UNDEFINED_SOURCE_TYPE Image_SourceType = 0
	Image_RAW                   Image_SourceType = 80904
)

// Enum value maps for Image_SourceType.
var (
	Image_SourceType_name = map[int32]string{
		0:     "UNDEFINED_SOURCE_TYPE",
		80904: "RAW",
	}
	Image_SourceType_value = map[string]int32{
		"UNDEFINED_SOURCE_TYPE": 0,
		"RAW":                   80904,
	}
)

func (x Image_SourceType) Enum() *Image_SourceType {
	p := new(Image_SourceType)
	*p = x
	return p
}

func (x Image_SourceType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Image_SourceType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[68].Descriptor()
}

func (Image_SourceType) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[68]
}

func (x Image_SourceType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Image_SourceType.Descriptor instead.
func (Image_SourceType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{169, 0}
}

// [Output Only] The status of the image. An image can be used to create other resources, such as instances, only after the image has been successfully created and the status is set to READY. Possible values are FAILED, PENDING, or READY.
type Image_Status int32

const (
	// A value indicating that the enum field is not set.
	Image_UNDEFINED_STATUS Image_Status = 0
	Image_DELETING         Image_Status = 528602024
	Image_FAILED           Image_Status = 455706685
	Image_PENDING          Image_Status = 35394935
	Image_READY            Image_Status = 77848963
)

// Enum value maps for Image_Status.
var (
	Image_Status_name = map[int32]string{
		0:         "UNDEFINED_STATUS",
		528602024: "DELETING",
		455706685: "FAILED",
		35394935:  "PENDING",
		77848963:  "READY",
	}
	Image_Status_value = map[string]int32{
		"UNDEFINED_STATUS": 0,
		"DELETING":         528602024,
		"FAILED":           455706685,
		"PENDING":          35394935,
		"READY":            77848963,
	}
)

func (x Image_Status) Enum() *Image_Status {
	p := new(Image_Status)
	*p = x
	return p
}

func (x Image_Status) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Image_Status) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[69].Descriptor()
}

func (Image_Status) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[69]
}

func (x Image_Status) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Image_Status.Descriptor instead.
func (Image_Status) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{169, 1}
}

// The type of vNIC to be used on this interface. This may be gVNIC or VirtioNet.
type NetworkInterface_NicType int32

const (
	// A value indicating that the enum field is not set.
	NetworkInterface_UNDEFINED_NIC_TYPE   NetworkInterface_NicType = 0
	NetworkInterface_GVNIC                NetworkInterface_NicType = 68209305
	NetworkInterface_UNSPECIFIED_NIC_TYPE NetworkInterface_NicType = 67411801
	NetworkInterface_VIRTIO_NET           NetworkInterface_NicType = 452123481
)

// Enum value maps for NetworkInterface_NicType.
var (
	NetworkInterface_NicType_name = map[int32]string{
		0:         "UNDEFINED_NIC_TYPE",
		68209305:  "GVNIC",
		67411801:  "UNSPECIFIED_NIC_TYPE",
		452123481: "VIRTIO_NET",
	}
	NetworkInterface_NicType_value = map[string]int32{
		"UNDEFINED_NIC_TYPE":   0,
		"GVNIC":                68209305,
		"UNSPECIFIED_NIC_TYPE": 67411801,
		"VIRTIO_NET":           452123481,
	}
)

func (x NetworkInterface_NicType) Enum() *NetworkInterface_NicType {
	p := new(NetworkInterface_NicType)
	*p = x
	return p
}

func (x NetworkInterface_NicType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (NetworkInterface_NicType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[70].Descriptor()
}

func (NetworkInterface_NicType) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[70]
}

func (x NetworkInterface_NicType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use NetworkInterface_NicType.Descriptor instead.
func (NetworkInterface_NicType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{172, 0}
}

// Specifies the type of reservation from which this instance can consume resources: ANY_RESERVATION (default), SPECIFIC_RESERVATION, or NO_RESERVATION. See  Consuming reserved instances for examples.
type ReservationAffinity_ConsumeReservationType int32

const (
	// A value indicating that the enum field is not set.
	ReservationAffinity_UNDEFINED_CONSUME_RESERVATION_TYPE ReservationAffinity_ConsumeReservationType = 0
	ReservationAffinity_ANY_RESERVATION                    ReservationAffinity_ConsumeReservationType = 200008121
	ReservationAffinity_NO_RESERVATION                     ReservationAffinity_ConsumeReservationType = 169322030
	ReservationAffinity_SPECIFIC_RESERVATION               ReservationAffinity_ConsumeReservationType = 229889055
	ReservationAffinity_UNSPECIFIED                        ReservationAffinity_ConsumeReservationType = 526786327
)

// Enum value maps for ReservationAffinity_ConsumeReservationType.
var (
	ReservationAffinity_ConsumeReservationType_name = map[int32]string{
		0:         "UNDEFINED_CONSUME_RESERVATION_TYPE",
		200008121: "ANY_RESERVATION",
		169322030: "NO_RESERVATION",
		229889055: "SPECIFIC_RESERVATION",
		526786327: "UNSPECIFIED",
	}
	ReservationAffinity_ConsumeReservationType_value = map[string]int32{
		"UNDEFINED_CONSUME_RESERVATION_TYPE": 0,
		"ANY_RESERVATION":                    200008121,
		"NO_RESERVATION":                     169322030,
		"SPECIFIC_RESERVATION":               229889055,
		"UNSPECIFIED":                        526786327,
	}
)

func (x ReservationAffinity_ConsumeReservationType) Enum() *ReservationAffinity_ConsumeReservationType {
	p := new(ReservationAffinity_ConsumeReservationType)
	*p = x
	return p
}

func (x ReservationAffinity_ConsumeReservationType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ReservationAffinity_ConsumeReservationType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[71].Descriptor()
}

func (ReservationAffinity_ConsumeReservationType) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[71]
}

func (x ReservationAffinity_ConsumeReservationType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ReservationAffinity_ConsumeReservationType.Descriptor instead.
func (ReservationAffinity_ConsumeReservationType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{173, 0}
}

// Defines the maintenance behavior for this instance. For standard instances, the default behavior is MIGRATE. For preemptible instances, the default and only possible behavior is TERMINATE. For more information, see Setting Instance Scheduling Options.
type Scheduling_OnHostMaintenance int32

const (
	// A value indicating that the enum field is not set.
	Scheduling_UNDEFINED_ON_HOST_MAINTENANCE Scheduling_OnHostMaintenance = 0
	Scheduling_MIGRATE                       Scheduling_OnHostMaintenance = 165699979
	Scheduling_TERMINATE                     Scheduling_OnHostMaintenance = 527617601
)

// Enum value maps for Scheduling_OnHostMaintenance.
var (
	Scheduling_OnHostMaintenance_name = map[int32]string{
		0:         "UNDEFINED_ON_HOST_MAINTENANCE",
		165699979: "MIGRATE",
		527617601: "TERMINATE",
	}
	Scheduling_OnHostMaintenance_value = map[string]int32{
		"UNDEFINED_ON_HOST_MAINTENANCE": 0,
		"MIGRATE":                       165699979,
		"TERMINATE":                     527617601,
	}
)

func (x Scheduling_OnHostMaintenance) Enum() *Scheduling_OnHostMaintenance {
	p := new(Scheduling_OnHostMaintenance)
	*p = x
	return p
}

func (x Scheduling_OnHostMaintenance) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Scheduling_OnHostMaintenance) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[72].Descriptor()
}

func (Scheduling_OnHostMaintenance) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[72]
}

func (x Scheduling_OnHostMaintenance) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Scheduling_OnHostMaintenance.Descriptor instead.
func (Scheduling_OnHostMaintenance) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{174, 0}
}

// The private IPv6 google access type for the VM. If not specified, use  INHERIT_FROM_SUBNETWORK as default.
type Instance_PrivateIpv6GoogleAccess int32

const (
	// A value indicating that the enum field is not set.
	Instance_UNDEFINED_PRIVATE_IPV6_GOOGLE_ACCESS  Instance_PrivateIpv6GoogleAccess = 0
	Instance_ENABLE_BIDIRECTIONAL_ACCESS_TO_GOOGLE Instance_PrivateIpv6GoogleAccess = 427975994
	Instance_ENABLE_OUTBOUND_VM_ACCESS_TO_GOOGLE   Instance_PrivateIpv6GoogleAccess = 288210263
	Instance_INHERIT_FROM_SUBNETWORK               Instance_PrivateIpv6GoogleAccess = 530256959
)

// Enum value maps for Instance_PrivateIpv6GoogleAccess.
var (
	Instance_PrivateIpv6GoogleAccess_name = map[int32]string{
		0:         "UNDEFINED_PRIVATE_IPV6_GOOGLE_ACCESS",
		427975994: "ENABLE_BIDIRECTIONAL_ACCESS_TO_GOOGLE",
		288210263: "ENABLE_OUTBOUND_VM_ACCESS_TO_GOOGLE",
		530256959: "INHERIT_FROM_SUBNETWORK",
	}
	Instance_PrivateIpv6GoogleAccess_value = map[string]int32{
		"UNDEFINED_PRIVATE_IPV6_GOOGLE_ACCESS":  0,
		"ENABLE_BIDIRECTIONAL_ACCESS_TO_GOOGLE": 427975994,
		"ENABLE_OUTBOUND_VM_ACCESS_TO_GOOGLE":   288210263,
		"INHERIT_FROM_SUBNETWORK":               530256959,
	}
)

func (x Instance_PrivateIpv6GoogleAccess) Enum() *Instance_PrivateIpv6GoogleAccess {
	p := new(Instance_PrivateIpv6GoogleAccess)
	*p = x
	return p
}

func (x Instance_PrivateIpv6GoogleAccess) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Instance_PrivateIpv6GoogleAccess) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[73].Descriptor()
}

func (Instance_PrivateIpv6GoogleAccess) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[73]
}

func (x Instance_PrivateIpv6GoogleAccess) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Instance_PrivateIpv6GoogleAccess.Descriptor instead.
func (Instance_PrivateIpv6GoogleAccess) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{179, 0}
}

// [Output Only] The status of the instance. One of the following values: PROVISIONING, STAGING, RUNNING, STOPPING, SUSPENDING, SUSPENDED, REPAIRING, and TERMINATED. For more information about the status of the instance, see  Instance life cycle.
type Instance_Status int32

const (
	// A value indicating that the enum field is not set.
	Instance_UNDEFINED_STATUS Instance_Status = 0
	Instance_DEPROVISIONING   Instance_Status = 428935662
	Instance_PROVISIONING     Instance_Status = 290896621
	Instance_REPAIRING        Instance_Status = 413483285
	Instance_RUNNING          Instance_Status = 121282975
	Instance_STAGING          Instance_Status = 431072283
	Instance_STOPPED          Instance_Status = 444276141
	Instance_STOPPING         Instance_Status = 350791796
	Instance_SUSPENDED        Instance_Status = 51223995
	Instance_SUSPENDING       Instance_Status = 514206246
	Instance_TERMINATED       Instance_Status = 250018339
)

// Enum value maps for Instance_Status.
var (
	Instance_Status_name = map[int32]string{
		0:         "UNDEFINED_STATUS",
		428935662: "DEPROVISIONING",
		290896621: "PROVISIONING",
		413483285: "REPAIRING",
		121282975: "RUNNING",
		431072283: "STAGING",
		444276141: "STOPPED",
		350791796: "STOPPING",
		51223995:  "SUSPENDED",
		514206246: "SUSPENDING",
		250018339: "TERMINATED",
	}
	Instance_Status_value = map[string]int32{
		"UNDEFINED_STATUS": 0,
		"DEPROVISIONING":   428935662,
		"PROVISIONING":     290896621,
		"REPAIRING":        413483285,
		"RUNNING":          121282975,
		"STAGING":          431072283,
		"STOPPED":          444276141,
		"STOPPING":         350791796,
		"SUSPENDED":        51223995,
		"SUSPENDING":       514206246,
		"TERMINATED":       250018339,
	}
)

func (x Instance_Status) Enum() *Instance_Status {
	p := new(Instance_Status)
	*p = x
	return p
}

func (x Instance_Status) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Instance_Status) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[74].Descriptor()
}

func (Instance_Status) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[74]
}

func (x Instance_Status) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Instance_Status.Descriptor instead.
func (Instance_Status) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{179, 1}
}

// The status of applying this per-instance config on the corresponding managed instance.
type PerInstanceConfig_Status int32

const (
	// A value indicating that the enum field is not set.
	PerInstanceConfig_UNDEFINED_STATUS   PerInstanceConfig_Status = 0
	PerInstanceConfig_APPLYING           PerInstanceConfig_Status = 352003508
	PerInstanceConfig_DELETING           PerInstanceConfig_Status = 528602024
	PerInstanceConfig_EFFECTIVE          PerInstanceConfig_Status = 244201863
	PerInstanceConfig_NONE               PerInstanceConfig_Status = 2402104
	PerInstanceConfig_UNAPPLIED          PerInstanceConfig_Status = 483935140
	PerInstanceConfig_UNAPPLIED_DELETION PerInstanceConfig_Status = 313956873
)

// Enum value maps for PerInstanceConfig_Status.
var (
	PerInstanceConfig_Status_name = map[int32]string{
		0:         "UNDEFINED_STATUS",
		352003508: "APPLYING",
		528602024: "DELETING",
		244201863: "EFFECTIVE",
		2402104:   "NONE",
		483935140: "UNAPPLIED",
		313956873: "UNAPPLIED_DELETION",
	}
	PerInstanceConfig_Status_value = map[string]int32{
		"UNDEFINED_STATUS":   0,
		"APPLYING":           352003508,
		"DELETING":           528602024,
		"EFFECTIVE":          244201863,
		"NONE":               2402104,
		"UNAPPLIED":          483935140,
		"UNAPPLIED_DELETION": 313956873,
	}
)

func (x PerInstanceConfig_Status) Enum() *PerInstanceConfig_Status {
	p := new(PerInstanceConfig_Status)
	*p = x
	return p
}

func (x PerInstanceConfig_Status) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (PerInstanceConfig_Status) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[75].Descriptor()
}

func (PerInstanceConfig_Status) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[75]
}

func (x PerInstanceConfig_Status) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use PerInstanceConfig_Status.Descriptor instead.
func (PerInstanceConfig_Status) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{202, 0}
}

// [Output Only] The current action that the managed instance group has scheduled for the instance. Possible values:
// - NONE The instance is running, and the managed instance group does not have any scheduled actions for this instance.
// - CREATING The managed instance group is creating this instance. If the group fails to create this instance, it will try again until it is successful.
// - CREATING_WITHOUT_RETRIES The managed instance group is attempting to create this instance only once. If the group fails to create this instance, it does not try again and the group's targetSize value is decreased instead.
// - RECREATING The managed instance group is recreating this instance.
// - DELETING The managed instance group is permanently deleting this instance.
// - ABANDONING The managed instance group is abandoning this instance. The instance will be removed from the instance group and from any target pools that are associated with this group.
// - RESTARTING The managed instance group is restarting the instance.
// - REFRESHING The managed instance group is applying configuration changes to the instance without stopping it. For example, the group can update the target pool list for an instance without stopping that instance.
// - VERIFYING The managed instance group has created the instance and it is in the process of being verified.
type ManagedInstance_CurrentAction int32

const (
	// A value indicating that the enum field is not set.
	ManagedInstance_UNDEFINED_CURRENT_ACTION ManagedInstance_CurrentAction = 0
	ManagedInstance_ABANDONING               ManagedInstance_CurrentAction = 388244813
	ManagedInstance_CREATING                 ManagedInstance_CurrentAction = 455564985
	ManagedInstance_CREATING_WITHOUT_RETRIES ManagedInstance_CurrentAction = 428843785
	ManagedInstance_DELETING                 ManagedInstance_CurrentAction = 528602024
	ManagedInstance_NONE                     ManagedInstance_CurrentAction = 2402104
	ManagedInstance_RECREATING               ManagedInstance_CurrentAction = 287278572
	ManagedInstance_REFRESHING               ManagedInstance_CurrentAction = 163266343
	ManagedInstance_RESTARTING               ManagedInstance_CurrentAction = 320534387
	ManagedInstance_VERIFYING                ManagedInstance_CurrentAction = 16982185
)

// Enum value maps for ManagedInstance_CurrentAction.
var (
	ManagedInstance_CurrentAction_name = map[int32]string{
		0:         "UNDEFINED_CURRENT_ACTION",
		388244813: "ABANDONING",
		455564985: "CREATING",
		428843785: "CREATING_WITHOUT_RETRIES",
		528602024: "DELETING",
		2402104:   "NONE",
		287278572: "RECREATING",
		163266343: "REFRESHING",
		320534387: "RESTARTING",
		16982185:  "VERIFYING",
	}
	ManagedInstance_CurrentAction_value = map[string]int32{
		"UNDEFINED_CURRENT_ACTION": 0,
		"ABANDONING":               388244813,
		"CREATING":                 455564985,
		"CREATING_WITHOUT_RETRIES": 428843785,
		"DELETING":                 528602024,
		"NONE":                     2402104,
		"RECREATING":               287278572,
		"REFRESHING":               163266343,
		"RESTARTING":               320534387,
		"VERIFYING":                16982185,
	}
)

func (x ManagedInstance_CurrentAction) Enum() *ManagedInstance_CurrentAction {
	p := new(ManagedInstance_CurrentAction)
	*p = x
	return p
}

func (x ManagedInstance_CurrentAction) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ManagedInstance_CurrentAction) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[76].Descriptor()
}

func (ManagedInstance_CurrentAction) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[76]
}

func (x ManagedInstance_CurrentAction) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ManagedInstance_CurrentAction.Descriptor instead.
func (ManagedInstance_CurrentAction) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{208, 0}
}

// [Output Only] The status of the instance. This field is empty when the instance does not exist.
type ManagedInstance_InstanceStatus int32

const (
	// A value indicating that the enum field is not set.
	ManagedInstance_UNDEFINED_INSTANCE_STATUS ManagedInstance_InstanceStatus = 0
	ManagedInstance_DEPROVISIONING            ManagedInstance_InstanceStatus = 428935662
	ManagedInstance_PROVISIONING              ManagedInstance_InstanceStatus = 290896621
	ManagedInstance_REPAIRING                 ManagedInstance_InstanceStatus = 413483285
	ManagedInstance_RUNNING                   ManagedInstance_InstanceStatus = 121282975
	ManagedInstance_STAGING                   ManagedInstance_InstanceStatus = 431072283
	ManagedInstance_STOPPED                   ManagedInstance_InstanceStatus = 444276141
	ManagedInstance_STOPPING                  ManagedInstance_InstanceStatus = 350791796
	ManagedInstance_SUSPENDED                 ManagedInstance_InstanceStatus = 51223995
	ManagedInstance_SUSPENDING                ManagedInstance_InstanceStatus = 514206246
	ManagedInstance_TERMINATED                ManagedInstance_InstanceStatus = 250018339
)

// Enum value maps for ManagedInstance_InstanceStatus.
var (
	ManagedInstance_InstanceStatus_name = map[int32]string{
		0:         "UNDEFINED_INSTANCE_STATUS",
		428935662: "DEPROVISIONING",
		290896621: "PROVISIONING",
		413483285: "REPAIRING",
		121282975: "RUNNING",
		431072283: "STAGING",
		444276141: "STOPPED",
		350791796: "STOPPING",
		51223995:  "SUSPENDED",
		514206246: "SUSPENDING",
		250018339: "TERMINATED",
	}
	ManagedInstance_InstanceStatus_value = map[string]int32{
		"UNDEFINED_INSTANCE_STATUS": 0,
		"DEPROVISIONING":            428935662,
		"PROVISIONING":              290896621,
		"REPAIRING":                 413483285,
		"RUNNING":                   121282975,
		"STAGING":                   431072283,
		"STOPPED":                   444276141,
		"STOPPING":                  350791796,
		"SUSPENDED":                 51223995,
		"SUSPENDING":                514206246,
		"TERMINATED":                250018339,
	}
)

func (x ManagedInstance_InstanceStatus) Enum() *ManagedInstance_InstanceStatus {
	p := new(ManagedInstance_InstanceStatus)
	*p = x
	return p
}

func (x ManagedInstance_InstanceStatus) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ManagedInstance_InstanceStatus) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[77].Descriptor()
}

func (ManagedInstance_InstanceStatus) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[77]
}

func (x ManagedInstance_InstanceStatus) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ManagedInstance_InstanceStatus.Descriptor instead.
func (ManagedInstance_InstanceStatus) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{208, 1}
}

// [Output Only] The status of the instance.
type InstanceWithNamedPorts_Status int32

const (
	// A value indicating that the enum field is not set.
	InstanceWithNamedPorts_UNDEFINED_STATUS InstanceWithNamedPorts_Status = 0
	InstanceWithNamedPorts_DEPROVISIONING   InstanceWithNamedPorts_Status = 428935662
	InstanceWithNamedPorts_PROVISIONING     InstanceWithNamedPorts_Status = 290896621
	InstanceWithNamedPorts_REPAIRING        InstanceWithNamedPorts_Status = 413483285
	InstanceWithNamedPorts_RUNNING          InstanceWithNamedPorts_Status = 121282975
	InstanceWithNamedPorts_STAGING          InstanceWithNamedPorts_Status = 431072283
	InstanceWithNamedPorts_STOPPED          InstanceWithNamedPorts_Status = 444276141
	InstanceWithNamedPorts_STOPPING         InstanceWithNamedPorts_Status = 350791796
	InstanceWithNamedPorts_SUSPENDED        InstanceWithNamedPorts_Status = 51223995
	InstanceWithNamedPorts_SUSPENDING       InstanceWithNamedPorts_Status = 514206246
	InstanceWithNamedPorts_TERMINATED       InstanceWithNamedPorts_Status = 250018339
)

// Enum value maps for InstanceWithNamedPorts_Status.
var (
	InstanceWithNamedPorts_Status_name = map[int32]string{
		0:         "UNDEFINED_STATUS",
		428935662: "DEPROVISIONING",
		290896621: "PROVISIONING",
		413483285: "REPAIRING",
		121282975: "RUNNING",
		431072283: "STAGING",
		444276141: "STOPPED",
		350791796: "STOPPING",
		51223995:  "SUSPENDED",
		514206246: "SUSPENDING",
		250018339: "TERMINATED",
	}
	InstanceWithNamedPorts_Status_value = map[string]int32{
		"UNDEFINED_STATUS": 0,
		"DEPROVISIONING":   428935662,
		"PROVISIONING":     290896621,
		"REPAIRING":        413483285,
		"RUNNING":          121282975,
		"STAGING":          431072283,
		"STOPPED":          444276141,
		"STOPPING":         350791796,
		"SUSPENDED":        51223995,
		"SUSPENDING":       514206246,
		"TERMINATED":       250018339,
	}
)

func (x InstanceWithNamedPorts_Status) Enum() *InstanceWithNamedPorts_Status {
	p := new(InstanceWithNamedPorts_Status)
	*p = x
	return p
}

func (x InstanceWithNamedPorts_Status) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (InstanceWithNamedPorts_Status) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[78].Descriptor()
}

func (InstanceWithNamedPorts_Status) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[78]
}

func (x InstanceWithNamedPorts_Status) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use InstanceWithNamedPorts_Status.Descriptor instead.
func (InstanceWithNamedPorts_Status) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{218, 0}
}

// A filter for the state of the instances in the instance group. Valid options are ALL or RUNNING. If you do not specify this parameter the list includes all instances regardless of their state.
type InstanceGroupsListInstancesRequest_InstanceState int32

const (
	// A value indicating that the enum field is not set.
	InstanceGroupsListInstancesRequest_UNDEFINED_INSTANCE_STATE InstanceGroupsListInstancesRequest_InstanceState = 0
	InstanceGroupsListInstancesRequest_ALL                      InstanceGroupsListInstancesRequest_InstanceState = 64897
	InstanceGroupsListInstancesRequest_RUNNING                  InstanceGroupsListInstancesRequest_InstanceState = 121282975
)

// Enum value maps for InstanceGroupsListInstancesRequest_InstanceState.
var (
	InstanceGroupsListInstancesRequest_InstanceState_name = map[int32]string{
		0:         "UNDEFINED_INSTANCE_STATE",
		64897:     "ALL",
		121282975: "RUNNING",
	}
	InstanceGroupsListInstancesRequest_InstanceState_value = map[string]int32{
		"UNDEFINED_INSTANCE_STATE": 0,
		"ALL":                      64897,
		"RUNNING":                  121282975,
	}
)

func (x InstanceGroupsListInstancesRequest_InstanceState) Enum() *InstanceGroupsListInstancesRequest_InstanceState {
	p := new(InstanceGroupsListInstancesRequest_InstanceState)
	*p = x
	return p
}

func (x InstanceGroupsListInstancesRequest_InstanceState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (InstanceGroupsListInstancesRequest_InstanceState) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[79].Descriptor()
}

func (InstanceGroupsListInstancesRequest_InstanceState) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[79]
}

func (x InstanceGroupsListInstancesRequest_InstanceState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use InstanceGroupsListInstancesRequest_InstanceState.Descriptor instead.
func (InstanceGroupsListInstancesRequest_InstanceState) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{220, 0}
}

// [Output Only] Action that managed instance group was executing on the instance when the error occurred. Possible values:
type InstanceManagedByIgmErrorInstanceActionDetails_Action int32

const (
	// A value indicating that the enum field is not set.
	InstanceManagedByIgmErrorInstanceActionDetails_UNDEFINED_ACTION         InstanceManagedByIgmErrorInstanceActionDetails_Action = 0
	InstanceManagedByIgmErrorInstanceActionDetails_ABANDONING               InstanceManagedByIgmErrorInstanceActionDetails_Action = 388244813
	InstanceManagedByIgmErrorInstanceActionDetails_CREATING                 InstanceManagedByIgmErrorInstanceActionDetails_Action = 455564985
	InstanceManagedByIgmErrorInstanceActionDetails_CREATING_WITHOUT_RETRIES InstanceManagedByIgmErrorInstanceActionDetails_Action = 428843785
	InstanceManagedByIgmErrorInstanceActionDetails_DELETING                 InstanceManagedByIgmErrorInstanceActionDetails_Action = 528602024
	InstanceManagedByIgmErrorInstanceActionDetails_NONE                     InstanceManagedByIgmErrorInstanceActionDetails_Action = 2402104
	InstanceManagedByIgmErrorInstanceActionDetails_RECREATING               InstanceManagedByIgmErrorInstanceActionDetails_Action = 287278572
	InstanceManagedByIgmErrorInstanceActionDetails_REFRESHING               InstanceManagedByIgmErrorInstanceActionDetails_Action = 163266343
	InstanceManagedByIgmErrorInstanceActionDetails_RESTARTING               InstanceManagedByIgmErrorInstanceActionDetails_Action = 320534387
	InstanceManagedByIgmErrorInstanceActionDetails_VERIFYING                InstanceManagedByIgmErrorInstanceActionDetails_Action = 16982185
)

// Enum value maps for InstanceManagedByIgmErrorInstanceActionDetails_Action.
var (
	InstanceManagedByIgmErrorInstanceActionDetails_Action_name = map[int32]string{
		0:         "UNDEFINED_ACTION",
		388244813: "ABANDONING",
		455564985: "CREATING",
		428843785: "CREATING_WITHOUT_RETRIES",
		528602024: "DELETING",
		2402104:   "NONE",
		287278572: "RECREATING",
		163266343: "REFRESHING",
		320534387: "RESTARTING",
		16982185:  "VERIFYING",
	}
	InstanceManagedByIgmErrorInstanceActionDetails_Action_value = map[string]int32{
		"UNDEFINED_ACTION":         0,
		"ABANDONING":               388244813,
		"CREATING":                 455564985,
		"CREATING_WITHOUT_RETRIES": 428843785,
		"DELETING":                 528602024,
		"NONE":                     2402104,
		"RECREATING":               287278572,
		"REFRESHING":               163266343,
		"RESTARTING":               320534387,
		"VERIFYING":                16982185,
	}
)

func (x InstanceManagedByIgmErrorInstanceActionDetails_Action) Enum() *InstanceManagedByIgmErrorInstanceActionDetails_Action {
	p := new(InstanceManagedByIgmErrorInstanceActionDetails_Action)
	*p = x
	return p
}

func (x InstanceManagedByIgmErrorInstanceActionDetails_Action) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (InstanceManagedByIgmErrorInstanceActionDetails_Action) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[80].Descriptor()
}

func (InstanceManagedByIgmErrorInstanceActionDetails_Action) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[80]
}

func (x InstanceManagedByIgmErrorInstanceActionDetails_Action) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use InstanceManagedByIgmErrorInstanceActionDetails_Action.Descriptor instead.
func (InstanceManagedByIgmErrorInstanceActionDetails_Action) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{227, 0}
}

// [Output Only] The type of the firewall policy.
type InstancesGetEffectiveFirewallsResponseEffectiveFirewallPolicy_Type int32

const (
	// A value indicating that the enum field is not set.
	InstancesGetEffectiveFirewallsResponseEffectiveFirewallPolicy_UNDEFINED_TYPE InstancesGetEffectiveFirewallsResponseEffectiveFirewallPolicy_Type = 0
	InstancesGetEffectiveFirewallsResponseEffectiveFirewallPolicy_HIERARCHY      InstancesGetEffectiveFirewallsResponseEffectiveFirewallPolicy_Type = 69902869
	InstancesGetEffectiveFirewallsResponseEffectiveFirewallPolicy_UNSPECIFIED    InstancesGetEffectiveFirewallsResponseEffectiveFirewallPolicy_Type = 526786327
)

// Enum value maps for InstancesGetEffectiveFirewallsResponseEffectiveFirewallPolicy_Type.
var (
	InstancesGetEffectiveFirewallsResponseEffectiveFirewallPolicy_Type_name = map[int32]string{
		0:         "UNDEFINED_TYPE",
		69902869:  "HIERARCHY",
		526786327: "UNSPECIFIED",
	}
	InstancesGetEffectiveFirewallsResponseEffectiveFirewallPolicy_Type_value = map[string]int32{
		"UNDEFINED_TYPE": 0,
		"HIERARCHY":      69902869,
		"UNSPECIFIED":    526786327,
	}
)

func (x InstancesGetEffectiveFirewallsResponseEffectiveFirewallPolicy_Type) Enum() *InstancesGetEffectiveFirewallsResponseEffectiveFirewallPolicy_Type {
	p := new(InstancesGetEffectiveFirewallsResponseEffectiveFirewallPolicy_Type)
	*p = x
	return p
}

func (x InstancesGetEffectiveFirewallsResponseEffectiveFirewallPolicy_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (InstancesGetEffectiveFirewallsResponseEffectiveFirewallPolicy_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[81].Descriptor()
}

func (InstancesGetEffectiveFirewallsResponseEffectiveFirewallPolicy_Type) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[81]
}

func (x InstancesGetEffectiveFirewallsResponseEffectiveFirewallPolicy_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use InstancesGetEffectiveFirewallsResponseEffectiveFirewallPolicy_Type.Descriptor instead.
func (InstancesGetEffectiveFirewallsResponseEffectiveFirewallPolicy_Type) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{234, 0}
}

// Form this outage is expected to take, which can take one of the following values:
// - OUTAGE: The Interconnect may be completely out of service for some or all of the specified window.
// - PARTIAL_OUTAGE: Some circuits comprising the Interconnect as a whole should remain up, but with reduced bandwidth. Note that the versions of this enum prefixed with "IT_" have been deprecated in favor of the unprefixed values.
type InterconnectOutageNotification_IssueType int32

const (
	// A value indicating that the enum field is not set.
	InterconnectOutageNotification_UNDEFINED_ISSUE_TYPE InterconnectOutageNotification_IssueType = 0
	InterconnectOutageNotification_IT_OUTAGE            InterconnectOutageNotification_IssueType = 175779973
	InterconnectOutageNotification_IT_PARTIAL_OUTAGE    InterconnectOutageNotification_IssueType = 92103971
	InterconnectOutageNotification_OUTAGE               InterconnectOutageNotification_IssueType = 195285745
	InterconnectOutageNotification_PARTIAL_OUTAGE       InterconnectOutageNotification_IssueType = 147053455
)

// Enum value maps for InterconnectOutageNotification_IssueType.
var (
	InterconnectOutageNotification_IssueType_name = map[int32]string{
		0:         "UNDEFINED_ISSUE_TYPE",
		175779973: "IT_OUTAGE",
		92103971:  "IT_PARTIAL_OUTAGE",
		195285745: "OUTAGE",
		147053455: "PARTIAL_OUTAGE",
	}
	InterconnectOutageNotification_IssueType_value = map[string]int32{
		"UNDEFINED_ISSUE_TYPE": 0,
		"IT_OUTAGE":            175779973,
		"IT_PARTIAL_OUTAGE":    92103971,
		"OUTAGE":               195285745,
		"PARTIAL_OUTAGE":       147053455,
	}
)

func (x InterconnectOutageNotification_IssueType) Enum() *InterconnectOutageNotification_IssueType {
	p := new(InterconnectOutageNotification_IssueType)
	*p = x
	return p
}

func (x InterconnectOutageNotification_IssueType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (InterconnectOutageNotification_IssueType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[82].Descriptor()
}

func (InterconnectOutageNotification_IssueType) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[82]
}

func (x InterconnectOutageNotification_IssueType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use InterconnectOutageNotification_IssueType.Descriptor instead.
func (InterconnectOutageNotification_IssueType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{244, 0}
}

// The party that generated this notification, which can take the following value:
// - GOOGLE: this notification as generated by Google. Note that the value of NSRC_GOOGLE has been deprecated in favor of GOOGLE.
type InterconnectOutageNotification_Source int32

const (
	// A value indicating that the enum field is not set.
	InterconnectOutageNotification_UNDEFINED_SOURCE InterconnectOutageNotification_Source = 0
	InterconnectOutageNotification_GOOGLE           InterconnectOutageNotification_Source = 497439289
	InterconnectOutageNotification_NSRC_GOOGLE      InterconnectOutageNotification_Source = 510574562
)

// Enum value maps for InterconnectOutageNotification_Source.
var (
	InterconnectOutageNotification_Source_name = map[int32]string{
		0:         "UNDEFINED_SOURCE",
		497439289: "GOOGLE",
		510574562: "NSRC_GOOGLE",
	}
	InterconnectOutageNotification_Source_value = map[string]int32{
		"UNDEFINED_SOURCE": 0,
		"GOOGLE":           497439289,
		"NSRC_GOOGLE":      510574562,
	}
)

func (x InterconnectOutageNotification_Source) Enum() *InterconnectOutageNotification_Source {
	p := new(InterconnectOutageNotification_Source)
	*p = x
	return p
}

func (x InterconnectOutageNotification_Source) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (InterconnectOutageNotification_Source) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[83].Descriptor()
}

func (InterconnectOutageNotification_Source) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[83]
}

func (x InterconnectOutageNotification_Source) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use InterconnectOutageNotification_Source.Descriptor instead.
func (InterconnectOutageNotification_Source) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{244, 1}
}

// State of this notification, which can take one of the following values:
// - ACTIVE: This outage notification is active. The event could be in the past, present, or future. See start_time and end_time for scheduling.
// - CANCELLED: The outage associated with this notification was cancelled before the outage was due to start. Note that the versions of this enum prefixed with "NS_" have been deprecated in favor of the unprefixed values.
type InterconnectOutageNotification_State int32

const (
	// A value indicating that the enum field is not set.
	InterconnectOutageNotification_UNDEFINED_STATE InterconnectOutageNotification_State = 0
	InterconnectOutageNotification_ACTIVE          InterconnectOutageNotification_State = 314733318
	InterconnectOutageNotification_CANCELLED       InterconnectOutageNotification_State = 41957681
	InterconnectOutageNotification_COMPLETED       InterconnectOutageNotification_State = 309921323
	InterconnectOutageNotification_NS_ACTIVE       InterconnectOutageNotification_State = 252563136
	InterconnectOutageNotification_NS_CANCELED     InterconnectOutageNotification_State = 506579411
)

// Enum value maps for InterconnectOutageNotification_State.
var (
	InterconnectOutageNotification_State_name = map[int32]string{
		0:         "UNDEFINED_STATE",
		314733318: "ACTIVE",
		41957681:  "CANCELLED",
		309921323: "COMPLETED",
		252563136: "NS_ACTIVE",
		506579411: "NS_CANCELED",
	}
	InterconnectOutageNotification_State_value = map[string]int32{
		"UNDEFINED_STATE": 0,
		"ACTIVE":          314733318,
		"CANCELLED":       41957681,
		"COMPLETED":       309921323,
		"NS_ACTIVE":       252563136,
		"NS_CANCELED":     506579411,
	}
)

func (x InterconnectOutageNotification_State) Enum() *InterconnectOutageNotification_State {
	p := new(InterconnectOutageNotification_State)
	*p = x
	return p
}

func (x InterconnectOutageNotification_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (InterconnectOutageNotification_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[84].Descriptor()
}

func (InterconnectOutageNotification_State) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[84]
}

func (x InterconnectOutageNotification_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use InterconnectOutageNotification_State.Descriptor instead.
func (InterconnectOutageNotification_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{244, 2}
}

// Type of interconnect, which can take one of the following values:
// - PARTNER: A partner-managed interconnection shared between customers though a partner.
// - DEDICATED: A dedicated physical interconnection with the customer. Note that a value IT_PRIVATE has been deprecated in favor of DEDICATED.
type Interconnect_InterconnectType int32

const (
	// A value indicating that the enum field is not set.
	Interconnect_UNDEFINED_INTERCONNECT_TYPE Interconnect_InterconnectType = 0
	Interconnect_DEDICATED                   Interconnect_InterconnectType = 258411983
	Interconnect_IT_PRIVATE                  Interconnect_InterconnectType = 335677007
	Interconnect_PARTNER                     Interconnect_InterconnectType = 461924520
)

// Enum value maps for Interconnect_InterconnectType.
var (
	Interconnect_InterconnectType_name = map[int32]string{
		0:         "UNDEFINED_INTERCONNECT_TYPE",
		258411983: "DEDICATED",
		335677007: "IT_PRIVATE",
		461924520: "PARTNER",
	}
	Interconnect_InterconnectType_value = map[string]int32{
		"UNDEFINED_INTERCONNECT_TYPE": 0,
		"DEDICATED":                   258411983,
		"IT_PRIVATE":                  335677007,
		"PARTNER":                     461924520,
	}
)

func (x Interconnect_InterconnectType) Enum() *Interconnect_InterconnectType {
	p := new(Interconnect_InterconnectType)
	*p = x
	return p
}

func (x Interconnect_InterconnectType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Interconnect_InterconnectType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[85].Descriptor()
}

func (Interconnect_InterconnectType) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[85]
}

func (x Interconnect_InterconnectType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Interconnect_InterconnectType.Descriptor instead.
func (Interconnect_InterconnectType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{245, 0}
}

// Type of link requested, which can take one of the following values:
// - LINK_TYPE_ETHERNET_10G_LR: A 10G Ethernet with LR optics
// - LINK_TYPE_ETHERNET_100G_LR: A 100G Ethernet with LR optics. Note that this field indicates the speed of each of the links in the bundle, not the speed of the entire bundle.
type Interconnect_LinkType int32

const (
	// A value indicating that the enum field is not set.
	Interconnect_UNDEFINED_LINK_TYPE        Interconnect_LinkType = 0
	Interconnect_LINK_TYPE_ETHERNET_100G_LR Interconnect_LinkType = 337672551
	Interconnect_LINK_TYPE_ETHERNET_10G_LR  Interconnect_LinkType = 236739749
)

// Enum value maps for Interconnect_LinkType.
var (
	Interconnect_LinkType_name = map[int32]string{
		0:         "UNDEFINED_LINK_TYPE",
		337672551: "LINK_TYPE_ETHERNET_100G_LR",
		236739749: "LINK_TYPE_ETHERNET_10G_LR",
	}
	Interconnect_LinkType_value = map[string]int32{
		"UNDEFINED_LINK_TYPE":        0,
		"LINK_TYPE_ETHERNET_100G_LR": 337672551,
		"LINK_TYPE_ETHERNET_10G_LR":  236739749,
	}
)

func (x Interconnect_LinkType) Enum() *Interconnect_LinkType {
	p := new(Interconnect_LinkType)
	*p = x
	return p
}

func (x Interconnect_LinkType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Interconnect_LinkType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[86].Descriptor()
}

func (Interconnect_LinkType) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[86]
}

func (x Interconnect_LinkType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Interconnect_LinkType.Descriptor instead.
func (Interconnect_LinkType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{245, 1}
}

// [Output Only] The current status of this Interconnect's functionality, which can take one of the following values:
// - OS_ACTIVE: A valid Interconnect, which is turned up and is ready to use. Attachments may be provisioned on this Interconnect.
// - OS_UNPROVISIONED: An Interconnect that has not completed turnup. No attachments may be provisioned on this Interconnect.
// - OS_UNDER_MAINTENANCE: An Interconnect that is undergoing internal maintenance. No attachments may be provisioned or updated on this Interconnect.
type Interconnect_OperationalStatus int32

const (
	// A value indicating that the enum field is not set.
	Interconnect_UNDEFINED_OPERATIONAL_STATUS Interconnect_OperationalStatus = 0
	Interconnect_OS_ACTIVE                    Interconnect_OperationalStatus = 55721409
	Interconnect_OS_UNPROVISIONED             Interconnect_OperationalStatus = 239771840
)

// Enum value maps for Interconnect_OperationalStatus.
var (
	Interconnect_OperationalStatus_name = map[int32]string{
		0:         "UNDEFINED_OPERATIONAL_STATUS",
		55721409:  "OS_ACTIVE",
		239771840: "OS_UNPROVISIONED",
	}
	Interconnect_OperationalStatus_value = map[string]int32{
		"UNDEFINED_OPERATIONAL_STATUS": 0,
		"OS_ACTIVE":                    55721409,
		"OS_UNPROVISIONED":             239771840,
	}
)

func (x Interconnect_OperationalStatus) Enum() *Interconnect_OperationalStatus {
	p := new(Interconnect_OperationalStatus)
	*p = x
	return p
}

func (x Interconnect_OperationalStatus) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Interconnect_OperationalStatus) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[87].Descriptor()
}

func (Interconnect_OperationalStatus) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[87]
}

func (x Interconnect_OperationalStatus) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Interconnect_OperationalStatus.Descriptor instead.
func (Interconnect_OperationalStatus) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{245, 2}
}

// [Output Only] The current state of Interconnect functionality, which can take one of the following values:
// - ACTIVE: The Interconnect is valid, turned up and ready to use. Attachments may be provisioned on this Interconnect.
// - UNPROVISIONED: The Interconnect has not completed turnup. No attachments may be provisioned on this Interconnect.
// - UNDER_MAINTENANCE: The Interconnect is undergoing internal maintenance. No attachments may be provisioned or updated on this Interconnect.
type Interconnect_State int32

const (
	// A value indicating that the enum field is not set.
	Interconnect_UNDEFINED_STATE Interconnect_State = 0
	Interconnect_ACTIVE          Interconnect_State = 314733318
	Interconnect_UNPROVISIONED   Interconnect_State = 517333979
)

// Enum value maps for Interconnect_State.
var (
	Interconnect_State_name = map[int32]string{
		0:         "UNDEFINED_STATE",
		314733318: "ACTIVE",
		517333979: "UNPROVISIONED",
	}
	Interconnect_State_value = map[string]int32{
		"UNDEFINED_STATE": 0,
		"ACTIVE":          314733318,
		"UNPROVISIONED":   517333979,
	}
)

func (x Interconnect_State) Enum() *Interconnect_State {
	p := new(Interconnect_State)
	*p = x
	return p
}

func (x Interconnect_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Interconnect_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[88].Descriptor()
}

func (Interconnect_State) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[88]
}

func (x Interconnect_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Interconnect_State.Descriptor instead.
func (Interconnect_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{245, 3}
}

// Provisioned bandwidth capacity for the interconnect attachment. For attachments of type DEDICATED, the user can set the bandwidth. For attachments of type PARTNER, the Google Partner that is operating the interconnect must set the bandwidth. Output only for PARTNER type, mutable for PARTNER_PROVIDER and DEDICATED, and can take one of the following values:
// - BPS_50M: 50 Mbit/s
// - BPS_100M: 100 Mbit/s
// - BPS_200M: 200 Mbit/s
// - BPS_300M: 300 Mbit/s
// - BPS_400M: 400 Mbit/s
// - BPS_500M: 500 Mbit/s
// - BPS_1G: 1 Gbit/s
// - BPS_2G: 2 Gbit/s
// - BPS_5G: 5 Gbit/s
// - BPS_10G: 10 Gbit/s
// - BPS_20G: 20 Gbit/s
// - BPS_50G: 50 Gbit/s
type InterconnectAttachment_Bandwidth int32

const (
	// A value indicating that the enum field is not set.
	InterconnectAttachment_UNDEFINED_BANDWIDTH InterconnectAttachment_Bandwidth = 0
	InterconnectAttachment_BPS_100M            InterconnectAttachment_Bandwidth = 49547958
	InterconnectAttachment_BPS_10G             InterconnectAttachment_Bandwidth = 278693006
	InterconnectAttachment_BPS_1G              InterconnectAttachment_Bandwidth = 355358448
	InterconnectAttachment_BPS_200M            InterconnectAttachment_Bandwidth = 49577749
	InterconnectAttachment_BPS_20G             InterconnectAttachment_Bandwidth = 278693967
	InterconnectAttachment_BPS_2G              InterconnectAttachment_Bandwidth = 355358479
	InterconnectAttachment_BPS_300M            InterconnectAttachment_Bandwidth = 49607540
	InterconnectAttachment_BPS_400M            InterconnectAttachment_Bandwidth = 49637331
	InterconnectAttachment_BPS_500M            InterconnectAttachment_Bandwidth = 49667122
	InterconnectAttachment_BPS_50G             InterconnectAttachment_Bandwidth = 278696850
	InterconnectAttachment_BPS_50M             InterconnectAttachment_Bandwidth = 278696856
	InterconnectAttachment_BPS_5G              InterconnectAttachment_Bandwidth = 355358572
)

// Enum value maps for InterconnectAttachment_Bandwidth.
var (
	InterconnectAttachment_Bandwidth_name = map[int32]string{
		0:         "UNDEFINED_BANDWIDTH",
		49547958:  "BPS_100M",
		278693006: "BPS_10G",
		355358448: "BPS_1G",
		49577749:  "BPS_200M",
		278693967: "BPS_20G",
		355358479: "BPS_2G",
		49607540:  "BPS_300M",
		49637331:  "BPS_400M",
		49667122:  "BPS_500M",
		278696850: "BPS_50G",
		278696856: "BPS_50M",
		355358572: "BPS_5G",
	}
	InterconnectAttachment_Bandwidth_value = map[string]int32{
		"UNDEFINED_BANDWIDTH": 0,
		"BPS_100M":            49547958,
		"BPS_10G":             278693006,
		"BPS_1G":              355358448,
		"BPS_200M":            49577749,
		"BPS_20G":             278693967,
		"BPS_2G":              355358479,
		"BPS_300M":            49607540,
		"BPS_400M":            49637331,
		"BPS_500M":            49667122,
		"BPS_50G":             278696850,
		"BPS_50M":             278696856,
		"BPS_5G":              355358572,
	}
)

func (x InterconnectAttachment_Bandwidth) Enum() *InterconnectAttachment_Bandwidth {
	p := new(InterconnectAttachment_Bandwidth)
	*p = x
	return p
}

func (x InterconnectAttachment_Bandwidth) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (InterconnectAttachment_Bandwidth) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[89].Descriptor()
}

func (InterconnectAttachment_Bandwidth) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[89]
}

func (x InterconnectAttachment_Bandwidth) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use InterconnectAttachment_Bandwidth.Descriptor instead.
func (InterconnectAttachment_Bandwidth) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{248, 0}
}

// Desired availability domain for the attachment. Only available for type PARTNER, at creation time, and can take one of the following values:
// - AVAILABILITY_DOMAIN_ANY
// - AVAILABILITY_DOMAIN_1
// - AVAILABILITY_DOMAIN_2 For improved reliability, customers should configure a pair of attachments, one per availability domain. The selected availability domain will be provided to the Partner via the pairing key, so that the provisioned circuit will lie in the specified domain. If not specified, the value will default to AVAILABILITY_DOMAIN_ANY.
type InterconnectAttachment_EdgeAvailabilityDomain int32

const (
	// A value indicating that the enum field is not set.
	InterconnectAttachment_UNDEFINED_EDGE_AVAILABILITY_DOMAIN InterconnectAttachment_EdgeAvailabilityDomain = 0
	InterconnectAttachment_AVAILABILITY_DOMAIN_1              InterconnectAttachment_EdgeAvailabilityDomain = 349552090
	InterconnectAttachment_AVAILABILITY_DOMAIN_2              InterconnectAttachment_EdgeAvailabilityDomain = 349552091
	InterconnectAttachment_AVAILABILITY_DOMAIN_ANY            InterconnectAttachment_EdgeAvailabilityDomain = 375256373
)

// Enum value maps for InterconnectAttachment_EdgeAvailabilityDomain.
var (
	InterconnectAttachment_EdgeAvailabilityDomain_name = map[int32]string{
		0:         "UNDEFINED_EDGE_AVAILABILITY_DOMAIN",
		349552090: "AVAILABILITY_DOMAIN_1",
		349552091: "AVAILABILITY_DOMAIN_2",
		375256373: "AVAILABILITY_DOMAIN_ANY",
	}
	InterconnectAttachment_EdgeAvailabilityDomain_value = map[string]int32{
		"UNDEFINED_EDGE_AVAILABILITY_DOMAIN": 0,
		"AVAILABILITY_DOMAIN_1":              349552090,
		"AVAILABILITY_DOMAIN_2":              349552091,
		"AVAILABILITY_DOMAIN_ANY":            375256373,
	}
)

func (x InterconnectAttachment_EdgeAvailabilityDomain) Enum() *InterconnectAttachment_EdgeAvailabilityDomain {
	p := new(InterconnectAttachment_EdgeAvailabilityDomain)
	*p = x
	return p
}

func (x InterconnectAttachment_EdgeAvailabilityDomain) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (InterconnectAttachment_EdgeAvailabilityDomain) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[90].Descriptor()
}

func (InterconnectAttachment_EdgeAvailabilityDomain) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[90]
}

func (x InterconnectAttachment_EdgeAvailabilityDomain) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use InterconnectAttachment_EdgeAvailabilityDomain.Descriptor instead.
func (InterconnectAttachment_EdgeAvailabilityDomain) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{248, 1}
}

// Indicates the user-supplied encryption option of this interconnect attachment:
// - NONE is the default value, which means that the attachment carries unencrypted traffic. VMs can send traffic to, or receive traffic from, this type of attachment.
// - IPSEC indicates that the attachment carries only traffic encrypted by an IPsec device such as an HA VPN gateway. VMs cannot directly send traffic to, or receive traffic from, such an attachment. To use IPsec-encrypted Cloud Interconnect, create the attachment using this option.
// Not currently available in all Interconnect locations.
type InterconnectAttachment_Encryption int32

const (
	// A value indicating that the enum field is not set.
	InterconnectAttachment_UNDEFINED_ENCRYPTION InterconnectAttachment_Encryption = 0
	InterconnectAttachment_IPSEC                InterconnectAttachment_Encryption = 69882282
	InterconnectAttachment_NONE                 InterconnectAttachment_Encryption = 2402104
)

// Enum value maps for InterconnectAttachment_Encryption.
var (
	InterconnectAttachment_Encryption_name = map[int32]string{
		0:        "UNDEFINED_ENCRYPTION",
		69882282: "IPSEC",
		2402104:  "NONE",
	}
	InterconnectAttachment_Encryption_value = map[string]int32{
		"UNDEFINED_ENCRYPTION": 0,
		"IPSEC":                69882282,
		"NONE":                 2402104,
	}
)

func (x InterconnectAttachment_Encryption) Enum() *InterconnectAttachment_Encryption {
	p := new(InterconnectAttachment_Encryption)
	*p = x
	return p
}

func (x InterconnectAttachment_Encryption) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (InterconnectAttachment_Encryption) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[91].Descriptor()
}

func (InterconnectAttachment_Encryption) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[91]
}

func (x InterconnectAttachment_Encryption) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use InterconnectAttachment_Encryption.Descriptor instead.
func (InterconnectAttachment_Encryption) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{248, 2}
}

// [Output Only] The current status of whether or not this interconnect attachment is functional, which can take one of the following values:
// - OS_ACTIVE: The attachment has been turned up and is ready to use.
// - OS_UNPROVISIONED: The attachment is not ready to use yet, because turnup is not complete.
type InterconnectAttachment_OperationalStatus int32

const (
	// A value indicating that the enum field is not set.
	InterconnectAttachment_UNDEFINED_OPERATIONAL_STATUS InterconnectAttachment_OperationalStatus = 0
	InterconnectAttachment_OS_ACTIVE                    InterconnectAttachment_OperationalStatus = 55721409
	InterconnectAttachment_OS_UNPROVISIONED             InterconnectAttachment_OperationalStatus = 239771840
)

// Enum value maps for InterconnectAttachment_OperationalStatus.
var (
	InterconnectAttachment_OperationalStatus_name = map[int32]string{
		0:         "UNDEFINED_OPERATIONAL_STATUS",
		55721409:  "OS_ACTIVE",
		239771840: "OS_UNPROVISIONED",
	}
	InterconnectAttachment_OperationalStatus_value = map[string]int32{
		"UNDEFINED_OPERATIONAL_STATUS": 0,
		"OS_ACTIVE":                    55721409,
		"OS_UNPROVISIONED":             239771840,
	}
)

func (x InterconnectAttachment_OperationalStatus) Enum() *InterconnectAttachment_OperationalStatus {
	p := new(InterconnectAttachment_OperationalStatus)
	*p = x
	return p
}

func (x InterconnectAttachment_OperationalStatus) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (InterconnectAttachment_OperationalStatus) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[92].Descriptor()
}

func (InterconnectAttachment_OperationalStatus) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[92]
}

func (x InterconnectAttachment_OperationalStatus) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use InterconnectAttachment_OperationalStatus.Descriptor instead.
func (InterconnectAttachment_OperationalStatus) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{248, 3}
}

// [Output Only] The current state of this attachment's functionality. Enum values ACTIVE and UNPROVISIONED are shared by DEDICATED/PRIVATE, PARTNER, and PARTNER_PROVIDER interconnect attachments, while enum values PENDING_PARTNER, PARTNER_REQUEST_RECEIVED, and PENDING_CUSTOMER are used for only PARTNER and PARTNER_PROVIDER interconnect attachments. This state can take one of the following values:
// - ACTIVE: The attachment has been turned up and is ready to use.
// - UNPROVISIONED: The attachment is not ready to use yet, because turnup is not complete.
// - PENDING_PARTNER: A newly-created PARTNER attachment that has not yet been configured on the Partner side.
// - PARTNER_REQUEST_RECEIVED: A PARTNER attachment is in the process of provisioning after a PARTNER_PROVIDER attachment was created that references it.
// - PENDING_CUSTOMER: A PARTNER or PARTNER_PROVIDER attachment that is waiting for a customer to activate it.
// - DEFUNCT: The attachment was deleted externally and is no longer functional. This could be because the associated Interconnect was removed, or because the other side of a Partner attachment was deleted.
type InterconnectAttachment_State int32

const (
	// A value indicating that the enum field is not set.
	InterconnectAttachment_UNDEFINED_STATE          InterconnectAttachment_State = 0
	InterconnectAttachment_ACTIVE                   InterconnectAttachment_State = 314733318
	InterconnectAttachment_DEFUNCT                  InterconnectAttachment_State = 115891759
	InterconnectAttachment_PARTNER_REQUEST_RECEIVED InterconnectAttachment_State = 513587304
	InterconnectAttachment_PENDING_CUSTOMER         InterconnectAttachment_State = 167494054
	InterconnectAttachment_PENDING_PARTNER          InterconnectAttachment_State = 387890656
	InterconnectAttachment_STATE_UNSPECIFIED        InterconnectAttachment_State = 470755401
	InterconnectAttachment_UNPROVISIONED            InterconnectAttachment_State = 517333979
)

// Enum value maps for InterconnectAttachment_State.
var (
	InterconnectAttachment_State_name = map[int32]string{
		0:         "UNDEFINED_STATE",
		314733318: "ACTIVE",
		115891759: "DEFUNCT",
		513587304: "PARTNER_REQUEST_RECEIVED",
		167494054: "PENDING_CUSTOMER",
		387890656: "PENDING_PARTNER",
		470755401: "STATE_UNSPECIFIED",
		517333979: "UNPROVISIONED",
	}
	InterconnectAttachment_State_value = map[string]int32{
		"UNDEFINED_STATE":          0,
		"ACTIVE":                   314733318,
		"DEFUNCT":                  115891759,
		"PARTNER_REQUEST_RECEIVED": 513587304,
		"PENDING_CUSTOMER":         167494054,
		"PENDING_PARTNER":          387890656,
		"STATE_UNSPECIFIED":        470755401,
		"UNPROVISIONED":            517333979,
	}
)

func (x InterconnectAttachment_State) Enum() *InterconnectAttachment_State {
	p := new(InterconnectAttachment_State)
	*p = x
	return p
}

func (x InterconnectAttachment_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (InterconnectAttachment_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[93].Descriptor()
}

func (InterconnectAttachment_State) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[93]
}

func (x InterconnectAttachment_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use InterconnectAttachment_State.Descriptor instead.
func (InterconnectAttachment_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{248, 4}
}

// The type of interconnect attachment this is, which can take one of the following values:
// - DEDICATED: an attachment to a Dedicated Interconnect.
// - PARTNER: an attachment to a Partner Interconnect, created by the customer.
// - PARTNER_PROVIDER: an attachment to a Partner Interconnect, created by the partner.
type InterconnectAttachment_Type int32

const (
	// A value indicating that the enum field is not set.
	InterconnectAttachment_UNDEFINED_TYPE   InterconnectAttachment_Type = 0
	InterconnectAttachment_DEDICATED        InterconnectAttachment_Type = 258411983
	InterconnectAttachment_PARTNER          InterconnectAttachment_Type = 461924520
	InterconnectAttachment_PARTNER_PROVIDER InterconnectAttachment_Type = 483261352
)

// Enum value maps for InterconnectAttachment_Type.
var (
	InterconnectAttachment_Type_name = map[int32]string{
		0:         "UNDEFINED_TYPE",
		258411983: "DEDICATED",
		461924520: "PARTNER",
		483261352: "PARTNER_PROVIDER",
	}
	InterconnectAttachment_Type_value = map[string]int32{
		"UNDEFINED_TYPE":   0,
		"DEDICATED":        258411983,
		"PARTNER":          461924520,
		"PARTNER_PROVIDER": 483261352,
	}
)

func (x InterconnectAttachment_Type) Enum() *InterconnectAttachment_Type {
	p := new(InterconnectAttachment_Type)
	*p = x
	return p
}

func (x InterconnectAttachment_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (InterconnectAttachment_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[94].Descriptor()
}

func (InterconnectAttachment_Type) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[94]
}

func (x InterconnectAttachment_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use InterconnectAttachment_Type.Descriptor instead.
func (InterconnectAttachment_Type) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{248, 5}
}

// The state of a LACP link, which can take one of the following values:
// - ACTIVE: The link is configured and active within the bundle.
// - DETACHED: The link is not configured within the bundle. This means that the rest of the object should be empty.
type InterconnectDiagnosticsLinkLACPStatus_State int32

const (
	// A value indicating that the enum field is not set.
	InterconnectDiagnosticsLinkLACPStatus_UNDEFINED_STATE InterconnectDiagnosticsLinkLACPStatus_State = 0
	InterconnectDiagnosticsLinkLACPStatus_ACTIVE          InterconnectDiagnosticsLinkLACPStatus_State = 314733318
	InterconnectDiagnosticsLinkLACPStatus_DETACHED        InterconnectDiagnosticsLinkLACPStatus_State = 216562546
)

// Enum value maps for InterconnectDiagnosticsLinkLACPStatus_State.
var (
	InterconnectDiagnosticsLinkLACPStatus_State_name = map[int32]string{
		0:         "UNDEFINED_STATE",
		314733318: "ACTIVE",
		216562546: "DETACHED",
	}
	InterconnectDiagnosticsLinkLACPStatus_State_value = map[string]int32{
		"UNDEFINED_STATE": 0,
		"ACTIVE":          314733318,
		"DETACHED":        216562546,
	}
)

func (x InterconnectDiagnosticsLinkLACPStatus_State) Enum() *InterconnectDiagnosticsLinkLACPStatus_State {
	p := new(InterconnectDiagnosticsLinkLACPStatus_State)
	*p = x
	return p
}

func (x InterconnectDiagnosticsLinkLACPStatus_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (InterconnectDiagnosticsLinkLACPStatus_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[95].Descriptor()
}

func (InterconnectDiagnosticsLinkLACPStatus_State) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[95]
}

func (x InterconnectDiagnosticsLinkLACPStatus_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use InterconnectDiagnosticsLinkLACPStatus_State.Descriptor instead.
func (InterconnectDiagnosticsLinkLACPStatus_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{255, 0}
}

// The status of the current value when compared to the warning and alarm levels for the receiving or transmitting transceiver. Possible states include:
// - OK: The value has not crossed a warning threshold.
// - LOW_WARNING: The value has crossed below the low warning threshold.
// - HIGH_WARNING: The value has crossed above the high warning threshold.
// - LOW_ALARM: The value has crossed below the low alarm threshold.
// - HIGH_ALARM: The value has crossed above the high alarm threshold.
type InterconnectDiagnosticsLinkOpticalPower_State int32

const (
	// A value indicating that the enum field is not set.
	InterconnectDiagnosticsLinkOpticalPower_UNDEFINED_STATE InterconnectDiagnosticsLinkOpticalPower_State = 0
	InterconnectDiagnosticsLinkOpticalPower_HIGH_ALARM      InterconnectDiagnosticsLinkOpticalPower_State = 305363284
	InterconnectDiagnosticsLinkOpticalPower_HIGH_WARNING    InterconnectDiagnosticsLinkOpticalPower_State = 220984799
	InterconnectDiagnosticsLinkOpticalPower_LOW_ALARM       InterconnectDiagnosticsLinkOpticalPower_State = 316659046
	InterconnectDiagnosticsLinkOpticalPower_LOW_WARNING     InterconnectDiagnosticsLinkOpticalPower_State = 338793841
	InterconnectDiagnosticsLinkOpticalPower_OK              InterconnectDiagnosticsLinkOpticalPower_State = 2524
)

// Enum value maps for InterconnectDiagnosticsLinkOpticalPower_State.
var (
	InterconnectDiagnosticsLinkOpticalPower_State_name = map[int32]string{
		0:         "UNDEFINED_STATE",
		305363284: "HIGH_ALARM",
		220984799: "HIGH_WARNING",
		316659046: "LOW_ALARM",
		338793841: "LOW_WARNING",
		2524:      "OK",
	}
	InterconnectDiagnosticsLinkOpticalPower_State_value = map[string]int32{
		"UNDEFINED_STATE": 0,
		"HIGH_ALARM":      305363284,
		"HIGH_WARNING":    220984799,
		"LOW_ALARM":       316659046,
		"LOW_WARNING":     338793841,
		"OK":              2524,
	}
)

func (x InterconnectDiagnosticsLinkOpticalPower_State) Enum() *InterconnectDiagnosticsLinkOpticalPower_State {
	p := new(InterconnectDiagnosticsLinkOpticalPower_State)
	*p = x
	return p
}

func (x InterconnectDiagnosticsLinkOpticalPower_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (InterconnectDiagnosticsLinkOpticalPower_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[96].Descriptor()
}

func (InterconnectDiagnosticsLinkOpticalPower_State) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[96]
}

func (x InterconnectDiagnosticsLinkOpticalPower_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use InterconnectDiagnosticsLinkOpticalPower_State.Descriptor instead.
func (InterconnectDiagnosticsLinkOpticalPower_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{256, 0}
}

// Identifies the network presence of this location.
type InterconnectLocationRegionInfo_LocationPresence int32

const (
	// A value indicating that the enum field is not set.
	InterconnectLocationRegionInfo_UNDEFINED_LOCATION_PRESENCE InterconnectLocationRegionInfo_LocationPresence = 0
	InterconnectLocationRegionInfo_GLOBAL                      InterconnectLocationRegionInfo_LocationPresence = 494663587
	InterconnectLocationRegionInfo_LOCAL_REGION                InterconnectLocationRegionInfo_LocationPresence = 403535464
	InterconnectLocationRegionInfo_LP_GLOBAL                   InterconnectLocationRegionInfo_LocationPresence = 429584062
	InterconnectLocationRegionInfo_LP_LOCAL_REGION             InterconnectLocationRegionInfo_LocationPresence = 488598851
)

// Enum value maps for InterconnectLocationRegionInfo_LocationPresence.
var (
	InterconnectLocationRegionInfo_LocationPresence_name = map[int32]string{
		0:         "UNDEFINED_LOCATION_PRESENCE",
		494663587: "GLOBAL",
		403535464: "LOCAL_REGION",
		429584062: "LP_GLOBAL",
		488598851: "LP_LOCAL_REGION",
	}
	InterconnectLocationRegionInfo_LocationPresence_value = map[string]int32{
		"UNDEFINED_LOCATION_PRESENCE": 0,
		"GLOBAL":                      494663587,
		"LOCAL_REGION":                403535464,
		"LP_GLOBAL":                   429584062,
		"LP_LOCAL_REGION":             488598851,
	}
)

func (x InterconnectLocationRegionInfo_LocationPresence) Enum() *InterconnectLocationRegionInfo_LocationPresence {
	p := new(InterconnectLocationRegionInfo_LocationPresence)
	*p = x
	return p
}

func (x InterconnectLocationRegionInfo_LocationPresence) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (InterconnectLocationRegionInfo_LocationPresence) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[97].Descriptor()
}

func (InterconnectLocationRegionInfo_LocationPresence) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[97]
}

func (x InterconnectLocationRegionInfo_LocationPresence) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use InterconnectLocationRegionInfo_LocationPresence.Descriptor instead.
func (InterconnectLocationRegionInfo_LocationPresence) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{258, 0}
}

// [Output Only] Continent for this location, which can take one of the following values:
// - AFRICA
// - ASIA_PAC
// - EUROPE
// - NORTH_AMERICA
// - SOUTH_AMERICA
type InterconnectLocation_Continent int32

const (
	// A value indicating that the enum field is not set.
	InterconnectLocation_UNDEFINED_CONTINENT InterconnectLocation_Continent = 0
	InterconnectLocation_AFRICA              InterconnectLocation_Continent = 317443706
	InterconnectLocation_ASIA_PAC            InterconnectLocation_Continent = 119782269
	InterconnectLocation_C_AFRICA            InterconnectLocation_Continent = 71993846
	InterconnectLocation_C_ASIA_PAC          InterconnectLocation_Continent = 465668089
	InterconnectLocation_C_EUROPE            InterconnectLocation_Continent = 200369438
	InterconnectLocation_C_NORTH_AMERICA     InterconnectLocation_Continent = 275697048
	InterconnectLocation_C_SOUTH_AMERICA     InterconnectLocation_Continent = 397149792
	InterconnectLocation_EUROPE              InterconnectLocation_Continent = 445819298
	InterconnectLocation_NORTH_AMERICA       InterconnectLocation_Continent = 448015508
	InterconnectLocation_SOUTH_AMERICA       InterconnectLocation_Continent = 32597340
)

// Enum value maps for InterconnectLocation_Continent.
var (
	InterconnectLocation_Continent_name = map[int32]string{
		0:         "UNDEFINED_CONTINENT",
		317443706: "AFRICA",
		119782269: "ASIA_PAC",
		71993846:  "C_AFRICA",
		465668089: "C_ASIA_PAC",
		200369438: "C_EUROPE",
		275697048: "C_NORTH_AMERICA",
		397149792: "C_SOUTH_AMERICA",
		445819298: "EUROPE",
		448015508: "NORTH_AMERICA",
		32597340:  "SOUTH_AMERICA",
	}
	InterconnectLocation_Continent_value = map[string]int32{
		"UNDEFINED_CONTINENT": 0,
		"AFRICA":              317443706,
		"ASIA_PAC":            119782269,
		"C_AFRICA":            71993846,
		"C_ASIA_PAC":          465668089,
		"C_EUROPE":            200369438,
		"C_NORTH_AMERICA":     275697048,
		"C_SOUTH_AMERICA":     397149792,
		"EUROPE":              445819298,
		"NORTH_AMERICA":       448015508,
		"SOUTH_AMERICA":       32597340,
	}
)

func (x InterconnectLocation_Continent) Enum() *InterconnectLocation_Continent {
	p := new(InterconnectLocation_Continent)
	*p = x
	return p
}

func (x InterconnectLocation_Continent) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (InterconnectLocation_Continent) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[98].Descriptor()
}

func (InterconnectLocation_Continent) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[98]
}

func (x InterconnectLocation_Continent) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use InterconnectLocation_Continent.Descriptor instead.
func (InterconnectLocation_Continent) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{259, 0}
}

// [Output Only] The status of this InterconnectLocation, which can take one of the following values:
// - CLOSED: The InterconnectLocation is closed and is unavailable for provisioning new Interconnects.
// - AVAILABLE: The InterconnectLocation is available for provisioning new Interconnects.
type InterconnectLocation_Status int32

const (
	// A value indicating that the enum field is not set.
	InterconnectLocation_UNDEFINED_STATUS InterconnectLocation_Status = 0
	InterconnectLocation_AVAILABLE        InterconnectLocation_Status = 442079913
	InterconnectLocation_CLOSED           InterconnectLocation_Status = 380163436
)

// Enum value maps for InterconnectLocation_Status.
var (
	InterconnectLocation_Status_name = map[int32]string{
		0:         "UNDEFINED_STATUS",
		442079913: "AVAILABLE",
		380163436: "CLOSED",
	}
	InterconnectLocation_Status_value = map[string]int32{
		"UNDEFINED_STATUS": 0,
		"AVAILABLE":        442079913,
		"CLOSED":           380163436,
	}
)

func (x InterconnectLocation_Status) Enum() *InterconnectLocation_Status {
	p := new(InterconnectLocation_Status)
	*p = x
	return p
}

func (x InterconnectLocation_Status) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (InterconnectLocation_Status) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[99].Descriptor()
}

func (InterconnectLocation_Status) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[99]
}

func (x InterconnectLocation_Status) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use InterconnectLocation_Status.Descriptor instead.
func (InterconnectLocation_Status) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{259, 1}
}

// [Output Only] Current state of this License Code.
type LicenseCode_State int32

const (
	// A value indicating that the enum field is not set.
	LicenseCode_UNDEFINED_STATE   LicenseCode_State = 0
	LicenseCode_DISABLED          LicenseCode_State = 516696700
	LicenseCode_ENABLED           LicenseCode_State = 182130465
	LicenseCode_RESTRICTED        LicenseCode_State = 261551195
	LicenseCode_STATE_UNSPECIFIED LicenseCode_State = 470755401
	LicenseCode_TERMINATED        LicenseCode_State = 250018339
)

// Enum value maps for LicenseCode_State.
var (
	LicenseCode_State_name = map[int32]string{
		0:         "UNDEFINED_STATE",
		516696700: "DISABLED",
		182130465: "ENABLED",
		261551195: "RESTRICTED",
		470755401: "STATE_UNSPECIFIED",
		250018339: "TERMINATED",
	}
	LicenseCode_State_value = map[string]int32{
		"UNDEFINED_STATE":   0,
		"DISABLED":          516696700,
		"ENABLED":           182130465,
		"RESTRICTED":        261551195,
		"STATE_UNSPECIFIED": 470755401,
		"TERMINATED":        250018339,
	}
)

func (x LicenseCode_State) Enum() *LicenseCode_State {
	p := new(LicenseCode_State)
	*p = x
	return p
}

func (x LicenseCode_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (LicenseCode_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[100].Descriptor()
}

func (LicenseCode_State) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[100]
}

func (x LicenseCode_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use LicenseCode_State.Descriptor instead.
func (LicenseCode_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{265, 0}
}

// Preference for a given locaction: ALLOW or DENY.
type LocationPolicyLocation_Preference int32

const (
	// A value indicating that the enum field is not set.
	LocationPolicyLocation_UNDEFINED_PREFERENCE   LocationPolicyLocation_Preference = 0
	LocationPolicyLocation_ALLOW                  LocationPolicyLocation_Preference = 62368553
	LocationPolicyLocation_DENY                   LocationPolicyLocation_Preference = 2094604
	LocationPolicyLocation_PREFERENCE_UNSPECIFIED LocationPolicyLocation_Preference = 496219571
)

// Enum value maps for LocationPolicyLocation_Preference.
var (
	LocationPolicyLocation_Preference_name = map[int32]string{
		0:         "UNDEFINED_PREFERENCE",
		62368553:  "ALLOW",
		2094604:   "DENY",
		496219571: "PREFERENCE_UNSPECIFIED",
	}
	LocationPolicyLocation_Preference_value = map[string]int32{
		"UNDEFINED_PREFERENCE":   0,
		"ALLOW":                  62368553,
		"DENY":                   2094604,
		"PREFERENCE_UNSPECIFIED": 496219571,
	}
)

func (x LocationPolicyLocation_Preference) Enum() *LocationPolicyLocation_Preference {
	p := new(LocationPolicyLocation_Preference)
	*p = x
	return p
}

func (x LocationPolicyLocation_Preference) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (LocationPolicyLocation_Preference) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[101].Descriptor()
}

func (LocationPolicyLocation_Preference) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[101]
}

func (x LocationPolicyLocation_Preference) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use LocationPolicyLocation_Preference.Descriptor instead.
func (LocationPolicyLocation_Preference) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{268, 0}
}

// The log_name to populate in the Cloud Audit Record.
type LogConfigCloudAuditOptions_LogName int32

const (
	// A value indicating that the enum field is not set.
	LogConfigCloudAuditOptions_UNDEFINED_LOG_NAME   LogConfigCloudAuditOptions_LogName = 0
	LogConfigCloudAuditOptions_ADMIN_ACTIVITY       LogConfigCloudAuditOptions_LogName = 427503135
	LogConfigCloudAuditOptions_DATA_ACCESS          LogConfigCloudAuditOptions_LogName = 238070681
	LogConfigCloudAuditOptions_UNSPECIFIED_LOG_NAME LogConfigCloudAuditOptions_LogName = 410515182
)

// Enum value maps for LogConfigCloudAuditOptions_LogName.
var (
	LogConfigCloudAuditOptions_LogName_name = map[int32]string{
		0:         "UNDEFINED_LOG_NAME",
		427503135: "ADMIN_ACTIVITY",
		238070681: "DATA_ACCESS",
		410515182: "UNSPECIFIED_LOG_NAME",
	}
	LogConfigCloudAuditOptions_LogName_value = map[string]int32{
		"UNDEFINED_LOG_NAME":   0,
		"ADMIN_ACTIVITY":       427503135,
		"DATA_ACCESS":          238070681,
		"UNSPECIFIED_LOG_NAME": 410515182,
	}
)

func (x LogConfigCloudAuditOptions_LogName) Enum() *LogConfigCloudAuditOptions_LogName {
	p := new(LogConfigCloudAuditOptions_LogName)
	*p = x
	return p
}

func (x LogConfigCloudAuditOptions_LogName) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (LogConfigCloudAuditOptions_LogName) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[102].Descriptor()
}

func (LogConfigCloudAuditOptions_LogName) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[102]
}

func (x LogConfigCloudAuditOptions_LogName) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use LogConfigCloudAuditOptions_LogName.Descriptor instead.
func (LogConfigCloudAuditOptions_LogName) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{269, 0}
}

//
type LogConfigDataAccessOptions_LogMode int32

const (
	// A value indicating that the enum field is not set.
	LogConfigDataAccessOptions_UNDEFINED_LOG_MODE   LogConfigDataAccessOptions_LogMode = 0
	LogConfigDataAccessOptions_LOG_FAIL_CLOSED      LogConfigDataAccessOptions_LogMode = 360469778
	LogConfigDataAccessOptions_LOG_MODE_UNSPECIFIED LogConfigDataAccessOptions_LogMode = 88160822
)

// Enum value maps for LogConfigDataAccessOptions_LogMode.
var (
	LogConfigDataAccessOptions_LogMode_name = map[int32]string{
		0:         "UNDEFINED_LOG_MODE",
		360469778: "LOG_FAIL_CLOSED",
		88160822:  "LOG_MODE_UNSPECIFIED",
	}
	LogConfigDataAccessOptions_LogMode_value = map[string]int32{
		"UNDEFINED_LOG_MODE":   0,
		"LOG_FAIL_CLOSED":      360469778,
		"LOG_MODE_UNSPECIFIED": 88160822,
	}
)

func (x LogConfigDataAccessOptions_LogMode) Enum() *LogConfigDataAccessOptions_LogMode {
	p := new(LogConfigDataAccessOptions_LogMode)
	*p = x
	return p
}

func (x LogConfigDataAccessOptions_LogMode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (LogConfigDataAccessOptions_LogMode) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[103].Descriptor()
}

func (LogConfigDataAccessOptions_LogMode) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[103]
}

func (x LogConfigDataAccessOptions_LogMode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use LogConfigDataAccessOptions_LogMode.Descriptor instead.
func (LogConfigDataAccessOptions_LogMode) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{271, 0}
}

// [Output Only] The current detailed instance health state.
type ManagedInstanceInstanceHealth_DetailedHealthState int32

const (
	// A value indicating that the enum field is not set.
	ManagedInstanceInstanceHealth_UNDEFINED_DETAILED_HEALTH_STATE ManagedInstanceInstanceHealth_DetailedHealthState = 0
	ManagedInstanceInstanceHealth_DRAINING                        ManagedInstanceInstanceHealth_DetailedHealthState = 480455402
	ManagedInstanceInstanceHealth_HEALTHY                         ManagedInstanceInstanceHealth_DetailedHealthState = 439801213
	ManagedInstanceInstanceHealth_TIMEOUT                         ManagedInstanceInstanceHealth_DetailedHealthState = 477813057
	ManagedInstanceInstanceHealth_UNHEALTHY                       ManagedInstanceInstanceHealth_DetailedHealthState = 462118084
	ManagedInstanceInstanceHealth_UNKNOWN                         ManagedInstanceInstanceHealth_DetailedHealthState = 433141802
)

// Enum value maps for ManagedInstanceInstanceHealth_DetailedHealthState.
var (
	ManagedInstanceInstanceHealth_DetailedHealthState_name = map[int32]string{
		0:         "UNDEFINED_DETAILED_HEALTH_STATE",
		480455402: "DRAINING",
		439801213: "HEALTHY",
		477813057: "TIMEOUT",
		462118084: "UNHEALTHY",
		433141802: "UNKNOWN",
	}
	ManagedInstanceInstanceHealth_DetailedHealthState_value = map[string]int32{
		"UNDEFINED_DETAILED_HEALTH_STATE": 0,
		"DRAINING":                        480455402,
		"HEALTHY":                         439801213,
		"TIMEOUT":                         477813057,
		"UNHEALTHY":                       462118084,
		"UNKNOWN":                         433141802,
	}
)

func (x ManagedInstanceInstanceHealth_DetailedHealthState) Enum() *ManagedInstanceInstanceHealth_DetailedHealthState {
	p := new(ManagedInstanceInstanceHealth_DetailedHealthState)
	*p = x
	return p
}

func (x ManagedInstanceInstanceHealth_DetailedHealthState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ManagedInstanceInstanceHealth_DetailedHealthState) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[104].Descriptor()
}

func (ManagedInstanceInstanceHealth_DetailedHealthState) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[104]
}

func (x ManagedInstanceInstanceHealth_DetailedHealthState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ManagedInstanceInstanceHealth_DetailedHealthState.Descriptor instead.
func (ManagedInstanceInstanceHealth_DetailedHealthState) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{280, 0}
}

// [Output Only] State for the peering, either `ACTIVE` or `INACTIVE`. The peering is `ACTIVE` when there's a matching configuration in the peer network.
type NetworkPeering_State int32

const (
	// A value indicating that the enum field is not set.
	NetworkPeering_UNDEFINED_STATE NetworkPeering_State = 0
	NetworkPeering_ACTIVE          NetworkPeering_State = 314733318
	NetworkPeering_INACTIVE        NetworkPeering_State = 270421099
)

// Enum value maps for NetworkPeering_State.
var (
	NetworkPeering_State_name = map[int32]string{
		0:         "UNDEFINED_STATE",
		314733318: "ACTIVE",
		270421099: "INACTIVE",
	}
	NetworkPeering_State_value = map[string]int32{
		"UNDEFINED_STATE": 0,
		"ACTIVE":          314733318,
		"INACTIVE":        270421099,
	}
)

func (x NetworkPeering_State) Enum() *NetworkPeering_State {
	p := new(NetworkPeering_State)
	*p = x
	return p
}

func (x NetworkPeering_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (NetworkPeering_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[105].Descriptor()
}

func (NetworkPeering_State) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[105]
}

func (x NetworkPeering_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use NetworkPeering_State.Descriptor instead.
func (NetworkPeering_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{286, 0}
}

// The network-wide routing mode to use. If set to REGIONAL, this network's Cloud Routers will only advertise routes with subnets of this network in the same region as the router. If set to GLOBAL, this network's Cloud Routers will advertise routes with all subnets of this network, across regions.
type NetworkRoutingConfig_RoutingMode int32

const (
	// A value indicating that the enum field is not set.
	NetworkRoutingConfig_UNDEFINED_ROUTING_MODE NetworkRoutingConfig_RoutingMode = 0
	NetworkRoutingConfig_GLOBAL                 NetworkRoutingConfig_RoutingMode = 494663587
	NetworkRoutingConfig_REGIONAL               NetworkRoutingConfig_RoutingMode = 92288543
)

// Enum value maps for NetworkRoutingConfig_RoutingMode.
var (
	NetworkRoutingConfig_RoutingMode_name = map[int32]string{
		0:         "UNDEFINED_ROUTING_MODE",
		494663587: "GLOBAL",
		92288543:  "REGIONAL",
	}
	NetworkRoutingConfig_RoutingMode_value = map[string]int32{
		"UNDEFINED_ROUTING_MODE": 0,
		"GLOBAL":                 494663587,
		"REGIONAL":               92288543,
	}
)

func (x NetworkRoutingConfig_RoutingMode) Enum() *NetworkRoutingConfig_RoutingMode {
	p := new(NetworkRoutingConfig_RoutingMode)
	*p = x
	return p
}

func (x NetworkRoutingConfig_RoutingMode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (NetworkRoutingConfig_RoutingMode) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[106].Descriptor()
}

func (NetworkRoutingConfig_RoutingMode) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[106]
}

func (x NetworkRoutingConfig_RoutingMode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use NetworkRoutingConfig_RoutingMode.Descriptor instead.
func (NetworkRoutingConfig_RoutingMode) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{287, 0}
}

// Type of network endpoints in this network endpoint group. Can be one of GCE_VM_IP_PORT, NON_GCP_PRIVATE_IP_PORT, INTERNET_FQDN_PORT, INTERNET_IP_PORT, or SERVERLESS.
type NetworkEndpointGroup_NetworkEndpointType int32

const (
	// A value indicating that the enum field is not set.
	NetworkEndpointGroup_UNDEFINED_NETWORK_ENDPOINT_TYPE NetworkEndpointGroup_NetworkEndpointType = 0
	NetworkEndpointGroup_GCE_VM_IP                       NetworkEndpointGroup_NetworkEndpointType = 401880793
	NetworkEndpointGroup_GCE_VM_IP_PORT                  NetworkEndpointGroup_NetworkEndpointType = 501838375
	NetworkEndpointGroup_INTERNET_FQDN_PORT              NetworkEndpointGroup_NetworkEndpointType = 404154477
	NetworkEndpointGroup_INTERNET_IP_PORT                NetworkEndpointGroup_NetworkEndpointType = 477719963
	NetworkEndpointGroup_NON_GCP_PRIVATE_IP_PORT         NetworkEndpointGroup_NetworkEndpointType = 336447968
	NetworkEndpointGroup_SERVERLESS                      NetworkEndpointGroup_NetworkEndpointType = 270492508
)

// Enum value maps for NetworkEndpointGroup_NetworkEndpointType.
var (
	NetworkEndpointGroup_NetworkEndpointType_name = map[int32]string{
		0:         "UNDEFINED_NETWORK_ENDPOINT_TYPE",
		401880793: "GCE_VM_IP",
		501838375: "GCE_VM_IP_PORT",
		404154477: "INTERNET_FQDN_PORT",
		477719963: "INTERNET_IP_PORT",
		336447968: "NON_GCP_PRIVATE_IP_PORT",
		270492508: "SERVERLESS",
	}
	NetworkEndpointGroup_NetworkEndpointType_value = map[string]int32{
		"UNDEFINED_NETWORK_ENDPOINT_TYPE": 0,
		"GCE_VM_IP":                       401880793,
		"GCE_VM_IP_PORT":                  501838375,
		"INTERNET_FQDN_PORT":              404154477,
		"INTERNET_IP_PORT":                477719963,
		"NON_GCP_PRIVATE_IP_PORT":         336447968,
		"SERVERLESS":                      270492508,
	}
)

func (x NetworkEndpointGroup_NetworkEndpointType) Enum() *NetworkEndpointGroup_NetworkEndpointType {
	p := new(NetworkEndpointGroup_NetworkEndpointType)
	*p = x
	return p
}

func (x NetworkEndpointGroup_NetworkEndpointType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (NetworkEndpointGroup_NetworkEndpointType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[107].Descriptor()
}

func (NetworkEndpointGroup_NetworkEndpointType) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[107]
}

func (x NetworkEndpointGroup_NetworkEndpointType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use NetworkEndpointGroup_NetworkEndpointType.Descriptor instead.
func (NetworkEndpointGroup_NetworkEndpointType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{292, 0}
}

// Optional query parameter for showing the health status of each network endpoint. Valid options are SKIP or SHOW. If you don't specify this parameter, the health status of network endpoints will not be provided.
type NetworkEndpointGroupsListEndpointsRequest_HealthStatus int32

const (
	// A value indicating that the enum field is not set.
	NetworkEndpointGroupsListEndpointsRequest_UNDEFINED_HEALTH_STATUS NetworkEndpointGroupsListEndpointsRequest_HealthStatus = 0
	NetworkEndpointGroupsListEndpointsRequest_SHOW                    NetworkEndpointGroupsListEndpointsRequest_HealthStatus = 2544381
	NetworkEndpointGroupsListEndpointsRequest_SKIP                    NetworkEndpointGroupsListEndpointsRequest_HealthStatus = 2547071
)

// Enum value maps for NetworkEndpointGroupsListEndpointsRequest_HealthStatus.
var (
	NetworkEndpointGroupsListEndpointsRequest_HealthStatus_name = map[int32]string{
		0:       "UNDEFINED_HEALTH_STATUS",
		2544381: "SHOW",
		2547071: "SKIP",
	}
	NetworkEndpointGroupsListEndpointsRequest_HealthStatus_value = map[string]int32{
		"UNDEFINED_HEALTH_STATUS": 0,
		"SHOW":                    2544381,
		"SKIP":                    2547071,
	}
)

func (x NetworkEndpointGroupsListEndpointsRequest_HealthStatus) Enum() *NetworkEndpointGroupsListEndpointsRequest_HealthStatus {
	p := new(NetworkEndpointGroupsListEndpointsRequest_HealthStatus)
	*p = x
	return p
}

func (x NetworkEndpointGroupsListEndpointsRequest_HealthStatus) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (NetworkEndpointGroupsListEndpointsRequest_HealthStatus) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[108].Descriptor()
}

func (NetworkEndpointGroupsListEndpointsRequest_HealthStatus) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[108]
}

func (x NetworkEndpointGroupsListEndpointsRequest_HealthStatus) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use NetworkEndpointGroupsListEndpointsRequest_HealthStatus.Descriptor instead.
func (NetworkEndpointGroupsListEndpointsRequest_HealthStatus) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{298, 0}
}

// [Output Only] The type of the firewall policy.
type NetworksGetEffectiveFirewallsResponseEffectiveFirewallPolicy_Type int32

const (
	// A value indicating that the enum field is not set.
	NetworksGetEffectiveFirewallsResponseEffectiveFirewallPolicy_UNDEFINED_TYPE NetworksGetEffectiveFirewallsResponseEffectiveFirewallPolicy_Type = 0
	NetworksGetEffectiveFirewallsResponseEffectiveFirewallPolicy_HIERARCHY      NetworksGetEffectiveFirewallsResponseEffectiveFirewallPolicy_Type = 69902869
	NetworksGetEffectiveFirewallsResponseEffectiveFirewallPolicy_NETWORK        NetworksGetEffectiveFirewallsResponseEffectiveFirewallPolicy_Type = 413984270
	NetworksGetEffectiveFirewallsResponseEffectiveFirewallPolicy_UNSPECIFIED    NetworksGetEffectiveFirewallsResponseEffectiveFirewallPolicy_Type = 526786327
)

// Enum value maps for NetworksGetEffectiveFirewallsResponseEffectiveFirewallPolicy_Type.
var (
	NetworksGetEffectiveFirewallsResponseEffectiveFirewallPolicy_Type_name = map[int32]string{
		0:         "UNDEFINED_TYPE",
		69902869:  "HIERARCHY",
		413984270: "NETWORK",
		526786327: "UNSPECIFIED",
	}
	NetworksGetEffectiveFirewallsResponseEffectiveFirewallPolicy_Type_value = map[string]int32{
		"UNDEFINED_TYPE": 0,
		"HIERARCHY":      69902869,
		"NETWORK":        413984270,
		"UNSPECIFIED":    526786327,
	}
)

func (x NetworksGetEffectiveFirewallsResponseEffectiveFirewallPolicy_Type) Enum() *NetworksGetEffectiveFirewallsResponseEffectiveFirewallPolicy_Type {
	p := new(NetworksGetEffectiveFirewallsResponseEffectiveFirewallPolicy_Type)
	*p = x
	return p
}

func (x NetworksGetEffectiveFirewallsResponseEffectiveFirewallPolicy_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (NetworksGetEffectiveFirewallsResponseEffectiveFirewallPolicy_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[109].Descriptor()
}

func (NetworksGetEffectiveFirewallsResponseEffectiveFirewallPolicy_Type) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[109]
}

func (x NetworksGetEffectiveFirewallsResponseEffectiveFirewallPolicy_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use NetworksGetEffectiveFirewallsResponseEffectiveFirewallPolicy_Type.Descriptor instead.
func (NetworksGetEffectiveFirewallsResponseEffectiveFirewallPolicy_Type) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{303, 0}
}

// The autoscaling mode. Set to one of: ON, OFF, or ONLY_SCALE_OUT. For more information, see  Autoscaler modes.
type NodeGroupAutoscalingPolicy_Mode int32

const (
	// A value indicating that the enum field is not set.
	NodeGroupAutoscalingPolicy_UNDEFINED_MODE   NodeGroupAutoscalingPolicy_Mode = 0
	NodeGroupAutoscalingPolicy_MODE_UNSPECIFIED NodeGroupAutoscalingPolicy_Mode = 371348091
	NodeGroupAutoscalingPolicy_OFF              NodeGroupAutoscalingPolicy_Mode = 78159
	NodeGroupAutoscalingPolicy_ON               NodeGroupAutoscalingPolicy_Mode = 2527
	NodeGroupAutoscalingPolicy_ONLY_SCALE_OUT   NodeGroupAutoscalingPolicy_Mode = 152713670
)

// Enum value maps for NodeGroupAutoscalingPolicy_Mode.
var (
	NodeGroupAutoscalingPolicy_Mode_name = map[int32]string{
		0:         "UNDEFINED_MODE",
		371348091: "MODE_UNSPECIFIED",
		78159:     "OFF",
		2527:      "ON",
		152713670: "ONLY_SCALE_OUT",
	}
	NodeGroupAutoscalingPolicy_Mode_value = map[string]int32{
		"UNDEFINED_MODE":   0,
		"MODE_UNSPECIFIED": 371348091,
		"OFF":              78159,
		"ON":               2527,
		"ONLY_SCALE_OUT":   152713670,
	}
)

func (x NodeGroupAutoscalingPolicy_Mode) Enum() *NodeGroupAutoscalingPolicy_Mode {
	p := new(NodeGroupAutoscalingPolicy_Mode)
	*p = x
	return p
}

func (x NodeGroupAutoscalingPolicy_Mode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (NodeGroupAutoscalingPolicy_Mode) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[110].Descriptor()
}

func (NodeGroupAutoscalingPolicy_Mode) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[110]
}

func (x NodeGroupAutoscalingPolicy_Mode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use NodeGroupAutoscalingPolicy_Mode.Descriptor instead.
func (NodeGroupAutoscalingPolicy_Mode) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{307, 0}
}

// Specifies how to handle instances when a node in the group undergoes maintenance. Set to one of: DEFAULT, RESTART_IN_PLACE, or MIGRATE_WITHIN_NODE_GROUP. The default value is DEFAULT. For more information, see  Maintenance policies.
type NodeGroup_MaintenancePolicy int32

const (
	// A value indicating that the enum field is not set.
	NodeGroup_UNDEFINED_MAINTENANCE_POLICY   NodeGroup_MaintenancePolicy = 0
	NodeGroup_DEFAULT                        NodeGroup_MaintenancePolicy = 115302945
	NodeGroup_MAINTENANCE_POLICY_UNSPECIFIED NodeGroup_MaintenancePolicy = 72964182
	NodeGroup_MIGRATE_WITHIN_NODE_GROUP      NodeGroup_MaintenancePolicy = 153483394
	NodeGroup_RESTART_IN_PLACE               NodeGroup_MaintenancePolicy = 228647325
)

// Enum value maps for NodeGroup_MaintenancePolicy.
var (
	NodeGroup_MaintenancePolicy_name = map[int32]string{
		0:         "UNDEFINED_MAINTENANCE_POLICY",
		115302945: "DEFAULT",
		72964182:  "MAINTENANCE_POLICY_UNSPECIFIED",
		153483394: "MIGRATE_WITHIN_NODE_GROUP",
		228647325: "RESTART_IN_PLACE",
	}
	NodeGroup_MaintenancePolicy_value = map[string]int32{
		"UNDEFINED_MAINTENANCE_POLICY":   0,
		"DEFAULT":                        115302945,
		"MAINTENANCE_POLICY_UNSPECIFIED": 72964182,
		"MIGRATE_WITHIN_NODE_GROUP":      153483394,
		"RESTART_IN_PLACE":               228647325,
	}
)

func (x NodeGroup_MaintenancePolicy) Enum() *NodeGroup_MaintenancePolicy {
	p := new(NodeGroup_MaintenancePolicy)
	*p = x
	return p
}

func (x NodeGroup_MaintenancePolicy) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (NodeGroup_MaintenancePolicy) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[111].Descriptor()
}

func (NodeGroup_MaintenancePolicy) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[111]
}

func (x NodeGroup_MaintenancePolicy) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use NodeGroup_MaintenancePolicy.Descriptor instead.
func (NodeGroup_MaintenancePolicy) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{309, 0}
}

//
type NodeGroup_Status int32

const (
	// A value indicating that the enum field is not set.
	NodeGroup_UNDEFINED_STATUS NodeGroup_Status = 0
	NodeGroup_CREATING         NodeGroup_Status = 455564985
	NodeGroup_DELETING         NodeGroup_Status = 528602024
	NodeGroup_INVALID          NodeGroup_Status = 530283991
	NodeGroup_READY            NodeGroup_Status = 77848963
)

// Enum value maps for NodeGroup_Status.
var (
	NodeGroup_Status_name = map[int32]string{
		0:         "UNDEFINED_STATUS",
		455564985: "CREATING",
		528602024: "DELETING",
		530283991: "INVALID",
		77848963:  "READY",
	}
	NodeGroup_Status_value = map[string]int32{
		"UNDEFINED_STATUS": 0,
		"CREATING":         455564985,
		"DELETING":         528602024,
		"INVALID":          530283991,
		"READY":            77848963,
	}
)

func (x NodeGroup_Status) Enum() *NodeGroup_Status {
	p := new(NodeGroup_Status)
	*p = x
	return p
}

func (x NodeGroup_Status) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (NodeGroup_Status) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[112].Descriptor()
}

func (NodeGroup_Status) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[112]
}

func (x NodeGroup_Status) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use NodeGroup_Status.Descriptor instead.
func (NodeGroup_Status) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{309, 1}
}

//
type ServerBinding_Type int32

const (
	// A value indicating that the enum field is not set.
	ServerBinding_UNDEFINED_TYPE                  ServerBinding_Type = 0
	ServerBinding_RESTART_NODE_ON_ANY_SERVER      ServerBinding_Type = 502950985
	ServerBinding_RESTART_NODE_ON_MINIMAL_SERVERS ServerBinding_Type = 204166495
	ServerBinding_SERVER_BINDING_TYPE_UNSPECIFIED ServerBinding_Type = 180825512
)

// Enum value maps for ServerBinding_Type.
var (
	ServerBinding_Type_name = map[int32]string{
		0:         "UNDEFINED_TYPE",
		502950985: "RESTART_NODE_ON_ANY_SERVER",
		204166495: "RESTART_NODE_ON_MINIMAL_SERVERS",
		180825512: "SERVER_BINDING_TYPE_UNSPECIFIED",
	}
	ServerBinding_Type_value = map[string]int32{
		"UNDEFINED_TYPE":                  0,
		"RESTART_NODE_ON_ANY_SERVER":      502950985,
		"RESTART_NODE_ON_MINIMAL_SERVERS": 204166495,
		"SERVER_BINDING_TYPE_UNSPECIFIED": 180825512,
	}
)

func (x ServerBinding_Type) Enum() *ServerBinding_Type {
	p := new(ServerBinding_Type)
	*p = x
	return p
}

func (x ServerBinding_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ServerBinding_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[113].Descriptor()
}

func (ServerBinding_Type) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[113]
}

func (x ServerBinding_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ServerBinding_Type.Descriptor instead.
func (ServerBinding_Type) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{313, 0}
}

// CPU overcommit.
type NodeGroupNode_CpuOvercommitType int32

const (
	// A value indicating that the enum field is not set.
	NodeGroupNode_UNDEFINED_CPU_OVERCOMMIT_TYPE   NodeGroupNode_CpuOvercommitType = 0
	NodeGroupNode_CPU_OVERCOMMIT_TYPE_UNSPECIFIED NodeGroupNode_CpuOvercommitType = 520665615
	NodeGroupNode_ENABLED                         NodeGroupNode_CpuOvercommitType = 182130465
	NodeGroupNode_NONE                            NodeGroupNode_CpuOvercommitType = 2402104
)

// Enum value maps for NodeGroupNode_CpuOvercommitType.
var (
	NodeGroupNode_CpuOvercommitType_name = map[int32]string{
		0:         "UNDEFINED_CPU_OVERCOMMIT_TYPE",
		520665615: "CPU_OVERCOMMIT_TYPE_UNSPECIFIED",
		182130465: "ENABLED",
		2402104:   "NONE",
	}
	NodeGroupNode_CpuOvercommitType_value = map[string]int32{
		"UNDEFINED_CPU_OVERCOMMIT_TYPE":   0,
		"CPU_OVERCOMMIT_TYPE_UNSPECIFIED": 520665615,
		"ENABLED":                         182130465,
		"NONE":                            2402104,
	}
)

func (x NodeGroupNode_CpuOvercommitType) Enum() *NodeGroupNode_CpuOvercommitType {
	p := new(NodeGroupNode_CpuOvercommitType)
	*p = x
	return p
}

func (x NodeGroupNode_CpuOvercommitType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (NodeGroupNode_CpuOvercommitType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[114].Descriptor()
}

func (NodeGroupNode_CpuOvercommitType) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[114]
}

func (x NodeGroupNode_CpuOvercommitType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use NodeGroupNode_CpuOvercommitType.Descriptor instead.
func (NodeGroupNode_CpuOvercommitType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{314, 0}
}

//
type NodeGroupNode_Status int32

const (
	// A value indicating that the enum field is not set.
	NodeGroupNode_UNDEFINED_STATUS NodeGroupNode_Status = 0
	NodeGroupNode_CREATING         NodeGroupNode_Status = 455564985
	NodeGroupNode_DELETING         NodeGroupNode_Status = 528602024
	NodeGroupNode_INVALID          NodeGroupNode_Status = 530283991
	NodeGroupNode_READY            NodeGroupNode_Status = 77848963
	NodeGroupNode_REPAIRING        NodeGroupNode_Status = 413483285
)

// Enum value maps for NodeGroupNode_Status.
var (
	NodeGroupNode_Status_name = map[int32]string{
		0:         "UNDEFINED_STATUS",
		455564985: "CREATING",
		528602024: "DELETING",
		530283991: "INVALID",
		77848963:  "READY",
		413483285: "REPAIRING",
	}
	NodeGroupNode_Status_value = map[string]int32{
		"UNDEFINED_STATUS": 0,
		"CREATING":         455564985,
		"DELETING":         528602024,
		"INVALID":          530283991,
		"READY":            77848963,
		"REPAIRING":        413483285,
	}
)

func (x NodeGroupNode_Status) Enum() *NodeGroupNode_Status {
	p := new(NodeGroupNode_Status)
	*p = x
	return p
}

func (x NodeGroupNode_Status) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (NodeGroupNode_Status) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[115].Descriptor()
}

func (NodeGroupNode_Status) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[115]
}

func (x NodeGroupNode_Status) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use NodeGroupNode_Status.Descriptor instead.
func (NodeGroupNode_Status) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{314, 1}
}

// CPU overcommit.
type NodeTemplate_CpuOvercommitType int32

const (
	// A value indicating that the enum field is not set.
	NodeTemplate_UNDEFINED_CPU_OVERCOMMIT_TYPE   NodeTemplate_CpuOvercommitType = 0
	NodeTemplate_CPU_OVERCOMMIT_TYPE_UNSPECIFIED NodeTemplate_CpuOvercommitType = 520665615
	NodeTemplate_ENABLED                         NodeTemplate_CpuOvercommitType = 182130465
	NodeTemplate_NONE                            NodeTemplate_CpuOvercommitType = 2402104
)

// Enum value maps for NodeTemplate_CpuOvercommitType.
var (
	NodeTemplate_CpuOvercommitType_name = map[int32]string{
		0:         "UNDEFINED_CPU_OVERCOMMIT_TYPE",
		520665615: "CPU_OVERCOMMIT_TYPE_UNSPECIFIED",
		182130465: "ENABLED",
		2402104:   "NONE",
	}
	NodeTemplate_CpuOvercommitType_value = map[string]int32{
		"UNDEFINED_CPU_OVERCOMMIT_TYPE":   0,
		"CPU_OVERCOMMIT_TYPE_UNSPECIFIED": 520665615,
		"ENABLED":                         182130465,
		"NONE":                            2402104,
	}
)

func (x NodeTemplate_CpuOvercommitType) Enum() *NodeTemplate_CpuOvercommitType {
	p := new(NodeTemplate_CpuOvercommitType)
	*p = x
	return p
}

func (x NodeTemplate_CpuOvercommitType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (NodeTemplate_CpuOvercommitType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[116].Descriptor()
}

func (NodeTemplate_CpuOvercommitType) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[116]
}

func (x NodeTemplate_CpuOvercommitType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use NodeTemplate_CpuOvercommitType.Descriptor instead.
func (NodeTemplate_CpuOvercommitType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{320, 0}
}

// [Output Only] The status of the node template. One of the following values: CREATING, READY, and DELETING.
type NodeTemplate_Status int32

const (
	// A value indicating that the enum field is not set.
	NodeTemplate_UNDEFINED_STATUS NodeTemplate_Status = 0
	NodeTemplate_CREATING         NodeTemplate_Status = 455564985
	NodeTemplate_DELETING         NodeTemplate_Status = 528602024
	NodeTemplate_INVALID          NodeTemplate_Status = 530283991
	NodeTemplate_READY            NodeTemplate_Status = 77848963
)

// Enum value maps for NodeTemplate_Status.
var (
	NodeTemplate_Status_name = map[int32]string{
		0:         "UNDEFINED_STATUS",
		455564985: "CREATING",
		528602024: "DELETING",
		530283991: "INVALID",
		77848963:  "READY",
	}
	NodeTemplate_Status_value = map[string]int32{
		"UNDEFINED_STATUS": 0,
		"CREATING":         455564985,
		"DELETING":         528602024,
		"INVALID":          530283991,
		"READY":            77848963,
	}
)

func (x NodeTemplate_Status) Enum() *NodeTemplate_Status {
	p := new(NodeTemplate_Status)
	*p = x
	return p
}

func (x NodeTemplate_Status) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (NodeTemplate_Status) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[117].Descriptor()
}

func (NodeTemplate_Status) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[117]
}

func (x NodeTemplate_Status) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use NodeTemplate_Status.Descriptor instead.
func (NodeTemplate_Status) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{320, 1}
}

// [Output Only] A warning code, if applicable. For example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in the response.
type Warnings_Code int32

const (
	// A value indicating that the enum field is not set.
	Warnings_UNDEFINED_CODE                            Warnings_Code = 0
	Warnings_CLEANUP_FAILED                            Warnings_Code = 150308440
	Warnings_DEPRECATED_RESOURCE_USED                  Warnings_Code = 391835586
	Warnings_DEPRECATED_TYPE_USED                      Warnings_Code = 346526230
	Warnings_DISK_SIZE_LARGER_THAN_IMAGE_SIZE          Warnings_Code = 369442967
	Warnings_EXPERIMENTAL_TYPE_USED                    Warnings_Code = 451954443
	Warnings_EXTERNAL_API_WARNING                      Warnings_Code = 175546307
	Warnings_FIELD_VALUE_OVERRIDEN                     Warnings_Code = 329669423
	Warnings_INJECTED_KERNELS_DEPRECATED               Warnings_Code = 417377419
	Warnings_LARGE_DEPLOYMENT_WARNING                  Warnings_Code = 481440678
	Warnings_MISSING_TYPE_DEPENDENCY                   Warnings_Code = 344505463
	Warnings_NEXT_HOP_ADDRESS_NOT_ASSIGNED             Warnings_Code = 324964999
	Warnings_NEXT_HOP_CANNOT_IP_FORWARD                Warnings_Code = 383382887
	Warnings_NEXT_HOP_INSTANCE_NOT_FOUND               Warnings_Code = 464250446
	Warnings_NEXT_HOP_INSTANCE_NOT_ON_NETWORK          Warnings_Code = 243758146
	Warnings_NEXT_HOP_NOT_RUNNING                      Warnings_Code = 417081265
	Warnings_NOT_CRITICAL_ERROR                        Warnings_Code = 105763924
	Warnings_NO_RESULTS_ON_PAGE                        Warnings_Code = 30036744
	Warnings_PARTIAL_SUCCESS                           Warnings_Code = 39966469
	Warnings_REQUIRED_TOS_AGREEMENT                    Warnings_Code = 3745539
	Warnings_RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING Warnings_Code = 496728641
	Warnings_RESOURCE_NOT_DELETED                      Warnings_Code = 168598460
	Warnings_SCHEMA_VALIDATION_IGNORED                 Warnings_Code = 275245642
	Warnings_SINGLE_INSTANCE_PROPERTY_TEMPLATE         Warnings_Code = 268305617
	Warnings_UNDECLARED_PROPERTIES                     Warnings_Code = 390513439
	Warnings_UNREACHABLE                               Warnings_Code = 13328052
)

// Enum value maps for Warnings_Code.
var (
	Warnings_Code_name = map[int32]string{
		0:         "UNDEFINED_CODE",
		150308440: "CLEANUP_FAILED",
		391835586: "DEPRECATED_RESOURCE_USED",
		346526230: "DEPRECATED_TYPE_USED",
		369442967: "DISK_SIZE_LARGER_THAN_IMAGE_SIZE",
		451954443: "EXPERIMENTAL_TYPE_USED",
		175546307: "EXTERNAL_API_WARNING",
		329669423: "FIELD_VALUE_OVERRIDEN",
		417377419: "INJECTED_KERNELS_DEPRECATED",
		481440678: "LARGE_DEPLOYMENT_WARNING",
		344505463: "MISSING_TYPE_DEPENDENCY",
		324964999: "NEXT_HOP_ADDRESS_NOT_ASSIGNED",
		383382887: "NEXT_HOP_CANNOT_IP_FORWARD",
		464250446: "NEXT_HOP_INSTANCE_NOT_FOUND",
		243758146: "NEXT_HOP_INSTANCE_NOT_ON_NETWORK",
		417081265: "NEXT_HOP_NOT_RUNNING",
		105763924: "NOT_CRITICAL_ERROR",
		30036744:  "NO_RESULTS_ON_PAGE",
		39966469:  "PARTIAL_SUCCESS",
		3745539:   "REQUIRED_TOS_AGREEMENT",
		496728641: "RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING",
		168598460: "RESOURCE_NOT_DELETED",
		275245642: "SCHEMA_VALIDATION_IGNORED",
		268305617: "SINGLE_INSTANCE_PROPERTY_TEMPLATE",
		390513439: "UNDECLARED_PROPERTIES",
		13328052:  "UNREACHABLE",
	}
	Warnings_Code_value = map[string]int32{
		"UNDEFINED_CODE":                            0,
		"CLEANUP_FAILED":                            150308440,
		"DEPRECATED_RESOURCE_USED":                  391835586,
		"DEPRECATED_TYPE_USED":                      346526230,
		"DISK_SIZE_LARGER_THAN_IMAGE_SIZE":          369442967,
		"EXPERIMENTAL_TYPE_USED":                    451954443,
		"EXTERNAL_API_WARNING":                      175546307,
		"FIELD_VALUE_OVERRIDEN":                     329669423,
		"INJECTED_KERNELS_DEPRECATED":               417377419,
		"LARGE_DEPLOYMENT_WARNING":                  481440678,
		"MISSING_TYPE_DEPENDENCY":                   344505463,
		"NEXT_HOP_ADDRESS_NOT_ASSIGNED":             324964999,
		"NEXT_HOP_CANNOT_IP_FORWARD":                383382887,
		"NEXT_HOP_INSTANCE_NOT_FOUND":               464250446,
		"NEXT_HOP_INSTANCE_NOT_ON_NETWORK":          243758146,
		"NEXT_HOP_NOT_RUNNING":                      417081265,
		"NOT_CRITICAL_ERROR":                        105763924,
		"NO_RESULTS_ON_PAGE":                        30036744,
		"PARTIAL_SUCCESS":                           39966469,
		"REQUIRED_TOS_AGREEMENT":                    3745539,
		"RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING": 496728641,
		"RESOURCE_NOT_DELETED":                      168598460,
		"SCHEMA_VALIDATION_IGNORED":                 275245642,
		"SINGLE_INSTANCE_PROPERTY_TEMPLATE":         268305617,
		"UNDECLARED_PROPERTIES":                     390513439,
		"UNREACHABLE":                               13328052,
	}
)

func (x Warnings_Code) Enum() *Warnings_Code {
	p := new(Warnings_Code)
	*p = x
	return p
}

func (x Warnings_Code) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Warnings_Code) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[118].Descriptor()
}

func (Warnings_Code) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[118]
}

func (x Warnings_Code) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Warnings_Code.Descriptor instead.
func (Warnings_Code) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{332, 0}
}

// [Output Only] The status of the operation, which can be one of the following: `PENDING`, `RUNNING`, or `DONE`.
type Operation_Status int32

const (
	// A value indicating that the enum field is not set.
	Operation_UNDEFINED_STATUS Operation_Status = 0
	Operation_DONE             Operation_Status = 2104194
	Operation_PENDING          Operation_Status = 35394935
	Operation_RUNNING          Operation_Status = 121282975
)

// Enum value maps for Operation_Status.
var (
	Operation_Status_name = map[int32]string{
		0:         "UNDEFINED_STATUS",
		2104194:   "DONE",
		35394935:  "PENDING",
		121282975: "RUNNING",
	}
	Operation_Status_value = map[string]int32{
		"UNDEFINED_STATUS": 0,
		"DONE":             2104194,
		"PENDING":          35394935,
		"RUNNING":          121282975,
	}
)

func (x Operation_Status) Enum() *Operation_Status {
	p := new(Operation_Status)
	*p = x
	return p
}

func (x Operation_Status) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Operation_Status) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[119].Descriptor()
}

func (Operation_Status) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[119]
}

func (x Operation_Status) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Operation_Status.Descriptor instead.
func (Operation_Status) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{333, 0}
}

// Direction of traffic to mirror, either INGRESS, EGRESS, or BOTH. The default is BOTH.
type PacketMirroringFilter_Direction int32

const (
	// A value indicating that the enum field is not set.
	PacketMirroringFilter_UNDEFINED_DIRECTION PacketMirroringFilter_Direction = 0
	PacketMirroringFilter_BOTH                PacketMirroringFilter_Direction = 2044801
	PacketMirroringFilter_EGRESS              PacketMirroringFilter_Direction = 432880501
	PacketMirroringFilter_INGRESS             PacketMirroringFilter_Direction = 516931221
)

// Enum value maps for PacketMirroringFilter_Direction.
var (
	PacketMirroringFilter_Direction_name = map[int32]string{
		0:         "UNDEFINED_DIRECTION",
		2044801:   "BOTH",
		432880501: "EGRESS",
		516931221: "INGRESS",
	}
	PacketMirroringFilter_Direction_value = map[string]int32{
		"UNDEFINED_DIRECTION": 0,
		"BOTH":                2044801,
		"EGRESS":              432880501,
		"INGRESS":             516931221,
	}
)

func (x PacketMirroringFilter_Direction) Enum() *PacketMirroringFilter_Direction {
	p := new(PacketMirroringFilter_Direction)
	*p = x
	return p
}

func (x PacketMirroringFilter_Direction) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (PacketMirroringFilter_Direction) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[120].Descriptor()
}

func (PacketMirroringFilter_Direction) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[120]
}

func (x PacketMirroringFilter_Direction) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use PacketMirroringFilter_Direction.Descriptor instead.
func (PacketMirroringFilter_Direction) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{338, 0}
}

// Indicates whether or not this packet mirroring takes effect. If set to FALSE, this packet mirroring policy will not be enforced on the network.
//
// The default is TRUE.
type PacketMirroring_Enable int32

const (
	// A value indicating that the enum field is not set.
	PacketMirroring_UNDEFINED_ENABLE PacketMirroring_Enable = 0
	PacketMirroring_FALSE            PacketMirroring_Enable = 66658563
	PacketMirroring_TRUE             PacketMirroring_Enable = 2583950
)

// Enum value maps for PacketMirroring_Enable.
var (
	PacketMirroring_Enable_name = map[int32]string{
		0:        "UNDEFINED_ENABLE",
		66658563: "FALSE",
		2583950:  "TRUE",
	}
	PacketMirroring_Enable_value = map[string]int32{
		"UNDEFINED_ENABLE": 0,
		"FALSE":            66658563,
		"TRUE":             2583950,
	}
)

func (x PacketMirroring_Enable) Enum() *PacketMirroring_Enable {
	p := new(PacketMirroring_Enable)
	*p = x
	return p
}

func (x PacketMirroring_Enable) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (PacketMirroring_Enable) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[121].Descriptor()
}

func (PacketMirroring_Enable) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[121]
}

func (x PacketMirroring_Enable) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use PacketMirroring_Enable.Descriptor instead.
func (PacketMirroring_Enable) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{341, 0}
}

// Required
type Rule_Action int32

const (
	// A value indicating that the enum field is not set.
	Rule_UNDEFINED_ACTION Rule_Action = 0
	Rule_ALLOW            Rule_Action = 62368553
	Rule_ALLOW_WITH_LOG   Rule_Action = 76034177
	Rule_DENY             Rule_Action = 2094604
	Rule_DENY_WITH_LOG    Rule_Action = 351433982
	Rule_LOG              Rule_Action = 75556
	Rule_NO_ACTION        Rule_Action = 260643444
)

// Enum value maps for Rule_Action.
var (
	Rule_Action_name = map[int32]string{
		0:         "UNDEFINED_ACTION",
		62368553:  "ALLOW",
		76034177:  "ALLOW_WITH_LOG",
		2094604:   "DENY",
		351433982: "DENY_WITH_LOG",
		75556:     "LOG",
		260643444: "NO_ACTION",
	}
	Rule_Action_value = map[string]int32{
		"UNDEFINED_ACTION": 0,
		"ALLOW":            62368553,
		"ALLOW_WITH_LOG":   76034177,
		"DENY":             2094604,
		"DENY_WITH_LOG":    351433982,
		"LOG":              75556,
		"NO_ACTION":        260643444,
	}
)

func (x Rule_Action) Enum() *Rule_Action {
	p := new(Rule_Action)
	*p = x
	return p
}

func (x Rule_Action) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Rule_Action) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[122].Descriptor()
}

func (Rule_Action) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[122]
}

func (x Rule_Action) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Rule_Action.Descriptor instead.
func (Rule_Action) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{349, 0}
}

// These stateful disks will never be deleted during autohealing, update, instance recreate operations. This flag is used to configure if the disk should be deleted after it is no longer used by the group, e.g. when the given instance or the whole MIG is deleted. Note: disks attached in READ_ONLY mode cannot be auto-deleted.
type PreservedStatePreservedDisk_AutoDelete int32

const (
	// A value indicating that the enum field is not set.
	PreservedStatePreservedDisk_UNDEFINED_AUTO_DELETE          PreservedStatePreservedDisk_AutoDelete = 0
	PreservedStatePreservedDisk_NEVER                          PreservedStatePreservedDisk_AutoDelete = 74175084
	PreservedStatePreservedDisk_ON_PERMANENT_INSTANCE_DELETION PreservedStatePreservedDisk_AutoDelete = 95727719
)

// Enum value maps for PreservedStatePreservedDisk_AutoDelete.
var (
	PreservedStatePreservedDisk_AutoDelete_name = map[int32]string{
		0:        "UNDEFINED_AUTO_DELETE",
		74175084: "NEVER",
		95727719: "ON_PERMANENT_INSTANCE_DELETION",
	}
	PreservedStatePreservedDisk_AutoDelete_value = map[string]int32{
		"UNDEFINED_AUTO_DELETE":          0,
		"NEVER":                          74175084,
		"ON_PERMANENT_INSTANCE_DELETION": 95727719,
	}
)

func (x PreservedStatePreservedDisk_AutoDelete) Enum() *PreservedStatePreservedDisk_AutoDelete {
	p := new(PreservedStatePreservedDisk_AutoDelete)
	*p = x
	return p
}

func (x PreservedStatePreservedDisk_AutoDelete) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (PreservedStatePreservedDisk_AutoDelete) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[123].Descriptor()
}

func (PreservedStatePreservedDisk_AutoDelete) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[123]
}

func (x PreservedStatePreservedDisk_AutoDelete) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use PreservedStatePreservedDisk_AutoDelete.Descriptor instead.
func (PreservedStatePreservedDisk_AutoDelete) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{352, 0}
}

// The mode in which to attach this disk, either READ_WRITE or READ_ONLY. If not specified, the default is to attach the disk in READ_WRITE mode.
type PreservedStatePreservedDisk_Mode int32

const (
	// A value indicating that the enum field is not set.
	PreservedStatePreservedDisk_UNDEFINED_MODE PreservedStatePreservedDisk_Mode = 0
	PreservedStatePreservedDisk_READ_ONLY      PreservedStatePreservedDisk_Mode = 91950261
	PreservedStatePreservedDisk_READ_WRITE     PreservedStatePreservedDisk_Mode = 173607894
)

// Enum value maps for PreservedStatePreservedDisk_Mode.
var (
	PreservedStatePreservedDisk_Mode_name = map[int32]string{
		0:         "UNDEFINED_MODE",
		91950261:  "READ_ONLY",
		173607894: "READ_WRITE",
	}
	PreservedStatePreservedDisk_Mode_value = map[string]int32{
		"UNDEFINED_MODE": 0,
		"READ_ONLY":      91950261,
		"READ_WRITE":     173607894,
	}
)

func (x PreservedStatePreservedDisk_Mode) Enum() *PreservedStatePreservedDisk_Mode {
	p := new(PreservedStatePreservedDisk_Mode)
	*p = x
	return p
}

func (x PreservedStatePreservedDisk_Mode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (PreservedStatePreservedDisk_Mode) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[124].Descriptor()
}

func (PreservedStatePreservedDisk_Mode) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[124]
}

func (x PreservedStatePreservedDisk_Mode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use PreservedStatePreservedDisk_Mode.Descriptor instead.
func (PreservedStatePreservedDisk_Mode) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{352, 1}
}

// [Output Only] Name of the quota metric.
type Quota_Metric int32

const (
	// A value indicating that the enum field is not set.
	Quota_UNDEFINED_METRIC                                       Quota_Metric = 0
	Quota_A2_CPUS                                                Quota_Metric = 153206585
	Quota_AFFINITY_GROUPS                                        Quota_Metric = 108303563
	Quota_AUTOSCALERS                                            Quota_Metric = 471248988
	Quota_BACKEND_BUCKETS                                        Quota_Metric = 137626846
	Quota_BACKEND_SERVICES                                       Quota_Metric = 269623753
	Quota_C2D_CPUS                                               Quota_Metric = 508182517
	Quota_C2_CPUS                                                Quota_Metric = 317601211
	Quota_COMMITMENTS                                            Quota_Metric = 456141790
	Quota_COMMITTED_A2_CPUS                                      Quota_Metric = 59330902
	Quota_COMMITTED_C2D_CPUS                                     Quota_Metric = 282390904
	Quota_COMMITTED_C2_CPUS                                      Quota_Metric = 223725528
	Quota_COMMITTED_CPUS                                         Quota_Metric = 292394702
	Quota_COMMITTED_E2_CPUS                                      Quota_Metric = 388120154
	Quota_COMMITTED_LICENSES                                     Quota_Metric = 357606869
	Quota_COMMITTED_LOCAL_SSD_TOTAL_GB                           Quota_Metric = 308393480
	Quota_COMMITTED_MEMORY_OPTIMIZED_CPUS                        Quota_Metric = 489057886
	Quota_COMMITTED_N2A_CPUS                                     Quota_Metric = 40064304
	Quota_COMMITTED_N2D_CPUS                                     Quota_Metric = 125951757
	Quota_COMMITTED_N2_CPUS                                      Quota_Metric = 322589603
	Quota_COMMITTED_NVIDIA_A100_GPUS                             Quota_Metric = 375799445
	Quota_COMMITTED_NVIDIA_K80_GPUS                              Quota_Metric = 3857188
	Quota_COMMITTED_NVIDIA_P100_GPUS                             Quota_Metric = 107528100
	Quota_COMMITTED_NVIDIA_P4_GPUS                               Quota_Metric = 347952897
	Quota_COMMITTED_NVIDIA_T4_GPUS                               Quota_Metric = 139871237
	Quota_COMMITTED_NVIDIA_V100_GPUS                             Quota_Metric = 219562
	Quota_CPUS                                                   Quota_Metric = 2075595
	Quota_CPUS_ALL_REGIONS                                       Quota_Metric = 470911149
	Quota_DISKS_TOTAL_GB                                         Quota_Metric = 353520543
	Quota_E2_CPUS                                                Quota_Metric = 481995837
	Quota_EXTERNAL_NETWORK_LB_FORWARDING_RULES                   Quota_Metric = 374298265
	Quota_EXTERNAL_PROTOCOL_FORWARDING_RULES                     Quota_Metric = 63478888
	Quota_EXTERNAL_VPN_GATEWAYS                                  Quota_Metric = 272457134
	Quota_FIREWALLS                                              Quota_Metric = 374485843
	Quota_FORWARDING_RULES                                       Quota_Metric = 432668949
	Quota_GLOBAL_INTERNAL_ADDRESSES                              Quota_Metric = 42738332
	Quota_GPUS_ALL_REGIONS                                       Quota_Metric = 39387177
	Quota_HEALTH_CHECKS                                          Quota_Metric = 289347502
	Quota_IMAGES                                                 Quota_Metric = 15562360
	Quota_INSTANCES                                              Quota_Metric = 131337822
	Quota_INSTANCE_GROUPS                                        Quota_Metric = 355919038
	Quota_INSTANCE_GROUP_MANAGERS                                Quota_Metric = 101798192
	Quota_INSTANCE_TEMPLATES                                     Quota_Metric = 226188271
	Quota_INTERCONNECTS                                          Quota_Metric = 415204741
	Quota_INTERCONNECT_ATTACHMENTS_PER_REGION                    Quota_Metric = 159968086
	Quota_INTERCONNECT_ATTACHMENTS_TOTAL_MBPS                    Quota_Metric = 425090419
	Quota_INTERCONNECT_TOTAL_GBPS                                Quota_Metric = 285341866
	Quota_INTERNAL_ADDRESSES                                     Quota_Metric = 197899392
	Quota_INTERNAL_TRAFFIC_DIRECTOR_FORWARDING_RULES             Quota_Metric = 266433668
	Quota_IN_PLACE_SNAPSHOTS                                     Quota_Metric = 151359133
	Quota_IN_USE_ADDRESSES                                       Quota_Metric = 402125072
	Quota_IN_USE_BACKUP_SCHEDULES                                Quota_Metric = 32786705
	Quota_IN_USE_SNAPSHOT_SCHEDULES                              Quota_Metric = 462104083
	Quota_LOCAL_SSD_TOTAL_GB                                     Quota_Metric = 330878021
	Quota_M1_CPUS                                                Quota_Metric = 37203366
	Quota_M2_CPUS                                                Quota_Metric = 65832517
	Quota_MACHINE_IMAGES                                         Quota_Metric = 446986640
	Quota_N2A_CPUS                                               Quota_Metric = 265855917
	Quota_N2D_CPUS                                               Quota_Metric = 351743370
	Quota_N2_CPUS                                                Quota_Metric = 416465286
	Quota_NETWORKS                                               Quota_Metric = 485481477
	Quota_NETWORK_ENDPOINT_GROUPS                                Quota_Metric = 102144909
	Quota_NETWORK_FIREWALL_POLICIES                              Quota_Metric = 101117374
	Quota_NODE_GROUPS                                            Quota_Metric = 24624817
	Quota_NODE_TEMPLATES                                         Quota_Metric = 474896668
	Quota_NVIDIA_A100_GPUS                                       Quota_Metric = 504872978
	Quota_NVIDIA_K80_GPUS                                        Quota_Metric = 163886599
	Quota_NVIDIA_P100_GPUS                                       Quota_Metric = 236601633
	Quota_NVIDIA_P100_VWS_GPUS                                   Quota_Metric = 213970574
	Quota_NVIDIA_P4_GPUS                                         Quota_Metric = 283841470
	Quota_NVIDIA_P4_VWS_GPUS                                     Quota_Metric = 528296619
	Quota_NVIDIA_T4_GPUS                                         Quota_Metric = 75759810
	Quota_NVIDIA_T4_VWS_GPUS                                     Quota_Metric = 319813039
	Quota_NVIDIA_V100_GPUS                                       Quota_Metric = 129293095
	Quota_PACKET_MIRRORINGS                                      Quota_Metric = 15578407
	Quota_PD_EXTREME_TOTAL_PROVISIONED_IOPS                      Quota_Metric = 69593965
	Quota_PREEMPTIBLE_CPUS                                       Quota_Metric = 251184841
	Quota_PREEMPTIBLE_LOCAL_SSD_GB                               Quota_Metric = 260819336
	Quota_PREEMPTIBLE_NVIDIA_A100_GPUS                           Quota_Metric = 68832784
	Quota_PREEMPTIBLE_NVIDIA_K80_GPUS                            Quota_Metric = 374960201
	Quota_PREEMPTIBLE_NVIDIA_P100_GPUS                           Quota_Metric = 337432351
	Quota_PREEMPTIBLE_NVIDIA_P100_VWS_GPUS                       Quota_Metric = 313544076
	Quota_PREEMPTIBLE_NVIDIA_P4_GPUS                             Quota_Metric = 429197628
	Quota_PREEMPTIBLE_NVIDIA_P4_VWS_GPUS                         Quota_Metric = 252981545
	Quota_PREEMPTIBLE_NVIDIA_T4_GPUS                             Quota_Metric = 221115968
	Quota_PREEMPTIBLE_NVIDIA_T4_VWS_GPUS                         Quota_Metric = 44497965
	Quota_PREEMPTIBLE_NVIDIA_V100_GPUS                           Quota_Metric = 230123813
	Quota_PSC_ILB_CONSUMER_FORWARDING_RULES_PER_PRODUCER_NETWORK Quota_Metric = 231164291
	Quota_PUBLIC_ADVERTISED_PREFIXES                             Quota_Metric = 471371980
	Quota_PUBLIC_DELEGATED_PREFIXES                              Quota_Metric = 532465974
	Quota_REGIONAL_AUTOSCALERS                                   Quota_Metric = 29363772
	Quota_REGIONAL_INSTANCE_GROUP_MANAGERS                       Quota_Metric = 37543696
	Quota_RESERVATIONS                                           Quota_Metric = 32644647
	Quota_RESOURCE_POLICIES                                      Quota_Metric = 83955297
	Quota_ROUTERS                                                Quota_Metric = 493018666
	Quota_ROUTES                                                 Quota_Metric = 275680074
	Quota_SECURITY_POLICIES                                      Quota_Metric = 189518703
	Quota_SECURITY_POLICY_CEVAL_RULES                            Quota_Metric = 470815689
	Quota_SECURITY_POLICY_RULES                                  Quota_Metric = 203549225
	Quota_SNAPSHOTS                                              Quota_Metric = 343405327
	Quota_SSD_TOTAL_GB                                           Quota_Metric = 161732561
	Quota_SSL_CERTIFICATES                                       Quota_Metric = 378372399
	Quota_STATIC_ADDRESSES                                       Quota_Metric = 93624049
	Quota_STATIC_BYOIP_ADDRESSES                                 Quota_Metric = 275809649
	Quota_SUBNETWORKS                                            Quota_Metric = 421330469
	Quota_TARGET_HTTPS_PROXIES                                   Quota_Metric = 219522506
	Quota_TARGET_HTTP_PROXIES                                    Quota_Metric = 164117155
	Quota_TARGET_INSTANCES                                       Quota_Metric = 284519728
	Quota_TARGET_POOLS                                           Quota_Metric = 348261257
	Quota_TARGET_SSL_PROXIES                                     Quota_Metric = 159216235
	Quota_TARGET_TCP_PROXIES                                     Quota_Metric = 182243136
	Quota_TARGET_VPN_GATEWAYS                                    Quota_Metric = 75029928
	Quota_URL_MAPS                                               Quota_Metric = 378660743
	Quota_VPN_GATEWAYS                                           Quota_Metric = 35620282
	Quota_VPN_TUNNELS                                            Quota_Metric = 104327296
	Quota_XPN_SERVICE_PROJECTS                                   Quota_Metric = 95191981
)

// Enum value maps for Quota_Metric.
var (
	Quota_Metric_name = map[int32]string{
		0:         "UNDEFINED_METRIC",
		153206585: "A2_CPUS",
		108303563: "AFFINITY_GROUPS",
		471248988: "AUTOSCALERS",
		137626846: "BACKEND_BUCKETS",
		269623753: "BACKEND_SERVICES",
		508182517: "C2D_CPUS",
		317601211: "C2_CPUS",
		456141790: "COMMITMENTS",
		59330902:  "COMMITTED_A2_CPUS",
		282390904: "COMMITTED_C2D_CPUS",
		223725528: "COMMITTED_C2_CPUS",
		292394702: "COMMITTED_CPUS",
		388120154: "COMMITTED_E2_CPUS",
		357606869: "COMMITTED_LICENSES",
		308393480: "COMMITTED_LOCAL_SSD_TOTAL_GB",
		489057886: "COMMITTED_MEMORY_OPTIMIZED_CPUS",
		40064304:  "COMMITTED_N2A_CPUS",
		125951757: "COMMITTED_N2D_CPUS",
		322589603: "COMMITTED_N2_CPUS",
		375799445: "COMMITTED_NVIDIA_A100_GPUS",
		3857188:   "COMMITTED_NVIDIA_K80_GPUS",
		107528100: "COMMITTED_NVIDIA_P100_GPUS",
		347952897: "COMMITTED_NVIDIA_P4_GPUS",
		139871237: "COMMITTED_NVIDIA_T4_GPUS",
		219562:    "COMMITTED_NVIDIA_V100_GPUS",
		2075595:   "CPUS",
		470911149: "CPUS_ALL_REGIONS",
		353520543: "DISKS_TOTAL_GB",
		481995837: "E2_CPUS",
		374298265: "EXTERNAL_NETWORK_LB_FORWARDING_RULES",
		63478888:  "EXTERNAL_PROTOCOL_FORWARDING_RULES",
		272457134: "EXTERNAL_VPN_GATEWAYS",
		374485843: "FIREWALLS",
		432668949: "FORWARDING_RULES",
		42738332:  "GLOBAL_INTERNAL_ADDRESSES",
		39387177:  "GPUS_ALL_REGIONS",
		289347502: "HEALTH_CHECKS",
		15562360:  "IMAGES",
		131337822: "INSTANCES",
		355919038: "INSTANCE_GROUPS",
		101798192: "INSTANCE_GROUP_MANAGERS",
		226188271: "INSTANCE_TEMPLATES",
		415204741: "INTERCONNECTS",
		159968086: "INTERCONNECT_ATTACHMENTS_PER_REGION",
		425090419: "INTERCONNECT_ATTACHMENTS_TOTAL_MBPS",
		285341866: "INTERCONNECT_TOTAL_GBPS",
		197899392: "INTERNAL_ADDRESSES",
		266433668: "INTERNAL_TRAFFIC_DIRECTOR_FORWARDING_RULES",
		151359133: "IN_PLACE_SNAPSHOTS",
		402125072: "IN_USE_ADDRESSES",
		32786705:  "IN_USE_BACKUP_SCHEDULES",
		462104083: "IN_USE_SNAPSHOT_SCHEDULES",
		330878021: "LOCAL_SSD_TOTAL_GB",
		37203366:  "M1_CPUS",
		65832517:  "M2_CPUS",
		446986640: "MACHINE_IMAGES",
		265855917: "N2A_CPUS",
		351743370: "N2D_CPUS",
		416465286: "N2_CPUS",
		485481477: "NETWORKS",
		102144909: "NETWORK_ENDPOINT_GROUPS",
		101117374: "NETWORK_FIREWALL_POLICIES",
		24624817:  "NODE_GROUPS",
		474896668: "NODE_TEMPLATES",
		504872978: "NVIDIA_A100_GPUS",
		163886599: "NVIDIA_K80_GPUS",
		236601633: "NVIDIA_P100_GPUS",
		213970574: "NVIDIA_P100_VWS_GPUS",
		283841470: "NVIDIA_P4_GPUS",
		528296619: "NVIDIA_P4_VWS_GPUS",
		75759810:  "NVIDIA_T4_GPUS",
		319813039: "NVIDIA_T4_VWS_GPUS",
		129293095: "NVIDIA_V100_GPUS",
		15578407:  "PACKET_MIRRORINGS",
		69593965:  "PD_EXTREME_TOTAL_PROVISIONED_IOPS",
		251184841: "PREEMPTIBLE_CPUS",
		260819336: "PREEMPTIBLE_LOCAL_SSD_GB",
		68832784:  "PREEMPTIBLE_NVIDIA_A100_GPUS",
		374960201: "PREEMPTIBLE_NVIDIA_K80_GPUS",
		337432351: "PREEMPTIBLE_NVIDIA_P100_GPUS",
		313544076: "PREEMPTIBLE_NVIDIA_P100_VWS_GPUS",
		429197628: "PREEMPTIBLE_NVIDIA_P4_GPUS",
		252981545: "PREEMPTIBLE_NVIDIA_P4_VWS_GPUS",
		221115968: "PREEMPTIBLE_NVIDIA_T4_GPUS",
		44497965:  "PREEMPTIBLE_NVIDIA_T4_VWS_GPUS",
		230123813: "PREEMPTIBLE_NVIDIA_V100_GPUS",
		231164291: "PSC_ILB_CONSUMER_FORWARDING_RULES_PER_PRODUCER_NETWORK",
		471371980: "PUBLIC_ADVERTISED_PREFIXES",
		532465974: "PUBLIC_DELEGATED_PREFIXES",
		29363772:  "REGIONAL_AUTOSCALERS",
		37543696:  "REGIONAL_INSTANCE_GROUP_MANAGERS",
		32644647:  "RESERVATIONS",
		83955297:  "RESOURCE_POLICIES",
		493018666: "ROUTERS",
		275680074: "ROUTES",
		189518703: "SECURITY_POLICIES",
		470815689: "SECURITY_POLICY_CEVAL_RULES",
		203549225: "SECURITY_POLICY_RULES",
		343405327: "SNAPSHOTS",
		161732561: "SSD_TOTAL_GB",
		378372399: "SSL_CERTIFICATES",
		93624049:  "STATIC_ADDRESSES",
		275809649: "STATIC_BYOIP_ADDRESSES",
		421330469: "SUBNETWORKS",
		219522506: "TARGET_HTTPS_PROXIES",
		164117155: "TARGET_HTTP_PROXIES",
		284519728: "TARGET_INSTANCES",
		348261257: "TARGET_POOLS",
		159216235: "TARGET_SSL_PROXIES",
		182243136: "TARGET_TCP_PROXIES",
		75029928:  "TARGET_VPN_GATEWAYS",
		378660743: "URL_MAPS",
		35620282:  "VPN_GATEWAYS",
		104327296: "VPN_TUNNELS",
		95191981:  "XPN_SERVICE_PROJECTS",
	}
	Quota_Metric_value = map[string]int32{
		"UNDEFINED_METRIC":                           0,
		"A2_CPUS":                                    153206585,
		"AFFINITY_GROUPS":                            108303563,
		"AUTOSCALERS":                                471248988,
		"BACKEND_BUCKETS":                            137626846,
		"BACKEND_SERVICES":                           269623753,
		"C2D_CPUS":                                   508182517,
		"C2_CPUS":                                    317601211,
		"COMMITMENTS":                                456141790,
		"COMMITTED_A2_CPUS":                          59330902,
		"COMMITTED_C2D_CPUS":                         282390904,
		"COMMITTED_C2_CPUS":                          223725528,
		"COMMITTED_CPUS":                             292394702,
		"COMMITTED_E2_CPUS":                          388120154,
		"COMMITTED_LICENSES":                         357606869,
		"COMMITTED_LOCAL_SSD_TOTAL_GB":               308393480,
		"COMMITTED_MEMORY_OPTIMIZED_CPUS":            489057886,
		"COMMITTED_N2A_CPUS":                         40064304,
		"COMMITTED_N2D_CPUS":                         125951757,
		"COMMITTED_N2_CPUS":                          322589603,
		"COMMITTED_NVIDIA_A100_GPUS":                 375799445,
		"COMMITTED_NVIDIA_K80_GPUS":                  3857188,
		"COMMITTED_NVIDIA_P100_GPUS":                 107528100,
		"COMMITTED_NVIDIA_P4_GPUS":                   347952897,
		"COMMITTED_NVIDIA_T4_GPUS":                   139871237,
		"COMMITTED_NVIDIA_V100_GPUS":                 219562,
		"CPUS":                                       2075595,
		"CPUS_ALL_REGIONS":                           470911149,
		"DISKS_TOTAL_GB":                             353520543,
		"E2_CPUS":                                    481995837,
		"EXTERNAL_NETWORK_LB_FORWARDING_RULES":       374298265,
		"EXTERNAL_PROTOCOL_FORWARDING_RULES":         63478888,
		"EXTERNAL_VPN_GATEWAYS":                      272457134,
		"FIREWALLS":                                  374485843,
		"FORWARDING_RULES":                           432668949,
		"GLOBAL_INTERNAL_ADDRESSES":                  42738332,
		"GPUS_ALL_REGIONS":                           39387177,
		"HEALTH_CHECKS":                              289347502,
		"IMAGES":                                     15562360,
		"INSTANCES":                                  131337822,
		"INSTANCE_GROUPS":                            355919038,
		"INSTANCE_GROUP_MANAGERS":                    101798192,
		"INSTANCE_TEMPLATES":                         226188271,
		"INTERCONNECTS":                              415204741,
		"INTERCONNECT_ATTACHMENTS_PER_REGION":        159968086,
		"INTERCONNECT_ATTACHMENTS_TOTAL_MBPS":        425090419,
		"INTERCONNECT_TOTAL_GBPS":                    285341866,
		"INTERNAL_ADDRESSES":                         197899392,
		"INTERNAL_TRAFFIC_DIRECTOR_FORWARDING_RULES": 266433668,
		"IN_PLACE_SNAPSHOTS":                         151359133,
		"IN_USE_ADDRESSES":                           402125072,
		"IN_USE_BACKUP_SCHEDULES":                    32786705,
		"IN_USE_SNAPSHOT_SCHEDULES":                  462104083,
		"LOCAL_SSD_TOTAL_GB":                         330878021,
		"M1_CPUS":                                    37203366,
		"M2_CPUS":                                    65832517,
		"MACHINE_IMAGES":                             446986640,
		"N2A_CPUS":                                   265855917,
		"N2D_CPUS":                                   351743370,
		"N2_CPUS":                                    416465286,
		"NETWORKS":                                   485481477,
		"NETWORK_ENDPOINT_GROUPS":                    102144909,
		"NETWORK_FIREWALL_POLICIES":                  101117374,
		"NODE_GROUPS":                                24624817,
		"NODE_TEMPLATES":                             474896668,
		"NVIDIA_A100_GPUS":                           504872978,
		"NVIDIA_K80_GPUS":                            163886599,
		"NVIDIA_P100_GPUS":                           236601633,
		"NVIDIA_P100_VWS_GPUS":                       213970574,
		"NVIDIA_P4_GPUS":                             283841470,
		"NVIDIA_P4_VWS_GPUS":                         528296619,
		"NVIDIA_T4_GPUS":                             75759810,
		"NVIDIA_T4_VWS_GPUS":                         319813039,
		"NVIDIA_V100_GPUS":                           129293095,
		"PACKET_MIRRORINGS":                          15578407,
		"PD_EXTREME_TOTAL_PROVISIONED_IOPS":          69593965,
		"PREEMPTIBLE_CPUS":                           251184841,
		"PREEMPTIBLE_LOCAL_SSD_GB":                   260819336,
		"PREEMPTIBLE_NVIDIA_A100_GPUS":               68832784,
		"PREEMPTIBLE_NVIDIA_K80_GPUS":                374960201,
		"PREEMPTIBLE_NVIDIA_P100_GPUS":               337432351,
		"PREEMPTIBLE_NVIDIA_P100_VWS_GPUS":           313544076,
		"PREEMPTIBLE_NVIDIA_P4_GPUS":                 429197628,
		"PREEMPTIBLE_NVIDIA_P4_VWS_GPUS":             252981545,
		"PREEMPTIBLE_NVIDIA_T4_GPUS":                 221115968,
		"PREEMPTIBLE_NVIDIA_T4_VWS_GPUS":             44497965,
		"PREEMPTIBLE_NVIDIA_V100_GPUS":               230123813,
		"PSC_ILB_CONSUMER_FORWARDING_RULES_PER_PRODUCER_NETWORK": 231164291,
		"PUBLIC_ADVERTISED_PREFIXES":                             471371980,
		"PUBLIC_DELEGATED_PREFIXES":                              532465974,
		"REGIONAL_AUTOSCALERS":                                   29363772,
		"REGIONAL_INSTANCE_GROUP_MANAGERS":                       37543696,
		"RESERVATIONS":                                           32644647,
		"RESOURCE_POLICIES":                                      83955297,
		"ROUTERS":                                                493018666,
		"ROUTES":                                                 275680074,
		"SECURITY_POLICIES":                                      189518703,
		"SECURITY_POLICY_CEVAL_RULES":                            470815689,
		"SECURITY_POLICY_RULES":                                  203549225,
		"SNAPSHOTS":                                              343405327,
		"SSD_TOTAL_GB":                                           161732561,
		"SSL_CERTIFICATES":                                       378372399,
		"STATIC_ADDRESSES":                                       93624049,
		"STATIC_BYOIP_ADDRESSES":                                 275809649,
		"SUBNETWORKS":                                            421330469,
		"TARGET_HTTPS_PROXIES":                                   219522506,
		"TARGET_HTTP_PROXIES":                                    164117155,
		"TARGET_INSTANCES":                                       284519728,
		"TARGET_POOLS":                                           348261257,
		"TARGET_SSL_PROXIES":                                     159216235,
		"TARGET_TCP_PROXIES":                                     182243136,
		"TARGET_VPN_GATEWAYS":                                    75029928,
		"URL_MAPS":                                               378660743,
		"VPN_GATEWAYS":                                           35620282,
		"VPN_TUNNELS":                                            104327296,
		"XPN_SERVICE_PROJECTS":                                   95191981,
	}
)

func (x Quota_Metric) Enum() *Quota_Metric {
	p := new(Quota_Metric)
	*p = x
	return p
}

func (x Quota_Metric) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Quota_Metric) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[125].Descriptor()
}

func (Quota_Metric) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[125]
}

func (x Quota_Metric) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Quota_Metric.Descriptor instead.
func (Quota_Metric) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{353, 0}
}

// This signifies the default network tier used for configuring resources of the project and can only take the following values: PREMIUM, STANDARD. Initially the default network tier is PREMIUM.
type Project_DefaultNetworkTier int32

const (
	// A value indicating that the enum field is not set.
	Project_UNDEFINED_DEFAULT_NETWORK_TIER Project_DefaultNetworkTier = 0
	Project_PREMIUM                        Project_DefaultNetworkTier = 399530551
	Project_STANDARD                       Project_DefaultNetworkTier = 484642493
)

// Enum value maps for Project_DefaultNetworkTier.
var (
	Project_DefaultNetworkTier_name = map[int32]string{
		0:         "UNDEFINED_DEFAULT_NETWORK_TIER",
		399530551: "PREMIUM",
		484642493: "STANDARD",
	}
	Project_DefaultNetworkTier_value = map[string]int32{
		"UNDEFINED_DEFAULT_NETWORK_TIER": 0,
		"PREMIUM":                        399530551,
		"STANDARD":                       484642493,
	}
)

func (x Project_DefaultNetworkTier) Enum() *Project_DefaultNetworkTier {
	p := new(Project_DefaultNetworkTier)
	*p = x
	return p
}

func (x Project_DefaultNetworkTier) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Project_DefaultNetworkTier) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[126].Descriptor()
}

func (Project_DefaultNetworkTier) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[126]
}

func (x Project_DefaultNetworkTier) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Project_DefaultNetworkTier.Descriptor instead.
func (Project_DefaultNetworkTier) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{355, 0}
}

// [Output Only] The role this project has in a shared VPC configuration. Currently, only projects with the host role, which is specified by the value HOST, are differentiated.
type Project_XpnProjectStatus int32

const (
	// A value indicating that the enum field is not set.
	Project_UNDEFINED_XPN_PROJECT_STATUS   Project_XpnProjectStatus = 0
	Project_HOST                           Project_XpnProjectStatus = 2223528
	Project_UNSPECIFIED_XPN_PROJECT_STATUS Project_XpnProjectStatus = 340393257
)

// Enum value maps for Project_XpnProjectStatus.
var (
	Project_XpnProjectStatus_name = map[int32]string{
		0:         "UNDEFINED_XPN_PROJECT_STATUS",
		2223528:   "HOST",
		340393257: "UNSPECIFIED_XPN_PROJECT_STATUS",
	}
	Project_XpnProjectStatus_value = map[string]int32{
		"UNDEFINED_XPN_PROJECT_STATUS":   0,
		"HOST":                           2223528,
		"UNSPECIFIED_XPN_PROJECT_STATUS": 340393257,
	}
)

func (x Project_XpnProjectStatus) Enum() *Project_XpnProjectStatus {
	p := new(Project_XpnProjectStatus)
	*p = x
	return p
}

func (x Project_XpnProjectStatus) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Project_XpnProjectStatus) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[127].Descriptor()
}

func (Project_XpnProjectStatus) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[127]
}

func (x Project_XpnProjectStatus) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Project_XpnProjectStatus.Descriptor instead.
func (Project_XpnProjectStatus) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{355, 1}
}

// The type of the service resource.
type XpnResourceId_Type int32

const (
	// A value indicating that the enum field is not set.
	XpnResourceId_UNDEFINED_TYPE                XpnResourceId_Type = 0
	XpnResourceId_PROJECT                       XpnResourceId_Type = 408671993
	XpnResourceId_XPN_RESOURCE_TYPE_UNSPECIFIED XpnResourceId_Type = 151607034
)

// Enum value maps for XpnResourceId_Type.
var (
	XpnResourceId_Type_name = map[int32]string{
		0:         "UNDEFINED_TYPE",
		408671993: "PROJECT",
		151607034: "XPN_RESOURCE_TYPE_UNSPECIFIED",
	}
	XpnResourceId_Type_value = map[string]int32{
		"UNDEFINED_TYPE":                0,
		"PROJECT":                       408671993,
		"XPN_RESOURCE_TYPE_UNSPECIFIED": 151607034,
	}
)

func (x XpnResourceId_Type) Enum() *XpnResourceId_Type {
	p := new(XpnResourceId_Type)
	*p = x
	return p
}

func (x XpnResourceId_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (XpnResourceId_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[128].Descriptor()
}

func (XpnResourceId_Type) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[128]
}

func (x XpnResourceId_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use XpnResourceId_Type.Descriptor instead.
func (XpnResourceId_Type) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{356, 0}
}

// Default network tier to be set.
type ProjectsSetDefaultNetworkTierRequest_NetworkTier int32

const (
	// A value indicating that the enum field is not set.
	ProjectsSetDefaultNetworkTierRequest_UNDEFINED_NETWORK_TIER ProjectsSetDefaultNetworkTierRequest_NetworkTier = 0
	ProjectsSetDefaultNetworkTierRequest_PREMIUM                ProjectsSetDefaultNetworkTierRequest_NetworkTier = 399530551
	ProjectsSetDefaultNetworkTierRequest_STANDARD               ProjectsSetDefaultNetworkTierRequest_NetworkTier = 484642493
)

// Enum value maps for ProjectsSetDefaultNetworkTierRequest_NetworkTier.
var (
	ProjectsSetDefaultNetworkTierRequest_NetworkTier_name = map[int32]string{
		0:         "UNDEFINED_NETWORK_TIER",
		399530551: "PREMIUM",
		484642493: "STANDARD",
	}
	ProjectsSetDefaultNetworkTierRequest_NetworkTier_value = map[string]int32{
		"UNDEFINED_NETWORK_TIER": 0,
		"PREMIUM":                399530551,
		"STANDARD":               484642493,
	}
)

func (x ProjectsSetDefaultNetworkTierRequest_NetworkTier) Enum() *ProjectsSetDefaultNetworkTierRequest_NetworkTier {
	p := new(ProjectsSetDefaultNetworkTierRequest_NetworkTier)
	*p = x
	return p
}

func (x ProjectsSetDefaultNetworkTierRequest_NetworkTier) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ProjectsSetDefaultNetworkTierRequest_NetworkTier) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[129].Descriptor()
}

func (ProjectsSetDefaultNetworkTierRequest_NetworkTier) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[129]
}

func (x ProjectsSetDefaultNetworkTierRequest_NetworkTier) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ProjectsSetDefaultNetworkTierRequest_NetworkTier.Descriptor instead.
func (ProjectsSetDefaultNetworkTierRequest_NetworkTier) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{361, 0}
}

// The status of the public advertised prefix.
type PublicAdvertisedPrefix_Status int32

const (
	// A value indicating that the enum field is not set.
	PublicAdvertisedPrefix_UNDEFINED_STATUS                 PublicAdvertisedPrefix_Status = 0
	PublicAdvertisedPrefix_INITIAL                          PublicAdvertisedPrefix_Status = 518841124
	PublicAdvertisedPrefix_PREFIX_CONFIGURATION_COMPLETE    PublicAdvertisedPrefix_Status = 480889551
	PublicAdvertisedPrefix_PREFIX_CONFIGURATION_IN_PROGRESS PublicAdvertisedPrefix_Status = 378550961
	PublicAdvertisedPrefix_PREFIX_REMOVAL_IN_PROGRESS       PublicAdvertisedPrefix_Status = 284375783
	PublicAdvertisedPrefix_PTR_CONFIGURED                   PublicAdvertisedPrefix_Status = 513497167
	PublicAdvertisedPrefix_REVERSE_DNS_LOOKUP_FAILED        PublicAdvertisedPrefix_Status = 295755183
	PublicAdvertisedPrefix_VALIDATED                        PublicAdvertisedPrefix_Status = 66197998
)

// Enum value maps for PublicAdvertisedPrefix_Status.
var (
	PublicAdvertisedPrefix_Status_name = map[int32]string{
		0:         "UNDEFINED_STATUS",
		518841124: "INITIAL",
		480889551: "PREFIX_CONFIGURATION_COMPLETE",
		378550961: "PREFIX_CONFIGURATION_IN_PROGRESS",
		284375783: "PREFIX_REMOVAL_IN_PROGRESS",
		513497167: "PTR_CONFIGURED",
		295755183: "REVERSE_DNS_LOOKUP_FAILED",
		66197998:  "VALIDATED",
	}
	PublicAdvertisedPrefix_Status_value = map[string]int32{
		"UNDEFINED_STATUS":                 0,
		"INITIAL":                          518841124,
		"PREFIX_CONFIGURATION_COMPLETE":    480889551,
		"PREFIX_CONFIGURATION_IN_PROGRESS": 378550961,
		"PREFIX_REMOVAL_IN_PROGRESS":       284375783,
		"PTR_CONFIGURED":                   513497167,
		"REVERSE_DNS_LOOKUP_FAILED":        295755183,
		"VALIDATED":                        66197998,
	}
)

func (x PublicAdvertisedPrefix_Status) Enum() *PublicAdvertisedPrefix_Status {
	p := new(PublicAdvertisedPrefix_Status)
	*p = x
	return p
}

func (x PublicAdvertisedPrefix_Status) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (PublicAdvertisedPrefix_Status) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[130].Descriptor()
}

func (PublicAdvertisedPrefix_Status) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[130]
}

func (x PublicAdvertisedPrefix_Status) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use PublicAdvertisedPrefix_Status.Descriptor instead.
func (PublicAdvertisedPrefix_Status) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{363, 0}
}

// [Output Only] The status of the sub public delegated prefix.
type PublicDelegatedPrefixPublicDelegatedSubPrefix_Status int32

const (
	// A value indicating that the enum field is not set.
	PublicDelegatedPrefixPublicDelegatedSubPrefix_UNDEFINED_STATUS PublicDelegatedPrefixPublicDelegatedSubPrefix_Status = 0
	PublicDelegatedPrefixPublicDelegatedSubPrefix_ACTIVE           PublicDelegatedPrefixPublicDelegatedSubPrefix_Status = 314733318
	PublicDelegatedPrefixPublicDelegatedSubPrefix_INACTIVE         PublicDelegatedPrefixPublicDelegatedSubPrefix_Status = 270421099
)

// Enum value maps for PublicDelegatedPrefixPublicDelegatedSubPrefix_Status.
var (
	PublicDelegatedPrefixPublicDelegatedSubPrefix_Status_name = map[int32]string{
		0:         "UNDEFINED_STATUS",
		314733318: "ACTIVE",
		270421099: "INACTIVE",
	}
	PublicDelegatedPrefixPublicDelegatedSubPrefix_Status_value = map[string]int32{
		"UNDEFINED_STATUS": 0,
		"ACTIVE":           314733318,
		"INACTIVE":         270421099,
	}
)

func (x PublicDelegatedPrefixPublicDelegatedSubPrefix_Status) Enum() *PublicDelegatedPrefixPublicDelegatedSubPrefix_Status {
	p := new(PublicDelegatedPrefixPublicDelegatedSubPrefix_Status)
	*p = x
	return p
}

func (x PublicDelegatedPrefixPublicDelegatedSubPrefix_Status) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (PublicDelegatedPrefixPublicDelegatedSubPrefix_Status) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[131].Descriptor()
}

func (PublicDelegatedPrefixPublicDelegatedSubPrefix_Status) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[131]
}

func (x PublicDelegatedPrefixPublicDelegatedSubPrefix_Status) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use PublicDelegatedPrefixPublicDelegatedSubPrefix_Status.Descriptor instead.
func (PublicDelegatedPrefixPublicDelegatedSubPrefix_Status) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{365, 0}
}

// [Output Only] The status of the public delegated prefix.
type PublicDelegatedPrefix_Status int32

const (
	// A value indicating that the enum field is not set.
	PublicDelegatedPrefix_UNDEFINED_STATUS PublicDelegatedPrefix_Status = 0
	PublicDelegatedPrefix_ANNOUNCED        PublicDelegatedPrefix_Status = 365103355
	PublicDelegatedPrefix_DELETING         PublicDelegatedPrefix_Status = 528602024
	PublicDelegatedPrefix_INITIALIZING     PublicDelegatedPrefix_Status = 306588749
)

// Enum value maps for PublicDelegatedPrefix_Status.
var (
	PublicDelegatedPrefix_Status_name = map[int32]string{
		0:         "UNDEFINED_STATUS",
		365103355: "ANNOUNCED",
		528602024: "DELETING",
		306588749: "INITIALIZING",
	}
	PublicDelegatedPrefix_Status_value = map[string]int32{
		"UNDEFINED_STATUS": 0,
		"ANNOUNCED":        365103355,
		"DELETING":         528602024,
		"INITIALIZING":     306588749,
	}
)

func (x PublicDelegatedPrefix_Status) Enum() *PublicDelegatedPrefix_Status {
	p := new(PublicDelegatedPrefix_Status)
	*p = x
	return p
}

func (x PublicDelegatedPrefix_Status) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (PublicDelegatedPrefix_Status) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[132].Descriptor()
}

func (PublicDelegatedPrefix_Status) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[132]
}

func (x PublicDelegatedPrefix_Status) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use PublicDelegatedPrefix_Status.Descriptor instead.
func (PublicDelegatedPrefix_Status) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{366, 0}
}

// [Output Only] Status of the region, either UP or DOWN.
type Region_Status int32

const (
	// A value indicating that the enum field is not set.
	Region_UNDEFINED_STATUS Region_Status = 0
	Region_DOWN             Region_Status = 2104482
	Region_UP               Region_Status = 2715
)

// Enum value maps for Region_Status.
var (
	Region_Status_name = map[int32]string{
		0:       "UNDEFINED_STATUS",
		2104482: "DOWN",
		2715:    "UP",
	}
	Region_Status_value = map[string]int32{
		"UNDEFINED_STATUS": 0,
		"DOWN":             2104482,
		"UP":               2715,
	}
)

func (x Region_Status) Enum() *Region_Status {
	p := new(Region_Status)
	*p = x
	return p
}

func (x Region_Status) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Region_Status) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[133].Descriptor()
}

func (Region_Status) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[133]
}

func (x Region_Status) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Region_Status.Descriptor instead.
func (Region_Status) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{370, 0}
}

// Instances in which state should be returned. Valid options are: 'ALL', 'RUNNING'. By default, it lists all instances.
type RegionInstanceGroupsListInstancesRequest_InstanceState int32

const (
	// A value indicating that the enum field is not set.
	RegionInstanceGroupsListInstancesRequest_UNDEFINED_INSTANCE_STATE RegionInstanceGroupsListInstancesRequest_InstanceState = 0
	RegionInstanceGroupsListInstancesRequest_ALL                      RegionInstanceGroupsListInstancesRequest_InstanceState = 64897
	RegionInstanceGroupsListInstancesRequest_RUNNING                  RegionInstanceGroupsListInstancesRequest_InstanceState = 121282975
)

// Enum value maps for RegionInstanceGroupsListInstancesRequest_InstanceState.
var (
	RegionInstanceGroupsListInstancesRequest_InstanceState_name = map[int32]string{
		0:         "UNDEFINED_INSTANCE_STATE",
		64897:     "ALL",
		121282975: "RUNNING",
	}
	RegionInstanceGroupsListInstancesRequest_InstanceState_value = map[string]int32{
		"UNDEFINED_INSTANCE_STATE": 0,
		"ALL":                      64897,
		"RUNNING":                  121282975,
	}
)

func (x RegionInstanceGroupsListInstancesRequest_InstanceState) Enum() *RegionInstanceGroupsListInstancesRequest_InstanceState {
	p := new(RegionInstanceGroupsListInstancesRequest_InstanceState)
	*p = x
	return p
}

func (x RegionInstanceGroupsListInstancesRequest_InstanceState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (RegionInstanceGroupsListInstancesRequest_InstanceState) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[134].Descriptor()
}

func (RegionInstanceGroupsListInstancesRequest_InstanceState) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[134]
}

func (x RegionInstanceGroupsListInstancesRequest_InstanceState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use RegionInstanceGroupsListInstancesRequest_InstanceState.Descriptor instead.
func (RegionInstanceGroupsListInstancesRequest_InstanceState) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{392, 0}
}

// [Output Only] The status of resource policy creation.
type ResourcePolicy_Status int32

const (
	// A value indicating that the enum field is not set.
	ResourcePolicy_UNDEFINED_STATUS ResourcePolicy_Status = 0
	ResourcePolicy_CREATING         ResourcePolicy_Status = 455564985
	ResourcePolicy_DELETING         ResourcePolicy_Status = 528602024
	ResourcePolicy_EXPIRED          ResourcePolicy_Status = 482489093
	ResourcePolicy_INVALID          ResourcePolicy_Status = 530283991
	ResourcePolicy_READY            ResourcePolicy_Status = 77848963
)

// Enum value maps for ResourcePolicy_Status.
var (
	ResourcePolicy_Status_name = map[int32]string{
		0:         "UNDEFINED_STATUS",
		455564985: "CREATING",
		528602024: "DELETING",
		482489093: "EXPIRED",
		530283991: "INVALID",
		77848963:  "READY",
	}
	ResourcePolicy_Status_value = map[string]int32{
		"UNDEFINED_STATUS": 0,
		"CREATING":         455564985,
		"DELETING":         528602024,
		"EXPIRED":          482489093,
		"INVALID":          530283991,
		"READY":            77848963,
	}
)

func (x ResourcePolicy_Status) Enum() *ResourcePolicy_Status {
	p := new(ResourcePolicy_Status)
	*p = x
	return p
}

func (x ResourcePolicy_Status) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ResourcePolicy_Status) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[135].Descriptor()
}

func (ResourcePolicy_Status) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[135]
}

func (x ResourcePolicy_Status) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ResourcePolicy_Status.Descriptor instead.
func (ResourcePolicy_Status) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{405, 0}
}

// Specifies network collocation
type ResourcePolicyGroupPlacementPolicy_Collocation int32

const (
	// A value indicating that the enum field is not set.
	ResourcePolicyGroupPlacementPolicy_UNDEFINED_COLLOCATION   ResourcePolicyGroupPlacementPolicy_Collocation = 0
	ResourcePolicyGroupPlacementPolicy_COLLOCATED              ResourcePolicyGroupPlacementPolicy_Collocation = 103257554
	ResourcePolicyGroupPlacementPolicy_UNSPECIFIED_COLLOCATION ResourcePolicyGroupPlacementPolicy_Collocation = 464308205
)

// Enum value maps for ResourcePolicyGroupPlacementPolicy_Collocation.
var (
	ResourcePolicyGroupPlacementPolicy_Collocation_name = map[int32]string{
		0:         "UNDEFINED_COLLOCATION",
		103257554: "COLLOCATED",
		464308205: "UNSPECIFIED_COLLOCATION",
	}
	ResourcePolicyGroupPlacementPolicy_Collocation_value = map[string]int32{
		"UNDEFINED_COLLOCATION":   0,
		"COLLOCATED":              103257554,
		"UNSPECIFIED_COLLOCATION": 464308205,
	}
)

func (x ResourcePolicyGroupPlacementPolicy_Collocation) Enum() *ResourcePolicyGroupPlacementPolicy_Collocation {
	p := new(ResourcePolicyGroupPlacementPolicy_Collocation)
	*p = x
	return p
}

func (x ResourcePolicyGroupPlacementPolicy_Collocation) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ResourcePolicyGroupPlacementPolicy_Collocation) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[136].Descriptor()
}

func (ResourcePolicyGroupPlacementPolicy_Collocation) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[136]
}

func (x ResourcePolicyGroupPlacementPolicy_Collocation) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ResourcePolicyGroupPlacementPolicy_Collocation.Descriptor instead.
func (ResourcePolicyGroupPlacementPolicy_Collocation) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{407, 0}
}

// Specifies the behavior to apply to scheduled snapshots when the source disk is deleted.
type ResourcePolicySnapshotSchedulePolicyRetentionPolicy_OnSourceDiskDelete int32

const (
	// A value indicating that the enum field is not set.
	ResourcePolicySnapshotSchedulePolicyRetentionPolicy_UNDEFINED_ON_SOURCE_DISK_DELETE   ResourcePolicySnapshotSchedulePolicyRetentionPolicy_OnSourceDiskDelete = 0
	ResourcePolicySnapshotSchedulePolicyRetentionPolicy_APPLY_RETENTION_POLICY            ResourcePolicySnapshotSchedulePolicyRetentionPolicy_OnSourceDiskDelete = 535071332
	ResourcePolicySnapshotSchedulePolicyRetentionPolicy_KEEP_AUTO_SNAPSHOTS               ResourcePolicySnapshotSchedulePolicyRetentionPolicy_OnSourceDiskDelete = 258925689
	ResourcePolicySnapshotSchedulePolicyRetentionPolicy_UNSPECIFIED_ON_SOURCE_DISK_DELETE ResourcePolicySnapshotSchedulePolicyRetentionPolicy_OnSourceDiskDelete = 239140769
)

// Enum value maps for ResourcePolicySnapshotSchedulePolicyRetentionPolicy_OnSourceDiskDelete.
var (
	ResourcePolicySnapshotSchedulePolicyRetentionPolicy_OnSourceDiskDelete_name = map[int32]string{
		0:         "UNDEFINED_ON_SOURCE_DISK_DELETE",
		535071332: "APPLY_RETENTION_POLICY",
		258925689: "KEEP_AUTO_SNAPSHOTS",
		239140769: "UNSPECIFIED_ON_SOURCE_DISK_DELETE",
	}
	ResourcePolicySnapshotSchedulePolicyRetentionPolicy_OnSourceDiskDelete_value = map[string]int32{
		"UNDEFINED_ON_SOURCE_DISK_DELETE":   0,
		"APPLY_RETENTION_POLICY":            535071332,
		"KEEP_AUTO_SNAPSHOTS":               258925689,
		"UNSPECIFIED_ON_SOURCE_DISK_DELETE": 239140769,
	}
)

func (x ResourcePolicySnapshotSchedulePolicyRetentionPolicy_OnSourceDiskDelete) Enum() *ResourcePolicySnapshotSchedulePolicyRetentionPolicy_OnSourceDiskDelete {
	p := new(ResourcePolicySnapshotSchedulePolicyRetentionPolicy_OnSourceDiskDelete)
	*p = x
	return p
}

func (x ResourcePolicySnapshotSchedulePolicyRetentionPolicy_OnSourceDiskDelete) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ResourcePolicySnapshotSchedulePolicyRetentionPolicy_OnSourceDiskDelete) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[137].Descriptor()
}

func (ResourcePolicySnapshotSchedulePolicyRetentionPolicy_OnSourceDiskDelete) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[137]
}

func (x ResourcePolicySnapshotSchedulePolicyRetentionPolicy_OnSourceDiskDelete) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ResourcePolicySnapshotSchedulePolicyRetentionPolicy_OnSourceDiskDelete.Descriptor instead.
func (ResourcePolicySnapshotSchedulePolicyRetentionPolicy_OnSourceDiskDelete) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{417, 0}
}

// Defines a schedule that runs on specific days of the week. Specify one or more days. The following options are available: MONDAY, TUESDAY, WEDNESDAY, THURSDAY, FRIDAY, SATURDAY, SUNDAY.
type ResourcePolicyWeeklyCycleDayOfWeek_Day int32

const (
	// A value indicating that the enum field is not set.
	ResourcePolicyWeeklyCycleDayOfWeek_UNDEFINED_DAY ResourcePolicyWeeklyCycleDayOfWeek_Day = 0
	ResourcePolicyWeeklyCycleDayOfWeek_FRIDAY        ResourcePolicyWeeklyCycleDayOfWeek_Day = 471398751
	ResourcePolicyWeeklyCycleDayOfWeek_INVALID       ResourcePolicyWeeklyCycleDayOfWeek_Day = 530283991
	ResourcePolicyWeeklyCycleDayOfWeek_MONDAY        ResourcePolicyWeeklyCycleDayOfWeek_Day = 132310288
	ResourcePolicyWeeklyCycleDayOfWeek_SATURDAY      ResourcePolicyWeeklyCycleDayOfWeek_Day = 279037881
	ResourcePolicyWeeklyCycleDayOfWeek_SUNDAY        ResourcePolicyWeeklyCycleDayOfWeek_Day = 309626320
	ResourcePolicyWeeklyCycleDayOfWeek_THURSDAY      ResourcePolicyWeeklyCycleDayOfWeek_Day = 207198682
	ResourcePolicyWeeklyCycleDayOfWeek_TUESDAY       ResourcePolicyWeeklyCycleDayOfWeek_Day = 277509677
	ResourcePolicyWeeklyCycleDayOfWeek_WEDNESDAY     ResourcePolicyWeeklyCycleDayOfWeek_Day = 422029110
)

// Enum value maps for ResourcePolicyWeeklyCycleDayOfWeek_Day.
var (
	ResourcePolicyWeeklyCycleDayOfWeek_Day_name = map[int32]string{
		0:         "UNDEFINED_DAY",
		471398751: "FRIDAY",
		530283991: "INVALID",
		132310288: "MONDAY",
		279037881: "SATURDAY",
		309626320: "SUNDAY",
		207198682: "THURSDAY",
		277509677: "TUESDAY",
		422029110: "WEDNESDAY",
	}
	ResourcePolicyWeeklyCycleDayOfWeek_Day_value = map[string]int32{
		"UNDEFINED_DAY": 0,
		"FRIDAY":        471398751,
		"INVALID":       530283991,
		"MONDAY":        132310288,
		"SATURDAY":      279037881,
		"SUNDAY":        309626320,
		"THURSDAY":      207198682,
		"TUESDAY":       277509677,
		"WEDNESDAY":     422029110,
	}
)

func (x ResourcePolicyWeeklyCycleDayOfWeek_Day) Enum() *ResourcePolicyWeeklyCycleDayOfWeek_Day {
	p := new(ResourcePolicyWeeklyCycleDayOfWeek_Day)
	*p = x
	return p
}

func (x ResourcePolicyWeeklyCycleDayOfWeek_Day) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ResourcePolicyWeeklyCycleDayOfWeek_Day) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[138].Descriptor()
}

func (ResourcePolicyWeeklyCycleDayOfWeek_Day) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[138]
}

func (x ResourcePolicyWeeklyCycleDayOfWeek_Day) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ResourcePolicyWeeklyCycleDayOfWeek_Day.Descriptor instead.
func (ResourcePolicyWeeklyCycleDayOfWeek_Day) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{421, 0}
}

// User-specified flag to indicate which mode to use for advertisement. The options are DEFAULT or CUSTOM.
type RouterBgp_AdvertiseMode int32

const (
	// A value indicating that the enum field is not set.
	RouterBgp_UNDEFINED_ADVERTISE_MODE RouterBgp_AdvertiseMode = 0
	RouterBgp_CUSTOM                   RouterBgp_AdvertiseMode = 388595569
	RouterBgp_DEFAULT                  RouterBgp_AdvertiseMode = 115302945
)

// Enum value maps for RouterBgp_AdvertiseMode.
var (
	RouterBgp_AdvertiseMode_name = map[int32]string{
		0:         "UNDEFINED_ADVERTISE_MODE",
		388595569: "CUSTOM",
		115302945: "DEFAULT",
	}
	RouterBgp_AdvertiseMode_value = map[string]int32{
		"UNDEFINED_ADVERTISE_MODE": 0,
		"CUSTOM":                   388595569,
		"DEFAULT":                  115302945,
	}
)

func (x RouterBgp_AdvertiseMode) Enum() *RouterBgp_AdvertiseMode {
	p := new(RouterBgp_AdvertiseMode)
	*p = x
	return p
}

func (x RouterBgp_AdvertiseMode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (RouterBgp_AdvertiseMode) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[139].Descriptor()
}

func (RouterBgp_AdvertiseMode) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[139]
}

func (x RouterBgp_AdvertiseMode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use RouterBgp_AdvertiseMode.Descriptor instead.
func (RouterBgp_AdvertiseMode) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{424, 0}
}

//
type RouterBgp_AdvertisedGroups int32

const (
	// A value indicating that the enum field is not set.
	RouterBgp_UNDEFINED_ADVERTISED_GROUPS RouterBgp_AdvertisedGroups = 0
	RouterBgp_ALL_SUBNETS                 RouterBgp_AdvertisedGroups = 3622872
)

// Enum value maps for RouterBgp_AdvertisedGroups.
var (
	RouterBgp_AdvertisedGroups_name = map[int32]string{
		0:       "UNDEFINED_ADVERTISED_GROUPS",
		3622872: "ALL_SUBNETS",
	}
	RouterBgp_AdvertisedGroups_value = map[string]int32{
		"UNDEFINED_ADVERTISED_GROUPS": 0,
		"ALL_SUBNETS":                 3622872,
	}
)

func (x RouterBgp_AdvertisedGroups) Enum() *RouterBgp_AdvertisedGroups {
	p := new(RouterBgp_AdvertisedGroups)
	*p = x
	return p
}

func (x RouterBgp_AdvertisedGroups) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (RouterBgp_AdvertisedGroups) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[140].Descriptor()
}

func (RouterBgp_AdvertisedGroups) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[140]
}

func (x RouterBgp_AdvertisedGroups) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use RouterBgp_AdvertisedGroups.Descriptor instead.
func (RouterBgp_AdvertisedGroups) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{424, 1}
}

// User-specified flag to indicate which mode to use for advertisement.
type RouterBgpPeer_AdvertiseMode int32

const (
	// A value indicating that the enum field is not set.
	RouterBgpPeer_UNDEFINED_ADVERTISE_MODE RouterBgpPeer_AdvertiseMode = 0
	RouterBgpPeer_CUSTOM                   RouterBgpPeer_AdvertiseMode = 388595569
	RouterBgpPeer_DEFAULT                  RouterBgpPeer_AdvertiseMode = 115302945
)

// Enum value maps for RouterBgpPeer_AdvertiseMode.
var (
	RouterBgpPeer_AdvertiseMode_name = map[int32]string{
		0:         "UNDEFINED_ADVERTISE_MODE",
		388595569: "CUSTOM",
		115302945: "DEFAULT",
	}
	RouterBgpPeer_AdvertiseMode_value = map[string]int32{
		"UNDEFINED_ADVERTISE_MODE": 0,
		"CUSTOM":                   388595569,
		"DEFAULT":                  115302945,
	}
)

func (x RouterBgpPeer_AdvertiseMode) Enum() *RouterBgpPeer_AdvertiseMode {
	p := new(RouterBgpPeer_AdvertiseMode)
	*p = x
	return p
}

func (x RouterBgpPeer_AdvertiseMode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (RouterBgpPeer_AdvertiseMode) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[141].Descriptor()
}

func (RouterBgpPeer_AdvertiseMode) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[141]
}

func (x RouterBgpPeer_AdvertiseMode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use RouterBgpPeer_AdvertiseMode.Descriptor instead.
func (RouterBgpPeer_AdvertiseMode) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{425, 0}
}

//
type RouterBgpPeer_AdvertisedGroups int32

const (
	// A value indicating that the enum field is not set.
	RouterBgpPeer_UNDEFINED_ADVERTISED_GROUPS RouterBgpPeer_AdvertisedGroups = 0
	RouterBgpPeer_ALL_SUBNETS                 RouterBgpPeer_AdvertisedGroups = 3622872
)

// Enum value maps for RouterBgpPeer_AdvertisedGroups.
var (
	RouterBgpPeer_AdvertisedGroups_name = map[int32]string{
		0:       "UNDEFINED_ADVERTISED_GROUPS",
		3622872: "ALL_SUBNETS",
	}
	RouterBgpPeer_AdvertisedGroups_value = map[string]int32{
		"UNDEFINED_ADVERTISED_GROUPS": 0,
		"ALL_SUBNETS":                 3622872,
	}
)

func (x RouterBgpPeer_AdvertisedGroups) Enum() *RouterBgpPeer_AdvertisedGroups {
	p := new(RouterBgpPeer_AdvertisedGroups)
	*p = x
	return p
}

func (x RouterBgpPeer_AdvertisedGroups) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (RouterBgpPeer_AdvertisedGroups) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[142].Descriptor()
}

func (RouterBgpPeer_AdvertisedGroups) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[142]
}

func (x RouterBgpPeer_AdvertisedGroups) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use RouterBgpPeer_AdvertisedGroups.Descriptor instead.
func (RouterBgpPeer_AdvertisedGroups) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{425, 1}
}

// [Output Only] The resource that configures and manages this BGP peer.
// - MANAGED_BY_USER is the default value and can be managed by you or other users
// - MANAGED_BY_ATTACHMENT is a BGP peer that is configured and managed by Cloud Interconnect, specifically by an InterconnectAttachment of type PARTNER. Google automatically creates, updates, and deletes this type of BGP peer when the PARTNER InterconnectAttachment is created, updated, or deleted.
type RouterBgpPeer_ManagementType int32

const (
	// A value indicating that the enum field is not set.
	RouterBgpPeer_UNDEFINED_MANAGEMENT_TYPE RouterBgpPeer_ManagementType = 0
	RouterBgpPeer_MANAGED_BY_ATTACHMENT     RouterBgpPeer_ManagementType = 458926411
	RouterBgpPeer_MANAGED_BY_USER           RouterBgpPeer_ManagementType = 317294067
)

// Enum value maps for RouterBgpPeer_ManagementType.
var (
	RouterBgpPeer_ManagementType_name = map[int32]string{
		0:         "UNDEFINED_MANAGEMENT_TYPE",
		458926411: "MANAGED_BY_ATTACHMENT",
		317294067: "MANAGED_BY_USER",
	}
	RouterBgpPeer_ManagementType_value = map[string]int32{
		"UNDEFINED_MANAGEMENT_TYPE": 0,
		"MANAGED_BY_ATTACHMENT":     458926411,
		"MANAGED_BY_USER":           317294067,
	}
)

func (x RouterBgpPeer_ManagementType) Enum() *RouterBgpPeer_ManagementType {
	p := new(RouterBgpPeer_ManagementType)
	*p = x
	return p
}

func (x RouterBgpPeer_ManagementType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (RouterBgpPeer_ManagementType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[143].Descriptor()
}

func (RouterBgpPeer_ManagementType) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[143]
}

func (x RouterBgpPeer_ManagementType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use RouterBgpPeer_ManagementType.Descriptor instead.
func (RouterBgpPeer_ManagementType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{425, 2}
}

// [Output Only] The resource that configures and manages this interface.
// - MANAGED_BY_USER is the default value and can be managed directly by users.
// - MANAGED_BY_ATTACHMENT is an interface that is configured and managed by Cloud Interconnect, specifically, by an InterconnectAttachment of type PARTNER. Google automatically creates, updates, and deletes this type of interface when the PARTNER InterconnectAttachment is created, updated, or deleted.
type RouterInterface_ManagementType int32

const (
	// A value indicating that the enum field is not set.
	RouterInterface_UNDEFINED_MANAGEMENT_TYPE RouterInterface_ManagementType = 0
	RouterInterface_MANAGED_BY_ATTACHMENT     RouterInterface_ManagementType = 458926411
	RouterInterface_MANAGED_BY_USER           RouterInterface_ManagementType = 317294067
)

// Enum value maps for RouterInterface_ManagementType.
var (
	RouterInterface_ManagementType_name = map[int32]string{
		0:         "UNDEFINED_MANAGEMENT_TYPE",
		458926411: "MANAGED_BY_ATTACHMENT",
		317294067: "MANAGED_BY_USER",
	}
	RouterInterface_ManagementType_value = map[string]int32{
		"UNDEFINED_MANAGEMENT_TYPE": 0,
		"MANAGED_BY_ATTACHMENT":     458926411,
		"MANAGED_BY_USER":           317294067,
	}
)

func (x RouterInterface_ManagementType) Enum() *RouterInterface_ManagementType {
	p := new(RouterInterface_ManagementType)
	*p = x
	return p
}

func (x RouterInterface_ManagementType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (RouterInterface_ManagementType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[144].Descriptor()
}

func (RouterInterface_ManagementType) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[144]
}

func (x RouterInterface_ManagementType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use RouterInterface_ManagementType.Descriptor instead.
func (RouterInterface_ManagementType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{426, 0}
}

// Specify the NatIpAllocateOption, which can take one of the following values:
// - MANUAL_ONLY: Uses only Nat IP addresses provided by customers. When there are not enough specified Nat IPs, the Nat service fails for new VMs.
// - AUTO_ONLY: Nat IPs are allocated by Google Cloud Platform; customers can't specify any Nat IPs. When choosing AUTO_ONLY, then nat_ip should be empty.
type RouterNat_NatIpAllocateOption int32

const (
	// A value indicating that the enum field is not set.
	RouterNat_UNDEFINED_NAT_IP_ALLOCATE_OPTION RouterNat_NatIpAllocateOption = 0
	RouterNat_AUTO_ONLY                        RouterNat_NatIpAllocateOption = 182333500
	RouterNat_MANUAL_ONLY                      RouterNat_NatIpAllocateOption = 261251205
)

// Enum value maps for RouterNat_NatIpAllocateOption.
var (
	RouterNat_NatIpAllocateOption_name = map[int32]string{
		0:         "UNDEFINED_NAT_IP_ALLOCATE_OPTION",
		182333500: "AUTO_ONLY",
		261251205: "MANUAL_ONLY",
	}
	RouterNat_NatIpAllocateOption_value = map[string]int32{
		"UNDEFINED_NAT_IP_ALLOCATE_OPTION": 0,
		"AUTO_ONLY":                        182333500,
		"MANUAL_ONLY":                      261251205,
	}
)

func (x RouterNat_NatIpAllocateOption) Enum() *RouterNat_NatIpAllocateOption {
	p := new(RouterNat_NatIpAllocateOption)
	*p = x
	return p
}

func (x RouterNat_NatIpAllocateOption) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (RouterNat_NatIpAllocateOption) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[145].Descriptor()
}

func (RouterNat_NatIpAllocateOption) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[145]
}

func (x RouterNat_NatIpAllocateOption) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use RouterNat_NatIpAllocateOption.Descriptor instead.
func (RouterNat_NatIpAllocateOption) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{427, 0}
}

// Specify the Nat option, which can take one of the following values:
// - ALL_SUBNETWORKS_ALL_IP_RANGES: All of the IP ranges in every Subnetwork are allowed to Nat.
// - ALL_SUBNETWORKS_ALL_PRIMARY_IP_RANGES: All of the primary IP ranges in every Subnetwork are allowed to Nat.
// - LIST_OF_SUBNETWORKS: A list of Subnetworks are allowed to Nat (specified in the field subnetwork below) The default is SUBNETWORK_IP_RANGE_TO_NAT_OPTION_UNSPECIFIED. Note that if this field contains ALL_SUBNETWORKS_ALL_IP_RANGES or ALL_SUBNETWORKS_ALL_PRIMARY_IP_RANGES, then there should not be any other Router.Nat section in any Router for this network in this region.
type RouterNat_SourceSubnetworkIpRangesToNat int32

const (
	// A value indicating that the enum field is not set.
	RouterNat_UNDEFINED_SOURCE_SUBNETWORK_IP_RANGES_TO_NAT RouterNat_SourceSubnetworkIpRangesToNat = 0
	RouterNat_ALL_SUBNETWORKS_ALL_IP_RANGES                RouterNat_SourceSubnetworkIpRangesToNat = 179964376
	RouterNat_ALL_SUBNETWORKS_ALL_PRIMARY_IP_RANGES        RouterNat_SourceSubnetworkIpRangesToNat = 185573819
	RouterNat_LIST_OF_SUBNETWORKS                          RouterNat_SourceSubnetworkIpRangesToNat = 517542270
)

// Enum value maps for RouterNat_SourceSubnetworkIpRangesToNat.
var (
	RouterNat_SourceSubnetworkIpRangesToNat_name = map[int32]string{
		0:         "UNDEFINED_SOURCE_SUBNETWORK_IP_RANGES_TO_NAT",
		179964376: "ALL_SUBNETWORKS_ALL_IP_RANGES",
		185573819: "ALL_SUBNETWORKS_ALL_PRIMARY_IP_RANGES",
		517542270: "LIST_OF_SUBNETWORKS",
	}
	RouterNat_SourceSubnetworkIpRangesToNat_value = map[string]int32{
		"UNDEFINED_SOURCE_SUBNETWORK_IP_RANGES_TO_NAT": 0,
		"ALL_SUBNETWORKS_ALL_IP_RANGES":                179964376,
		"ALL_SUBNETWORKS_ALL_PRIMARY_IP_RANGES":        185573819,
		"LIST_OF_SUBNETWORKS":                          517542270,
	}
)

func (x RouterNat_SourceSubnetworkIpRangesToNat) Enum() *RouterNat_SourceSubnetworkIpRangesToNat {
	p := new(RouterNat_SourceSubnetworkIpRangesToNat)
	*p = x
	return p
}

func (x RouterNat_SourceSubnetworkIpRangesToNat) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (RouterNat_SourceSubnetworkIpRangesToNat) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[146].Descriptor()
}

func (RouterNat_SourceSubnetworkIpRangesToNat) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[146]
}

func (x RouterNat_SourceSubnetworkIpRangesToNat) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use RouterNat_SourceSubnetworkIpRangesToNat.Descriptor instead.
func (RouterNat_SourceSubnetworkIpRangesToNat) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{427, 1}
}

// Specify the desired filtering of logs on this NAT. If unspecified, logs are exported for all connections handled by this NAT. This option can take one of the following values:
// - ERRORS_ONLY: Export logs only for connection failures.
// - TRANSLATIONS_ONLY: Export logs only for successful connections.
// - ALL: Export logs for all connections, successful and unsuccessful.
type RouterNatLogConfig_Filter int32

const (
	// A value indicating that the enum field is not set.
	RouterNatLogConfig_UNDEFINED_FILTER  RouterNatLogConfig_Filter = 0
	RouterNatLogConfig_ALL               RouterNatLogConfig_Filter = 64897
	RouterNatLogConfig_ERRORS_ONLY       RouterNatLogConfig_Filter = 307484672
	RouterNatLogConfig_TRANSLATIONS_ONLY RouterNatLogConfig_Filter = 357212649
)

// Enum value maps for RouterNatLogConfig_Filter.
var (
	RouterNatLogConfig_Filter_name = map[int32]string{
		0:         "UNDEFINED_FILTER",
		64897:     "ALL",
		307484672: "ERRORS_ONLY",
		357212649: "TRANSLATIONS_ONLY",
	}
	RouterNatLogConfig_Filter_value = map[string]int32{
		"UNDEFINED_FILTER":  0,
		"ALL":               64897,
		"ERRORS_ONLY":       307484672,
		"TRANSLATIONS_ONLY": 357212649,
	}
)

func (x RouterNatLogConfig_Filter) Enum() *RouterNatLogConfig_Filter {
	p := new(RouterNatLogConfig_Filter)
	*p = x
	return p
}

func (x RouterNatLogConfig_Filter) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (RouterNatLogConfig_Filter) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[147].Descriptor()
}

func (RouterNatLogConfig_Filter) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[147]
}

func (x RouterNatLogConfig_Filter) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use RouterNatLogConfig_Filter.Descriptor instead.
func (RouterNatLogConfig_Filter) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{433, 0}
}

//
type RouterNatSubnetworkToNat_SourceIpRangesToNat int32

const (
	// A value indicating that the enum field is not set.
	RouterNatSubnetworkToNat_UNDEFINED_SOURCE_IP_RANGES_TO_NAT RouterNatSubnetworkToNat_SourceIpRangesToNat = 0
	RouterNatSubnetworkToNat_ALL_IP_RANGES                     RouterNatSubnetworkToNat_SourceIpRangesToNat = 35608496
	RouterNatSubnetworkToNat_LIST_OF_SECONDARY_IP_RANGES       RouterNatSubnetworkToNat_SourceIpRangesToNat = 192289308
	RouterNatSubnetworkToNat_PRIMARY_IP_RANGE                  RouterNatSubnetworkToNat_SourceIpRangesToNat = 297109954
)

// Enum value maps for RouterNatSubnetworkToNat_SourceIpRangesToNat.
var (
	RouterNatSubnetworkToNat_SourceIpRangesToNat_name = map[int32]string{
		0:         "UNDEFINED_SOURCE_IP_RANGES_TO_NAT",
		35608496:  "ALL_IP_RANGES",
		192289308: "LIST_OF_SECONDARY_IP_RANGES",
		297109954: "PRIMARY_IP_RANGE",
	}
	RouterNatSubnetworkToNat_SourceIpRangesToNat_value = map[string]int32{
		"UNDEFINED_SOURCE_IP_RANGES_TO_NAT": 0,
		"ALL_IP_RANGES":                     35608496,
		"LIST_OF_SECONDARY_IP_RANGES":       192289308,
		"PRIMARY_IP_RANGE":                  297109954,
	}
)

func (x RouterNatSubnetworkToNat_SourceIpRangesToNat) Enum() *RouterNatSubnetworkToNat_SourceIpRangesToNat {
	p := new(RouterNatSubnetworkToNat_SourceIpRangesToNat)
	*p = x
	return p
}

func (x RouterNatSubnetworkToNat_SourceIpRangesToNat) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (RouterNatSubnetworkToNat_SourceIpRangesToNat) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[148].Descriptor()
}

func (RouterNatSubnetworkToNat_SourceIpRangesToNat) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[148]
}

func (x RouterNatSubnetworkToNat_SourceIpRangesToNat) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use RouterNatSubnetworkToNat_SourceIpRangesToNat.Descriptor instead.
func (RouterNatSubnetworkToNat_SourceIpRangesToNat) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{434, 0}
}

// Status of the BGP peer: {UP, DOWN}
type RouterStatusBgpPeerStatus_Status int32

const (
	// A value indicating that the enum field is not set.
	RouterStatusBgpPeerStatus_UNDEFINED_STATUS RouterStatusBgpPeerStatus_Status = 0
	RouterStatusBgpPeerStatus_DOWN             RouterStatusBgpPeerStatus_Status = 2104482
	RouterStatusBgpPeerStatus_UNKNOWN          RouterStatusBgpPeerStatus_Status = 433141802
	RouterStatusBgpPeerStatus_UP               RouterStatusBgpPeerStatus_Status = 2715
)

// Enum value maps for RouterStatusBgpPeerStatus_Status.
var (
	RouterStatusBgpPeerStatus_Status_name = map[int32]string{
		0:         "UNDEFINED_STATUS",
		2104482:   "DOWN",
		433141802: "UNKNOWN",
		2715:      "UP",
	}
	RouterStatusBgpPeerStatus_Status_value = map[string]int32{
		"UNDEFINED_STATUS": 0,
		"DOWN":             2104482,
		"UNKNOWN":          433141802,
		"UP":               2715,
	}
)

func (x RouterStatusBgpPeerStatus_Status) Enum() *RouterStatusBgpPeerStatus_Status {
	p := new(RouterStatusBgpPeerStatus_Status)
	*p = x
	return p
}

func (x RouterStatusBgpPeerStatus_Status) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (RouterStatusBgpPeerStatus_Status) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[149].Descriptor()
}

func (RouterStatusBgpPeerStatus_Status) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[149]
}

func (x RouterStatusBgpPeerStatus_Status) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use RouterStatusBgpPeerStatus_Status.Descriptor instead.
func (RouterStatusBgpPeerStatus_Status) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{435, 0}
}

// Defines the operation of node selection. Valid operators are IN for affinity and NOT_IN for anti-affinity.
type SchedulingNodeAffinity_Operator int32

const (
	// A value indicating that the enum field is not set.
	SchedulingNodeAffinity_UNDEFINED_OPERATOR   SchedulingNodeAffinity_Operator = 0
	SchedulingNodeAffinity_IN                   SchedulingNodeAffinity_Operator = 2341
	SchedulingNodeAffinity_NOT_IN               SchedulingNodeAffinity_Operator = 161144369
	SchedulingNodeAffinity_OPERATOR_UNSPECIFIED SchedulingNodeAffinity_Operator = 128892924
)

// Enum value maps for SchedulingNodeAffinity_Operator.
var (
	SchedulingNodeAffinity_Operator_name = map[int32]string{
		0:         "UNDEFINED_OPERATOR",
		2341:      "IN",
		161144369: "NOT_IN",
		128892924: "OPERATOR_UNSPECIFIED",
	}
	SchedulingNodeAffinity_Operator_value = map[string]int32{
		"UNDEFINED_OPERATOR":   0,
		"IN":                   2341,
		"NOT_IN":               161144369,
		"OPERATOR_UNSPECIFIED": 128892924,
	}
)

func (x SchedulingNodeAffinity_Operator) Enum() *SchedulingNodeAffinity_Operator {
	p := new(SchedulingNodeAffinity_Operator)
	*p = x
	return p
}

func (x SchedulingNodeAffinity_Operator) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SchedulingNodeAffinity_Operator) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[150].Descriptor()
}

func (SchedulingNodeAffinity_Operator) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[150]
}

func (x SchedulingNodeAffinity_Operator) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SchedulingNodeAffinity_Operator.Descriptor instead.
func (SchedulingNodeAffinity_Operator) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{440, 0}
}

// Preconfigured versioned expression. If this field is specified, config must also be specified. Available preconfigured expressions along with their requirements are: SRC_IPS_V1 - must specify the corresponding src_ip_range field in config.
type SecurityPolicyRuleMatcher_VersionedExpr int32

const (
	// A value indicating that the enum field is not set.
	SecurityPolicyRuleMatcher_UNDEFINED_VERSIONED_EXPR SecurityPolicyRuleMatcher_VersionedExpr = 0
	SecurityPolicyRuleMatcher_SRC_IPS_V1               SecurityPolicyRuleMatcher_VersionedExpr = 70925961
)

// Enum value maps for SecurityPolicyRuleMatcher_VersionedExpr.
var (
	SecurityPolicyRuleMatcher_VersionedExpr_name = map[int32]string{
		0:        "UNDEFINED_VERSIONED_EXPR",
		70925961: "SRC_IPS_V1",
	}
	SecurityPolicyRuleMatcher_VersionedExpr_value = map[string]int32{
		"UNDEFINED_VERSIONED_EXPR": 0,
		"SRC_IPS_V1":               70925961,
	}
)

func (x SecurityPolicyRuleMatcher_VersionedExpr) Enum() *SecurityPolicyRuleMatcher_VersionedExpr {
	p := new(SecurityPolicyRuleMatcher_VersionedExpr)
	*p = x
	return p
}

func (x SecurityPolicyRuleMatcher_VersionedExpr) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SecurityPolicyRuleMatcher_VersionedExpr) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[151].Descriptor()
}

func (SecurityPolicyRuleMatcher_VersionedExpr) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[151]
}

func (x SecurityPolicyRuleMatcher_VersionedExpr) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SecurityPolicyRuleMatcher_VersionedExpr.Descriptor instead.
func (SecurityPolicyRuleMatcher_VersionedExpr) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{448, 0}
}

// [Output Only] The status of the snapshot. This can be CREATING, DELETING, FAILED, READY, or UPLOADING.
type Snapshot_Status int32

const (
	// A value indicating that the enum field is not set.
	Snapshot_UNDEFINED_STATUS Snapshot_Status = 0
	Snapshot_CREATING         Snapshot_Status = 455564985
	Snapshot_DELETING         Snapshot_Status = 528602024
	Snapshot_FAILED           Snapshot_Status = 455706685
	Snapshot_READY            Snapshot_Status = 77848963
	Snapshot_UPLOADING        Snapshot_Status = 267603489
)

// Enum value maps for Snapshot_Status.
var (
	Snapshot_Status_name = map[int32]string{
		0:         "UNDEFINED_STATUS",
		455564985: "CREATING",
		528602024: "DELETING",
		455706685: "FAILED",
		77848963:  "READY",
		267603489: "UPLOADING",
	}
	Snapshot_Status_value = map[string]int32{
		"UNDEFINED_STATUS": 0,
		"CREATING":         455564985,
		"DELETING":         528602024,
		"FAILED":           455706685,
		"READY":            77848963,
		"UPLOADING":        267603489,
	}
)

func (x Snapshot_Status) Enum() *Snapshot_Status {
	p := new(Snapshot_Status)
	*p = x
	return p
}

func (x Snapshot_Status) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Snapshot_Status) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[152].Descriptor()
}

func (Snapshot_Status) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[152]
}

func (x Snapshot_Status) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Snapshot_Status.Descriptor instead.
func (Snapshot_Status) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{454, 0}
}

// [Output Only] An indicator whether storageBytes is in a stable state or it is being adjusted as a result of shared storage reallocation. This status can either be UPDATING, meaning the size of the snapshot is being updated, or UP_TO_DATE, meaning the size of the snapshot is up-to-date.
type Snapshot_StorageBytesStatus int32

const (
	// A value indicating that the enum field is not set.
	Snapshot_UNDEFINED_STORAGE_BYTES_STATUS Snapshot_StorageBytesStatus = 0
	Snapshot_UPDATING                       Snapshot_StorageBytesStatus = 494614342
	Snapshot_UP_TO_DATE                     Snapshot_StorageBytesStatus = 101306702
)

// Enum value maps for Snapshot_StorageBytesStatus.
var (
	Snapshot_StorageBytesStatus_name = map[int32]string{
		0:         "UNDEFINED_STORAGE_BYTES_STATUS",
		494614342: "UPDATING",
		101306702: "UP_TO_DATE",
	}
	Snapshot_StorageBytesStatus_value = map[string]int32{
		"UNDEFINED_STORAGE_BYTES_STATUS": 0,
		"UPDATING":                       494614342,
		"UP_TO_DATE":                     101306702,
	}
)

func (x Snapshot_StorageBytesStatus) Enum() *Snapshot_StorageBytesStatus {
	p := new(Snapshot_StorageBytesStatus)
	*p = x
	return p
}

func (x Snapshot_StorageBytesStatus) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Snapshot_StorageBytesStatus) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[153].Descriptor()
}

func (Snapshot_StorageBytesStatus) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[153]
}

func (x Snapshot_StorageBytesStatus) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Snapshot_StorageBytesStatus.Descriptor instead.
func (Snapshot_StorageBytesStatus) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{454, 1}
}

// [Output only] Status of the managed certificate resource.
type SslCertificateManagedSslCertificate_Status int32

const (
	// A value indicating that the enum field is not set.
	SslCertificateManagedSslCertificate_UNDEFINED_STATUS                       SslCertificateManagedSslCertificate_Status = 0
	SslCertificateManagedSslCertificate_ACTIVE                                 SslCertificateManagedSslCertificate_Status = 314733318
	SslCertificateManagedSslCertificate_MANAGED_CERTIFICATE_STATUS_UNSPECIFIED SslCertificateManagedSslCertificate_Status = 474800850
	SslCertificateManagedSslCertificate_PROVISIONING                           SslCertificateManagedSslCertificate_Status = 290896621
	SslCertificateManagedSslCertificate_PROVISIONING_FAILED                    SslCertificateManagedSslCertificate_Status = 76813775
	SslCertificateManagedSslCertificate_PROVISIONING_FAILED_PERMANENTLY        SslCertificateManagedSslCertificate_Status = 275036203
	SslCertificateManagedSslCertificate_RENEWAL_FAILED                         SslCertificateManagedSslCertificate_Status = 434659076
)

// Enum value maps for SslCertificateManagedSslCertificate_Status.
var (
	SslCertificateManagedSslCertificate_Status_name = map[int32]string{
		0:         "UNDEFINED_STATUS",
		314733318: "ACTIVE",
		474800850: "MANAGED_CERTIFICATE_STATUS_UNSPECIFIED",
		290896621: "PROVISIONING",
		76813775:  "PROVISIONING_FAILED",
		275036203: "PROVISIONING_FAILED_PERMANENTLY",
		434659076: "RENEWAL_FAILED",
	}
	SslCertificateManagedSslCertificate_Status_value = map[string]int32{
		"UNDEFINED_STATUS":                       0,
		"ACTIVE":                                 314733318,
		"MANAGED_CERTIFICATE_STATUS_UNSPECIFIED": 474800850,
		"PROVISIONING":                           290896621,
		"PROVISIONING_FAILED":                    76813775,
		"PROVISIONING_FAILED_PERMANENTLY":        275036203,
		"RENEWAL_FAILED":                         434659076,
	}
)

func (x SslCertificateManagedSslCertificate_Status) Enum() *SslCertificateManagedSslCertificate_Status {
	p := new(SslCertificateManagedSslCertificate_Status)
	*p = x
	return p
}

func (x SslCertificateManagedSslCertificate_Status) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SslCertificateManagedSslCertificate_Status) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[154].Descriptor()
}

func (SslCertificateManagedSslCertificate_Status) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[154]
}

func (x SslCertificateManagedSslCertificate_Status) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SslCertificateManagedSslCertificate_Status.Descriptor instead.
func (SslCertificateManagedSslCertificate_Status) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{456, 0}
}

// (Optional) Specifies the type of SSL certificate, either "SELF_MANAGED" or "MANAGED". If not specified, the certificate is self-managed and the fields certificate and private_key are used.
type SslCertificate_Type int32

const (
	// A value indicating that the enum field is not set.
	SslCertificate_UNDEFINED_TYPE   SslCertificate_Type = 0
	SslCertificate_MANAGED          SslCertificate_Type = 479501183
	SslCertificate_SELF_MANAGED     SslCertificate_Type = 434437516
	SslCertificate_TYPE_UNSPECIFIED SslCertificate_Type = 437714322
)

// Enum value maps for SslCertificate_Type.
var (
	SslCertificate_Type_name = map[int32]string{
		0:         "UNDEFINED_TYPE",
		479501183: "MANAGED",
		434437516: "SELF_MANAGED",
		437714322: "TYPE_UNSPECIFIED",
	}
	SslCertificate_Type_value = map[string]int32{
		"UNDEFINED_TYPE":   0,
		"MANAGED":          479501183,
		"SELF_MANAGED":     434437516,
		"TYPE_UNSPECIFIED": 437714322,
	}
)

func (x SslCertificate_Type) Enum() *SslCertificate_Type {
	p := new(SslCertificate_Type)
	*p = x
	return p
}

func (x SslCertificate_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SslCertificate_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[155].Descriptor()
}

func (SslCertificate_Type) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[155]
}

func (x SslCertificate_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SslCertificate_Type.Descriptor instead.
func (SslCertificate_Type) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{458, 0}
}

// The minimum version of SSL protocol that can be used by the clients to establish a connection with the load balancer. This can be one of TLS_1_0, TLS_1_1, TLS_1_2.
type SslPolicy_MinTlsVersion int32

const (
	// A value indicating that the enum field is not set.
	SslPolicy_UNDEFINED_MIN_TLS_VERSION SslPolicy_MinTlsVersion = 0
	SslPolicy_TLS_1_0                   SslPolicy_MinTlsVersion = 33116734
	SslPolicy_TLS_1_1                   SslPolicy_MinTlsVersion = 33116735
	SslPolicy_TLS_1_2                   SslPolicy_MinTlsVersion = 33116736
)

// Enum value maps for SslPolicy_MinTlsVersion.
var (
	SslPolicy_MinTlsVersion_name = map[int32]string{
		0:        "UNDEFINED_MIN_TLS_VERSION",
		33116734: "TLS_1_0",
		33116735: "TLS_1_1",
		33116736: "TLS_1_2",
	}
	SslPolicy_MinTlsVersion_value = map[string]int32{
		"UNDEFINED_MIN_TLS_VERSION": 0,
		"TLS_1_0":                   33116734,
		"TLS_1_1":                   33116735,
		"TLS_1_2":                   33116736,
	}
)

func (x SslPolicy_MinTlsVersion) Enum() *SslPolicy_MinTlsVersion {
	p := new(SslPolicy_MinTlsVersion)
	*p = x
	return p
}

func (x SslPolicy_MinTlsVersion) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SslPolicy_MinTlsVersion) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[156].Descriptor()
}

func (SslPolicy_MinTlsVersion) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[156]
}

func (x SslPolicy_MinTlsVersion) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SslPolicy_MinTlsVersion.Descriptor instead.
func (SslPolicy_MinTlsVersion) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{462, 0}
}

// Profile specifies the set of SSL features that can be used by the load balancer when negotiating SSL with clients. This can be one of COMPATIBLE, MODERN, RESTRICTED, or CUSTOM. If using CUSTOM, the set of SSL features to enable must be specified in the customFeatures field.
type SslPolicy_Profile int32

const (
	// A value indicating that the enum field is not set.
	SslPolicy_UNDEFINED_PROFILE SslPolicy_Profile = 0
	SslPolicy_COMPATIBLE        SslPolicy_Profile = 179357396
	SslPolicy_CUSTOM            SslPolicy_Profile = 388595569
	SslPolicy_MODERN            SslPolicy_Profile = 132013855
	SslPolicy_RESTRICTED        SslPolicy_Profile = 261551195
)

// Enum value maps for SslPolicy_Profile.
var (
	SslPolicy_Profile_name = map[int32]string{
		0:         "UNDEFINED_PROFILE",
		179357396: "COMPATIBLE",
		388595569: "CUSTOM",
		132013855: "MODERN",
		261551195: "RESTRICTED",
	}
	SslPolicy_Profile_value = map[string]int32{
		"UNDEFINED_PROFILE": 0,
		"COMPATIBLE":        179357396,
		"CUSTOM":            388595569,
		"MODERN":            132013855,
		"RESTRICTED":        261551195,
	}
)

func (x SslPolicy_Profile) Enum() *SslPolicy_Profile {
	p := new(SslPolicy_Profile)
	*p = x
	return p
}

func (x SslPolicy_Profile) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SslPolicy_Profile) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[157].Descriptor()
}

func (SslPolicy_Profile) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[157]
}

func (x SslPolicy_Profile) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SslPolicy_Profile.Descriptor instead.
func (SslPolicy_Profile) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{462, 1}
}

// These stateful disks will never be deleted during autohealing, update or VM instance recreate operations. This flag is used to configure if the disk should be deleted after it is no longer used by the group, e.g. when the given instance or the whole group is deleted. Note: disks attached in READ_ONLY mode cannot be auto-deleted.
type StatefulPolicyPreservedStateDiskDevice_AutoDelete int32

const (
	// A value indicating that the enum field is not set.
	StatefulPolicyPreservedStateDiskDevice_UNDEFINED_AUTO_DELETE          StatefulPolicyPreservedStateDiskDevice_AutoDelete = 0
	StatefulPolicyPreservedStateDiskDevice_NEVER                          StatefulPolicyPreservedStateDiskDevice_AutoDelete = 74175084
	StatefulPolicyPreservedStateDiskDevice_ON_PERMANENT_INSTANCE_DELETION StatefulPolicyPreservedStateDiskDevice_AutoDelete = 95727719
)

// Enum value maps for StatefulPolicyPreservedStateDiskDevice_AutoDelete.
var (
	StatefulPolicyPreservedStateDiskDevice_AutoDelete_name = map[int32]string{
		0:        "UNDEFINED_AUTO_DELETE",
		74175084: "NEVER",
		95727719: "ON_PERMANENT_INSTANCE_DELETION",
	}
	StatefulPolicyPreservedStateDiskDevice_AutoDelete_value = map[string]int32{
		"UNDEFINED_AUTO_DELETE":          0,
		"NEVER":                          74175084,
		"ON_PERMANENT_INSTANCE_DELETION": 95727719,
	}
)

func (x StatefulPolicyPreservedStateDiskDevice_AutoDelete) Enum() *StatefulPolicyPreservedStateDiskDevice_AutoDelete {
	p := new(StatefulPolicyPreservedStateDiskDevice_AutoDelete)
	*p = x
	return p
}

func (x StatefulPolicyPreservedStateDiskDevice_AutoDelete) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (StatefulPolicyPreservedStateDiskDevice_AutoDelete) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[158].Descriptor()
}

func (StatefulPolicyPreservedStateDiskDevice_AutoDelete) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[158]
}

func (x StatefulPolicyPreservedStateDiskDevice_AutoDelete) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use StatefulPolicyPreservedStateDiskDevice_AutoDelete.Descriptor instead.
func (StatefulPolicyPreservedStateDiskDevice_AutoDelete) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{467, 0}
}

// Can only be specified if VPC flow logging for this subnetwork is enabled. Toggles the aggregation interval for collecting flow logs. Increasing the interval time will reduce the amount of generated flow logs for long lasting connections. Default is an interval of 5 seconds per connection.
type SubnetworkLogConfig_AggregationInterval int32

const (
	// A value indicating that the enum field is not set.
	SubnetworkLogConfig_UNDEFINED_AGGREGATION_INTERVAL SubnetworkLogConfig_AggregationInterval = 0
	SubnetworkLogConfig_INTERVAL_10_MIN                SubnetworkLogConfig_AggregationInterval = 487155916
	SubnetworkLogConfig_INTERVAL_15_MIN                SubnetworkLogConfig_AggregationInterval = 491773521
	SubnetworkLogConfig_INTERVAL_1_MIN                 SubnetworkLogConfig_AggregationInterval = 69052714
	SubnetworkLogConfig_INTERVAL_30_SEC                SubnetworkLogConfig_AggregationInterval = 7548937
	SubnetworkLogConfig_INTERVAL_5_MIN                 SubnetworkLogConfig_AggregationInterval = 72746798
	SubnetworkLogConfig_INTERVAL_5_SEC                 SubnetworkLogConfig_AggregationInterval = 72752429
)

// Enum value maps for SubnetworkLogConfig_AggregationInterval.
var (
	SubnetworkLogConfig_AggregationInterval_name = map[int32]string{
		0:         "UNDEFINED_AGGREGATION_INTERVAL",
		487155916: "INTERVAL_10_MIN",
		491773521: "INTERVAL_15_MIN",
		69052714:  "INTERVAL_1_MIN",
		7548937:   "INTERVAL_30_SEC",
		72746798:  "INTERVAL_5_MIN",
		72752429:  "INTERVAL_5_SEC",
	}
	SubnetworkLogConfig_AggregationInterval_value = map[string]int32{
		"UNDEFINED_AGGREGATION_INTERVAL": 0,
		"INTERVAL_10_MIN":                487155916,
		"INTERVAL_15_MIN":                491773521,
		"INTERVAL_1_MIN":                 69052714,
		"INTERVAL_30_SEC":                7548937,
		"INTERVAL_5_MIN":                 72746798,
		"INTERVAL_5_SEC":                 72752429,
	}
)

func (x SubnetworkLogConfig_AggregationInterval) Enum() *SubnetworkLogConfig_AggregationInterval {
	p := new(SubnetworkLogConfig_AggregationInterval)
	*p = x
	return p
}

func (x SubnetworkLogConfig_AggregationInterval) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SubnetworkLogConfig_AggregationInterval) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[159].Descriptor()
}

func (SubnetworkLogConfig_AggregationInterval) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[159]
}

func (x SubnetworkLogConfig_AggregationInterval) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SubnetworkLogConfig_AggregationInterval.Descriptor instead.
func (SubnetworkLogConfig_AggregationInterval) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{468, 0}
}

// Can only be specified if VPC flow logs for this subnetwork is enabled. Configures whether all, none or a subset of metadata fields should be added to the reported VPC flow logs. Default is EXCLUDE_ALL_METADATA.
type SubnetworkLogConfig_Metadata int32

const (
	// A value indicating that the enum field is not set.
	SubnetworkLogConfig_UNDEFINED_METADATA   SubnetworkLogConfig_Metadata = 0
	SubnetworkLogConfig_CUSTOM_METADATA      SubnetworkLogConfig_Metadata = 62450749
	SubnetworkLogConfig_EXCLUDE_ALL_METADATA SubnetworkLogConfig_Metadata = 334519954
	SubnetworkLogConfig_INCLUDE_ALL_METADATA SubnetworkLogConfig_Metadata = 164619908
)

// Enum value maps for SubnetworkLogConfig_Metadata.
var (
	SubnetworkLogConfig_Metadata_name = map[int32]string{
		0:         "UNDEFINED_METADATA",
		62450749:  "CUSTOM_METADATA",
		334519954: "EXCLUDE_ALL_METADATA",
		164619908: "INCLUDE_ALL_METADATA",
	}
	SubnetworkLogConfig_Metadata_value = map[string]int32{
		"UNDEFINED_METADATA":   0,
		"CUSTOM_METADATA":      62450749,
		"EXCLUDE_ALL_METADATA": 334519954,
		"INCLUDE_ALL_METADATA": 164619908,
	}
)

func (x SubnetworkLogConfig_Metadata) Enum() *SubnetworkLogConfig_Metadata {
	p := new(SubnetworkLogConfig_Metadata)
	*p = x
	return p
}

func (x SubnetworkLogConfig_Metadata) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SubnetworkLogConfig_Metadata) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[160].Descriptor()
}

func (SubnetworkLogConfig_Metadata) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[160]
}

func (x SubnetworkLogConfig_Metadata) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SubnetworkLogConfig_Metadata.Descriptor instead.
func (SubnetworkLogConfig_Metadata) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{468, 1}
}

// The private IPv6 google access type for the VMs in this subnet. This is an expanded field of enablePrivateV6Access. If both fields are set, privateIpv6GoogleAccess will take priority.
//
// This field can be both set at resource creation time and updated using patch.
type Subnetwork_PrivateIpv6GoogleAccess int32

const (
	// A value indicating that the enum field is not set.
	Subnetwork_UNDEFINED_PRIVATE_IPV6_GOOGLE_ACCESS  Subnetwork_PrivateIpv6GoogleAccess = 0
	Subnetwork_DISABLE_GOOGLE_ACCESS                 Subnetwork_PrivateIpv6GoogleAccess = 450958579
	Subnetwork_ENABLE_BIDIRECTIONAL_ACCESS_TO_GOOGLE Subnetwork_PrivateIpv6GoogleAccess = 427975994
	Subnetwork_ENABLE_OUTBOUND_VM_ACCESS_TO_GOOGLE   Subnetwork_PrivateIpv6GoogleAccess = 288210263
)

// Enum value maps for Subnetwork_PrivateIpv6GoogleAccess.
var (
	Subnetwork_PrivateIpv6GoogleAccess_name = map[int32]string{
		0:         "UNDEFINED_PRIVATE_IPV6_GOOGLE_ACCESS",
		450958579: "DISABLE_GOOGLE_ACCESS",
		427975994: "ENABLE_BIDIRECTIONAL_ACCESS_TO_GOOGLE",
		288210263: "ENABLE_OUTBOUND_VM_ACCESS_TO_GOOGLE",
	}
	Subnetwork_PrivateIpv6GoogleAccess_value = map[string]int32{
		"UNDEFINED_PRIVATE_IPV6_GOOGLE_ACCESS":  0,
		"DISABLE_GOOGLE_ACCESS":                 450958579,
		"ENABLE_BIDIRECTIONAL_ACCESS_TO_GOOGLE": 427975994,
		"ENABLE_OUTBOUND_VM_ACCESS_TO_GOOGLE":   288210263,
	}
)

func (x Subnetwork_PrivateIpv6GoogleAccess) Enum() *Subnetwork_PrivateIpv6GoogleAccess {
	p := new(Subnetwork_PrivateIpv6GoogleAccess)
	*p = x
	return p
}

func (x Subnetwork_PrivateIpv6GoogleAccess) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Subnetwork_PrivateIpv6GoogleAccess) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[161].Descriptor()
}

func (Subnetwork_PrivateIpv6GoogleAccess) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[161]
}

func (x Subnetwork_PrivateIpv6GoogleAccess) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Subnetwork_PrivateIpv6GoogleAccess.Descriptor instead.
func (Subnetwork_PrivateIpv6GoogleAccess) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{470, 0}
}

// The purpose of the resource. This field can be either PRIVATE_RFC_1918 or INTERNAL_HTTPS_LOAD_BALANCER. A subnetwork with purpose set to INTERNAL_HTTPS_LOAD_BALANCER is a user-created subnetwork that is reserved for Internal HTTP(S) Load Balancing. If unspecified, the purpose defaults to PRIVATE_RFC_1918. The enableFlowLogs field isn't supported with the purpose field set to INTERNAL_HTTPS_LOAD_BALANCER.
type Subnetwork_Purpose int32

const (
	// A value indicating that the enum field is not set.
	Subnetwork_UNDEFINED_PURPOSE            Subnetwork_Purpose = 0
	Subnetwork_INTERNAL_HTTPS_LOAD_BALANCER Subnetwork_Purpose = 248748889
	Subnetwork_PRIVATE                      Subnetwork_Purpose = 403485027
	Subnetwork_PRIVATE_RFC_1918             Subnetwork_Purpose = 254902107
)

// Enum value maps for Subnetwork_Purpose.
var (
	Subnetwork_Purpose_name = map[int32]string{
		0:         "UNDEFINED_PURPOSE",
		248748889: "INTERNAL_HTTPS_LOAD_BALANCER",
		403485027: "PRIVATE",
		254902107: "PRIVATE_RFC_1918",
	}
	Subnetwork_Purpose_value = map[string]int32{
		"UNDEFINED_PURPOSE":            0,
		"INTERNAL_HTTPS_LOAD_BALANCER": 248748889,
		"PRIVATE":                      403485027,
		"PRIVATE_RFC_1918":             254902107,
	}
)

func (x Subnetwork_Purpose) Enum() *Subnetwork_Purpose {
	p := new(Subnetwork_Purpose)
	*p = x
	return p
}

func (x Subnetwork_Purpose) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Subnetwork_Purpose) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[162].Descriptor()
}

func (Subnetwork_Purpose) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[162]
}

func (x Subnetwork_Purpose) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Subnetwork_Purpose.Descriptor instead.
func (Subnetwork_Purpose) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{470, 1}
}

// The role of subnetwork. Currently, this field is only used when purpose = INTERNAL_HTTPS_LOAD_BALANCER. The value can be set to ACTIVE or BACKUP. An ACTIVE subnetwork is one that is currently being used for Internal HTTP(S) Load Balancing. A BACKUP subnetwork is one that is ready to be promoted to ACTIVE or is currently draining. This field can be updated with a patch request.
type Subnetwork_Role int32

const (
	// A value indicating that the enum field is not set.
	Subnetwork_UNDEFINED_ROLE Subnetwork_Role = 0
	Subnetwork_ACTIVE         Subnetwork_Role = 314733318
	Subnetwork_BACKUP         Subnetwork_Role = 341010882
)

// Enum value maps for Subnetwork_Role.
var (
	Subnetwork_Role_name = map[int32]string{
		0:         "UNDEFINED_ROLE",
		314733318: "ACTIVE",
		341010882: "BACKUP",
	}
	Subnetwork_Role_value = map[string]int32{
		"UNDEFINED_ROLE": 0,
		"ACTIVE":         314733318,
		"BACKUP":         341010882,
	}
)

func (x Subnetwork_Role) Enum() *Subnetwork_Role {
	p := new(Subnetwork_Role)
	*p = x
	return p
}

func (x Subnetwork_Role) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Subnetwork_Role) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[163].Descriptor()
}

func (Subnetwork_Role) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[163]
}

func (x Subnetwork_Role) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Subnetwork_Role.Descriptor instead.
func (Subnetwork_Role) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{470, 2}
}

// [Output Only] The state of the subnetwork, which can be one of the following values: READY: Subnetwork is created and ready to use DRAINING: only applicable to subnetworks that have the purpose set to INTERNAL_HTTPS_LOAD_BALANCER and indicates that connections to the load balancer are being drained. A subnetwork that is draining cannot be used or modified until it reaches a status of READY
type Subnetwork_State int32

const (
	// A value indicating that the enum field is not set.
	Subnetwork_UNDEFINED_STATE Subnetwork_State = 0
	Subnetwork_DRAINING        Subnetwork_State = 480455402
	Subnetwork_READY           Subnetwork_State = 77848963
)

// Enum value maps for Subnetwork_State.
var (
	Subnetwork_State_name = map[int32]string{
		0:         "UNDEFINED_STATE",
		480455402: "DRAINING",
		77848963:  "READY",
	}
	Subnetwork_State_value = map[string]int32{
		"UNDEFINED_STATE": 0,
		"DRAINING":        480455402,
		"READY":           77848963,
	}
)

func (x Subnetwork_State) Enum() *Subnetwork_State {
	p := new(Subnetwork_State)
	*p = x
	return p
}

func (x Subnetwork_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Subnetwork_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[164].Descriptor()
}

func (Subnetwork_State) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[164]
}

func (x Subnetwork_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Subnetwork_State.Descriptor instead.
func (Subnetwork_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{470, 3}
}

// Specifies the QUIC override policy for this TargetHttpsProxy resource. This setting determines whether the load balancer attempts to negotiate QUIC with clients. You can specify NONE, ENABLE, or DISABLE.
// - When quic-override is set to NONE, Google manages whether QUIC is used.
// - When quic-override is set to ENABLE, the load balancer uses QUIC when possible.
// - When quic-override is set to DISABLE, the load balancer doesn't use QUIC.
// - If the quic-override flag is not specified, NONE is implied.
type TargetHttpsProxy_QuicOverride int32

const (
	// A value indicating that the enum field is not set.
	TargetHttpsProxy_UNDEFINED_QUIC_OVERRIDE TargetHttpsProxy_QuicOverride = 0
	TargetHttpsProxy_DISABLE                 TargetHttpsProxy_QuicOverride = 241807048
	TargetHttpsProxy_ENABLE                  TargetHttpsProxy_QuicOverride = 438835587
	TargetHttpsProxy_NONE                    TargetHttpsProxy_QuicOverride = 2402104
)

// Enum value maps for TargetHttpsProxy_QuicOverride.
var (
	TargetHttpsProxy_QuicOverride_name = map[int32]string{
		0:         "UNDEFINED_QUIC_OVERRIDE",
		241807048: "DISABLE",
		438835587: "ENABLE",
		2402104:   "NONE",
	}
	TargetHttpsProxy_QuicOverride_value = map[string]int32{
		"UNDEFINED_QUIC_OVERRIDE": 0,
		"DISABLE":                 241807048,
		"ENABLE":                  438835587,
		"NONE":                    2402104,
	}
)

func (x TargetHttpsProxy_QuicOverride) Enum() *TargetHttpsProxy_QuicOverride {
	p := new(TargetHttpsProxy_QuicOverride)
	*p = x
	return p
}

func (x TargetHttpsProxy_QuicOverride) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (TargetHttpsProxy_QuicOverride) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[165].Descriptor()
}

func (TargetHttpsProxy_QuicOverride) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[165]
}

func (x TargetHttpsProxy_QuicOverride) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use TargetHttpsProxy_QuicOverride.Descriptor instead.
func (TargetHttpsProxy_QuicOverride) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{482, 0}
}

// QUIC policy for the TargetHttpsProxy resource.
type TargetHttpsProxiesSetQuicOverrideRequest_QuicOverride int32

const (
	// A value indicating that the enum field is not set.
	TargetHttpsProxiesSetQuicOverrideRequest_UNDEFINED_QUIC_OVERRIDE TargetHttpsProxiesSetQuicOverrideRequest_QuicOverride = 0
	TargetHttpsProxiesSetQuicOverrideRequest_DISABLE                 TargetHttpsProxiesSetQuicOverrideRequest_QuicOverride = 241807048
	TargetHttpsProxiesSetQuicOverrideRequest_ENABLE                  TargetHttpsProxiesSetQuicOverrideRequest_QuicOverride = 438835587
	TargetHttpsProxiesSetQuicOverrideRequest_NONE                    TargetHttpsProxiesSetQuicOverrideRequest_QuicOverride = 2402104
)

// Enum value maps for TargetHttpsProxiesSetQuicOverrideRequest_QuicOverride.
var (
	TargetHttpsProxiesSetQuicOverrideRequest_QuicOverride_name = map[int32]string{
		0:         "UNDEFINED_QUIC_OVERRIDE",
		241807048: "DISABLE",
		438835587: "ENABLE",
		2402104:   "NONE",
	}
	TargetHttpsProxiesSetQuicOverrideRequest_QuicOverride_value = map[string]int32{
		"UNDEFINED_QUIC_OVERRIDE": 0,
		"DISABLE":                 241807048,
		"ENABLE":                  438835587,
		"NONE":                    2402104,
	}
)

func (x TargetHttpsProxiesSetQuicOverrideRequest_QuicOverride) Enum() *TargetHttpsProxiesSetQuicOverrideRequest_QuicOverride {
	p := new(TargetHttpsProxiesSetQuicOverrideRequest_QuicOverride)
	*p = x
	return p
}

func (x TargetHttpsProxiesSetQuicOverrideRequest_QuicOverride) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (TargetHttpsProxiesSetQuicOverrideRequest_QuicOverride) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[166].Descriptor()
}

func (TargetHttpsProxiesSetQuicOverrideRequest_QuicOverride) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[166]
}

func (x TargetHttpsProxiesSetQuicOverrideRequest_QuicOverride) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use TargetHttpsProxiesSetQuicOverrideRequest_QuicOverride.Descriptor instead.
func (TargetHttpsProxiesSetQuicOverrideRequest_QuicOverride) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{484, 0}
}

// NAT option controlling how IPs are NAT'ed to the instance. Currently only NO_NAT (default value) is supported.
type TargetInstance_NatPolicy int32

const (
	// A value indicating that the enum field is not set.
	TargetInstance_UNDEFINED_NAT_POLICY TargetInstance_NatPolicy = 0
	TargetInstance_NO_NAT               TargetInstance_NatPolicy = 161455491
)

// Enum value maps for TargetInstance_NatPolicy.
var (
	TargetInstance_NatPolicy_name = map[int32]string{
		0:         "UNDEFINED_NAT_POLICY",
		161455491: "NO_NAT",
	}
	TargetInstance_NatPolicy_value = map[string]int32{
		"UNDEFINED_NAT_POLICY": 0,
		"NO_NAT":               161455491,
	}
)

func (x TargetInstance_NatPolicy) Enum() *TargetInstance_NatPolicy {
	p := new(TargetInstance_NatPolicy)
	*p = x
	return p
}

func (x TargetInstance_NatPolicy) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (TargetInstance_NatPolicy) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[167].Descriptor()
}

func (TargetInstance_NatPolicy) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[167]
}

func (x TargetInstance_NatPolicy) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use TargetInstance_NatPolicy.Descriptor instead.
func (TargetInstance_NatPolicy) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{488, 0}
}

// Session affinity option, must be one of the following values:
// NONE: Connections from the same client IP may go to any instance in the pool.
// CLIENT_IP: Connections from the same client IP will go to the same instance in the pool while that instance remains healthy.
// CLIENT_IP_PROTO: Connections from the same client IP with the same IP protocol will go to the same instance in the pool while that instance remains healthy.
type TargetPool_SessionAffinity int32

const (
	// A value indicating that the enum field is not set.
	TargetPool_UNDEFINED_SESSION_AFFINITY TargetPool_SessionAffinity = 0
	TargetPool_CLIENT_IP                  TargetPool_SessionAffinity = 345665051
	TargetPool_CLIENT_IP_NO_DESTINATION   TargetPool_SessionAffinity = 106122516
	TargetPool_CLIENT_IP_PORT_PROTO       TargetPool_SessionAffinity = 221722926
	TargetPool_CLIENT_IP_PROTO            TargetPool_SessionAffinity = 25322148
	TargetPool_GENERATED_COOKIE           TargetPool_SessionAffinity = 370321204
	TargetPool_HEADER_FIELD               TargetPool_SessionAffinity = 200737960
	TargetPool_HTTP_COOKIE                TargetPool_SessionAffinity = 494981627
	TargetPool_NONE                       TargetPool_SessionAffinity = 2402104
)

// Enum value maps for TargetPool_SessionAffinity.
var (
	TargetPool_SessionAffinity_name = map[int32]string{
		0:         "UNDEFINED_SESSION_AFFINITY",
		345665051: "CLIENT_IP",
		106122516: "CLIENT_IP_NO_DESTINATION",
		221722926: "CLIENT_IP_PORT_PROTO",
		25322148:  "CLIENT_IP_PROTO",
		370321204: "GENERATED_COOKIE",
		200737960: "HEADER_FIELD",
		494981627: "HTTP_COOKIE",
		2402104:   "NONE",
	}
	TargetPool_SessionAffinity_value = map[string]int32{
		"UNDEFINED_SESSION_AFFINITY": 0,
		"CLIENT_IP":                  345665051,
		"CLIENT_IP_NO_DESTINATION":   106122516,
		"CLIENT_IP_PORT_PROTO":       221722926,
		"CLIENT_IP_PROTO":            25322148,
		"GENERATED_COOKIE":           370321204,
		"HEADER_FIELD":               200737960,
		"HTTP_COOKIE":                494981627,
		"NONE":                       2402104,
	}
)

func (x TargetPool_SessionAffinity) Enum() *TargetPool_SessionAffinity {
	p := new(TargetPool_SessionAffinity)
	*p = x
	return p
}

func (x TargetPool_SessionAffinity) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (TargetPool_SessionAffinity) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[168].Descriptor()
}

func (TargetPool_SessionAffinity) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[168]
}

func (x TargetPool_SessionAffinity) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use TargetPool_SessionAffinity.Descriptor instead.
func (TargetPool_SessionAffinity) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{492, 0}
}

// The new type of proxy header to append before sending data to the backend. NONE or PROXY_V1 are allowed.
type TargetSslProxiesSetProxyHeaderRequest_ProxyHeader int32

const (
	// A value indicating that the enum field is not set.
	TargetSslProxiesSetProxyHeaderRequest_UNDEFINED_PROXY_HEADER TargetSslProxiesSetProxyHeaderRequest_ProxyHeader = 0
	TargetSslProxiesSetProxyHeaderRequest_NONE                   TargetSslProxiesSetProxyHeaderRequest_ProxyHeader = 2402104
	TargetSslProxiesSetProxyHeaderRequest_PROXY_V1               TargetSslProxiesSetProxyHeaderRequest_ProxyHeader = 334352940
)

// Enum value maps for TargetSslProxiesSetProxyHeaderRequest_ProxyHeader.
var (
	TargetSslProxiesSetProxyHeaderRequest_ProxyHeader_name = map[int32]string{
		0:         "UNDEFINED_PROXY_HEADER",
		2402104:   "NONE",
		334352940: "PROXY_V1",
	}
	TargetSslProxiesSetProxyHeaderRequest_ProxyHeader_value = map[string]int32{
		"UNDEFINED_PROXY_HEADER": 0,
		"NONE":                   2402104,
		"PROXY_V1":               334352940,
	}
)

func (x TargetSslProxiesSetProxyHeaderRequest_ProxyHeader) Enum() *TargetSslProxiesSetProxyHeaderRequest_ProxyHeader {
	p := new(TargetSslProxiesSetProxyHeaderRequest_ProxyHeader)
	*p = x
	return p
}

func (x TargetSslProxiesSetProxyHeaderRequest_ProxyHeader) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (TargetSslProxiesSetProxyHeaderRequest_ProxyHeader) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[169].Descriptor()
}

func (TargetSslProxiesSetProxyHeaderRequest_ProxyHeader) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[169]
}

func (x TargetSslProxiesSetProxyHeaderRequest_ProxyHeader) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use TargetSslProxiesSetProxyHeaderRequest_ProxyHeader.Descriptor instead.
func (TargetSslProxiesSetProxyHeaderRequest_ProxyHeader) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{503, 0}
}

// Specifies the type of proxy header to append before sending data to the backend, either NONE or PROXY_V1. The default is NONE.
type TargetSslProxy_ProxyHeader int32

const (
	// A value indicating that the enum field is not set.
	TargetSslProxy_UNDEFINED_PROXY_HEADER TargetSslProxy_ProxyHeader = 0
	TargetSslProxy_NONE                   TargetSslProxy_ProxyHeader = 2402104
	TargetSslProxy_PROXY_V1               TargetSslProxy_ProxyHeader = 334352940
)

// Enum value maps for TargetSslProxy_ProxyHeader.
var (
	TargetSslProxy_ProxyHeader_name = map[int32]string{
		0:         "UNDEFINED_PROXY_HEADER",
		2402104:   "NONE",
		334352940: "PROXY_V1",
	}
	TargetSslProxy_ProxyHeader_value = map[string]int32{
		"UNDEFINED_PROXY_HEADER": 0,
		"NONE":                   2402104,
		"PROXY_V1":               334352940,
	}
)

func (x TargetSslProxy_ProxyHeader) Enum() *TargetSslProxy_ProxyHeader {
	p := new(TargetSslProxy_ProxyHeader)
	*p = x
	return p
}

func (x TargetSslProxy_ProxyHeader) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (TargetSslProxy_ProxyHeader) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[170].Descriptor()
}

func (TargetSslProxy_ProxyHeader) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[170]
}

func (x TargetSslProxy_ProxyHeader) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use TargetSslProxy_ProxyHeader.Descriptor instead.
func (TargetSslProxy_ProxyHeader) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{505, 0}
}

// The new type of proxy header to append before sending data to the backend. NONE or PROXY_V1 are allowed.
type TargetTcpProxiesSetProxyHeaderRequest_ProxyHeader int32

const (
	// A value indicating that the enum field is not set.
	TargetTcpProxiesSetProxyHeaderRequest_UNDEFINED_PROXY_HEADER TargetTcpProxiesSetProxyHeaderRequest_ProxyHeader = 0
	TargetTcpProxiesSetProxyHeaderRequest_NONE                   TargetTcpProxiesSetProxyHeaderRequest_ProxyHeader = 2402104
	TargetTcpProxiesSetProxyHeaderRequest_PROXY_V1               TargetTcpProxiesSetProxyHeaderRequest_ProxyHeader = 334352940
)

// Enum value maps for TargetTcpProxiesSetProxyHeaderRequest_ProxyHeader.
var (
	TargetTcpProxiesSetProxyHeaderRequest_ProxyHeader_name = map[int32]string{
		0:         "UNDEFINED_PROXY_HEADER",
		2402104:   "NONE",
		334352940: "PROXY_V1",
	}
	TargetTcpProxiesSetProxyHeaderRequest_ProxyHeader_value = map[string]int32{
		"UNDEFINED_PROXY_HEADER": 0,
		"NONE":                   2402104,
		"PROXY_V1":               334352940,
	}
)

func (x TargetTcpProxiesSetProxyHeaderRequest_ProxyHeader) Enum() *TargetTcpProxiesSetProxyHeaderRequest_ProxyHeader {
	p := new(TargetTcpProxiesSetProxyHeaderRequest_ProxyHeader)
	*p = x
	return p
}

func (x TargetTcpProxiesSetProxyHeaderRequest_ProxyHeader) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (TargetTcpProxiesSetProxyHeaderRequest_ProxyHeader) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[171].Descriptor()
}

func (TargetTcpProxiesSetProxyHeaderRequest_ProxyHeader) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[171]
}

func (x TargetTcpProxiesSetProxyHeaderRequest_ProxyHeader) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use TargetTcpProxiesSetProxyHeaderRequest_ProxyHeader.Descriptor instead.
func (TargetTcpProxiesSetProxyHeaderRequest_ProxyHeader) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{508, 0}
}

// Specifies the type of proxy header to append before sending data to the backend, either NONE or PROXY_V1. The default is NONE.
type TargetTcpProxy_ProxyHeader int32

const (
	// A value indicating that the enum field is not set.
	TargetTcpProxy_UNDEFINED_PROXY_HEADER TargetTcpProxy_ProxyHeader = 0
	TargetTcpProxy_NONE                   TargetTcpProxy_ProxyHeader = 2402104
	TargetTcpProxy_PROXY_V1               TargetTcpProxy_ProxyHeader = 334352940
)

// Enum value maps for TargetTcpProxy_ProxyHeader.
var (
	TargetTcpProxy_ProxyHeader_name = map[int32]string{
		0:         "UNDEFINED_PROXY_HEADER",
		2402104:   "NONE",
		334352940: "PROXY_V1",
	}
	TargetTcpProxy_ProxyHeader_value = map[string]int32{
		"UNDEFINED_PROXY_HEADER": 0,
		"NONE":                   2402104,
		"PROXY_V1":               334352940,
	}
)

func (x TargetTcpProxy_ProxyHeader) Enum() *TargetTcpProxy_ProxyHeader {
	p := new(TargetTcpProxy_ProxyHeader)
	*p = x
	return p
}

func (x TargetTcpProxy_ProxyHeader) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (TargetTcpProxy_ProxyHeader) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[172].Descriptor()
}

func (TargetTcpProxy_ProxyHeader) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[172]
}

func (x TargetTcpProxy_ProxyHeader) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use TargetTcpProxy_ProxyHeader.Descriptor instead.
func (TargetTcpProxy_ProxyHeader) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{509, 0}
}

// [Output Only] The status of the VPN gateway, which can be one of the following: CREATING, READY, FAILED, or DELETING.
type TargetVpnGateway_Status int32

const (
	// A value indicating that the enum field is not set.
	TargetVpnGateway_UNDEFINED_STATUS TargetVpnGateway_Status = 0
	TargetVpnGateway_CREATING         TargetVpnGateway_Status = 455564985
	TargetVpnGateway_DELETING         TargetVpnGateway_Status = 528602024
	TargetVpnGateway_FAILED           TargetVpnGateway_Status = 455706685
	TargetVpnGateway_READY            TargetVpnGateway_Status = 77848963
)

// Enum value maps for TargetVpnGateway_Status.
var (
	TargetVpnGateway_Status_name = map[int32]string{
		0:         "UNDEFINED_STATUS",
		455564985: "CREATING",
		528602024: "DELETING",
		455706685: "FAILED",
		77848963:  "READY",
	}
	TargetVpnGateway_Status_value = map[string]int32{
		"UNDEFINED_STATUS": 0,
		"CREATING":         455564985,
		"DELETING":         528602024,
		"FAILED":           455706685,
		"READY":            77848963,
	}
)

func (x TargetVpnGateway_Status) Enum() *TargetVpnGateway_Status {
	p := new(TargetVpnGateway_Status)
	*p = x
	return p
}

func (x TargetVpnGateway_Status) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (TargetVpnGateway_Status) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[173].Descriptor()
}

func (TargetVpnGateway_Status) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[173]
}

func (x TargetVpnGateway_Status) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use TargetVpnGateway_Status.Descriptor instead.
func (TargetVpnGateway_Status) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{511, 0}
}

// Indicates the high availability requirement state for the VPN connection. Valid values are CONNECTION_REDUNDANCY_MET, CONNECTION_REDUNDANCY_NOT_MET.
type VpnGatewayStatusHighAvailabilityRequirementState_State int32

const (
	// A value indicating that the enum field is not set.
	VpnGatewayStatusHighAvailabilityRequirementState_UNDEFINED_STATE               VpnGatewayStatusHighAvailabilityRequirementState_State = 0
	VpnGatewayStatusHighAvailabilityRequirementState_CONNECTION_REDUNDANCY_MET     VpnGatewayStatusHighAvailabilityRequirementState_State = 505242907
	VpnGatewayStatusHighAvailabilityRequirementState_CONNECTION_REDUNDANCY_NOT_MET VpnGatewayStatusHighAvailabilityRequirementState_State = 511863311
)

// Enum value maps for VpnGatewayStatusHighAvailabilityRequirementState_State.
var (
	VpnGatewayStatusHighAvailabilityRequirementState_State_name = map[int32]string{
		0:         "UNDEFINED_STATE",
		505242907: "CONNECTION_REDUNDANCY_MET",
		511863311: "CONNECTION_REDUNDANCY_NOT_MET",
	}
	VpnGatewayStatusHighAvailabilityRequirementState_State_value = map[string]int32{
		"UNDEFINED_STATE":               0,
		"CONNECTION_REDUNDANCY_MET":     505242907,
		"CONNECTION_REDUNDANCY_NOT_MET": 511863311,
	}
)

func (x VpnGatewayStatusHighAvailabilityRequirementState_State) Enum() *VpnGatewayStatusHighAvailabilityRequirementState_State {
	p := new(VpnGatewayStatusHighAvailabilityRequirementState_State)
	*p = x
	return p
}

func (x VpnGatewayStatusHighAvailabilityRequirementState_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (VpnGatewayStatusHighAvailabilityRequirementState_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[174].Descriptor()
}

func (VpnGatewayStatusHighAvailabilityRequirementState_State) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[174]
}

func (x VpnGatewayStatusHighAvailabilityRequirementState_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use VpnGatewayStatusHighAvailabilityRequirementState_State.Descriptor instead.
func (VpnGatewayStatusHighAvailabilityRequirementState_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{540, 0}
}

// Indicates the reason why the VPN connection does not meet the high availability redundancy criteria/requirement. Valid values is INCOMPLETE_TUNNELS_COVERAGE.
type VpnGatewayStatusHighAvailabilityRequirementState_UnsatisfiedReason int32

const (
	// A value indicating that the enum field is not set.
	VpnGatewayStatusHighAvailabilityRequirementState_UNDEFINED_UNSATISFIED_REASON VpnGatewayStatusHighAvailabilityRequirementState_UnsatisfiedReason = 0
	VpnGatewayStatusHighAvailabilityRequirementState_INCOMPLETE_TUNNELS_COVERAGE  VpnGatewayStatusHighAvailabilityRequirementState_UnsatisfiedReason = 55917437
)

// Enum value maps for VpnGatewayStatusHighAvailabilityRequirementState_UnsatisfiedReason.
var (
	VpnGatewayStatusHighAvailabilityRequirementState_UnsatisfiedReason_name = map[int32]string{
		0:        "UNDEFINED_UNSATISFIED_REASON",
		55917437: "INCOMPLETE_TUNNELS_COVERAGE",
	}
	VpnGatewayStatusHighAvailabilityRequirementState_UnsatisfiedReason_value = map[string]int32{
		"UNDEFINED_UNSATISFIED_REASON": 0,
		"INCOMPLETE_TUNNELS_COVERAGE":  55917437,
	}
)

func (x VpnGatewayStatusHighAvailabilityRequirementState_UnsatisfiedReason) Enum() *VpnGatewayStatusHighAvailabilityRequirementState_UnsatisfiedReason {
	p := new(VpnGatewayStatusHighAvailabilityRequirementState_UnsatisfiedReason)
	*p = x
	return p
}

func (x VpnGatewayStatusHighAvailabilityRequirementState_UnsatisfiedReason) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (VpnGatewayStatusHighAvailabilityRequirementState_UnsatisfiedReason) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[175].Descriptor()
}

func (VpnGatewayStatusHighAvailabilityRequirementState_UnsatisfiedReason) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[175]
}

func (x VpnGatewayStatusHighAvailabilityRequirementState_UnsatisfiedReason) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use VpnGatewayStatusHighAvailabilityRequirementState_UnsatisfiedReason.Descriptor instead.
func (VpnGatewayStatusHighAvailabilityRequirementState_UnsatisfiedReason) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{540, 1}
}

// [Output Only] The status of the VPN tunnel, which can be one of the following:
// - PROVISIONING: Resource is being allocated for the VPN tunnel.
// - WAITING_FOR_FULL_CONFIG: Waiting to receive all VPN-related configs from the user. Network, TargetVpnGateway, VpnTunnel, ForwardingRule, and Route resources are needed to setup the VPN tunnel.
// - FIRST_HANDSHAKE: Successful first handshake with the peer VPN.
// - ESTABLISHED: Secure session is successfully established with the peer VPN.
// - NETWORK_ERROR: Deprecated, replaced by NO_INCOMING_PACKETS
// - AUTHORIZATION_ERROR: Auth error (for example, bad shared secret).
// - NEGOTIATION_FAILURE: Handshake failed.
// - DEPROVISIONING: Resources are being deallocated for the VPN tunnel.
// - FAILED: Tunnel creation has failed and the tunnel is not ready to be used.
// - NO_INCOMING_PACKETS: No incoming packets from peer.
// - REJECTED: Tunnel configuration was rejected, can be result of being denied access.
// - ALLOCATING_RESOURCES: Cloud VPN is in the process of allocating all required resources.
// - STOPPED: Tunnel is stopped due to its Forwarding Rules being deleted for Classic VPN tunnels or the project is in frozen state.
// - PEER_IDENTITY_MISMATCH: Peer identity does not match peer IP, probably behind NAT.
// - TS_NARROWING_NOT_ALLOWED: Traffic selector narrowing not allowed for an HA-VPN tunnel.
type VpnTunnel_Status int32

const (
	// A value indicating that the enum field is not set.
	VpnTunnel_UNDEFINED_STATUS        VpnTunnel_Status = 0
	VpnTunnel_ALLOCATING_RESOURCES    VpnTunnel_Status = 320922816
	VpnTunnel_AUTHORIZATION_ERROR     VpnTunnel_Status = 23580290
	VpnTunnel_DEPROVISIONING          VpnTunnel_Status = 428935662
	VpnTunnel_ESTABLISHED             VpnTunnel_Status = 88852344
	VpnTunnel_FAILED                  VpnTunnel_Status = 455706685
	VpnTunnel_FIRST_HANDSHAKE         VpnTunnel_Status = 191393000
	VpnTunnel_NEGOTIATION_FAILURE     VpnTunnel_Status = 360325868
	VpnTunnel_NETWORK_ERROR           VpnTunnel_Status = 193912951
	VpnTunnel_NO_INCOMING_PACKETS     VpnTunnel_Status = 119983216
	VpnTunnel_PROVISIONING            VpnTunnel_Status = 290896621
	VpnTunnel_REJECTED                VpnTunnel_Status = 174130302
	VpnTunnel_STOPPED                 VpnTunnel_Status = 444276141
	VpnTunnel_WAITING_FOR_FULL_CONFIG VpnTunnel_Status = 41640522
)

// Enum value maps for VpnTunnel_Status.
var (
	VpnTunnel_Status_name = map[int32]string{
		0:         "UNDEFINED_STATUS",
		320922816: "ALLOCATING_RESOURCES",
		23580290:  "AUTHORIZATION_ERROR",
		428935662: "DEPROVISIONING",
		88852344:  "ESTABLISHED",
		455706685: "FAILED",
		191393000: "FIRST_HANDSHAKE",
		360325868: "NEGOTIATION_FAILURE",
		193912951: "NETWORK_ERROR",
		119983216: "NO_INCOMING_PACKETS",
		290896621: "PROVISIONING",
		174130302: "REJECTED",
		444276141: "STOPPED",
		41640522:  "WAITING_FOR_FULL_CONFIG",
	}
	VpnTunnel_Status_value = map[string]int32{
		"UNDEFINED_STATUS":        0,
		"ALLOCATING_RESOURCES":    320922816,
		"AUTHORIZATION_ERROR":     23580290,
		"DEPROVISIONING":          428935662,
		"ESTABLISHED":             88852344,
		"FAILED":                  455706685,
		"FIRST_HANDSHAKE":         191393000,
		"NEGOTIATION_FAILURE":     360325868,
		"NETWORK_ERROR":           193912951,
		"NO_INCOMING_PACKETS":     119983216,
		"PROVISIONING":            290896621,
		"REJECTED":                174130302,
		"STOPPED":                 444276141,
		"WAITING_FOR_FULL_CONFIG": 41640522,
	}
)

func (x VpnTunnel_Status) Enum() *VpnTunnel_Status {
	p := new(VpnTunnel_Status)
	*p = x
	return p
}

func (x VpnTunnel_Status) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (VpnTunnel_Status) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[176].Descriptor()
}

func (VpnTunnel_Status) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[176]
}

func (x VpnTunnel_Status) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use VpnTunnel_Status.Descriptor instead.
func (VpnTunnel_Status) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{543, 0}
}

// [Output Only] Status of the zone, either UP or DOWN.
type Zone_Status int32

const (
	// A value indicating that the enum field is not set.
	Zone_UNDEFINED_STATUS Zone_Status = 0
	Zone_DOWN             Zone_Status = 2104482
	Zone_UP               Zone_Status = 2715
)

// Enum value maps for Zone_Status.
var (
	Zone_Status_name = map[int32]string{
		0:       "UNDEFINED_STATUS",
		2104482: "DOWN",
		2715:    "UP",
	}
	Zone_Status_value = map[string]int32{
		"UNDEFINED_STATUS": 0,
		"DOWN":             2104482,
		"UP":               2715,
	}
)

func (x Zone_Status) Enum() *Zone_Status {
	p := new(Zone_Status)
	*p = x
	return p
}

func (x Zone_Status) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Zone_Status) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[177].Descriptor()
}

func (Zone_Status) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[177]
}

func (x Zone_Status) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Zone_Status.Descriptor instead.
func (Zone_Status) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{549, 0}
}

// The direction of the exchanged routes.
type ListPeeringRoutesNetworksRequest_Direction int32

const (
	// A value indicating that the enum field is not set.
	ListPeeringRoutesNetworksRequest_UNDEFINED_DIRECTION ListPeeringRoutesNetworksRequest_Direction = 0
	ListPeeringRoutesNetworksRequest_INCOMING            ListPeeringRoutesNetworksRequest_Direction = 338552870
	ListPeeringRoutesNetworksRequest_OUTGOING            ListPeeringRoutesNetworksRequest_Direction = 307438444
)

// Enum value maps for ListPeeringRoutesNetworksRequest_Direction.
var (
	ListPeeringRoutesNetworksRequest_Direction_name = map[int32]string{
		0:         "UNDEFINED_DIRECTION",
		338552870: "INCOMING",
		307438444: "OUTGOING",
	}
	ListPeeringRoutesNetworksRequest_Direction_value = map[string]int32{
		"UNDEFINED_DIRECTION": 0,
		"INCOMING":            338552870,
		"OUTGOING":            307438444,
	}
)

func (x ListPeeringRoutesNetworksRequest_Direction) Enum() *ListPeeringRoutesNetworksRequest_Direction {
	p := new(ListPeeringRoutesNetworksRequest_Direction)
	*p = x
	return p
}

func (x ListPeeringRoutesNetworksRequest_Direction) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ListPeeringRoutesNetworksRequest_Direction) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_compute_v1_compute_proto_enumTypes[178].Descriptor()
}

func (ListPeeringRoutesNetworksRequest_Direction) Type() protoreflect.EnumType {
	return &file_google_cloud_compute_v1_compute_proto_enumTypes[178]
}

func (x ListPeeringRoutesNetworksRequest_Direction) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ListPeeringRoutesNetworksRequest_Direction.Descriptor instead.
func (ListPeeringRoutesNetworksRequest_Direction) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{811, 0}
}

//
// Messages
//
// A specification of the type and number of accelerator cards attached to the instance.
type AcceleratorConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The number of the guest accelerator cards exposed to this instance.
	AcceleratorCount *int32 `protobuf:"varint,504879675,opt,name=accelerator_count,json=acceleratorCount,proto3,oneof" json:"accelerator_count,omitempty"`
	// Full or partial URL of the accelerator type resource to attach to this instance. For example: projects/my-project/zones/us-central1-c/acceleratorTypes/nvidia-tesla-p100 If you are creating an instance template, specify only the accelerator name. See GPUs on Compute Engine for a full list of accelerator types.
	AcceleratorType *string `protobuf:"bytes,138031246,opt,name=accelerator_type,json=acceleratorType,proto3,oneof" json:"accelerator_type,omitempty"`
}

func (x *AcceleratorConfig) Reset() {
	*x = AcceleratorConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AcceleratorConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AcceleratorConfig) ProtoMessage() {}

func (x *AcceleratorConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AcceleratorConfig.ProtoReflect.Descriptor instead.
func (*AcceleratorConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{0}
}

func (x *AcceleratorConfig) GetAcceleratorCount() int32 {
	if x != nil && x.AcceleratorCount != nil {
		return *x.AcceleratorCount
	}
	return 0
}

func (x *AcceleratorConfig) GetAcceleratorType() string {
	if x != nil && x.AcceleratorType != nil {
		return *x.AcceleratorType
	}
	return ""
}

// Deprecation status for a public resource.
type DeprecationStatus struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// An optional RFC3339 timestamp on or after which the state of this resource is intended to change to DELETED. This is only informational and the status will not change unless the client explicitly changes it.
	Deleted *string `protobuf:"bytes,476721177,opt,name=deleted,proto3,oneof" json:"deleted,omitempty"`
	// An optional RFC3339 timestamp on or after which the state of this resource is intended to change to DEPRECATED. This is only informational and the status will not change unless the client explicitly changes it.
	Deprecated *string `protobuf:"bytes,515138995,opt,name=deprecated,proto3,oneof" json:"deprecated,omitempty"`
	// An optional RFC3339 timestamp on or after which the state of this resource is intended to change to OBSOLETE. This is only informational and the status will not change unless the client explicitly changes it.
	Obsolete *string `protobuf:"bytes,357647769,opt,name=obsolete,proto3,oneof" json:"obsolete,omitempty"`
	// The URL of the suggested replacement for a deprecated resource. The suggested replacement resource must be the same kind of resource as the deprecated resource.
	Replacement *string `protobuf:"bytes,430919186,opt,name=replacement,proto3,oneof" json:"replacement,omitempty"`
	// The deprecation state of this resource. This can be ACTIVE, DEPRECATED, OBSOLETE, or DELETED. Operations which communicate the end of life date for an image, can use ACTIVE. Operations which create a new resource using a DEPRECATED resource will return successfully, but with a warning indicating the deprecated resource and recommending its replacement. Operations which use OBSOLETE or DELETED resources will be rejected and result in an error.
	State *DeprecationStatus_State `protobuf:"varint,109757585,opt,name=state,proto3,enum=google.cloud.compute.v1.DeprecationStatus_State,oneof" json:"state,omitempty"`
}

func (x *DeprecationStatus) Reset() {
	*x = DeprecationStatus{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeprecationStatus) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeprecationStatus) ProtoMessage() {}

func (x *DeprecationStatus) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeprecationStatus.ProtoReflect.Descriptor instead.
func (*DeprecationStatus) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{1}
}

func (x *DeprecationStatus) GetDeleted() string {
	if x != nil && x.Deleted != nil {
		return *x.Deleted
	}
	return ""
}

func (x *DeprecationStatus) GetDeprecated() string {
	if x != nil && x.Deprecated != nil {
		return *x.Deprecated
	}
	return ""
}

func (x *DeprecationStatus) GetObsolete() string {
	if x != nil && x.Obsolete != nil {
		return *x.Obsolete
	}
	return ""
}

func (x *DeprecationStatus) GetReplacement() string {
	if x != nil && x.Replacement != nil {
		return *x.Replacement
	}
	return ""
}

func (x *DeprecationStatus) GetState() DeprecationStatus_State {
	if x != nil && x.State != nil {
		return *x.State
	}
	return DeprecationStatus_UNDEFINED_STATE
}

// Represents an Accelerator Type resource.
//
// Google Cloud Platform provides graphics processing units (accelerators) that you can add to VM instances to improve or accelerate performance when working with intensive workloads. For more information, read GPUs on Compute Engine. (== resource_for {$api_version}.acceleratorTypes ==)
type AcceleratorType struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// [Output Only] Creation timestamp in RFC3339 text format.
	CreationTimestamp *string `protobuf:"bytes,30525366,opt,name=creation_timestamp,json=creationTimestamp,proto3,oneof" json:"creation_timestamp,omitempty"`
	// [Output Only] The deprecation status associated with this accelerator type.
	Deprecated *DeprecationStatus `protobuf:"bytes,515138995,opt,name=deprecated,proto3,oneof" json:"deprecated,omitempty"`
	// [Output Only] An optional textual description of the resource.
	Description *string `protobuf:"bytes,422937596,opt,name=description,proto3,oneof" json:"description,omitempty"`
	// [Output Only] The unique identifier for the resource. This identifier is defined by the server.
	Id *uint64 `protobuf:"varint,3355,opt,name=id,proto3,oneof" json:"id,omitempty"`
	// [Output Only] The type of the resource. Always compute#acceleratorType for accelerator types.
	Kind *string `protobuf:"bytes,3292052,opt,name=kind,proto3,oneof" json:"kind,omitempty"`
	// [Output Only] Maximum number of accelerator cards allowed per instance.
	MaximumCardsPerInstance *int32 `protobuf:"varint,263814482,opt,name=maximum_cards_per_instance,json=maximumCardsPerInstance,proto3,oneof" json:"maximum_cards_per_instance,omitempty"`
	// [Output Only] Name of the resource.
	Name *string `protobuf:"bytes,3373707,opt,name=name,proto3,oneof" json:"name,omitempty"`
	// [Output Only] Server-defined, fully qualified URL for this resource.
	SelfLink *string `protobuf:"bytes,456214797,opt,name=self_link,json=selfLink,proto3,oneof" json:"self_link,omitempty"`
	// [Output Only] The name of the zone where the accelerator type resides, such as us-central1-a. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
	Zone *string `protobuf:"bytes,3744684,opt,name=zone,proto3,oneof" json:"zone,omitempty"`
}

func (x *AcceleratorType) Reset() {
	*x = AcceleratorType{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AcceleratorType) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AcceleratorType) ProtoMessage() {}

func (x *AcceleratorType) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AcceleratorType.ProtoReflect.Descriptor instead.
func (*AcceleratorType) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{2}
}

func (x *AcceleratorType) GetCreationTimestamp() string {
	if x != nil && x.CreationTimestamp != nil {
		return *x.CreationTimestamp
	}
	return ""
}

func (x *AcceleratorType) GetDeprecated() *DeprecationStatus {
	if x != nil {
		return x.Deprecated
	}
	return nil
}

func (x *AcceleratorType) GetDescription() string {
	if x != nil && x.Description != nil {
		return *x.Description
	}
	return ""
}

func (x *AcceleratorType) GetId() uint64 {
	if x != nil && x.Id != nil {
		return *x.Id
	}
	return 0
}

func (x *AcceleratorType) GetKind() string {
	if x != nil && x.Kind != nil {
		return *x.Kind
	}
	return ""
}

func (x *AcceleratorType) GetMaximumCardsPerInstance() int32 {
	if x != nil && x.MaximumCardsPerInstance != nil {
		return *x.MaximumCardsPerInstance
	}
	return 0
}

func (x *AcceleratorType) GetName() string {
	if x != nil && x.Name != nil {
		return *x.Name
	}
	return ""
}

func (x *AcceleratorType) GetSelfLink() string {
	if x != nil && x.SelfLink != nil {
		return *x.SelfLink
	}
	return ""
}

func (x *AcceleratorType) GetZone() string {
	if x != nil && x.Zone != nil {
		return *x.Zone
	}
	return ""
}

//
type AcceleratorTypesScopedList struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// [Output Only] A list of accelerator types contained in this scope.
	AcceleratorTypes []*AcceleratorType `protobuf:"bytes,520872357,rep,name=accelerator_types,json=acceleratorTypes,proto3" json:"accelerator_types,omitempty"`
	// [Output Only] An informational warning that appears when the accelerator types list is empty.
	Warning *Warning `protobuf:"bytes,50704284,opt,name=warning,proto3,oneof" json:"warning,omitempty"`
}

func (x *AcceleratorTypesScopedList) Reset() {
	*x = AcceleratorTypesScopedList{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AcceleratorTypesScopedList) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AcceleratorTypesScopedList) ProtoMessage() {}

func (x *AcceleratorTypesScopedList) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AcceleratorTypesScopedList.ProtoReflect.Descriptor instead.
func (*AcceleratorTypesScopedList) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{3}
}

func (x *AcceleratorTypesScopedList) GetAcceleratorTypes() []*AcceleratorType {
	if x != nil {
		return x.AcceleratorTypes
	}
	return nil
}

func (x *AcceleratorTypesScopedList) GetWarning() *Warning {
	if x != nil {
		return x.Warning
	}
	return nil
}

//
type Data struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// [Output Only] A key that provides more detail on the warning being returned. For example, for warnings where there are no results in a list request for a particular zone, this key might be scope and the key value might be the zone name. Other examples might be a key indicating a deprecated resource and a suggested replacement, or a warning about invalid network settings (for example, if an instance attempts to perform IP forwarding but is not enabled for IP forwarding).
	Key *string `protobuf:"bytes,106079,opt,name=key,proto3,oneof" json:"key,omitempty"`
	// [Output Only] A warning data value corresponding to the key.
	Value *string `protobuf:"bytes,111972721,opt,name=value,proto3,oneof" json:"value,omitempty"`
}

func (x *Data) Reset() {
	*x = Data{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Data) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Data) ProtoMessage() {}

func (x *Data) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Data.ProtoReflect.Descriptor instead.
func (*Data) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{4}
}

func (x *Data) GetKey() string {
	if x != nil && x.Key != nil {
		return *x.Key
	}
	return ""
}

func (x *Data) GetValue() string {
	if x != nil && x.Value != nil {
		return *x.Value
	}
	return ""
}

// [Output Only] Informational warning message.
type Warning struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// [Output Only] A warning code, if applicable. For example, Compute Engine returns NO_RESULTS_ON_PAGE if there are no results in the response.
	Code *Warning_Code `protobuf:"varint,3059181,opt,name=code,proto3,enum=google.cloud.compute.v1.Warning_Code,oneof" json:"code,omitempty"`
	// [Output Only] Metadata about this warning in key: value format. For example:
	// "data": [ { "key": "scope", "value": "zones/us-east1-d" }
	Data []*Data `protobuf:"bytes,3076010,rep,name=data,proto3" json:"data,omitempty"`
	// [Output Only] A human-readable description of the warning code.
	Message *string `protobuf:"bytes,418054151,opt,name=message,proto3,oneof" json:"message,omitempty"`
}

func (x *Warning) Reset() {
	*x = Warning{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Warning) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Warning) ProtoMessage() {}

func (x *Warning) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Warning.ProtoReflect.Descriptor instead.
func (*Warning) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{5}
}

func (x *Warning) GetCode() Warning_Code {
	if x != nil && x.Code != nil {
		return *x.Code
	}
	return Warning_UNDEFINED_CODE
}

func (x *Warning) GetData() []*Data {
	if x != nil {
		return x.Data
	}
	return nil
}

func (x *Warning) GetMessage() string {
	if x != nil && x.Message != nil {
		return *x.Message
	}
	return ""
}

//
type AcceleratorTypeAggregatedList struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// [Output Only] Unique identifier for the resource; defined by the server.
	Id *string `protobuf:"bytes,3355,opt,name=id,proto3,oneof" json:"id,omitempty"`
	// A list of AcceleratorTypesScopedList resources.
	Items map[string]*AcceleratorTypesScopedList `protobuf:"bytes,100526016,rep,name=items,proto3" json:"items,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// [Output Only] Type of resource. Always compute#acceleratorTypeAggregatedList for aggregated lists of accelerator types.
	Kind *string `protobuf:"bytes,3292052,opt,name=kind,proto3,oneof" json:"kind,omitempty"`
	// [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
	NextPageToken *string `protobuf:"bytes,79797525,opt,name=next_page_token,json=nextPageToken,proto3,oneof" json:"next_page_token,omitempty"`
	// [Output Only] Server-defined URL for this resource.
	SelfLink *string `protobuf:"bytes,456214797,opt,name=self_link,json=selfLink,proto3,oneof" json:"self_link,omitempty"`
	// [Output Only] Unreachable resources.
	Unreachables []string `protobuf:"bytes,243372063,rep,name=unreachables,proto3" json:"unreachables,omitempty"`
	// [Output Only] Informational warning message.
	Warning *Warning `protobuf:"bytes,50704284,opt,name=warning,proto3,oneof" json:"warning,omitempty"`
}

func (x *AcceleratorTypeAggregatedList) Reset() {
	*x = AcceleratorTypeAggregatedList{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AcceleratorTypeAggregatedList) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AcceleratorTypeAggregatedList) ProtoMessage() {}

func (x *AcceleratorTypeAggregatedList) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AcceleratorTypeAggregatedList.ProtoReflect.Descriptor instead.
func (*AcceleratorTypeAggregatedList) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{6}
}

func (x *AcceleratorTypeAggregatedList) GetId() string {
	if x != nil && x.Id != nil {
		return *x.Id
	}
	return ""
}

func (x *AcceleratorTypeAggregatedList) GetItems() map[string]*AcceleratorTypesScopedList {
	if x != nil {
		return x.Items
	}
	return nil
}

func (x *AcceleratorTypeAggregatedList) GetKind() string {
	if x != nil && x.Kind != nil {
		return *x.Kind
	}
	return ""
}

func (x *AcceleratorTypeAggregatedList) GetNextPageToken() string {
	if x != nil && x.NextPageToken != nil {
		return *x.NextPageToken
	}
	return ""
}

func (x *AcceleratorTypeAggregatedList) GetSelfLink() string {
	if x != nil && x.SelfLink != nil {
		return *x.SelfLink
	}
	return ""
}

func (x *AcceleratorTypeAggregatedList) GetUnreachables() []string {
	if x != nil {
		return x.Unreachables
	}
	return nil
}

func (x *AcceleratorTypeAggregatedList) GetWarning() *Warning {
	if x != nil {
		return x.Warning
	}
	return nil
}

// Contains a list of accelerator types.
type AcceleratorTypeList struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// [Output Only] Unique identifier for the resource; defined by the server.
	Id *string `protobuf:"bytes,3355,opt,name=id,proto3,oneof" json:"id,omitempty"`
	// A list of AcceleratorType resources.
	Items []*AcceleratorType `protobuf:"bytes,100526016,rep,name=items,proto3" json:"items,omitempty"`
	// [Output Only] Type of resource. Always compute#acceleratorTypeList for lists of accelerator types.
	Kind *string `protobuf:"bytes,3292052,opt,name=kind,proto3,oneof" json:"kind,omitempty"`
	// [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
	NextPageToken *string `protobuf:"bytes,79797525,opt,name=next_page_token,json=nextPageToken,proto3,oneof" json:"next_page_token,omitempty"`
	// [Output Only] Server-defined URL for this resource.
	SelfLink *string `protobuf:"bytes,456214797,opt,name=self_link,json=selfLink,proto3,oneof" json:"self_link,omitempty"`
	// [Output Only] Informational warning message.
	Warning *Warning `protobuf:"bytes,50704284,opt,name=warning,proto3,oneof" json:"warning,omitempty"`
}

func (x *AcceleratorTypeList) Reset() {
	*x = AcceleratorTypeList{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AcceleratorTypeList) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AcceleratorTypeList) ProtoMessage() {}

func (x *AcceleratorTypeList) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AcceleratorTypeList.ProtoReflect.Descriptor instead.
func (*AcceleratorTypeList) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{7}
}

func (x *AcceleratorTypeList) GetId() string {
	if x != nil && x.Id != nil {
		return *x.Id
	}
	return ""
}

func (x *AcceleratorTypeList) GetItems() []*AcceleratorType {
	if x != nil {
		return x.Items
	}
	return nil
}

func (x *AcceleratorTypeList) GetKind() string {
	if x != nil && x.Kind != nil {
		return *x.Kind
	}
	return ""
}

func (x *AcceleratorTypeList) GetNextPageToken() string {
	if x != nil && x.NextPageToken != nil {
		return *x.NextPageToken
	}
	return ""
}

func (x *AcceleratorTypeList) GetSelfLink() string {
	if x != nil && x.SelfLink != nil {
		return *x.SelfLink
	}
	return ""
}

func (x *AcceleratorTypeList) GetWarning() *Warning {
	if x != nil {
		return x.Warning
	}
	return nil
}

// An access configuration attached to an instance's network interface. Only one access config per instance is supported.
type AccessConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// [Output Only] Type of the resource. Always compute#accessConfig for access configs.
	Kind *string `protobuf:"bytes,3292052,opt,name=kind,proto3,oneof" json:"kind,omitempty"`
	// The name of this access configuration. The default and recommended name is External NAT, but you can use any arbitrary string, such as My external IP or Network Access.
	Name *string `protobuf:"bytes,3373707,opt,name=name,proto3,oneof" json:"name,omitempty"`
	// An external IP address associated with this instance. Specify an unused static external IP address available to the project or leave this field undefined to use an IP from a shared ephemeral IP address pool. If you specify a static external IP address, it must live in the same region as the zone of the instance.
	NatIP *string `protobuf:"bytes,117634556,opt,name=nat_i_p,json=natIP,proto3,oneof" json:"nat_i_p,omitempty"`
	// This signifies the networking tier used for configuring this access configuration and can only take the following values: PREMIUM, STANDARD.
	//
	// If an AccessConfig is specified without a valid external IP address, an ephemeral IP will be created with this networkTier.
	//
	// If an AccessConfig with a valid external IP address is specified, it must match that of the networkTier associated with the Address resource owning that IP.
	NetworkTier *AccessConfig_NetworkTier `protobuf:"varint,517397843,opt,name=network_tier,json=networkTier,proto3,enum=google.cloud.compute.v1.AccessConfig_NetworkTier,oneof" json:"network_tier,omitempty"`
	// The DNS domain name for the public PTR record. You can set this field only if the `setPublicPtr` field is enabled.
	PublicPtrDomainName *string `protobuf:"bytes,316599167,opt,name=public_ptr_domain_name,json=publicPtrDomainName,proto3,oneof" json:"public_ptr_domain_name,omitempty"`
	// Specifies whether a public DNS 'PTR' record should be created to map the external IP address of the instance to a DNS domain name.
	SetPublicPtr *bool `protobuf:"varint,523870229,opt,name=set_public_ptr,json=setPublicPtr,proto3,oneof" json:"set_public_ptr,omitempty"`
	// The type of configuration. The default and only option is ONE_TO_ONE_NAT.
	Type *AccessConfig_Type `protobuf:"varint,3575610,opt,name=type,proto3,enum=google.cloud.compute.v1.AccessConfig_Type,oneof" json:"type,omitempty"`
}

func (x *AccessConfig) Reset() {
	*x = AccessConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AccessConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AccessConfig) ProtoMessage() {}

func (x *AccessConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AccessConfig.ProtoReflect.Descriptor instead.
func (*AccessConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{8}
}

func (x *AccessConfig) GetKind() string {
	if x != nil && x.Kind != nil {
		return *x.Kind
	}
	return ""
}

func (x *AccessConfig) GetName() string {
	if x != nil && x.Name != nil {
		return *x.Name
	}
	return ""
}

func (x *AccessConfig) GetNatIP() string {
	if x != nil && x.NatIP != nil {
		return *x.NatIP
	}
	return ""
}

func (x *AccessConfig) GetNetworkTier() AccessConfig_NetworkTier {
	if x != nil && x.NetworkTier != nil {
		return *x.NetworkTier
	}
	return AccessConfig_UNDEFINED_NETWORK_TIER
}

func (x *AccessConfig) GetPublicPtrDomainName() string {
	if x != nil && x.PublicPtrDomainName != nil {
		return *x.PublicPtrDomainName
	}
	return ""
}

func (x *AccessConfig) GetSetPublicPtr() bool {
	if x != nil && x.SetPublicPtr != nil {
		return *x.SetPublicPtr
	}
	return false
}

func (x *AccessConfig) GetType() AccessConfig_Type {
	if x != nil && x.Type != nil {
		return *x.Type
	}
	return AccessConfig_UNDEFINED_TYPE
}

// Use global external addresses for GFE-based external HTTP(S) load balancers in Premium Tier.
//
// Use global internal addresses for reserved peering network range.
//
// Use regional external addresses for the following resources:
//
// - External IP addresses for VM instances - Regional external forwarding rules - Cloud NAT external IP addresses - GFE based LBs in Standard Tier - Network LBs in Premium or Standard Tier - Cloud VPN gateways (both Classic and HA)
//
// Use regional internal IP addresses for subnet IP ranges (primary and secondary). This includes:
//
// - Internal IP addresses for VM instances - Alias IP ranges of VM instances (/32 only) - Regional internal forwarding rules - Internal TCP/UDP load balancer addresses - Internal HTTP(S) load balancer addresses - Cloud DNS inbound forwarding IP addresses
//
// For more information, read reserved IP address.
//
// (== resource_for {$api_version}.addresses ==) (== resource_for {$api_version}.globalAddresses ==)
type Address struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The static IP address represented by this resource.
	Address *string `protobuf:"bytes,462920692,opt,name=address,proto3,oneof" json:"address,omitempty"`
	// The type of address to reserve, either INTERNAL or EXTERNAL. If unspecified, defaults to EXTERNAL.
	AddressType *Address_AddressType `protobuf:"varint,264307877,opt,name=address_type,json=addressType,proto3,enum=google.cloud.compute.v1.Address_AddressType,oneof" json:"address_type,omitempty"`
	// [Output Only] Creation timestamp in RFC3339 text format.
	CreationTimestamp *string `protobuf:"bytes,30525366,opt,name=creation_timestamp,json=creationTimestamp,proto3,oneof" json:"creation_timestamp,omitempty"`
	// An optional description of this resource. Provide this field when you create the resource.
	Description *string `protobuf:"bytes,422937596,opt,name=description,proto3,oneof" json:"description,omitempty"`
	// [Output Only] The unique identifier for the resource. This identifier is defined by the server.
	Id *uint64 `protobuf:"varint,3355,opt,name=id,proto3,oneof" json:"id,omitempty"`
	// The IP version that will be used by this address. Valid options are IPV4 or IPV6. This can only be specified for a global address.
	IpVersion *Address_IpVersion `protobuf:"varint,294959552,opt,name=ip_version,json=ipVersion,proto3,enum=google.cloud.compute.v1.Address_IpVersion,oneof" json:"ip_version,omitempty"`
	// [Output Only] Type of the resource. Always compute#address for addresses.
	Kind *string `protobuf:"bytes,3292052,opt,name=kind,proto3,oneof" json:"kind,omitempty"`
	// Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?`. The first character must be a lowercase letter, and all following characters (except for the last character) must be a dash, lowercase letter, or digit. The last character must be a lowercase letter or digit.
	Name *string `protobuf:"bytes,3373707,opt,name=name,proto3,oneof" json:"name,omitempty"`
	// The URL of the network in which to reserve the address. This field can only be used with INTERNAL type with the VPC_PEERING purpose.
	Network *string `protobuf:"bytes,232872494,opt,name=network,proto3,oneof" json:"network,omitempty"`
	// This signifies the networking tier used for configuring this address and can only take the following values: PREMIUM or STANDARD. Global forwarding rules can only be Premium Tier. Regional forwarding rules can be either Premium or Standard Tier. Standard Tier addresses applied to regional forwarding rules can be used with any external load balancer. Regional forwarding rules in Premium Tier can only be used with a network load balancer.
	//
	// If this field is not specified, it is assumed to be PREMIUM.
	NetworkTier *Address_NetworkTier `protobuf:"varint,517397843,opt,name=network_tier,json=networkTier,proto3,enum=google.cloud.compute.v1.Address_NetworkTier,oneof" json:"network_tier,omitempty"`
	// The prefix length if the resource represents an IP range.
	PrefixLength *int32 `protobuf:"varint,453565747,opt,name=prefix_length,json=prefixLength,proto3,oneof" json:"prefix_length,omitempty"`
	// The purpose of this resource, which can be one of the following values:
	// - `GCE_ENDPOINT` for addresses that are used by VM instances, alias IP ranges, internal load balancers, and similar resources.
	// - `DNS_RESOLVER` for a DNS resolver address in a subnetwork
	// - `VPC_PEERING` for addresses that are reserved for VPC peer networks.
	// - `NAT_AUTO` for addresses that are external IP addresses automatically reserved for Cloud NAT.
	// - `IPSEC_INTERCONNECT` for addresses created from a private IP range that are reserved for a VLAN attachment in an IPsec-encrypted Cloud Interconnect configuration. These addresses are regional resources.
	Purpose *Address_Purpose `protobuf:"varint,316407070,opt,name=purpose,proto3,enum=google.cloud.compute.v1.Address_Purpose,oneof" json:"purpose,omitempty"`
	// [Output Only] The URL of the region where a regional address resides. For regional addresses, you must specify the region as a path parameter in the HTTP request URL. This field is not applicable to global addresses.
	Region *string `protobuf:"bytes,138946292,opt,name=region,proto3,oneof" json:"region,omitempty"`
	// [Output Only] Server-defined URL for the resource.
	SelfLink *string `protobuf:"bytes,456214797,opt,name=self_link,json=selfLink,proto3,oneof" json:"self_link,omitempty"`
	// [Output Only] The status of the address, which can be one of RESERVING, RESERVED, or IN_USE. An address that is RESERVING is currently in the process of being reserved. A RESERVED address is currently reserved and available to use. An IN_USE address is currently being used by another resource and is not available.
	Status *Address_Status `protobuf:"varint,181260274,opt,name=status,proto3,enum=google.cloud.compute.v1.Address_Status,oneof" json:"status,omitempty"`
	// The URL of the subnetwork in which to reserve the address. If an IP address is specified, it must be within the subnetwork's IP range. This field can only be used with INTERNAL type with a GCE_ENDPOINT or DNS_RESOLVER purpose.
	Subnetwork *string `protobuf:"bytes,307827694,opt,name=subnetwork,proto3,oneof" json:"subnetwork,omitempty"`
	// [Output Only] The URLs of the resources that are using this address.
	Users []string `protobuf:"bytes,111578632,rep,name=users,proto3" json:"users,omitempty"`
}

func (x *Address) Reset() {
	*x = Address{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Address) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Address) ProtoMessage() {}

func (x *Address) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Address.ProtoReflect.Descriptor instead.
func (*Address) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{9}
}

func (x *Address) GetAddress() string {
	if x != nil && x.Address != nil {
		return *x.Address
	}
	return ""
}

func (x *Address) GetAddressType() Address_AddressType {
	if x != nil && x.AddressType != nil {
		return *x.AddressType
	}
	return Address_UNDEFINED_ADDRESS_TYPE
}

func (x *Address) GetCreationTimestamp() string {
	if x != nil && x.CreationTimestamp != nil {
		return *x.CreationTimestamp
	}
	return ""
}

func (x *Address) GetDescription() string {
	if x != nil && x.Description != nil {
		return *x.Description
	}
	return ""
}

func (x *Address) GetId() uint64 {
	if x != nil && x.Id != nil {
		return *x.Id
	}
	return 0
}

func (x *Address) GetIpVersion() Address_IpVersion {
	if x != nil && x.IpVersion != nil {
		return *x.IpVersion
	}
	return Address_UNDEFINED_IP_VERSION
}

func (x *Address) GetKind() string {
	if x != nil && x.Kind != nil {
		return *x.Kind
	}
	return ""
}

func (x *Address) GetName() string {
	if x != nil && x.Name != nil {
		return *x.Name
	}
	return ""
}

func (x *Address) GetNetwork() string {
	if x != nil && x.Network != nil {
		return *x.Network
	}
	return ""
}

func (x *Address) GetNetworkTier() Address_NetworkTier {
	if x != nil && x.NetworkTier != nil {
		return *x.NetworkTier
	}
	return Address_UNDEFINED_NETWORK_TIER
}

func (x *Address) GetPrefixLength() int32 {
	if x != nil && x.PrefixLength != nil {
		return *x.PrefixLength
	}
	return 0
}

func (x *Address) GetPurpose() Address_Purpose {
	if x != nil && x.Purpose != nil {
		return *x.Purpose
	}
	return Address_UNDEFINED_PURPOSE
}

func (x *Address) GetRegion() string {
	if x != nil && x.Region != nil {
		return *x.Region
	}
	return ""
}

func (x *Address) GetSelfLink() string {
	if x != nil && x.SelfLink != nil {
		return *x.SelfLink
	}
	return ""
}

func (x *Address) GetStatus() Address_Status {
	if x != nil && x.Status != nil {
		return *x.Status
	}
	return Address_UNDEFINED_STATUS
}

func (x *Address) GetSubnetwork() string {
	if x != nil && x.Subnetwork != nil {
		return *x.Subnetwork
	}
	return ""
}

func (x *Address) GetUsers() []string {
	if x != nil {
		return x.Users
	}
	return nil
}

//
type AddressesScopedList struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// [Output Only] A list of addresses contained in this scope.
	Addresses []*Address `protobuf:"bytes,337673122,rep,name=addresses,proto3" json:"addresses,omitempty"`
	// [Output Only] Informational warning which replaces the list of addresses when the list is empty.
	Warning *Warning `protobuf:"bytes,50704284,opt,name=warning,proto3,oneof" json:"warning,omitempty"`
}

func (x *AddressesScopedList) Reset() {
	*x = AddressesScopedList{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AddressesScopedList) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AddressesScopedList) ProtoMessage() {}

func (x *AddressesScopedList) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AddressesScopedList.ProtoReflect.Descriptor instead.
func (*AddressesScopedList) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{10}
}

func (x *AddressesScopedList) GetAddresses() []*Address {
	if x != nil {
		return x.Addresses
	}
	return nil
}

func (x *AddressesScopedList) GetWarning() *Warning {
	if x != nil {
		return x.Warning
	}
	return nil
}

//
type AddressAggregatedList struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// [Output Only] Unique identifier for the resource; defined by the server.
	Id *string `protobuf:"bytes,3355,opt,name=id,proto3,oneof" json:"id,omitempty"`
	// A list of AddressesScopedList resources.
	Items map[string]*AddressesScopedList `protobuf:"bytes,100526016,rep,name=items,proto3" json:"items,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// [Output Only] Type of resource. Always compute#addressAggregatedList for aggregated lists of addresses.
	Kind *string `protobuf:"bytes,3292052,opt,name=kind,proto3,oneof" json:"kind,omitempty"`
	// [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
	NextPageToken *string `protobuf:"bytes,79797525,opt,name=next_page_token,json=nextPageToken,proto3,oneof" json:"next_page_token,omitempty"`
	// [Output Only] Server-defined URL for this resource.
	SelfLink *string `protobuf:"bytes,456214797,opt,name=self_link,json=selfLink,proto3,oneof" json:"self_link,omitempty"`
	// [Output Only] Unreachable resources.
	Unreachables []string `protobuf:"bytes,243372063,rep,name=unreachables,proto3" json:"unreachables,omitempty"`
	// [Output Only] Informational warning message.
	Warning *Warning `protobuf:"bytes,50704284,opt,name=warning,proto3,oneof" json:"warning,omitempty"`
}

func (x *AddressAggregatedList) Reset() {
	*x = AddressAggregatedList{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AddressAggregatedList) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AddressAggregatedList) ProtoMessage() {}

func (x *AddressAggregatedList) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AddressAggregatedList.ProtoReflect.Descriptor instead.
func (*AddressAggregatedList) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{11}
}

func (x *AddressAggregatedList) GetId() string {
	if x != nil && x.Id != nil {
		return *x.Id
	}
	return ""
}

func (x *AddressAggregatedList) GetItems() map[string]*AddressesScopedList {
	if x != nil {
		return x.Items
	}
	return nil
}

func (x *AddressAggregatedList) GetKind() string {
	if x != nil && x.Kind != nil {
		return *x.Kind
	}
	return ""
}

func (x *AddressAggregatedList) GetNextPageToken() string {
	if x != nil && x.NextPageToken != nil {
		return *x.NextPageToken
	}
	return ""
}

func (x *AddressAggregatedList) GetSelfLink() string {
	if x != nil && x.SelfLink != nil {
		return *x.SelfLink
	}
	return ""
}

func (x *AddressAggregatedList) GetUnreachables() []string {
	if x != nil {
		return x.Unreachables
	}
	return nil
}

func (x *AddressAggregatedList) GetWarning() *Warning {
	if x != nil {
		return x.Warning
	}
	return nil
}

// Contains a list of addresses.
type AddressList struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// [Output Only] Unique identifier for the resource; defined by the server.
	Id *string `protobuf:"bytes,3355,opt,name=id,proto3,oneof" json:"id,omitempty"`
	// A list of Address resources.
	Items []*Address `protobuf:"bytes,100526016,rep,name=items,proto3" json:"items,omitempty"`
	// [Output Only] Type of resource. Always compute#addressList for lists of addresses.
	Kind *string `protobuf:"bytes,3292052,opt,name=kind,proto3,oneof" json:"kind,omitempty"`
	// [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
	NextPageToken *string `protobuf:"bytes,79797525,opt,name=next_page_token,json=nextPageToken,proto3,oneof" json:"next_page_token,omitempty"`
	// [Output Only] Server-defined URL for this resource.
	SelfLink *string `protobuf:"bytes,456214797,opt,name=self_link,json=selfLink,proto3,oneof" json:"self_link,omitempty"`
	// [Output Only] Informational warning message.
	Warning *Warning `protobuf:"bytes,50704284,opt,name=warning,proto3,oneof" json:"warning,omitempty"`
}

func (x *AddressList) Reset() {
	*x = AddressList{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AddressList) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AddressList) ProtoMessage() {}

func (x *AddressList) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AddressList.ProtoReflect.Descriptor instead.
func (*AddressList) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{12}
}

func (x *AddressList) GetId() string {
	if x != nil && x.Id != nil {
		return *x.Id
	}
	return ""
}

func (x *AddressList) GetItems() []*Address {
	if x != nil {
		return x.Items
	}
	return nil
}

func (x *AddressList) GetKind() string {
	if x != nil && x.Kind != nil {
		return *x.Kind
	}
	return ""
}

func (x *AddressList) GetNextPageToken() string {
	if x != nil && x.NextPageToken != nil {
		return *x.NextPageToken
	}
	return ""
}

func (x *AddressList) GetSelfLink() string {
	if x != nil && x.SelfLink != nil {
		return *x.SelfLink
	}
	return ""
}

func (x *AddressList) GetWarning() *Warning {
	if x != nil {
		return x.Warning
	}
	return nil
}

// Specifies options for controlling advanced machine features. Options that would traditionally be configured in a BIOS belong here. Features that require operating system support may have corresponding entries in the GuestOsFeatures of an Image (e.g., whether or not the OS in the Image supports nested virtualization being enabled or disabled).
type AdvancedMachineFeatures struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Whether to enable nested virtualization or not (default is false).
	EnableNestedVirtualization *bool `protobuf:"varint,16639365,opt,name=enable_nested_virtualization,json=enableNestedVirtualization,proto3,oneof" json:"enable_nested_virtualization,omitempty"`
	// The number of threads per physical core. To disable simultaneous multithreading (SMT) set this to 1. If unset, the maximum number of threads supported per core by the underlying processor is assumed.
	ThreadsPerCore *int32 `protobuf:"varint,352611671,opt,name=threads_per_core,json=threadsPerCore,proto3,oneof" json:"threads_per_core,omitempty"`
}

func (x *AdvancedMachineFeatures) Reset() {
	*x = AdvancedMachineFeatures{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AdvancedMachineFeatures) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AdvancedMachineFeatures) ProtoMessage() {}

func (x *AdvancedMachineFeatures) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AdvancedMachineFeatures.ProtoReflect.Descriptor instead.
func (*AdvancedMachineFeatures) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{13}
}

func (x *AdvancedMachineFeatures) GetEnableNestedVirtualization() bool {
	if x != nil && x.EnableNestedVirtualization != nil {
		return *x.EnableNestedVirtualization
	}
	return false
}

func (x *AdvancedMachineFeatures) GetThreadsPerCore() int32 {
	if x != nil && x.ThreadsPerCore != nil {
		return *x.ThreadsPerCore
	}
	return 0
}

// An alias IP range attached to an instance's network interface.
type AliasIpRange struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The IP alias ranges to allocate for this interface. This IP CIDR range must belong to the specified subnetwork and cannot contain IP addresses reserved by system or used by other network interfaces. This range may be a single IP address (such as 10.2.3.4), a netmask (such as /24) or a CIDR-formatted string (such as 10.1.2.0/24).
	IpCidrRange *string `protobuf:"bytes,98117322,opt,name=ip_cidr_range,json=ipCidrRange,proto3,oneof" json:"ip_cidr_range,omitempty"`
	// The name of a subnetwork secondary IP range from which to allocate an IP alias range. If not specified, the primary range of the subnetwork is used.
	SubnetworkRangeName *string `protobuf:"bytes,387995966,opt,name=subnetwork_range_name,json=subnetworkRangeName,proto3,oneof" json:"subnetwork_range_name,omitempty"`
}

func (x *AliasIpRange) Reset() {
	*x = AliasIpRange{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AliasIpRange) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AliasIpRange) ProtoMessage() {}

func (x *AliasIpRange) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AliasIpRange.ProtoReflect.Descriptor instead.
func (*AliasIpRange) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{14}
}

func (x *AliasIpRange) GetIpCidrRange() string {
	if x != nil && x.IpCidrRange != nil {
		return *x.IpCidrRange
	}
	return ""
}

func (x *AliasIpRange) GetSubnetworkRangeName() string {
	if x != nil && x.SubnetworkRangeName != nil {
		return *x.SubnetworkRangeName
	}
	return ""
}

//
type AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Specifies the size of the disk in base-2 GB.
	DiskSizeGb *int64 `protobuf:"varint,316263735,opt,name=disk_size_gb,json=diskSizeGb,proto3,oneof" json:"disk_size_gb,omitempty"`
	// Specifies the disk interface to use for attaching this disk, which is either SCSI or NVME. The default is SCSI. For performance characteristics of SCSI over NVMe, see Local SSD performance.
	Interface *AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk_Interface `protobuf:"varint,502623545,opt,name=interface,proto3,enum=google.cloud.compute.v1.AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk_Interface,oneof" json:"interface,omitempty"`
}

func (x *AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk) Reset() {
	*x = AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk) ProtoMessage() {}

func (x *AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk.ProtoReflect.Descriptor instead.
func (*AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{15}
}

func (x *AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk) GetDiskSizeGb() int64 {
	if x != nil && x.DiskSizeGb != nil {
		return *x.DiskSizeGb
	}
	return 0
}

func (x *AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk) GetInterface() AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk_Interface {
	if x != nil && x.Interface != nil {
		return *x.Interface
	}
	return AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk_UNDEFINED_INTERFACE
}

// Properties of the SKU instances being reserved. Next ID: 9
type AllocationSpecificSKUAllocationReservedInstanceProperties struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Specifies accelerator type and count.
	GuestAccelerators []*AcceleratorConfig `protobuf:"bytes,463595119,rep,name=guest_accelerators,json=guestAccelerators,proto3" json:"guest_accelerators,omitempty"`
	// Specifies amount of local ssd to reserve with each instance. The type of disk is local-ssd.
	LocalSsds []*AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk `protobuf:"bytes,229951299,rep,name=local_ssds,json=localSsds,proto3" json:"local_ssds,omitempty"`
	// An opaque location hint used to place the allocation close to other resources. This field is for use by internal tools that use the public API.
	LocationHint *string `protobuf:"bytes,350519505,opt,name=location_hint,json=locationHint,proto3,oneof" json:"location_hint,omitempty"`
	// Specifies type of machine (name only) which has fixed number of vCPUs and fixed amount of memory. This also includes specifying custom machine type following custom-NUMBER_OF_CPUS-AMOUNT_OF_MEMORY pattern.
	MachineType *string `protobuf:"bytes,227711026,opt,name=machine_type,json=machineType,proto3,oneof" json:"machine_type,omitempty"`
	// Minimum cpu platform the reservation.
	MinCpuPlatform *string `protobuf:"bytes,242912759,opt,name=min_cpu_platform,json=minCpuPlatform,proto3,oneof" json:"min_cpu_platform,omitempty"`
}

func (x *AllocationSpecificSKUAllocationReservedInstanceProperties) Reset() {
	*x = AllocationSpecificSKUAllocationReservedInstanceProperties{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AllocationSpecificSKUAllocationReservedInstanceProperties) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AllocationSpecificSKUAllocationReservedInstanceProperties) ProtoMessage() {}

func (x *AllocationSpecificSKUAllocationReservedInstanceProperties) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AllocationSpecificSKUAllocationReservedInstanceProperties.ProtoReflect.Descriptor instead.
func (*AllocationSpecificSKUAllocationReservedInstanceProperties) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{16}
}

func (x *AllocationSpecificSKUAllocationReservedInstanceProperties) GetGuestAccelerators() []*AcceleratorConfig {
	if x != nil {
		return x.GuestAccelerators
	}
	return nil
}

func (x *AllocationSpecificSKUAllocationReservedInstanceProperties) GetLocalSsds() []*AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk {
	if x != nil {
		return x.LocalSsds
	}
	return nil
}

func (x *AllocationSpecificSKUAllocationReservedInstanceProperties) GetLocationHint() string {
	if x != nil && x.LocationHint != nil {
		return *x.LocationHint
	}
	return ""
}

func (x *AllocationSpecificSKUAllocationReservedInstanceProperties) GetMachineType() string {
	if x != nil && x.MachineType != nil {
		return *x.MachineType
	}
	return ""
}

func (x *AllocationSpecificSKUAllocationReservedInstanceProperties) GetMinCpuPlatform() string {
	if x != nil && x.MinCpuPlatform != nil {
		return *x.MinCpuPlatform
	}
	return ""
}

// This reservation type allows to pre allocate specific instance configuration.
type AllocationSpecificSKUReservation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Specifies the number of resources that are allocated.
	Count *int64 `protobuf:"varint,94851343,opt,name=count,proto3,oneof" json:"count,omitempty"`
	// [Output Only] Indicates how many instances are in use.
	InUseCount *int64 `protobuf:"varint,493458877,opt,name=in_use_count,json=inUseCount,proto3,oneof" json:"in_use_count,omitempty"`
	// The instance properties for the reservation.
	InstanceProperties *AllocationSpecificSKUAllocationReservedInstanceProperties `protobuf:"bytes,215355165,opt,name=instance_properties,json=instanceProperties,proto3,oneof" json:"instance_properties,omitempty"`
}

func (x *AllocationSpecificSKUReservation) Reset() {
	*x = AllocationSpecificSKUReservation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AllocationSpecificSKUReservation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AllocationSpecificSKUReservation) ProtoMessage() {}

func (x *AllocationSpecificSKUReservation) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AllocationSpecificSKUReservation.ProtoReflect.Descriptor instead.
func (*AllocationSpecificSKUReservation) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{17}
}

func (x *AllocationSpecificSKUReservation) GetCount() int64 {
	if x != nil && x.Count != nil {
		return *x.Count
	}
	return 0
}

func (x *AllocationSpecificSKUReservation) GetInUseCount() int64 {
	if x != nil && x.InUseCount != nil {
		return *x.InUseCount
	}
	return 0
}

func (x *AllocationSpecificSKUReservation) GetInstanceProperties() *AllocationSpecificSKUAllocationReservedInstanceProperties {
	if x != nil {
		return x.InstanceProperties
	}
	return nil
}

//
type CustomerEncryptionKey struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the encryption key that is stored in Google Cloud KMS.
	KmsKeyName *string `protobuf:"bytes,484373913,opt,name=kms_key_name,json=kmsKeyName,proto3,oneof" json:"kms_key_name,omitempty"`
	// The service account being used for the encryption request for the given KMS key. If absent, the Compute Engine default service account is used.
	KmsKeyServiceAccount *string `protobuf:"bytes,209986261,opt,name=kms_key_service_account,json=kmsKeyServiceAccount,proto3,oneof" json:"kms_key_service_account,omitempty"`
	// Specifies a 256-bit customer-supplied encryption key, encoded in RFC 4648 base64 to either encrypt or decrypt this resource.
	RawKey *string `protobuf:"bytes,449196488,opt,name=raw_key,json=rawKey,proto3,oneof" json:"raw_key,omitempty"`
	// [Output only] The RFC 4648 base64 encoded SHA-256 hash of the customer-supplied encryption key that protects this resource.
	Sha256 *string `protobuf:"bytes,170112551,opt,name=sha256,proto3,oneof" json:"sha256,omitempty"`
}

func (x *CustomerEncryptionKey) Reset() {
	*x = CustomerEncryptionKey{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CustomerEncryptionKey) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CustomerEncryptionKey) ProtoMessage() {}

func (x *CustomerEncryptionKey) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CustomerEncryptionKey.ProtoReflect.Descriptor instead.
func (*CustomerEncryptionKey) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{18}
}

func (x *CustomerEncryptionKey) GetKmsKeyName() string {
	if x != nil && x.KmsKeyName != nil {
		return *x.KmsKeyName
	}
	return ""
}

func (x *CustomerEncryptionKey) GetKmsKeyServiceAccount() string {
	if x != nil && x.KmsKeyServiceAccount != nil {
		return *x.KmsKeyServiceAccount
	}
	return ""
}

func (x *CustomerEncryptionKey) GetRawKey() string {
	if x != nil && x.RawKey != nil {
		return *x.RawKey
	}
	return ""
}

func (x *CustomerEncryptionKey) GetSha256() string {
	if x != nil && x.Sha256 != nil {
		return *x.Sha256
	}
	return ""
}

// Guest OS features.
type GuestOsFeature struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The ID of a supported feature. Read  Enabling guest operating system features to see a list of available options.
	Type *GuestOsFeature_Type `protobuf:"varint,3575610,opt,name=type,proto3,enum=google.cloud.compute.v1.GuestOsFeature_Type,oneof" json:"type,omitempty"`
}

func (x *GuestOsFeature) Reset() {
	*x = GuestOsFeature{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GuestOsFeature) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GuestOsFeature) ProtoMessage() {}

func (x *GuestOsFeature) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GuestOsFeature.ProtoReflect.Descriptor instead.
func (*GuestOsFeature) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{19}
}

func (x *GuestOsFeature) GetType() GuestOsFeature_Type {
	if x != nil && x.Type != nil {
		return *x.Type
	}
	return GuestOsFeature_UNDEFINED_TYPE
}

// [Input Only] Specifies the parameters for a new disk that will be created alongside the new instance. Use initialization parameters to create boot disks or local SSDs attached to the new instance.
//
// This property is mutually exclusive with the source property; you can only define one or the other, but not both.
type AttachedDiskInitializeParams struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// An optional description. Provide this property when creating the disk.
	Description *string `protobuf:"bytes,422937596,opt,name=description,proto3,oneof" json:"description,omitempty"`
	// Specifies the disk name. If not specified, the default is to use the name of the instance. If a disk with the same name already exists in the given region, the existing disk is attached to the new instance and the new disk is not created.
	DiskName *string `protobuf:"bytes,92807149,opt,name=disk_name,json=diskName,proto3,oneof" json:"disk_name,omitempty"`
	// Specifies the size of the disk in base-2 GB. The size must be at least 10 GB. If you specify a sourceImage, which is required for boot disks, the default size is the size of the sourceImage. If you do not specify a sourceImage, the default disk size is 500 GB.
	DiskSizeGb *int64 `protobuf:"varint,316263735,opt,name=disk_size_gb,json=diskSizeGb,proto3,oneof" json:"disk_size_gb,omitempty"`
	// Specifies the disk type to use to create the instance. If not specified, the default is pd-standard, specified using the full URL. For example:
	// https://www.googleapis.com/compute/v1/projects/project/zones/zone/diskTypes/pd-standard
	//
	//
	// Other values include pd-ssd and local-ssd. If you define this field, you can provide either the full or partial URL. For example, the following are valid values:
	// - https://www.googleapis.com/compute/v1/projects/project/zones/zone/diskTypes/diskType
	// - projects/project/zones/zone/diskTypes/diskType
	// - zones/zone/diskTypes/diskType  Note that for InstanceTemplate, this is the name of the disk type, not URL.
	DiskType *string `protobuf:"bytes,93009052,opt,name=disk_type,json=diskType,proto3,oneof" json:"disk_type,omitempty"`
	// Labels to apply to this disk. These can be later modified by the disks.setLabels method. This field is only applicable for persistent disks.
	Labels map[string]string `protobuf:"bytes,500195327,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Specifies which action to take on instance update with this disk. Default is to use the existing disk.
	OnUpdateAction *AttachedDiskInitializeParams_OnUpdateAction `protobuf:"varint,202451980,opt,name=on_update_action,json=onUpdateAction,proto3,enum=google.cloud.compute.v1.AttachedDiskInitializeParams_OnUpdateAction,oneof" json:"on_update_action,omitempty"`
	// Indicates how many IOPS must be provisioned for the disk.
	ProvisionedIops *int64 `protobuf:"varint,186769108,opt,name=provisioned_iops,json=provisionedIops,proto3,oneof" json:"provisioned_iops,omitempty"`
	// Resource policies applied to this disk for automatic snapshot creations. Specified using the full or partial URL. For instance template, specify only the resource policy name.
	ResourcePolicies []string `protobuf:"bytes,22220385,rep,name=resource_policies,json=resourcePolicies,proto3" json:"resource_policies,omitempty"`
	// The source image to create this disk. When creating a new instance, one of initializeParams.sourceImage or initializeParams.sourceSnapshot or disks.source is required except for local SSD.
	//
	// To create a disk with one of the public operating system images, specify the image by its family name. For example, specify family/debian-9 to use the latest Debian 9 image:
	// projects/debian-cloud/global/images/family/debian-9
	//
	//
	// Alternatively, use a specific version of a public operating system image:
	// projects/debian-cloud/global/images/debian-9-stretch-vYYYYMMDD
	//
	//
	// To create a disk with a custom image that you created, specify the image name in the following format:
	// global/images/my-custom-image
	//
	//
	// You can also specify a custom image by its image family, which returns the latest version of the image in that family. Replace the image name with family/family-name:
	// global/images/family/my-image-family
	//
	//
	// If the source image is deleted later, this field will not be set.
	SourceImage *string `protobuf:"bytes,50443319,opt,name=source_image,json=sourceImage,proto3,oneof" json:"source_image,omitempty"`
	// The customer-supplied encryption key of the source image. Required if the source image is protected by a customer-supplied encryption key.
	//
	// Instance templates do not store customer-supplied encryption keys, so you cannot create disks for instances in a managed instance group if the source images are encrypted with your own keys.
	SourceImageEncryptionKey *CustomerEncryptionKey `protobuf:"bytes,381503659,opt,name=source_image_encryption_key,json=sourceImageEncryptionKey,proto3,oneof" json:"source_image_encryption_key,omitempty"`
	// The source snapshot to create this disk. When creating a new instance, one of initializeParams.sourceSnapshot or initializeParams.sourceImage or disks.source is required except for local SSD.
	//
	// To create a disk with a snapshot that you created, specify the snapshot name in the following format:
	// global/snapshots/my-backup
	//
	//
	// If the source snapshot is deleted later, this field will not be set.
	SourceSnapshot *string `protobuf:"bytes,126061928,opt,name=source_snapshot,json=sourceSnapshot,proto3,oneof" json:"source_snapshot,omitempty"`
	// The customer-supplied encryption key of the source snapshot.
	SourceSnapshotEncryptionKey *CustomerEncryptionKey `protobuf:"bytes,303679322,opt,name=source_snapshot_encryption_key,json=sourceSnapshotEncryptionKey,proto3,oneof" json:"source_snapshot_encryption_key,omitempty"`
}

func (x *AttachedDiskInitializeParams) Reset() {
	*x = AttachedDiskInitializeParams{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AttachedDiskInitializeParams) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AttachedDiskInitializeParams) ProtoMessage() {}

func (x *AttachedDiskInitializeParams) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AttachedDiskInitializeParams.ProtoReflect.Descriptor instead.
func (*AttachedDiskInitializeParams) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{20}
}

func (x *AttachedDiskInitializeParams) GetDescription() string {
	if x != nil && x.Description != nil {
		return *x.Description
	}
	return ""
}

func (x *AttachedDiskInitializeParams) GetDiskName() string {
	if x != nil && x.DiskName != nil {
		return *x.DiskName
	}
	return ""
}

func (x *AttachedDiskInitializeParams) GetDiskSizeGb() int64 {
	if x != nil && x.DiskSizeGb != nil {
		return *x.DiskSizeGb
	}
	return 0
}

func (x *AttachedDiskInitializeParams) GetDiskType() string {
	if x != nil && x.DiskType != nil {
		return *x.DiskType
	}
	return ""
}

func (x *AttachedDiskInitializeParams) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *AttachedDiskInitializeParams) GetOnUpdateAction() AttachedDiskInitializeParams_OnUpdateAction {
	if x != nil && x.OnUpdateAction != nil {
		return *x.OnUpdateAction
	}
	return AttachedDiskInitializeParams_UNDEFINED_ON_UPDATE_ACTION
}

func (x *AttachedDiskInitializeParams) GetProvisionedIops() int64 {
	if x != nil && x.ProvisionedIops != nil {
		return *x.ProvisionedIops
	}
	return 0
}

func (x *AttachedDiskInitializeParams) GetResourcePolicies() []string {
	if x != nil {
		return x.ResourcePolicies
	}
	return nil
}

func (x *AttachedDiskInitializeParams) GetSourceImage() string {
	if x != nil && x.SourceImage != nil {
		return *x.SourceImage
	}
	return ""
}

func (x *AttachedDiskInitializeParams) GetSourceImageEncryptionKey() *CustomerEncryptionKey {
	if x != nil {
		return x.SourceImageEncryptionKey
	}
	return nil
}

func (x *AttachedDiskInitializeParams) GetSourceSnapshot() string {
	if x != nil && x.SourceSnapshot != nil {
		return *x.SourceSnapshot
	}
	return ""
}

func (x *AttachedDiskInitializeParams) GetSourceSnapshotEncryptionKey() *CustomerEncryptionKey {
	if x != nil {
		return x.SourceSnapshotEncryptionKey
	}
	return nil
}

// Initial State for shielded instance, these are public keys which are safe to store in public
type InitialStateConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The Key Database (db).
	Dbs []*FileContentBuffer `protobuf:"bytes,99253,rep,name=dbs,proto3" json:"dbs,omitempty"`
	// The forbidden key database (dbx).
	Dbxs []*FileContentBuffer `protobuf:"bytes,3077113,rep,name=dbxs,proto3" json:"dbxs,omitempty"`
	// The Key Exchange Key (KEK).
	Keks []*FileContentBuffer `protobuf:"bytes,3288130,rep,name=keks,proto3" json:"keks,omitempty"`
	// The Platform Key (PK).
	Pk *FileContentBuffer `protobuf:"bytes,3579,opt,name=pk,proto3,oneof" json:"pk,omitempty"`
}

func (x *InitialStateConfig) Reset() {
	*x = InitialStateConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *InitialStateConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InitialStateConfig) ProtoMessage() {}

func (x *InitialStateConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InitialStateConfig.ProtoReflect.Descriptor instead.
func (*InitialStateConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{21}
}

func (x *InitialStateConfig) GetDbs() []*FileContentBuffer {
	if x != nil {
		return x.Dbs
	}
	return nil
}

func (x *InitialStateConfig) GetDbxs() []*FileContentBuffer {
	if x != nil {
		return x.Dbxs
	}
	return nil
}

func (x *InitialStateConfig) GetKeks() []*FileContentBuffer {
	if x != nil {
		return x.Keks
	}
	return nil
}

func (x *InitialStateConfig) GetPk() *FileContentBuffer {
	if x != nil {
		return x.Pk
	}
	return nil
}

// An instance-attached disk resource.
type AttachedDisk struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Specifies whether the disk will be auto-deleted when the instance is deleted (but not when the disk is detached from the instance).
	AutoDelete *bool `protobuf:"varint,464761403,opt,name=auto_delete,json=autoDelete,proto3,oneof" json:"auto_delete,omitempty"`
	// Indicates that this is a boot disk. The virtual machine will use the first partition of the disk for its root filesystem.
	Boot *bool `protobuf:"varint,3029746,opt,name=boot,proto3,oneof" json:"boot,omitempty"`
	// Specifies a unique device name of your choice that is reflected into the /dev/disk/by-id/google-* tree of a Linux operating system running within the instance. This name can be used to reference the device for mounting, resizing, and so on, from within the instance.
	//
	// If not specified, the server chooses a default device name to apply to this disk, in the form persistent-disk-x, where x is a number assigned by Google Compute Engine. This field is only applicable for persistent disks.
	DeviceName *string `protobuf:"bytes,67541716,opt,name=device_name,json=deviceName,proto3,oneof" json:"device_name,omitempty"`
	// Encrypts or decrypts a disk using a customer-supplied encryption key.
	//
	// If you are creating a new disk, this field encrypts the new disk using an encryption key that you provide. If you are attaching an existing disk that is already encrypted, this field decrypts the disk using the customer-supplied encryption key.
	//
	// If you encrypt a disk using a customer-supplied key, you must provide the same key again when you attempt to use this resource at a later time. For example, you must provide the key when you create a snapshot or an image from the disk or when you attach the disk to a virtual machine instance.
	//
	// If you do not provide an encryption key, then the disk will be encrypted using an automatically generated key and you do not need to provide a key to use the disk later.
	//
	// Instance templates do not store customer-supplied encryption keys, so you cannot use your own keys to encrypt disks in a managed instance group.
	DiskEncryptionKey *CustomerEncryptionKey `protobuf:"bytes,271660677,opt,name=disk_encryption_key,json=diskEncryptionKey,proto3,oneof" json:"disk_encryption_key,omitempty"`
	// The size of the disk in GB.
	DiskSizeGb *int64 `protobuf:"varint,316263735,opt,name=disk_size_gb,json=diskSizeGb,proto3,oneof" json:"disk_size_gb,omitempty"`
	// A list of features to enable on the guest operating system. Applicable only for bootable images. Read  Enabling guest operating system features to see a list of available options.
	GuestOsFeatures []*GuestOsFeature `protobuf:"bytes,79294545,rep,name=guest_os_features,json=guestOsFeatures,proto3" json:"guest_os_features,omitempty"`
	// [Output Only] A zero-based index to this disk, where 0 is reserved for the boot disk. If you have many disks attached to an instance, each disk would have a unique index number.
	Index *int32 `protobuf:"varint,100346066,opt,name=index,proto3,oneof" json:"index,omitempty"`
	// [Input Only] Specifies the parameters for a new disk that will be created alongside the new instance. Use initialization parameters to create boot disks or local SSDs attached to the new instance.
	//
	// This property is mutually exclusive with the source property; you can only define one or the other, but not both.
	InitializeParams *AttachedDiskInitializeParams `protobuf:"bytes,17697045,opt,name=initialize_params,json=initializeParams,proto3,oneof" json:"initialize_params,omitempty"`
	// Specifies the disk interface to use for attaching this disk, which is either SCSI or NVME. The default is SCSI. Persistent disks must always use SCSI and the request will fail if you attempt to attach a persistent disk in any other format than SCSI. Local SSDs can use either NVME or SCSI. For performance characteristics of SCSI over NVMe, see Local SSD performance.
	Interface *AttachedDisk_Interface `protobuf:"varint,502623545,opt,name=interface,proto3,enum=google.cloud.compute.v1.AttachedDisk_Interface,oneof" json:"interface,omitempty"`
	// [Output Only] Type of the resource. Always compute#attachedDisk for attached disks.
	Kind *string `protobuf:"bytes,3292052,opt,name=kind,proto3,oneof" json:"kind,omitempty"`
	// [Output Only] Any valid publicly visible licenses.
	Licenses []string `protobuf:"bytes,337642578,rep,name=licenses,proto3" json:"licenses,omitempty"`
	// The mode in which to attach this disk, either READ_WRITE or READ_ONLY. If not specified, the default is to attach the disk in READ_WRITE mode.
	Mode *AttachedDisk_Mode `protobuf:"varint,3357091,opt,name=mode,proto3,enum=google.cloud.compute.v1.AttachedDisk_Mode,oneof" json:"mode,omitempty"`
	// [Output Only] shielded vm initial state stored on disk
	ShieldedInstanceInitialState *InitialStateConfig `protobuf:"bytes,192356867,opt,name=shielded_instance_initial_state,json=shieldedInstanceInitialState,proto3,oneof" json:"shielded_instance_initial_state,omitempty"`
	// Specifies a valid partial or full URL to an existing Persistent Disk resource. When creating a new instance, one of initializeParams.sourceImage or initializeParams.sourceSnapshot or disks.source is required except for local SSD.
	//
	// If desired, you can also attach existing non-root persistent disks using this property. This field is only applicable for persistent disks.
	//
	// Note that for InstanceTemplate, specify the disk name, not the URL for the disk.
	Source *string `protobuf:"bytes,177235995,opt,name=source,proto3,oneof" json:"source,omitempty"`
	// Specifies the type of the disk, either SCRATCH or PERSISTENT. If not specified, the default is PERSISTENT.
	Type *AttachedDisk_Type `protobuf:"varint,3575610,opt,name=type,proto3,enum=google.cloud.compute.v1.AttachedDisk_Type,oneof" json:"type,omitempty"`
}

func (x *AttachedDisk) Reset() {
	*x = AttachedDisk{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[22]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AttachedDisk) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AttachedDisk) ProtoMessage() {}

func (x *AttachedDisk) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[22]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AttachedDisk.ProtoReflect.Descriptor instead.
func (*AttachedDisk) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{22}
}

func (x *AttachedDisk) GetAutoDelete() bool {
	if x != nil && x.AutoDelete != nil {
		return *x.AutoDelete
	}
	return false
}

func (x *AttachedDisk) GetBoot() bool {
	if x != nil && x.Boot != nil {
		return *x.Boot
	}
	return false
}

func (x *AttachedDisk) GetDeviceName() string {
	if x != nil && x.DeviceName != nil {
		return *x.DeviceName
	}
	return ""
}

func (x *AttachedDisk) GetDiskEncryptionKey() *CustomerEncryptionKey {
	if x != nil {
		return x.DiskEncryptionKey
	}
	return nil
}

func (x *AttachedDisk) GetDiskSizeGb() int64 {
	if x != nil && x.DiskSizeGb != nil {
		return *x.DiskSizeGb
	}
	return 0
}

func (x *AttachedDisk) GetGuestOsFeatures() []*GuestOsFeature {
	if x != nil {
		return x.GuestOsFeatures
	}
	return nil
}

func (x *AttachedDisk) GetIndex() int32 {
	if x != nil && x.Index != nil {
		return *x.Index
	}
	return 0
}

func (x *AttachedDisk) GetInitializeParams() *AttachedDiskInitializeParams {
	if x != nil {
		return x.InitializeParams
	}
	return nil
}

func (x *AttachedDisk) GetInterface() AttachedDisk_Interface {
	if x != nil && x.Interface != nil {
		return *x.Interface
	}
	return AttachedDisk_UNDEFINED_INTERFACE
}

func (x *AttachedDisk) GetKind() string {
	if x != nil && x.Kind != nil {
		return *x.Kind
	}
	return ""
}

func (x *AttachedDisk) GetLicenses() []string {
	if x != nil {
		return x.Licenses
	}
	return nil
}

func (x *AttachedDisk) GetMode() AttachedDisk_Mode {
	if x != nil && x.Mode != nil {
		return *x.Mode
	}
	return AttachedDisk_UNDEFINED_MODE
}

func (x *AttachedDisk) GetShieldedInstanceInitialState() *InitialStateConfig {
	if x != nil {
		return x.ShieldedInstanceInitialState
	}
	return nil
}

func (x *AttachedDisk) GetSource() string {
	if x != nil && x.Source != nil {
		return *x.Source
	}
	return ""
}

func (x *AttachedDisk) GetType() AttachedDisk_Type {
	if x != nil && x.Type != nil {
		return *x.Type
	}
	return AttachedDisk_UNDEFINED_TYPE
}

// Provides the configuration for logging a type of permissions. Example:
//
// { "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [ "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" } ] }
//
// This enables 'DATA_READ' and 'DATA_WRITE' logging, while exempting jose@example.com from DATA_READ logging.
type AuditLogConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Specifies the identities that do not cause logging for this type of permission. Follows the same format of [Binding.members][].
	ExemptedMembers       []string `protobuf:"bytes,232615576,rep,name=exempted_members,json=exemptedMembers,proto3" json:"exempted_members,omitempty"`
	IgnoreChildExemptions *bool    `protobuf:"varint,70141850,opt,name=ignore_child_exemptions,json=ignoreChildExemptions,proto3,oneof" json:"ignore_child_exemptions,omitempty"`
	// The log type that this config enables.
	LogType *AuditLogConfig_LogType `protobuf:"varint,403115861,opt,name=log_type,json=logType,proto3,enum=google.cloud.compute.v1.AuditLogConfig_LogType,oneof" json:"log_type,omitempty"`
}

func (x *AuditLogConfig) Reset() {
	*x = AuditLogConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[23]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AuditLogConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AuditLogConfig) ProtoMessage() {}

func (x *AuditLogConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[23]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AuditLogConfig.ProtoReflect.Descriptor instead.
func (*AuditLogConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{23}
}

func (x *AuditLogConfig) GetExemptedMembers() []string {
	if x != nil {
		return x.ExemptedMembers
	}
	return nil
}

func (x *AuditLogConfig) GetIgnoreChildExemptions() bool {
	if x != nil && x.IgnoreChildExemptions != nil {
		return *x.IgnoreChildExemptions
	}
	return false
}

func (x *AuditLogConfig) GetLogType() AuditLogConfig_LogType {
	if x != nil && x.LogType != nil {
		return *x.LogType
	}
	return AuditLogConfig_UNDEFINED_LOG_TYPE
}

// Specifies the audit configuration for a service. The configuration determines which permission types are logged, and what identities, if any, are exempted from logging. An AuditConfig must have one or more AuditLogConfigs.
//
// If there are AuditConfigs for both `allServices` and a specific service, the union of the two AuditConfigs is used for that service: the log_types specified in each AuditConfig are enabled, and the exempted_members in each AuditLogConfig are exempted.
//
// Example Policy with multiple AuditConfigs:
//
// { "audit_configs": [ { "service": "allServices", "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [ "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" }, { "log_type": "ADMIN_READ" } ] }, { "service": "sampleservice.googleapis.com", "audit_log_configs": [ { "log_type": "DATA_READ" }, { "log_type": "DATA_WRITE", "exempted_members": [ "user:aliya@example.com" ] } ] } ] }
//
// For sampleservice, this policy enables DATA_READ, DATA_WRITE and ADMIN_READ logging. It also exempts jose@example.com from DATA_READ logging, and aliya@example.com from DATA_WRITE logging.
type AuditConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The configuration for logging of each type of permission.
	AuditLogConfigs []*AuditLogConfig `protobuf:"bytes,488420626,rep,name=audit_log_configs,json=auditLogConfigs,proto3" json:"audit_log_configs,omitempty"`
	ExemptedMembers []string          `protobuf:"bytes,232615576,rep,name=exempted_members,json=exemptedMembers,proto3" json:"exempted_members,omitempty"`
	// Specifies a service that will be enabled for audit logging. For example, `storage.googleapis.com`, `cloudsql.googleapis.com`. `allServices` is a special value that covers all services.
	Service *string `protobuf:"bytes,373540533,opt,name=service,proto3,oneof" json:"service,omitempty"`
}

func (x *AuditConfig) Reset() {
	*x = AuditConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[24]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AuditConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AuditConfig) ProtoMessage() {}

func (x *AuditConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[24]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AuditConfig.ProtoReflect.Descriptor instead.
func (*AuditConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{24}
}

func (x *AuditConfig) GetAuditLogConfigs() []*AuditLogConfig {
	if x != nil {
		return x.AuditLogConfigs
	}
	return nil
}

func (x *AuditConfig) GetExemptedMembers() []string {
	if x != nil {
		return x.ExemptedMembers
	}
	return nil
}

func (x *AuditConfig) GetService() string {
	if x != nil && x.Service != nil {
		return *x.Service
	}
	return ""
}

// Authorization-related information used by Cloud Audit Logging.
type AuthorizationLoggingOptions struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The type of the permission that was checked.
	PermissionType *AuthorizationLoggingOptions_PermissionType `protobuf:"varint,525978538,opt,name=permission_type,json=permissionType,proto3,enum=google.cloud.compute.v1.AuthorizationLoggingOptions_PermissionType,oneof" json:"permission_type,omitempty"`
}

func (x *AuthorizationLoggingOptions) Reset() {
	*x = AuthorizationLoggingOptions{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[25]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AuthorizationLoggingOptions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AuthorizationLoggingOptions) ProtoMessage() {}

func (x *AuthorizationLoggingOptions) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[25]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AuthorizationLoggingOptions.ProtoReflect.Descriptor instead.
func (*AuthorizationLoggingOptions) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{25}
}

func (x *AuthorizationLoggingOptions) GetPermissionType() AuthorizationLoggingOptions_PermissionType {
	if x != nil && x.PermissionType != nil {
		return *x.PermissionType
	}
	return AuthorizationLoggingOptions_UNDEFINED_PERMISSION_TYPE
}

// Cloud Autoscaler policy.
type AutoscalingPolicy struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The number of seconds that the autoscaler waits before it starts collecting information from a new instance. This prevents the autoscaler from collecting information when the instance is initializing, during which the collected usage would not be reliable. The default time autoscaler waits is 60 seconds.
	//
	// Virtual machine initialization times might vary because of numerous factors. We recommend that you test how long an instance may take to initialize. To do this, create an instance and time the startup process.
	CoolDownPeriodSec *int32 `protobuf:"varint,107692954,opt,name=cool_down_period_sec,json=coolDownPeriodSec,proto3,oneof" json:"cool_down_period_sec,omitempty"`
	// Defines the CPU utilization policy that allows the autoscaler to scale based on the average CPU utilization of a managed instance group.
	CpuUtilization *AutoscalingPolicyCpuUtilization `protobuf:"bytes,381211147,opt,name=cpu_utilization,json=cpuUtilization,proto3,oneof" json:"cpu_utilization,omitempty"`
	// Configuration parameters of autoscaling based on a custom metric.
	CustomMetricUtilizations []*AutoscalingPolicyCustomMetricUtilization `protobuf:"bytes,131972850,rep,name=custom_metric_utilizations,json=customMetricUtilizations,proto3" json:"custom_metric_utilizations,omitempty"`
	// Configuration parameters of autoscaling based on load balancer.
	LoadBalancingUtilization *AutoscalingPolicyLoadBalancingUtilization `protobuf:"bytes,429746403,opt,name=load_balancing_utilization,json=loadBalancingUtilization,proto3,oneof" json:"load_balancing_utilization,omitempty"`
	// The maximum number of instances that the autoscaler can scale out to. This is required when creating or updating an autoscaler. The maximum number of replicas must not be lower than minimal number of replicas.
	MaxNumReplicas *int32 `protobuf:"varint,62327375,opt,name=max_num_replicas,json=maxNumReplicas,proto3,oneof" json:"max_num_replicas,omitempty"`
	// The minimum number of replicas that the autoscaler can scale in to. This cannot be less than 0. If not provided, autoscaler chooses a default value depending on maximum number of instances allowed.
	MinNumReplicas *int32 `protobuf:"varint,535329825,opt,name=min_num_replicas,json=minNumReplicas,proto3,oneof" json:"min_num_replicas,omitempty"`
	// Defines operating mode for this policy.
	Mode           *AutoscalingPolicy_Mode          `protobuf:"varint,3357091,opt,name=mode,proto3,enum=google.cloud.compute.v1.AutoscalingPolicy_Mode,oneof" json:"mode,omitempty"`
	ScaleInControl *AutoscalingPolicyScaleInControl `protobuf:"bytes,527670872,opt,name=scale_in_control,json=scaleInControl,proto3,oneof" json:"scale_in_control,omitempty"`
	// Scaling schedules defined for an autoscaler. Multiple schedules can be set on an autoscaler, and they can overlap. During overlapping periods the greatest min_required_replicas of all scaling schedules is applied. Up to 128 scaling schedules are allowed.
	ScalingSchedules map[string]*AutoscalingPolicyScalingSchedule `protobuf:"bytes,355416580,rep,name=scaling_schedules,json=scalingSchedules,proto3" json:"scaling_schedules,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *AutoscalingPolicy) Reset() {
	*x = AutoscalingPolicy{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[26]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AutoscalingPolicy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AutoscalingPolicy) ProtoMessage() {}

func (x *AutoscalingPolicy) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[26]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AutoscalingPolicy.ProtoReflect.Descriptor instead.
func (*AutoscalingPolicy) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{26}
}

func (x *AutoscalingPolicy) GetCoolDownPeriodSec() int32 {
	if x != nil && x.CoolDownPeriodSec != nil {
		return *x.CoolDownPeriodSec
	}
	return 0
}

func (x *AutoscalingPolicy) GetCpuUtilization() *AutoscalingPolicyCpuUtilization {
	if x != nil {
		return x.CpuUtilization
	}
	return nil
}

func (x *AutoscalingPolicy) GetCustomMetricUtilizations() []*AutoscalingPolicyCustomMetricUtilization {
	if x != nil {
		return x.CustomMetricUtilizations
	}
	return nil
}

func (x *AutoscalingPolicy) GetLoadBalancingUtilization() *AutoscalingPolicyLoadBalancingUtilization {
	if x != nil {
		return x.LoadBalancingUtilization
	}
	return nil
}

func (x *AutoscalingPolicy) GetMaxNumReplicas() int32 {
	if x != nil && x.MaxNumReplicas != nil {
		return *x.MaxNumReplicas
	}
	return 0
}

func (x *AutoscalingPolicy) GetMinNumReplicas() int32 {
	if x != nil && x.MinNumReplicas != nil {
		return *x.MinNumReplicas
	}
	return 0
}

func (x *AutoscalingPolicy) GetMode() AutoscalingPolicy_Mode {
	if x != nil && x.Mode != nil {
		return *x.Mode
	}
	return AutoscalingPolicy_UNDEFINED_MODE
}

func (x *AutoscalingPolicy) GetScaleInControl() *AutoscalingPolicyScaleInControl {
	if x != nil {
		return x.ScaleInControl
	}
	return nil
}

func (x *AutoscalingPolicy) GetScalingSchedules() map[string]*AutoscalingPolicyScalingSchedule {
	if x != nil {
		return x.ScalingSchedules
	}
	return nil
}

//
type ScalingScheduleStatus struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// [Output Only] The last time the scaling schedule became active. Note: this is a timestamp when a schedule actually became active, not when it was planned to do so. The timestamp is in RFC3339 text format.
	LastStartTime *string `protobuf:"bytes,34545107,opt,name=last_start_time,json=lastStartTime,proto3,oneof" json:"last_start_time,omitempty"`
	// [Output Only] The next time the scaling schedule is to become active. Note: this is a timestamp when a schedule is planned to run, but the actual time might be slightly different. The timestamp is in RFC3339 text format.
	NextStartTime *string `protobuf:"bytes,97270102,opt,name=next_start_time,json=nextStartTime,proto3,oneof" json:"next_start_time,omitempty"`
	// [Output Only] The current state of a scaling schedule.
	State *ScalingScheduleStatus_State `protobuf:"varint,109757585,opt,name=state,proto3,enum=google.cloud.compute.v1.ScalingScheduleStatus_State,oneof" json:"state,omitempty"`
}

func (x *ScalingScheduleStatus) Reset() {
	*x = ScalingScheduleStatus{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[27]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ScalingScheduleStatus) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ScalingScheduleStatus) ProtoMessage() {}

func (x *ScalingScheduleStatus) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[27]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ScalingScheduleStatus.ProtoReflect.Descriptor instead.
func (*ScalingScheduleStatus) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{27}
}

func (x *ScalingScheduleStatus) GetLastStartTime() string {
	if x != nil && x.LastStartTime != nil {
		return *x.LastStartTime
	}
	return ""
}

func (x *ScalingScheduleStatus) GetNextStartTime() string {
	if x != nil && x.NextStartTime != nil {
		return *x.NextStartTime
	}
	return ""
}

func (x *ScalingScheduleStatus) GetState() ScalingScheduleStatus_State {
	if x != nil && x.State != nil {
		return *x.State
	}
	return ScalingScheduleStatus_UNDEFINED_STATE
}

//
type AutoscalerStatusDetails struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The status message.
	Message *string `protobuf:"bytes,418054151,opt,name=message,proto3,oneof" json:"message,omitempty"`
	// The type of error, warning, or notice returned. Current set of possible values:
	// - ALL_INSTANCES_UNHEALTHY (WARNING): All instances in the instance group are unhealthy (not in RUNNING state).
	// - BACKEND_SERVICE_DOES_NOT_EXIST (ERROR): There is no backend service attached to the instance group.
	// - CAPPED_AT_MAX_NUM_REPLICAS (WARNING): Autoscaler recommends a size greater than maxNumReplicas.
	// - CUSTOM_METRIC_DATA_POINTS_TOO_SPARSE (WARNING): The custom metric samples are not exported often enough to be a credible base for autoscaling.
	// - CUSTOM_METRIC_INVALID (ERROR): The custom metric that was specified does not exist or does not have the necessary labels.
	// - MIN_EQUALS_MAX (WARNING): The minNumReplicas is equal to maxNumReplicas. This means the autoscaler cannot add or remove instances from the instance group.
	// - MISSING_CUSTOM_METRIC_DATA_POINTS (WARNING): The autoscaler did not receive any data from the custom metric configured for autoscaling.
	// - MISSING_LOAD_BALANCING_DATA_POINTS (WARNING): The autoscaler is configured to scale based on a load balancing signal but the instance group has not received any requests from the load balancer.
	// - MODE_OFF (WARNING): Autoscaling is turned off. The number of instances in the group won't change automatically. The autoscaling configuration is preserved.
	// - MODE_ONLY_UP (WARNING): Autoscaling is in the "Autoscale only out" mode. The autoscaler can add instances but not remove any.
	// - MORE_THAN_ONE_BACKEND_SERVICE (ERROR): The instance group cannot be autoscaled because it has more than one backend service attached to it.
	// - NOT_ENOUGH_QUOTA_AVAILABLE (ERROR): There is insufficient quota for the necessary resources, such as CPU or number of instances.
	// - REGION_RESOURCE_STOCKOUT (ERROR): Shown only for regional autoscalers: there is a resource stockout in the chosen region.
	// - SCALING_TARGET_DOES_NOT_EXIST (ERROR): The target to be scaled does not exist.
	// - UNSUPPORTED_MAX_RATE_LOAD_BALANCING_CONFIGURATION (ERROR): Autoscaling does not work with an HTTP/S load balancer that has been configured for maxRate.
	// - ZONE_RESOURCE_STOCKOUT (ERROR): For zonal autoscalers: there is a resource stockout in the chosen zone. For regional autoscalers: in at least one of the zones you're using there is a resource stockout.  New values might be added in the future. Some of the values might not be available in all API versions.
	Type *AutoscalerStatusDetails_Type `protobuf:"varint,3575610,opt,name=type,proto3,enum=google.cloud.compute.v1.AutoscalerStatusDetails_Type,oneof" json:"type,omitempty"`
}

func (x *AutoscalerStatusDetails) Reset() {
	*x = AutoscalerStatusDetails{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[28]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AutoscalerStatusDetails) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AutoscalerStatusDetails) ProtoMessage() {}

func (x *AutoscalerStatusDetails) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[28]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AutoscalerStatusDetails.ProtoReflect.Descriptor instead.
func (*AutoscalerStatusDetails) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{28}
}

func (x *AutoscalerStatusDetails) GetMessage() string {
	if x != nil && x.Message != nil {
		return *x.Message
	}
	return ""
}

func (x *AutoscalerStatusDetails) GetType() AutoscalerStatusDetails_Type {
	if x != nil && x.Type != nil {
		return *x.Type
	}
	return AutoscalerStatusDetails_UNDEFINED_TYPE
}

// Represents an Autoscaler resource.
//
// Google Compute Engine has two Autoscaler resources:
//
// * [Zonal](/compute/docs/reference/rest/{$api_version}/autoscalers) * [Regional](/compute/docs/reference/rest/{$api_version}/regionAutoscalers)
//
// Use autoscalers to automatically add or delete instances from a managed instance group according to your defined autoscaling policy. For more information, read Autoscaling Groups of Instances.
//
// For zonal managed instance groups resource, use the autoscaler resource.
//
// For regional managed instance groups, use the regionAutoscalers resource. (== resource_for {$api_version}.autoscalers ==) (== resource_for {$api_version}.regionAutoscalers ==)
type Autoscaler struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The configuration parameters for the autoscaling algorithm. You can define one or more signals for an autoscaler: cpuUtilization, customMetricUtilizations, and loadBalancingUtilization.
	//
	// If none of these are specified, the default will be to autoscale based on cpuUtilization to 0.6 or 60%.
	AutoscalingPolicy *AutoscalingPolicy `protobuf:"bytes,221950041,opt,name=autoscaling_policy,json=autoscalingPolicy,proto3,oneof" json:"autoscaling_policy,omitempty"`
	// [Output Only] Creation timestamp in RFC3339 text format.
	CreationTimestamp *string `protobuf:"bytes,30525366,opt,name=creation_timestamp,json=creationTimestamp,proto3,oneof" json:"creation_timestamp,omitempty"`
	// An optional description of this resource. Provide this property when you create the resource.
	Description *string `protobuf:"bytes,422937596,opt,name=description,proto3,oneof" json:"description,omitempty"`
	// [Output Only] The unique identifier for the resource. This identifier is defined by the server.
	Id *uint64 `protobuf:"varint,3355,opt,name=id,proto3,oneof" json:"id,omitempty"`
	// [Output Only] Type of the resource. Always compute#autoscaler for autoscalers.
	Kind *string `protobuf:"bytes,3292052,opt,name=kind,proto3,oneof" json:"kind,omitempty"`
	// Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
	Name *string `protobuf:"bytes,3373707,opt,name=name,proto3,oneof" json:"name,omitempty"`
	// [Output Only] Target recommended MIG size (number of instances) computed by autoscaler. Autoscaler calculates the recommended MIG size even when the autoscaling policy mode is different from ON. This field is empty when autoscaler is not connected to an existing managed instance group or autoscaler did not generate its prediction.
	RecommendedSize *int32 `protobuf:"varint,257915749,opt,name=recommended_size,json=recommendedSize,proto3,oneof" json:"recommended_size,omitempty"`
	// [Output Only] URL of the region where the instance group resides (for autoscalers living in regional scope).
	Region *string `protobuf:"bytes,138946292,opt,name=region,proto3,oneof" json:"region,omitempty"`
	// [Output Only] Status information of existing scaling schedules.
	ScalingScheduleStatus map[string]*ScalingScheduleStatus `protobuf:"bytes,465950178,rep,name=scaling_schedule_status,json=scalingScheduleStatus,proto3" json:"scaling_schedule_status,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// [Output Only] Server-defined URL for the resource.
	SelfLink *string `protobuf:"bytes,456214797,opt,name=self_link,json=selfLink,proto3,oneof" json:"self_link,omitempty"`
	// [Output Only] The status of the autoscaler configuration. Current set of possible values:
	// - PENDING: Autoscaler backend hasn't read new/updated configuration.
	// - DELETING: Configuration is being deleted.
	// - ACTIVE: Configuration is acknowledged to be effective. Some warnings might be present in the statusDetails field.
	// - ERROR: Configuration has errors. Actionable for users. Details are present in the statusDetails field.  New values might be added in the future.
	Status *Autoscaler_Status `protobuf:"varint,181260274,opt,name=status,proto3,enum=google.cloud.compute.v1.Autoscaler_Status,oneof" json:"status,omitempty"`
	// [Output Only] Human-readable details about the current state of the autoscaler. Read the documentation for Commonly returned status messages for examples of status messages you might encounter.
	StatusDetails []*AutoscalerStatusDetails `protobuf:"bytes,363353845,rep,name=status_details,json=statusDetails,proto3" json:"status_details,omitempty"`
	// URL of the managed instance group that this autoscaler will scale. This field is required when creating an autoscaler.
	Target *string `protobuf:"bytes,192835985,opt,name=target,proto3,oneof" json:"target,omitempty"`
	// [Output Only] URL of the zone where the instance group resides (for autoscalers living in zonal scope).
	Zone *string `protobuf:"bytes,3744684,opt,name=zone,proto3,oneof" json:"zone,omitempty"`
}

func (x *Autoscaler) Reset() {
	*x = Autoscaler{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[29]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Autoscaler) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Autoscaler) ProtoMessage() {}

func (x *Autoscaler) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[29]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Autoscaler.ProtoReflect.Descriptor instead.
func (*Autoscaler) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{29}
}

func (x *Autoscaler) GetAutoscalingPolicy() *AutoscalingPolicy {
	if x != nil {
		return x.AutoscalingPolicy
	}
	return nil
}

func (x *Autoscaler) GetCreationTimestamp() string {
	if x != nil && x.CreationTimestamp != nil {
		return *x.CreationTimestamp
	}
	return ""
}

func (x *Autoscaler) GetDescription() string {
	if x != nil && x.Description != nil {
		return *x.Description
	}
	return ""
}

func (x *Autoscaler) GetId() uint64 {
	if x != nil && x.Id != nil {
		return *x.Id
	}
	return 0
}

func (x *Autoscaler) GetKind() string {
	if x != nil && x.Kind != nil {
		return *x.Kind
	}
	return ""
}

func (x *Autoscaler) GetName() string {
	if x != nil && x.Name != nil {
		return *x.Name
	}
	return ""
}

func (x *Autoscaler) GetRecommendedSize() int32 {
	if x != nil && x.RecommendedSize != nil {
		return *x.RecommendedSize
	}
	return 0
}

func (x *Autoscaler) GetRegion() string {
	if x != nil && x.Region != nil {
		return *x.Region
	}
	return ""
}

func (x *Autoscaler) GetScalingScheduleStatus() map[string]*ScalingScheduleStatus {
	if x != nil {
		return x.ScalingScheduleStatus
	}
	return nil
}

func (x *Autoscaler) GetSelfLink() string {
	if x != nil && x.SelfLink != nil {
		return *x.SelfLink
	}
	return ""
}

func (x *Autoscaler) GetStatus() Autoscaler_Status {
	if x != nil && x.Status != nil {
		return *x.Status
	}
	return Autoscaler_UNDEFINED_STATUS
}

func (x *Autoscaler) GetStatusDetails() []*AutoscalerStatusDetails {
	if x != nil {
		return x.StatusDetails
	}
	return nil
}

func (x *Autoscaler) GetTarget() string {
	if x != nil && x.Target != nil {
		return *x.Target
	}
	return ""
}

func (x *Autoscaler) GetZone() string {
	if x != nil && x.Zone != nil {
		return *x.Zone
	}
	return ""
}

//
type AutoscalersScopedList struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// [Output Only] A list of autoscalers contained in this scope.
	Autoscalers []*Autoscaler `protobuf:"bytes,465771644,rep,name=autoscalers,proto3" json:"autoscalers,omitempty"`
	// [Output Only] Informational warning which replaces the list of autoscalers when the list is empty.
	Warning *Warning `protobuf:"bytes,50704284,opt,name=warning,proto3,oneof" json:"warning,omitempty"`
}

func (x *AutoscalersScopedList) Reset() {
	*x = AutoscalersScopedList{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[30]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AutoscalersScopedList) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AutoscalersScopedList) ProtoMessage() {}

func (x *AutoscalersScopedList) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[30]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AutoscalersScopedList.ProtoReflect.Descriptor instead.
func (*AutoscalersScopedList) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{30}
}

func (x *AutoscalersScopedList) GetAutoscalers() []*Autoscaler {
	if x != nil {
		return x.Autoscalers
	}
	return nil
}

func (x *AutoscalersScopedList) GetWarning() *Warning {
	if x != nil {
		return x.Warning
	}
	return nil
}

//
type AutoscalerAggregatedList struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// [Output Only] Unique identifier for the resource; defined by the server.
	Id *string `protobuf:"bytes,3355,opt,name=id,proto3,oneof" json:"id,omitempty"`
	// A list of AutoscalersScopedList resources.
	Items map[string]*AutoscalersScopedList `protobuf:"bytes,100526016,rep,name=items,proto3" json:"items,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// [Output Only] Type of resource. Always compute#autoscalerAggregatedList for aggregated lists of autoscalers.
	Kind *string `protobuf:"bytes,3292052,opt,name=kind,proto3,oneof" json:"kind,omitempty"`
	// [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
	NextPageToken *string `protobuf:"bytes,79797525,opt,name=next_page_token,json=nextPageToken,proto3,oneof" json:"next_page_token,omitempty"`
	// [Output Only] Server-defined URL for this resource.
	SelfLink *string `protobuf:"bytes,456214797,opt,name=self_link,json=selfLink,proto3,oneof" json:"self_link,omitempty"`
	// [Output Only] Unreachable resources.
	Unreachables []string `protobuf:"bytes,243372063,rep,name=unreachables,proto3" json:"unreachables,omitempty"`
	// [Output Only] Informational warning message.
	Warning *Warning `protobuf:"bytes,50704284,opt,name=warning,proto3,oneof" json:"warning,omitempty"`
}

func (x *AutoscalerAggregatedList) Reset() {
	*x = AutoscalerAggregatedList{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[31]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AutoscalerAggregatedList) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AutoscalerAggregatedList) ProtoMessage() {}

func (x *AutoscalerAggregatedList) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[31]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AutoscalerAggregatedList.ProtoReflect.Descriptor instead.
func (*AutoscalerAggregatedList) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{31}
}

func (x *AutoscalerAggregatedList) GetId() string {
	if x != nil && x.Id != nil {
		return *x.Id
	}
	return ""
}

func (x *AutoscalerAggregatedList) GetItems() map[string]*AutoscalersScopedList {
	if x != nil {
		return x.Items
	}
	return nil
}

func (x *AutoscalerAggregatedList) GetKind() string {
	if x != nil && x.Kind != nil {
		return *x.Kind
	}
	return ""
}

func (x *AutoscalerAggregatedList) GetNextPageToken() string {
	if x != nil && x.NextPageToken != nil {
		return *x.NextPageToken
	}
	return ""
}

func (x *AutoscalerAggregatedList) GetSelfLink() string {
	if x != nil && x.SelfLink != nil {
		return *x.SelfLink
	}
	return ""
}

func (x *AutoscalerAggregatedList) GetUnreachables() []string {
	if x != nil {
		return x.Unreachables
	}
	return nil
}

func (x *AutoscalerAggregatedList) GetWarning() *Warning {
	if x != nil {
		return x.Warning
	}
	return nil
}

// Contains a list of Autoscaler resources.
type AutoscalerList struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// [Output Only] Unique identifier for the resource; defined by the server.
	Id *string `protobuf:"bytes,3355,opt,name=id,proto3,oneof" json:"id,omitempty"`
	// A list of Autoscaler resources.
	Items []*Autoscaler `protobuf:"bytes,100526016,rep,name=items,proto3" json:"items,omitempty"`
	// [Output Only] Type of resource. Always compute#autoscalerList for lists of autoscalers.
	Kind *string `protobuf:"bytes,3292052,opt,name=kind,proto3,oneof" json:"kind,omitempty"`
	// [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
	NextPageToken *string `protobuf:"bytes,79797525,opt,name=next_page_token,json=nextPageToken,proto3,oneof" json:"next_page_token,omitempty"`
	// [Output Only] Server-defined URL for this resource.
	SelfLink *string `protobuf:"bytes,456214797,opt,name=self_link,json=selfLink,proto3,oneof" json:"self_link,omitempty"`
	// [Output Only] Informational warning message.
	Warning *Warning `protobuf:"bytes,50704284,opt,name=warning,proto3,oneof" json:"warning,omitempty"`
}

func (x *AutoscalerList) Reset() {
	*x = AutoscalerList{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[32]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AutoscalerList) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AutoscalerList) ProtoMessage() {}

func (x *AutoscalerList) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[32]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AutoscalerList.ProtoReflect.Descriptor instead.
func (*AutoscalerList) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{32}
}

func (x *AutoscalerList) GetId() string {
	if x != nil && x.Id != nil {
		return *x.Id
	}
	return ""
}

func (x *AutoscalerList) GetItems() []*Autoscaler {
	if x != nil {
		return x.Items
	}
	return nil
}

func (x *AutoscalerList) GetKind() string {
	if x != nil && x.Kind != nil {
		return *x.Kind
	}
	return ""
}

func (x *AutoscalerList) GetNextPageToken() string {
	if x != nil && x.NextPageToken != nil {
		return *x.NextPageToken
	}
	return ""
}

func (x *AutoscalerList) GetSelfLink() string {
	if x != nil && x.SelfLink != nil {
		return *x.SelfLink
	}
	return ""
}

func (x *AutoscalerList) GetWarning() *Warning {
	if x != nil {
		return x.Warning
	}
	return nil
}

// CPU utilization policy.
type AutoscalingPolicyCpuUtilization struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Indicates whether predictive autoscaling based on CPU metric is enabled. Valid values are:
	//
	// * NONE (default). No predictive method is used. The autoscaler scales the group to meet current demand based on real-time metrics. * OPTIMIZE_AVAILABILITY. Predictive autoscaling improves availability by monitoring daily and weekly load patterns and scaling out ahead of anticipated demand.
	PredictiveMethod *AutoscalingPolicyCpuUtilization_PredictiveMethod `protobuf:"varint,390220737,opt,name=predictive_method,json=predictiveMethod,proto3,enum=google.cloud.compute.v1.AutoscalingPolicyCpuUtilization_PredictiveMethod,oneof" json:"predictive_method,omitempty"`
	// The target CPU utilization that the autoscaler maintains. Must be a float value in the range (0, 1]. If not specified, the default is 0.6.
	//
	// If the CPU level is below the target utilization, the autoscaler scales in the number of instances until it reaches the minimum number of instances you specified or until the average CPU of your instances reaches the target utilization.
	//
	// If the average CPU is above the target utilization, the autoscaler scales out until it reaches the maximum number of instances you specified or until the average utilization reaches the target utilization.
	UtilizationTarget *float64 `protobuf:"fixed64,215905870,opt,name=utilization_target,json=utilizationTarget,proto3,oneof" json:"utilization_target,omitempty"`
}

func (x *AutoscalingPolicyCpuUtilization) Reset() {
	*x = AutoscalingPolicyCpuUtilization{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[33]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AutoscalingPolicyCpuUtilization) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AutoscalingPolicyCpuUtilization) ProtoMessage() {}

func (x *AutoscalingPolicyCpuUtilization) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[33]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AutoscalingPolicyCpuUtilization.ProtoReflect.Descriptor instead.
func (*AutoscalingPolicyCpuUtilization) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{33}
}

func (x *AutoscalingPolicyCpuUtilization) GetPredictiveMethod() AutoscalingPolicyCpuUtilization_PredictiveMethod {
	if x != nil && x.PredictiveMethod != nil {
		return *x.PredictiveMethod
	}
	return AutoscalingPolicyCpuUtilization_UNDEFINED_PREDICTIVE_METHOD
}

func (x *AutoscalingPolicyCpuUtilization) GetUtilizationTarget() float64 {
	if x != nil && x.UtilizationTarget != nil {
		return *x.UtilizationTarget
	}
	return 0
}

// Custom utilization metric policy.
type AutoscalingPolicyCustomMetricUtilization struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A filter string, compatible with a Stackdriver Monitoring filter string for TimeSeries.list API call. This filter is used to select a specific TimeSeries for the purpose of autoscaling and to determine whether the metric is exporting per-instance or per-group data.
	//
	// For the filter to be valid for autoscaling purposes, the following rules apply:
	// - You can only use the AND operator for joining selectors.
	// - You can only use direct equality comparison operator (=) without any functions for each selector.
	// - You can specify the metric in both the filter string and in the metric field. However, if specified in both places, the metric must be identical.
	// - The monitored resource type determines what kind of values are expected for the metric. If it is a gce_instance, the autoscaler expects the metric to include a separate TimeSeries for each instance in a group. In such a case, you cannot filter on resource labels.
	// If the resource type is any other value, the autoscaler expects this metric to contain values that apply to the entire autoscaled instance group and resource label filtering can be performed to point autoscaler at the correct TimeSeries to scale upon. This is called a per-group metric for the purpose of autoscaling.
	//
	// If not specified, the type defaults to gce_instance.
	//
	// Try to provide a filter that is selective enough to pick just one TimeSeries for the autoscaled group or for each of the instances (if you are using gce_instance resource type). If multiple TimeSeries are returned upon the query execution, the autoscaler will sum their respective values to obtain its scaling value.
	Filter *string `protobuf:"bytes,336120696,opt,name=filter,proto3,oneof" json:"filter,omitempty"`
	// The identifier (type) of the Stackdriver Monitoring metric. The metric cannot have negative values.
	//
	// The metric must have a value type of INT64 or DOUBLE.
	Metric *string `protobuf:"bytes,533067184,opt,name=metric,proto3,oneof" json:"metric,omitempty"`
	// If scaling is based on a per-group metric value that represents the total amount of work to be done or resource usage, set this value to an amount assigned for a single instance of the scaled group. Autoscaler keeps the number of instances proportional to the value of this metric. The metric itself does not change value due to group resizing.
	//
	// A good metric to use with the target is for example pubsub.googleapis.com/subscription/num_undelivered_messages or a custom metric exporting the total number of requests coming to your instances.
	//
	// A bad example would be a metric exporting an average or median latency, since this value can't include a chunk assignable to a single instance, it could be better used with utilization_target instead.
	SingleInstanceAssignment *float64 `protobuf:"fixed64,504768064,opt,name=single_instance_assignment,json=singleInstanceAssignment,proto3,oneof" json:"single_instance_assignment,omitempty"`
	// The target value of the metric that autoscaler maintains. This must be a positive value. A utilization metric scales number of virtual machines handling requests to increase or decrease proportionally to the metric.
	//
	// For example, a good metric to use as a utilization_target is https://www.googleapis.com/compute/v1/instance/network/received_bytes_count. The autoscaler works to keep this value constant for each of the instances.
	UtilizationTarget *float64 `protobuf:"fixed64,215905870,opt,name=utilization_target,json=utilizationTarget,proto3,oneof" json:"utilization_target,omitempty"`
	// Defines how target utilization value is expressed for a Stackdriver Monitoring metric. Either GAUGE, DELTA_PER_SECOND, or DELTA_PER_MINUTE.
	UtilizationTargetType *AutoscalingPolicyCustomMetricUtilization_UtilizationTargetType `protobuf:"varint,340169355,opt,name=utilization_target_type,json=utilizationTargetType,proto3,enum=google.cloud.compute.v1.AutoscalingPolicyCustomMetricUtilization_UtilizationTargetType,oneof" json:"utilization_target_type,omitempty"`
}

func (x *AutoscalingPolicyCustomMetricUtilization) Reset() {
	*x = AutoscalingPolicyCustomMetricUtilization{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[34]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AutoscalingPolicyCustomMetricUtilization) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AutoscalingPolicyCustomMetricUtilization) ProtoMessage() {}

func (x *AutoscalingPolicyCustomMetricUtilization) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[34]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AutoscalingPolicyCustomMetricUtilization.ProtoReflect.Descriptor instead.
func (*AutoscalingPolicyCustomMetricUtilization) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{34}
}

func (x *AutoscalingPolicyCustomMetricUtilization) GetFilter() string {
	if x != nil && x.Filter != nil {
		return *x.Filter
	}
	return ""
}

func (x *AutoscalingPolicyCustomMetricUtilization) GetMetric() string {
	if x != nil && x.Metric != nil {
		return *x.Metric
	}
	return ""
}

func (x *AutoscalingPolicyCustomMetricUtilization) GetSingleInstanceAssignment() float64 {
	if x != nil && x.SingleInstanceAssignment != nil {
		return *x.SingleInstanceAssignment
	}
	return 0
}

func (x *AutoscalingPolicyCustomMetricUtilization) GetUtilizationTarget() float64 {
	if x != nil && x.UtilizationTarget != nil {
		return *x.UtilizationTarget
	}
	return 0
}

func (x *AutoscalingPolicyCustomMetricUtilization) GetUtilizationTargetType() AutoscalingPolicyCustomMetricUtilization_UtilizationTargetType {
	if x != nil && x.UtilizationTargetType != nil {
		return *x.UtilizationTargetType
	}
	return AutoscalingPolicyCustomMetricUtilization_UNDEFINED_UTILIZATION_TARGET_TYPE
}

// Configuration parameters of autoscaling based on load balancing.
type AutoscalingPolicyLoadBalancingUtilization struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Fraction of backend capacity utilization (set in HTTP(S) load balancing configuration) that the autoscaler maintains. Must be a positive float value. If not defined, the default is 0.8.
	UtilizationTarget *float64 `protobuf:"fixed64,215905870,opt,name=utilization_target,json=utilizationTarget,proto3,oneof" json:"utilization_target,omitempty"`
}

func (x *AutoscalingPolicyLoadBalancingUtilization) Reset() {
	*x = AutoscalingPolicyLoadBalancingUtilization{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[35]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AutoscalingPolicyLoadBalancingUtilization) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AutoscalingPolicyLoadBalancingUtilization) ProtoMessage() {}

func (x *AutoscalingPolicyLoadBalancingUtilization) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[35]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AutoscalingPolicyLoadBalancingUtilization.ProtoReflect.Descriptor instead.
func (*AutoscalingPolicyLoadBalancingUtilization) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{35}
}

func (x *AutoscalingPolicyLoadBalancingUtilization) GetUtilizationTarget() float64 {
	if x != nil && x.UtilizationTarget != nil {
		return *x.UtilizationTarget
	}
	return 0
}

// Configuration that allows for slower scale in so that even if Autoscaler recommends an abrupt scale in of a MIG, it will be throttled as specified by the parameters below.
type AutoscalingPolicyScaleInControl struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Maximum allowed number (or %) of VMs that can be deducted from the peak recommendation during the window autoscaler looks at when computing recommendations. Possibly all these VMs can be deleted at once so user service needs to be prepared to lose that many VMs in one step.
	MaxScaledInReplicas *FixedOrPercent `protobuf:"bytes,180710123,opt,name=max_scaled_in_replicas,json=maxScaledInReplicas,proto3,oneof" json:"max_scaled_in_replicas,omitempty"`
	// How far back autoscaling looks when computing recommendations to include directives regarding slower scale in, as described above.
	TimeWindowSec *int32 `protobuf:"varint,36405300,opt,name=time_window_sec,json=timeWindowSec,proto3,oneof" json:"time_window_sec,omitempty"`
}

func (x *AutoscalingPolicyScaleInControl) Reset() {
	*x = AutoscalingPolicyScaleInControl{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[36]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AutoscalingPolicyScaleInControl) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AutoscalingPolicyScaleInControl) ProtoMessage() {}

func (x *AutoscalingPolicyScaleInControl) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[36]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AutoscalingPolicyScaleInControl.ProtoReflect.Descriptor instead.
func (*AutoscalingPolicyScaleInControl) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{36}
}

func (x *AutoscalingPolicyScaleInControl) GetMaxScaledInReplicas() *FixedOrPercent {
	if x != nil {
		return x.MaxScaledInReplicas
	}
	return nil
}

func (x *AutoscalingPolicyScaleInControl) GetTimeWindowSec() int32 {
	if x != nil && x.TimeWindowSec != nil {
		return *x.TimeWindowSec
	}
	return 0
}

// Scaling based on user-defined schedule. The message describes a single scaling schedule. A scaling schedule changes the minimum number of VM instances an autoscaler can recommend, which can trigger scaling out.
type AutoscalingPolicyScalingSchedule struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A description of a scaling schedule.
	Description *string `protobuf:"bytes,422937596,opt,name=description,proto3,oneof" json:"description,omitempty"`
	// A boolean value that specifies whether a scaling schedule can influence autoscaler recommendations. If set to true, then a scaling schedule has no effect. This field is optional, and its value is false by default.
	Disabled *bool `protobuf:"varint,270940796,opt,name=disabled,proto3,oneof" json:"disabled,omitempty"`
	// The duration of time intervals, in seconds, for which this scaling schedule is to run. The minimum allowed value is 300. This field is required.
	DurationSec *int32 `protobuf:"varint,212356902,opt,name=duration_sec,json=durationSec,proto3,oneof" json:"duration_sec,omitempty"`
	// The minimum number of VM instances that the autoscaler will recommend in time intervals starting according to schedule. This field is required.
	MinRequiredReplicas *int32 `protobuf:"varint,365514414,opt,name=min_required_replicas,json=minRequiredReplicas,proto3,oneof" json:"min_required_replicas,omitempty"`
	// The start timestamps of time intervals when this scaling schedule is to provide a scaling signal. This field uses the extended cron format (with an optional year field). The expression can describe a single timestamp if the optional year is set, in which case the scaling schedule runs once. The schedule is interpreted with respect to time_zone. This field is required. Note: These timestamps only describe when autoscaler starts providing the scaling signal. The VMs need additional time to become serving.
	Schedule *string `protobuf:"bytes,375820951,opt,name=schedule,proto3,oneof" json:"schedule,omitempty"`
	// The time zone to use when interpreting the schedule. The value of this field must be a time zone name from the tz database: http://en.wikipedia.org/wiki/Tz_database. This field is assigned a default value of ?UTC? if left empty.
	TimeZone *string `protobuf:"bytes,36848094,opt,name=time_zone,json=timeZone,proto3,oneof" json:"time_zone,omitempty"`
}

func (x *AutoscalingPolicyScalingSchedule) Reset() {
	*x = AutoscalingPolicyScalingSchedule{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[37]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AutoscalingPolicyScalingSchedule) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AutoscalingPolicyScalingSchedule) ProtoMessage() {}

func (x *AutoscalingPolicyScalingSchedule) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[37]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AutoscalingPolicyScalingSchedule.ProtoReflect.Descriptor instead.
func (*AutoscalingPolicyScalingSchedule) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{37}
}

func (x *AutoscalingPolicyScalingSchedule) GetDescription() string {
	if x != nil && x.Description != nil {
		return *x.Description
	}
	return ""
}

func (x *AutoscalingPolicyScalingSchedule) GetDisabled() bool {
	if x != nil && x.Disabled != nil {
		return *x.Disabled
	}
	return false
}

func (x *AutoscalingPolicyScalingSchedule) GetDurationSec() int32 {
	if x != nil && x.DurationSec != nil {
		return *x.DurationSec
	}
	return 0
}

func (x *AutoscalingPolicyScalingSchedule) GetMinRequiredReplicas() int32 {
	if x != nil && x.MinRequiredReplicas != nil {
		return *x.MinRequiredReplicas
	}
	return 0
}

func (x *AutoscalingPolicyScalingSchedule) GetSchedule() string {
	if x != nil && x.Schedule != nil {
		return *x.Schedule
	}
	return ""
}

func (x *AutoscalingPolicyScalingSchedule) GetTimeZone() string {
	if x != nil && x.TimeZone != nil {
		return *x.TimeZone
	}
	return ""
}

// Encapsulates numeric value that can be either absolute or relative.
type FixedOrPercent struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// [Output Only] Absolute value of VM instances calculated based on the specific mode.
	//
	//
	// - If the value is fixed, then the calculated value is equal to the fixed value.
	// - If the value is a percent, then the calculated value is percent/100 * targetSize. For example, the calculated value of a 80% of a managed instance group with 150 instances would be (80/100 * 150) = 120 VM instances. If there is a remainder, the number is rounded up.
	Calculated *int32 `protobuf:"varint,472082878,opt,name=calculated,proto3,oneof" json:"calculated,omitempty"`
	// Specifies a fixed number of VM instances. This must be a positive integer.
	Fixed *int32 `protobuf:"varint,97445748,opt,name=fixed,proto3,oneof" json:"fixed,omitempty"`
	// Specifies a percentage of instances between 0 to 100%, inclusive. For example, specify 80 for 80%.
	Percent *int32 `protobuf:"varint,394814533,opt,name=percent,proto3,oneof" json:"percent,omitempty"`
}

func (x *FixedOrPercent) Reset() {
	*x = FixedOrPercent{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[38]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FixedOrPercent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FixedOrPercent) ProtoMessage() {}

func (x *FixedOrPercent) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[38]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FixedOrPercent.ProtoReflect.Descriptor instead.
func (*FixedOrPercent) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{38}
}

func (x *FixedOrPercent) GetCalculated() int32 {
	if x != nil && x.Calculated != nil {
		return *x.Calculated
	}
	return 0
}

func (x *FixedOrPercent) GetFixed() int32 {
	if x != nil && x.Fixed != nil {
		return *x.Fixed
	}
	return 0
}

func (x *FixedOrPercent) GetPercent() int32 {
	if x != nil && x.Percent != nil {
		return *x.Percent
	}
	return 0
}

// Message containing information of one individual backend.
type Backend struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Specifies how to determine whether the backend of a load balancer can handle additional traffic or is fully loaded. For usage guidelines, see  Connection balancing mode.
	BalancingMode *Backend_BalancingMode `protobuf:"varint,430286217,opt,name=balancing_mode,json=balancingMode,proto3,enum=google.cloud.compute.v1.Backend_BalancingMode,oneof" json:"balancing_mode,omitempty"`
	// A multiplier applied to the backend's target capacity of its balancing mode. The default value is 1, which means the group serves up to 100% of its configured capacity (depending on balancingMode). A setting of 0 means the group is completely drained, offering 0% of its available capacity. The valid ranges are 0.0 and [0.1,1.0]. You cannot configure a setting larger than 0 and smaller than 0.1. You cannot configure a setting of 0 when there is only one backend attached to the backend service.
	//
	// Not supported by:
	//
	// - Internal TCP/UDP Load Balancing - Network Load Balancing
	CapacityScaler *float32 `protobuf:"fixed32,315958157,opt,name=capacity_scaler,json=capacityScaler,proto3,oneof" json:"capacity_scaler,omitempty"`
	// An optional description of this resource. Provide this property when you create the resource.
	Description *string `protobuf:"bytes,422937596,opt,name=description,proto3,oneof" json:"description,omitempty"`
	// This field designates whether this is a failover backend. More than one failover backend can be configured for a given BackendService.
	Failover *bool `protobuf:"varint,138892530,opt,name=failover,proto3,oneof" json:"failover,omitempty"`
	// The fully-qualified URL of an instance group or network endpoint group (NEG) resource. The type of backend that a backend service supports depends on the backend service's loadBalancingScheme.
	//
	//
	// - When the loadBalancingScheme for the backend service is EXTERNAL (except Network Load Balancing),  INTERNAL_SELF_MANAGED, or INTERNAL_MANAGED , the backend can be either an instance group or a NEG. The backends on the backend service must be either all instance groups or all NEGs. You cannot mix instance group and NEG backends on the same backend service.
	//
	//
	// - When the loadBalancingScheme for the backend service is EXTERNAL for Network Load Balancing or INTERNAL for Internal TCP/UDP Load Balancing, the backend must be an instance group. NEGs are not supported.
	//
	// For regional services, the backend must be in the same region as the backend service.
	//
	// You must use the fully-qualified URL (starting with https://www.googleapis.com/) to specify the instance group or NEG. Partial URLs are not supported.
	Group *string `protobuf:"bytes,98629247,opt,name=group,proto3,oneof" json:"group,omitempty"`
	// Defines a target maximum number of simultaneous connections. For usage guidelines, see Connection balancing mode and Utilization balancing mode. Not available if the backend's balancingMode is RATE. Not supported by:
	//
	// - Internal TCP/UDP Load Balancing - Network Load Balancing
	MaxConnections *int32 `protobuf:"varint,110652154,opt,name=max_connections,json=maxConnections,proto3,oneof" json:"max_connections,omitempty"`
	// Defines a target maximum number of simultaneous connections. For usage guidelines, see Connection balancing mode and Utilization balancing mode.
	//
	// Not available if the backend's balancingMode is RATE. Not supported by:
	//
	// - Internal TCP/UDP Load Balancing - Network Load Balancing.
	MaxConnectionsPerEndpoint *int32 `protobuf:"varint,216904604,opt,name=max_connections_per_endpoint,json=maxConnectionsPerEndpoint,proto3,oneof" json:"max_connections_per_endpoint,omitempty"`
	// Defines a target maximum number of simultaneous connections. For usage guidelines, see Connection balancing mode and Utilization balancing mode.
	//
	// Not available if the backend's balancingMode is RATE. Not supported by:
	//
	// - Internal TCP/UDP Load Balancing - Network Load Balancing.
	MaxConnectionsPerInstance *int32 `protobuf:"varint,104671900,opt,name=max_connections_per_instance,json=maxConnectionsPerInstance,proto3,oneof" json:"max_connections_per_instance,omitempty"`
	// Defines a maximum number of HTTP requests per second (RPS). For usage guidelines, see Rate balancing mode and Utilization balancing mode.
	//
	// Not available if the backend's balancingMode is CONNECTION.
	MaxRate *int32 `protobuf:"varint,408035035,opt,name=max_rate,json=maxRate,proto3,oneof" json:"max_rate,omitempty"`
	// Defines a maximum target for requests per second (RPS). For usage guidelines, see Rate balancing mode and Utilization balancing mode.
	//
	// Not available if the backend's balancingMode is CONNECTION.
	MaxRatePerEndpoint *float32 `protobuf:"fixed32,129832283,opt,name=max_rate_per_endpoint,json=maxRatePerEndpoint,proto3,oneof" json:"max_rate_per_endpoint,omitempty"`
	// Defines a maximum target for requests per second (RPS). For usage guidelines, see Rate balancing mode and Utilization balancing mode.
	//
	// Not available if the backend's balancingMode is CONNECTION.
	MaxRatePerInstance *float32 `protobuf:"fixed32,17599579,opt,name=max_rate_per_instance,json=maxRatePerInstance,proto3,oneof" json:"max_rate_per_instance,omitempty"`
	MaxUtilization     *float32 `protobuf:"fixed32,148192199,opt,name=max_utilization,json=maxUtilization,proto3,oneof" json:"max_utilization,omitempty"`
}

func (x *Backend) Reset() {
	*x = Backend{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[39]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Backend) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Backend) ProtoMessage() {}

func (x *Backend) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[39]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Backend.ProtoReflect.Descriptor instead.
func (*Backend) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{39}
}

func (x *Backend) GetBalancingMode() Backend_BalancingMode {
	if x != nil && x.BalancingMode != nil {
		return *x.BalancingMode
	}
	return Backend_UNDEFINED_BALANCING_MODE
}

func (x *Backend) GetCapacityScaler() float32 {
	if x != nil && x.CapacityScaler != nil {
		return *x.CapacityScaler
	}
	return 0
}

func (x *Backend) GetDescription() string {
	if x != nil && x.Description != nil {
		return *x.Description
	}
	return ""
}

func (x *Backend) GetFailover() bool {
	if x != nil && x.Failover != nil {
		return *x.Failover
	}
	return false
}

func (x *Backend) GetGroup() string {
	if x != nil && x.Group != nil {
		return *x.Group
	}
	return ""
}

func (x *Backend) GetMaxConnections() int32 {
	if x != nil && x.MaxConnections != nil {
		return *x.MaxConnections
	}
	return 0
}

func (x *Backend) GetMaxConnectionsPerEndpoint() int32 {
	if x != nil && x.MaxConnectionsPerEndpoint != nil {
		return *x.MaxConnectionsPerEndpoint
	}
	return 0
}

func (x *Backend) GetMaxConnectionsPerInstance() int32 {
	if x != nil && x.MaxConnectionsPerInstance != nil {
		return *x.MaxConnectionsPerInstance
	}
	return 0
}

func (x *Backend) GetMaxRate() int32 {
	if x != nil && x.MaxRate != nil {
		return *x.MaxRate
	}
	return 0
}

func (x *Backend) GetMaxRatePerEndpoint() float32 {
	if x != nil && x.MaxRatePerEndpoint != nil {
		return *x.MaxRatePerEndpoint
	}
	return 0
}

func (x *Backend) GetMaxRatePerInstance() float32 {
	if x != nil && x.MaxRatePerInstance != nil {
		return *x.MaxRatePerInstance
	}
	return 0
}

func (x *Backend) GetMaxUtilization() float32 {
	if x != nil && x.MaxUtilization != nil {
		return *x.MaxUtilization
	}
	return 0
}

// Message containing Cloud CDN configuration for a backend bucket.
type BackendBucketCdnPolicy struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Bypass the cache when the specified request headers are matched - e.g. Pragma or Authorization headers. Up to 5 headers can be specified. The cache is bypassed for all cdnPolicy.cacheMode settings.
	BypassCacheOnRequestHeaders []*BackendBucketCdnPolicyBypassCacheOnRequestHeader `protobuf:"bytes,486203082,rep,name=bypass_cache_on_request_headers,json=bypassCacheOnRequestHeaders,proto3" json:"bypass_cache_on_request_headers,omitempty"`
	// Specifies the cache setting for all responses from this backend. The possible values are:
	//
	// USE_ORIGIN_HEADERS Requires the origin to set valid caching headers to cache content. Responses without these headers will not be cached at Google's edge, and will require a full trip to the origin on every request, potentially impacting performance and increasing load on the origin server.
	//
	// FORCE_CACHE_ALL Cache all content, ignoring any "private", "no-store" or "no-cache" directives in Cache-Control response headers. Warning: this may result in Cloud CDN caching private, per-user (user identifiable) content.
	//
	// CACHE_ALL_STATIC Automatically cache static content, including common image formats, media (video and audio), and web assets (JavaScript and CSS). Requests and responses that are marked as uncacheable, as well as dynamic content (including HTML), will not be cached.
	CacheMode *BackendBucketCdnPolicy_CacheMode `protobuf:"varint,28877888,opt,name=cache_mode,json=cacheMode,proto3,enum=google.cloud.compute.v1.BackendBucketCdnPolicy_CacheMode,oneof" json:"cache_mode,omitempty"`
	// Specifies a separate client (e.g. browser client) maximum TTL. This is used to clamp the max-age (or Expires) value sent to the client. With FORCE_CACHE_ALL, the lesser of client_ttl and default_ttl is used for the response max-age directive, along with a "public" directive. For cacheable content in CACHE_ALL_STATIC mode, client_ttl clamps the max-age from the origin (if specified), or else sets the response max-age directive to the lesser of the client_ttl and default_ttl, and also ensures a "public" cache-control directive is present. If a client TTL is not specified, a default value (1 hour) will be used. The maximum allowed value is 86400s (1 day).
	ClientTtl *int32 `protobuf:"varint,29034360,opt,name=client_ttl,json=clientTtl,proto3,oneof" json:"client_ttl,omitempty"`
	// Specifies the default TTL for cached content served by this origin for responses that do not have an existing valid TTL (max-age or s-max-age). Setting a TTL of "0" means "always revalidate". The value of defaultTTL cannot be set to a value greater than that of maxTTL, but can be equal. When the cacheMode is set to FORCE_CACHE_ALL, the defaultTTL will overwrite the TTL set in all responses. The maximum allowed value is 31,622,400s (1 year), noting that infrequently accessed objects may be evicted from the cache before the defined TTL.
	DefaultTtl *int32 `protobuf:"varint,100253422,opt,name=default_ttl,json=defaultTtl,proto3,oneof" json:"default_ttl,omitempty"`
	// Specifies the maximum allowed TTL for cached content served by this origin. Cache directives that attempt to set a max-age or s-maxage higher than this, or an Expires header more than maxTTL seconds in the future will be capped at the value of maxTTL, as if it were the value of an s-maxage Cache-Control directive. Headers sent to the client will not be modified. Setting a TTL of "0" means "always revalidate". The maximum allowed value is 31,622,400s (1 year), noting that infrequently accessed objects may be evicted from the cache before the defined TTL.
	MaxTtl *int32 `protobuf:"varint,307578001,opt,name=max_ttl,json=maxTtl,proto3,oneof" json:"max_ttl,omitempty"`
	// Negative caching allows per-status code TTLs to be set, in order to apply fine-grained caching for common errors or redirects. This can reduce the load on your origin and improve end-user experience by reducing response latency. When the cache mode is set to CACHE_ALL_STATIC or USE_ORIGIN_HEADERS, negative caching applies to responses with the specified response code that lack any Cache-Control, Expires, or Pragma: no-cache directives. When the cache mode is set to FORCE_CACHE_ALL, negative caching applies to all responses with the specified response code, and override any caching headers. By default, Cloud CDN will apply the following default TTLs to these status codes: HTTP 300 (Multiple Choice), 301, 308 (Permanent Redirects): 10m HTTP 404 (Not Found), 410 (Gone), 451 (Unavailable For Legal Reasons): 120s HTTP 405 (Method Not Found), 421 (Misdirected Request), 501 (Not Implemented): 60s. These defaults can be overridden in negative_caching_policy.
	NegativeCaching *bool `protobuf:"varint,336110005,opt,name=negative_caching,json=negativeCaching,proto3,oneof" json:"negative_caching,omitempty"`
	// Sets a cache TTL for the specified HTTP status code. negative_caching must be enabled to configure negative_caching_policy. Omitting the policy and leaving negative_caching enabled will use Cloud CDN's default cache TTLs. Note that when specifying an explicit negative_caching_policy, you should take care to specify a cache TTL for all response codes that you wish to cache. Cloud CDN will not apply any default negative caching when a policy exists.
	NegativeCachingPolicy []*BackendBucketCdnPolicyNegativeCachingPolicy `protobuf:"bytes,155359996,rep,name=negative_caching_policy,json=negativeCachingPolicy,proto3" json:"negative_caching_policy,omitempty"`
	// If true then Cloud CDN will combine multiple concurrent cache fill requests into a small number of requests to the origin.
	RequestCoalescing *bool `protobuf:"varint,532808276,opt,name=request_coalescing,json=requestCoalescing,proto3,oneof" json:"request_coalescing,omitempty"`
	// Serve existing content from the cache (if available) when revalidating content with the origin, or when an error is encountered when refreshing the cache. This setting defines the default "max-stale" duration for any cached responses that do not specify a max-stale directive. Stale responses that exceed the TTL configured here will not be served. The default limit (max-stale) is 86400s (1 day), which will allow stale content to be served up to this limit beyond the max-age (or s-max-age) of a cached response. The maximum allowed value is 604800 (1 week). Set this to zero (0) to disable serve-while-stale.
	ServeWhileStale *int32 `protobuf:"varint,236682203,opt,name=serve_while_stale,json=serveWhileStale,proto3,oneof" json:"serve_while_stale,omitempty"`
	// Maximum number of seconds the response to a signed URL request will be considered fresh. After this time period, the response will be revalidated before being served. Defaults to 1hr (3600s). When serving responses to signed URL requests, Cloud CDN will internally behave as though all responses from this backend had a "Cache-Control: public, max-age=[TTL]" header, regardless of any existing Cache-Control header. The actual headers served in responses will not be altered.
	SignedUrlCacheMaxAgeSec *int64 `protobuf:"varint,269374534,opt,name=signed_url_cache_max_age_sec,json=signedUrlCacheMaxAgeSec,proto3,oneof" json:"signed_url_cache_max_age_sec,omitempty"`
	// [Output Only] Names of the keys for signing request URLs.
	SignedUrlKeyNames []string `protobuf:"bytes,371848885,rep,name=signed_url_key_names,json=signedUrlKeyNames,proto3" json:"signed_url_key_names,omitempty"`
}

func (x *BackendBucketCdnPolicy) Reset() {
	*x = BackendBucketCdnPolicy{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[40]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BackendBucketCdnPolicy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BackendBucketCdnPolicy) ProtoMessage() {}

func (x *BackendBucketCdnPolicy) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[40]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BackendBucketCdnPolicy.ProtoReflect.Descriptor instead.
func (*BackendBucketCdnPolicy) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{40}
}

func (x *BackendBucketCdnPolicy) GetBypassCacheOnRequestHeaders() []*BackendBucketCdnPolicyBypassCacheOnRequestHeader {
	if x != nil {
		return x.BypassCacheOnRequestHeaders
	}
	return nil
}

func (x *BackendBucketCdnPolicy) GetCacheMode() BackendBucketCdnPolicy_CacheMode {
	if x != nil && x.CacheMode != nil {
		return *x.CacheMode
	}
	return BackendBucketCdnPolicy_UNDEFINED_CACHE_MODE
}

func (x *BackendBucketCdnPolicy) GetClientTtl() int32 {
	if x != nil && x.ClientTtl != nil {
		return *x.ClientTtl
	}
	return 0
}

func (x *BackendBucketCdnPolicy) GetDefaultTtl() int32 {
	if x != nil && x.DefaultTtl != nil {
		return *x.DefaultTtl
	}
	return 0
}

func (x *BackendBucketCdnPolicy) GetMaxTtl() int32 {
	if x != nil && x.MaxTtl != nil {
		return *x.MaxTtl
	}
	return 0
}

func (x *BackendBucketCdnPolicy) GetNegativeCaching() bool {
	if x != nil && x.NegativeCaching != nil {
		return *x.NegativeCaching
	}
	return false
}

func (x *BackendBucketCdnPolicy) GetNegativeCachingPolicy() []*BackendBucketCdnPolicyNegativeCachingPolicy {
	if x != nil {
		return x.NegativeCachingPolicy
	}
	return nil
}

func (x *BackendBucketCdnPolicy) GetRequestCoalescing() bool {
	if x != nil && x.RequestCoalescing != nil {
		return *x.RequestCoalescing
	}
	return false
}

func (x *BackendBucketCdnPolicy) GetServeWhileStale() int32 {
	if x != nil && x.ServeWhileStale != nil {
		return *x.ServeWhileStale
	}
	return 0
}

func (x *BackendBucketCdnPolicy) GetSignedUrlCacheMaxAgeSec() int64 {
	if x != nil && x.SignedUrlCacheMaxAgeSec != nil {
		return *x.SignedUrlCacheMaxAgeSec
	}
	return 0
}

func (x *BackendBucketCdnPolicy) GetSignedUrlKeyNames() []string {
	if x != nil {
		return x.SignedUrlKeyNames
	}
	return nil
}

// Represents a Cloud Storage Bucket resource.
//
// This Cloud Storage bucket resource is referenced by a URL map of a load balancer. For more information, read Backend Buckets.
type BackendBucket struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Cloud Storage bucket name.
	BucketName *string `protobuf:"bytes,283610048,opt,name=bucket_name,json=bucketName,proto3,oneof" json:"bucket_name,omitempty"`
	// Cloud CDN configuration for this BackendBucket.
	CdnPolicy *BackendBucketCdnPolicy `protobuf:"bytes,213976452,opt,name=cdn_policy,json=cdnPolicy,proto3,oneof" json:"cdn_policy,omitempty"`
	// [Output Only] Creation timestamp in RFC3339 text format.
	CreationTimestamp *string `protobuf:"bytes,30525366,opt,name=creation_timestamp,json=creationTimestamp,proto3,oneof" json:"creation_timestamp,omitempty"`
	// Headers that the HTTP/S load balancer should add to proxied responses.
	CustomResponseHeaders []string `protobuf:"bytes,387539094,rep,name=custom_response_headers,json=customResponseHeaders,proto3" json:"custom_response_headers,omitempty"`
	// An optional textual description of the resource; provided by the client when the resource is created.
	Description *string `protobuf:"bytes,422937596,opt,name=description,proto3,oneof" json:"description,omitempty"`
	// If true, enable Cloud CDN for this BackendBucket.
	EnableCdn *bool `protobuf:"varint,282942321,opt,name=enable_cdn,json=enableCdn,proto3,oneof" json:"enable_cdn,omitempty"`
	// [Output Only] Unique identifier for the resource; defined by the server.
	Id *uint64 `protobuf:"varint,3355,opt,name=id,proto3,oneof" json:"id,omitempty"`
	// Type of the resource.
	Kind *string `protobuf:"bytes,3292052,opt,name=kind,proto3,oneof" json:"kind,omitempty"`
	// Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
	Name *string `protobuf:"bytes,3373707,opt,name=name,proto3,oneof" json:"name,omitempty"`
	// [Output Only] Server-defined URL for the resource.
	SelfLink *string `protobuf:"bytes,456214797,opt,name=self_link,json=selfLink,proto3,oneof" json:"self_link,omitempty"`
}

func (x *BackendBucket) Reset() {
	*x = BackendBucket{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[41]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BackendBucket) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BackendBucket) ProtoMessage() {}

func (x *BackendBucket) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[41]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BackendBucket.ProtoReflect.Descriptor instead.
func (*BackendBucket) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{41}
}

func (x *BackendBucket) GetBucketName() string {
	if x != nil && x.BucketName != nil {
		return *x.BucketName
	}
	return ""
}

func (x *BackendBucket) GetCdnPolicy() *BackendBucketCdnPolicy {
	if x != nil {
		return x.CdnPolicy
	}
	return nil
}

func (x *BackendBucket) GetCreationTimestamp() string {
	if x != nil && x.CreationTimestamp != nil {
		return *x.CreationTimestamp
	}
	return ""
}

func (x *BackendBucket) GetCustomResponseHeaders() []string {
	if x != nil {
		return x.CustomResponseHeaders
	}
	return nil
}

func (x *BackendBucket) GetDescription() string {
	if x != nil && x.Description != nil {
		return *x.Description
	}
	return ""
}

func (x *BackendBucket) GetEnableCdn() bool {
	if x != nil && x.EnableCdn != nil {
		return *x.EnableCdn
	}
	return false
}

func (x *BackendBucket) GetId() uint64 {
	if x != nil && x.Id != nil {
		return *x.Id
	}
	return 0
}

func (x *BackendBucket) GetKind() string {
	if x != nil && x.Kind != nil {
		return *x.Kind
	}
	return ""
}

func (x *BackendBucket) GetName() string {
	if x != nil && x.Name != nil {
		return *x.Name
	}
	return ""
}

func (x *BackendBucket) GetSelfLink() string {
	if x != nil && x.SelfLink != nil {
		return *x.SelfLink
	}
	return ""
}

// Bypass the cache when the specified request headers are present, e.g. Pragma or Authorization headers. Values are case insensitive. The presence of such a header overrides the cache_mode setting.
type BackendBucketCdnPolicyBypassCacheOnRequestHeader struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The header field name to match on when bypassing cache. Values are case-insensitive.
	HeaderName *string `protobuf:"bytes,110223613,opt,name=header_name,json=headerName,proto3,oneof" json:"header_name,omitempty"`
}

func (x *BackendBucketCdnPolicyBypassCacheOnRequestHeader) Reset() {
	*x = BackendBucketCdnPolicyBypassCacheOnRequestHeader{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[42]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BackendBucketCdnPolicyBypassCacheOnRequestHeader) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BackendBucketCdnPolicyBypassCacheOnRequestHeader) ProtoMessage() {}

func (x *BackendBucketCdnPolicyBypassCacheOnRequestHeader) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[42]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BackendBucketCdnPolicyBypassCacheOnRequestHeader.ProtoReflect.Descriptor instead.
func (*BackendBucketCdnPolicyBypassCacheOnRequestHeader) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{42}
}

func (x *BackendBucketCdnPolicyBypassCacheOnRequestHeader) GetHeaderName() string {
	if x != nil && x.HeaderName != nil {
		return *x.HeaderName
	}
	return ""
}

// Specify CDN TTLs for response error codes.
type BackendBucketCdnPolicyNegativeCachingPolicy struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The HTTP status code to define a TTL against. Only HTTP status codes 300, 301, 302, 307, 308, 404, 405, 410, 421, 451 and 501 are can be specified as values, and you cannot specify a status code more than once.
	Code *int32 `protobuf:"varint,3059181,opt,name=code,proto3,oneof" json:"code,omitempty"`
	// The TTL (in seconds) for which to cache responses with the corresponding status code. The maximum allowed value is 1800s (30 minutes), noting that infrequently accessed objects may be evicted from the cache before the defined TTL.
	Ttl *int32 `protobuf:"varint,115180,opt,name=ttl,proto3,oneof" json:"ttl,omitempty"`
}

func (x *BackendBucketCdnPolicyNegativeCachingPolicy) Reset() {
	*x = BackendBucketCdnPolicyNegativeCachingPolicy{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[43]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BackendBucketCdnPolicyNegativeCachingPolicy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BackendBucketCdnPolicyNegativeCachingPolicy) ProtoMessage() {}

func (x *BackendBucketCdnPolicyNegativeCachingPolicy) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[43]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BackendBucketCdnPolicyNegativeCachingPolicy.ProtoReflect.Descriptor instead.
func (*BackendBucketCdnPolicyNegativeCachingPolicy) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{43}
}

func (x *BackendBucketCdnPolicyNegativeCachingPolicy) GetCode() int32 {
	if x != nil && x.Code != nil {
		return *x.Code
	}
	return 0
}

func (x *BackendBucketCdnPolicyNegativeCachingPolicy) GetTtl() int32 {
	if x != nil && x.Ttl != nil {
		return *x.Ttl
	}
	return 0
}

// Contains a list of BackendBucket resources.
type BackendBucketList struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// [Output Only] Unique identifier for the resource; defined by the server.
	Id *string `protobuf:"bytes,3355,opt,name=id,proto3,oneof" json:"id,omitempty"`
	// A list of BackendBucket resources.
	Items []*BackendBucket `protobuf:"bytes,100526016,rep,name=items,proto3" json:"items,omitempty"`
	// Type of resource.
	Kind *string `protobuf:"bytes,3292052,opt,name=kind,proto3,oneof" json:"kind,omitempty"`
	// [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
	NextPageToken *string `protobuf:"bytes,79797525,opt,name=next_page_token,json=nextPageToken,proto3,oneof" json:"next_page_token,omitempty"`
	// [Output Only] Server-defined URL for this resource.
	SelfLink *string `protobuf:"bytes,456214797,opt,name=self_link,json=selfLink,proto3,oneof" json:"self_link,omitempty"`
	// [Output Only] Informational warning message.
	Warning *Warning `protobuf:"bytes,50704284,opt,name=warning,proto3,oneof" json:"warning,omitempty"`
}

func (x *BackendBucketList) Reset() {
	*x = BackendBucketList{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[44]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BackendBucketList) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BackendBucketList) ProtoMessage() {}

func (x *BackendBucketList) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[44]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BackendBucketList.ProtoReflect.Descriptor instead.
func (*BackendBucketList) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{44}
}

func (x *BackendBucketList) GetId() string {
	if x != nil && x.Id != nil {
		return *x.Id
	}
	return ""
}

func (x *BackendBucketList) GetItems() []*BackendBucket {
	if x != nil {
		return x.Items
	}
	return nil
}

func (x *BackendBucketList) GetKind() string {
	if x != nil && x.Kind != nil {
		return *x.Kind
	}
	return ""
}

func (x *BackendBucketList) GetNextPageToken() string {
	if x != nil && x.NextPageToken != nil {
		return *x.NextPageToken
	}
	return ""
}

func (x *BackendBucketList) GetSelfLink() string {
	if x != nil && x.SelfLink != nil {
		return *x.SelfLink
	}
	return ""
}

func (x *BackendBucketList) GetWarning() *Warning {
	if x != nil {
		return x.Warning
	}
	return nil
}

// Message containing Cloud CDN configuration for a backend service.
type BackendServiceCdnPolicy struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Bypass the cache when the specified request headers are matched - e.g. Pragma or Authorization headers. Up to 5 headers can be specified. The cache is bypassed for all cdnPolicy.cacheMode settings.
	BypassCacheOnRequestHeaders []*BackendServiceCdnPolicyBypassCacheOnRequestHeader `protobuf:"bytes,486203082,rep,name=bypass_cache_on_request_headers,json=bypassCacheOnRequestHeaders,proto3" json:"bypass_cache_on_request_headers,omitempty"`
	// The CacheKeyPolicy for this CdnPolicy.
	CacheKeyPolicy *CacheKeyPolicy `protobuf:"bytes,159263727,opt,name=cache_key_policy,json=cacheKeyPolicy,proto3,oneof" json:"cache_key_policy,omitempty"`
	// Specifies the cache setting for all responses from this backend. The possible values are:
	//
	// USE_ORIGIN_HEADERS Requires the origin to set valid caching headers to cache content. Responses without these headers will not be cached at Google's edge, and will require a full trip to the origin on every request, potentially impacting performance and increasing load on the origin server.
	//
	// FORCE_CACHE_ALL Cache all content, ignoring any "private", "no-store" or "no-cache" directives in Cache-Control response headers. Warning: this may result in Cloud CDN caching private, per-user (user identifiable) content.
	//
	// CACHE_ALL_STATIC Automatically cache static content, including common image formats, media (video and audio), and web assets (JavaScript and CSS). Requests and responses that are marked as uncacheable, as well as dynamic content (including HTML), will not be cached.
	CacheMode *BackendServiceCdnPolicy_CacheMode `protobuf:"varint,28877888,opt,name=cache_mode,json=cacheMode,proto3,enum=google.cloud.compute.v1.BackendServiceCdnPolicy_CacheMode,oneof" json:"cache_mode,omitempty"`
	// Specifies a separate client (e.g. browser client) maximum TTL. This is used to clamp the max-age (or Expires) value sent to the client. With FORCE_CACHE_ALL, the lesser of client_ttl and default_ttl is used for the response max-age directive, along with a "public" directive. For cacheable content in CACHE_ALL_STATIC mode, client_ttl clamps the max-age from the origin (if specified), or else sets the response max-age directive to the lesser of the client_ttl and default_ttl, and also ensures a "public" cache-control directive is present. If a client TTL is not specified, a default value (1 hour) will be used. The maximum allowed value is 86400s (1 day).
	ClientTtl *int32 `protobuf:"varint,29034360,opt,name=client_ttl,json=clientTtl,proto3,oneof" json:"client_ttl,omitempty"`
	// Specifies the default TTL for cached content served by this origin for responses that do not have an existing valid TTL (max-age or s-max-age). Setting a TTL of "0" means "always revalidate". The value of defaultTTL cannot be set to a value greater than that of maxTTL, but can be equal. When the cacheMode is set to FORCE_CACHE_ALL, the defaultTTL will overwrite the TTL set in all responses. The maximum allowed value is 31,622,400s (1 year), noting that infrequently accessed objects may be evicted from the cache before the defined TTL.
	DefaultTtl *int32 `protobuf:"varint,100253422,opt,name=default_ttl,json=defaultTtl,proto3,oneof" json:"default_ttl,omitempty"`
	// Specifies the maximum allowed TTL for cached content served by this origin. Cache directives that attempt to set a max-age or s-maxage higher than this, or an Expires header more than maxTTL seconds in the future will be capped at the value of maxTTL, as if it were the value of an s-maxage Cache-Control directive. Headers sent to the client will not be modified. Setting a TTL of "0" means "always revalidate". The maximum allowed value is 31,622,400s (1 year), noting that infrequently accessed objects may be evicted from the cache before the defined TTL.
	MaxTtl *int32 `protobuf:"varint,307578001,opt,name=max_ttl,json=maxTtl,proto3,oneof" json:"max_ttl,omitempty"`
	// Negative caching allows per-status code TTLs to be set, in order to apply fine-grained caching for common errors or redirects. This can reduce the load on your origin and improve end-user experience by reducing response latency. When the cache mode is set to CACHE_ALL_STATIC or USE_ORIGIN_HEADERS, negative caching applies to responses with the specified response code that lack any Cache-Control, Expires, or Pragma: no-cache directives. When the cache mode is set to FORCE_CACHE_ALL, negative caching applies to all responses with the specified response code, and override any caching headers. By default, Cloud CDN will apply the following default TTLs to these status codes: HTTP 300 (Multiple Choice), 301, 308 (Permanent Redirects): 10m HTTP 404 (Not Found), 410 (Gone), 451 (Unavailable For Legal Reasons): 120s HTTP 405 (Method Not Found), 421 (Misdirected Request), 501 (Not Implemented): 60s. These defaults can be overridden in negative_caching_policy.
	NegativeCaching *bool `protobuf:"varint,336110005,opt,name=negative_caching,json=negativeCaching,proto3,oneof" json:"negative_caching,omitempty"`
	// Sets a cache TTL for the specified HTTP status code. negative_caching must be enabled to configure negative_caching_policy. Omitting the policy and leaving negative_caching enabled will use Cloud CDN's default cache TTLs. Note that when specifying an explicit negative_caching_policy, you should take care to specify a cache TTL for all response codes that you wish to cache. Cloud CDN will not apply any default negative caching when a policy exists.
	NegativeCachingPolicy []*BackendServiceCdnPolicyNegativeCachingPolicy `protobuf:"bytes,155359996,rep,name=negative_caching_policy,json=negativeCachingPolicy,proto3" json:"negative_caching_policy,omitempty"`
	// If true then Cloud CDN will combine multiple concurrent cache fill requests into a small number of requests to the origin.
	RequestCoalescing *bool `protobuf:"varint,532808276,opt,name=request_coalescing,json=requestCoalescing,proto3,oneof" json:"request_coalescing,omitempty"`
	// Serve existing content from the cache (if available) when revalidating content with the origin, or when an error is encountered when refreshing the cache. This setting defines the default "max-stale" duration for any cached responses that do not specify a max-stale directive. Stale responses that exceed the TTL configured here will not be served. The default limit (max-stale) is 86400s (1 day), which will allow stale content to be served up to this limit beyond the max-age (or s-max-age) of a cached response. The maximum allowed value is 604800 (1 week). Set this to zero (0) to disable serve-while-stale.
	ServeWhileStale *int32 `protobuf:"varint,236682203,opt,name=serve_while_stale,json=serveWhileStale,proto3,oneof" json:"serve_while_stale,omitempty"`
	// Maximum number of seconds the response to a signed URL request will be considered fresh. After this time period, the response will be revalidated before being served. Defaults to 1hr (3600s). When serving responses to signed URL requests, Cloud CDN will internally behave as though all responses from this backend had a "Cache-Control: public, max-age=[TTL]" header, regardless of any existing Cache-Control header. The actual headers served in responses will not be altered.
	SignedUrlCacheMaxAgeSec *int64 `protobuf:"varint,269374534,opt,name=signed_url_cache_max_age_sec,json=signedUrlCacheMaxAgeSec,proto3,oneof" json:"signed_url_cache_max_age_sec,omitempty"`
	// [Output Only] Names of the keys for signing request URLs.
	SignedUrlKeyNames []string `protobuf:"bytes,371848885,rep,name=signed_url_key_names,json=signedUrlKeyNames,proto3" json:"signed_url_key_names,omitempty"`
}

func (x *BackendServiceCdnPolicy) Reset() {
	*x = BackendServiceCdnPolicy{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[45]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BackendServiceCdnPolicy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BackendServiceCdnPolicy) ProtoMessage() {}

func (x *BackendServiceCdnPolicy) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[45]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BackendServiceCdnPolicy.ProtoReflect.Descriptor instead.
func (*BackendServiceCdnPolicy) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{45}
}

func (x *BackendServiceCdnPolicy) GetBypassCacheOnRequestHeaders() []*BackendServiceCdnPolicyBypassCacheOnRequestHeader {
	if x != nil {
		return x.BypassCacheOnRequestHeaders
	}
	return nil
}

func (x *BackendServiceCdnPolicy) GetCacheKeyPolicy() *CacheKeyPolicy {
	if x != nil {
		return x.CacheKeyPolicy
	}
	return nil
}

func (x *BackendServiceCdnPolicy) GetCacheMode() BackendServiceCdnPolicy_CacheMode {
	if x != nil && x.CacheMode != nil {
		return *x.CacheMode
	}
	return BackendServiceCdnPolicy_UNDEFINED_CACHE_MODE
}

func (x *BackendServiceCdnPolicy) GetClientTtl() int32 {
	if x != nil && x.ClientTtl != nil {
		return *x.ClientTtl
	}
	return 0
}

func (x *BackendServiceCdnPolicy) GetDefaultTtl() int32 {
	if x != nil && x.DefaultTtl != nil {
		return *x.DefaultTtl
	}
	return 0
}

func (x *BackendServiceCdnPolicy) GetMaxTtl() int32 {
	if x != nil && x.MaxTtl != nil {
		return *x.MaxTtl
	}
	return 0
}

func (x *BackendServiceCdnPolicy) GetNegativeCaching() bool {
	if x != nil && x.NegativeCaching != nil {
		return *x.NegativeCaching
	}
	return false
}

func (x *BackendServiceCdnPolicy) GetNegativeCachingPolicy() []*BackendServiceCdnPolicyNegativeCachingPolicy {
	if x != nil {
		return x.NegativeCachingPolicy
	}
	return nil
}

func (x *BackendServiceCdnPolicy) GetRequestCoalescing() bool {
	if x != nil && x.RequestCoalescing != nil {
		return *x.RequestCoalescing
	}
	return false
}

func (x *BackendServiceCdnPolicy) GetServeWhileStale() int32 {
	if x != nil && x.ServeWhileStale != nil {
		return *x.ServeWhileStale
	}
	return 0
}

func (x *BackendServiceCdnPolicy) GetSignedUrlCacheMaxAgeSec() int64 {
	if x != nil && x.SignedUrlCacheMaxAgeSec != nil {
		return *x.SignedUrlCacheMaxAgeSec
	}
	return 0
}

func (x *BackendServiceCdnPolicy) GetSignedUrlKeyNames() []string {
	if x != nil {
		return x.SignedUrlKeyNames
	}
	return nil
}

// Settings controlling the volume of connections to a backend service.
type CircuitBreakers struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The maximum number of connections to the backend service. If not specified, there is no limit.
	MaxConnections *int32 `protobuf:"varint,110652154,opt,name=max_connections,json=maxConnections,proto3,oneof" json:"max_connections,omitempty"`
	// The maximum number of pending requests allowed to the backend service. If not specified, there is no limit.
	MaxPendingRequests *int32 `protobuf:"varint,375558887,opt,name=max_pending_requests,json=maxPendingRequests,proto3,oneof" json:"max_pending_requests,omitempty"`
	// The maximum number of parallel requests that allowed to the backend service. If not specified, there is no limit.
	MaxRequests *int32 `protobuf:"varint,28097599,opt,name=max_requests,json=maxRequests,proto3,oneof" json:"max_requests,omitempty"`
	// Maximum requests for a single connection to the backend service. This parameter is respected by both the HTTP/1.1 and HTTP/2 implementations. If not specified, there is no limit. Setting this parameter to 1 will effectively disable keep alive.
	MaxRequestsPerConnection *int32 `protobuf:"varint,361630528,opt,name=max_requests_per_connection,json=maxRequestsPerConnection,proto3,oneof" json:"max_requests_per_connection,omitempty"`
	// The maximum number of parallel retries allowed to the backend cluster. If not specified, the default is 1.
	MaxRetries *int32 `protobuf:"varint,55546219,opt,name=max_retries,json=maxRetries,proto3,oneof" json:"max_retries,omitempty"`
}

func (x *CircuitBreakers) Reset() {
	*x = CircuitBreakers{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[46]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CircuitBreakers) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CircuitBreakers) ProtoMessage() {}

func (x *CircuitBreakers) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[46]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CircuitBreakers.ProtoReflect.Descriptor instead.
func (*CircuitBreakers) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{46}
}

func (x *CircuitBreakers) GetMaxConnections() int32 {
	if x != nil && x.MaxConnections != nil {
		return *x.MaxConnections
	}
	return 0
}

func (x *CircuitBreakers) GetMaxPendingRequests() int32 {
	if x != nil && x.MaxPendingRequests != nil {
		return *x.MaxPendingRequests
	}
	return 0
}

func (x *CircuitBreakers) GetMaxRequests() int32 {
	if x != nil && x.MaxRequests != nil {
		return *x.MaxRequests
	}
	return 0
}

func (x *CircuitBreakers) GetMaxRequestsPerConnection() int32 {
	if x != nil && x.MaxRequestsPerConnection != nil {
		return *x.MaxRequestsPerConnection
	}
	return 0
}

func (x *CircuitBreakers) GetMaxRetries() int32 {
	if x != nil && x.MaxRetries != nil {
		return *x.MaxRetries
	}
	return 0
}

// Message containing connection draining configuration.
type ConnectionDraining struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Configures a duration timeout for existing requests on a removed backend instance. For supported load balancers and protocols, as described in Enabling connection draining.
	DrainingTimeoutSec *int32 `protobuf:"varint,225127070,opt,name=draining_timeout_sec,json=drainingTimeoutSec,proto3,oneof" json:"draining_timeout_sec,omitempty"`
}

func (x *ConnectionDraining) Reset() {
	*x = ConnectionDraining{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[47]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ConnectionDraining) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ConnectionDraining) ProtoMessage() {}

func (x *ConnectionDraining) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[47]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ConnectionDraining.ProtoReflect.Descriptor instead.
func (*ConnectionDraining) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{47}
}

func (x *ConnectionDraining) GetDrainingTimeoutSec() int32 {
	if x != nil && x.DrainingTimeoutSec != nil {
		return *x.DrainingTimeoutSec
	}
	return 0
}

// This message defines settings for a consistent hash style load balancer.
type ConsistentHashLoadBalancerSettings struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Hash is based on HTTP Cookie. This field describes a HTTP cookie that will be used as the hash key for the consistent hash load balancer. If the cookie is not present, it will be generated. This field is applicable if the sessionAffinity is set to HTTP_COOKIE.
	HttpCookie *ConsistentHashLoadBalancerSettingsHttpCookie `protobuf:"bytes,6673915,opt,name=http_cookie,json=httpCookie,proto3,oneof" json:"http_cookie,omitempty"`
	// The hash based on the value of the specified header field. This field is applicable if the sessionAffinity is set to HEADER_FIELD.
	HttpHeaderName *string `protobuf:"bytes,234798022,opt,name=http_header_name,json=httpHeaderName,proto3,oneof" json:"http_header_name,omitempty"`
	// The minimum number of virtual nodes to use for the hash ring. Defaults to 1024. Larger ring sizes result in more granular load distributions. If the number of hosts in the load balancing pool is larger than the ring size, each host will be assigned a single virtual node.
	MinimumRingSize *int64 `protobuf:"varint,234380735,opt,name=minimum_ring_size,json=minimumRingSize,proto3,oneof" json:"minimum_ring_size,omitempty"`
}

func (x *ConsistentHashLoadBalancerSettings) Reset() {
	*x = ConsistentHashLoadBalancerSettings{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[48]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ConsistentHashLoadBalancerSettings) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ConsistentHashLoadBalancerSettings) ProtoMessage() {}

func (x *ConsistentHashLoadBalancerSettings) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[48]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ConsistentHashLoadBalancerSettings.ProtoReflect.Descriptor instead.
func (*ConsistentHashLoadBalancerSettings) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{48}
}

func (x *ConsistentHashLoadBalancerSettings) GetHttpCookie() *ConsistentHashLoadBalancerSettingsHttpCookie {
	if x != nil {
		return x.HttpCookie
	}
	return nil
}

func (x *ConsistentHashLoadBalancerSettings) GetHttpHeaderName() string {
	if x != nil && x.HttpHeaderName != nil {
		return *x.HttpHeaderName
	}
	return ""
}

func (x *ConsistentHashLoadBalancerSettings) GetMinimumRingSize() int64 {
	if x != nil && x.MinimumRingSize != nil {
		return *x.MinimumRingSize
	}
	return 0
}

// Applicable only to Failover for Internal TCP/UDP Load Balancing and Network Load Balancing. On failover or failback, this field indicates whether connection draining will be honored. GCP has a fixed connection draining timeout of 10 minutes. A setting of true terminates existing TCP connections to the active pool during failover and failback, immediately draining traffic. A setting of false allows existing TCP connections to persist, even on VMs no longer in the active pool, for up to the duration of the connection draining timeout (10 minutes).
type BackendServiceFailoverPolicy struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// This can be set to true only if the protocol is TCP.
	//
	// The default is false.
	DisableConnectionDrainOnFailover *bool `protobuf:"varint,182150753,opt,name=disable_connection_drain_on_failover,json=disableConnectionDrainOnFailover,proto3,oneof" json:"disable_connection_drain_on_failover,omitempty"`
	// Applicable only to Failover for Internal TCP/UDP Load Balancing and Network Load Balancing, If set to true, connections to the load balancer are dropped when all primary and all backup backend VMs are unhealthy.If set to false, connections are distributed among all primary VMs when all primary and all backup backend VMs are unhealthy. The default is false.
	DropTrafficIfUnhealthy *bool `protobuf:"varint,112289428,opt,name=drop_traffic_if_unhealthy,json=dropTrafficIfUnhealthy,proto3,oneof" json:"drop_traffic_if_unhealthy,omitempty"`
	// Applicable only to Failover for Internal TCP/UDP Load Balancing and Network Load Balancing. The value of the field must be in the range [0, 1]. If the value is 0, the load balancer performs a failover when the number of healthy primary VMs equals zero. For all other values, the load balancer performs a failover when the total number of healthy primary VMs is less than this ratio.
	FailoverRatio *float32 `protobuf:"fixed32,212667006,opt,name=failover_ratio,json=failoverRatio,proto3,oneof" json:"failover_ratio,omitempty"`
}

func (x *BackendServiceFailoverPolicy) Reset() {
	*x = BackendServiceFailoverPolicy{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[49]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BackendServiceFailoverPolicy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BackendServiceFailoverPolicy) ProtoMessage() {}

func (x *BackendServiceFailoverPolicy) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[49]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BackendServiceFailoverPolicy.ProtoReflect.Descriptor instead.
func (*BackendServiceFailoverPolicy) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{49}
}

func (x *BackendServiceFailoverPolicy) GetDisableConnectionDrainOnFailover() bool {
	if x != nil && x.DisableConnectionDrainOnFailover != nil {
		return *x.DisableConnectionDrainOnFailover
	}
	return false
}

func (x *BackendServiceFailoverPolicy) GetDropTrafficIfUnhealthy() bool {
	if x != nil && x.DropTrafficIfUnhealthy != nil {
		return *x.DropTrafficIfUnhealthy
	}
	return false
}

func (x *BackendServiceFailoverPolicy) GetFailoverRatio() float32 {
	if x != nil && x.FailoverRatio != nil {
		return *x.FailoverRatio
	}
	return 0
}

// Identity-Aware Proxy
type BackendServiceIAP struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Whether the serving infrastructure will authenticate and authorize all incoming requests. If true, the oauth2ClientId and oauth2ClientSecret fields must be non-empty.
	Enabled *bool `protobuf:"varint,1018689,opt,name=enabled,proto3,oneof" json:"enabled,omitempty"`
	// OAuth2 client ID to use for the authentication flow.
	Oauth2ClientId *string `protobuf:"bytes,314017611,opt,name=oauth2_client_id,json=oauth2ClientId,proto3,oneof" json:"oauth2_client_id,omitempty"`
	// OAuth2 client secret to use for the authentication flow. For security reasons, this value cannot be retrieved via the API. Instead, the SHA-256 hash of the value is returned in the oauth2ClientSecretSha256 field.
	Oauth2ClientSecret *string `protobuf:"bytes,50999520,opt,name=oauth2_client_secret,json=oauth2ClientSecret,proto3,oneof" json:"oauth2_client_secret,omitempty"`
	// [Output Only] SHA256 hash value for the field oauth2_client_secret above.
	Oauth2ClientSecretSha256 *string `protobuf:"bytes,112903782,opt,name=oauth2_client_secret_sha256,json=oauth2ClientSecretSha256,proto3,oneof" json:"oauth2_client_secret_sha256,omitempty"`
}

func (x *BackendServiceIAP) Reset() {
	*x = BackendServiceIAP{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[50]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BackendServiceIAP) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BackendServiceIAP) ProtoMessage() {}

func (x *BackendServiceIAP) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[50]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BackendServiceIAP.ProtoReflect.Descriptor instead.
func (*BackendServiceIAP) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{50}
}

func (x *BackendServiceIAP) GetEnabled() bool {
	if x != nil && x.Enabled != nil {
		return *x.Enabled
	}
	return false
}

func (x *BackendServiceIAP) GetOauth2ClientId() string {
	if x != nil && x.Oauth2ClientId != nil {
		return *x.Oauth2ClientId
	}
	return ""
}

func (x *BackendServiceIAP) GetOauth2ClientSecret() string {
	if x != nil && x.Oauth2ClientSecret != nil {
		return *x.Oauth2ClientSecret
	}
	return ""
}

func (x *BackendServiceIAP) GetOauth2ClientSecretSha256() string {
	if x != nil && x.Oauth2ClientSecretSha256 != nil {
		return *x.Oauth2ClientSecretSha256
	}
	return ""
}

// The available logging options for the load balancer traffic served by this backend service.
type BackendServiceLogConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// This field denotes whether to enable logging for the load balancer traffic served by this backend service.
	Enable *bool `protobuf:"varint,311764355,opt,name=enable,proto3,oneof" json:"enable,omitempty"`
	// This field can only be specified if logging is enabled for this backend service. The value of the field must be in [0, 1]. This configures the sampling rate of requests to the load balancer where 1.0 means all logged requests are reported and 0.0 means no logged requests are reported. The default value is 1.0.
	SampleRate *float32 `protobuf:"fixed32,153193045,opt,name=sample_rate,json=sampleRate,proto3,oneof" json:"sample_rate,omitempty"`
}

func (x *BackendServiceLogConfig) Reset() {
	*x = BackendServiceLogConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[51]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BackendServiceLogConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BackendServiceLogConfig) ProtoMessage() {}

func (x *BackendServiceLogConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[51]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BackendServiceLogConfig.ProtoReflect.Descriptor instead.
func (*BackendServiceLogConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{51}
}

func (x *BackendServiceLogConfig) GetEnable() bool {
	if x != nil && x.Enable != nil {
		return *x.Enable
	}
	return false
}

func (x *BackendServiceLogConfig) GetSampleRate() float32 {
	if x != nil && x.SampleRate != nil {
		return *x.SampleRate
	}
	return 0
}

// A Duration represents a fixed-length span of time represented as a count of seconds and fractions of seconds at nanosecond resolution. It is independent of any calendar and concepts like "day" or "month". Range is approximately 10,000 years.
type Duration struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Span of time that's a fraction of a second at nanosecond resolution. Durations less than one second are represented with a 0 `seconds` field and a positive `nanos` field. Must be from 0 to 999,999,999 inclusive.
	Nanos *int32 `protobuf:"varint,104586303,opt,name=nanos,proto3,oneof" json:"nanos,omitempty"`
	// Span of time at a resolution of a second. Must be from 0 to 315,576,000,000 inclusive. Note: these bounds are computed from: 60 sec/min * 60 min/hr * 24 hr/day * 365.25 days/year * 10000 years
	Seconds *int64 `protobuf:"varint,359484031,opt,name=seconds,proto3,oneof" json:"seconds,omitempty"`
}

func (x *Duration) Reset() {
	*x = Duration{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[52]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Duration) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Duration) ProtoMessage() {}

func (x *Duration) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[52]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Duration.ProtoReflect.Descriptor instead.
func (*Duration) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{52}
}

func (x *Duration) GetNanos() int32 {
	if x != nil && x.Nanos != nil {
		return *x.Nanos
	}
	return 0
}

func (x *Duration) GetSeconds() int64 {
	if x != nil && x.Seconds != nil {
		return *x.Seconds
	}
	return 0
}

// Settings controlling the eviction of unhealthy hosts from the load balancing pool for the backend service.
type OutlierDetection struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The base time that a host is ejected for. The real ejection time is equal to the base ejection time multiplied by the number of times the host has been ejected. Defaults to 30000ms or 30s.
	BaseEjectionTime *Duration `protobuf:"bytes,80997255,opt,name=base_ejection_time,json=baseEjectionTime,proto3,oneof" json:"base_ejection_time,omitempty"`
	// Number of errors before a host is ejected from the connection pool. When the backend host is accessed over HTTP, a 5xx return code qualifies as an error. Defaults to 5.
	ConsecutiveErrors *int32 `protobuf:"varint,387193248,opt,name=consecutive_errors,json=consecutiveErrors,proto3,oneof" json:"consecutive_errors,omitempty"`
	// The number of consecutive gateway failures (502, 503, 504 status or connection errors that are mapped to one of those status codes) before a consecutive gateway failure ejection occurs. Defaults to 3.
	ConsecutiveGatewayFailure *int32 `protobuf:"varint,417504250,opt,name=consecutive_gateway_failure,json=consecutiveGatewayFailure,proto3,oneof" json:"consecutive_gateway_failure,omitempty"`
	// The percentage chance that a host will be actually ejected when an outlier status is detected through consecutive 5xx. This setting can be used to disable ejection or to ramp it up slowly. Defaults to 0.
	EnforcingConsecutiveErrors *int32 `protobuf:"varint,213133760,opt,name=enforcing_consecutive_errors,json=enforcingConsecutiveErrors,proto3,oneof" json:"enforcing_consecutive_errors,omitempty"`
	// The percentage chance that a host will be actually ejected when an outlier status is detected through consecutive gateway failures. This setting can be used to disable ejection or to ramp it up slowly. Defaults to 100.
	EnforcingConsecutiveGatewayFailure *int32 `protobuf:"varint,394440666,opt,name=enforcing_consecutive_gateway_failure,json=enforcingConsecutiveGatewayFailure,proto3,oneof" json:"enforcing_consecutive_gateway_failure,omitempty"`
	// The percentage chance that a host will be actually ejected when an outlier status is detected through success rate statistics. This setting can be used to disable ejection or to ramp it up slowly. Defaults to 100.
	EnforcingSuccessRate *int32 `protobuf:"varint,194508732,opt,name=enforcing_success_rate,json=enforcingSuccessRate,proto3,oneof" json:"enforcing_success_rate,omitempty"`
	// Time interval between ejection analysis sweeps. This can result in both new ejections as well as hosts being returned to service. Defaults to 1 second.
	Interval *Duration `protobuf:"bytes,33547461,opt,name=interval,proto3,oneof" json:"interval,omitempty"`
	// Maximum percentage of hosts in the load balancing pool for the backend service that can be ejected. Defaults to 50%.
	MaxEjectionPercent *int32 `protobuf:"varint,18436888,opt,name=max_ejection_percent,json=maxEjectionPercent,proto3,oneof" json:"max_ejection_percent,omitempty"`
	// The number of hosts in a cluster that must have enough request volume to detect success rate outliers. If the number of hosts is less than this setting, outlier detection via success rate statistics is not performed for any host in the cluster. Defaults to 5.
	SuccessRateMinimumHosts *int32 `protobuf:"varint,525766903,opt,name=success_rate_minimum_hosts,json=successRateMinimumHosts,proto3,oneof" json:"success_rate_minimum_hosts,omitempty"`
	// The minimum number of total requests that must be collected in one interval (as defined by the interval duration above) to include this host in success rate based outlier detection. If the volume is lower than this setting, outlier detection via success rate statistics is not performed for that host. Defaults to 100.
	SuccessRateRequestVolume *int32 `protobuf:"varint,281425357,opt,name=success_rate_request_volume,json=successRateRequestVolume,proto3,oneof" json:"success_rate_request_volume,omitempty"`
	// This factor is used to determine the ejection threshold for success rate outlier ejection. The ejection threshold is the difference between the mean success rate, and the product of this factor and the standard deviation of the mean success rate: mean - (stdev * success_rate_stdev_factor). This factor is divided by a thousand to get a double. That is, if the desired factor is 1.9, the runtime value should be 1900. Defaults to 1900.
	SuccessRateStdevFactor *int32 `protobuf:"varint,174735773,opt,name=success_rate_stdev_factor,json=successRateStdevFactor,proto3,oneof" json:"success_rate_stdev_factor,omitempty"`
}

func (x *OutlierDetection) Reset() {
	*x = OutlierDetection{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[53]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OutlierDetection) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OutlierDetection) ProtoMessage() {}

func (x *OutlierDetection) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[53]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OutlierDetection.ProtoReflect.Descriptor instead.
func (*OutlierDetection) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{53}
}

func (x *OutlierDetection) GetBaseEjectionTime() *Duration {
	if x != nil {
		return x.BaseEjectionTime
	}
	return nil
}

func (x *OutlierDetection) GetConsecutiveErrors() int32 {
	if x != nil && x.ConsecutiveErrors != nil {
		return *x.ConsecutiveErrors
	}
	return 0
}

func (x *OutlierDetection) GetConsecutiveGatewayFailure() int32 {
	if x != nil && x.ConsecutiveGatewayFailure != nil {
		return *x.ConsecutiveGatewayFailure
	}
	return 0
}

func (x *OutlierDetection) GetEnforcingConsecutiveErrors() int32 {
	if x != nil && x.EnforcingConsecutiveErrors != nil {
		return *x.EnforcingConsecutiveErrors
	}
	return 0
}

func (x *OutlierDetection) GetEnforcingConsecutiveGatewayFailure() int32 {
	if x != nil && x.EnforcingConsecutiveGatewayFailure != nil {
		return *x.EnforcingConsecutiveGatewayFailure
	}
	return 0
}

func (x *OutlierDetection) GetEnforcingSuccessRate() int32 {
	if x != nil && x.EnforcingSuccessRate != nil {
		return *x.EnforcingSuccessRate
	}
	return 0
}

func (x *OutlierDetection) GetInterval() *Duration {
	if x != nil {
		return x.Interval
	}
	return nil
}

func (x *OutlierDetection) GetMaxEjectionPercent() int32 {
	if x != nil && x.MaxEjectionPercent != nil {
		return *x.MaxEjectionPercent
	}
	return 0
}

func (x *OutlierDetection) GetSuccessRateMinimumHosts() int32 {
	if x != nil && x.SuccessRateMinimumHosts != nil {
		return *x.SuccessRateMinimumHosts
	}
	return 0
}

func (x *OutlierDetection) GetSuccessRateRequestVolume() int32 {
	if x != nil && x.SuccessRateRequestVolume != nil {
		return *x.SuccessRateRequestVolume
	}
	return 0
}

func (x *OutlierDetection) GetSuccessRateStdevFactor() int32 {
	if x != nil && x.SuccessRateStdevFactor != nil {
		return *x.SuccessRateStdevFactor
	}
	return 0
}

// The authentication and authorization settings for a BackendService.
type SecuritySettings struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. A URL referring to a networksecurity.ClientTlsPolicy resource that describes how clients should authenticate with this service's backends.
	// clientTlsPolicy only applies to a global BackendService with the loadBalancingScheme set to INTERNAL_SELF_MANAGED.
	// If left blank, communications are not encrypted.
	// Note: This field currently has no impact.
	ClientTlsPolicy *string `protobuf:"bytes,462325226,opt,name=client_tls_policy,json=clientTlsPolicy,proto3,oneof" json:"client_tls_policy,omitempty"`
	// Optional. A list of Subject Alternative Names (SANs) that the client verifies during a mutual TLS handshake with an server/endpoint for this BackendService. When the server presents its X.509 certificate to the client, the client inspects the certificate's subjectAltName field. If the field contains one of the specified values, the communication continues. Otherwise, it fails. This additional check enables the client to verify that the server is authorized to run the requested service.
	// Note that the contents of the server certificate's subjectAltName field are configured by the Public Key Infrastructure which provisions server identities.
	// Only applies to a global BackendService with loadBalancingScheme set to INTERNAL_SELF_MANAGED. Only applies when BackendService has an attached clientTlsPolicy with clientCertificate (mTLS mode).
	// Note: This field currently has no impact.
	SubjectAltNames []string `protobuf:"bytes,330029535,rep,name=subject_alt_names,json=subjectAltNames,proto3" json:"subject_alt_names,omitempty"`
}

func (x *SecuritySettings) Reset() {
	*x = SecuritySettings{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[54]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SecuritySettings) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SecuritySettings) ProtoMessage() {}

func (x *SecuritySettings) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[54]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SecuritySettings.ProtoReflect.Descriptor instead.
func (*SecuritySettings) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{54}
}

func (x *SecuritySettings) GetClientTlsPolicy() string {
	if x != nil && x.ClientTlsPolicy != nil {
		return *x.ClientTlsPolicy
	}
	return ""
}

func (x *SecuritySettings) GetSubjectAltNames() []string {
	if x != nil {
		return x.SubjectAltNames
	}
	return nil
}

// Represents a Backend Service resource.
//
// A backend service defines how Google Cloud load balancers distribute traffic. The backend service configuration contains a set of values, such as the protocol used to connect to backends, various distribution and session settings, health checks, and timeouts. These settings provide fine-grained control over how your load balancer behaves. Most of the settings have default values that allow for easy configuration if you need to get started quickly.
//
// Backend services in Google Compute Engine can be either regionally or globally scoped.
//
// * [Global](/compute/docs/reference/rest/{$api_version}/backendServices) * [Regional](/compute/docs/reference/rest/{$api_version}/regionBackendServices)
//
// For more information, see Backend Services.
//
// (== resource_for {$api_version}.backendService ==)
type BackendService struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Lifetime of cookies in seconds. Only applicable if the loadBalancingScheme is EXTERNAL, INTERNAL_SELF_MANAGED, or INTERNAL_MANAGED, the protocol is HTTP or HTTPS, and the sessionAffinity is GENERATED_COOKIE, or HTTP_COOKIE.
	//
	// If set to 0, the cookie is non-persistent and lasts only until the end of the browser session (or equivalent). The maximum allowed value is one day (86,400).
	//
	// Not supported when the backend service is referenced by a URL map that is bound to target gRPC proxy that has validateForProxyless field set to true.
	AffinityCookieTtlSec *int32 `protobuf:"varint,369996954,opt,name=affinity_cookie_ttl_sec,json=affinityCookieTtlSec,proto3,oneof" json:"affinity_cookie_ttl_sec,omitempty"`
	// The list of backends that serve this BackendService.
	Backends []*Backend `protobuf:"bytes,510839903,rep,name=backends,proto3" json:"backends,omitempty"`
	// Cloud CDN configuration for this BackendService. Only available for  external HTTP(S) Load Balancing.
	CdnPolicy *BackendServiceCdnPolicy `protobuf:"bytes,213976452,opt,name=cdn_policy,json=cdnPolicy,proto3,oneof" json:"cdn_policy,omitempty"`
	// Settings controlling the volume of connections to a backend service. If not set, this feature is considered disabled.
	//
	// This field is applicable to either:
	// - A regional backend service with the service_protocol set to HTTP, HTTPS, or HTTP2, and load_balancing_scheme set to INTERNAL_MANAGED.
	// - A global backend service with the load_balancing_scheme set to INTERNAL_SELF_MANAGED.
	//
	// Not supported when the backend service is referenced by a URL map that is bound to target gRPC proxy that has validateForProxyless field set to true.
	CircuitBreakers    *CircuitBreakers    `protobuf:"bytes,421340061,opt,name=circuit_breakers,json=circuitBreakers,proto3,oneof" json:"circuit_breakers,omitempty"`
	ConnectionDraining *ConnectionDraining `protobuf:"bytes,461096747,opt,name=connection_draining,json=connectionDraining,proto3,oneof" json:"connection_draining,omitempty"`
	// Consistent Hash-based load balancing can be used to provide soft session affinity based on HTTP headers, cookies or other properties. This load balancing policy is applicable only for HTTP connections. The affinity to a particular destination host will be lost when one or more hosts are added/removed from the destination service. This field specifies parameters that control consistent hashing. This field is only applicable when localityLbPolicy is set to MAGLEV or RING_HASH.
	//
	// This field is applicable to either:
	// - A regional backend service with the service_protocol set to HTTP, HTTPS, or HTTP2, and load_balancing_scheme set to INTERNAL_MANAGED.
	// - A global backend service with the load_balancing_scheme set to INTERNAL_SELF_MANAGED.
	//
	// Not supported when the backend service is referenced by a URL map that is bound to target gRPC proxy that has validateForProxyless field set to true.
	ConsistentHash *ConsistentHashLoadBalancerSettings `protobuf:"bytes,905883,opt,name=consistent_hash,json=consistentHash,proto3,oneof" json:"consistent_hash,omitempty"`
	// [Output Only] Creation timestamp in RFC3339 text format.
	CreationTimestamp *string `protobuf:"bytes,30525366,opt,name=creation_timestamp,json=creationTimestamp,proto3,oneof" json:"creation_timestamp,omitempty"`
	// Headers that the HTTP/S load balancer should add to proxied requests.
	CustomRequestHeaders []string `protobuf:"bytes,27977992,rep,name=custom_request_headers,json=customRequestHeaders,proto3" json:"custom_request_headers,omitempty"`
	// Headers that the HTTP/S load balancer should add to proxied responses.
	CustomResponseHeaders []string `protobuf:"bytes,387539094,rep,name=custom_response_headers,json=customResponseHeaders,proto3" json:"custom_response_headers,omitempty"`
	// An optional description of this resource. Provide this property when you create the resource.
	Description *string `protobuf:"bytes,422937596,opt,name=description,proto3,oneof" json:"description,omitempty"`
	// If true, enables Cloud CDN for the backend service. Only applicable if the loadBalancingScheme is EXTERNAL and the protocol is HTTP or HTTPS.
	EnableCDN *bool `protobuf:"varint,250733499,opt,name=enable_c_d_n,json=enableCDN,proto3,oneof" json:"enable_c_d_n,omitempty"`
	// Applicable only to Failover for Internal TCP/UDP Load Balancing and Network Load Balancing. Requires at least one backend instance group to be defined as a backup (failover) backend.
	FailoverPolicy *BackendServiceFailoverPolicy `protobuf:"bytes,105658655,opt,name=failover_policy,json=failoverPolicy,proto3,oneof" json:"failover_policy,omitempty"`
	// Fingerprint of this resource. A hash of the contents stored in this object. This field is used in optimistic locking. This field will be ignored when inserting a BackendService. An up-to-date fingerprint must be provided in order to update the BackendService, otherwise the request will fail with error 412 conditionNotMet.
	//
	// To see the latest fingerprint, make a get() request to retrieve a BackendService.
	Fingerprint *string `protobuf:"bytes,234678500,opt,name=fingerprint,proto3,oneof" json:"fingerprint,omitempty"`
	// The list of URLs to the healthChecks, httpHealthChecks (legacy), or httpsHealthChecks (legacy) resource for health checking this backend service. Not all backend services support legacy health checks. See  Load balancer guide. Currently, at most one health check can be specified for each backend service. Backend services with instance group or zonal NEG backends must have a health check. Backend services with internet or serverless NEG backends must not have a health check.
	HealthChecks []string `protobuf:"bytes,448370606,rep,name=health_checks,json=healthChecks,proto3" json:"health_checks,omitempty"`
	// The configurations for Identity-Aware Proxy on this resource. Not available for Internal TCP/UDP Load Balancing and Network Load Balancing.
	Iap *BackendServiceIAP `protobuf:"bytes,104024,opt,name=iap,proto3,oneof" json:"iap,omitempty"`
	// [Output Only] The unique identifier for the resource. This identifier is defined by the server.
	Id *uint64 `protobuf:"varint,3355,opt,name=id,proto3,oneof" json:"id,omitempty"`
	// [Output Only] Type of resource. Always compute#backendService for backend services.
	Kind *string `protobuf:"bytes,3292052,opt,name=kind,proto3,oneof" json:"kind,omitempty"`
	// Specifies the load balancer type. Choose EXTERNAL for external HTTP(S), SSL Proxy, TCP Proxy and Network Load Balancing. Choose  INTERNAL for Internal TCP/UDP Load Balancing. Choose  INTERNAL_MANAGED for Internal HTTP(S) Load Balancing.  INTERNAL_SELF_MANAGED for Traffic Director. A backend service created for one type of load balancer cannot be used with another. For more information, refer to Choosing a load balancer.
	LoadBalancingScheme *BackendService_LoadBalancingScheme `protobuf:"varint,363890244,opt,name=load_balancing_scheme,json=loadBalancingScheme,proto3,enum=google.cloud.compute.v1.BackendService_LoadBalancingScheme,oneof" json:"load_balancing_scheme,omitempty"`
	// The load balancing algorithm used within the scope of the locality. The possible values are:
	// - ROUND_ROBIN: This is a simple policy in which each healthy backend is selected in round robin order. This is the default.
	// - LEAST_REQUEST: An O(1) algorithm which selects two random healthy hosts and picks the host which has fewer active requests.
	// - RING_HASH: The ring/modulo hash load balancer implements consistent hashing to backends. The algorithm has the property that the addition/removal of a host from a set of N hosts only affects 1/N of the requests.
	// - RANDOM: The load balancer selects a random healthy host.
	// - ORIGINAL_DESTINATION: Backend host is selected based on the client connection metadata, i.e., connections are opened to the same address as the destination address of the incoming connection before the connection was redirected to the load balancer.
	// - MAGLEV: used as a drop in replacement for the ring hash load balancer. Maglev is not as stable as ring hash but has faster table lookup build times and host selection times. For more information about Maglev, see https://ai.google/research/pubs/pub44824
	//
	// This field is applicable to either:
	// - A regional backend service with the service_protocol set to HTTP, HTTPS, or HTTP2, and load_balancing_scheme set to INTERNAL_MANAGED.
	// - A global backend service with the load_balancing_scheme set to INTERNAL_SELF_MANAGED.
	//
	// If sessionAffinity is not NONE, and this field is not set to MAGLEV or RING_HASH, session affinity settings will not take effect.
	//
	// Only the default ROUND_ROBIN policy is supported when the backend service is referenced by a URL map that is bound to target gRPC proxy that has validateForProxyless field set to true.
	LocalityLbPolicy *BackendService_LocalityLbPolicy `protobuf:"varint,131431487,opt,name=locality_lb_policy,json=localityLbPolicy,proto3,enum=google.cloud.compute.v1.BackendService_LocalityLbPolicy,oneof" json:"locality_lb_policy,omitempty"`
	// This field denotes the logging options for the load balancer traffic served by this backend service. If logging is enabled, logs will be exported to Stackdriver.
	LogConfig *BackendServiceLogConfig `protobuf:"bytes,351299741,opt,name=log_config,json=logConfig,proto3,oneof" json:"log_config,omitempty"`
	// Specifies the default maximum duration (timeout) for streams to this service. Duration is computed from the beginning of the stream until the response has been completely processed, including all retries. A stream that does not complete in this duration is closed.
	// If not specified, there will be no timeout limit, i.e. the maximum duration is infinite.
	// This field is only allowed when the loadBalancingScheme of the backend service is INTERNAL_SELF_MANAGED.
	MaxStreamDuration *Duration `protobuf:"bytes,61428376,opt,name=max_stream_duration,json=maxStreamDuration,proto3,oneof" json:"max_stream_duration,omitempty"`
	// Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
	Name *string `protobuf:"bytes,3373707,opt,name=name,proto3,oneof" json:"name,omitempty"`
	// The URL of the network to which this backend service belongs. This field can only be specified when the load balancing scheme is set to INTERNAL.
	Network *string `protobuf:"bytes,232872494,opt,name=network,proto3,oneof" json:"network,omitempty"`
	// Settings controlling the eviction of unhealthy hosts from the load balancing pool for the backend service. If not set, this feature is considered disabled.
	//
	// This field is applicable to either:
	// - A regional backend service with the service_protocol set to HTTP, HTTPS, or HTTP2, and load_balancing_scheme set to INTERNAL_MANAGED.
	// - A global backend service with the load_balancing_scheme set to INTERNAL_SELF_MANAGED.
	//
	// Not supported when the backend service is referenced by a URL map that is bound to target gRPC proxy that has validateForProxyless field set to true.
	OutlierDetection *OutlierDetection `protobuf:"bytes,354625086,opt,name=outlier_detection,json=outlierDetection,proto3,oneof" json:"outlier_detection,omitempty"`
	// Deprecated in favor of portName. The TCP port to connect on the backend. The default value is 80.
	//
	// Backend services for Internal TCP/UDP Load Balancing and Network Load Balancing require you omit port.
	Port *int32 `protobuf:"varint,3446913,opt,name=port,proto3,oneof" json:"port,omitempty"`
	// A named port on a backend instance group representing the port for communication to the backend VMs in that group. Required when the loadBalancingScheme is EXTERNAL (except Network Load Balancing), INTERNAL_MANAGED, or  INTERNAL_SELF_MANAGED and the backends are instance groups. The named port must be defined on each backend instance group. This parameter has no meaning if the backends are NEGs.
	//
	//
	//
	// Backend services for Internal TCP/UDP Load Balancing and Network Load Balancing require you omit port_name.
	PortName *string `protobuf:"bytes,41534345,opt,name=port_name,json=portName,proto3,oneof" json:"port_name,omitempty"`
	// The protocol this BackendService uses to communicate with backends.
	//
	// Possible values are HTTP, HTTPS, HTTP2, TCP, SSL, UDP or GRPC. depending on the chosen load balancer or Traffic Director configuration. Refer to the documentation for the load balancer or for Traffic Director for more information.
	//
	// Must be set to GRPC when the backend service is referenced by a URL map that is bound to target gRPC proxy.
	Protocol *BackendService_Protocol `protobuf:"varint,84577944,opt,name=protocol,proto3,enum=google.cloud.compute.v1.BackendService_Protocol,oneof" json:"protocol,omitempty"`
	// [Output Only] URL of the region where the regional backend service resides. This field is not applicable to global backend services. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
	Region *string `protobuf:"bytes,138946292,opt,name=region,proto3,oneof" json:"region,omitempty"`
	// [Output Only] The resource URL for the security policy associated with this backend service.
	SecurityPolicy *string `protobuf:"bytes,171082513,opt,name=security_policy,json=securityPolicy,proto3,oneof" json:"security_policy,omitempty"`
	// This field specifies the security policy that applies to this backend service. This field is applicable to either:
	// - A regional backend service with the service_protocol set to HTTP, HTTPS, or HTTP2, and load_balancing_scheme set to INTERNAL_MANAGED.
	// - A global backend service with the load_balancing_scheme set to INTERNAL_SELF_MANAGED.
	SecuritySettings *SecuritySettings `protobuf:"bytes,478649922,opt,name=security_settings,json=securitySettings,proto3,oneof" json:"security_settings,omitempty"`
	// [Output Only] Server-defined URL for the resource.
	SelfLink *string `protobuf:"bytes,456214797,opt,name=self_link,json=selfLink,proto3,oneof" json:"self_link,omitempty"`
	// Type of session affinity to use. The default is NONE.
	//
	// When the loadBalancingScheme is EXTERNAL: * For Network Load Balancing, the possible values are NONE, CLIENT_IP, CLIENT_IP_PROTO, or  CLIENT_IP_PORT_PROTO. * For all other load balancers that use loadBalancingScheme=EXTERNAL, the possible values are NONE, CLIENT_IP, or GENERATED_COOKIE. * You can use GENERATED_COOKIE if the protocol is HTTP, HTTP2, or HTTPS.
	//
	// When the loadBalancingScheme is INTERNAL, possible values are NONE, CLIENT_IP, CLIENT_IP_PROTO, or CLIENT_IP_PORT_PROTO.
	//
	// When the loadBalancingScheme is INTERNAL_SELF_MANAGED, or INTERNAL_MANAGED, possible values are NONE, CLIENT_IP, GENERATED_COOKIE, HEADER_FIELD, or HTTP_COOKIE.
	//
	// Not supported when the backend service is referenced by a URL map that is bound to target gRPC proxy that has validateForProxyless field set to true.
	SessionAffinity *BackendService_SessionAffinity `protobuf:"varint,463888561,opt,name=session_affinity,json=sessionAffinity,proto3,enum=google.cloud.compute.v1.BackendService_SessionAffinity,oneof" json:"session_affinity,omitempty"`
	// The backend service timeout has a different meaning depending on the type of load balancer. For more information see,  Backend service settings The default is 30 seconds. The full range of timeout values allowed is 1 - 2,147,483,647 seconds.
	TimeoutSec *int32 `protobuf:"varint,79994995,opt,name=timeout_sec,json=timeoutSec,proto3,oneof" json:"timeout_sec,omitempty"`
}

func (x *BackendService) Reset() {
	*x = BackendService{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[55]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BackendService) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BackendService) ProtoMessage() {}

func (x *BackendService) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[55]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BackendService.ProtoReflect.Descriptor instead.
func (*BackendService) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{55}
}

func (x *BackendService) GetAffinityCookieTtlSec() int32 {
	if x != nil && x.AffinityCookieTtlSec != nil {
		return *x.AffinityCookieTtlSec
	}
	return 0
}

func (x *BackendService) GetBackends() []*Backend {
	if x != nil {
		return x.Backends
	}
	return nil
}

func (x *BackendService) GetCdnPolicy() *BackendServiceCdnPolicy {
	if x != nil {
		return x.CdnPolicy
	}
	return nil
}

func (x *BackendService) GetCircuitBreakers() *CircuitBreakers {
	if x != nil {
		return x.CircuitBreakers
	}
	return nil
}

func (x *BackendService) GetConnectionDraining() *ConnectionDraining {
	if x != nil {
		return x.ConnectionDraining
	}
	return nil
}

func (x *BackendService) GetConsistentHash() *ConsistentHashLoadBalancerSettings {
	if x != nil {
		return x.ConsistentHash
	}
	return nil
}

func (x *BackendService) GetCreationTimestamp() string {
	if x != nil && x.CreationTimestamp != nil {
		return *x.CreationTimestamp
	}
	return ""
}

func (x *BackendService) GetCustomRequestHeaders() []string {
	if x != nil {
		return x.CustomRequestHeaders
	}
	return nil
}

func (x *BackendService) GetCustomResponseHeaders() []string {
	if x != nil {
		return x.CustomResponseHeaders
	}
	return nil
}

func (x *BackendService) GetDescription() string {
	if x != nil && x.Description != nil {
		return *x.Description
	}
	return ""
}

func (x *BackendService) GetEnableCDN() bool {
	if x != nil && x.EnableCDN != nil {
		return *x.EnableCDN
	}
	return false
}

func (x *BackendService) GetFailoverPolicy() *BackendServiceFailoverPolicy {
	if x != nil {
		return x.FailoverPolicy
	}
	return nil
}

func (x *BackendService) GetFingerprint() string {
	if x != nil && x.Fingerprint != nil {
		return *x.Fingerprint
	}
	return ""
}

func (x *BackendService) GetHealthChecks() []string {
	if x != nil {
		return x.HealthChecks
	}
	return nil
}

func (x *BackendService) GetIap() *BackendServiceIAP {
	if x != nil {
		return x.Iap
	}
	return nil
}

func (x *BackendService) GetId() uint64 {
	if x != nil && x.Id != nil {
		return *x.Id
	}
	return 0
}

func (x *BackendService) GetKind() string {
	if x != nil && x.Kind != nil {
		return *x.Kind
	}
	return ""
}

func (x *BackendService) GetLoadBalancingScheme() BackendService_LoadBalancingScheme {
	if x != nil && x.LoadBalancingScheme != nil {
		return *x.LoadBalancingScheme
	}
	return BackendService_UNDEFINED_LOAD_BALANCING_SCHEME
}

func (x *BackendService) GetLocalityLbPolicy() BackendService_LocalityLbPolicy {
	if x != nil && x.LocalityLbPolicy != nil {
		return *x.LocalityLbPolicy
	}
	return BackendService_UNDEFINED_LOCALITY_LB_POLICY
}

func (x *BackendService) GetLogConfig() *BackendServiceLogConfig {
	if x != nil {
		return x.LogConfig
	}
	return nil
}

func (x *BackendService) GetMaxStreamDuration() *Duration {
	if x != nil {
		return x.MaxStreamDuration
	}
	return nil
}

func (x *BackendService) GetName() string {
	if x != nil && x.Name != nil {
		return *x.Name
	}
	return ""
}

func (x *BackendService) GetNetwork() string {
	if x != nil && x.Network != nil {
		return *x.Network
	}
	return ""
}

func (x *BackendService) GetOutlierDetection() *OutlierDetection {
	if x != nil {
		return x.OutlierDetection
	}
	return nil
}

func (x *BackendService) GetPort() int32 {
	if x != nil && x.Port != nil {
		return *x.Port
	}
	return 0
}

func (x *BackendService) GetPortName() string {
	if x != nil && x.PortName != nil {
		return *x.PortName
	}
	return ""
}

func (x *BackendService) GetProtocol() BackendService_Protocol {
	if x != nil && x.Protocol != nil {
		return *x.Protocol
	}
	return BackendService_UNDEFINED_PROTOCOL
}

func (x *BackendService) GetRegion() string {
	if x != nil && x.Region != nil {
		return *x.Region
	}
	return ""
}

func (x *BackendService) GetSecurityPolicy() string {
	if x != nil && x.SecurityPolicy != nil {
		return *x.SecurityPolicy
	}
	return ""
}

func (x *BackendService) GetSecuritySettings() *SecuritySettings {
	if x != nil {
		return x.SecuritySettings
	}
	return nil
}

func (x *BackendService) GetSelfLink() string {
	if x != nil && x.SelfLink != nil {
		return *x.SelfLink
	}
	return ""
}

func (x *BackendService) GetSessionAffinity() BackendService_SessionAffinity {
	if x != nil && x.SessionAffinity != nil {
		return *x.SessionAffinity
	}
	return BackendService_UNDEFINED_SESSION_AFFINITY
}

func (x *BackendService) GetTimeoutSec() int32 {
	if x != nil && x.TimeoutSec != nil {
		return *x.TimeoutSec
	}
	return 0
}

//
type BackendServicesScopedList struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A list of BackendServices contained in this scope.
	BackendServices []*BackendService `protobuf:"bytes,388522409,rep,name=backend_services,json=backendServices,proto3" json:"backend_services,omitempty"`
	// Informational warning which replaces the list of backend services when the list is empty.
	Warning *Warning `protobuf:"bytes,50704284,opt,name=warning,proto3,oneof" json:"warning,omitempty"`
}

func (x *BackendServicesScopedList) Reset() {
	*x = BackendServicesScopedList{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[56]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BackendServicesScopedList) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BackendServicesScopedList) ProtoMessage() {}

func (x *BackendServicesScopedList) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[56]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BackendServicesScopedList.ProtoReflect.Descriptor instead.
func (*BackendServicesScopedList) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{56}
}

func (x *BackendServicesScopedList) GetBackendServices() []*BackendService {
	if x != nil {
		return x.BackendServices
	}
	return nil
}

func (x *BackendServicesScopedList) GetWarning() *Warning {
	if x != nil {
		return x.Warning
	}
	return nil
}

// Contains a list of BackendServicesScopedList.
type BackendServiceAggregatedList struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// [Output Only] Unique identifier for the resource; defined by the server.
	Id *string `protobuf:"bytes,3355,opt,name=id,proto3,oneof" json:"id,omitempty"`
	// A list of BackendServicesScopedList resources.
	Items map[string]*BackendServicesScopedList `protobuf:"bytes,100526016,rep,name=items,proto3" json:"items,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Type of resource.
	Kind *string `protobuf:"bytes,3292052,opt,name=kind,proto3,oneof" json:"kind,omitempty"`
	// [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
	NextPageToken *string `protobuf:"bytes,79797525,opt,name=next_page_token,json=nextPageToken,proto3,oneof" json:"next_page_token,omitempty"`
	// [Output Only] Server-defined URL for this resource.
	SelfLink *string `protobuf:"bytes,456214797,opt,name=self_link,json=selfLink,proto3,oneof" json:"self_link,omitempty"`
	// [Output Only] Unreachable resources.
	Unreachables []string `protobuf:"bytes,243372063,rep,name=unreachables,proto3" json:"unreachables,omitempty"`
	// [Output Only] Informational warning message.
	Warning *Warning `protobuf:"bytes,50704284,opt,name=warning,proto3,oneof" json:"warning,omitempty"`
}

func (x *BackendServiceAggregatedList) Reset() {
	*x = BackendServiceAggregatedList{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[57]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BackendServiceAggregatedList) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BackendServiceAggregatedList) ProtoMessage() {}

func (x *BackendServiceAggregatedList) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[57]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BackendServiceAggregatedList.ProtoReflect.Descriptor instead.
func (*BackendServiceAggregatedList) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{57}
}

func (x *BackendServiceAggregatedList) GetId() string {
	if x != nil && x.Id != nil {
		return *x.Id
	}
	return ""
}

func (x *BackendServiceAggregatedList) GetItems() map[string]*BackendServicesScopedList {
	if x != nil {
		return x.Items
	}
	return nil
}

func (x *BackendServiceAggregatedList) GetKind() string {
	if x != nil && x.Kind != nil {
		return *x.Kind
	}
	return ""
}

func (x *BackendServiceAggregatedList) GetNextPageToken() string {
	if x != nil && x.NextPageToken != nil {
		return *x.NextPageToken
	}
	return ""
}

func (x *BackendServiceAggregatedList) GetSelfLink() string {
	if x != nil && x.SelfLink != nil {
		return *x.SelfLink
	}
	return ""
}

func (x *BackendServiceAggregatedList) GetUnreachables() []string {
	if x != nil {
		return x.Unreachables
	}
	return nil
}

func (x *BackendServiceAggregatedList) GetWarning() *Warning {
	if x != nil {
		return x.Warning
	}
	return nil
}

// Bypass the cache when the specified request headers are present, e.g. Pragma or Authorization headers. Values are case insensitive. The presence of such a header overrides the cache_mode setting.
type BackendServiceCdnPolicyBypassCacheOnRequestHeader struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The header field name to match on when bypassing cache. Values are case-insensitive.
	HeaderName *string `protobuf:"bytes,110223613,opt,name=header_name,json=headerName,proto3,oneof" json:"header_name,omitempty"`
}

func (x *BackendServiceCdnPolicyBypassCacheOnRequestHeader) Reset() {
	*x = BackendServiceCdnPolicyBypassCacheOnRequestHeader{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[58]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BackendServiceCdnPolicyBypassCacheOnRequestHeader) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BackendServiceCdnPolicyBypassCacheOnRequestHeader) ProtoMessage() {}

func (x *BackendServiceCdnPolicyBypassCacheOnRequestHeader) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[58]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BackendServiceCdnPolicyBypassCacheOnRequestHeader.ProtoReflect.Descriptor instead.
func (*BackendServiceCdnPolicyBypassCacheOnRequestHeader) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{58}
}

func (x *BackendServiceCdnPolicyBypassCacheOnRequestHeader) GetHeaderName() string {
	if x != nil && x.HeaderName != nil {
		return *x.HeaderName
	}
	return ""
}

// Message containing what to include in the cache key for a request for Cloud CDN.
type CacheKeyPolicy struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// If true, requests to different hosts will be cached separately.
	IncludeHost *bool `protobuf:"varint,486867679,opt,name=include_host,json=includeHost,proto3,oneof" json:"include_host,omitempty"`
	// If true, http and https requests will be cached separately.
	IncludeProtocol *bool `protobuf:"varint,303507535,opt,name=include_protocol,json=includeProtocol,proto3,oneof" json:"include_protocol,omitempty"`
	// If true, include query string parameters in the cache key according to query_string_whitelist and query_string_blacklist. If neither is set, the entire query string will be included. If false, the query string will be excluded from the cache key entirely.
	IncludeQueryString *bool `protobuf:"varint,474036639,opt,name=include_query_string,json=includeQueryString,proto3,oneof" json:"include_query_string,omitempty"`
	// Names of query string parameters to exclude in cache keys. All other parameters will be included. Either specify query_string_whitelist or query_string_blacklist, not both. '&' and '=' will be percent encoded and not treated as delimiters.
	QueryStringBlacklist []string `protobuf:"bytes,354964742,rep,name=query_string_blacklist,json=queryStringBlacklist,proto3" json:"query_string_blacklist,omitempty"`
	// Names of query string parameters to include in cache keys. All other parameters will be excluded. Either specify query_string_whitelist or query_string_blacklist, not both. '&' and '=' will be percent encoded and not treated as delimiters.
	QueryStringWhitelist []string `protobuf:"bytes,52456496,rep,name=query_string_whitelist,json=queryStringWhitelist,proto3" json:"query_string_whitelist,omitempty"`
}

func (x *CacheKeyPolicy) Reset() {
	*x = CacheKeyPolicy{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[59]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CacheKeyPolicy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CacheKeyPolicy) ProtoMessage() {}

func (x *CacheKeyPolicy) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[59]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CacheKeyPolicy.ProtoReflect.Descriptor instead.
func (*CacheKeyPolicy) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{59}
}

func (x *CacheKeyPolicy) GetIncludeHost() bool {
	if x != nil && x.IncludeHost != nil {
		return *x.IncludeHost
	}
	return false
}

func (x *CacheKeyPolicy) GetIncludeProtocol() bool {
	if x != nil && x.IncludeProtocol != nil {
		return *x.IncludeProtocol
	}
	return false
}

func (x *CacheKeyPolicy) GetIncludeQueryString() bool {
	if x != nil && x.IncludeQueryString != nil {
		return *x.IncludeQueryString
	}
	return false
}

func (x *CacheKeyPolicy) GetQueryStringBlacklist() []string {
	if x != nil {
		return x.QueryStringBlacklist
	}
	return nil
}

func (x *CacheKeyPolicy) GetQueryStringWhitelist() []string {
	if x != nil {
		return x.QueryStringWhitelist
	}
	return nil
}

// Specify CDN TTLs for response error codes.
type BackendServiceCdnPolicyNegativeCachingPolicy struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The HTTP status code to define a TTL against. Only HTTP status codes 300, 301, 302, 307, 308, 404, 405, 410, 421, 451 and 501 are can be specified as values, and you cannot specify a status code more than once.
	Code *int32 `protobuf:"varint,3059181,opt,name=code,proto3,oneof" json:"code,omitempty"`
	// The TTL (in seconds) for which to cache responses with the corresponding status code. The maximum allowed value is 1800s (30 minutes), noting that infrequently accessed objects may be evicted from the cache before the defined TTL.
	Ttl *int32 `protobuf:"varint,115180,opt,name=ttl,proto3,oneof" json:"ttl,omitempty"`
}

func (x *BackendServiceCdnPolicyNegativeCachingPolicy) Reset() {
	*x = BackendServiceCdnPolicyNegativeCachingPolicy{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[60]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BackendServiceCdnPolicyNegativeCachingPolicy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BackendServiceCdnPolicyNegativeCachingPolicy) ProtoMessage() {}

func (x *BackendServiceCdnPolicyNegativeCachingPolicy) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[60]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BackendServiceCdnPolicyNegativeCachingPolicy.ProtoReflect.Descriptor instead.
func (*BackendServiceCdnPolicyNegativeCachingPolicy) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{60}
}

func (x *BackendServiceCdnPolicyNegativeCachingPolicy) GetCode() int32 {
	if x != nil && x.Code != nil {
		return *x.Code
	}
	return 0
}

func (x *BackendServiceCdnPolicyNegativeCachingPolicy) GetTtl() int32 {
	if x != nil && x.Ttl != nil {
		return *x.Ttl
	}
	return 0
}

//
type HealthStatus struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Metadata defined as annotations for network endpoint.
	Annotations map[string]string `protobuf:"bytes,112032548,rep,name=annotations,proto3" json:"annotations,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// URL of the forwarding rule associated with the health status of the instance.
	ForwardingRule *string `protobuf:"bytes,269964030,opt,name=forwarding_rule,json=forwardingRule,proto3,oneof" json:"forwarding_rule,omitempty"`
	// A forwarding rule IP address assigned to this instance.
	ForwardingRuleIp *string `protobuf:"bytes,172250632,opt,name=forwarding_rule_ip,json=forwardingRuleIp,proto3,oneof" json:"forwarding_rule_ip,omitempty"`
	// Health state of the instance.
	HealthState *HealthStatus_HealthState `protobuf:"varint,324007150,opt,name=health_state,json=healthState,proto3,enum=google.cloud.compute.v1.HealthStatus_HealthState,oneof" json:"health_state,omitempty"`
	// URL of the instance resource.
	Instance *string `protobuf:"bytes,18257045,opt,name=instance,proto3,oneof" json:"instance,omitempty"`
	// For target pool based Network Load Balancing, it indicates the forwarding rule's IP address assigned to this instance. For other types of load balancing, the field indicates VM internal ip.
	IpAddress *string `protobuf:"bytes,406272220,opt,name=ip_address,json=ipAddress,proto3,oneof" json:"ip_address,omitempty"`
	// The named port of the instance group, not necessarily the port that is health-checked.
	Port        *int32                    `protobuf:"varint,3446913,opt,name=port,proto3,oneof" json:"port,omitempty"`
	Weight      *string                   `protobuf:"bytes,282149496,opt,name=weight,proto3,oneof" json:"weight,omitempty"`
	WeightError *HealthStatus_WeightError `protobuf:"varint,522501505,opt,name=weight_error,json=weightError,proto3,enum=google.cloud.compute.v1.HealthStatus_WeightError,oneof" json:"weight_error,omitempty"`
}

func (x *HealthStatus) Reset() {
	*x = HealthStatus{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[61]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *HealthStatus) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HealthStatus) ProtoMessage() {}

func (x *HealthStatus) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[61]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HealthStatus.ProtoReflect.Descriptor instead.
func (*HealthStatus) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{61}
}

func (x *HealthStatus) GetAnnotations() map[string]string {
	if x != nil {
		return x.Annotations
	}
	return nil
}

func (x *HealthStatus) GetForwardingRule() string {
	if x != nil && x.ForwardingRule != nil {
		return *x.ForwardingRule
	}
	return ""
}

func (x *HealthStatus) GetForwardingRuleIp() string {
	if x != nil && x.ForwardingRuleIp != nil {
		return *x.ForwardingRuleIp
	}
	return ""
}

func (x *HealthStatus) GetHealthState() HealthStatus_HealthState {
	if x != nil && x.HealthState != nil {
		return *x.HealthState
	}
	return HealthStatus_UNDEFINED_HEALTH_STATE
}

func (x *HealthStatus) GetInstance() string {
	if x != nil && x.Instance != nil {
		return *x.Instance
	}
	return ""
}

func (x *HealthStatus) GetIpAddress() string {
	if x != nil && x.IpAddress != nil {
		return *x.IpAddress
	}
	return ""
}

func (x *HealthStatus) GetPort() int32 {
	if x != nil && x.Port != nil {
		return *x.Port
	}
	return 0
}

func (x *HealthStatus) GetWeight() string {
	if x != nil && x.Weight != nil {
		return *x.Weight
	}
	return ""
}

func (x *HealthStatus) GetWeightError() HealthStatus_WeightError {
	if x != nil && x.WeightError != nil {
		return *x.WeightError
	}
	return HealthStatus_UNDEFINED_WEIGHT_ERROR
}

//
type BackendServiceGroupHealth struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Metadata defined as annotations on the network endpoint group.
	Annotations map[string]string `protobuf:"bytes,112032548,rep,name=annotations,proto3" json:"annotations,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Health state of the backend instances or endpoints in requested instance or network endpoint group, determined based on configured health checks.
	HealthStatus []*HealthStatus `protobuf:"bytes,380545845,rep,name=health_status,json=healthStatus,proto3" json:"health_status,omitempty"`
	// [Output Only] Type of resource. Always compute#backendServiceGroupHealth for the health of backend services.
	Kind *string `protobuf:"bytes,3292052,opt,name=kind,proto3,oneof" json:"kind,omitempty"`
}

func (x *BackendServiceGroupHealth) Reset() {
	*x = BackendServiceGroupHealth{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[62]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BackendServiceGroupHealth) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BackendServiceGroupHealth) ProtoMessage() {}

func (x *BackendServiceGroupHealth) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[62]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BackendServiceGroupHealth.ProtoReflect.Descriptor instead.
func (*BackendServiceGroupHealth) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{62}
}

func (x *BackendServiceGroupHealth) GetAnnotations() map[string]string {
	if x != nil {
		return x.Annotations
	}
	return nil
}

func (x *BackendServiceGroupHealth) GetHealthStatus() []*HealthStatus {
	if x != nil {
		return x.HealthStatus
	}
	return nil
}

func (x *BackendServiceGroupHealth) GetKind() string {
	if x != nil && x.Kind != nil {
		return *x.Kind
	}
	return ""
}

// Contains a list of BackendService resources.
type BackendServiceList struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// [Output Only] Unique identifier for the resource; defined by the server.
	Id *string `protobuf:"bytes,3355,opt,name=id,proto3,oneof" json:"id,omitempty"`
	// A list of BackendService resources.
	Items []*BackendService `protobuf:"bytes,100526016,rep,name=items,proto3" json:"items,omitempty"`
	// [Output Only] Type of resource. Always compute#backendServiceList for lists of backend services.
	Kind *string `protobuf:"bytes,3292052,opt,name=kind,proto3,oneof" json:"kind,omitempty"`
	// [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
	NextPageToken *string `protobuf:"bytes,79797525,opt,name=next_page_token,json=nextPageToken,proto3,oneof" json:"next_page_token,omitempty"`
	// [Output Only] Server-defined URL for this resource.
	SelfLink *string `protobuf:"bytes,456214797,opt,name=self_link,json=selfLink,proto3,oneof" json:"self_link,omitempty"`
	// [Output Only] Informational warning message.
	Warning *Warning `protobuf:"bytes,50704284,opt,name=warning,proto3,oneof" json:"warning,omitempty"`
}

func (x *BackendServiceList) Reset() {
	*x = BackendServiceList{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[63]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BackendServiceList) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BackendServiceList) ProtoMessage() {}

func (x *BackendServiceList) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[63]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BackendServiceList.ProtoReflect.Descriptor instead.
func (*BackendServiceList) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{63}
}

func (x *BackendServiceList) GetId() string {
	if x != nil && x.Id != nil {
		return *x.Id
	}
	return ""
}

func (x *BackendServiceList) GetItems() []*BackendService {
	if x != nil {
		return x.Items
	}
	return nil
}

func (x *BackendServiceList) GetKind() string {
	if x != nil && x.Kind != nil {
		return *x.Kind
	}
	return ""
}

func (x *BackendServiceList) GetNextPageToken() string {
	if x != nil && x.NextPageToken != nil {
		return *x.NextPageToken
	}
	return ""
}

func (x *BackendServiceList) GetSelfLink() string {
	if x != nil && x.SelfLink != nil {
		return *x.SelfLink
	}
	return ""
}

func (x *BackendServiceList) GetWarning() *Warning {
	if x != nil {
		return x.Warning
	}
	return nil
}

//
type BackendServiceReference struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	BackendService *string `protobuf:"bytes,306946058,opt,name=backend_service,json=backendService,proto3,oneof" json:"backend_service,omitempty"`
}

func (x *BackendServiceReference) Reset() {
	*x = BackendServiceReference{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[64]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BackendServiceReference) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BackendServiceReference) ProtoMessage() {}

func (x *BackendServiceReference) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[64]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BackendServiceReference.ProtoReflect.Descriptor instead.
func (*BackendServiceReference) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{64}
}

func (x *BackendServiceReference) GetBackendService() string {
	if x != nil && x.BackendService != nil {
		return *x.BackendService
	}
	return ""
}

// Represents a textual expression in the Common Expression Language (CEL) syntax. CEL is a C-like expression language. The syntax and semantics of CEL are documented at https://github.com/google/cel-spec.
//
// Example (Comparison):
//
// title: "Summary size limit" description: "Determines if a summary is less than 100 chars" expression: "document.summary.size() < 100"
//
// Example (Equality):
//
// title: "Requestor is owner" description: "Determines if requestor is the document owner" expression: "document.owner == request.auth.claims.email"
//
// Example (Logic):
//
// title: "Public documents" description: "Determine whether the document should be publicly visible" expression: "document.type != 'private' && document.type != 'internal'"
//
// Example (Data Manipulation):
//
// title: "Notification string" description: "Create a notification string with a timestamp." expression: "'New message received at ' + string(document.create_time)"
//
// The exact variables and functions that may be referenced within an expression are determined by the service that evaluates it. See the service documentation for additional information.
type Expr struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Description of the expression. This is a longer text which describes the expression, e.g. when hovered over it in a UI.
	Description *string `protobuf:"bytes,422937596,opt,name=description,proto3,oneof" json:"description,omitempty"`
	// Textual representation of an expression in Common Expression Language syntax.
	Expression *string `protobuf:"bytes,352031384,opt,name=expression,proto3,oneof" json:"expression,omitempty"`
	// Optional. String indicating the location of the expression for error reporting, e.g. a file name and a position in the file.
	Location *string `protobuf:"bytes,290430901,opt,name=location,proto3,oneof" json:"location,omitempty"`
	// Optional. Title for the expression, i.e. a short string describing its purpose. This can be used e.g. in UIs which allow to enter the expression.
	Title *string `protobuf:"bytes,110371416,opt,name=title,proto3,oneof" json:"title,omitempty"`
}

func (x *Expr) Reset() {
	*x = Expr{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[65]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Expr) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Expr) ProtoMessage() {}

func (x *Expr) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[65]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Expr.ProtoReflect.Descriptor instead.
func (*Expr) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{65}
}

func (x *Expr) GetDescription() string {
	if x != nil && x.Description != nil {
		return *x.Description
	}
	return ""
}

func (x *Expr) GetExpression() string {
	if x != nil && x.Expression != nil {
		return *x.Expression
	}
	return ""
}

func (x *Expr) GetLocation() string {
	if x != nil && x.Location != nil {
		return *x.Location
	}
	return ""
}

func (x *Expr) GetTitle() string {
	if x != nil && x.Title != nil {
		return *x.Title
	}
	return ""
}

// Associates `members` with a `role`.
type Binding struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	BindingId *string `protobuf:"bytes,441088277,opt,name=binding_id,json=bindingId,proto3,oneof" json:"binding_id,omitempty"`
	// The condition that is associated with this binding.
	//
	// If the condition evaluates to `true`, then this binding applies to the current request.
	//
	// If the condition evaluates to `false`, then this binding does not apply to the current request. However, a different role binding might grant the same role to one or more of the members in this binding.
	//
	// To learn which resources support conditions in their IAM policies, see the [IAM documentation](https://cloud.google.com/iam/help/conditions/resource-policies).
	Condition *Expr `protobuf:"bytes,212430107,opt,name=condition,proto3,oneof" json:"condition,omitempty"`
	// Specifies the identities requesting access for a Cloud Platform resource. `members` can have the following values:
	//
	// * `allUsers`: A special identifier that represents anyone who is on the internet; with or without a Google account.
	//
	// * `allAuthenticatedUsers`: A special identifier that represents anyone who is authenticated with a Google account or a service account.
	//
	// * `user:{emailid}`: An email address that represents a specific Google account. For example, `alice@example.com` .
	//
	//
	//
	// * `serviceAccount:{emailid}`: An email address that represents a service account. For example, `my-other-app@appspot.gserviceaccount.com`.
	//
	// * `group:{emailid}`: An email address that represents a Google group. For example, `admins@example.com`.
	//
	// * `deleted:user:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a user that has been recently deleted. For example, `alice@example.com?uid=123456789012345678901`. If the user is recovered, this value reverts to `user:{emailid}` and the recovered user retains the role in the binding.
	//
	// * `deleted:serviceAccount:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a service account that has been recently deleted. For example, `my-other-app@appspot.gserviceaccount.com?uid=123456789012345678901`. If the service account is undeleted, this value reverts to `serviceAccount:{emailid}` and the undeleted service account retains the role in the binding.
	//
	// * `deleted:group:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a Google group that has been recently deleted. For example, `admins@example.com?uid=123456789012345678901`. If the group is recovered, this value reverts to `group:{emailid}` and the recovered group retains the role in the binding.
	//
	//
	//
	// * `domain:{domain}`: The G Suite domain (primary) that represents all the users of that domain. For example, `google.com` or `example.com`.
	Members []string `protobuf:"bytes,412010777,rep,name=members,proto3" json:"members,omitempty"`
	// Role that is assigned to `members`. For example, `roles/viewer`, `roles/editor`, or `roles/owner`.
	Role *string `protobuf:"bytes,3506294,opt,name=role,proto3,oneof" json:"role,omitempty"`
}

func (x *Binding) Reset() {
	*x = Binding{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[66]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Binding) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Binding) ProtoMessage() {}

func (x *Binding) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[66]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Binding.ProtoReflect.Descriptor instead.
func (*Binding) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{66}
}

func (x *Binding) GetBindingId() string {
	if x != nil && x.BindingId != nil {
		return *x.BindingId
	}
	return ""
}

func (x *Binding) GetCondition() *Expr {
	if x != nil {
		return x.Condition
	}
	return nil
}

func (x *Binding) GetMembers() []string {
	if x != nil {
		return x.Members
	}
	return nil
}

func (x *Binding) GetRole() string {
	if x != nil && x.Role != nil {
		return *x.Role
	}
	return ""
}

//
type InstanceProperties struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Controls for advanced machine-related behavior features.
	AdvancedMachineFeatures *AdvancedMachineFeatures `protobuf:"bytes,409646002,opt,name=advanced_machine_features,json=advancedMachineFeatures,proto3,oneof" json:"advanced_machine_features,omitempty"`
	// Enables instances created based on these properties to send packets with source IP addresses other than their own and receive packets with destination IP addresses other than their own. If these instances will be used as an IP gateway or it will be set as the next-hop in a Route resource, specify true. If unsure, leave this set to false. See the Enable IP forwarding documentation for more information.
	CanIpForward *bool `protobuf:"varint,467731324,opt,name=can_ip_forward,json=canIpForward,proto3,oneof" json:"can_ip_forward,omitempty"`
	// Specifies the Confidential Instance options.
	ConfidentialInstanceConfig *ConfidentialInstanceConfig `protobuf:"bytes,490637685,opt,name=confidential_instance_config,json=confidentialInstanceConfig,proto3,oneof" json:"confidential_instance_config,omitempty"`
	// An optional text description for the instances that are created from these properties.
	Description *string `protobuf:"bytes,422937596,opt,name=description,proto3,oneof" json:"description,omitempty"`
	// An array of disks that are associated with the instances that are created from these properties.
	Disks []*AttachedDisk `protobuf:"bytes,95594102,rep,name=disks,proto3" json:"disks,omitempty"`
	// A list of guest accelerator cards' type and count to use for instances created from these properties.
	GuestAccelerators []*AcceleratorConfig `protobuf:"bytes,463595119,rep,name=guest_accelerators,json=guestAccelerators,proto3" json:"guest_accelerators,omitempty"`
	// Labels to apply to instances that are created from these properties.
	Labels map[string]string `protobuf:"bytes,500195327,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// The machine type to use for instances that are created from these properties.
	MachineType *string `protobuf:"bytes,227711026,opt,name=machine_type,json=machineType,proto3,oneof" json:"machine_type,omitempty"`
	// The metadata key/value pairs to assign to instances that are created from these properties. These pairs can consist of custom metadata or predefined keys. See Project and instance metadata for more information.
	Metadata *Metadata `protobuf:"bytes,86866735,opt,name=metadata,proto3,oneof" json:"metadata,omitempty"`
	// Minimum cpu/platform to be used by instances. The instance may be scheduled on the specified or newer cpu/platform. Applicable values are the friendly names of CPU platforms, such as minCpuPlatform: "Intel Haswell" or minCpuPlatform: "Intel Sandy Bridge". For more information, read Specifying a Minimum CPU Platform.
	MinCpuPlatform *string `protobuf:"bytes,242912759,opt,name=min_cpu_platform,json=minCpuPlatform,proto3,oneof" json:"min_cpu_platform,omitempty"`
	// An array of network access configurations for this interface.
	NetworkInterfaces []*NetworkInterface `protobuf:"bytes,52735243,rep,name=network_interfaces,json=networkInterfaces,proto3" json:"network_interfaces,omitempty"`
	// The private IPv6 google access type for VMs. If not specified, use  INHERIT_FROM_SUBNETWORK as default.
	PrivateIpv6GoogleAccess *InstanceProperties_PrivateIpv6GoogleAccess `protobuf:"varint,48277006,opt,name=private_ipv6_google_access,json=privateIpv6GoogleAccess,proto3,enum=google.cloud.compute.v1.InstanceProperties_PrivateIpv6GoogleAccess,oneof" json:"private_ipv6_google_access,omitempty"`
	// Specifies the reservations that instances can consume from.
	ReservationAffinity *ReservationAffinity `protobuf:"bytes,157850683,opt,name=reservation_affinity,json=reservationAffinity,proto3,oneof" json:"reservation_affinity,omitempty"`
	// Resource policies (names, not ULRs) applied to instances created from these properties.
	ResourcePolicies []string `protobuf:"bytes,22220385,rep,name=resource_policies,json=resourcePolicies,proto3" json:"resource_policies,omitempty"`
	// Specifies the scheduling options for the instances that are created from these properties.
	Scheduling *Scheduling `protobuf:"bytes,386688404,opt,name=scheduling,proto3,oneof" json:"scheduling,omitempty"`
	// A list of service accounts with specified scopes. Access tokens for these service accounts are available to the instances that are created from these properties. Use metadata queries to obtain the access tokens for these instances.
	ServiceAccounts        []*ServiceAccount       `protobuf:"bytes,277537328,rep,name=service_accounts,json=serviceAccounts,proto3" json:"service_accounts,omitempty"`
	ShieldedInstanceConfig *ShieldedInstanceConfig `protobuf:"bytes,12862901,opt,name=shielded_instance_config,json=shieldedInstanceConfig,proto3,oneof" json:"shielded_instance_config,omitempty"`
	// A list of tags to apply to the instances that are created from these properties. The tags identify valid sources or targets for network firewalls. The setTags method can modify this list of tags. Each tag within the list must comply with RFC1035.
	Tags *Tags `protobuf:"bytes,3552281,opt,name=tags,proto3,oneof" json:"tags,omitempty"`
}

func (x *InstanceProperties) Reset() {
	*x = InstanceProperties{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[67]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *InstanceProperties) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InstanceProperties) ProtoMessage() {}

func (x *InstanceProperties) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[67]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InstanceProperties.ProtoReflect.Descriptor instead.
func (*InstanceProperties) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{67}
}

func (x *InstanceProperties) GetAdvancedMachineFeatures() *AdvancedMachineFeatures {
	if x != nil {
		return x.AdvancedMachineFeatures
	}
	return nil
}

func (x *InstanceProperties) GetCanIpForward() bool {
	if x != nil && x.CanIpForward != nil {
		return *x.CanIpForward
	}
	return false
}

func (x *InstanceProperties) GetConfidentialInstanceConfig() *ConfidentialInstanceConfig {
	if x != nil {
		return x.ConfidentialInstanceConfig
	}
	return nil
}

func (x *InstanceProperties) GetDescription() string {
	if x != nil && x.Description != nil {
		return *x.Description
	}
	return ""
}

func (x *InstanceProperties) GetDisks() []*AttachedDisk {
	if x != nil {
		return x.Disks
	}
	return nil
}

func (x *InstanceProperties) GetGuestAccelerators() []*AcceleratorConfig {
	if x != nil {
		return x.GuestAccelerators
	}
	return nil
}

func (x *InstanceProperties) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *InstanceProperties) GetMachineType() string {
	if x != nil && x.MachineType != nil {
		return *x.MachineType
	}
	return ""
}

func (x *InstanceProperties) GetMetadata() *Metadata {
	if x != nil {
		return x.Metadata
	}
	return nil
}

func (x *InstanceProperties) GetMinCpuPlatform() string {
	if x != nil && x.MinCpuPlatform != nil {
		return *x.MinCpuPlatform
	}
	return ""
}

func (x *InstanceProperties) GetNetworkInterfaces() []*NetworkInterface {
	if x != nil {
		return x.NetworkInterfaces
	}
	return nil
}

func (x *InstanceProperties) GetPrivateIpv6GoogleAccess() InstanceProperties_PrivateIpv6GoogleAccess {
	if x != nil && x.PrivateIpv6GoogleAccess != nil {
		return *x.PrivateIpv6GoogleAccess
	}
	return InstanceProperties_UNDEFINED_PRIVATE_IPV6_GOOGLE_ACCESS
}

func (x *InstanceProperties) GetReservationAffinity() *ReservationAffinity {
	if x != nil {
		return x.ReservationAffinity
	}
	return nil
}

func (x *InstanceProperties) GetResourcePolicies() []string {
	if x != nil {
		return x.ResourcePolicies
	}
	return nil
}

func (x *InstanceProperties) GetScheduling() *Scheduling {
	if x != nil {
		return x.Scheduling
	}
	return nil
}

func (x *InstanceProperties) GetServiceAccounts() []*ServiceAccount {
	if x != nil {
		return x.ServiceAccounts
	}
	return nil
}

func (x *InstanceProperties) GetShieldedInstanceConfig() *ShieldedInstanceConfig {
	if x != nil {
		return x.ShieldedInstanceConfig
	}
	return nil
}

func (x *InstanceProperties) GetTags() *Tags {
	if x != nil {
		return x.Tags
	}
	return nil
}

// Configuration for location policy among multiple possible locations (e.g. preferences for zone selection among zones in a single region).
type LocationPolicy struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Location configurations mapped by location name. Currently only zone names are supported and must be represented as valid internal URLs, such as zones/us-central1-a.
	Locations map[string]*LocationPolicyLocation `protobuf:"bytes,413423454,rep,name=locations,proto3" json:"locations,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *LocationPolicy) Reset() {
	*x = LocationPolicy{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[68]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LocationPolicy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LocationPolicy) ProtoMessage() {}

func (x *LocationPolicy) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[68]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LocationPolicy.ProtoReflect.Descriptor instead.
func (*LocationPolicy) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{68}
}

func (x *LocationPolicy) GetLocations() map[string]*LocationPolicyLocation {
	if x != nil {
		return x.Locations
	}
	return nil
}

// Per-instance properties to be set on individual instances. To be extended in the future.
type BulkInsertInstanceResourcePerInstanceProperties struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// This field is only temporary. It will be removed. Do not use it.
	Name *string `protobuf:"bytes,3373707,opt,name=name,proto3,oneof" json:"name,omitempty"`
}

func (x *BulkInsertInstanceResourcePerInstanceProperties) Reset() {
	*x = BulkInsertInstanceResourcePerInstanceProperties{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[69]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BulkInsertInstanceResourcePerInstanceProperties) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BulkInsertInstanceResourcePerInstanceProperties) ProtoMessage() {}

func (x *BulkInsertInstanceResourcePerInstanceProperties) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[69]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BulkInsertInstanceResourcePerInstanceProperties.ProtoReflect.Descriptor instead.
func (*BulkInsertInstanceResourcePerInstanceProperties) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{69}
}

func (x *BulkInsertInstanceResourcePerInstanceProperties) GetName() string {
	if x != nil && x.Name != nil {
		return *x.Name
	}
	return ""
}

//
type BulkInsertInstanceResource struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The maximum number of instances to create.
	Count *int64 `protobuf:"varint,94851343,opt,name=count,proto3,oneof" json:"count,omitempty"`
	// The instance properties defining the VM instances to be created. Required if sourceInstanceTemplate is not provided.
	InstanceProperties *InstanceProperties `protobuf:"bytes,215355165,opt,name=instance_properties,json=instanceProperties,proto3,oneof" json:"instance_properties,omitempty"`
	// Policy for chosing target zone.
	LocationPolicy *LocationPolicy `protobuf:"bytes,465689852,opt,name=location_policy,json=locationPolicy,proto3,oneof" json:"location_policy,omitempty"`
	// The minimum number of instances to create. If no min_count is specified then count is used as the default value. If min_count instances cannot be created, then no instances will be created and instances already created will be deleted.
	MinCount *int64 `protobuf:"varint,523228386,opt,name=min_count,json=minCount,proto3,oneof" json:"min_count,omitempty"`
	// The string pattern used for the names of the VMs. Either name_pattern or per_instance_properties must be set. The pattern should contain one continuous sequence of placeholder hash characters (#) with each character corresponding to one digit of the generated instance name. Example: name_pattern of inst-#### will generate instance names such as inst-0001, inst-0002, ... . If there already exist instance(s) whose names match the name pattern in the same project and zone, then the generated instance numbers will start after the biggest existing number. For example, if there exists an instance with name inst-0050, then instance names generated using the pattern inst-#### will be inst-0051, inst-0052, etc. The name pattern placeholder #...# can contain up to 18 characters.
	NamePattern *string `protobuf:"bytes,413815260,opt,name=name_pattern,json=namePattern,proto3,oneof" json:"name_pattern,omitempty"`
	// Per-instance properties to be set on individual instances. Keys of this map specify requested instance names. Can be empty if name_pattern is used.
	PerInstanceProperties map[string]*BulkInsertInstanceResourcePerInstanceProperties `protobuf:"bytes,108502267,rep,name=per_instance_properties,json=perInstanceProperties,proto3" json:"per_instance_properties,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Specifies the instance template from which to create instances. You may combine sourceInstanceTemplate with instanceProperties to override specific values from an existing instance template. Bulk API follows the semantics of JSON Merge Patch described by RFC 7396.
	//
	// It can be a full or partial URL. For example, the following are all valid URLs to an instance template:
	// - https://www.googleapis.com/compute/v1/projects/project/global/instanceTemplates/instanceTemplate
	// - projects/project/global/instanceTemplates/instanceTemplate
	// - global/instanceTemplates/instanceTemplate
	//
	// This field is optional.
	SourceInstanceTemplate *string `protobuf:"bytes,332423616,opt,name=source_instance_template,json=sourceInstanceTemplate,proto3,oneof" json:"source_instance_template,omitempty"`
}

func (x *BulkInsertInstanceResource) Reset() {
	*x = BulkInsertInstanceResource{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[70]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BulkInsertInstanceResource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BulkInsertInstanceResource) ProtoMessage() {}

func (x *BulkInsertInstanceResource) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[70]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BulkInsertInstanceResource.ProtoReflect.Descriptor instead.
func (*BulkInsertInstanceResource) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{70}
}

func (x *BulkInsertInstanceResource) GetCount() int64 {
	if x != nil && x.Count != nil {
		return *x.Count
	}
	return 0
}

func (x *BulkInsertInstanceResource) GetInstanceProperties() *InstanceProperties {
	if x != nil {
		return x.InstanceProperties
	}
	return nil
}

func (x *BulkInsertInstanceResource) GetLocationPolicy() *LocationPolicy {
	if x != nil {
		return x.LocationPolicy
	}
	return nil
}

func (x *BulkInsertInstanceResource) GetMinCount() int64 {
	if x != nil && x.MinCount != nil {
		return *x.MinCount
	}
	return 0
}

func (x *BulkInsertInstanceResource) GetNamePattern() string {
	if x != nil && x.NamePattern != nil {
		return *x.NamePattern
	}
	return ""
}

func (x *BulkInsertInstanceResource) GetPerInstanceProperties() map[string]*BulkInsertInstanceResourcePerInstanceProperties {
	if x != nil {
		return x.PerInstanceProperties
	}
	return nil
}

func (x *BulkInsertInstanceResource) GetSourceInstanceTemplate() string {
	if x != nil && x.SourceInstanceTemplate != nil {
		return *x.SourceInstanceTemplate
	}
	return ""
}

//
type CacheInvalidationRule struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// If set, this invalidation rule will only apply to requests with a Host header matching host.
	Host *string `protobuf:"bytes,3208616,opt,name=host,proto3,oneof" json:"host,omitempty"`
	Path *string `protobuf:"bytes,3433509,opt,name=path,proto3,oneof" json:"path,omitempty"`
}

func (x *CacheInvalidationRule) Reset() {
	*x = CacheInvalidationRule{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[71]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CacheInvalidationRule) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CacheInvalidationRule) ProtoMessage() {}

func (x *CacheInvalidationRule) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[71]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CacheInvalidationRule.ProtoReflect.Descriptor instead.
func (*CacheInvalidationRule) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{71}
}

func (x *CacheInvalidationRule) GetHost() string {
	if x != nil && x.Host != nil {
		return *x.Host
	}
	return ""
}

func (x *CacheInvalidationRule) GetPath() string {
	if x != nil && x.Path != nil {
		return *x.Path
	}
	return ""
}

// Commitment for a particular license resource.
type LicenseResourceCommitment struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The number of licenses purchased.
	Amount *int64 `protobuf:"varint,196759640,opt,name=amount,proto3,oneof" json:"amount,omitempty"`
	// Specifies the core range of the instance for which this license applies.
	CoresPerLicense *string `protobuf:"bytes,32482324,opt,name=cores_per_license,json=coresPerLicense,proto3,oneof" json:"cores_per_license,omitempty"`
	// Any applicable license URI.
	License *string `protobuf:"bytes,166757441,opt,name=license,proto3,oneof" json:"license,omitempty"`
}

func (x *LicenseResourceCommitment) Reset() {
	*x = LicenseResourceCommitment{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[72]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LicenseResourceCommitment) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LicenseResourceCommitment) ProtoMessage() {}

func (x *LicenseResourceCommitment) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[72]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LicenseResourceCommitment.ProtoReflect.Descriptor instead.
func (*LicenseResourceCommitment) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{72}
}

func (x *LicenseResourceCommitment) GetAmount() int64 {
	if x != nil && x.Amount != nil {
		return *x.Amount
	}
	return 0
}

func (x *LicenseResourceCommitment) GetCoresPerLicense() string {
	if x != nil && x.CoresPerLicense != nil {
		return *x.CoresPerLicense
	}
	return ""
}

func (x *LicenseResourceCommitment) GetLicense() string {
	if x != nil && x.License != nil {
		return *x.License
	}
	return ""
}

// Represents a reservation resource. A reservation ensures that capacity is held in a specific zone even if the reserved VMs are not running. For more information, read  Reserving zonal resources. (== resource_for {$api_version}.reservations ==)
type Reservation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// [Output Only] Full or partial URL to a parent commitment. This field displays for reservations that are tied to a commitment.
	Commitment *string `protobuf:"bytes,482134805,opt,name=commitment,proto3,oneof" json:"commitment,omitempty"`
	// [Output Only] Creation timestamp in RFC3339 text format.
	CreationTimestamp *string `protobuf:"bytes,30525366,opt,name=creation_timestamp,json=creationTimestamp,proto3,oneof" json:"creation_timestamp,omitempty"`
	// An optional description of this resource. Provide this property when you create the resource.
	Description *string `protobuf:"bytes,422937596,opt,name=description,proto3,oneof" json:"description,omitempty"`
	// [Output Only] The unique identifier for the resource. This identifier is defined by the server.
	Id *uint64 `protobuf:"varint,3355,opt,name=id,proto3,oneof" json:"id,omitempty"`
	// [Output Only] Type of the resource. Always compute#reservations for reservations.
	Kind *string `protobuf:"bytes,3292052,opt,name=kind,proto3,oneof" json:"kind,omitempty"`
	// The name of the resource, provided by the client when initially creating the resource. The resource name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
	Name *string `protobuf:"bytes,3373707,opt,name=name,proto3,oneof" json:"name,omitempty"`
	// [Output Only] Reserved for future use.
	SatisfiesPzs *bool `protobuf:"varint,480964267,opt,name=satisfies_pzs,json=satisfiesPzs,proto3,oneof" json:"satisfies_pzs,omitempty"`
	// [Output Only] Server-defined fully-qualified URL for this resource.
	SelfLink *string `protobuf:"bytes,456214797,opt,name=self_link,json=selfLink,proto3,oneof" json:"self_link,omitempty"`
	// Reservation for instances with specific machine shapes.
	SpecificReservation *AllocationSpecificSKUReservation `protobuf:"bytes,404901951,opt,name=specific_reservation,json=specificReservation,proto3,oneof" json:"specific_reservation,omitempty"`
	// Indicates whether the reservation can be consumed by VMs with affinity for "any" reservation. If the field is set, then only VMs that target the reservation by name can consume from this reservation.
	SpecificReservationRequired *bool `protobuf:"varint,226550687,opt,name=specific_reservation_required,json=specificReservationRequired,proto3,oneof" json:"specific_reservation_required,omitempty"`
	// [Output Only] The status of the reservation.
	Status *Reservation_Status `protobuf:"varint,181260274,opt,name=status,proto3,enum=google.cloud.compute.v1.Reservation_Status,oneof" json:"status,omitempty"`
	// Zone in which the reservation resides. A zone must be provided if the reservation is created within a commitment.
	Zone *string `protobuf:"bytes,3744684,opt,name=zone,proto3,oneof" json:"zone,omitempty"`
}

func (x *Reservation) Reset() {
	*x = Reservation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[73]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Reservation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Reservation) ProtoMessage() {}

func (x *Reservation) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[73]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Reservation.ProtoReflect.Descriptor instead.
func (*Reservation) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{73}
}

func (x *Reservation) GetCommitment() string {
	if x != nil && x.Commitment != nil {
		return *x.Commitment
	}
	return ""
}

func (x *Reservation) GetCreationTimestamp() string {
	if x != nil && x.CreationTimestamp != nil {
		return *x.CreationTimestamp
	}
	return ""
}

func (x *Reservation) GetDescription() string {
	if x != nil && x.Description != nil {
		return *x.Description
	}
	return ""
}

func (x *Reservation) GetId() uint64 {
	if x != nil && x.Id != nil {
		return *x.Id
	}
	return 0
}

func (x *Reservation) GetKind() string {
	if x != nil && x.Kind != nil {
		return *x.Kind
	}
	return ""
}

func (x *Reservation) GetName() string {
	if x != nil && x.Name != nil {
		return *x.Name
	}
	return ""
}

func (x *Reservation) GetSatisfiesPzs() bool {
	if x != nil && x.SatisfiesPzs != nil {
		return *x.SatisfiesPzs
	}
	return false
}

func (x *Reservation) GetSelfLink() string {
	if x != nil && x.SelfLink != nil {
		return *x.SelfLink
	}
	return ""
}

func (x *Reservation) GetSpecificReservation() *AllocationSpecificSKUReservation {
	if x != nil {
		return x.SpecificReservation
	}
	return nil
}

func (x *Reservation) GetSpecificReservationRequired() bool {
	if x != nil && x.SpecificReservationRequired != nil {
		return *x.SpecificReservationRequired
	}
	return false
}

func (x *Reservation) GetStatus() Reservation_Status {
	if x != nil && x.Status != nil {
		return *x.Status
	}
	return Reservation_UNDEFINED_STATUS
}

func (x *Reservation) GetZone() string {
	if x != nil && x.Zone != nil {
		return *x.Zone
	}
	return ""
}

// Commitment for a particular resource (a Commitment is composed of one or more of these).
type ResourceCommitment struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of the accelerator type resource. Applicable only when the type is ACCELERATOR.
	AcceleratorType *string `protobuf:"bytes,138031246,opt,name=accelerator_type,json=acceleratorType,proto3,oneof" json:"accelerator_type,omitempty"`
	// The amount of the resource purchased (in a type-dependent unit, such as bytes). For vCPUs, this can just be an integer. For memory, this must be provided in MB. Memory must be a multiple of 256 MB, with up to 6.5GB of memory per every vCPU.
	Amount *int64 `protobuf:"varint,196759640,opt,name=amount,proto3,oneof" json:"amount,omitempty"`
	// Type of resource for which this commitment applies. Possible values are VCPU and MEMORY
	Type *ResourceCommitment_Type `protobuf:"varint,3575610,opt,name=type,proto3,enum=google.cloud.compute.v1.ResourceCommitment_Type,oneof" json:"type,omitempty"`
}

func (x *ResourceCommitment) Reset() {
	*x = ResourceCommitment{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[74]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ResourceCommitment) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ResourceCommitment) ProtoMessage() {}

func (x *ResourceCommitment) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[74]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ResourceCommitment.ProtoReflect.Descriptor instead.
func (*ResourceCommitment) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{74}
}

func (x *ResourceCommitment) GetAcceleratorType() string {
	if x != nil && x.AcceleratorType != nil {
		return *x.AcceleratorType
	}
	return ""
}

func (x *ResourceCommitment) GetAmount() int64 {
	if x != nil && x.Amount != nil {
		return *x.Amount
	}
	return 0
}

func (x *ResourceCommitment) GetType() ResourceCommitment_Type {
	if x != nil && x.Type != nil {
		return *x.Type
	}
	return ResourceCommitment_UNDEFINED_TYPE
}

// Represents a regional Commitment resource.
//
// Creating a commitment resource means that you are purchasing a committed use contract with an explicit start and end time. You can create commitments based on vCPUs and memory usage and receive discounted rates. For full details, read Signing Up for Committed Use Discounts. (== resource_for {$api_version}.regionCommitments ==)
type Commitment struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The category of the commitment. Category MACHINE specifies commitments composed of machine resources such as VCPU or MEMORY, listed in resources. Category LICENSE specifies commitments composed of software licenses, listed in licenseResources. Note that only MACHINE commitments should have a Type specified.
	Category *Commitment_Category `protobuf:"varint,50511102,opt,name=category,proto3,enum=google.cloud.compute.v1.Commitment_Category,oneof" json:"category,omitempty"`
	// [Output Only] Creation timestamp in RFC3339 text format.
	CreationTimestamp *string `protobuf:"bytes,30525366,opt,name=creation_timestamp,json=creationTimestamp,proto3,oneof" json:"creation_timestamp,omitempty"`
	// An optional description of this resource. Provide this property when you create the resource.
	Description *string `protobuf:"bytes,422937596,opt,name=description,proto3,oneof" json:"description,omitempty"`
	// [Output Only] Commitment end time in RFC3339 text format.
	EndTimestamp *string `protobuf:"bytes,468096690,opt,name=end_timestamp,json=endTimestamp,proto3,oneof" json:"end_timestamp,omitempty"`
	// [Output Only] The unique identifier for the resource. This identifier is defined by the server.
	Id *uint64 `protobuf:"varint,3355,opt,name=id,proto3,oneof" json:"id,omitempty"`
	// [Output Only] Type of the resource. Always compute#commitment for commitments.
	Kind *string `protobuf:"bytes,3292052,opt,name=kind,proto3,oneof" json:"kind,omitempty"`
	// The license specification required as part of a license commitment.
	LicenseResource *LicenseResourceCommitment `protobuf:"bytes,437955148,opt,name=license_resource,json=licenseResource,proto3,oneof" json:"license_resource,omitempty"`
	// Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
	Name *string `protobuf:"bytes,3373707,opt,name=name,proto3,oneof" json:"name,omitempty"`
	// The plan for this commitment, which determines duration and discount rate. The currently supported plans are TWELVE_MONTH (1 year), and THIRTY_SIX_MONTH (3 years).
	Plan *Commitment_Plan `protobuf:"varint,3443497,opt,name=plan,proto3,enum=google.cloud.compute.v1.Commitment_Plan,oneof" json:"plan,omitempty"`
	// [Output Only] URL of the region where this commitment may be used.
	Region *string `protobuf:"bytes,138946292,opt,name=region,proto3,oneof" json:"region,omitempty"`
	// List of reservations in this commitment.
	Reservations []*Reservation `protobuf:"bytes,399717927,rep,name=reservations,proto3" json:"reservations,omitempty"`
	// A list of commitment amounts for particular resources. Note that VCPU and MEMORY resource commitments must occur together.
	Resources []*ResourceCommitment `protobuf:"bytes,164412965,rep,name=resources,proto3" json:"resources,omitempty"`
	// [Output Only] Server-defined URL for the resource.
	SelfLink *string `protobuf:"bytes,456214797,opt,name=self_link,json=selfLink,proto3,oneof" json:"self_link,omitempty"`
	// [Output Only] Commitment start time in RFC3339 text format.
	StartTimestamp *string `protobuf:"bytes,83645817,opt,name=start_timestamp,json=startTimestamp,proto3,oneof" json:"start_timestamp,omitempty"`
	// [Output Only] Status of the commitment with regards to eventual expiration (each commitment has an end date defined). One of the following values: NOT_YET_ACTIVE, ACTIVE, EXPIRED.
	Status *Commitment_Status `protobuf:"varint,181260274,opt,name=status,proto3,enum=google.cloud.compute.v1.Commitment_Status,oneof" json:"status,omitempty"`
	// [Output Only] An optional, human-readable explanation of the status.
	StatusMessage *string `protobuf:"bytes,297428154,opt,name=status_message,json=statusMessage,proto3,oneof" json:"status_message,omitempty"`
}

func (x *Commitment) Reset() {
	*x = Commitment{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[75]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Commitment) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Commitment) ProtoMessage() {}

func (x *Commitment) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[75]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Commitment.ProtoReflect.Descriptor instead.
func (*Commitment) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{75}
}

func (x *Commitment) GetCategory() Commitment_Category {
	if x != nil && x.Category != nil {
		return *x.Category
	}
	return Commitment_UNDEFINED_CATEGORY
}

func (x *Commitment) GetCreationTimestamp() string {
	if x != nil && x.CreationTimestamp != nil {
		return *x.CreationTimestamp
	}
	return ""
}

func (x *Commitment) GetDescription() string {
	if x != nil && x.Description != nil {
		return *x.Description
	}
	return ""
}

func (x *Commitment) GetEndTimestamp() string {
	if x != nil && x.EndTimestamp != nil {
		return *x.EndTimestamp
	}
	return ""
}

func (x *Commitment) GetId() uint64 {
	if x != nil && x.Id != nil {
		return *x.Id
	}
	return 0
}

func (x *Commitment) GetKind() string {
	if x != nil && x.Kind != nil {
		return *x.Kind
	}
	return ""
}

func (x *Commitment) GetLicenseResource() *LicenseResourceCommitment {
	if x != nil {
		return x.LicenseResource
	}
	return nil
}

func (x *Commitment) GetName() string {
	if x != nil && x.Name != nil {
		return *x.Name
	}
	return ""
}

func (x *Commitment) GetPlan() Commitment_Plan {
	if x != nil && x.Plan != nil {
		return *x.Plan
	}
	return Commitment_UNDEFINED_PLAN
}

func (x *Commitment) GetRegion() string {
	if x != nil && x.Region != nil {
		return *x.Region
	}
	return ""
}

func (x *Commitment) GetReservations() []*Reservation {
	if x != nil {
		return x.Reservations
	}
	return nil
}

func (x *Commitment) GetResources() []*ResourceCommitment {
	if x != nil {
		return x.Resources
	}
	return nil
}

func (x *Commitment) GetSelfLink() string {
	if x != nil && x.SelfLink != nil {
		return *x.SelfLink
	}
	return ""
}

func (x *Commitment) GetStartTimestamp() string {
	if x != nil && x.StartTimestamp != nil {
		return *x.StartTimestamp
	}
	return ""
}

func (x *Commitment) GetStatus() Commitment_Status {
	if x != nil && x.Status != nil {
		return *x.Status
	}
	return Commitment_UNDEFINED_STATUS
}

func (x *Commitment) GetStatusMessage() string {
	if x != nil && x.StatusMessage != nil {
		return *x.StatusMessage
	}
	return ""
}

//
type CommitmentsScopedList struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// [Output Only] A list of commitments contained in this scope.
	Commitments []*Commitment `protobuf:"bytes,450664446,rep,name=commitments,proto3" json:"commitments,omitempty"`
	// [Output Only] Informational warning which replaces the list of commitments when the list is empty.
	Warning *Warning `protobuf:"bytes,50704284,opt,name=warning,proto3,oneof" json:"warning,omitempty"`
}

func (x *CommitmentsScopedList) Reset() {
	*x = CommitmentsScopedList{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[76]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CommitmentsScopedList) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CommitmentsScopedList) ProtoMessage() {}

func (x *CommitmentsScopedList) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[76]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CommitmentsScopedList.ProtoReflect.Descriptor instead.
func (*CommitmentsScopedList) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{76}
}

func (x *CommitmentsScopedList) GetCommitments() []*Commitment {
	if x != nil {
		return x.Commitments
	}
	return nil
}

func (x *CommitmentsScopedList) GetWarning() *Warning {
	if x != nil {
		return x.Warning
	}
	return nil
}

//
type CommitmentAggregatedList struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// [Output Only] Unique identifier for the resource; defined by the server.
	Id *string `protobuf:"bytes,3355,opt,name=id,proto3,oneof" json:"id,omitempty"`
	// A list of CommitmentsScopedList resources.
	Items map[string]*CommitmentsScopedList `protobuf:"bytes,100526016,rep,name=items,proto3" json:"items,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// [Output Only] Type of resource. Always compute#commitmentAggregatedList for aggregated lists of commitments.
	Kind *string `protobuf:"bytes,3292052,opt,name=kind,proto3,oneof" json:"kind,omitempty"`
	// [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
	NextPageToken *string `protobuf:"bytes,79797525,opt,name=next_page_token,json=nextPageToken,proto3,oneof" json:"next_page_token,omitempty"`
	// [Output Only] Server-defined URL for this resource.
	SelfLink *string `protobuf:"bytes,456214797,opt,name=self_link,json=selfLink,proto3,oneof" json:"self_link,omitempty"`
	// [Output Only] Unreachable resources.
	Unreachables []string `protobuf:"bytes,243372063,rep,name=unreachables,proto3" json:"unreachables,omitempty"`
	// [Output Only] Informational warning message.
	Warning *Warning `protobuf:"bytes,50704284,opt,name=warning,proto3,oneof" json:"warning,omitempty"`
}

func (x *CommitmentAggregatedList) Reset() {
	*x = CommitmentAggregatedList{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[77]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CommitmentAggregatedList) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CommitmentAggregatedList) ProtoMessage() {}

func (x *CommitmentAggregatedList) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[77]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CommitmentAggregatedList.ProtoReflect.Descriptor instead.
func (*CommitmentAggregatedList) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{77}
}

func (x *CommitmentAggregatedList) GetId() string {
	if x != nil && x.Id != nil {
		return *x.Id
	}
	return ""
}

func (x *CommitmentAggregatedList) GetItems() map[string]*CommitmentsScopedList {
	if x != nil {
		return x.Items
	}
	return nil
}

func (x *CommitmentAggregatedList) GetKind() string {
	if x != nil && x.Kind != nil {
		return *x.Kind
	}
	return ""
}

func (x *CommitmentAggregatedList) GetNextPageToken() string {
	if x != nil && x.NextPageToken != nil {
		return *x.NextPageToken
	}
	return ""
}

func (x *CommitmentAggregatedList) GetSelfLink() string {
	if x != nil && x.SelfLink != nil {
		return *x.SelfLink
	}
	return ""
}

func (x *CommitmentAggregatedList) GetUnreachables() []string {
	if x != nil {
		return x.Unreachables
	}
	return nil
}

func (x *CommitmentAggregatedList) GetWarning() *Warning {
	if x != nil {
		return x.Warning
	}
	return nil
}

// Contains a list of Commitment resources.
type CommitmentList struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// [Output Only] Unique identifier for the resource; defined by the server.
	Id *string `protobuf:"bytes,3355,opt,name=id,proto3,oneof" json:"id,omitempty"`
	// A list of Commitment resources.
	Items []*Commitment `protobuf:"bytes,100526016,rep,name=items,proto3" json:"items,omitempty"`
	// [Output Only] Type of resource. Always compute#commitmentList for lists of commitments.
	Kind *string `protobuf:"bytes,3292052,opt,name=kind,proto3,oneof" json:"kind,omitempty"`
	// [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
	NextPageToken *string `protobuf:"bytes,79797525,opt,name=next_page_token,json=nextPageToken,proto3,oneof" json:"next_page_token,omitempty"`
	// [Output Only] Server-defined URL for this resource.
	SelfLink *string `protobuf:"bytes,456214797,opt,name=self_link,json=selfLink,proto3,oneof" json:"self_link,omitempty"`
	// [Output Only] Informational warning message.
	Warning *Warning `protobuf:"bytes,50704284,opt,name=warning,proto3,oneof" json:"warning,omitempty"`
}

func (x *CommitmentList) Reset() {
	*x = CommitmentList{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[78]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CommitmentList) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CommitmentList) ProtoMessage() {}

func (x *CommitmentList) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[78]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CommitmentList.ProtoReflect.Descriptor instead.
func (*CommitmentList) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{78}
}

func (x *CommitmentList) GetId() string {
	if x != nil && x.Id != nil {
		return *x.Id
	}
	return ""
}

func (x *CommitmentList) GetItems() []*Commitment {
	if x != nil {
		return x.Items
	}
	return nil
}

func (x *CommitmentList) GetKind() string {
	if x != nil && x.Kind != nil {
		return *x.Kind
	}
	return ""
}

func (x *CommitmentList) GetNextPageToken() string {
	if x != nil && x.NextPageToken != nil {
		return *x.NextPageToken
	}
	return ""
}

func (x *CommitmentList) GetSelfLink() string {
	if x != nil && x.SelfLink != nil {
		return *x.SelfLink
	}
	return ""
}

func (x *CommitmentList) GetWarning() *Warning {
	if x != nil {
		return x.Warning
	}
	return nil
}

// A condition to be met.
type Condition struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Trusted attributes supplied by the IAM system.
	Iam *string `protobuf:"bytes,104021,opt,name=iam,proto3,oneof" json:"iam,omitempty"`
	// An operator to apply the subject with.
	Op *string `protobuf:"bytes,3553,opt,name=op,proto3,oneof" json:"op,omitempty"`
	// Trusted attributes discharged by the service.
	Svc *string `protobuf:"bytes,114272,opt,name=svc,proto3,oneof" json:"svc,omitempty"`
	// Trusted attributes supplied by any service that owns resources and uses the IAM system for access control.
	Sys *string `protobuf:"bytes,114381,opt,name=sys,proto3,oneof" json:"sys,omitempty"`
	// The objects of the condition.
	Values []string `protobuf:"bytes,249928994,rep,name=values,proto3" json:"values,omitempty"`
}

func (x *Condition) Reset() {
	*x = Condition{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[79]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Condition) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Condition) ProtoMessage() {}

func (x *Condition) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[79]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Condition.ProtoReflect.Descriptor instead.
func (*Condition) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{79}
}

func (x *Condition) GetIam() string {
	if x != nil && x.Iam != nil {
		return *x.Iam
	}
	return ""
}

func (x *Condition) GetOp() string {
	if x != nil && x.Op != nil {
		return *x.Op
	}
	return ""
}

func (x *Condition) GetSvc() string {
	if x != nil && x.Svc != nil {
		return *x.Svc
	}
	return ""
}

func (x *Condition) GetSys() string {
	if x != nil && x.Sys != nil {
		return *x.Sys
	}
	return ""
}

func (x *Condition) GetValues() []string {
	if x != nil {
		return x.Values
	}
	return nil
}

// A set of Confidential Instance options.
type ConfidentialInstanceConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Defines whether the instance should have confidential compute enabled.
	EnableConfidentialCompute *bool `protobuf:"varint,102135228,opt,name=enable_confidential_compute,json=enableConfidentialCompute,proto3,oneof" json:"enable_confidential_compute,omitempty"`
}

func (x *ConfidentialInstanceConfig) Reset() {
	*x = ConfidentialInstanceConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[80]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ConfidentialInstanceConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ConfidentialInstanceConfig) ProtoMessage() {}

func (x *ConfidentialInstanceConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[80]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ConfidentialInstanceConfig.ProtoReflect.Descriptor instead.
func (*ConfidentialInstanceConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{80}
}

func (x *ConfidentialInstanceConfig) GetEnableConfidentialCompute() bool {
	if x != nil && x.EnableConfidentialCompute != nil {
		return *x.EnableConfidentialCompute
	}
	return false
}

// The information about the HTTP Cookie on which the hash function is based for load balancing policies that use a consistent hash.
type ConsistentHashLoadBalancerSettingsHttpCookie struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of the cookie.
	Name *string `protobuf:"bytes,3373707,opt,name=name,proto3,oneof" json:"name,omitempty"`
	// Path to set for the cookie.
	Path *string `protobuf:"bytes,3433509,opt,name=path,proto3,oneof" json:"path,omitempty"`
	// Lifetime of the cookie.
	Ttl *Duration `protobuf:"bytes,115180,opt,name=ttl,proto3,oneof" json:"ttl,omitempty"`
}

func (x *ConsistentHashLoadBalancerSettingsHttpCookie) Reset() {
	*x = ConsistentHashLoadBalancerSettingsHttpCookie{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[81]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ConsistentHashLoadBalancerSettingsHttpCookie) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ConsistentHashLoadBalancerSettingsHttpCookie) ProtoMessage() {}

func (x *ConsistentHashLoadBalancerSettingsHttpCookie) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[81]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ConsistentHashLoadBalancerSettingsHttpCookie.ProtoReflect.Descriptor instead.
func (*ConsistentHashLoadBalancerSettingsHttpCookie) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{81}
}

func (x *ConsistentHashLoadBalancerSettingsHttpCookie) GetName() string {
	if x != nil && x.Name != nil {
		return *x.Name
	}
	return ""
}

func (x *ConsistentHashLoadBalancerSettingsHttpCookie) GetPath() string {
	if x != nil && x.Path != nil {
		return *x.Path
	}
	return ""
}

func (x *ConsistentHashLoadBalancerSettingsHttpCookie) GetTtl() *Duration {
	if x != nil {
		return x.Ttl
	}
	return nil
}

// The specification for allowing client side cross-origin requests. Please see W3C Recommendation for Cross Origin Resource Sharing
type CorsPolicy struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// In response to a preflight request, setting this to true indicates that the actual request can include user credentials. This translates to the Access-Control-Allow-Credentials header.
	// Default is false.
	AllowCredentials *bool `protobuf:"varint,481263366,opt,name=allow_credentials,json=allowCredentials,proto3,oneof" json:"allow_credentials,omitempty"`
	// Specifies the content for the Access-Control-Allow-Headers header.
	AllowHeaders []string `protobuf:"bytes,45179024,rep,name=allow_headers,json=allowHeaders,proto3" json:"allow_headers,omitempty"`
	// Specifies the content for the Access-Control-Allow-Methods header.
	AllowMethods []string `protobuf:"bytes,205405372,rep,name=allow_methods,json=allowMethods,proto3" json:"allow_methods,omitempty"`
	// Specifies the regualar expression patterns that match allowed origins. For regular expression grammar please see github.com/google/re2/wiki/Syntax
	// An origin is allowed if it matches either an item in allowOrigins or an item in allowOriginRegexes.
	AllowOriginRegexes []string `protobuf:"bytes,215385810,rep,name=allow_origin_regexes,json=allowOriginRegexes,proto3" json:"allow_origin_regexes,omitempty"`
	// Specifies the list of origins that will be allowed to do CORS requests.
	// An origin is allowed if it matches either an item in allowOrigins or an item in allowOriginRegexes.
	AllowOrigins []string `protobuf:"bytes,194914071,rep,name=allow_origins,json=allowOrigins,proto3" json:"allow_origins,omitempty"`
	// If true, specifies the CORS policy is disabled. The default value of false, which indicates that the CORS policy is in effect.
	Disabled *bool `protobuf:"varint,270940796,opt,name=disabled,proto3,oneof" json:"disabled,omitempty"`
	// Specifies the content for the Access-Control-Expose-Headers header.
	ExposeHeaders []string `protobuf:"bytes,247604747,rep,name=expose_headers,json=exposeHeaders,proto3" json:"expose_headers,omitempty"`
	// Specifies how long results of a preflight request can be cached in seconds. This translates to the Access-Control-Max-Age header.
	MaxAge *int32 `protobuf:"varint,307559332,opt,name=max_age,json=maxAge,proto3,oneof" json:"max_age,omitempty"`
}

func (x *CorsPolicy) Reset() {
	*x = CorsPolicy{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[82]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CorsPolicy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CorsPolicy) ProtoMessage() {}

func (x *CorsPolicy) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[82]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CorsPolicy.ProtoReflect.Descriptor instead.
func (*CorsPolicy) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{82}
}

func (x *CorsPolicy) GetAllowCredentials() bool {
	if x != nil && x.AllowCredentials != nil {
		return *x.AllowCredentials
	}
	return false
}

func (x *CorsPolicy) GetAllowHeaders() []string {
	if x != nil {
		return x.AllowHeaders
	}
	return nil
}

func (x *CorsPolicy) GetAllowMethods() []string {
	if x != nil {
		return x.AllowMethods
	}
	return nil
}

func (x *CorsPolicy) GetAllowOriginRegexes() []string {
	if x != nil {
		return x.AllowOriginRegexes
	}
	return nil
}

func (x *CorsPolicy) GetAllowOrigins() []string {
	if x != nil {
		return x.AllowOrigins
	}
	return nil
}

func (x *CorsPolicy) GetDisabled() bool {
	if x != nil && x.Disabled != nil {
		return *x.Disabled
	}
	return false
}

func (x *CorsPolicy) GetExposeHeaders() []string {
	if x != nil {
		return x.ExposeHeaders
	}
	return nil
}

func (x *CorsPolicy) GetMaxAge() int32 {
	if x != nil && x.MaxAge != nil {
		return *x.MaxAge
	}
	return 0
}

//
type CustomerEncryptionKeyProtectedDisk struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Decrypts data associated with the disk with a customer-supplied encryption key.
	DiskEncryptionKey *CustomerEncryptionKey `protobuf:"bytes,271660677,opt,name=disk_encryption_key,json=diskEncryptionKey,proto3,oneof" json:"disk_encryption_key,omitempty"`
	// Specifies a valid partial or full URL to an existing Persistent Disk resource. This field is only applicable for persistent disks.
	Source *string `protobuf:"bytes,177235995,opt,name=source,proto3,oneof" json:"source,omitempty"`
}

func (x *CustomerEncryptionKeyProtectedDisk) Reset() {
	*x = CustomerEncryptionKeyProtectedDisk{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[83]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CustomerEncryptionKeyProtectedDisk) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CustomerEncryptionKeyProtectedDisk) ProtoMessage() {}

func (x *CustomerEncryptionKeyProtectedDisk) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[83]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CustomerEncryptionKeyProtectedDisk.ProtoReflect.Descriptor instead.
func (*CustomerEncryptionKeyProtectedDisk) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{83}
}

func (x *CustomerEncryptionKeyProtectedDisk) GetDiskEncryptionKey() *CustomerEncryptionKey {
	if x != nil {
		return x.DiskEncryptionKey
	}
	return nil
}

func (x *CustomerEncryptionKeyProtectedDisk) GetSource() string {
	if x != nil && x.Source != nil {
		return *x.Source
	}
	return ""
}

// Represents a Persistent Disk resource.
//
// Google Compute Engine has two Disk resources:
//
// * [Zonal](/compute/docs/reference/rest/{$api_version}/disks) * [Regional](/compute/docs/reference/rest/{$api_version}/regionDisks)
//
// Persistent disks are required for running your VM instances. Create both boot and non-boot (data) persistent disks. For more information, read Persistent Disks. For more storage options, read Storage options.
//
// The disks resource represents a zonal persistent disk. For more information, read Zonal persistent disks.
//
// The regionDisks resource represents a regional persistent disk. For more information, read  Regional resources. (== resource_for {$api_version}.disks ==) (== resource_for {$api_version}.regionDisks ==)
type Disk struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// [Output Only] Creation timestamp in RFC3339 text format.
	CreationTimestamp *string `protobuf:"bytes,30525366,opt,name=creation_timestamp,json=creationTimestamp,proto3,oneof" json:"creation_timestamp,omitempty"`
	// An optional description of this resource. Provide this property when you create the resource.
	Description *string `protobuf:"bytes,422937596,opt,name=description,proto3,oneof" json:"description,omitempty"`
	// Encrypts the disk using a customer-supplied encryption key.
	//
	// After you encrypt a disk with a customer-supplied key, you must provide the same key if you use the disk later (e.g. to create a disk snapshot, to create a disk image, to create a machine image, or to attach the disk to a virtual machine).
	//
	// Customer-supplied encryption keys do not protect access to metadata of the disk.
	//
	// If you do not provide an encryption key when creating the disk, then the disk will be encrypted using an automatically generated key and you do not need to provide a key to use the disk later.
	DiskEncryptionKey *CustomerEncryptionKey `protobuf:"bytes,271660677,opt,name=disk_encryption_key,json=diskEncryptionKey,proto3,oneof" json:"disk_encryption_key,omitempty"`
	// A list of features to enable on the guest operating system. Applicable only for bootable images. Read  Enabling guest operating system features to see a list of available options.
	GuestOsFeatures []*GuestOsFeature `protobuf:"bytes,79294545,rep,name=guest_os_features,json=guestOsFeatures,proto3" json:"guest_os_features,omitempty"`
	// [Output Only] The unique identifier for the resource. This identifier is defined by the server.
	Id *uint64 `protobuf:"varint,3355,opt,name=id,proto3,oneof" json:"id,omitempty"`
	// [Output Only] Type of the resource. Always compute#disk for disks.
	Kind *string `protobuf:"bytes,3292052,opt,name=kind,proto3,oneof" json:"kind,omitempty"`
	// A fingerprint for the labels being applied to this disk, which is essentially a hash of the labels set used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update labels. You must always provide an up-to-date fingerprint hash in order to update or change labels, otherwise the request will fail with error 412 conditionNotMet.
	//
	// To see the latest fingerprint, make a get() request to retrieve a disk.
	LabelFingerprint *string `protobuf:"bytes,178124825,opt,name=label_fingerprint,json=labelFingerprint,proto3,oneof" json:"label_fingerprint,omitempty"`
	// Labels to apply to this disk. These can be later modified by the setLabels method.
	Labels map[string]string `protobuf:"bytes,500195327,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// [Output Only] Last attach timestamp in RFC3339 text format.
	LastAttachTimestamp *string `protobuf:"bytes,42159653,opt,name=last_attach_timestamp,json=lastAttachTimestamp,proto3,oneof" json:"last_attach_timestamp,omitempty"`
	// [Output Only] Last detach timestamp in RFC3339 text format.
	LastDetachTimestamp *string `protobuf:"bytes,56471027,opt,name=last_detach_timestamp,json=lastDetachTimestamp,proto3,oneof" json:"last_detach_timestamp,omitempty"`
	// Integer license codes indicating which licenses are attached to this disk.
	LicenseCodes []int64 `protobuf:"varint,45482664,rep,packed,name=license_codes,json=licenseCodes,proto3" json:"license_codes,omitempty"`
	// A list of publicly visible licenses. Reserved for Google's use.
	Licenses []string `protobuf:"bytes,337642578,rep,name=licenses,proto3" json:"licenses,omitempty"`
	// An opaque location hint used to place the disk close to other resources. This field is for use by internal tools that use the public API.
	LocationHint *string `protobuf:"bytes,350519505,opt,name=location_hint,json=locationHint,proto3,oneof" json:"location_hint,omitempty"`
	// Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
	Name *string `protobuf:"bytes,3373707,opt,name=name,proto3,oneof" json:"name,omitempty"`
	// Internal use only.
	Options *string `protobuf:"bytes,361137822,opt,name=options,proto3,oneof" json:"options,omitempty"`
	// Physical block size of the persistent disk, in bytes. If not present in a request, a default value is used. The currently supported size is 4096, other sizes may be added in the future. If an unsupported value is requested, the error message will list the supported values for the caller's project.
	PhysicalBlockSizeBytes *int64 `protobuf:"varint,420007943,opt,name=physical_block_size_bytes,json=physicalBlockSizeBytes,proto3,oneof" json:"physical_block_size_bytes,omitempty"`
	// Indicates how many IOPS must be provisioned for the disk.
	ProvisionedIops *int64 `protobuf:"varint,186769108,opt,name=provisioned_iops,json=provisionedIops,proto3,oneof" json:"provisioned_iops,omitempty"`
	// [Output Only] URL of the region where the disk resides. Only applicable for regional resources. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
	Region *string `protobuf:"bytes,138946292,opt,name=region,proto3,oneof" json:"region,omitempty"`
	// URLs of the zones where the disk should be replicated to. Only applicable for regional resources.
	ReplicaZones []string `protobuf:"bytes,48438272,rep,name=replica_zones,json=replicaZones,proto3" json:"replica_zones,omitempty"`
	// Resource policies applied to this disk for automatic snapshot creations.
	ResourcePolicies []string `protobuf:"bytes,22220385,rep,name=resource_policies,json=resourcePolicies,proto3" json:"resource_policies,omitempty"`
	// [Output Only] Reserved for future use.
	SatisfiesPzs *bool `protobuf:"varint,480964267,opt,name=satisfies_pzs,json=satisfiesPzs,proto3,oneof" json:"satisfies_pzs,omitempty"`
	// [Output Only] Server-defined fully-qualified URL for this resource.
	SelfLink *string `protobuf:"bytes,456214797,opt,name=self_link,json=selfLink,proto3,oneof" json:"self_link,omitempty"`
	// Size, in GB, of the persistent disk. You can specify this field when creating a persistent disk using the sourceImage, sourceSnapshot, or sourceDisk parameter, or specify it alone to create an empty persistent disk.
	//
	// If you specify this field along with a source, the value of sizeGb must not be less than the size of the source. Acceptable values are 1 to 65536, inclusive.
	SizeGb *int64 `protobuf:"varint,494929369,opt,name=size_gb,json=sizeGb,proto3,oneof" json:"size_gb,omitempty"`
	// The source disk used to create this disk. You can provide this as a partial or full URL to the resource. For example, the following are valid values:
	// - https://www.googleapis.com/compute/v1/projects/project/zones/zone/disks/disk
	// - https://www.googleapis.com/compute/v1/projects/project/regions/region/disks/disk
	// - projects/project/zones/zone/disks/disk
	// - projects/project/regions/region/disks/disk
	// - zones/zone/disks/disk
	// - regions/region/disks/disk
	SourceDisk *string `protobuf:"bytes,451753793,opt,name=source_disk,json=sourceDisk,proto3,oneof" json:"source_disk,omitempty"`
	// [Output Only] The unique ID of the disk used to create this disk. This value identifies the exact disk that was used to create this persistent disk. For example, if you created the persistent disk from a disk that was later deleted and recreated under the same name, the source disk ID would identify the exact version of the disk that was used.
	SourceDiskId *string `protobuf:"bytes,454190809,opt,name=source_disk_id,json=sourceDiskId,proto3,oneof" json:"source_disk_id,omitempty"`
	// The source image used to create this disk. If the source image is deleted, this field will not be set.
	//
	// To create a disk with one of the public operating system images, specify the image by its family name. For example, specify family/debian-9 to use the latest Debian 9 image:
	// projects/debian-cloud/global/images/family/debian-9
	//
	//
	// Alternatively, use a specific version of a public operating system image:
	// projects/debian-cloud/global/images/debian-9-stretch-vYYYYMMDD
	//
	//
	// To create a disk with a custom image that you created, specify the image name in the following format:
	// global/images/my-custom-image
	//
	//
	// You can also specify a custom image by its image family, which returns the latest version of the image in that family. Replace the image name with family/family-name:
	// global/images/family/my-image-family
	SourceImage *string `protobuf:"bytes,50443319,opt,name=source_image,json=sourceImage,proto3,oneof" json:"source_image,omitempty"`
	// The customer-supplied encryption key of the source image. Required if the source image is protected by a customer-supplied encryption key.
	SourceImageEncryptionKey *CustomerEncryptionKey `protobuf:"bytes,381503659,opt,name=source_image_encryption_key,json=sourceImageEncryptionKey,proto3,oneof" json:"source_image_encryption_key,omitempty"`
	// [Output Only] The ID value of the image used to create this disk. This value identifies the exact image that was used to create this persistent disk. For example, if you created the persistent disk from an image that was later deleted and recreated under the same name, the source image ID would identify the exact version of the image that was used.
	SourceImageId *string `protobuf:"bytes,55328291,opt,name=source_image_id,json=sourceImageId,proto3,oneof" json:"source_image_id,omitempty"`
	// The source snapshot used to create this disk. You can provide this as a partial or full URL to the resource. For example, the following are valid values:
	// - https://www.googleapis.com/compute/v1/projects/project/global/snapshots/snapshot
	// - projects/project/global/snapshots/snapshot
	// - global/snapshots/snapshot
	SourceSnapshot *string `protobuf:"bytes,126061928,opt,name=source_snapshot,json=sourceSnapshot,proto3,oneof" json:"source_snapshot,omitempty"`
	// The customer-supplied encryption key of the source snapshot. Required if the source snapshot is protected by a customer-supplied encryption key.
	SourceSnapshotEncryptionKey *CustomerEncryptionKey `protobuf:"bytes,303679322,opt,name=source_snapshot_encryption_key,json=sourceSnapshotEncryptionKey,proto3,oneof" json:"source_snapshot_encryption_key,omitempty"`
	// [Output Only] The unique ID of the snapshot used to create this disk. This value identifies the exact snapshot that was used to create this persistent disk. For example, if you created the persistent disk from a snapshot that was later deleted and recreated under the same name, the source snapshot ID would identify the exact version of the snapshot that was used.
	SourceSnapshotId *string `protobuf:"bytes,98962258,opt,name=source_snapshot_id,json=sourceSnapshotId,proto3,oneof" json:"source_snapshot_id,omitempty"`
	// The full Google Cloud Storage URI where the disk image is stored. This file must be a gzip-compressed tarball whose name ends in .tar.gz or virtual machine disk whose name ends in vmdk. Valid URIs may start with gs:// or https://storage.googleapis.com/. This flag is not optimized for creating multiple disks from a source storage object. To create many disks from a source storage object, use gcloud compute images import instead.
	SourceStorageObject *string `protobuf:"bytes,233052711,opt,name=source_storage_object,json=sourceStorageObject,proto3,oneof" json:"source_storage_object,omitempty"`
	// [Output Only] The status of disk creation.
	// - CREATING: Disk is provisioning.
	// - RESTORING: Source data is being copied into the disk.
	// - FAILED: Disk creation failed.
	// - READY: Disk is ready for use.
	// - DELETING: Disk is deleting.
	Status *Disk_Status `protobuf:"varint,181260274,opt,name=status,proto3,enum=google.cloud.compute.v1.Disk_Status,oneof" json:"status,omitempty"`
	// URL of the disk type resource describing which disk type to use to create the disk. Provide this when creating the disk. For example: projects/project/zones/zone/diskTypes/pd-standard  or pd-ssd
	Type *string `protobuf:"bytes,3575610,opt,name=type,proto3,oneof" json:"type,omitempty"`
	// [Output Only] Links to the users of the disk (attached instances) in form: projects/project/zones/zone/instances/instance
	Users []string `protobuf:"bytes,111578632,rep,name=users,proto3" json:"users,omitempty"`
	// [Output Only] URL of the zone where the disk resides. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
	Zone *string `protobuf:"bytes,3744684,opt,name=zone,proto3,oneof" json:"zone,omitempty"`
}

func (x *Disk) Reset() {
	*x = Disk{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[84]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Disk) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Disk) ProtoMessage() {}

func (x *Disk) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[84]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Disk.ProtoReflect.Descriptor instead.
func (*Disk) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{84}
}

func (x *Disk) GetCreationTimestamp() string {
	if x != nil && x.CreationTimestamp != nil {
		return *x.CreationTimestamp
	}
	return ""
}

func (x *Disk) GetDescription() string {
	if x != nil && x.Description != nil {
		return *x.Description
	}
	return ""
}

func (x *Disk) GetDiskEncryptionKey() *CustomerEncryptionKey {
	if x != nil {
		return x.DiskEncryptionKey
	}
	return nil
}

func (x *Disk) GetGuestOsFeatures() []*GuestOsFeature {
	if x != nil {
		return x.GuestOsFeatures
	}
	return nil
}

func (x *Disk) GetId() uint64 {
	if x != nil && x.Id != nil {
		return *x.Id
	}
	return 0
}

func (x *Disk) GetKind() string {
	if x != nil && x.Kind != nil {
		return *x.Kind
	}
	return ""
}

func (x *Disk) GetLabelFingerprint() string {
	if x != nil && x.LabelFingerprint != nil {
		return *x.LabelFingerprint
	}
	return ""
}

func (x *Disk) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *Disk) GetLastAttachTimestamp() string {
	if x != nil && x.LastAttachTimestamp != nil {
		return *x.LastAttachTimestamp
	}
	return ""
}

func (x *Disk) GetLastDetachTimestamp() string {
	if x != nil && x.LastDetachTimestamp != nil {
		return *x.LastDetachTimestamp
	}
	return ""
}

func (x *Disk) GetLicenseCodes() []int64 {
	if x != nil {
		return x.LicenseCodes
	}
	return nil
}

func (x *Disk) GetLicenses() []string {
	if x != nil {
		return x.Licenses
	}
	return nil
}

func (x *Disk) GetLocationHint() string {
	if x != nil && x.LocationHint != nil {
		return *x.LocationHint
	}
	return ""
}

func (x *Disk) GetName() string {
	if x != nil && x.Name != nil {
		return *x.Name
	}
	return ""
}

func (x *Disk) GetOptions() string {
	if x != nil && x.Options != nil {
		return *x.Options
	}
	return ""
}

func (x *Disk) GetPhysicalBlockSizeBytes() int64 {
	if x != nil && x.PhysicalBlockSizeBytes != nil {
		return *x.PhysicalBlockSizeBytes
	}
	return 0
}

func (x *Disk) GetProvisionedIops() int64 {
	if x != nil && x.ProvisionedIops != nil {
		return *x.ProvisionedIops
	}
	return 0
}

func (x *Disk) GetRegion() string {
	if x != nil && x.Region != nil {
		return *x.Region
	}
	return ""
}

func (x *Disk) GetReplicaZones() []string {
	if x != nil {
		return x.ReplicaZones
	}
	return nil
}

func (x *Disk) GetResourcePolicies() []string {
	if x != nil {
		return x.ResourcePolicies
	}
	return nil
}

func (x *Disk) GetSatisfiesPzs() bool {
	if x != nil && x.SatisfiesPzs != nil {
		return *x.SatisfiesPzs
	}
	return false
}

func (x *Disk) GetSelfLink() string {
	if x != nil && x.SelfLink != nil {
		return *x.SelfLink
	}
	return ""
}

func (x *Disk) GetSizeGb() int64 {
	if x != nil && x.SizeGb != nil {
		return *x.SizeGb
	}
	return 0
}

func (x *Disk) GetSourceDisk() string {
	if x != nil && x.SourceDisk != nil {
		return *x.SourceDisk
	}
	return ""
}

func (x *Disk) GetSourceDiskId() string {
	if x != nil && x.SourceDiskId != nil {
		return *x.SourceDiskId
	}
	return ""
}

func (x *Disk) GetSourceImage() string {
	if x != nil && x.SourceImage != nil {
		return *x.SourceImage
	}
	return ""
}

func (x *Disk) GetSourceImageEncryptionKey() *CustomerEncryptionKey {
	if x != nil {
		return x.SourceImageEncryptionKey
	}
	return nil
}

func (x *Disk) GetSourceImageId() string {
	if x != nil && x.SourceImageId != nil {
		return *x.SourceImageId
	}
	return ""
}

func (x *Disk) GetSourceSnapshot() string {
	if x != nil && x.SourceSnapshot != nil {
		return *x.SourceSnapshot
	}
	return ""
}

func (x *Disk) GetSourceSnapshotEncryptionKey() *CustomerEncryptionKey {
	if x != nil {
		return x.SourceSnapshotEncryptionKey
	}
	return nil
}

func (x *Disk) GetSourceSnapshotId() string {
	if x != nil && x.SourceSnapshotId != nil {
		return *x.SourceSnapshotId
	}
	return ""
}

func (x *Disk) GetSourceStorageObject() string {
	if x != nil && x.SourceStorageObject != nil {
		return *x.SourceStorageObject
	}
	return ""
}

func (x *Disk) GetStatus() Disk_Status {
	if x != nil && x.Status != nil {
		return *x.Status
	}
	return Disk_UNDEFINED_STATUS
}

func (x *Disk) GetType() string {
	if x != nil && x.Type != nil {
		return *x.Type
	}
	return ""
}

func (x *Disk) GetUsers() []string {
	if x != nil {
		return x.Users
	}
	return nil
}

func (x *Disk) GetZone() string {
	if x != nil && x.Zone != nil {
		return *x.Zone
	}
	return ""
}

//
type DisksScopedList struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// [Output Only] A list of disks contained in this scope.
	Disks []*Disk `protobuf:"bytes,95594102,rep,name=disks,proto3" json:"disks,omitempty"`
	// [Output Only] Informational warning which replaces the list of disks when the list is empty.
	Warning *Warning `protobuf:"bytes,50704284,opt,name=warning,proto3,oneof" json:"warning,omitempty"`
}

func (x *DisksScopedList) Reset() {
	*x = DisksScopedList{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[85]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DisksScopedList) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DisksScopedList) ProtoMessage() {}

func (x *DisksScopedList) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[85]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DisksScopedList.ProtoReflect.Descriptor instead.
func (*DisksScopedList) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{85}
}

func (x *DisksScopedList) GetDisks() []*Disk {
	if x != nil {
		return x.Disks
	}
	return nil
}

func (x *DisksScopedList) GetWarning() *Warning {
	if x != nil {
		return x.Warning
	}
	return nil
}

//
type DiskAggregatedList struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// [Output Only] Unique identifier for the resource; defined by the server.
	Id *string `protobuf:"bytes,3355,opt,name=id,proto3,oneof" json:"id,omitempty"`
	// A list of DisksScopedList resources.
	Items map[string]*DisksScopedList `protobuf:"bytes,100526016,rep,name=items,proto3" json:"items,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// [Output Only] Type of resource. Always compute#diskAggregatedList for aggregated lists of persistent disks.
	Kind *string `protobuf:"bytes,3292052,opt,name=kind,proto3,oneof" json:"kind,omitempty"`
	// [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
	NextPageToken *string `protobuf:"bytes,79797525,opt,name=next_page_token,json=nextPageToken,proto3,oneof" json:"next_page_token,omitempty"`
	// [Output Only] Server-defined URL for this resource.
	SelfLink *string `protobuf:"bytes,456214797,opt,name=self_link,json=selfLink,proto3,oneof" json:"self_link,omitempty"`
	// [Output Only] Unreachable resources.
	Unreachables []string `protobuf:"bytes,243372063,rep,name=unreachables,proto3" json:"unreachables,omitempty"`
	// [Output Only] Informational warning message.
	Warning *Warning `protobuf:"bytes,50704284,opt,name=warning,proto3,oneof" json:"warning,omitempty"`
}

func (x *DiskAggregatedList) Reset() {
	*x = DiskAggregatedList{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[86]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DiskAggregatedList) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DiskAggregatedList) ProtoMessage() {}

func (x *DiskAggregatedList) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[86]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DiskAggregatedList.ProtoReflect.Descriptor instead.
func (*DiskAggregatedList) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{86}
}

func (x *DiskAggregatedList) GetId() string {
	if x != nil && x.Id != nil {
		return *x.Id
	}
	return ""
}

func (x *DiskAggregatedList) GetItems() map[string]*DisksScopedList {
	if x != nil {
		return x.Items
	}
	return nil
}

func (x *DiskAggregatedList) GetKind() string {
	if x != nil && x.Kind != nil {
		return *x.Kind
	}
	return ""
}

func (x *DiskAggregatedList) GetNextPageToken() string {
	if x != nil && x.NextPageToken != nil {
		return *x.NextPageToken
	}
	return ""
}

func (x *DiskAggregatedList) GetSelfLink() string {
	if x != nil && x.SelfLink != nil {
		return *x.SelfLink
	}
	return ""
}

func (x *DiskAggregatedList) GetUnreachables() []string {
	if x != nil {
		return x.Unreachables
	}
	return nil
}

func (x *DiskAggregatedList) GetWarning() *Warning {
	if x != nil {
		return x.Warning
	}
	return nil
}

// A specification of the desired way to instantiate a disk in the instance template when its created from a source instance.
type DiskInstantiationConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Specifies whether the disk will be auto-deleted when the instance is deleted (but not when the disk is detached from the instance).
	AutoDelete *bool `protobuf:"varint,464761403,opt,name=auto_delete,json=autoDelete,proto3,oneof" json:"auto_delete,omitempty"`
	// The custom source image to be used to restore this disk when instantiating this instance template.
	CustomImage *string `protobuf:"bytes,184123149,opt,name=custom_image,json=customImage,proto3,oneof" json:"custom_image,omitempty"`
	// Specifies the device name of the disk to which the configurations apply to.
	DeviceName *string `protobuf:"bytes,67541716,opt,name=device_name,json=deviceName,proto3,oneof" json:"device_name,omitempty"`
	// Specifies whether to include the disk and what image to use. Possible values are:
	// - source-image: to use the same image that was used to create the source instance's corresponding disk. Applicable to the boot disk and additional read-write disks.
	// - source-image-family: to use the same image family that was used to create the source instance's corresponding disk. Applicable to the boot disk and additional read-write disks.
	// - custom-image: to use a user-provided image url for disk creation. Applicable to the boot disk and additional read-write disks.
	// - attach-read-only: to attach a read-only disk. Applicable to read-only disks.
	// - do-not-include: to exclude a disk from the template. Applicable to additional read-write disks, local SSDs, and read-only disks.
	InstantiateFrom *DiskInstantiationConfig_InstantiateFrom `protobuf:"varint,393383903,opt,name=instantiate_from,json=instantiateFrom,proto3,enum=google.cloud.compute.v1.DiskInstantiationConfig_InstantiateFrom,oneof" json:"instantiate_from,omitempty"`
}

func (x *DiskInstantiationConfig) Reset() {
	*x = DiskInstantiationConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[87]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DiskInstantiationConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DiskInstantiationConfig) ProtoMessage() {}

func (x *DiskInstantiationConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[87]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DiskInstantiationConfig.ProtoReflect.Descriptor instead.
func (*DiskInstantiationConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{87}
}

func (x *DiskInstantiationConfig) GetAutoDelete() bool {
	if x != nil && x.AutoDelete != nil {
		return *x.AutoDelete
	}
	return false
}

func (x *DiskInstantiationConfig) GetCustomImage() string {
	if x != nil && x.CustomImage != nil {
		return *x.CustomImage
	}
	return ""
}

func (x *DiskInstantiationConfig) GetDeviceName() string {
	if x != nil && x.DeviceName != nil {
		return *x.DeviceName
	}
	return ""
}

func (x *DiskInstantiationConfig) GetInstantiateFrom() DiskInstantiationConfig_InstantiateFrom {
	if x != nil && x.InstantiateFrom != nil {
		return *x.InstantiateFrom
	}
	return DiskInstantiationConfig_UNDEFINED_INSTANTIATE_FROM
}

// A list of Disk resources.
type DiskList struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// [Output Only] Unique identifier for the resource; defined by the server.
	Id *string `protobuf:"bytes,3355,opt,name=id,proto3,oneof" json:"id,omitempty"`
	// A list of Disk resources.
	Items []*Disk `protobuf:"bytes,100526016,rep,name=items,proto3" json:"items,omitempty"`
	// [Output Only] Type of resource. Always compute#diskList for lists of disks.
	Kind *string `protobuf:"bytes,3292052,opt,name=kind,proto3,oneof" json:"kind,omitempty"`
	// [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
	NextPageToken *string `protobuf:"bytes,79797525,opt,name=next_page_token,json=nextPageToken,proto3,oneof" json:"next_page_token,omitempty"`
	// [Output Only] Server-defined URL for this resource.
	SelfLink *string `protobuf:"bytes,456214797,opt,name=self_link,json=selfLink,proto3,oneof" json:"self_link,omitempty"`
	// [Output Only] Informational warning message.
	Warning *Warning `protobuf:"bytes,50704284,opt,name=warning,proto3,oneof" json:"warning,omitempty"`
}

func (x *DiskList) Reset() {
	*x = DiskList{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[88]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DiskList) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DiskList) ProtoMessage() {}

func (x *DiskList) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[88]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DiskList.ProtoReflect.Descriptor instead.
func (*DiskList) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{88}
}

func (x *DiskList) GetId() string {
	if x != nil && x.Id != nil {
		return *x.Id
	}
	return ""
}

func (x *DiskList) GetItems() []*Disk {
	if x != nil {
		return x.Items
	}
	return nil
}

func (x *DiskList) GetKind() string {
	if x != nil && x.Kind != nil {
		return *x.Kind
	}
	return ""
}

func (x *DiskList) GetNextPageToken() string {
	if x != nil && x.NextPageToken != nil {
		return *x.NextPageToken
	}
	return ""
}

func (x *DiskList) GetSelfLink() string {
	if x != nil && x.SelfLink != nil {
		return *x.SelfLink
	}
	return ""
}

func (x *DiskList) GetWarning() *Warning {
	if x != nil {
		return x.Warning
	}
	return nil
}

//
type DiskMoveRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The URL of the destination zone to move the disk. This can be a full or partial URL. For example, the following are all valid URLs to a zone:
	// - https://www.googleapis.com/compute/v1/projects/project/zones/zone
	// - projects/project/zones/zone
	// - zones/zone
	DestinationZone *string `protobuf:"bytes,131854653,opt,name=destination_zone,json=destinationZone,proto3,oneof" json:"destination_zone,omitempty"`
	// The URL of the target disk to move. This can be a full or partial URL. For example, the following are all valid URLs to a disk:
	// - https://www.googleapis.com/compute/v1/projects/project/zones/zone/disks/disk
	// - projects/project/zones/zone/disks/disk
	// - zones/zone/disks/disk
	TargetDisk *string `protobuf:"bytes,62433163,opt,name=target_disk,json=targetDisk,proto3,oneof" json:"target_disk,omitempty"`
}

func (x *DiskMoveRequest) Reset() {
	*x = DiskMoveRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[89]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DiskMoveRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DiskMoveRequest) ProtoMessage() {}

func (x *DiskMoveRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[89]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DiskMoveRequest.ProtoReflect.Descriptor instead.
func (*DiskMoveRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{89}
}

func (x *DiskMoveRequest) GetDestinationZone() string {
	if x != nil && x.DestinationZone != nil {
		return *x.DestinationZone
	}
	return ""
}

func (x *DiskMoveRequest) GetTargetDisk() string {
	if x != nil && x.TargetDisk != nil {
		return *x.TargetDisk
	}
	return ""
}

// Represents a Disk Type resource.
//
// Google Compute Engine has two Disk Type resources:
//
// * [Regional](/compute/docs/reference/rest/{$api_version}/regionDiskTypes) * [Zonal](/compute/docs/reference/rest/{$api_version}/diskTypes)
//
// You can choose from a variety of disk types based on your needs. For more information, read Storage options.
//
// The diskTypes resource represents disk types for a zonal persistent disk. For more information, read Zonal persistent disks.
//
// The regionDiskTypes resource represents disk types for a regional persistent disk. For more information, read Regional persistent disks. (== resource_for {$api_version}.diskTypes ==) (== resource_for {$api_version}.regionDiskTypes ==)
type DiskType struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// [Output Only] Creation timestamp in RFC3339 text format.
	CreationTimestamp *string `protobuf:"bytes,30525366,opt,name=creation_timestamp,json=creationTimestamp,proto3,oneof" json:"creation_timestamp,omitempty"`
	// [Output Only] Server-defined default disk size in GB.
	DefaultDiskSizeGb *int64 `protobuf:"varint,270619253,opt,name=default_disk_size_gb,json=defaultDiskSizeGb,proto3,oneof" json:"default_disk_size_gb,omitempty"`
	// [Output Only] The deprecation status associated with this disk type.
	Deprecated *DeprecationStatus `protobuf:"bytes,515138995,opt,name=deprecated,proto3,oneof" json:"deprecated,omitempty"`
	// [Output Only] An optional description of this resource.
	Description *string `protobuf:"bytes,422937596,opt,name=description,proto3,oneof" json:"description,omitempty"`
	// [Output Only] The unique identifier for the resource. This identifier is defined by the server.
	Id *uint64 `protobuf:"varint,3355,opt,name=id,proto3,oneof" json:"id,omitempty"`
	// [Output Only] Type of the resource. Always compute#diskType for disk types.
	Kind *string `protobuf:"bytes,3292052,opt,name=kind,proto3,oneof" json:"kind,omitempty"`
	// [Output Only] Name of the resource.
	Name *string `protobuf:"bytes,3373707,opt,name=name,proto3,oneof" json:"name,omitempty"`
	// [Output Only] URL of the region where the disk type resides. Only applicable for regional resources. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
	Region *string `protobuf:"bytes,138946292,opt,name=region,proto3,oneof" json:"region,omitempty"`
	// [Output Only] Server-defined URL for the resource.
	SelfLink *string `protobuf:"bytes,456214797,opt,name=self_link,json=selfLink,proto3,oneof" json:"self_link,omitempty"`
	// [Output Only] An optional textual description of the valid disk size, such as "10GB-10TB".
	ValidDiskSize *string `protobuf:"bytes,493962464,opt,name=valid_disk_size,json=validDiskSize,proto3,oneof" json:"valid_disk_size,omitempty"`
	// [Output Only] URL of the zone where the disk type resides. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
	Zone *string `protobuf:"bytes,3744684,opt,name=zone,proto3,oneof" json:"zone,omitempty"`
}

func (x *DiskType) Reset() {
	*x = DiskType{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[90]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DiskType) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DiskType) ProtoMessage() {}

func (x *DiskType) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[90]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DiskType.ProtoReflect.Descriptor instead.
func (*DiskType) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{90}
}

func (x *DiskType) GetCreationTimestamp() string {
	if x != nil && x.CreationTimestamp != nil {
		return *x.CreationTimestamp
	}
	return ""
}

func (x *DiskType) GetDefaultDiskSizeGb() int64 {
	if x != nil && x.DefaultDiskSizeGb != nil {
		return *x.DefaultDiskSizeGb
	}
	return 0
}

func (x *DiskType) GetDeprecated() *DeprecationStatus {
	if x != nil {
		return x.Deprecated
	}
	return nil
}

func (x *DiskType) GetDescription() string {
	if x != nil && x.Description != nil {
		return *x.Description
	}
	return ""
}

func (x *DiskType) GetId() uint64 {
	if x != nil && x.Id != nil {
		return *x.Id
	}
	return 0
}

func (x *DiskType) GetKind() string {
	if x != nil && x.Kind != nil {
		return *x.Kind
	}
	return ""
}

func (x *DiskType) GetName() string {
	if x != nil && x.Name != nil {
		return *x.Name
	}
	return ""
}

func (x *DiskType) GetRegion() string {
	if x != nil && x.Region != nil {
		return *x.Region
	}
	return ""
}

func (x *DiskType) GetSelfLink() string {
	if x != nil && x.SelfLink != nil {
		return *x.SelfLink
	}
	return ""
}

func (x *DiskType) GetValidDiskSize() string {
	if x != nil && x.ValidDiskSize != nil {
		return *x.ValidDiskSize
	}
	return ""
}

func (x *DiskType) GetZone() string {
	if x != nil && x.Zone != nil {
		return *x.Zone
	}
	return ""
}

//
type DiskTypesScopedList struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// [Output Only] A list of disk types contained in this scope.
	DiskTypes []*DiskType `protobuf:"bytes,198926167,rep,name=disk_types,json=diskTypes,proto3" json:"disk_types,omitempty"`
	// [Output Only] Informational warning which replaces the list of disk types when the list is empty.
	Warning *Warning `protobuf:"bytes,50704284,opt,name=warning,proto3,oneof" json:"warning,omitempty"`
}

func (x *DiskTypesScopedList) Reset() {
	*x = DiskTypesScopedList{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[91]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DiskTypesScopedList) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DiskTypesScopedList) ProtoMessage() {}

func (x *DiskTypesScopedList) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[91]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DiskTypesScopedList.ProtoReflect.Descriptor instead.
func (*DiskTypesScopedList) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{91}
}

func (x *DiskTypesScopedList) GetDiskTypes() []*DiskType {
	if x != nil {
		return x.DiskTypes
	}
	return nil
}

func (x *DiskTypesScopedList) GetWarning() *Warning {
	if x != nil {
		return x.Warning
	}
	return nil
}

//
type DiskTypeAggregatedList struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// [Output Only] Unique identifier for the resource; defined by the server.
	Id *string `protobuf:"bytes,3355,opt,name=id,proto3,oneof" json:"id,omitempty"`
	// A list of DiskTypesScopedList resources.
	Items map[string]*DiskTypesScopedList `protobuf:"bytes,100526016,rep,name=items,proto3" json:"items,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// [Output Only] Type of resource. Always compute#diskTypeAggregatedList.
	Kind *string `protobuf:"bytes,3292052,opt,name=kind,proto3,oneof" json:"kind,omitempty"`
	// [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
	NextPageToken *string `protobuf:"bytes,79797525,opt,name=next_page_token,json=nextPageToken,proto3,oneof" json:"next_page_token,omitempty"`
	// [Output Only] Server-defined URL for this resource.
	SelfLink *string `protobuf:"bytes,456214797,opt,name=self_link,json=selfLink,proto3,oneof" json:"self_link,omitempty"`
	// [Output Only] Unreachable resources.
	Unreachables []string `protobuf:"bytes,243372063,rep,name=unreachables,proto3" json:"unreachables,omitempty"`
	// [Output Only] Informational warning message.
	Warning *Warning `protobuf:"bytes,50704284,opt,name=warning,proto3,oneof" json:"warning,omitempty"`
}

func (x *DiskTypeAggregatedList) Reset() {
	*x = DiskTypeAggregatedList{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[92]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DiskTypeAggregatedList) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DiskTypeAggregatedList) ProtoMessage() {}

func (x *DiskTypeAggregatedList) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[92]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DiskTypeAggregatedList.ProtoReflect.Descriptor instead.
func (*DiskTypeAggregatedList) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{92}
}

func (x *DiskTypeAggregatedList) GetId() string {
	if x != nil && x.Id != nil {
		return *x.Id
	}
	return ""
}

func (x *DiskTypeAggregatedList) GetItems() map[string]*DiskTypesScopedList {
	if x != nil {
		return x.Items
	}
	return nil
}

func (x *DiskTypeAggregatedList) GetKind() string {
	if x != nil && x.Kind != nil {
		return *x.Kind
	}
	return ""
}

func (x *DiskTypeAggregatedList) GetNextPageToken() string {
	if x != nil && x.NextPageToken != nil {
		return *x.NextPageToken
	}
	return ""
}

func (x *DiskTypeAggregatedList) GetSelfLink() string {
	if x != nil && x.SelfLink != nil {
		return *x.SelfLink
	}
	return ""
}

func (x *DiskTypeAggregatedList) GetUnreachables() []string {
	if x != nil {
		return x.Unreachables
	}
	return nil
}

func (x *DiskTypeAggregatedList) GetWarning() *Warning {
	if x != nil {
		return x.Warning
	}
	return nil
}

// Contains a list of disk types.
type DiskTypeList struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// [Output Only] Unique identifier for the resource; defined by the server.
	Id *string `protobuf:"bytes,3355,opt,name=id,proto3,oneof" json:"id,omitempty"`
	// A list of DiskType resources.
	Items []*DiskType `protobuf:"bytes,100526016,rep,name=items,proto3" json:"items,omitempty"`
	// [Output Only] Type of resource. Always compute#diskTypeList for disk types.
	Kind *string `protobuf:"bytes,3292052,opt,name=kind,proto3,oneof" json:"kind,omitempty"`
	// [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
	NextPageToken *string `protobuf:"bytes,79797525,opt,name=next_page_token,json=nextPageToken,proto3,oneof" json:"next_page_token,omitempty"`
	// [Output Only] Server-defined URL for this resource.
	SelfLink *string `protobuf:"bytes,456214797,opt,name=self_link,json=selfLink,proto3,oneof" json:"self_link,omitempty"`
	// [Output Only] Informational warning message.
	Warning *Warning `protobuf:"bytes,50704284,opt,name=warning,proto3,oneof" json:"warning,omitempty"`
}

func (x *DiskTypeList) Reset() {
	*x = DiskTypeList{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[93]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DiskTypeList) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DiskTypeList) ProtoMessage() {}

func (x *DiskTypeList) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[93]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DiskTypeList.ProtoReflect.Descriptor instead.
func (*DiskTypeList) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{93}
}

func (x *DiskTypeList) GetId() string {
	if x != nil && x.Id != nil {
		return *x.Id
	}
	return ""
}

func (x *DiskTypeList) GetItems() []*DiskType {
	if x != nil {
		return x.Items
	}
	return nil
}

func (x *DiskTypeList) GetKind() string {
	if x != nil && x.Kind != nil {
		return *x.Kind
	}
	return ""
}

func (x *DiskTypeList) GetNextPageToken() string {
	if x != nil && x.NextPageToken != nil {
		return *x.NextPageToken
	}
	return ""
}

func (x *DiskTypeList) GetSelfLink() string {
	if x != nil && x.SelfLink != nil {
		return *x.SelfLink
	}
	return ""
}

func (x *DiskTypeList) GetWarning() *Warning {
	if x != nil {
		return x.Warning
	}
	return nil
}

//
type DisksAddResourcePoliciesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Resource policies to be added to this disk. Currently you can only specify one policy here.
	ResourcePolicies []string `protobuf:"bytes,22220385,rep,name=resource_policies,json=resourcePolicies,proto3" json:"resource_policies,omitempty"`
}

func (x *DisksAddResourcePoliciesRequest) Reset() {
	*x = DisksAddResourcePoliciesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[94]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DisksAddResourcePoliciesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DisksAddResourcePoliciesRequest) ProtoMessage() {}

func (x *DisksAddResourcePoliciesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[94]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DisksAddResourcePoliciesRequest.ProtoReflect.Descriptor instead.
func (*DisksAddResourcePoliciesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{94}
}

func (x *DisksAddResourcePoliciesRequest) GetResourcePolicies() []string {
	if x != nil {
		return x.ResourcePolicies
	}
	return nil
}

//
type DisksRemoveResourcePoliciesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Resource policies to be removed from this disk.
	ResourcePolicies []string `protobuf:"bytes,22220385,rep,name=resource_policies,json=resourcePolicies,proto3" json:"resource_policies,omitempty"`
}

func (x *DisksRemoveResourcePoliciesRequest) Reset() {
	*x = DisksRemoveResourcePoliciesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[95]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DisksRemoveResourcePoliciesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DisksRemoveResourcePoliciesRequest) ProtoMessage() {}

func (x *DisksRemoveResourcePoliciesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[95]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DisksRemoveResourcePoliciesRequest.ProtoReflect.Descriptor instead.
func (*DisksRemoveResourcePoliciesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{95}
}

func (x *DisksRemoveResourcePoliciesRequest) GetResourcePolicies() []string {
	if x != nil {
		return x.ResourcePolicies
	}
	return nil
}

//
type DisksResizeRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The new size of the persistent disk, which is specified in GB.
	SizeGb *int64 `protobuf:"varint,494929369,opt,name=size_gb,json=sizeGb,proto3,oneof" json:"size_gb,omitempty"`
}

func (x *DisksResizeRequest) Reset() {
	*x = DisksResizeRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[96]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DisksResizeRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DisksResizeRequest) ProtoMessage() {}

func (x *DisksResizeRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[96]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DisksResizeRequest.ProtoReflect.Descriptor instead.
func (*DisksResizeRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{96}
}

func (x *DisksResizeRequest) GetSizeGb() int64 {
	if x != nil && x.SizeGb != nil {
		return *x.SizeGb
	}
	return 0
}

// A set of Display Device options
type DisplayDevice struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Defines whether the instance has Display enabled.
	EnableDisplay *bool `protobuf:"varint,14266886,opt,name=enable_display,json=enableDisplay,proto3,oneof" json:"enable_display,omitempty"`
}

func (x *DisplayDevice) Reset() {
	*x = DisplayDevice{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[97]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DisplayDevice) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DisplayDevice) ProtoMessage() {}

func (x *DisplayDevice) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[97]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DisplayDevice.ProtoReflect.Descriptor instead.
func (*DisplayDevice) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{97}
}

func (x *DisplayDevice) GetEnableDisplay() bool {
	if x != nil && x.EnableDisplay != nil {
		return *x.EnableDisplay
	}
	return false
}

//
type DistributionPolicyZoneConfiguration struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The URL of the zone. The zone must exist in the region where the managed instance group is located.
	Zone *string `protobuf:"bytes,3744684,opt,name=zone,proto3,oneof" json:"zone,omitempty"`
}

func (x *DistributionPolicyZoneConfiguration) Reset() {
	*x = DistributionPolicyZoneConfiguration{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[98]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DistributionPolicyZoneConfiguration) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DistributionPolicyZoneConfiguration) ProtoMessage() {}

func (x *DistributionPolicyZoneConfiguration) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[98]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DistributionPolicyZoneConfiguration.ProtoReflect.Descriptor instead.
func (*DistributionPolicyZoneConfiguration) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{98}
}

func (x *DistributionPolicyZoneConfiguration) GetZone() string {
	if x != nil && x.Zone != nil {
		return *x.Zone
	}
	return ""
}

//
type DistributionPolicy struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The distribution shape to which the group converges either proactively or on resize events (depending on the value set in updatePolicy.instanceRedistributionType).
	TargetShape *DistributionPolicy_TargetShape `protobuf:"varint,338621299,opt,name=target_shape,json=targetShape,proto3,enum=google.cloud.compute.v1.DistributionPolicy_TargetShape,oneof" json:"target_shape,omitempty"`
	// Zones where the regional managed instance group will create and manage its instances.
	Zones []*DistributionPolicyZoneConfiguration `protobuf:"bytes,116085319,rep,name=zones,proto3" json:"zones,omitempty"`
}

func (x *DistributionPolicy) Reset() {
	*x = DistributionPolicy{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[99]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DistributionPolicy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DistributionPolicy) ProtoMessage() {}

func (x *DistributionPolicy) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[99]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DistributionPolicy.ProtoReflect.Descriptor instead.
func (*DistributionPolicy) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{99}
}

func (x *DistributionPolicy) GetTargetShape() DistributionPolicy_TargetShape {
	if x != nil && x.TargetShape != nil {
		return *x.TargetShape
	}
	return DistributionPolicy_UNDEFINED_TARGET_SHAPE
}

func (x *DistributionPolicy) GetZones() []*DistributionPolicyZoneConfiguration {
	if x != nil {
		return x.Zones
	}
	return nil
}

//
type ExchangedPeeringRoute struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The destination range of the route.
	DestRange *string `protobuf:"bytes,381327712,opt,name=dest_range,json=destRange,proto3,oneof" json:"dest_range,omitempty"`
	// True if the peering route has been imported from a peer. The actual import happens if the field networkPeering.importCustomRoutes is true for this network, and networkPeering.exportCustomRoutes is true for the peer network, and the import does not result in a route conflict.
	Imported *bool `protobuf:"varint,114502404,opt,name=imported,proto3,oneof" json:"imported,omitempty"`
	// The region of peering route next hop, only applies to dynamic routes.
	NextHopRegion *string `protobuf:"bytes,122577014,opt,name=next_hop_region,json=nextHopRegion,proto3,oneof" json:"next_hop_region,omitempty"`
	// The priority of the peering route.
	Priority *uint32 `protobuf:"varint,445151652,opt,name=priority,proto3,oneof" json:"priority,omitempty"`
	// The type of the peering route.
	Type *ExchangedPeeringRoute_Type `protobuf:"varint,3575610,opt,name=type,proto3,enum=google.cloud.compute.v1.ExchangedPeeringRoute_Type,oneof" json:"type,omitempty"`
}

func (x *ExchangedPeeringRoute) Reset() {
	*x = ExchangedPeeringRoute{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[100]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExchangedPeeringRoute) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExchangedPeeringRoute) ProtoMessage() {}

func (x *ExchangedPeeringRoute) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[100]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExchangedPeeringRoute.ProtoReflect.Descriptor instead.
func (*ExchangedPeeringRoute) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{100}
}

func (x *ExchangedPeeringRoute) GetDestRange() string {
	if x != nil && x.DestRange != nil {
		return *x.DestRange
	}
	return ""
}

func (x *ExchangedPeeringRoute) GetImported() bool {
	if x != nil && x.Imported != nil {
		return *x.Imported
	}
	return false
}

func (x *ExchangedPeeringRoute) GetNextHopRegion() string {
	if x != nil && x.NextHopRegion != nil {
		return *x.NextHopRegion
	}
	return ""
}

func (x *ExchangedPeeringRoute) GetPriority() uint32 {
	if x != nil && x.Priority != nil {
		return *x.Priority
	}
	return 0
}

func (x *ExchangedPeeringRoute) GetType() ExchangedPeeringRoute_Type {
	if x != nil && x.Type != nil {
		return *x.Type
	}
	return ExchangedPeeringRoute_UNDEFINED_TYPE
}

//
type ExchangedPeeringRoutesList struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// [Output Only] Unique identifier for the resource; defined by the server.
	Id *string `protobuf:"bytes,3355,opt,name=id,proto3,oneof" json:"id,omitempty"`
	// A list of ExchangedPeeringRoute resources.
	Items []*ExchangedPeeringRoute `protobuf:"bytes,100526016,rep,name=items,proto3" json:"items,omitempty"`
	// [Output Only] Type of resource. Always compute#exchangedPeeringRoutesList for exchanged peering routes lists.
	Kind *string `protobuf:"bytes,3292052,opt,name=kind,proto3,oneof" json:"kind,omitempty"`
	// [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
	NextPageToken *string `protobuf:"bytes,79797525,opt,name=next_page_token,json=nextPageToken,proto3,oneof" json:"next_page_token,omitempty"`
	// [Output Only] Server-defined URL for this resource.
	SelfLink *string `protobuf:"bytes,456214797,opt,name=self_link,json=selfLink,proto3,oneof" json:"self_link,omitempty"`
	// [Output Only] Informational warning message.
	Warning *Warning `protobuf:"bytes,50704284,opt,name=warning,proto3,oneof" json:"warning,omitempty"`
}

func (x *ExchangedPeeringRoutesList) Reset() {
	*x = ExchangedPeeringRoutesList{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[101]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExchangedPeeringRoutesList) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExchangedPeeringRoutesList) ProtoMessage() {}

func (x *ExchangedPeeringRoutesList) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[101]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExchangedPeeringRoutesList.ProtoReflect.Descriptor instead.
func (*ExchangedPeeringRoutesList) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{101}
}

func (x *ExchangedPeeringRoutesList) GetId() string {
	if x != nil && x.Id != nil {
		return *x.Id
	}
	return ""
}

func (x *ExchangedPeeringRoutesList) GetItems() []*ExchangedPeeringRoute {
	if x != nil {
		return x.Items
	}
	return nil
}

func (x *ExchangedPeeringRoutesList) GetKind() string {
	if x != nil && x.Kind != nil {
		return *x.Kind
	}
	return ""
}

func (x *ExchangedPeeringRoutesList) GetNextPageToken() string {
	if x != nil && x.NextPageToken != nil {
		return *x.NextPageToken
	}
	return ""
}

func (x *ExchangedPeeringRoutesList) GetSelfLink() string {
	if x != nil && x.SelfLink != nil {
		return *x.SelfLink
	}
	return ""
}

func (x *ExchangedPeeringRoutesList) GetWarning() *Warning {
	if x != nil {
		return x.Warning
	}
	return nil
}

// The interface for the external VPN gateway.
type ExternalVpnGatewayInterface struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The numeric ID of this interface. The allowed input values for this id for different redundancy types of external VPN gateway: SINGLE_IP_INTERNALLY_REDUNDANT - 0 TWO_IPS_REDUNDANCY - 0, 1 FOUR_IPS_REDUNDANCY - 0, 1, 2, 3
	Id *uint32 `protobuf:"varint,3355,opt,name=id,proto3,oneof" json:"id,omitempty"`
	// IP address of the interface in the external VPN gateway. Only IPv4 is supported. This IP address can be either from your on-premise gateway or another Cloud provider's VPN gateway, it cannot be an IP address from Google Compute Engine.
	IpAddress *string `protobuf:"bytes,406272220,opt,name=ip_address,json=ipAddress,proto3,oneof" json:"ip_address,omitempty"`
}

func (x *ExternalVpnGatewayInterface) Reset() {
	*x = ExternalVpnGatewayInterface{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[102]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExternalVpnGatewayInterface) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExternalVpnGatewayInterface) ProtoMessage() {}

func (x *ExternalVpnGatewayInterface) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[102]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExternalVpnGatewayInterface.ProtoReflect.Descriptor instead.
func (*ExternalVpnGatewayInterface) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{102}
}

func (x *ExternalVpnGatewayInterface) GetId() uint32 {
	if x != nil && x.Id != nil {
		return *x.Id
	}
	return 0
}

func (x *ExternalVpnGatewayInterface) GetIpAddress() string {
	if x != nil && x.IpAddress != nil {
		return *x.IpAddress
	}
	return ""
}

// Represents an external VPN gateway.
//
// External VPN gateway is the on-premises VPN gateway(s) or another cloud provider's VPN gateway that connects to your Google Cloud VPN gateway.
//
// To create a highly available VPN from Google Cloud Platform to your VPN gateway or another cloud provider's VPN gateway, you must create a external VPN gateway resource with information about the other gateway.
//
// For more information about using external VPN gateways, see  Creating an HA VPN gateway and tunnel pair to a peer VPN. (== resource_for {$api_version}.externalVpnGateways ==)
type ExternalVpnGateway struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// [Output Only] Creation timestamp in RFC3339 text format.
	CreationTimestamp *string `protobuf:"bytes,30525366,opt,name=creation_timestamp,json=creationTimestamp,proto3,oneof" json:"creation_timestamp,omitempty"`
	// An optional description of this resource. Provide this property when you create the resource.
	Description *string `protobuf:"bytes,422937596,opt,name=description,proto3,oneof" json:"description,omitempty"`
	// [Output Only] The unique identifier for the resource. This identifier is defined by the server.
	Id *uint64 `protobuf:"varint,3355,opt,name=id,proto3,oneof" json:"id,omitempty"`
	// List of interfaces for this external VPN gateway.
	Interfaces []*ExternalVpnGatewayInterface `protobuf:"bytes,12073562,rep,name=interfaces,proto3" json:"interfaces,omitempty"`
	// [Output Only] Type of the resource. Always compute#externalVpnGateway for externalVpnGateways.
	Kind *string `protobuf:"bytes,3292052,opt,name=kind,proto3,oneof" json:"kind,omitempty"`
	// A fingerprint for the labels being applied to this ExternalVpnGateway, which is essentially a hash of the labels set used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update labels. You must always provide an up-to-date fingerprint hash in order to update or change labels, otherwise the request will fail with error 412 conditionNotMet.
	//
	// To see the latest fingerprint, make a get() request to retrieve an ExternalVpnGateway.
	LabelFingerprint *string `protobuf:"bytes,178124825,opt,name=label_fingerprint,json=labelFingerprint,proto3,oneof" json:"label_fingerprint,omitempty"`
	// Labels for this resource. These can only be added or modified by the setLabels method. Each label key/value pair must comply with RFC1035. Label values may be empty.
	Labels map[string]string `protobuf:"bytes,500195327,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
	Name *string `protobuf:"bytes,3373707,opt,name=name,proto3,oneof" json:"name,omitempty"`
	// Indicates the user-supplied redundancy type of this external VPN gateway.
	RedundancyType *ExternalVpnGateway_RedundancyType `protobuf:"varint,271443740,opt,name=redundancy_type,json=redundancyType,proto3,enum=google.cloud.compute.v1.ExternalVpnGateway_RedundancyType,oneof" json:"redundancy_type,omitempty"`
	// [Output Only] Server-defined URL for the resource.
	SelfLink *string `protobuf:"bytes,456214797,opt,name=self_link,json=selfLink,proto3,oneof" json:"self_link,omitempty"`
}

func (x *ExternalVpnGateway) Reset() {
	*x = ExternalVpnGateway{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[103]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExternalVpnGateway) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExternalVpnGateway) ProtoMessage() {}

func (x *ExternalVpnGateway) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[103]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExternalVpnGateway.ProtoReflect.Descriptor instead.
func (*ExternalVpnGateway) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{103}
}

func (x *ExternalVpnGateway) GetCreationTimestamp() string {
	if x != nil && x.CreationTimestamp != nil {
		return *x.CreationTimestamp
	}
	return ""
}

func (x *ExternalVpnGateway) GetDescription() string {
	if x != nil && x.Description != nil {
		return *x.Description
	}
	return ""
}

func (x *ExternalVpnGateway) GetId() uint64 {
	if x != nil && x.Id != nil {
		return *x.Id
	}
	return 0
}

func (x *ExternalVpnGateway) GetInterfaces() []*ExternalVpnGatewayInterface {
	if x != nil {
		return x.Interfaces
	}
	return nil
}

func (x *ExternalVpnGateway) GetKind() string {
	if x != nil && x.Kind != nil {
		return *x.Kind
	}
	return ""
}

func (x *ExternalVpnGateway) GetLabelFingerprint() string {
	if x != nil && x.LabelFingerprint != nil {
		return *x.LabelFingerprint
	}
	return ""
}

func (x *ExternalVpnGateway) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *ExternalVpnGateway) GetName() string {
	if x != nil && x.Name != nil {
		return *x.Name
	}
	return ""
}

func (x *ExternalVpnGateway) GetRedundancyType() ExternalVpnGateway_RedundancyType {
	if x != nil && x.RedundancyType != nil {
		return *x.RedundancyType
	}
	return ExternalVpnGateway_UNDEFINED_REDUNDANCY_TYPE
}

func (x *ExternalVpnGateway) GetSelfLink() string {
	if x != nil && x.SelfLink != nil {
		return *x.SelfLink
	}
	return ""
}

// Response to the list request, and contains a list of externalVpnGateways.
type ExternalVpnGatewayList struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Etag *string `protobuf:"bytes,3123477,opt,name=etag,proto3,oneof" json:"etag,omitempty"`
	// [Output Only] Unique identifier for the resource; defined by the server.
	Id *string `protobuf:"bytes,3355,opt,name=id,proto3,oneof" json:"id,omitempty"`
	// A list of ExternalVpnGateway resources.
	Items []*ExternalVpnGateway `protobuf:"bytes,100526016,rep,name=items,proto3" json:"items,omitempty"`
	// [Output Only] Type of resource. Always compute#externalVpnGatewayList  for lists of externalVpnGateways.
	Kind *string `protobuf:"bytes,3292052,opt,name=kind,proto3,oneof" json:"kind,omitempty"`
	// [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
	NextPageToken *string `protobuf:"bytes,79797525,opt,name=next_page_token,json=nextPageToken,proto3,oneof" json:"next_page_token,omitempty"`
	// [Output Only] Server-defined URL for this resource.
	SelfLink *string `protobuf:"bytes,456214797,opt,name=self_link,json=selfLink,proto3,oneof" json:"self_link,omitempty"`
	// [Output Only] Informational warning message.
	Warning *Warning `protobuf:"bytes,50704284,opt,name=warning,proto3,oneof" json:"warning,omitempty"`
}

func (x *ExternalVpnGatewayList) Reset() {
	*x = ExternalVpnGatewayList{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[104]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExternalVpnGatewayList) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExternalVpnGatewayList) ProtoMessage() {}

func (x *ExternalVpnGatewayList) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[104]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExternalVpnGatewayList.ProtoReflect.Descriptor instead.
func (*ExternalVpnGatewayList) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{104}
}

func (x *ExternalVpnGatewayList) GetEtag() string {
	if x != nil && x.Etag != nil {
		return *x.Etag
	}
	return ""
}

func (x *ExternalVpnGatewayList) GetId() string {
	if x != nil && x.Id != nil {
		return *x.Id
	}
	return ""
}

func (x *ExternalVpnGatewayList) GetItems() []*ExternalVpnGateway {
	if x != nil {
		return x.Items
	}
	return nil
}

func (x *ExternalVpnGatewayList) GetKind() string {
	if x != nil && x.Kind != nil {
		return *x.Kind
	}
	return ""
}

func (x *ExternalVpnGatewayList) GetNextPageToken() string {
	if x != nil && x.NextPageToken != nil {
		return *x.NextPageToken
	}
	return ""
}

func (x *ExternalVpnGatewayList) GetSelfLink() string {
	if x != nil && x.SelfLink != nil {
		return *x.SelfLink
	}
	return ""
}

func (x *ExternalVpnGatewayList) GetWarning() *Warning {
	if x != nil {
		return x.Warning
	}
	return nil
}

//
type FileContentBuffer struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The raw content in the secure keys file.
	Content *string `protobuf:"bytes,414659705,opt,name=content,proto3,oneof" json:"content,omitempty"`
	// The file type of source file.
	FileType *FileContentBuffer_FileType `protobuf:"varint,294346781,opt,name=file_type,json=fileType,proto3,enum=google.cloud.compute.v1.FileContentBuffer_FileType,oneof" json:"file_type,omitempty"`
}

func (x *FileContentBuffer) Reset() {
	*x = FileContentBuffer{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[105]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FileContentBuffer) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FileContentBuffer) ProtoMessage() {}

func (x *FileContentBuffer) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[105]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FileContentBuffer.ProtoReflect.Descriptor instead.
func (*FileContentBuffer) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{105}
}

func (x *FileContentBuffer) GetContent() string {
	if x != nil && x.Content != nil {
		return *x.Content
	}
	return ""
}

func (x *FileContentBuffer) GetFileType() FileContentBuffer_FileType {
	if x != nil && x.FileType != nil {
		return *x.FileType
	}
	return FileContentBuffer_UNDEFINED_FILE_TYPE
}

//
type Allowed struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The IP protocol to which this rule applies. The protocol type is required when creating a firewall rule. This value can either be one of the following well known protocol strings (tcp, udp, icmp, esp, ah, ipip, sctp) or the IP protocol number.
	IPProtocol *string `protobuf:"bytes,488094525,opt,name=I_p_protocol,json=IPProtocol,proto3,oneof" json:"I_p_protocol,omitempty"`
	// An optional list of ports to which this rule applies. This field is only applicable for the UDP or TCP protocol. Each entry must be either an integer or a range. If not specified, this rule applies to connections through any port.
	//
	// Example inputs include: ["22"], ["80","443"], and ["12345-12349"].
	Ports []string `protobuf:"bytes,106854418,rep,name=ports,proto3" json:"ports,omitempty"`
}

func (x *Allowed) Reset() {
	*x = Allowed{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[106]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Allowed) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Allowed) ProtoMessage() {}

func (x *Allowed) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[106]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Allowed.ProtoReflect.Descriptor instead.
func (*Allowed) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{106}
}

func (x *Allowed) GetIPProtocol() string {
	if x != nil && x.IPProtocol != nil {
		return *x.IPProtocol
	}
	return ""
}

func (x *Allowed) GetPorts() []string {
	if x != nil {
		return x.Ports
	}
	return nil
}

//
type Denied struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The IP protocol to which this rule applies. The protocol type is required when creating a firewall rule. This value can either be one of the following well known protocol strings (tcp, udp, icmp, esp, ah, ipip, sctp) or the IP protocol number.
	IPProtocol *string `protobuf:"bytes,488094525,opt,name=I_p_protocol,json=IPProtocol,proto3,oneof" json:"I_p_protocol,omitempty"`
	// An optional list of ports to which this rule applies. This field is only applicable for the UDP or TCP protocol. Each entry must be either an integer or a range. If not specified, this rule applies to connections through any port.
	//
	// Example inputs include: ["22"], ["80","443"], and ["12345-12349"].
	Ports []string `protobuf:"bytes,106854418,rep,name=ports,proto3" json:"ports,omitempty"`
}

func (x *Denied) Reset() {
	*x = Denied{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[107]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Denied) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Denied) ProtoMessage() {}

func (x *Denied) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[107]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Denied.ProtoReflect.Descriptor instead.
func (*Denied) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{107}
}

func (x *Denied) GetIPProtocol() string {
	if x != nil && x.IPProtocol != nil {
		return *x.IPProtocol
	}
	return ""
}

func (x *Denied) GetPorts() []string {
	if x != nil {
		return x.Ports
	}
	return nil
}

// The available logging options for a firewall rule.
type FirewallLogConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// This field denotes whether to enable logging for a particular firewall rule.
	Enable *bool `protobuf:"varint,311764355,opt,name=enable,proto3,oneof" json:"enable,omitempty"`
	// This field can only be specified for a particular firewall rule if logging is enabled for that rule. This field denotes whether to include or exclude metadata for firewall logs.
	Metadata *FirewallLogConfig_Metadata `protobuf:"varint,86866735,opt,name=metadata,proto3,enum=google.cloud.compute.v1.FirewallLogConfig_Metadata,oneof" json:"metadata,omitempty"`
}

func (x *FirewallLogConfig) Reset() {
	*x = FirewallLogConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[108]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FirewallLogConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FirewallLogConfig) ProtoMessage() {}

func (x *FirewallLogConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[108]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FirewallLogConfig.ProtoReflect.Descriptor instead.
func (*FirewallLogConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{108}
}

func (x *FirewallLogConfig) GetEnable() bool {
	if x != nil && x.Enable != nil {
		return *x.Enable
	}
	return false
}

func (x *FirewallLogConfig) GetMetadata() FirewallLogConfig_Metadata {
	if x != nil && x.Metadata != nil {
		return *x.Metadata
	}
	return FirewallLogConfig_UNDEFINED_METADATA
}

// Represents a Firewall Rule resource.
//
// Firewall rules allow or deny ingress traffic to, and egress traffic from your instances. For more information, read Firewall rules.
type Firewall struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of ALLOW rules specified by this firewall. Each rule specifies a protocol and port-range tuple that describes a permitted connection.
	Allowed []*Allowed `protobuf:"bytes,162398632,rep,name=allowed,proto3" json:"allowed,omitempty"`
	// [Output Only] Creation timestamp in RFC3339 text format.
	CreationTimestamp *string `protobuf:"bytes,30525366,opt,name=creation_timestamp,json=creationTimestamp,proto3,oneof" json:"creation_timestamp,omitempty"`
	// The list of DENY rules specified by this firewall. Each rule specifies a protocol and port-range tuple that describes a denied connection.
	Denied []*Denied `protobuf:"bytes,275217307,rep,name=denied,proto3" json:"denied,omitempty"`
	// An optional description of this resource. Provide this field when you create the resource.
	Description *string `protobuf:"bytes,422937596,opt,name=description,proto3,oneof" json:"description,omitempty"`
	// If destination ranges are specified, the firewall rule applies only to traffic that has destination IP address in these ranges. These ranges must be expressed in CIDR format. Only IPv4 is supported.
	DestinationRanges []string `protobuf:"bytes,305699879,rep,name=destination_ranges,json=destinationRanges,proto3" json:"destination_ranges,omitempty"`
	// Direction of traffic to which this firewall applies, either `INGRESS` or `EGRESS`. The default is `INGRESS`. For `INGRESS` traffic, you cannot specify the destinationRanges field, and for `EGRESS` traffic, you cannot specify the sourceRanges or sourceTags fields.
	Direction *Firewall_Direction `protobuf:"varint,111150975,opt,name=direction,proto3,enum=google.cloud.compute.v1.Firewall_Direction,oneof" json:"direction,omitempty"`
	// Denotes whether the firewall rule is disabled. When set to true, the firewall rule is not enforced and the network behaves as if it did not exist. If this is unspecified, the firewall rule will be enabled.
	Disabled *bool `protobuf:"varint,270940796,opt,name=disabled,proto3,oneof" json:"disabled,omitempty"`
	// [Output Only] The unique identifier for the resource. This identifier is defined by the server.
	Id *uint64 `protobuf:"varint,3355,opt,name=id,proto3,oneof" json:"id,omitempty"`
	// [Output Only] Type of the resource. Always compute#firewall for firewall rules.
	Kind *string `protobuf:"bytes,3292052,opt,name=kind,proto3,oneof" json:"kind,omitempty"`
	// This field denotes the logging options for a particular firewall rule. If logging is enabled, logs will be exported to Cloud Logging.
	LogConfig *FirewallLogConfig `protobuf:"bytes,351299741,opt,name=log_config,json=logConfig,proto3,oneof" json:"log_config,omitempty"`
	// Name of the resource; provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?. The first character must be a lowercase letter, and all following characters (except for the last character) must be a dash, lowercase letter, or digit. The last character must be a lowercase letter or digit.
	Name *string `protobuf:"bytes,3373707,opt,name=name,proto3,oneof" json:"name,omitempty"`
	// URL of the network resource for this firewall rule. If not specified when creating a firewall rule, the default network is used:
	// global/networks/default
	// If you choose to specify this field, you can specify the network as a full or partial URL. For example, the following are all valid URLs:
	// - https://www.googleapis.com/compute/v1/projects/myproject/global/networks/my-network
	// - projects/myproject/global/networks/my-network
	// - global/networks/default
	Network *string `protobuf:"bytes,232872494,opt,name=network,proto3,oneof" json:"network,omitempty"`
	// Priority for this rule. This is an integer between `0` and `65535`, both inclusive. The default value is `1000`. Relative priorities determine which rule takes effect if multiple rules apply. Lower values indicate higher priority. For example, a rule with priority `0` has higher precedence than a rule with priority `1`. DENY rules take precedence over ALLOW rules if they have equal priority. Note that VPC networks have implied rules with a priority of `65535`. To avoid conflicts with the implied rules, use a priority number less than `65535`.
	Priority *int32 `protobuf:"varint,445151652,opt,name=priority,proto3,oneof" json:"priority,omitempty"`
	// [Output Only] Server-defined URL for the resource.
	SelfLink *string `protobuf:"bytes,456214797,opt,name=self_link,json=selfLink,proto3,oneof" json:"self_link,omitempty"`
	// If source ranges are specified, the firewall rule applies only to traffic that has a source IP address in these ranges. These ranges must be expressed in CIDR format. One or both of sourceRanges and sourceTags may be set. If both fields are set, the rule applies to traffic that has a source IP address within sourceRanges OR a source IP from a resource with a matching tag listed in the sourceTags field. The connection does not need to match both fields for the rule to apply. Only IPv4 is supported.
	SourceRanges []string `protobuf:"bytes,200097658,rep,name=source_ranges,json=sourceRanges,proto3" json:"source_ranges,omitempty"`
	// If source service accounts are specified, the firewall rules apply only to traffic originating from an instance with a service account in this list. Source service accounts cannot be used to control traffic to an instance's external IP address because service accounts are associated with an instance, not an IP address. sourceRanges can be set at the same time as sourceServiceAccounts. If both are set, the firewall applies to traffic that has a source IP address within the sourceRanges OR a source IP that belongs to an instance with service account listed in sourceServiceAccount. The connection does not need to match both fields for the firewall to apply. sourceServiceAccounts cannot be used at the same time as sourceTags or targetTags.
	SourceServiceAccounts []string `protobuf:"bytes,105100756,rep,name=source_service_accounts,json=sourceServiceAccounts,proto3" json:"source_service_accounts,omitempty"`
	// If source tags are specified, the firewall rule applies only to traffic with source IPs that match the primary network interfaces of VM instances that have the tag and are in the same VPC network. Source tags cannot be used to control traffic to an instance's external IP address, it only applies to traffic between instances in the same virtual network. Because tags are associated with instances, not IP addresses. One or both of sourceRanges and sourceTags may be set. If both fields are set, the firewall applies to traffic that has a source IP address within sourceRanges OR a source IP from a resource with a matching tag listed in the sourceTags field. The connection does not need to match both fields for the firewall to apply.
	SourceTags []string `protobuf:"bytes,452222397,rep,name=source_tags,json=sourceTags,proto3" json:"source_tags,omitempty"`
	// A list of service accounts indicating sets of instances located in the network that may make network connections as specified in allowed[]. targetServiceAccounts cannot be used at the same time as targetTags or sourceTags. If neither targetServiceAccounts nor targetTags are specified, the firewall rule applies to all instances on the specified network.
	TargetServiceAccounts []string `protobuf:"bytes,457639710,rep,name=target_service_accounts,json=targetServiceAccounts,proto3" json:"target_service_accounts,omitempty"`
	// A list of tags that controls which instances the firewall rule applies to. If targetTags are specified, then the firewall rule applies only to instances in the VPC network that have one of those tags. If no targetTags are specified, the firewall rule applies to all instances on the specified network.
	TargetTags []string `protobuf:"bytes,62901767,rep,name=target_tags,json=targetTags,proto3" json:"target_tags,omitempty"`
}

func (x *Firewall) Reset() {
	*x = Firewall{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[109]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Firewall) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Firewall) ProtoMessage() {}

func (x *Firewall) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[109]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Firewall.ProtoReflect.Descriptor instead.
func (*Firewall) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{109}
}

func (x *Firewall) GetAllowed() []*Allowed {
	if x != nil {
		return x.Allowed
	}
	return nil
}

func (x *Firewall) GetCreationTimestamp() string {
	if x != nil && x.CreationTimestamp != nil {
		return *x.CreationTimestamp
	}
	return ""
}

func (x *Firewall) GetDenied() []*Denied {
	if x != nil {
		return x.Denied
	}
	return nil
}

func (x *Firewall) GetDescription() string {
	if x != nil && x.Description != nil {
		return *x.Description
	}
	return ""
}

func (x *Firewall) GetDestinationRanges() []string {
	if x != nil {
		return x.DestinationRanges
	}
	return nil
}

func (x *Firewall) GetDirection() Firewall_Direction {
	if x != nil && x.Direction != nil {
		return *x.Direction
	}
	return Firewall_UNDEFINED_DIRECTION
}

func (x *Firewall) GetDisabled() bool {
	if x != nil && x.Disabled != nil {
		return *x.Disabled
	}
	return false
}

func (x *Firewall) GetId() uint64 {
	if x != nil && x.Id != nil {
		return *x.Id
	}
	return 0
}

func (x *Firewall) GetKind() string {
	if x != nil && x.Kind != nil {
		return *x.Kind
	}
	return ""
}

func (x *Firewall) GetLogConfig() *FirewallLogConfig {
	if x != nil {
		return x.LogConfig
	}
	return nil
}

func (x *Firewall) GetName() string {
	if x != nil && x.Name != nil {
		return *x.Name
	}
	return ""
}

func (x *Firewall) GetNetwork() string {
	if x != nil && x.Network != nil {
		return *x.Network
	}
	return ""
}

func (x *Firewall) GetPriority() int32 {
	if x != nil && x.Priority != nil {
		return *x.Priority
	}
	return 0
}

func (x *Firewall) GetSelfLink() string {
	if x != nil && x.SelfLink != nil {
		return *x.SelfLink
	}
	return ""
}

func (x *Firewall) GetSourceRanges() []string {
	if x != nil {
		return x.SourceRanges
	}
	return nil
}

func (x *Firewall) GetSourceServiceAccounts() []string {
	if x != nil {
		return x.SourceServiceAccounts
	}
	return nil
}

func (x *Firewall) GetSourceTags() []string {
	if x != nil {
		return x.SourceTags
	}
	return nil
}

func (x *Firewall) GetTargetServiceAccounts() []string {
	if x != nil {
		return x.TargetServiceAccounts
	}
	return nil
}

func (x *Firewall) GetTargetTags() []string {
	if x != nil {
		return x.TargetTags
	}
	return nil
}

// Contains a list of firewalls.
type FirewallList struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// [Output Only] Unique identifier for the resource; defined by the server.
	Id *string `protobuf:"bytes,3355,opt,name=id,proto3,oneof" json:"id,omitempty"`
	// A list of Firewall resources.
	Items []*Firewall `protobuf:"bytes,100526016,rep,name=items,proto3" json:"items,omitempty"`
	// [Output Only] Type of resource. Always compute#firewallList for lists of firewalls.
	Kind *string `protobuf:"bytes,3292052,opt,name=kind,proto3,oneof" json:"kind,omitempty"`
	// [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
	NextPageToken *string `protobuf:"bytes,79797525,opt,name=next_page_token,json=nextPageToken,proto3,oneof" json:"next_page_token,omitempty"`
	// [Output Only] Server-defined URL for this resource.
	SelfLink *string `protobuf:"bytes,456214797,opt,name=self_link,json=selfLink,proto3,oneof" json:"self_link,omitempty"`
	// [Output Only] Informational warning message.
	Warning *Warning `protobuf:"bytes,50704284,opt,name=warning,proto3,oneof" json:"warning,omitempty"`
}

func (x *FirewallList) Reset() {
	*x = FirewallList{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[110]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FirewallList) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FirewallList) ProtoMessage() {}

func (x *FirewallList) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[110]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FirewallList.ProtoReflect.Descriptor instead.
func (*FirewallList) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{110}
}

func (x *FirewallList) GetId() string {
	if x != nil && x.Id != nil {
		return *x.Id
	}
	return ""
}

func (x *FirewallList) GetItems() []*Firewall {
	if x != nil {
		return x.Items
	}
	return nil
}

func (x *FirewallList) GetKind() string {
	if x != nil && x.Kind != nil {
		return *x.Kind
	}
	return ""
}

func (x *FirewallList) GetNextPageToken() string {
	if x != nil && x.NextPageToken != nil {
		return *x.NextPageToken
	}
	return ""
}

func (x *FirewallList) GetSelfLink() string {
	if x != nil && x.SelfLink != nil {
		return *x.SelfLink
	}
	return ""
}

func (x *FirewallList) GetWarning() *Warning {
	if x != nil {
		return x.Warning
	}
	return nil
}

//
type FirewallPolicyAssociation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The target that the firewall policy is attached to.
	AttachmentTarget *string `protobuf:"bytes,175773741,opt,name=attachment_target,json=attachmentTarget,proto3,oneof" json:"attachment_target,omitempty"`
	// [Output Only] Deprecated, please use short name instead. The display name of the firewall policy of the association.
	DisplayName *string `protobuf:"bytes,4473832,opt,name=display_name,json=displayName,proto3,oneof" json:"display_name,omitempty"`
	// [Output Only] The firewall policy ID of the association.
	FirewallPolicyId *string `protobuf:"bytes,357211849,opt,name=firewall_policy_id,json=firewallPolicyId,proto3,oneof" json:"firewall_policy_id,omitempty"`
	// The name for an association.
	Name *string `protobuf:"bytes,3373707,opt,name=name,proto3,oneof" json:"name,omitempty"`
	// [Output Only] The short name of the firewall policy of the association.
	ShortName *string `protobuf:"bytes,492051566,opt,name=short_name,json=shortName,proto3,oneof" json:"short_name,omitempty"`
}

func (x *FirewallPolicyAssociation) Reset() {
	*x = FirewallPolicyAssociation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[111]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FirewallPolicyAssociation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FirewallPolicyAssociation) ProtoMessage() {}

func (x *FirewallPolicyAssociation) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[111]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FirewallPolicyAssociation.ProtoReflect.Descriptor instead.
func (*FirewallPolicyAssociation) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{111}
}

func (x *FirewallPolicyAssociation) GetAttachmentTarget() string {
	if x != nil && x.AttachmentTarget != nil {
		return *x.AttachmentTarget
	}
	return ""
}

func (x *FirewallPolicyAssociation) GetDisplayName() string {
	if x != nil && x.DisplayName != nil {
		return *x.DisplayName
	}
	return ""
}

func (x *FirewallPolicyAssociation) GetFirewallPolicyId() string {
	if x != nil && x.FirewallPolicyId != nil {
		return *x.FirewallPolicyId
	}
	return ""
}

func (x *FirewallPolicyAssociation) GetName() string {
	if x != nil && x.Name != nil {
		return *x.Name
	}
	return ""
}

func (x *FirewallPolicyAssociation) GetShortName() string {
	if x != nil && x.ShortName != nil {
		return *x.ShortName
	}
	return ""
}

//
type FirewallPoliciesListAssociationsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A list of associations.
	Associations []*FirewallPolicyAssociation `protobuf:"bytes,508736530,rep,name=associations,proto3" json:"associations,omitempty"`
	// [Output Only] Type of firewallPolicy associations. Always compute#FirewallPoliciesListAssociations for lists of firewallPolicy associations.
	Kind *string `protobuf:"bytes,3292052,opt,name=kind,proto3,oneof" json:"kind,omitempty"`
}

func (x *FirewallPoliciesListAssociationsResponse) Reset() {
	*x = FirewallPoliciesListAssociationsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[112]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FirewallPoliciesListAssociationsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FirewallPoliciesListAssociationsResponse) ProtoMessage() {}

func (x *FirewallPoliciesListAssociationsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[112]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FirewallPoliciesListAssociationsResponse.ProtoReflect.Descriptor instead.
func (*FirewallPoliciesListAssociationsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{112}
}

func (x *FirewallPoliciesListAssociationsResponse) GetAssociations() []*FirewallPolicyAssociation {
	if x != nil {
		return x.Associations
	}
	return nil
}

func (x *FirewallPoliciesListAssociationsResponse) GetKind() string {
	if x != nil && x.Kind != nil {
		return *x.Kind
	}
	return ""
}

// Represents a rule that describes one or more match conditions along with the action to be taken when traffic matches this condition (allow or deny).
type FirewallPolicyRule struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The Action to perform when the client connection triggers the rule. Can currently be either "allow" or "deny()" where valid values for status are 403, 404, and 502.
	Action *string `protobuf:"bytes,187661878,opt,name=action,proto3,oneof" json:"action,omitempty"`
	// An optional description for this resource.
	Description *string `protobuf:"bytes,422937596,opt,name=description,proto3,oneof" json:"description,omitempty"`
	// The direction in which this rule applies.
	Direction *FirewallPolicyRule_Direction `protobuf:"varint,111150975,opt,name=direction,proto3,enum=google.cloud.compute.v1.FirewallPolicyRule_Direction,oneof" json:"direction,omitempty"`
	// Denotes whether the firewall policy rule is disabled. When set to true, the firewall policy rule is not enforced and traffic behaves as if it did not exist. If this is unspecified, the firewall policy rule will be enabled.
	Disabled *bool `protobuf:"varint,270940796,opt,name=disabled,proto3,oneof" json:"disabled,omitempty"`
	// Denotes whether to enable logging for a particular rule. If logging is enabled, logs will be exported to the configured export destination in Stackdriver. Logs may be exported to BigQuery or Pub/Sub. Note: you cannot enable logging on "goto_next" rules.
	EnableLogging *bool `protobuf:"varint,295396515,opt,name=enable_logging,json=enableLogging,proto3,oneof" json:"enable_logging,omitempty"`
	// [Output only] Type of the resource. Always compute#firewallPolicyRule for firewall policy rules
	Kind *string `protobuf:"bytes,3292052,opt,name=kind,proto3,oneof" json:"kind,omitempty"`
	// A match condition that incoming traffic is evaluated against. If it evaluates to true, the corresponding 'action' is enforced.
	Match *FirewallPolicyRuleMatcher `protobuf:"bytes,103668165,opt,name=match,proto3,oneof" json:"match,omitempty"`
	// An integer indicating the priority of a rule in the list. The priority must be a positive value between 0 and 2147483647. Rules are evaluated from highest to lowest priority where 0 is the highest priority and 2147483647 is the lowest prority.
	Priority *int32 `protobuf:"varint,445151652,opt,name=priority,proto3,oneof" json:"priority,omitempty"`
	// [Output Only] Calculation of the complexity of a single firewall policy rule.
	RuleTupleCount *int32 `protobuf:"varint,388342037,opt,name=rule_tuple_count,json=ruleTupleCount,proto3,oneof" json:"rule_tuple_count,omitempty"`
	// A list of network resource URLs to which this rule applies. This field allows you to control which network's VMs get this rule. If this field is left blank, all VMs within the organization will receive the rule.
	TargetResources []string `protobuf:"bytes,528230647,rep,name=target_resources,json=targetResources,proto3" json:"target_resources,omitempty"`
	// A list of service accounts indicating the sets of instances that are applied with this rule.
	TargetServiceAccounts []string `protobuf:"bytes,457639710,rep,name=target_service_accounts,json=targetServiceAccounts,proto3" json:"target_service_accounts,omitempty"`
}

func (x *FirewallPolicyRule) Reset() {
	*x = FirewallPolicyRule{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[113]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FirewallPolicyRule) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FirewallPolicyRule) ProtoMessage() {}

func (x *FirewallPolicyRule) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[113]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FirewallPolicyRule.ProtoReflect.Descriptor instead.
func (*FirewallPolicyRule) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{113}
}

func (x *FirewallPolicyRule) GetAction() string {
	if x != nil && x.Action != nil {
		return *x.Action
	}
	return ""
}

func (x *FirewallPolicyRule) GetDescription() string {
	if x != nil && x.Description != nil {
		return *x.Description
	}
	return ""
}

func (x *FirewallPolicyRule) GetDirection() FirewallPolicyRule_Direction {
	if x != nil && x.Direction != nil {
		return *x.Direction
	}
	return FirewallPolicyRule_UNDEFINED_DIRECTION
}

func (x *FirewallPolicyRule) GetDisabled() bool {
	if x != nil && x.Disabled != nil {
		return *x.Disabled
	}
	return false
}

func (x *FirewallPolicyRule) GetEnableLogging() bool {
	if x != nil && x.EnableLogging != nil {
		return *x.EnableLogging
	}
	return false
}

func (x *FirewallPolicyRule) GetKind() string {
	if x != nil && x.Kind != nil {
		return *x.Kind
	}
	return ""
}

func (x *FirewallPolicyRule) GetMatch() *FirewallPolicyRuleMatcher {
	if x != nil {
		return x.Match
	}
	return nil
}

func (x *FirewallPolicyRule) GetPriority() int32 {
	if x != nil && x.Priority != nil {
		return *x.Priority
	}
	return 0
}

func (x *FirewallPolicyRule) GetRuleTupleCount() int32 {
	if x != nil && x.RuleTupleCount != nil {
		return *x.RuleTupleCount
	}
	return 0
}

func (x *FirewallPolicyRule) GetTargetResources() []string {
	if x != nil {
		return x.TargetResources
	}
	return nil
}

func (x *FirewallPolicyRule) GetTargetServiceAccounts() []string {
	if x != nil {
		return x.TargetServiceAccounts
	}
	return nil
}

// Represents a Firewall Policy resource. (== resource_for {$api_version}.firewallPolicies ==)
type FirewallPolicy struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A list of associations that belong to this firewall policy.
	Associations []*FirewallPolicyAssociation `protobuf:"bytes,508736530,rep,name=associations,proto3" json:"associations,omitempty"`
	// [Output Only] Creation timestamp in RFC3339 text format.
	CreationTimestamp *string `protobuf:"bytes,30525366,opt,name=creation_timestamp,json=creationTimestamp,proto3,oneof" json:"creation_timestamp,omitempty"`
	// An optional description of this resource. Provide this property when you create the resource.
	Description *string `protobuf:"bytes,422937596,opt,name=description,proto3,oneof" json:"description,omitempty"`
	// Depreacted, please use short name instead. User-provided name of the Organization firewall plicy. The name should be unique in the organization in which the firewall policy is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
	DisplayName *string `protobuf:"bytes,4473832,opt,name=display_name,json=displayName,proto3,oneof" json:"display_name,omitempty"`
	// Specifies a fingerprint for this resource, which is essentially a hash of the metadata's contents and used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update metadata. You must always provide an up-to-date fingerprint hash in order to update or change metadata, otherwise the request will fail with error 412 conditionNotMet.
	//
	// To see the latest fingerprint, make get() request to the firewall policy.
	Fingerprint *string `protobuf:"bytes,234678500,opt,name=fingerprint,proto3,oneof" json:"fingerprint,omitempty"`
	// [Output Only] The unique identifier for the resource. This identifier is defined by the server.
	Id *uint64 `protobuf:"varint,3355,opt,name=id,proto3,oneof" json:"id,omitempty"`
	// [Output only] Type of the resource. Always compute#firewallPolicyfor firewall policies
	Kind *string `protobuf:"bytes,3292052,opt,name=kind,proto3,oneof" json:"kind,omitempty"`
	// [Output Only] Name of the resource. It is a numeric ID allocated by GCP which uniquely identifies the Firewall Policy.
	Name *string `protobuf:"bytes,3373707,opt,name=name,proto3,oneof" json:"name,omitempty"`
	// [Output Only] The parent of the firewall policy.
	Parent *string `protobuf:"bytes,78317738,opt,name=parent,proto3,oneof" json:"parent,omitempty"`
	// [Output Only] Total count of all firewall policy rule tuples. A firewall policy can not exceed a set number of tuples.
	RuleTupleCount *int32 `protobuf:"varint,388342037,opt,name=rule_tuple_count,json=ruleTupleCount,proto3,oneof" json:"rule_tuple_count,omitempty"`
	// A list of rules that belong to this policy. There must always be a default rule (rule with priority 2147483647 and match "*"). If no rules are provided when creating a firewall policy, a default rule with action "allow" will be added.
	Rules []*FirewallPolicyRule `protobuf:"bytes,108873975,rep,name=rules,proto3" json:"rules,omitempty"`
	// [Output Only] Server-defined URL for the resource.
	SelfLink *string `protobuf:"bytes,456214797,opt,name=self_link,json=selfLink,proto3,oneof" json:"self_link,omitempty"`
	// [Output Only] Server-defined URL for this resource with the resource id.
	SelfLinkWithId *string `protobuf:"bytes,44520962,opt,name=self_link_with_id,json=selfLinkWithId,proto3,oneof" json:"self_link_with_id,omitempty"`
	// User-provided name of the Organization firewall plicy. The name should be unique in the organization in which the firewall policy is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
	ShortName *string `protobuf:"bytes,492051566,opt,name=short_name,json=shortName,proto3,oneof" json:"short_name,omitempty"`
}

func (x *FirewallPolicy) Reset() {
	*x = FirewallPolicy{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[114]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FirewallPolicy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FirewallPolicy) ProtoMessage() {}

func (x *FirewallPolicy) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[114]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FirewallPolicy.ProtoReflect.Descriptor instead.
func (*FirewallPolicy) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{114}
}

func (x *FirewallPolicy) GetAssociations() []*FirewallPolicyAssociation {
	if x != nil {
		return x.Associations
	}
	return nil
}

func (x *FirewallPolicy) GetCreationTimestamp() string {
	if x != nil && x.CreationTimestamp != nil {
		return *x.CreationTimestamp
	}
	return ""
}

func (x *FirewallPolicy) GetDescription() string {
	if x != nil && x.Description != nil {
		return *x.Description
	}
	return ""
}

func (x *FirewallPolicy) GetDisplayName() string {
	if x != nil && x.DisplayName != nil {
		return *x.DisplayName
	}
	return ""
}

func (x *FirewallPolicy) GetFingerprint() string {
	if x != nil && x.Fingerprint != nil {
		return *x.Fingerprint
	}
	return ""
}

func (x *FirewallPolicy) GetId() uint64 {
	if x != nil && x.Id != nil {
		return *x.Id
	}
	return 0
}

func (x *FirewallPolicy) GetKind() string {
	if x != nil && x.Kind != nil {
		return *x.Kind
	}
	return ""
}

func (x *FirewallPolicy) GetName() string {
	if x != nil && x.Name != nil {
		return *x.Name
	}
	return ""
}

func (x *FirewallPolicy) GetParent() string {
	if x != nil && x.Parent != nil {
		return *x.Parent
	}
	return ""
}

func (x *FirewallPolicy) GetRuleTupleCount() int32 {
	if x != nil && x.RuleTupleCount != nil {
		return *x.RuleTupleCount
	}
	return 0
}

func (x *FirewallPolicy) GetRules() []*FirewallPolicyRule {
	if x != nil {
		return x.Rules
	}
	return nil
}

func (x *FirewallPolicy) GetSelfLink() string {
	if x != nil && x.SelfLink != nil {
		return *x.SelfLink
	}
	return ""
}

func (x *FirewallPolicy) GetSelfLinkWithId() string {
	if x != nil && x.SelfLinkWithId != nil {
		return *x.SelfLinkWithId
	}
	return ""
}

func (x *FirewallPolicy) GetShortName() string {
	if x != nil && x.ShortName != nil {
		return *x.ShortName
	}
	return ""
}

//
type FirewallPolicyList struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// [Output Only] Unique identifier for the resource; defined by the server.
	Id *string `protobuf:"bytes,3355,opt,name=id,proto3,oneof" json:"id,omitempty"`
	// A list of FirewallPolicy resources.
	Items []*FirewallPolicy `protobuf:"bytes,100526016,rep,name=items,proto3" json:"items,omitempty"`
	// [Output Only] Type of resource. Always compute#firewallPolicyList for listsof FirewallPolicies
	Kind *string `protobuf:"bytes,3292052,opt,name=kind,proto3,oneof" json:"kind,omitempty"`
	// [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
	NextPageToken *string `protobuf:"bytes,79797525,opt,name=next_page_token,json=nextPageToken,proto3,oneof" json:"next_page_token,omitempty"`
	// [Output Only] Informational warning message.
	Warning *Warning `protobuf:"bytes,50704284,opt,name=warning,proto3,oneof" json:"warning,omitempty"`
}

func (x *FirewallPolicyList) Reset() {
	*x = FirewallPolicyList{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[115]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FirewallPolicyList) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FirewallPolicyList) ProtoMessage() {}

func (x *FirewallPolicyList) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[115]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FirewallPolicyList.ProtoReflect.Descriptor instead.
func (*FirewallPolicyList) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{115}
}

func (x *FirewallPolicyList) GetId() string {
	if x != nil && x.Id != nil {
		return *x.Id
	}
	return ""
}

func (x *FirewallPolicyList) GetItems() []*FirewallPolicy {
	if x != nil {
		return x.Items
	}
	return nil
}

func (x *FirewallPolicyList) GetKind() string {
	if x != nil && x.Kind != nil {
		return *x.Kind
	}
	return ""
}

func (x *FirewallPolicyList) GetNextPageToken() string {
	if x != nil && x.NextPageToken != nil {
		return *x.NextPageToken
	}
	return ""
}

func (x *FirewallPolicyList) GetWarning() *Warning {
	if x != nil {
		return x.Warning
	}
	return nil
}

// Represents a match condition that incoming traffic is evaluated against. Exactly one field must be specified.
type FirewallPolicyRuleMatcher struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// CIDR IP address range. Maximum number of destination CIDR IP ranges allowed is 256.
	DestIpRanges []string `protobuf:"bytes,337357713,rep,name=dest_ip_ranges,json=destIpRanges,proto3" json:"dest_ip_ranges,omitempty"`
	// Pairs of IP protocols and ports that the rule should match.
	Layer4Configs []*FirewallPolicyRuleMatcherLayer4Config `protobuf:"bytes,373534261,rep,name=layer4_configs,json=layer4Configs,proto3" json:"layer4_configs,omitempty"`
	// CIDR IP address range. Maximum number of source CIDR IP ranges allowed is 256.
	SrcIpRanges []string `protobuf:"bytes,432128083,rep,name=src_ip_ranges,json=srcIpRanges,proto3" json:"src_ip_ranges,omitempty"`
}

func (x *FirewallPolicyRuleMatcher) Reset() {
	*x = FirewallPolicyRuleMatcher{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[116]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FirewallPolicyRuleMatcher) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FirewallPolicyRuleMatcher) ProtoMessage() {}

func (x *FirewallPolicyRuleMatcher) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[116]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FirewallPolicyRuleMatcher.ProtoReflect.Descriptor instead.
func (*FirewallPolicyRuleMatcher) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{116}
}

func (x *FirewallPolicyRuleMatcher) GetDestIpRanges() []string {
	if x != nil {
		return x.DestIpRanges
	}
	return nil
}

func (x *FirewallPolicyRuleMatcher) GetLayer4Configs() []*FirewallPolicyRuleMatcherLayer4Config {
	if x != nil {
		return x.Layer4Configs
	}
	return nil
}

func (x *FirewallPolicyRuleMatcher) GetSrcIpRanges() []string {
	if x != nil {
		return x.SrcIpRanges
	}
	return nil
}

//
type FirewallPolicyRuleMatcherLayer4Config struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The IP protocol to which this rule applies. The protocol type is required when creating a firewall rule. This value can either be one of the following well known protocol strings (tcp, udp, icmp, esp, ah, ipip, sctp), or the IP protocol number.
	IpProtocol *string `protobuf:"bytes,475958960,opt,name=ip_protocol,json=ipProtocol,proto3,oneof" json:"ip_protocol,omitempty"`
	// An optional list of ports to which this rule applies. This field is only applicable for UDP or TCP protocol. Each entry must be either an integer or a range. If not specified, this rule applies to connections through any port.
	//
	// Example inputs include: ["22"], ["80","443"], and ["12345-12349"].
	Ports []string `protobuf:"bytes,106854418,rep,name=ports,proto3" json:"ports,omitempty"`
}

func (x *FirewallPolicyRuleMatcherLayer4Config) Reset() {
	*x = FirewallPolicyRuleMatcherLayer4Config{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[117]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FirewallPolicyRuleMatcherLayer4Config) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FirewallPolicyRuleMatcherLayer4Config) ProtoMessage() {}

func (x *FirewallPolicyRuleMatcherLayer4Config) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[117]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FirewallPolicyRuleMatcherLayer4Config.ProtoReflect.Descriptor instead.
func (*FirewallPolicyRuleMatcherLayer4Config) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{117}
}

func (x *FirewallPolicyRuleMatcherLayer4Config) GetIpProtocol() string {
	if x != nil && x.IpProtocol != nil {
		return *x.IpProtocol
	}
	return ""
}

func (x *FirewallPolicyRuleMatcherLayer4Config) GetPorts() []string {
	if x != nil {
		return x.Ports
	}
	return nil
}

// Opaque filter criteria used by loadbalancers to restrict routing configuration to a limited set of loadbalancing proxies. Proxies and sidecars involved in loadbalancing would typically present metadata to the loadbalancers which need to match criteria specified here. If a match takes place, the relevant configuration is made available to those proxies.
// For each metadataFilter in this list, if its filterMatchCriteria is set to MATCH_ANY, at least one of the filterLabels must match the corresponding label provided in the metadata. If its filterMatchCriteria is set to MATCH_ALL, then all of its filterLabels must match with corresponding labels provided in the metadata.
// An example for using metadataFilters would be: if loadbalancing involves  Envoys, they will only receive routing configuration when values in metadataFilters match values supplied in <a href="https://www.envoyproxy.io/docs/envoy/latest/api-v2/api/v2/core/base.proto#envoy-api-msg-core-node" Node metadata of their XDS requests to loadbalancers.
type MetadataFilter struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of label value pairs that must match labels in the provided metadata based on filterMatchCriteria
	// This list must not be empty and can have at the most 64 entries.
	FilterLabels []*MetadataFilterLabelMatch `protobuf:"bytes,307903142,rep,name=filter_labels,json=filterLabels,proto3" json:"filter_labels,omitempty"`
	// Specifies how individual filterLabel matches within the list of filterLabels contribute towards the overall metadataFilter match.
	// Supported values are:
	// - MATCH_ANY: At least one of the filterLabels must have a matching label in the provided metadata.
	// - MATCH_ALL: All filterLabels must have matching labels in the provided metadata.
	FilterMatchCriteria *MetadataFilter_FilterMatchCriteria `protobuf:"varint,239970368,opt,name=filter_match_criteria,json=filterMatchCriteria,proto3,enum=google.cloud.compute.v1.MetadataFilter_FilterMatchCriteria,oneof" json:"filter_match_criteria,omitempty"`
}

func (x *MetadataFilter) Reset() {
	*x = MetadataFilter{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[118]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MetadataFilter) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MetadataFilter) ProtoMessage() {}

func (x *MetadataFilter) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[118]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MetadataFilter.ProtoReflect.Descriptor instead.
func (*MetadataFilter) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{118}
}

func (x *MetadataFilter) GetFilterLabels() []*MetadataFilterLabelMatch {
	if x != nil {
		return x.FilterLabels
	}
	return nil
}

func (x *MetadataFilter) GetFilterMatchCriteria() MetadataFilter_FilterMatchCriteria {
	if x != nil && x.FilterMatchCriteria != nil {
		return *x.FilterMatchCriteria
	}
	return MetadataFilter_UNDEFINED_FILTER_MATCH_CRITERIA
}

// Describes the auto-registration of the Forwarding Rule to Service Directory. The region and project of the Service Directory resource generated from this registration will be the same as this Forwarding Rule.
type ForwardingRuleServiceDirectoryRegistration struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Service Directory namespace to register the forwarding rule under.
	Namespace *string `protobuf:"bytes,178476379,opt,name=namespace,proto3,oneof" json:"namespace,omitempty"`
	// Service Directory service to register the forwarding rule under.
	Service *string `protobuf:"bytes,373540533,opt,name=service,proto3,oneof" json:"service,omitempty"`
	// [Optional] Service Directory region to register this global forwarding rule under. Default to "us-central1". Only used for PSC for Google APIs. All PSC for Google APIs Forwarding Rules on the same network should use the same Service Directory region.
	ServiceDirectoryRegion *string `protobuf:"bytes,74030416,opt,name=service_directory_region,json=serviceDirectoryRegion,proto3,oneof" json:"service_directory_region,omitempty"`
}

func (x *ForwardingRuleServiceDirectoryRegistration) Reset() {
	*x = ForwardingRuleServiceDirectoryRegistration{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[119]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ForwardingRuleServiceDirectoryRegistration) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ForwardingRuleServiceDirectoryRegistration) ProtoMessage() {}

func (x *ForwardingRuleServiceDirectoryRegistration) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[119]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ForwardingRuleServiceDirectoryRegistration.ProtoReflect.Descriptor instead.
func (*ForwardingRuleServiceDirectoryRegistration) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{119}
}

func (x *ForwardingRuleServiceDirectoryRegistration) GetNamespace() string {
	if x != nil && x.Namespace != nil {
		return *x.Namespace
	}
	return ""
}

func (x *ForwardingRuleServiceDirectoryRegistration) GetService() string {
	if x != nil && x.Service != nil {
		return *x.Service
	}
	return ""
}

func (x *ForwardingRuleServiceDirectoryRegistration) GetServiceDirectoryRegion() string {
	if x != nil && x.ServiceDirectoryRegion != nil {
		return *x.ServiceDirectoryRegion
	}
	return ""
}

// Represents a Forwarding Rule resource.
//
// Forwarding rule resources in GCP can be either regional or global in scope:
//
// * [Global](/compute/docs/reference/rest/{$api_version}/globalForwardingRules) * [Regional](/compute/docs/reference/rest/{$api_version}/forwardingRules)
//
// A forwarding rule and its corresponding IP address represent the frontend configuration of a Google Cloud Platform load balancer. Forwarding rules can also reference target instances and Cloud VPN Classic gateways (targetVpnGateway).
//
// For more information, read Forwarding rule concepts and Using protocol forwarding.
//
// (== resource_for {$api_version}.forwardingRules ==) (== resource_for {$api_version}.globalForwardingRules ==) (== resource_for {$api_version}.regionForwardingRules ==)
type ForwardingRule struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// IP address that this forwarding rule serves. When a client sends traffic to this IP address, the forwarding rule directs the traffic to the target that you specify in the forwarding rule.
	//
	// If you don't specify a reserved IP address, an ephemeral IP address is assigned. Methods for specifying an IP address:
	//
	// * IPv4 dotted decimal, as in `100.1.2.3` * Full URL, as in https://www.googleapis.com/compute/v1/projects/project_id/regions/region/addresses/address-name * Partial URL or by name, as in:
	// - projects/project_id/regions/region/addresses/address-name
	// - regions/region/addresses/address-name
	// - global/addresses/address-name
	// - address-name
	//
	// The loadBalancingScheme and the forwarding rule's target determine the type of IP address that you can use. For detailed information, refer to [IP address specifications](/load-balancing/docs/forwarding-rule-concepts#ip_address_specifications).
	//
	// Must be set to `0.0.0.0` when the target is targetGrpcProxy that has validateForProxyless field set to true.
	//
	// For Private Service Connect forwarding rules that forward traffic to Google APIs, IP address must be provided.
	IPAddress *string `protobuf:"bytes,42976943,opt,name=I_p_address,json=IPAddress,proto3,oneof" json:"I_p_address,omitempty"`
	// The IP protocol to which this rule applies.
	//
	// For protocol forwarding, valid options are TCP, UDP, ESP, AH, SCTP and ICMP.
	//
	// The valid IP protocols are different for different load balancing products:
	// - Internal TCP/UDP Load Balancing: The load balancing scheme is INTERNAL, and one of TCP, UDP or ALL is valid.
	// - Traffic Director: The load balancing scheme is INTERNAL_SELF_MANAGED, and only TCP is valid.
	// - Internal HTTP(S) Load Balancing: The load balancing scheme is INTERNAL_MANAGED, and only TCP is valid.
	// - HTTP(S), SSL Proxy, and TCP Proxy Load Balancing: The load balancing scheme is EXTERNAL and only TCP is valid.
	// - Network Load Balancing: The load balancing scheme is EXTERNAL, and one of TCP or UDP is valid.
	IPProtocol *ForwardingRule_IPProtocol `protobuf:"varint,488094525,opt,name=I_p_protocol,json=IPProtocol,proto3,enum=google.cloud.compute.v1.ForwardingRule_IPProtocol,oneof" json:"I_p_protocol,omitempty"`
	// This field is used along with the backend_service field for internal load balancing or with the target field for internal TargetInstance. This field cannot be used with port or portRange fields.
	//
	// When the load balancing scheme is INTERNAL and protocol is TCP/UDP, specify this field to allow packets addressed to any ports will be forwarded to the backends configured with this forwarding rule.
	AllPorts *bool `protobuf:"varint,445175796,opt,name=all_ports,json=allPorts,proto3,oneof" json:"all_ports,omitempty"`
	// This field is used along with the backend_service field for internal load balancing or with the target field for internal TargetInstance. If the field is set to TRUE, clients can access ILB from all regions. Otherwise only allows access from clients in the same region as the internal load balancer.
	AllowGlobalAccess *bool `protobuf:"varint,499409674,opt,name=allow_global_access,json=allowGlobalAccess,proto3,oneof" json:"allow_global_access,omitempty"`
	// Identifies the backend service to which the forwarding rule sends traffic. Required for Internal TCP/UDP Load Balancing and Network Load Balancing; must be omitted for all other load balancer types.
	BackendService *string `protobuf:"bytes,306946058,opt,name=backend_service,json=backendService,proto3,oneof" json:"backend_service,omitempty"`
	// [Output Only] Creation timestamp in RFC3339 text format.
	CreationTimestamp *string `protobuf:"bytes,30525366,opt,name=creation_timestamp,json=creationTimestamp,proto3,oneof" json:"creation_timestamp,omitempty"`
	// An optional description of this resource. Provide this property when you create the resource.
	Description *string `protobuf:"bytes,422937596,opt,name=description,proto3,oneof" json:"description,omitempty"`
	// Fingerprint of this resource. A hash of the contents stored in this object. This field is used in optimistic locking. This field will be ignored when inserting a ForwardingRule. Include the fingerprint in patch request to ensure that you do not overwrite changes that were applied from another concurrent request.
	//
	// To see the latest fingerprint, make a get() request to retrieve a ForwardingRule.
	Fingerprint *string `protobuf:"bytes,234678500,opt,name=fingerprint,proto3,oneof" json:"fingerprint,omitempty"`
	// [Output Only] The unique identifier for the resource. This identifier is defined by the server.
	Id *uint64 `protobuf:"varint,3355,opt,name=id,proto3,oneof" json:"id,omitempty"`
	// The IP Version that will be used by this forwarding rule. Valid options are IPV4 or IPV6. This can only be specified for an external global forwarding rule.
	IpVersion *ForwardingRule_IpVersion `protobuf:"varint,294959552,opt,name=ip_version,json=ipVersion,proto3,enum=google.cloud.compute.v1.ForwardingRule_IpVersion,oneof" json:"ip_version,omitempty"`
	// Indicates whether or not this load balancer can be used as a collector for packet mirroring. To prevent mirroring loops, instances behind this load balancer will not have their traffic mirrored even if a PacketMirroring rule applies to them. This can only be set to true for load balancers that have their loadBalancingScheme set to INTERNAL.
	IsMirroringCollector *bool `protobuf:"varint,119255164,opt,name=is_mirroring_collector,json=isMirroringCollector,proto3,oneof" json:"is_mirroring_collector,omitempty"`
	// [Output Only] Type of the resource. Always compute#forwardingRule for Forwarding Rule resources.
	Kind *string `protobuf:"bytes,3292052,opt,name=kind,proto3,oneof" json:"kind,omitempty"`
	// A fingerprint for the labels being applied to this resource, which is essentially a hash of the labels set used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update labels. You must always provide an up-to-date fingerprint hash in order to update or change labels, otherwise the request will fail with error 412 conditionNotMet.
	//
	// To see the latest fingerprint, make a get() request to retrieve a ForwardingRule.
	LabelFingerprint *string `protobuf:"bytes,178124825,opt,name=label_fingerprint,json=labelFingerprint,proto3,oneof" json:"label_fingerprint,omitempty"`
	// Labels for this resource. These can only be added or modified by the setLabels method. Each label key/value pair must comply with RFC1035. Label values may be empty.
	Labels map[string]string `protobuf:"bytes,500195327,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Specifies the forwarding rule type.
	//
	//
	// - EXTERNAL is used for:
	// - Classic Cloud VPN gateways
	// - Protocol forwarding to VMs from an external IP address
	// - HTTP(S), SSL Proxy, TCP Proxy, and Network Load Balancing
	// - INTERNAL is used for:
	// - Protocol forwarding to VMs from an internal IP address
	// - Internal TCP/UDP Load Balancing
	// - INTERNAL_MANAGED is used for:
	// - Internal HTTP(S) Load Balancing
	// - INTERNAL_SELF_MANAGED is used for:
	// - Traffic Director
	//
	// For more information about forwarding rules, refer to Forwarding rule concepts.
	LoadBalancingScheme *ForwardingRule_LoadBalancingScheme `protobuf:"varint,363890244,opt,name=load_balancing_scheme,json=loadBalancingScheme,proto3,enum=google.cloud.compute.v1.ForwardingRule_LoadBalancingScheme,oneof" json:"load_balancing_scheme,omitempty"`
	// Opaque filter criteria used by Loadbalancer to restrict routing configuration to a limited set of xDS compliant clients. In their xDS requests to Loadbalancer, xDS clients present node metadata. When there is a match, the relevant configuration is made available to those proxies. Otherwise, all the resources (e.g. TargetHttpProxy, UrlMap) referenced by the ForwardingRule will not be visible to those proxies.
	// For each metadataFilter in this list, if its filterMatchCriteria is set to MATCH_ANY, at least one of the filterLabels must match the corresponding label provided in the metadata. If its filterMatchCriteria is set to MATCH_ALL, then all of its filterLabels must match with corresponding labels provided in the metadata. If multiple metadataFilters are specified, all of them need to be satisfied in order to be considered a match.
	// metadataFilters specified here will be applifed before those specified in the UrlMap that this ForwardingRule references.
	// metadataFilters only applies to Loadbalancers that have their loadBalancingScheme set to INTERNAL_SELF_MANAGED.
	MetadataFilters []*MetadataFilter `protobuf:"bytes,464725739,rep,name=metadata_filters,json=metadataFilters,proto3" json:"metadata_filters,omitempty"`
	// Name of the resource; provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
	Name *string `protobuf:"bytes,3373707,opt,name=name,proto3,oneof" json:"name,omitempty"`
	// This field is not used for external load balancing.
	//
	// For Internal TCP/UDP Load Balancing, this field identifies the network that the load balanced IP should belong to for this Forwarding Rule. If this field is not specified, the default network will be used.
	//
	// For Private Service Connect forwarding rules that forward traffic to Google APIs, a network must be provided.
	Network *string `protobuf:"bytes,232872494,opt,name=network,proto3,oneof" json:"network,omitempty"`
	// This signifies the networking tier used for configuring this load balancer and can only take the following values: PREMIUM, STANDARD.
	//
	// For regional ForwardingRule, the valid values are PREMIUM and STANDARD. For GlobalForwardingRule, the valid value is PREMIUM.
	//
	// If this field is not specified, it is assumed to be PREMIUM. If IPAddress is specified, this value must be equal to the networkTier of the Address.
	NetworkTier *ForwardingRule_NetworkTier `protobuf:"varint,517397843,opt,name=network_tier,json=networkTier,proto3,enum=google.cloud.compute.v1.ForwardingRule_NetworkTier,oneof" json:"network_tier,omitempty"`
	// This field can be used only if: * Load balancing scheme is one of EXTERNAL,  INTERNAL_SELF_MANAGED or INTERNAL_MANAGED, and * IPProtocol is one of TCP, UDP, or SCTP.
	//
	// Packets addressed to ports in the specified range will be forwarded to target or  backend_service. You can only use one of ports, port_range, or allPorts. The three are mutually exclusive. Forwarding rules with the same [IPAddress, IPProtocol] pair must have disjoint port ranges.
	//
	// Some types of forwarding target have constraints on the acceptable ports:
	// - TargetHttpProxy: 80, 8080
	// - TargetHttpsProxy: 443
	// - TargetGrpcProxy: no constraints
	// - TargetTcpProxy: 25, 43, 110, 143, 195, 443, 465, 587, 700, 993, 995, 1688, 1883, 5222
	// - TargetSslProxy: 25, 43, 110, 143, 195, 443, 465, 587, 700, 993, 995, 1688, 1883, 5222
	// - TargetVpnGateway: 500, 4500
	PortRange *string `protobuf:"bytes,217518079,opt,name=port_range,json=portRange,proto3,oneof" json:"port_range,omitempty"`
	// The ports field is only supported when the forwarding rule references a backend_service directly. Supported load balancing products are Internal TCP/UDP Load Balancing and Network Load Balancing. Only packets addressed to the specified list of ports are forwarded to backends.
	//
	// You can only use one of ports and port_range, or allPorts. The three are mutually exclusive.
	//
	// You can specify a list of up to five ports, which can be non-contiguous.
	//
	// For Internal TCP/UDP Load Balancing, if you specify allPorts, you should not specify ports.
	//
	// For more information, see [Port specifications](/load-balancing/docs/forwarding-rule-concepts#port_specifications).
	Ports []string `protobuf:"bytes,106854418,rep,name=ports,proto3" json:"ports,omitempty"`
	// [Output Only] The PSC connection id of the PSC Forwarding Rule.
	PscConnectionId *uint64 `protobuf:"varint,292082397,opt,name=psc_connection_id,json=pscConnectionId,proto3,oneof" json:"psc_connection_id,omitempty"`
	// [Output Only] URL of the region where the regional forwarding rule resides. This field is not applicable to global forwarding rules. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
	Region *string `protobuf:"bytes,138946292,opt,name=region,proto3,oneof" json:"region,omitempty"`
	// [Output Only] Server-defined URL for the resource.
	SelfLink *string `protobuf:"bytes,456214797,opt,name=self_link,json=selfLink,proto3,oneof" json:"self_link,omitempty"`
	// Service Directory resources to register this forwarding rule with. Currently, only supports a single Service Directory resource.
	//
	// It is only supported for Internal TCP/UDP Load Balancing and Internal HTTP(S) Load Balancing.
	ServiceDirectoryRegistrations []*ForwardingRuleServiceDirectoryRegistration `protobuf:"bytes,223549694,rep,name=service_directory_registrations,json=serviceDirectoryRegistrations,proto3" json:"service_directory_registrations,omitempty"`
	// An optional prefix to the service name for this Forwarding Rule. If specified, the prefix is the first label of the fully qualified service name.
	//
	// The label must be 1-63 characters long, and comply with RFC1035. Specifically, the label must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
	//
	// This field is only used for internal load balancing.
	ServiceLabel *string `protobuf:"bytes,417008874,opt,name=service_label,json=serviceLabel,proto3,oneof" json:"service_label,omitempty"`
	// [Output Only] The internal fully qualified service name for this Forwarding Rule.
	//
	// This field is only used for internal load balancing.
	ServiceName *string `protobuf:"bytes,359880149,opt,name=service_name,json=serviceName,proto3,oneof" json:"service_name,omitempty"`
	// This field is only used for internal load balancing.
	//
	// For internal load balancing, this field identifies the subnetwork that the load balanced IP should belong to for this Forwarding Rule.
	//
	// If the network specified is in auto subnet mode, this field is optional. However, if the network is in custom subnet mode, a subnetwork must be specified.
	Subnetwork *string `protobuf:"bytes,307827694,opt,name=subnetwork,proto3,oneof" json:"subnetwork,omitempty"`
	Target     *string `protobuf:"bytes,192835985,opt,name=target,proto3,oneof" json:"target,omitempty"`
}

func (x *ForwardingRule) Reset() {
	*x = ForwardingRule{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[120]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ForwardingRule) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ForwardingRule) ProtoMessage() {}

func (x *ForwardingRule) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[120]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ForwardingRule.ProtoReflect.Descriptor instead.
func (*ForwardingRule) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{120}
}

func (x *ForwardingRule) GetIPAddress() string {
	if x != nil && x.IPAddress != nil {
		return *x.IPAddress
	}
	return ""
}

func (x *ForwardingRule) GetIPProtocol() ForwardingRule_IPProtocol {
	if x != nil && x.IPProtocol != nil {
		return *x.IPProtocol
	}
	return ForwardingRule_UNDEFINED_I_P_PROTOCOL
}

func (x *ForwardingRule) GetAllPorts() bool {
	if x != nil && x.AllPorts != nil {
		return *x.AllPorts
	}
	return false
}

func (x *ForwardingRule) GetAllowGlobalAccess() bool {
	if x != nil && x.AllowGlobalAccess != nil {
		return *x.AllowGlobalAccess
	}
	return false
}

func (x *ForwardingRule) GetBackendService() string {
	if x != nil && x.BackendService != nil {
		return *x.BackendService
	}
	return ""
}

func (x *ForwardingRule) GetCreationTimestamp() string {
	if x != nil && x.CreationTimestamp != nil {
		return *x.CreationTimestamp
	}
	return ""
}

func (x *ForwardingRule) GetDescription() string {
	if x != nil && x.Description != nil {
		return *x.Description
	}
	return ""
}

func (x *ForwardingRule) GetFingerprint() string {
	if x != nil && x.Fingerprint != nil {
		return *x.Fingerprint
	}
	return ""
}

func (x *ForwardingRule) GetId() uint64 {
	if x != nil && x.Id != nil {
		return *x.Id
	}
	return 0
}

func (x *ForwardingRule) GetIpVersion() ForwardingRule_IpVersion {
	if x != nil && x.IpVersion != nil {
		return *x.IpVersion
	}
	return ForwardingRule_UNDEFINED_IP_VERSION
}

func (x *ForwardingRule) GetIsMirroringCollector() bool {
	if x != nil && x.IsMirroringCollector != nil {
		return *x.IsMirroringCollector
	}
	return false
}

func (x *ForwardingRule) GetKind() string {
	if x != nil && x.Kind != nil {
		return *x.Kind
	}
	return ""
}

func (x *ForwardingRule) GetLabelFingerprint() string {
	if x != nil && x.LabelFingerprint != nil {
		return *x.LabelFingerprint
	}
	return ""
}

func (x *ForwardingRule) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *ForwardingRule) GetLoadBalancingScheme() ForwardingRule_LoadBalancingScheme {
	if x != nil && x.LoadBalancingScheme != nil {
		return *x.LoadBalancingScheme
	}
	return ForwardingRule_UNDEFINED_LOAD_BALANCING_SCHEME
}

func (x *ForwardingRule) GetMetadataFilters() []*MetadataFilter {
	if x != nil {
		return x.MetadataFilters
	}
	return nil
}

func (x *ForwardingRule) GetName() string {
	if x != nil && x.Name != nil {
		return *x.Name
	}
	return ""
}

func (x *ForwardingRule) GetNetwork() string {
	if x != nil && x.Network != nil {
		return *x.Network
	}
	return ""
}

func (x *ForwardingRule) GetNetworkTier() ForwardingRule_NetworkTier {
	if x != nil && x.NetworkTier != nil {
		return *x.NetworkTier
	}
	return ForwardingRule_UNDEFINED_NETWORK_TIER
}

func (x *ForwardingRule) GetPortRange() string {
	if x != nil && x.PortRange != nil {
		return *x.PortRange
	}
	return ""
}

func (x *ForwardingRule) GetPorts() []string {
	if x != nil {
		return x.Ports
	}
	return nil
}

func (x *ForwardingRule) GetPscConnectionId() uint64 {
	if x != nil && x.PscConnectionId != nil {
		return *x.PscConnectionId
	}
	return 0
}

func (x *ForwardingRule) GetRegion() string {
	if x != nil && x.Region != nil {
		return *x.Region
	}
	return ""
}

func (x *ForwardingRule) GetSelfLink() string {
	if x != nil && x.SelfLink != nil {
		return *x.SelfLink
	}
	return ""
}

func (x *ForwardingRule) GetServiceDirectoryRegistrations() []*ForwardingRuleServiceDirectoryRegistration {
	if x != nil {
		return x.ServiceDirectoryRegistrations
	}
	return nil
}

func (x *ForwardingRule) GetServiceLabel() string {
	if x != nil && x.ServiceLabel != nil {
		return *x.ServiceLabel
	}
	return ""
}

func (x *ForwardingRule) GetServiceName() string {
	if x != nil && x.ServiceName != nil {
		return *x.ServiceName
	}
	return ""
}

func (x *ForwardingRule) GetSubnetwork() string {
	if x != nil && x.Subnetwork != nil {
		return *x.Subnetwork
	}
	return ""
}

func (x *ForwardingRule) GetTarget() string {
	if x != nil && x.Target != nil {
		return *x.Target
	}
	return ""
}

//
type ForwardingRulesScopedList struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A list of forwarding rules contained in this scope.
	ForwardingRules []*ForwardingRule `protobuf:"bytes,315821365,rep,name=forwarding_rules,json=forwardingRules,proto3" json:"forwarding_rules,omitempty"`
	// Informational warning which replaces the list of forwarding rules when the list is empty.
	Warning *Warning `protobuf:"bytes,50704284,opt,name=warning,proto3,oneof" json:"warning,omitempty"`
}

func (x *ForwardingRulesScopedList) Reset() {
	*x = ForwardingRulesScopedList{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[121]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ForwardingRulesScopedList) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ForwardingRulesScopedList) ProtoMessage() {}

func (x *ForwardingRulesScopedList) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[121]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ForwardingRulesScopedList.ProtoReflect.Descriptor instead.
func (*ForwardingRulesScopedList) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{121}
}

func (x *ForwardingRulesScopedList) GetForwardingRules() []*ForwardingRule {
	if x != nil {
		return x.ForwardingRules
	}
	return nil
}

func (x *ForwardingRulesScopedList) GetWarning() *Warning {
	if x != nil {
		return x.Warning
	}
	return nil
}

//
type ForwardingRuleAggregatedList struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// [Output Only] Unique identifier for the resource; defined by the server.
	Id *string `protobuf:"bytes,3355,opt,name=id,proto3,oneof" json:"id,omitempty"`
	// A list of ForwardingRulesScopedList resources.
	Items map[string]*ForwardingRulesScopedList `protobuf:"bytes,100526016,rep,name=items,proto3" json:"items,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// [Output Only] Type of resource. Always compute#forwardingRuleAggregatedList for lists of forwarding rules.
	Kind *string `protobuf:"bytes,3292052,opt,name=kind,proto3,oneof" json:"kind,omitempty"`
	// [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
	NextPageToken *string `protobuf:"bytes,79797525,opt,name=next_page_token,json=nextPageToken,proto3,oneof" json:"next_page_token,omitempty"`
	// [Output Only] Server-defined URL for this resource.
	SelfLink *string `protobuf:"bytes,456214797,opt,name=self_link,json=selfLink,proto3,oneof" json:"self_link,omitempty"`
	// [Output Only] Unreachable resources.
	Unreachables []string `protobuf:"bytes,243372063,rep,name=unreachables,proto3" json:"unreachables,omitempty"`
	// [Output Only] Informational warning message.
	Warning *Warning `protobuf:"bytes,50704284,opt,name=warning,proto3,oneof" json:"warning,omitempty"`
}

func (x *ForwardingRuleAggregatedList) Reset() {
	*x = ForwardingRuleAggregatedList{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[122]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ForwardingRuleAggregatedList) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ForwardingRuleAggregatedList) ProtoMessage() {}

func (x *ForwardingRuleAggregatedList) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[122]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ForwardingRuleAggregatedList.ProtoReflect.Descriptor instead.
func (*ForwardingRuleAggregatedList) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{122}
}

func (x *ForwardingRuleAggregatedList) GetId() string {
	if x != nil && x.Id != nil {
		return *x.Id
	}
	return ""
}

func (x *ForwardingRuleAggregatedList) GetItems() map[string]*ForwardingRulesScopedList {
	if x != nil {
		return x.Items
	}
	return nil
}

func (x *ForwardingRuleAggregatedList) GetKind() string {
	if x != nil && x.Kind != nil {
		return *x.Kind
	}
	return ""
}

func (x *ForwardingRuleAggregatedList) GetNextPageToken() string {
	if x != nil && x.NextPageToken != nil {
		return *x.NextPageToken
	}
	return ""
}

func (x *ForwardingRuleAggregatedList) GetSelfLink() string {
	if x != nil && x.SelfLink != nil {
		return *x.SelfLink
	}
	return ""
}

func (x *ForwardingRuleAggregatedList) GetUnreachables() []string {
	if x != nil {
		return x.Unreachables
	}
	return nil
}

func (x *ForwardingRuleAggregatedList) GetWarning() *Warning {
	if x != nil {
		return x.Warning
	}
	return nil
}

// Contains a list of ForwardingRule resources.
type ForwardingRuleList struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// [Output Only] Unique identifier for the resource; defined by the server.
	Id *string `protobuf:"bytes,3355,opt,name=id,proto3,oneof" json:"id,omitempty"`
	// A list of ForwardingRule resources.
	Items []*ForwardingRule `protobuf:"bytes,100526016,rep,name=items,proto3" json:"items,omitempty"`
	// Type of resource.
	Kind *string `protobuf:"bytes,3292052,opt,name=kind,proto3,oneof" json:"kind,omitempty"`
	// [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
	NextPageToken *string `protobuf:"bytes,79797525,opt,name=next_page_token,json=nextPageToken,proto3,oneof" json:"next_page_token,omitempty"`
	// [Output Only] Server-defined URL for this resource.
	SelfLink *string `protobuf:"bytes,456214797,opt,name=self_link,json=selfLink,proto3,oneof" json:"self_link,omitempty"`
	// [Output Only] Informational warning message.
	Warning *Warning `protobuf:"bytes,50704284,opt,name=warning,proto3,oneof" json:"warning,omitempty"`
}

func (x *ForwardingRuleList) Reset() {
	*x = ForwardingRuleList{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[123]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ForwardingRuleList) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ForwardingRuleList) ProtoMessage() {}

func (x *ForwardingRuleList) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[123]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ForwardingRuleList.ProtoReflect.Descriptor instead.
func (*ForwardingRuleList) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{123}
}

func (x *ForwardingRuleList) GetId() string {
	if x != nil && x.Id != nil {
		return *x.Id
	}
	return ""
}

func (x *ForwardingRuleList) GetItems() []*ForwardingRule {
	if x != nil {
		return x.Items
	}
	return nil
}

func (x *ForwardingRuleList) GetKind() string {
	if x != nil && x.Kind != nil {
		return *x.Kind
	}
	return ""
}

func (x *ForwardingRuleList) GetNextPageToken() string {
	if x != nil && x.NextPageToken != nil {
		return *x.NextPageToken
	}
	return ""
}

func (x *ForwardingRuleList) GetSelfLink() string {
	if x != nil && x.SelfLink != nil {
		return *x.SelfLink
	}
	return ""
}

func (x *ForwardingRuleList) GetWarning() *Warning {
	if x != nil {
		return x.Warning
	}
	return nil
}

//
type ForwardingRuleReference struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ForwardingRule *string `protobuf:"bytes,269964030,opt,name=forwarding_rule,json=forwardingRule,proto3,oneof" json:"forwarding_rule,omitempty"`
}

func (x *ForwardingRuleReference) Reset() {
	*x = ForwardingRuleReference{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[124]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ForwardingRuleReference) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ForwardingRuleReference) ProtoMessage() {}

func (x *ForwardingRuleReference) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[124]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ForwardingRuleReference.ProtoReflect.Descriptor instead.
func (*ForwardingRuleReference) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{124}
}

func (x *ForwardingRuleReference) GetForwardingRule() string {
	if x != nil && x.ForwardingRule != nil {
		return *x.ForwardingRule
	}
	return ""
}

//
type GRPCHealthCheck struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The gRPC service name for the health check. This field is optional. The value of grpc_service_name has the following meanings by convention:
	// - Empty service_name means the overall status of all services at the backend.
	// - Non-empty service_name means the health of that gRPC service, as defined by the owner of the service.
	// The grpc_service_name can only be ASCII.
	GrpcServiceName *string `protobuf:"bytes,136533078,opt,name=grpc_service_name,json=grpcServiceName,proto3,oneof" json:"grpc_service_name,omitempty"`
	// The port number for the health check request. Must be specified if port_name and port_specification are not set or if port_specification is USE_FIXED_PORT. Valid values are 1 through 65535.
	Port *int32 `protobuf:"varint,3446913,opt,name=port,proto3,oneof" json:"port,omitempty"`
	// Port name as defined in InstanceGroup#NamedPort#name. If both port and port_name are defined, port takes precedence. The port_name should conform to RFC1035.
	PortName *string `protobuf:"bytes,41534345,opt,name=port_name,json=portName,proto3,oneof" json:"port_name,omitempty"`
	// Specifies how port is selected for health checking, can be one of following values:
	// USE_FIXED_PORT: The port number in port is used for health checking.
	// USE_NAMED_PORT: The portName is used for health checking.
	// USE_SERVING_PORT: For NetworkEndpointGroup, the port specified for each network endpoint is used for health checking. For other backends, the port or named port specified in the Backend Service is used for health checking.
	//
	//
	// If not specified, gRPC health check follows behavior specified in port and portName fields.
	PortSpecification *GRPCHealthCheck_PortSpecification `protobuf:"varint,51590597,opt,name=port_specification,json=portSpecification,proto3,enum=google.cloud.compute.v1.GRPCHealthCheck_PortSpecification,oneof" json:"port_specification,omitempty"`
}

func (x *GRPCHealthCheck) Reset() {
	*x = GRPCHealthCheck{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[125]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GRPCHealthCheck) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GRPCHealthCheck) ProtoMessage() {}

func (x *GRPCHealthCheck) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[125]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GRPCHealthCheck.ProtoReflect.Descriptor instead.
func (*GRPCHealthCheck) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{125}
}

func (x *GRPCHealthCheck) GetGrpcServiceName() string {
	if x != nil && x.GrpcServiceName != nil {
		return *x.GrpcServiceName
	}
	return ""
}

func (x *GRPCHealthCheck) GetPort() int32 {
	if x != nil && x.Port != nil {
		return *x.Port
	}
	return 0
}

func (x *GRPCHealthCheck) GetPortName() string {
	if x != nil && x.PortName != nil {
		return *x.PortName
	}
	return ""
}

func (x *GRPCHealthCheck) GetPortSpecification() GRPCHealthCheck_PortSpecification {
	if x != nil && x.PortSpecification != nil {
		return *x.PortSpecification
	}
	return GRPCHealthCheck_UNDEFINED_PORT_SPECIFICATION
}

// The network endpoint.
type NetworkEndpoint struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Metadata defined as annotations on the network endpoint.
	Annotations map[string]string `protobuf:"bytes,112032548,rep,name=annotations,proto3" json:"annotations,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Optional fully qualified domain name of network endpoint. This can only be specified when NetworkEndpointGroup.network_endpoint_type is NON_GCP_FQDN_PORT.
	Fqdn *string `protobuf:"bytes,3150485,opt,name=fqdn,proto3,oneof" json:"fqdn,omitempty"`
	// The name for a specific VM instance that the IP address belongs to. This is required for network endpoints of type GCE_VM_IP_PORT. The instance must be in the same zone of network endpoint group.
	//
	// The name must be 1-63 characters long, and comply with RFC1035.
	Instance *string `protobuf:"bytes,18257045,opt,name=instance,proto3,oneof" json:"instance,omitempty"`
	// Optional IPv4 address of network endpoint. The IP address must belong to a VM in Compute Engine (either the primary IP or as part of an aliased IP range). If the IP address is not specified, then the primary IP address for the VM instance in the network that the network endpoint group belongs to will be used.
	IpAddress *string `protobuf:"bytes,406272220,opt,name=ip_address,json=ipAddress,proto3,oneof" json:"ip_address,omitempty"`
	// Optional port number of network endpoint. If not specified, the defaultPort for the network endpoint group will be used.
	Port *int32 `protobuf:"varint,3446913,opt,name=port,proto3,oneof" json:"port,omitempty"`
}

func (x *NetworkEndpoint) Reset() {
	*x = NetworkEndpoint{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[126]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *NetworkEndpoint) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NetworkEndpoint) ProtoMessage() {}

func (x *NetworkEndpoint) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[126]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NetworkEndpoint.ProtoReflect.Descriptor instead.
func (*NetworkEndpoint) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{126}
}

func (x *NetworkEndpoint) GetAnnotations() map[string]string {
	if x != nil {
		return x.Annotations
	}
	return nil
}

func (x *NetworkEndpoint) GetFqdn() string {
	if x != nil && x.Fqdn != nil {
		return *x.Fqdn
	}
	return ""
}

func (x *NetworkEndpoint) GetInstance() string {
	if x != nil && x.Instance != nil {
		return *x.Instance
	}
	return ""
}

func (x *NetworkEndpoint) GetIpAddress() string {
	if x != nil && x.IpAddress != nil {
		return *x.IpAddress
	}
	return ""
}

func (x *NetworkEndpoint) GetPort() int32 {
	if x != nil && x.Port != nil {
		return *x.Port
	}
	return 0
}

//
type GlobalNetworkEndpointGroupsAttachEndpointsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of network endpoints to be attached.
	NetworkEndpoints []*NetworkEndpoint `protobuf:"bytes,149850285,rep,name=network_endpoints,json=networkEndpoints,proto3" json:"network_endpoints,omitempty"`
}

func (x *GlobalNetworkEndpointGroupsAttachEndpointsRequest) Reset() {
	*x = GlobalNetworkEndpointGroupsAttachEndpointsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[127]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GlobalNetworkEndpointGroupsAttachEndpointsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GlobalNetworkEndpointGroupsAttachEndpointsRequest) ProtoMessage() {}

func (x *GlobalNetworkEndpointGroupsAttachEndpointsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[127]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GlobalNetworkEndpointGroupsAttachEndpointsRequest.ProtoReflect.Descriptor instead.
func (*GlobalNetworkEndpointGroupsAttachEndpointsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{127}
}

func (x *GlobalNetworkEndpointGroupsAttachEndpointsRequest) GetNetworkEndpoints() []*NetworkEndpoint {
	if x != nil {
		return x.NetworkEndpoints
	}
	return nil
}

//
type GlobalNetworkEndpointGroupsDetachEndpointsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of network endpoints to be detached.
	NetworkEndpoints []*NetworkEndpoint `protobuf:"bytes,149850285,rep,name=network_endpoints,json=networkEndpoints,proto3" json:"network_endpoints,omitempty"`
}

func (x *GlobalNetworkEndpointGroupsDetachEndpointsRequest) Reset() {
	*x = GlobalNetworkEndpointGroupsDetachEndpointsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[128]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GlobalNetworkEndpointGroupsDetachEndpointsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GlobalNetworkEndpointGroupsDetachEndpointsRequest) ProtoMessage() {}

func (x *GlobalNetworkEndpointGroupsDetachEndpointsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[128]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GlobalNetworkEndpointGroupsDetachEndpointsRequest.ProtoReflect.Descriptor instead.
func (*GlobalNetworkEndpointGroupsDetachEndpointsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{128}
}

func (x *GlobalNetworkEndpointGroupsDetachEndpointsRequest) GetNetworkEndpoints() []*NetworkEndpoint {
	if x != nil {
		return x.NetworkEndpoints
	}
	return nil
}

// An Identity and Access Management (IAM) policy, which specifies access controls for Google Cloud resources.
//
//
//
// A `Policy` is a collection of `bindings`. A `binding` binds one or more `members` to a single `role`. Members can be user accounts, service accounts, Google groups, and domains (such as G Suite). A `role` is a named list of permissions; each `role` can be an IAM predefined role or a user-created custom role.
//
// For some types of Google Cloud resources, a `binding` can also specify a `condition`, which is a logical expression that allows access to a resource only if the expression evaluates to `true`. A condition can add constraints based on attributes of the request, the resource, or both. To learn which resources support conditions in their IAM policies, see the [IAM documentation](https://cloud.google.com/iam/help/conditions/resource-policies).
//
// **JSON example:**
//
// { "bindings": [ { "role": "roles/resourcemanager.organizationAdmin", "members": [ "user:mike@example.com", "group:admins@example.com", "domain:google.com", "serviceAccount:my-project-id@appspot.gserviceaccount.com" ] }, { "role": "roles/resourcemanager.organizationViewer", "members": [ "user:eve@example.com" ], "condition": { "title": "expirable access", "description": "Does not grant access after Sep 2020", "expression": "request.time < timestamp('2020-10-01T00:00:00.000Z')", } } ], "etag": "BwWWja0YfJA=", "version": 3 }
//
// **YAML example:**
//
// bindings: - members: - user:mike@example.com - group:admins@example.com - domain:google.com - serviceAccount:my-project-id@appspot.gserviceaccount.com role: roles/resourcemanager.organizationAdmin - members: - user:eve@example.com role: roles/resourcemanager.organizationViewer condition: title: expirable access description: Does not grant access after Sep 2020 expression: request.time < timestamp('2020-10-01T00:00:00.000Z') - etag: BwWWja0YfJA= - version: 3
//
// For a description of IAM and its features, see the [IAM documentation](https://cloud.google.com/iam/docs/).
type Policy struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Specifies cloud audit logging configuration for this policy.
	AuditConfigs []*AuditConfig `protobuf:"bytes,328080653,rep,name=audit_configs,json=auditConfigs,proto3" json:"audit_configs,omitempty"`
	// Associates a list of `members` to a `role`. Optionally, may specify a `condition` that determines how and when the `bindings` are applied. Each of the `bindings` must contain at least one member.
	Bindings []*Binding `protobuf:"bytes,403251854,rep,name=bindings,proto3" json:"bindings,omitempty"`
	// `etag` is used for optimistic concurrency control as a way to help prevent simultaneous updates of a policy from overwriting each other. It is strongly suggested that systems make use of the `etag` in the read-modify-write cycle to perform policy updates in order to avoid race conditions: An `etag` is returned in the response to `getIamPolicy`, and systems are expected to put that etag in the request to `setIamPolicy` to ensure that their change will be applied to the same version of the policy.
	//
	// **Important:** If you use IAM Conditions, you must include the `etag` field whenever you call `setIamPolicy`. If you omit this field, then IAM allows you to overwrite a version `3` policy with a version `1` policy, and all of the conditions in the version `3` policy are lost.
	Etag     *string `protobuf:"bytes,3123477,opt,name=etag,proto3,oneof" json:"etag,omitempty"`
	IamOwned *bool   `protobuf:"varint,450566203,opt,name=iam_owned,json=iamOwned,proto3,oneof" json:"iam_owned,omitempty"`
	// If more than one rule is specified, the rules are applied in the following manner: - All matching LOG rules are always applied. - If any DENY/DENY_WITH_LOG rule matches, permission is denied. Logging will be applied if one or more matching rule requires logging. - Otherwise, if any ALLOW/ALLOW_WITH_LOG rule matches, permission is granted. Logging will be applied if one or more matching rule requires logging. - Otherwise, if no rule applies, permission is denied.
	Rules []*Rule `protobuf:"bytes,108873975,rep,name=rules,proto3" json:"rules,omitempty"`
	// Specifies the format of the policy.
	//
	// Valid values are `0`, `1`, and `3`. Requests that specify an invalid value are rejected.
	//
	// Any operation that affects conditional role bindings must specify version `3`. This requirement applies to the following operations:
	//
	// * Getting a policy that includes a conditional role binding * Adding a conditional role binding to a policy * Changing a conditional role binding in a policy * Removing any role binding, with or without a condition, from a policy that includes conditions
	//
	// **Important:** If you use IAM Conditions, you must include the `etag` field whenever you call `setIamPolicy`. If you omit this field, then IAM allows you to overwrite a version `3` policy with a version `1` policy, and all of the conditions in the version `3` policy are lost.
	//
	// If a policy does not include any conditions, operations on that policy may specify any valid version or leave the field unset.
	//
	// To learn which resources support conditions in their IAM policies, see the [IAM documentation](https://cloud.google.com/iam/help/conditions/resource-policies).
	Version *int32 `protobuf:"varint,351608024,opt,name=version,proto3,oneof" json:"version,omitempty"`
}

func (x *Policy) Reset() {
	*x = Policy{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[129]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Policy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Policy) ProtoMessage() {}

func (x *Policy) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[129]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Policy.ProtoReflect.Descriptor instead.
func (*Policy) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{129}
}

func (x *Policy) GetAuditConfigs() []*AuditConfig {
	if x != nil {
		return x.AuditConfigs
	}
	return nil
}

func (x *Policy) GetBindings() []*Binding {
	if x != nil {
		return x.Bindings
	}
	return nil
}

func (x *Policy) GetEtag() string {
	if x != nil && x.Etag != nil {
		return *x.Etag
	}
	return ""
}

func (x *Policy) GetIamOwned() bool {
	if x != nil && x.IamOwned != nil {
		return *x.IamOwned
	}
	return false
}

func (x *Policy) GetRules() []*Rule {
	if x != nil {
		return x.Rules
	}
	return nil
}

func (x *Policy) GetVersion() int32 {
	if x != nil && x.Version != nil {
		return *x.Version
	}
	return 0
}

//
type GlobalOrganizationSetPolicyRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Flatten Policy to create a backward compatible wire-format. Deprecated. Use 'policy' to specify bindings.
	Bindings []*Binding `protobuf:"bytes,403251854,rep,name=bindings,proto3" json:"bindings,omitempty"`
	// Flatten Policy to create a backward compatible wire-format. Deprecated. Use 'policy' to specify the etag.
	Etag *string `protobuf:"bytes,3123477,opt,name=etag,proto3,oneof" json:"etag,omitempty"`
	// REQUIRED: The complete policy to be applied to the 'resource'. The size of the policy is limited to a few 10s of KB. An empty policy is in general a valid policy but certain services (like Projects) might reject them.
	Policy *Policy `protobuf:"bytes,91071794,opt,name=policy,proto3,oneof" json:"policy,omitempty"`
}

func (x *GlobalOrganizationSetPolicyRequest) Reset() {
	*x = GlobalOrganizationSetPolicyRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[130]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GlobalOrganizationSetPolicyRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GlobalOrganizationSetPolicyRequest) ProtoMessage() {}

func (x *GlobalOrganizationSetPolicyRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[130]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GlobalOrganizationSetPolicyRequest.ProtoReflect.Descriptor instead.
func (*GlobalOrganizationSetPolicyRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{130}
}

func (x *GlobalOrganizationSetPolicyRequest) GetBindings() []*Binding {
	if x != nil {
		return x.Bindings
	}
	return nil
}

func (x *GlobalOrganizationSetPolicyRequest) GetEtag() string {
	if x != nil && x.Etag != nil {
		return *x.Etag
	}
	return ""
}

func (x *GlobalOrganizationSetPolicyRequest) GetPolicy() *Policy {
	if x != nil {
		return x.Policy
	}
	return nil
}

//
type GlobalSetLabelsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The fingerprint of the previous set of labels for this resource, used to detect conflicts. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update labels. You must always provide an up-to-date fingerprint hash when updating or changing labels, otherwise the request will fail with error 412 conditionNotMet. Make a get() request to the resource to get the latest fingerprint.
	LabelFingerprint *string `protobuf:"bytes,178124825,opt,name=label_fingerprint,json=labelFingerprint,proto3,oneof" json:"label_fingerprint,omitempty"`
	// A list of labels to apply for this resource. Each label key & value must comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash. For example, "webserver-frontend": "images". A label value can also be empty (e.g. "my-label": "").
	Labels map[string]string `protobuf:"bytes,500195327,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *GlobalSetLabelsRequest) Reset() {
	*x = GlobalSetLabelsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[131]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GlobalSetLabelsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GlobalSetLabelsRequest) ProtoMessage() {}

func (x *GlobalSetLabelsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[131]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GlobalSetLabelsRequest.ProtoReflect.Descriptor instead.
func (*GlobalSetLabelsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{131}
}

func (x *GlobalSetLabelsRequest) GetLabelFingerprint() string {
	if x != nil && x.LabelFingerprint != nil {
		return *x.LabelFingerprint
	}
	return ""
}

func (x *GlobalSetLabelsRequest) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

//
type GlobalSetPolicyRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Flatten Policy to create a backward compatible wire-format. Deprecated. Use 'policy' to specify bindings.
	Bindings []*Binding `protobuf:"bytes,403251854,rep,name=bindings,proto3" json:"bindings,omitempty"`
	// Flatten Policy to create a backward compatible wire-format. Deprecated. Use 'policy' to specify the etag.
	Etag *string `protobuf:"bytes,3123477,opt,name=etag,proto3,oneof" json:"etag,omitempty"`
	// REQUIRED: The complete policy to be applied to the 'resource'. The size of the policy is limited to a few 10s of KB. An empty policy is in general a valid policy but certain services (like Projects) might reject them.
	Policy *Policy `protobuf:"bytes,91071794,opt,name=policy,proto3,oneof" json:"policy,omitempty"`
}

func (x *GlobalSetPolicyRequest) Reset() {
	*x = GlobalSetPolicyRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[132]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GlobalSetPolicyRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GlobalSetPolicyRequest) ProtoMessage() {}

func (x *GlobalSetPolicyRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[132]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GlobalSetPolicyRequest.ProtoReflect.Descriptor instead.
func (*GlobalSetPolicyRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{132}
}

func (x *GlobalSetPolicyRequest) GetBindings() []*Binding {
	if x != nil {
		return x.Bindings
	}
	return nil
}

func (x *GlobalSetPolicyRequest) GetEtag() string {
	if x != nil && x.Etag != nil {
		return *x.Etag
	}
	return ""
}

func (x *GlobalSetPolicyRequest) GetPolicy() *Policy {
	if x != nil {
		return x.Policy
	}
	return nil
}

// Array of guest attribute namespace/key/value tuples.
type GuestAttributesValue struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Items []*GuestAttributesEntry `protobuf:"bytes,100526016,rep,name=items,proto3" json:"items,omitempty"`
}

func (x *GuestAttributesValue) Reset() {
	*x = GuestAttributesValue{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[133]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GuestAttributesValue) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GuestAttributesValue) ProtoMessage() {}

func (x *GuestAttributesValue) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[133]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GuestAttributesValue.ProtoReflect.Descriptor instead.
func (*GuestAttributesValue) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{133}
}

func (x *GuestAttributesValue) GetItems() []*GuestAttributesEntry {
	if x != nil {
		return x.Items
	}
	return nil
}

// A guest attributes entry.
type GuestAttributes struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// [Output Only] Type of the resource. Always compute#guestAttributes for guest attributes entry.
	Kind *string `protobuf:"bytes,3292052,opt,name=kind,proto3,oneof" json:"kind,omitempty"`
	// The path to be queried. This can be the default namespace ('/') or a nested namespace ('/\/') or a specified key ('/\/\')
	QueryPath *string `protobuf:"bytes,368591164,opt,name=query_path,json=queryPath,proto3,oneof" json:"query_path,omitempty"`
	// [Output Only] The value of the requested queried path.
	QueryValue *GuestAttributesValue `protobuf:"bytes,157570874,opt,name=query_value,json=queryValue,proto3,oneof" json:"query_value,omitempty"`
	// [Output Only] Server-defined URL for this resource.
	SelfLink *string `protobuf:"bytes,456214797,opt,name=self_link,json=selfLink,proto3,oneof" json:"self_link,omitempty"`
	// The key to search for.
	VariableKey *string `protobuf:"bytes,164364828,opt,name=variable_key,json=variableKey,proto3,oneof" json:"variable_key,omitempty"`
	// [Output Only] The value found for the requested key.
	VariableValue *string `protobuf:"bytes,124582382,opt,name=variable_value,json=variableValue,proto3,oneof" json:"variable_value,omitempty"`
}

func (x *GuestAttributes) Reset() {
	*x = GuestAttributes{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[134]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GuestAttributes) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GuestAttributes) ProtoMessage() {}

func (x *GuestAttributes) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[134]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GuestAttributes.ProtoReflect.Descriptor instead.
func (*GuestAttributes) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{134}
}

func (x *GuestAttributes) GetKind() string {
	if x != nil && x.Kind != nil {
		return *x.Kind
	}
	return ""
}

func (x *GuestAttributes) GetQueryPath() string {
	if x != nil && x.QueryPath != nil {
		return *x.QueryPath
	}
	return ""
}

func (x *GuestAttributes) GetQueryValue() *GuestAttributesValue {
	if x != nil {
		return x.QueryValue
	}
	return nil
}

func (x *GuestAttributes) GetSelfLink() string {
	if x != nil && x.SelfLink != nil {
		return *x.SelfLink
	}
	return ""
}

func (x *GuestAttributes) GetVariableKey() string {
	if x != nil && x.VariableKey != nil {
		return *x.VariableKey
	}
	return ""
}

func (x *GuestAttributes) GetVariableValue() string {
	if x != nil && x.VariableValue != nil {
		return *x.VariableValue
	}
	return ""
}

// A guest attributes namespace/key/value entry.
type GuestAttributesEntry struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Key for the guest attribute entry.
	Key *string `protobuf:"bytes,106079,opt,name=key,proto3,oneof" json:"key,omitempty"`
	// Namespace for the guest attribute entry.
	Namespace *string `protobuf:"bytes,178476379,opt,name=namespace,proto3,oneof" json:"namespace,omitempty"`
	// Value for the guest attribute entry.
	Value *string `protobuf:"bytes,111972721,opt,name=value,proto3,oneof" json:"value,omitempty"`
}

func (x *GuestAttributesEntry) Reset() {
	*x = GuestAttributesEntry{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[135]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GuestAttributesEntry) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GuestAttributesEntry) ProtoMessage() {}

func (x *GuestAttributesEntry) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[135]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GuestAttributesEntry.ProtoReflect.Descriptor instead.
func (*GuestAttributesEntry) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{135}
}

func (x *GuestAttributesEntry) GetKey() string {
	if x != nil && x.Key != nil {
		return *x.Key
	}
	return ""
}

func (x *GuestAttributesEntry) GetNamespace() string {
	if x != nil && x.Namespace != nil {
		return *x.Namespace
	}
	return ""
}

func (x *GuestAttributesEntry) GetValue() string {
	if x != nil && x.Value != nil {
		return *x.Value
	}
	return ""
}

//
type HTTP2HealthCheck struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The value of the host header in the HTTP/2 health check request. If left empty (default value), the IP on behalf of which this health check is performed will be used.
	Host *string `protobuf:"bytes,3208616,opt,name=host,proto3,oneof" json:"host,omitempty"`
	// The TCP port number for the health check request. The default value is 443. Valid values are 1 through 65535.
	Port *int32 `protobuf:"varint,3446913,opt,name=port,proto3,oneof" json:"port,omitempty"`
	// Port name as defined in InstanceGroup#NamedPort#name. If both port and port_name are defined, port takes precedence.
	PortName *string `protobuf:"bytes,41534345,opt,name=port_name,json=portName,proto3,oneof" json:"port_name,omitempty"`
	// Specifies how port is selected for health checking, can be one of following values:
	// USE_FIXED_PORT: The port number in port is used for health checking.
	// USE_NAMED_PORT: The portName is used for health checking.
	// USE_SERVING_PORT: For NetworkEndpointGroup, the port specified for each network endpoint is used for health checking. For other backends, the port or named port specified in the Backend Service is used for health checking.
	//
	//
	// If not specified, HTTP2 health check follows behavior specified in port and portName fields.
	PortSpecification *HTTP2HealthCheck_PortSpecification `protobuf:"varint,51590597,opt,name=port_specification,json=portSpecification,proto3,enum=google.cloud.compute.v1.HTTP2HealthCheck_PortSpecification,oneof" json:"port_specification,omitempty"`
	// Specifies the type of proxy header to append before sending data to the backend, either NONE or PROXY_V1. The default is NONE.
	ProxyHeader *HTTP2HealthCheck_ProxyHeader `protobuf:"varint,160374142,opt,name=proxy_header,json=proxyHeader,proto3,enum=google.cloud.compute.v1.HTTP2HealthCheck_ProxyHeader,oneof" json:"proxy_header,omitempty"`
	// The request path of the HTTP/2 health check request. The default value is /.
	RequestPath *string `protobuf:"bytes,229403605,opt,name=request_path,json=requestPath,proto3,oneof" json:"request_path,omitempty"`
	// The string to match anywhere in the first 1024 bytes of the response body. If left empty (the default value), the status code determines health. The response data can only be ASCII.
	Response *string `protobuf:"bytes,196547649,opt,name=response,proto3,oneof" json:"response,omitempty"`
}

func (x *HTTP2HealthCheck) Reset() {
	*x = HTTP2HealthCheck{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[136]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *HTTP2HealthCheck) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HTTP2HealthCheck) ProtoMessage() {}

func (x *HTTP2HealthCheck) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[136]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HTTP2HealthCheck.ProtoReflect.Descriptor instead.
func (*HTTP2HealthCheck) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{136}
}

func (x *HTTP2HealthCheck) GetHost() string {
	if x != nil && x.Host != nil {
		return *x.Host
	}
	return ""
}

func (x *HTTP2HealthCheck) GetPort() int32 {
	if x != nil && x.Port != nil {
		return *x.Port
	}
	return 0
}

func (x *HTTP2HealthCheck) GetPortName() string {
	if x != nil && x.PortName != nil {
		return *x.PortName
	}
	return ""
}

func (x *HTTP2HealthCheck) GetPortSpecification() HTTP2HealthCheck_PortSpecification {
	if x != nil && x.PortSpecification != nil {
		return *x.PortSpecification
	}
	return HTTP2HealthCheck_UNDEFINED_PORT_SPECIFICATION
}

func (x *HTTP2HealthCheck) GetProxyHeader() HTTP2HealthCheck_ProxyHeader {
	if x != nil && x.ProxyHeader != nil {
		return *x.ProxyHeader
	}
	return HTTP2HealthCheck_UNDEFINED_PROXY_HEADER
}

func (x *HTTP2HealthCheck) GetRequestPath() string {
	if x != nil && x.RequestPath != nil {
		return *x.RequestPath
	}
	return ""
}

func (x *HTTP2HealthCheck) GetResponse() string {
	if x != nil && x.Response != nil {
		return *x.Response
	}
	return ""
}

//
type HTTPHealthCheck struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The value of the host header in the HTTP health check request. If left empty (default value), the IP on behalf of which this health check is performed will be used.
	Host *string `protobuf:"bytes,3208616,opt,name=host,proto3,oneof" json:"host,omitempty"`
	// The TCP port number for the health check request. The default value is 80. Valid values are 1 through 65535.
	Port *int32 `protobuf:"varint,3446913,opt,name=port,proto3,oneof" json:"port,omitempty"`
	// Port name as defined in InstanceGroup#NamedPort#name. If both port and port_name are defined, port takes precedence.
	PortName *string `protobuf:"bytes,41534345,opt,name=port_name,json=portName,proto3,oneof" json:"port_name,omitempty"`
	// Specifies how port is selected for health checking, can be one of following values:
	// USE_FIXED_PORT: The port number in port is used for health checking.
	// USE_NAMED_PORT: The portName is used for health checking.
	// USE_SERVING_PORT: For NetworkEndpointGroup, the port specified for each network endpoint is used for health checking. For other backends, the port or named port specified in the Backend Service is used for health checking.
	//
	//
	// If not specified, HTTP health check follows behavior specified in port and portName fields.
	PortSpecification *HTTPHealthCheck_PortSpecification `protobuf:"varint,51590597,opt,name=port_specification,json=portSpecification,proto3,enum=google.cloud.compute.v1.HTTPHealthCheck_PortSpecification,oneof" json:"port_specification,omitempty"`
	// Specifies the type of proxy header to append before sending data to the backend, either NONE or PROXY_V1. The default is NONE.
	ProxyHeader *HTTPHealthCheck_ProxyHeader `protobuf:"varint,160374142,opt,name=proxy_header,json=proxyHeader,proto3,enum=google.cloud.compute.v1.HTTPHealthCheck_ProxyHeader,oneof" json:"proxy_header,omitempty"`
	// The request path of the HTTP health check request. The default value is /.
	RequestPath *string `protobuf:"bytes,229403605,opt,name=request_path,json=requestPath,proto3,oneof" json:"request_path,omitempty"`
	// The string to match anywhere in the first 1024 bytes of the response body. If left empty (the default value), the status code determines health. The response data can only be ASCII.
	Response *string `protobuf:"bytes,196547649,opt,name=response,proto3,oneof" json:"response,omitempty"`
}

func (x *HTTPHealthCheck) Reset() {
	*x = HTTPHealthCheck{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[137]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *HTTPHealthCheck) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HTTPHealthCheck) ProtoMessage() {}

func (x *HTTPHealthCheck) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[137]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HTTPHealthCheck.ProtoReflect.Descriptor instead.
func (*HTTPHealthCheck) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{137}
}

func (x *HTTPHealthCheck) GetHost() string {
	if x != nil && x.Host != nil {
		return *x.Host
	}
	return ""
}

func (x *HTTPHealthCheck) GetPort() int32 {
	if x != nil && x.Port != nil {
		return *x.Port
	}
	return 0
}

func (x *HTTPHealthCheck) GetPortName() string {
	if x != nil && x.PortName != nil {
		return *x.PortName
	}
	return ""
}

func (x *HTTPHealthCheck) GetPortSpecification() HTTPHealthCheck_PortSpecification {
	if x != nil && x.PortSpecification != nil {
		return *x.PortSpecification
	}
	return HTTPHealthCheck_UNDEFINED_PORT_SPECIFICATION
}

func (x *HTTPHealthCheck) GetProxyHeader() HTTPHealthCheck_ProxyHeader {
	if x != nil && x.ProxyHeader != nil {
		return *x.ProxyHeader
	}
	return HTTPHealthCheck_UNDEFINED_PROXY_HEADER
}

func (x *HTTPHealthCheck) GetRequestPath() string {
	if x != nil && x.RequestPath != nil {
		return *x.RequestPath
	}
	return ""
}

func (x *HTTPHealthCheck) GetResponse() string {
	if x != nil && x.Response != nil {
		return *x.Response
	}
	return ""
}

//
type HTTPSHealthCheck struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The value of the host header in the HTTPS health check request. If left empty (default value), the IP on behalf of which this health check is performed will be used.
	Host *string `protobuf:"bytes,3208616,opt,name=host,proto3,oneof" json:"host,omitempty"`
	// The TCP port number for the health check request. The default value is 443. Valid values are 1 through 65535.
	Port *int32 `protobuf:"varint,3446913,opt,name=port,proto3,oneof" json:"port,omitempty"`
	// Port name as defined in InstanceGroup#NamedPort#name. If both port and port_name are defined, port takes precedence.
	PortName *string `protobuf:"bytes,41534345,opt,name=port_name,json=portName,proto3,oneof" json:"port_name,omitempty"`
	// Specifies how port is selected for health checking, can be one of following values:
	// USE_FIXED_PORT: The port number in port is used for health checking.
	// USE_NAMED_PORT: The portName is used for health checking.
	// USE_SERVING_PORT: For NetworkEndpointGroup, the port specified for each network endpoint is used for health checking. For other backends, the port or named port specified in the Backend Service is used for health checking.
	//
	//
	// If not specified, HTTPS health check follows behavior specified in port and portName fields.
	PortSpecification *HTTPSHealthCheck_PortSpecification `protobuf:"varint,51590597,opt,name=port_specification,json=portSpecification,proto3,enum=google.cloud.compute.v1.HTTPSHealthCheck_PortSpecification,oneof" json:"port_specification,omitempty"`
	// Specifies the type of proxy header to append before sending data to the backend, either NONE or PROXY_V1. The default is NONE.
	ProxyHeader *HTTPSHealthCheck_ProxyHeader `protobuf:"varint,160374142,opt,name=proxy_header,json=proxyHeader,proto3,enum=google.cloud.compute.v1.HTTPSHealthCheck_ProxyHeader,oneof" json:"proxy_header,omitempty"`
	// The request path of the HTTPS health check request. The default value is /.
	RequestPath *string `protobuf:"bytes,229403605,opt,name=request_path,json=requestPath,proto3,oneof" json:"request_path,omitempty"`
	// The string to match anywhere in the first 1024 bytes of the response body. If left empty (the default value), the status code determines health. The response data can only be ASCII.
	Response *string `protobuf:"bytes,196547649,opt,name=response,proto3,oneof" json:"response,omitempty"`
}

func (x *HTTPSHealthCheck) Reset() {
	*x = HTTPSHealthCheck{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[138]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *HTTPSHealthCheck) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HTTPSHealthCheck) ProtoMessage() {}

func (x *HTTPSHealthCheck) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[138]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HTTPSHealthCheck.ProtoReflect.Descriptor instead.
func (*HTTPSHealthCheck) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{138}
}

func (x *HTTPSHealthCheck) GetHost() string {
	if x != nil && x.Host != nil {
		return *x.Host
	}
	return ""
}

func (x *HTTPSHealthCheck) GetPort() int32 {
	if x != nil && x.Port != nil {
		return *x.Port
	}
	return 0
}

func (x *HTTPSHealthCheck) GetPortName() string {
	if x != nil && x.PortName != nil {
		return *x.PortName
	}
	return ""
}

func (x *HTTPSHealthCheck) GetPortSpecification() HTTPSHealthCheck_PortSpecification {
	if x != nil && x.PortSpecification != nil {
		return *x.PortSpecification
	}
	return HTTPSHealthCheck_UNDEFINED_PORT_SPECIFICATION
}

func (x *HTTPSHealthCheck) GetProxyHeader() HTTPSHealthCheck_ProxyHeader {
	if x != nil && x.ProxyHeader != nil {
		return *x.ProxyHeader
	}
	return HTTPSHealthCheck_UNDEFINED_PROXY_HEADER
}

func (x *HTTPSHealthCheck) GetRequestPath() string {
	if x != nil && x.RequestPath != nil {
		return *x.RequestPath
	}
	return ""
}

func (x *HTTPSHealthCheck) GetResponse() string {
	if x != nil && x.Response != nil {
		return *x.Response
	}
	return ""
}

// Configuration of logging on a health check. If logging is enabled, logs will be exported to Stackdriver.
type HealthCheckLogConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Indicates whether or not to export logs. This is false by default, which means no health check logging will be done.
	Enable *bool `protobuf:"varint,311764355,opt,name=enable,proto3,oneof" json:"enable,omitempty"`
}

func (x *HealthCheckLogConfig) Reset() {
	*x = HealthCheckLogConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[139]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *HealthCheckLogConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HealthCheckLogConfig) ProtoMessage() {}

func (x *HealthCheckLogConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[139]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HealthCheckLogConfig.ProtoReflect.Descriptor instead.
func (*HealthCheckLogConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{139}
}

func (x *HealthCheckLogConfig) GetEnable() bool {
	if x != nil && x.Enable != nil {
		return *x.Enable
	}
	return false
}

//
type SSLHealthCheck struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The TCP port number for the health check request. The default value is 443. Valid values are 1 through 65535.
	Port *int32 `protobuf:"varint,3446913,opt,name=port,proto3,oneof" json:"port,omitempty"`
	// Port name as defined in InstanceGroup#NamedPort#name. If both port and port_name are defined, port takes precedence.
	PortName *string `protobuf:"bytes,41534345,opt,name=port_name,json=portName,proto3,oneof" json:"port_name,omitempty"`
	// Specifies how port is selected for health checking, can be one of following values:
	// USE_FIXED_PORT: The port number in port is used for health checking.
	// USE_NAMED_PORT: The portName is used for health checking.
	// USE_SERVING_PORT: For NetworkEndpointGroup, the port specified for each network endpoint is used for health checking. For other backends, the port or named port specified in the Backend Service is used for health checking.
	//
	//
	// If not specified, SSL health check follows behavior specified in port and portName fields.
	PortSpecification *SSLHealthCheck_PortSpecification `protobuf:"varint,51590597,opt,name=port_specification,json=portSpecification,proto3,enum=google.cloud.compute.v1.SSLHealthCheck_PortSpecification,oneof" json:"port_specification,omitempty"`
	// Specifies the type of proxy header to append before sending data to the backend, either NONE or PROXY_V1. The default is NONE.
	ProxyHeader *SSLHealthCheck_ProxyHeader `protobuf:"varint,160374142,opt,name=proxy_header,json=proxyHeader,proto3,enum=google.cloud.compute.v1.SSLHealthCheck_ProxyHeader,oneof" json:"proxy_header,omitempty"`
	// The application data to send once the SSL connection has been established (default value is empty). If both request and response are empty, the connection establishment alone will indicate health. The request data can only be ASCII.
	Request *string `protobuf:"bytes,21951119,opt,name=request,proto3,oneof" json:"request,omitempty"`
	// The bytes to match against the beginning of the response data. If left empty (the default value), any response will indicate health. The response data can only be ASCII.
	Response *string `protobuf:"bytes,196547649,opt,name=response,proto3,oneof" json:"response,omitempty"`
}

func (x *SSLHealthCheck) Reset() {
	*x = SSLHealthCheck{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[140]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SSLHealthCheck) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SSLHealthCheck) ProtoMessage() {}

func (x *SSLHealthCheck) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[140]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SSLHealthCheck.ProtoReflect.Descriptor instead.
func (*SSLHealthCheck) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{140}
}

func (x *SSLHealthCheck) GetPort() int32 {
	if x != nil && x.Port != nil {
		return *x.Port
	}
	return 0
}

func (x *SSLHealthCheck) GetPortName() string {
	if x != nil && x.PortName != nil {
		return *x.PortName
	}
	return ""
}

func (x *SSLHealthCheck) GetPortSpecification() SSLHealthCheck_PortSpecification {
	if x != nil && x.PortSpecification != nil {
		return *x.PortSpecification
	}
	return SSLHealthCheck_UNDEFINED_PORT_SPECIFICATION
}

func (x *SSLHealthCheck) GetProxyHeader() SSLHealthCheck_ProxyHeader {
	if x != nil && x.ProxyHeader != nil {
		return *x.ProxyHeader
	}
	return SSLHealthCheck_UNDEFINED_PROXY_HEADER
}

func (x *SSLHealthCheck) GetRequest() string {
	if x != nil && x.Request != nil {
		return *x.Request
	}
	return ""
}

func (x *SSLHealthCheck) GetResponse() string {
	if x != nil && x.Response != nil {
		return *x.Response
	}
	return ""
}

//
type TCPHealthCheck struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The TCP port number for the health check request. The default value is 80. Valid values are 1 through 65535.
	Port *int32 `protobuf:"varint,3446913,opt,name=port,proto3,oneof" json:"port,omitempty"`
	// Port name as defined in InstanceGroup#NamedPort#name. If both port and port_name are defined, port takes precedence.
	PortName *string `protobuf:"bytes,41534345,opt,name=port_name,json=portName,proto3,oneof" json:"port_name,omitempty"`
	// Specifies how port is selected for health checking, can be one of following values:
	// USE_FIXED_PORT: The port number in port is used for health checking.
	// USE_NAMED_PORT: The portName is used for health checking.
	// USE_SERVING_PORT: For NetworkEndpointGroup, the port specified for each network endpoint is used for health checking. For other backends, the port or named port specified in the Backend Service is used for health checking.
	//
	//
	// If not specified, TCP health check follows behavior specified in port and portName fields.
	PortSpecification *TCPHealthCheck_PortSpecification `protobuf:"varint,51590597,opt,name=port_specification,json=portSpecification,proto3,enum=google.cloud.compute.v1.TCPHealthCheck_PortSpecification,oneof" json:"port_specification,omitempty"`
	// Specifies the type of proxy header to append before sending data to the backend, either NONE or PROXY_V1. The default is NONE.
	ProxyHeader *TCPHealthCheck_ProxyHeader `protobuf:"varint,160374142,opt,name=proxy_header,json=proxyHeader,proto3,enum=google.cloud.compute.v1.TCPHealthCheck_ProxyHeader,oneof" json:"proxy_header,omitempty"`
	// The application data to send once the TCP connection has been established (default value is empty). If both request and response are empty, the connection establishment alone will indicate health. The request data can only be ASCII.
	Request *string `protobuf:"bytes,21951119,opt,name=request,proto3,oneof" json:"request,omitempty"`
	// The bytes to match against the beginning of the response data. If left empty (the default value), any response will indicate health. The response data can only be ASCII.
	Response *string `protobuf:"bytes,196547649,opt,name=response,proto3,oneof" json:"response,omitempty"`
}

func (x *TCPHealthCheck) Reset() {
	*x = TCPHealthCheck{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[141]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TCPHealthCheck) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TCPHealthCheck) ProtoMessage() {}

func (x *TCPHealthCheck) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[141]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TCPHealthCheck.ProtoReflect.Descriptor instead.
func (*TCPHealthCheck) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{141}
}

func (x *TCPHealthCheck) GetPort() int32 {
	if x != nil && x.Port != nil {
		return *x.Port
	}
	return 0
}

func (x *TCPHealthCheck) GetPortName() string {
	if x != nil && x.PortName != nil {
		return *x.PortName
	}
	return ""
}

func (x *TCPHealthCheck) GetPortSpecification() TCPHealthCheck_PortSpecification {
	if x != nil && x.PortSpecification != nil {
		return *x.PortSpecification
	}
	return TCPHealthCheck_UNDEFINED_PORT_SPECIFICATION
}

func (x *TCPHealthCheck) GetProxyHeader() TCPHealthCheck_ProxyHeader {
	if x != nil && x.ProxyHeader != nil {
		return *x.ProxyHeader
	}
	return TCPHealthCheck_UNDEFINED_PROXY_HEADER
}

func (x *TCPHealthCheck) GetRequest() string {
	if x != nil && x.Request != nil {
		return *x.Request
	}
	return ""
}

func (x *TCPHealthCheck) GetResponse() string {
	if x != nil && x.Response != nil {
		return *x.Response
	}
	return ""
}

// Represents a Health Check resource.
//
// Google Compute Engine has two Health Check resources:
//
// * [Global](/compute/docs/reference/rest/{$api_version}/healthChecks) * [Regional](/compute/docs/reference/rest/{$api_version}/regionHealthChecks)
//
// Internal HTTP(S) load balancers must use regional health checks (`compute.v1.regionHealthChecks`).
//
// Traffic Director must use global health checks (`compute.v1.HealthChecks`).
//
// Internal TCP/UDP load balancers can use either regional or global health checks (`compute.v1.regionHealthChecks` or `compute.v1.HealthChecks`).
//
// External HTTP(S), TCP proxy, and SSL proxy load balancers as well as managed instance group auto-healing must use global health checks (`compute.v1.HealthChecks`).
//
// Network load balancers must use legacy HTTP health checks (httpHealthChecks).
//
// For more information, see Health checks overview.
type HealthCheck struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// How often (in seconds) to send a health check. The default value is 5 seconds.
	CheckIntervalSec *int32 `protobuf:"varint,345561006,opt,name=check_interval_sec,json=checkIntervalSec,proto3,oneof" json:"check_interval_sec,omitempty"`
	// [Output Only] Creation timestamp in 3339 text format.
	CreationTimestamp *string `protobuf:"bytes,30525366,opt,name=creation_timestamp,json=creationTimestamp,proto3,oneof" json:"creation_timestamp,omitempty"`
	// An optional description of this resource. Provide this property when you create the resource.
	Description     *string          `protobuf:"bytes,422937596,opt,name=description,proto3,oneof" json:"description,omitempty"`
	GrpcHealthCheck *GRPCHealthCheck `protobuf:"bytes,85529574,opt,name=grpc_health_check,json=grpcHealthCheck,proto3,oneof" json:"grpc_health_check,omitempty"`
	// A so-far unhealthy instance will be marked healthy after this many consecutive successes. The default value is 2.
	HealthyThreshold *int32            `protobuf:"varint,403212361,opt,name=healthy_threshold,json=healthyThreshold,proto3,oneof" json:"healthy_threshold,omitempty"`
	Http2HealthCheck *HTTP2HealthCheck `protobuf:"bytes,11360986,opt,name=http2_health_check,json=http2HealthCheck,proto3,oneof" json:"http2_health_check,omitempty"`
	HttpHealthCheck  *HTTPHealthCheck  `protobuf:"bytes,412586940,opt,name=http_health_check,json=httpHealthCheck,proto3,oneof" json:"http_health_check,omitempty"`
	HttpsHealthCheck *HTTPSHealthCheck `protobuf:"bytes,436046905,opt,name=https_health_check,json=httpsHealthCheck,proto3,oneof" json:"https_health_check,omitempty"`
	// [Output Only] The unique identifier for the resource. This identifier is defined by the server.
	Id *uint64 `protobuf:"varint,3355,opt,name=id,proto3,oneof" json:"id,omitempty"`
	// Type of the resource.
	Kind *string `protobuf:"bytes,3292052,opt,name=kind,proto3,oneof" json:"kind,omitempty"`
	// Configure logging on this health check.
	LogConfig *HealthCheckLogConfig `protobuf:"bytes,351299741,opt,name=log_config,json=logConfig,proto3,oneof" json:"log_config,omitempty"`
	// Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. For example, a name that is 1-63 characters long, matches the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?`, and otherwise complies with RFC1035. This regular expression describes a name where the first character is a lowercase letter, and all following characters are a dash, lowercase letter, or digit, except the last character, which isn't a dash.
	Name *string `protobuf:"bytes,3373707,opt,name=name,proto3,oneof" json:"name,omitempty"`
	// [Output Only] Region where the health check resides. Not applicable to global health checks.
	Region *string `protobuf:"bytes,138946292,opt,name=region,proto3,oneof" json:"region,omitempty"`
	// [Output Only] Server-defined URL for the resource.
	SelfLink       *string         `protobuf:"bytes,456214797,opt,name=self_link,json=selfLink,proto3,oneof" json:"self_link,omitempty"`
	SslHealthCheck *SSLHealthCheck `protobuf:"bytes,280032440,opt,name=ssl_health_check,json=sslHealthCheck,proto3,oneof" json:"ssl_health_check,omitempty"`
	TcpHealthCheck *TCPHealthCheck `protobuf:"bytes,469980419,opt,name=tcp_health_check,json=tcpHealthCheck,proto3,oneof" json:"tcp_health_check,omitempty"`
	// How long (in seconds) to wait before claiming failure. The default value is 5 seconds. It is invalid for timeoutSec to have greater value than checkIntervalSec.
	TimeoutSec *int32 `protobuf:"varint,79994995,opt,name=timeout_sec,json=timeoutSec,proto3,oneof" json:"timeout_sec,omitempty"`
	// Specifies the type of the healthCheck, either TCP, SSL, HTTP, HTTPS or HTTP2. If not specified, the default is TCP. Exactly one of the protocol-specific health check field must be specified, which must match type field.
	Type *HealthCheck_Type `protobuf:"varint,3575610,opt,name=type,proto3,enum=google.cloud.compute.v1.HealthCheck_Type,oneof" json:"type,omitempty"`
	// A so-far healthy instance will be marked unhealthy after this many consecutive failures. The default value is 2.
	UnhealthyThreshold *int32 `protobuf:"varint,227958480,opt,name=unhealthy_threshold,json=unhealthyThreshold,proto3,oneof" json:"unhealthy_threshold,omitempty"`
}

func (x *HealthCheck) Reset() {
	*x = HealthCheck{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[142]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *HealthCheck) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HealthCheck) ProtoMessage() {}

func (x *HealthCheck) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[142]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HealthCheck.ProtoReflect.Descriptor instead.
func (*HealthCheck) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{142}
}

func (x *HealthCheck) GetCheckIntervalSec() int32 {
	if x != nil && x.CheckIntervalSec != nil {
		return *x.CheckIntervalSec
	}
	return 0
}

func (x *HealthCheck) GetCreationTimestamp() string {
	if x != nil && x.CreationTimestamp != nil {
		return *x.CreationTimestamp
	}
	return ""
}

func (x *HealthCheck) GetDescription() string {
	if x != nil && x.Description != nil {
		return *x.Description
	}
	return ""
}

func (x *HealthCheck) GetGrpcHealthCheck() *GRPCHealthCheck {
	if x != nil {
		return x.GrpcHealthCheck
	}
	return nil
}

func (x *HealthCheck) GetHealthyThreshold() int32 {
	if x != nil && x.HealthyThreshold != nil {
		return *x.HealthyThreshold
	}
	return 0
}

func (x *HealthCheck) GetHttp2HealthCheck() *HTTP2HealthCheck {
	if x != nil {
		return x.Http2HealthCheck
	}
	return nil
}

func (x *HealthCheck) GetHttpHealthCheck() *HTTPHealthCheck {
	if x != nil {
		return x.HttpHealthCheck
	}
	return nil
}

func (x *HealthCheck) GetHttpsHealthCheck() *HTTPSHealthCheck {
	if x != nil {
		return x.HttpsHealthCheck
	}
	return nil
}

func (x *HealthCheck) GetId() uint64 {
	if x != nil && x.Id != nil {
		return *x.Id
	}
	return 0
}

func (x *HealthCheck) GetKind() string {
	if x != nil && x.Kind != nil {
		return *x.Kind
	}
	return ""
}

func (x *HealthCheck) GetLogConfig() *HealthCheckLogConfig {
	if x != nil {
		return x.LogConfig
	}
	return nil
}

func (x *HealthCheck) GetName() string {
	if x != nil && x.Name != nil {
		return *x.Name
	}
	return ""
}

func (x *HealthCheck) GetRegion() string {
	if x != nil && x.Region != nil {
		return *x.Region
	}
	return ""
}

func (x *HealthCheck) GetSelfLink() string {
	if x != nil && x.SelfLink != nil {
		return *x.SelfLink
	}
	return ""
}

func (x *HealthCheck) GetSslHealthCheck() *SSLHealthCheck {
	if x != nil {
		return x.SslHealthCheck
	}
	return nil
}

func (x *HealthCheck) GetTcpHealthCheck() *TCPHealthCheck {
	if x != nil {
		return x.TcpHealthCheck
	}
	return nil
}

func (x *HealthCheck) GetTimeoutSec() int32 {
	if x != nil && x.TimeoutSec != nil {
		return *x.TimeoutSec
	}
	return 0
}

func (x *HealthCheck) GetType() HealthCheck_Type {
	if x != nil && x.Type != nil {
		return *x.Type
	}
	return HealthCheck_UNDEFINED_TYPE
}

func (x *HealthCheck) GetUnhealthyThreshold() int32 {
	if x != nil && x.UnhealthyThreshold != nil {
		return *x.UnhealthyThreshold
	}
	return 0
}

// Contains a list of HealthCheck resources.
type HealthCheckList struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// [Output Only] Unique identifier for the resource; defined by the server.
	Id *string `protobuf:"bytes,3355,opt,name=id,proto3,oneof" json:"id,omitempty"`
	// A list of HealthCheck resources.
	Items []*HealthCheck `protobuf:"bytes,100526016,rep,name=items,proto3" json:"items,omitempty"`
	// Type of resource.
	Kind *string `protobuf:"bytes,3292052,opt,name=kind,proto3,oneof" json:"kind,omitempty"`
	// [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
	NextPageToken *string `protobuf:"bytes,79797525,opt,name=next_page_token,json=nextPageToken,proto3,oneof" json:"next_page_token,omitempty"`
	// [Output Only] Server-defined URL for this resource.
	SelfLink *string `protobuf:"bytes,456214797,opt,name=self_link,json=selfLink,proto3,oneof" json:"self_link,omitempty"`
	// [Output Only] Informational warning message.
	Warning *Warning `protobuf:"bytes,50704284,opt,name=warning,proto3,oneof" json:"warning,omitempty"`
}

func (x *HealthCheckList) Reset() {
	*x = HealthCheckList{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[143]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *HealthCheckList) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HealthCheckList) ProtoMessage() {}

func (x *HealthCheckList) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[143]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HealthCheckList.ProtoReflect.Descriptor instead.
func (*HealthCheckList) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{143}
}

func (x *HealthCheckList) GetId() string {
	if x != nil && x.Id != nil {
		return *x.Id
	}
	return ""
}

func (x *HealthCheckList) GetItems() []*HealthCheck {
	if x != nil {
		return x.Items
	}
	return nil
}

func (x *HealthCheckList) GetKind() string {
	if x != nil && x.Kind != nil {
		return *x.Kind
	}
	return ""
}

func (x *HealthCheckList) GetNextPageToken() string {
	if x != nil && x.NextPageToken != nil {
		return *x.NextPageToken
	}
	return ""
}

func (x *HealthCheckList) GetSelfLink() string {
	if x != nil && x.SelfLink != nil {
		return *x.SelfLink
	}
	return ""
}

func (x *HealthCheckList) GetWarning() *Warning {
	if x != nil {
		return x.Warning
	}
	return nil
}

// A full or valid partial URL to a health check. For example, the following are valid URLs:
// - https://www.googleapis.com/compute/beta/projects/project-id/global/httpHealthChecks/health-check
// - projects/project-id/global/httpHealthChecks/health-check
// - global/httpHealthChecks/health-check
type HealthCheckReference struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	HealthCheck *string `protobuf:"bytes,308876645,opt,name=health_check,json=healthCheck,proto3,oneof" json:"health_check,omitempty"`
}

func (x *HealthCheckReference) Reset() {
	*x = HealthCheckReference{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[144]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *HealthCheckReference) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HealthCheckReference) ProtoMessage() {}

func (x *HealthCheckReference) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[144]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HealthCheckReference.ProtoReflect.Descriptor instead.
func (*HealthCheckReference) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{144}
}

func (x *HealthCheckReference) GetHealthCheck() string {
	if x != nil && x.HealthCheck != nil {
		return *x.HealthCheck
	}
	return ""
}

// Represents a Health-Check as a Service resource.
//
// (== resource_for {$api_version}.regionHealthCheckServices ==)
type HealthCheckService struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// [Output Only] Creation timestamp in RFC3339 text format.
	CreationTimestamp *string `protobuf:"bytes,30525366,opt,name=creation_timestamp,json=creationTimestamp,proto3,oneof" json:"creation_timestamp,omitempty"`
	// An optional description of this resource. Provide this property when you create the resource.
	Description *string `protobuf:"bytes,422937596,opt,name=description,proto3,oneof" json:"description,omitempty"`
	// Fingerprint of this resource. A hash of the contents stored in this object. This field is used in optimistic locking. This field will be ignored when inserting a HealthCheckService. An up-to-date fingerprint must be provided in order to patch/update the HealthCheckService; Otherwise, the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make a get() request to retrieve the HealthCheckService.
	Fingerprint *string `protobuf:"bytes,234678500,opt,name=fingerprint,proto3,oneof" json:"fingerprint,omitempty"`
	// List of URLs to the HealthCheck resources. Must have at least one HealthCheck, and not more than 10. HealthCheck resources must have portSpecification=USE_SERVING_PORT. For regional HealthCheckService, the HealthCheck must be regional and in the same region. For global HealthCheckService, HealthCheck must be global. Mix of regional and global HealthChecks is not supported. Multiple regional HealthChecks must belong to the same region. Regional HealthChecks</code? must belong to the same region as zones of NEGs.
	HealthChecks []string `protobuf:"bytes,448370606,rep,name=health_checks,json=healthChecks,proto3" json:"health_checks,omitempty"`
	// Optional. Policy for how the results from multiple health checks for the same endpoint are aggregated. Defaults to NO_AGGREGATION if unspecified.
	// - NO_AGGREGATION. An EndpointHealth message is returned for each backend in the health check service.
	// - AND. If any backend's health check reports UNHEALTHY, then UNHEALTHY is the HealthState of the entire health check service. If all backend's are healthy, the HealthState of the health check service is HEALTHY. .
	HealthStatusAggregationPolicy *HealthCheckService_HealthStatusAggregationPolicy `protobuf:"varint,253163129,opt,name=health_status_aggregation_policy,json=healthStatusAggregationPolicy,proto3,enum=google.cloud.compute.v1.HealthCheckService_HealthStatusAggregationPolicy,oneof" json:"health_status_aggregation_policy,omitempty"`
	// [Output Only] The unique identifier for the resource. This identifier is defined by the server.
	Id *uint64 `protobuf:"varint,3355,opt,name=id,proto3,oneof" json:"id,omitempty"`
	// [Output only] Type of the resource. Always compute#healthCheckServicefor health check services.
	Kind *string `protobuf:"bytes,3292052,opt,name=kind,proto3,oneof" json:"kind,omitempty"`
	// Name of the resource. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
	Name *string `protobuf:"bytes,3373707,opt,name=name,proto3,oneof" json:"name,omitempty"`
	// List of URLs to the NetworkEndpointGroup resources. Must not have more than 100. For regional HealthCheckService, NEGs must be in zones in the region of the HealthCheckService.
	NetworkEndpointGroups []string `protobuf:"bytes,29346733,rep,name=network_endpoint_groups,json=networkEndpointGroups,proto3" json:"network_endpoint_groups,omitempty"`
	// List of URLs to the NotificationEndpoint resources. Must not have more than 10. A list of endpoints for receiving notifications of change in health status. For regional HealthCheckService, NotificationEndpoint must be regional and in the same region. For global HealthCheckService, NotificationEndpoint must be global.
	NotificationEndpoints []string `protobuf:"bytes,406728490,rep,name=notification_endpoints,json=notificationEndpoints,proto3" json:"notification_endpoints,omitempty"`
	// [Output Only] URL of the region where the health check service resides. This field is not applicable to global health check services. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
	Region *string `protobuf:"bytes,138946292,opt,name=region,proto3,oneof" json:"region,omitempty"`
	// [Output Only] Server-defined URL for the resource.
	SelfLink *string `protobuf:"bytes,456214797,opt,name=self_link,json=selfLink,proto3,oneof" json:"self_link,omitempty"`
}

func (x *HealthCheckService) Reset() {
	*x = HealthCheckService{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[145]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *HealthCheckService) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HealthCheckService) ProtoMessage() {}

func (x *HealthCheckService) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[145]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HealthCheckService.ProtoReflect.Descriptor instead.
func (*HealthCheckService) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{145}
}

func (x *HealthCheckService) GetCreationTimestamp() string {
	if x != nil && x.CreationTimestamp != nil {
		return *x.CreationTimestamp
	}
	return ""
}

func (x *HealthCheckService) GetDescription() string {
	if x != nil && x.Description != nil {
		return *x.Description
	}
	return ""
}

func (x *HealthCheckService) GetFingerprint() string {
	if x != nil && x.Fingerprint != nil {
		return *x.Fingerprint
	}
	return ""
}

func (x *HealthCheckService) GetHealthChecks() []string {
	if x != nil {
		return x.HealthChecks
	}
	return nil
}

func (x *HealthCheckService) GetHealthStatusAggregationPolicy() HealthCheckService_HealthStatusAggregationPolicy {
	if x != nil && x.HealthStatusAggregationPolicy != nil {
		return *x.HealthStatusAggregationPolicy
	}
	return HealthCheckService_UNDEFINED_HEALTH_STATUS_AGGREGATION_POLICY
}

func (x *HealthCheckService) GetId() uint64 {
	if x != nil && x.Id != nil {
		return *x.Id
	}
	return 0
}

func (x *HealthCheckService) GetKind() string {
	if x != nil && x.Kind != nil {
		return *x.Kind
	}
	return ""
}

func (x *HealthCheckService) GetName() string {
	if x != nil && x.Name != nil {
		return *x.Name
	}
	return ""
}

func (x *HealthCheckService) GetNetworkEndpointGroups() []string {
	if x != nil {
		return x.NetworkEndpointGroups
	}
	return nil
}

func (x *HealthCheckService) GetNotificationEndpoints() []string {
	if x != nil {
		return x.NotificationEndpoints
	}
	return nil
}

func (x *HealthCheckService) GetRegion() string {
	if x != nil && x.Region != nil {
		return *x.Region
	}
	return ""
}

func (x *HealthCheckService) GetSelfLink() string {
	if x != nil && x.SelfLink != nil {
		return *x.SelfLink
	}
	return ""
}

// A full or valid partial URL to a health check service. For example, the following are valid URLs:
// - https://www.googleapis.com/compute/beta/projects/project-id/regions/us-west1/healthCheckServices/health-check-service
// - projects/project-id/regions/us-west1/healthCheckServices/health-check-service
// - regions/us-west1/healthCheckServices/health-check-service
type HealthCheckServiceReference struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	HealthCheckService *string `protobuf:"bytes,408374747,opt,name=health_check_service,json=healthCheckService,proto3,oneof" json:"health_check_service,omitempty"`
}

func (x *HealthCheckServiceReference) Reset() {
	*x = HealthCheckServiceReference{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[146]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *HealthCheckServiceReference) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HealthCheckServiceReference) ProtoMessage() {}

func (x *HealthCheckServiceReference) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[146]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HealthCheckServiceReference.ProtoReflect.Descriptor instead.
func (*HealthCheckServiceReference) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{146}
}

func (x *HealthCheckServiceReference) GetHealthCheckService() string {
	if x != nil && x.HealthCheckService != nil {
		return *x.HealthCheckService
	}
	return ""
}

//
type HealthCheckServicesList struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// [Output Only] Unique identifier for the resource; defined by the server.
	Id *string `protobuf:"bytes,3355,opt,name=id,proto3,oneof" json:"id,omitempty"`
	// A list of HealthCheckService resources.
	Items []*HealthCheckService `protobuf:"bytes,100526016,rep,name=items,proto3" json:"items,omitempty"`
	// [Output Only] Type of the resource. Always compute#healthCheckServicesList for lists of HealthCheckServices.
	Kind *string `protobuf:"bytes,3292052,opt,name=kind,proto3,oneof" json:"kind,omitempty"`
	// [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
	NextPageToken *string `protobuf:"bytes,79797525,opt,name=next_page_token,json=nextPageToken,proto3,oneof" json:"next_page_token,omitempty"`
	// [Output Only] Server-defined URL for this resource.
	SelfLink *string `protobuf:"bytes,456214797,opt,name=self_link,json=selfLink,proto3,oneof" json:"self_link,omitempty"`
	// [Output Only] Informational warning message.
	Warning *Warning `protobuf:"bytes,50704284,opt,name=warning,proto3,oneof" json:"warning,omitempty"`
}

func (x *HealthCheckServicesList) Reset() {
	*x = HealthCheckServicesList{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[147]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *HealthCheckServicesList) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HealthCheckServicesList) ProtoMessage() {}

func (x *HealthCheckServicesList) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[147]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HealthCheckServicesList.ProtoReflect.Descriptor instead.
func (*HealthCheckServicesList) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{147}
}

func (x *HealthCheckServicesList) GetId() string {
	if x != nil && x.Id != nil {
		return *x.Id
	}
	return ""
}

func (x *HealthCheckServicesList) GetItems() []*HealthCheckService {
	if x != nil {
		return x.Items
	}
	return nil
}

func (x *HealthCheckServicesList) GetKind() string {
	if x != nil && x.Kind != nil {
		return *x.Kind
	}
	return ""
}

func (x *HealthCheckServicesList) GetNextPageToken() string {
	if x != nil && x.NextPageToken != nil {
		return *x.NextPageToken
	}
	return ""
}

func (x *HealthCheckServicesList) GetSelfLink() string {
	if x != nil && x.SelfLink != nil {
		return *x.SelfLink
	}
	return ""
}

func (x *HealthCheckServicesList) GetWarning() *Warning {
	if x != nil {
		return x.Warning
	}
	return nil
}

//
type HealthChecksScopedList struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A list of HealthChecks contained in this scope.
	HealthChecks []*HealthCheck `protobuf:"bytes,448370606,rep,name=health_checks,json=healthChecks,proto3" json:"health_checks,omitempty"`
	// Informational warning which replaces the list of backend services when the list is empty.
	Warning *Warning `protobuf:"bytes,50704284,opt,name=warning,proto3,oneof" json:"warning,omitempty"`
}

func (x *HealthChecksScopedList) Reset() {
	*x = HealthChecksScopedList{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[148]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *HealthChecksScopedList) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HealthChecksScopedList) ProtoMessage() {}

func (x *HealthChecksScopedList) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[148]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HealthChecksScopedList.ProtoReflect.Descriptor instead.
func (*HealthChecksScopedList) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{148}
}

func (x *HealthChecksScopedList) GetHealthChecks() []*HealthCheck {
	if x != nil {
		return x.HealthChecks
	}
	return nil
}

func (x *HealthChecksScopedList) GetWarning() *Warning {
	if x != nil {
		return x.Warning
	}
	return nil
}

//
type HealthChecksAggregatedList struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// [Output Only] Unique identifier for the resource; defined by the server.
	Id *string `protobuf:"bytes,3355,opt,name=id,proto3,oneof" json:"id,omitempty"`
	// A list of HealthChecksScopedList resources.
	Items map[string]*HealthChecksScopedList `protobuf:"bytes,100526016,rep,name=items,proto3" json:"items,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Type of resource.
	Kind *string `protobuf:"bytes,3292052,opt,name=kind,proto3,oneof" json:"kind,omitempty"`
	// [Output Only] This token allows you to get the next page of results for list requests. If the number of results is larger than maxResults, use the nextPageToken as a value for the query parameter pageToken in the next list request. Subsequent list requests will have their own nextPageToken to continue paging through the results.
	NextPageToken *string `protobuf:"bytes,79797525,opt,name=next_page_token,json=nextPageToken,proto3,oneof" json:"next_page_token,omitempty"`
	// [Output Only] Server-defined URL for this resource.
	SelfLink *string `protobuf:"bytes,456214797,opt,name=self_link,json=selfLink,proto3,oneof" json:"self_link,omitempty"`
	// [Output Only] Unreachable resources.
	Unreachables []string `protobuf:"bytes,243372063,rep,name=unreachables,proto3" json:"unreachables,omitempty"`
	// [Output Only] Informational warning message.
	Warning *Warning `protobuf:"bytes,50704284,opt,name=warning,proto3,oneof" json:"warning,omitempty"`
}

func (x *HealthChecksAggregatedList) Reset() {
	*x = HealthChecksAggregatedList{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[149]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *HealthChecksAggregatedList) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HealthChecksAggregatedList) ProtoMessage() {}

func (x *HealthChecksAggregatedList) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[149]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HealthChecksAggregatedList.ProtoReflect.Descriptor instead.
func (*HealthChecksAggregatedList) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{149}
}

func (x *HealthChecksAggregatedList) GetId() string {
	if x != nil && x.Id != nil {
		return *x.Id
	}
	return ""
}

func (x *HealthChecksAggregatedList) GetItems() map[string]*HealthChecksScopedList {
	if x != nil {
		return x.Items
	}
	return nil
}

func (x *HealthChecksAggregatedList) GetKind() string {
	if x != nil && x.Kind != nil {
		return *x.Kind
	}
	return ""
}

func (x *HealthChecksAggregatedList) GetNextPageToken() string {
	if x != nil && x.NextPageToken != nil {
		return *x.NextPageToken
	}
	return ""
}

func (x *HealthChecksAggregatedList) GetSelfLink() string {
	if x != nil && x.SelfLink != nil {
		return *x.SelfLink
	}
	return ""
}

func (x *HealthChecksAggregatedList) GetUnreachables() []string {
	if x != nil {
		return x.Unreachables
	}
	return nil
}

func (x *HealthChecksAggregatedList) GetWarning() *Warning {
	if x != nil {
		return x.Warning
	}
	return nil
}

//
type HealthStatusForNetworkEndpoint struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// URL of the backend service associated with the health state of the network endpoint.
	BackendService *BackendServiceReference `protobuf:"bytes,306946058,opt,name=backend_service,json=backendService,proto3,oneof" json:"backend_service,omitempty"`
	// URL of the forwarding rule associated with the health state of the network endpoint.
	ForwardingRule *ForwardingRuleReference `protobuf:"bytes,269964030,opt,name=forwarding_rule,json=forwardingRule,proto3,oneof" json:"forwarding_rule,omitempty"`
	// URL of the health check associated with the health state of the network endpoint.
	HealthCheck *HealthCheckReference `protobuf:"bytes,308876645,opt,name=health_check,json=healthCheck,proto3,oneof" json:"health_check,omitempty"`
	// URL of the health check service associated with the health state of the network endpoint.
	HealthCheckService *HealthCheckServiceReference `protobuf:"bytes,408374747,opt,name=health_check_service,json=healthCheckService,proto3,oneof" json:"health_check_service,omitempty"`
	// Health state of the network endpoint determined based on the health checks configured.
	HealthState *HealthStatusForNetworkEndpoint_HealthState `protobuf:"varint,324007150,opt,name=health_state,json=healthState,proto3,enum=google.cloud.compute.v1.HealthStatusForNetworkEndpoint_HealthState,oneof" json:"health_state,omitempty"`
}

func (x *HealthStatusForNetworkEndpoint) Reset() {
	*x = HealthStatusForNetworkEndpoint{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[150]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *HealthStatusForNetworkEndpoint) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HealthStatusForNetworkEndpoint) ProtoMessage() {}

func (x *HealthStatusForNetworkEndpoint) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[150]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HealthStatusForNetworkEndpoint.ProtoReflect.Descriptor instead.
func (*HealthStatusForNetworkEndpoint) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{150}
}

func (x *HealthStatusForNetworkEndpoint) GetBackendService() *BackendServiceReference {
	if x != nil {
		return x.BackendService
	}
	return nil
}

func (x *HealthStatusForNetworkEndpoint) GetForwardingRule() *ForwardingRuleReference {
	if x != nil {
		return x.ForwardingRule
	}
	return nil
}

func (x *HealthStatusForNetworkEndpoint) GetHealthCheck() *HealthCheckReference {
	if x != nil {
		return x.HealthCheck
	}
	return nil
}

func (x *HealthStatusForNetworkEndpoint) GetHealthCheckService() *HealthCheckServiceReference {
	if x != nil {
		return x.HealthCheckService
	}
	return nil
}

func (x *HealthStatusForNetworkEndpoint) GetHealthState() HealthStatusForNetworkEndpoint_HealthState {
	if x != nil && x.HealthState != nil {
		return *x.HealthState
	}
	return HealthStatusForNetworkEndpoint_UNDEFINED_HEALTH_STATE
}

// UrlMaps A host-matching rule for a URL. If matched, will use the named PathMatcher to select the BackendService.
type HostRule struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// An optional description of this resource. Provide this property when you create the resource.
	Description *string `protobuf:"bytes,422937596,opt,name=description,proto3,oneof" json:"description,omitempty"`
	// The list of host patterns to match. They must be valid hostnames with optional port numbers in the format host:port. * matches any string of ([a-z0-9-.]*). In that case, * must be the first character and must be followed in the pattern by either - or ..
	// * based matching is not supported when the URL map is bound to target gRPC proxy that has validateForProxyless field set to true.
	Hosts []string `protobuf:"bytes,99467211,rep,name=hosts,proto3" json:"hosts,omitempty"`
	// The name of the PathMatcher to use to match the path portion of the URL if the hostRule matches the URL's host portion.
	PathMatcher *string `protobuf:"bytes,337813272,opt,name=path_matcher,json=pathMatcher,proto3,oneof" json:"path_matcher,omitempty"`
}

func (x *HostRule) Reset() {
	*x = HostRule{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[151]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *HostRule) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HostRule) ProtoMessage() {}

func (x *HostRule) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[151]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HostRule.ProtoReflect.Descriptor instead.
func (*HostRule) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{151}
}

func (x *HostRule) GetDescription() string {
	if x != nil && x.Description != nil {
		return *x.Description
	}
	return ""
}

func (x *HostRule) GetHosts() []string {
	if x != nil {
		return x.Hosts
	}
	return nil
}

func (x *HostRule) GetPathMatcher() string {
	if x != nil && x.PathMatcher != nil {
		return *x.PathMatcher
	}
	return ""
}

// Specification for how requests are aborted as part of fault injection.
type HttpFaultAbort struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The HTTP status code used to abort the request.
	// The value must be between 200 and 599 inclusive.
	HttpStatus *uint32 `protobuf:"varint,468949897,opt,name=http_status,json=httpStatus,proto3,oneof" json:"http_status,omitempty"`
	// The percentage of traffic (connections/operations/requests) which will be aborted as part of fault injection.
	// The value must be between 0.0 and 100.0 inclusive.
	Percentage *float64 `protobuf:"fixed64,151909018,opt,name=percentage,proto3,oneof" json:"percentage,omitempty"`
}

func (x *HttpFaultAbort) Reset() {
	*x = HttpFaultAbort{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[152]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *HttpFaultAbort) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HttpFaultAbort) ProtoMessage() {}

func (x *HttpFaultAbort) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[152]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HttpFaultAbort.ProtoReflect.Descriptor instead.
func (*HttpFaultAbort) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{152}
}

func (x *HttpFaultAbort) GetHttpStatus() uint32 {
	if x != nil && x.HttpStatus != nil {
		return *x.HttpStatus
	}
	return 0
}

func (x *HttpFaultAbort) GetPercentage() float64 {
	if x != nil && x.Percentage != nil {
		return *x.Percentage
	}
	return 0
}

// Specifies the delay introduced by Loadbalancer before forwarding the request to the backend service as part of fault injection.
type HttpFaultDelay struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Specifies the value of the fixed delay interval.
	FixedDelay *Duration `protobuf:"bytes,317037816,opt,name=fixed_delay,json=fixedDelay,proto3,oneof" json:"fixed_delay,omitempty"`
	// The percentage of traffic (connections/operations/requests) on which delay will be introduced as part of fault injection.
	// The value must be between 0.0 and 100.0 inclusive.
	Percentage *float64 `protobuf:"fixed64,151909018,opt,name=percentage,proto3,oneof" json:"percentage,omitempty"`
}

func (x *HttpFaultDelay) Reset() {
	*x = HttpFaultDelay{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[153]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *HttpFaultDelay) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HttpFaultDelay) ProtoMessage() {}

func (x *HttpFaultDelay) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[153]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HttpFaultDelay.ProtoReflect.Descriptor instead.
func (*HttpFaultDelay) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{153}
}

func (x *HttpFaultDelay) GetFixedDelay() *Duration {
	if x != nil {
		return x.FixedDelay
	}
	return nil
}

func (x *HttpFaultDelay) GetPercentage() float64 {
	if x != nil && x.Percentage != nil {
		return *x.Percentage
	}
	return 0
}

// The specification for fault injection introduced into traffic to test the resiliency of clients to backend service failure. As part of fault injection, when clients send requests to a backend service, delays can be introduced by Loadbalancer on a percentage of requests before sending those request to the backend service. Similarly requests from clients can be aborted by the Loadbalancer for a percentage of requests.
type HttpFaultInjection struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The specification for how client requests are aborted as part of fault injection.
	Abort *HttpFaultAbort `protobuf:"bytes,92611376,opt,name=abort,proto3,oneof" json:"abort,omitempty"`
	// The specification for how client requests are delayed as part of fault injection, before being sent to a backend service.
	Delay *HttpFaultDelay `protobuf:"bytes,95467907,opt,name=delay,proto3,oneof" json:"delay,omitempty"`
}

func (x *HttpFaultInjection) Reset() {
	*x = HttpFaultInjection{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[154]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *HttpFaultInjection) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HttpFaultInjection) ProtoMessage() {}

func (x *HttpFaultInjection) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[154]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HttpFaultInjection.ProtoReflect.Descriptor instead.
func (*HttpFaultInjection) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{154}
}

func (x *HttpFaultInjection) GetAbort() *HttpFaultAbort {
	if x != nil {
		return x.Abort
	}
	return nil
}

func (x *HttpFaultInjection) GetDelay() *HttpFaultDelay {
	if x != nil {
		return x.Delay
	}
	return nil
}

// Specification determining how headers are added to requests or responses.
type HttpHeaderOption struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the header.
	HeaderName *string `protobuf:"bytes,110223613,opt,name=header_name,json=headerName,proto3,oneof" json:"header_name,omitempty"`
	// The value of the header to add.
	HeaderValue *string `protobuf:"bytes,203094335,opt,name=header_value,json=headerValue,proto3,oneof" json:"header_value,omitempty"`
	// If false, headerValue is appended to any values that already exist for the header. If true, headerValue is set for the header, discarding any values that were set for that header.
	// The default value is false.
	Replace *bool `protobuf:"varint,20755124,opt,name=replace,proto3,oneof" json:"replace,omitempty"`
}

func (x *HttpHeaderOption) Reset() {
	*x = HttpHeaderOption{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[155]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *HttpHeaderOption) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HttpHeaderOption) ProtoMessage() {}

func (x *HttpHeaderOption) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_compute_v1_compute_proto_msgTypes[155]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HttpHeaderOption.ProtoReflect.Descriptor instead.
func (*HttpHeaderOption) Descriptor() ([]byte, []int) {
	return file_google_cloud_compute_v1_compute_proto_rawDescGZIP(), []int{155}
}

func (x *HttpHeaderOption) GetHeaderName() string {
	if x != nil && x.HeaderName != nil {
		return *x.HeaderName
	}
	return ""
}

func (x *HttpHeaderOption) GetHeaderValue() string {
	if x != nil && x.HeaderValue != nil {
		return *x.HeaderValue
	}
	return ""
}

func (x *HttpHeaderOption) GetReplace() bool {
	if x != nil && x.Replace != nil {
		return *x.Replace
	}
	return false
}

// The request and response header transformations that take effect before the request is passed along to the selected backendService.
type HttpHeaderAction struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Headers to add to a matching request prior to forwarding the request to the backendService.
	RequestHeadersToAdd []*HttpHeaderOption `protobuf:"bytes,72111974,rep,name=request_headers_to_add,json=requestHeadersToAdd,proto3" json:"request_headers_to_add,omitempty"`
	// A list of header names for headers that need to be removed from the request prior to forwarding the request to the backendService.
	RequestHeadersToRemove []string `protobuf:"bytes,218425247,rep,name=request_headers_to_remove,json=requestH